/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //Edit for each race
         var raceRnd=13;
         var RTL=false;
         var winnerYrs=9;//number of years for winners graph
         
         //DO NOT CHANGE
         var gn = 34872;//first circuit - do not change. All gn numbers derived from this one
         var yearNo=2017;
         var raceArr = [1637121,1637191,1637202,1637213,1637224,1637235,1637246,1637257,1637269,1637280,1637292,1637314,1637325,1637347,1637336,1637358,1637371,1637382,1637400,1637411];
         var raceID = raceArr[raceRnd];
         var gnNo = 34870;//number for live data 33835 34870
         var gpStart, raceStart, gpHr=0, raceHr=0;//Auto set timer / time of 1st practice 3 / time of race 7
         $(".continents").css({"-webkit-border-radius":"50%","-khtml-border-radius":"50%","-moz-border-radius":"50%","border-radius":"50%",
         "-webkit-mask-image": "-webkit-gradient(linear, left top, right top, color-stop(0, rgba(0,0,0,1)), color-stop(1, rgba(0,0,0,1)))"});
         var latlong=[[-38,145],[31,121],[26,50],[44,40],[41,2],[44,7],[46,-74],[40,50],[52,15],[52,1],[52,19],[50,6],[50,6],[46,9],[1,104],[3,102],[35,137],[29,-95],[19,-99],[-24,-47],[24,55]];
         var x=latlong[raceRnd][1]; var y=latlong[raceRnd][0];
         var stageWidth, mob=0, mobOpen=false, inPlay=false;
         var gpMonth=  [2,3,3,3,4,4,5,5,6,6,6,7,8,8,8,9,9,9,10,10];//start month
         var raceMonth=[2,3,3,3,4,4,5,5,6,6,6,7,8,8,9,9,9,9,10,10];//month of race
         var gpDay=[24,7,14,28,12,25,9,23,7,14,28,25,1,15,29,6,20,27,10,24];//start day
         var raceDay=[26,9,16,30,14,28,11,25,9,16,30,27,3,17,1,8,22,29,12,26];//day of race
         //COLOURS
         var grey  = {"background-color":"rgba(157,174,182,1.00)"}, red = {"background-color":"rgba(218,0,0,1)"}, black  = {"background-color":"rgba(0,0,0,1)"}, white  = {"background-color":"rgba(255,255,255,1)"};
         sym.getSymbol("styleHead").$("number").html(raceRnd+1);
         sym.getSymbol("styleHead").$("flag").attr('src','images/flag'+(raceRnd+1)+'.jpg');
         //FILL IN TEXT
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var counterTxt = sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"pointer-events":"none","top":"-2px","box-shadow":"0px 0px 10px 10px rgba(255,255,255,0.2)","padding":"2px 4px","border-radius":"2px","border":"solid 1px rgb(255,255,255)","text-align":"left"});
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	//CREATE ARRAYS FOR TEXT ELEMENTS
         	//KEY START
         		var keyTxt=[], menuIcon=[], capsTxt=[], liveTxt=[], resTxt=[], cornerTxt=[], menuIconArr =[], keyArr=[], menuTxtArr=[], capsArr=[], txtArr=[], resArr=[];
         		keyTxt[0]=sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("key0").css("pointer-events","none");
         		keyTxt[1]=sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("key1").css("pointer-events","none");
         		keyTxt[2]=sym.getSymbol("circuitOverlay").$("key2").css("pointer-events","none");
         		keyTxt[3]=sym.getSymbol("circuitOverlay").$("key3").css("pointer-events","none");
         		keyTxt[4]=sym.getSymbol("circuitOverlay").$("key4").css("pointer-events","none");
         
         	//MENU START
         	for (var m=0;m<4;m++){
         		menuIcon[m]=sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+m);
         	}
         	var menuTxt=sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	//CAPTIONS START
         		capsTxt[0]=sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         		capsTxt[1] = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         		capsTxt[2] = sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("distance").css("pointer-events","none");
         		capsTxt[3] = sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("lap").css("pointer-events","none");
         		capsTxt[4] = sym.getSymbol("circuitMc").$("gpTxt").css("pointer-events","none");
         		capsTxt[5] = sym.getSymbol("circuitMc").$("pit").css("pointer-events","none");
         		capsTxt[6] = sym.getSymbol("circuitOverlayTop").getSymbol("recent").$("lastyear").css({"pointer-events":"none","line-height":"18px"});
         
         	//CAPTIONS - LIVE
         	liveTxt[0] = sym.getSymbol("liveMc").getSymbol("latestMc").$("txt0").css("pointer-events","none"); //laps
         	liveTxt[1] = sym.getSymbol("liveMc").getSymbol("latestMc").$("txt2").css("pointer-events","none"); //time
         	liveTxt[2] = sym.getSymbol("liveMc").getSymbol("latestMc").$("txt1").css("pointer-events","none"); //weather
         	liveTxt[3] = sym.getSymbol("liveMc").getSymbol("latestMc").getSymbol("pitstop").$("txt").css("pointer-events","none"); //pitstop
         	liveTxt[4] = sym.getSymbol("liveMc").getSymbol("timingMc").$("txt4").css("pointer-events","none"); //time
         	liveTxt[5] = sym.getSymbol("liveMc").getSymbol("latestMc").$("driverTxt").css("pointer-events","none");
         	liveTxt[6] = sym.getSymbol("liveMc").getSymbol("latestMc").$("teamTxt").css("pointer-events","none");
         	liveTxt[7] = sym.getSymbol("liveMc").getSymbol("timingMc").$("driverTxt").css("pointer-events","none");
         	liveTxt[8] = sym.getSymbol("liveMc").getSymbol("timingMc").$("teamTxt").css("pointer-events","none");
         	liveTxt[9] = sym.getSymbol("liveMc").getSymbol("latestMc").$("txt3").css("pointer-events","none"); //race session
         	liveTxt[10] = sym.getSymbol("liveMc").getSymbol("timingMc").$("txt5").css("pointer-events","none"); //race session
         	liveTxt[11] = sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("gridTxt").css("pointer-events","none"); //grid text on phase button
         	//CAPTIONS - RESULTS
         	for (var n=0;n<6;n++){
         		resTxt[n] = sym.getSymbol("resultsMc").$("resultTxt"+n).css("pointer-events","none");//results
         	}
         	//CORNERS START
         	var corners, stat, statCap, headline, headlinemob, standmob, graphcolor;
         
         function numOrdA(a, b){ return (a-b); }//sort numbers ascending
         function numOrdD(a, b){ return (b-a); }//sort numbers descending
         
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         		type: "GET",
         		url: "GN35763.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headline = $(xml).find('headline').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			standmob = $(xml).find('standmob').text();
         			graphcolor=$(xml).find('graphcolor').text();
         			headlinetxt.html(headline);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0;i<5;i++){
         					keyArr[i]=$(xml).find('key'+i).text();
         					keyTxt[i].html(keyArr[i]);
         				}
         			for (var i=0; i<12; i++){
         					txtArr[i]=$(xml).find('txt'+i).text();
         				}
         			for (var l=0; l<5; l++){
         				liveTxt[l].html(txtArr[l]);
         			}	
         			var statCapString=$(xml).find('statusCap').text();
         				statCap= statCapString.split(";");
         			statCapString=$(xml).find('statusCap0').text();
         				statCap0= statCapString.split(";")
         			for (var m=0; m<menuIcon.length; m++){
         				menuTxtArr[m]=$(xml).find('menuTxt'+m).text();	
         			//	menuTxt[m].html(menuTxtArr[m]);
         			}
         			menuTxt.html(menuTxtArr[0]);
         			for (var i=0; i<3; i++){
         				sym.getSymbol("liveMc").getSymbol("phaseBtn"+i).$("txt").html(statCap[i]);
         			}
         			for (var c=0; c<capsTxt.length; c++){
         				capsArr[c] = $(xml).find('cap'+c).text();
         				capsTxt[c].html(capsArr[c]);
         			}
         			for (var r=0; r<5; r++){
         				resArr[r]=$(xml).find('results'+r).text();
         				resTxt[r].html(resArr[r]);
         			}
         			$(xml).find("previous").each(function(){
         				var $previous = $(this);
         				var pcat = $previous.find('cat').text();
         				var pname=$previous.find('name').text();
         				var pteam=$previous.find('team').text();
         				var ptime=$previous.find('time').text();
         				var prevHtml="<div class='prevrow'><div class='cat'>"+pcat+"</div><div class='name'>"+pname+"</div><div class='team'>"+pteam+"</div><div class='time'>"+ptime+"</div></div>";
         				sym.getSymbol("circuitOverlayTop").getSymbol("recent").$("previous").append(prevHtml);
         			});
         			$(".prev").css({"font-family":"Helvetica, Arial, sans-serif","font-size":"12px","width":"85%","line-height":"14px","color":"rgb(140,140,140)"})
         			$(".prevrow").css({"width":"100%","display":"table","height":"17px","border-bottom":"groove 1px rgb(200,200,200)","background-color":"rgba(255,255,255,1.0)"})
         			capsTxt[6].css({"text-align":"center","font-weight":700,"color":"rgb(255,255,255)","width":"15%"});//lastyear
         			$(".cat").css({"width":"17.5%","display":"table-cell","padding-left":"3px"});
         			$(".name").css({"width":"35%","display":"table-cell","font-weight":700});
         			$(".team").css({"width":"32.5%","display":"table-cell","font-style":"oblique"});
         			$(".time").css({"width":"25%","display":"table-cell","font-weight":700,"text-align":"right","padding-right":"3px"});
         			sym.getSymbol("circuitOverlayTop").$("recent").css({"right":"-85%","left":"auto","border-left":"solid 1px white","border-bottom":"solid 1px white","border-top":"solid 1px white","border-radius":"5px 0 0 5px"});
         			var cornerString=$(xml).find('corners').text();
         					corners= cornerString.split(";");
         					for (var i=0;i<corners.length;i++){
         					sym.getSymbol("circuitMc").$("corner"+i).html(corners[i]);
         					sym.getSymbol("circuitMc").$("corner"+i).css("pointer-events","none");
         					}
         			var statusString=$(xml).find('status').text();
         					stat= statusString.split(";");
         					liveTxt[11].html(statCap[5]);
         			var winners = $(xml).find('winners').text();
         			sym.getSymbol("winnersMc").$("winnerTxt0").html(winners);
         			sym.getSymbol("winnersMc").$("winnerTxt1").html(txtArr[7]);
         			var timeMs=[];var unSorted=[]; var driverArr=[]; var teamArr=[]; var timeArr=[]; var yearArr=[];
         			for (var n=0;n<winnerYrs;n++){		//get details for each year
                  				$(xml).find("winner"+n).each(function(){
                  					var $winner = $(this);
                  					driverArr[n]=$winner.find('name').text();
                  					teamArr[n]=$winner.find('team').text();
                  					timeArr[n]=$winner.find('time').text();	
                  					yearArr[n]=$winner.attr('year');			
                  				});
         				timeMs[n]=	parseFloat(timeArr[n]);
         				unSorted.push(timeMs[n]);//store speeds in an unsorted array
         				var winnerTable ="<div class='winners'>";
         				winnerTable += "<div id='winner"+n+"' class='winnerbar'>";
         				winnerTable += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				winnerTable +="<td class='wyear' id='wyear"+n+"'></td>";
         				winnerTable +="<td class='wdriver' id='wdriver"+n+"'></td>";
         				winnerTable +="<td class='wteam' id='wteam"+n+"'></td>";
         				winnerTable +="<td class='wtime' id='wtime"+n+"'></td>";
         				winnerTable +="</tr></table>";
         				winnerTable +="</div>";
         				winnerTable +="</div>";
         				sym.getSymbol("winnersMc").$("graph").append(winnerTable);
         				$('#wyear' + n).text(yearArr[n]);
         				$('#wdriver' + n).text(driverArr[n]);
         				$('#wteam' + n).text(teamArr[n]);
         				$('#wtime' + n).text(timeArr[n]);
         			}
         			var sorted=timeMs.sort( numOrdD );	
         			for (n=0;n<timeMs.length;n++){	
         				var x=timeMs.indexOf(unSorted[n]);
         				if(x==0){
         				scaleWinner=100;
         				}else if(x==timeMs.length-1){
         				scaleWinner=65;
         				}else{
         				scaleWinner=100-((timeMs[x]-timeMs[0])*35/(timeMs[timeMs.length-1]-timeMs[0]));
         				}
         				$("#winner"+n).css({'width':scaleWinner+'%'});
         			}
         			$(".winnerbar").css({'height':'21px','background-color':graphcolor,'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$(".winners").css({'font-size':'13px', 'line-height':'18px','font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         			$(".wyear").css({'width':'35px','font-weight':700,'padding-left':'3px'});
         			$(".wdriver").css({'width':'140px'});
         			$(".wteam").css({'width':'70px','font-style':'italic'});
         			$(".wtime").css({'text-align':'right','padding-right':'5px'});
         			$(".textSize").css({'font-size':fontSize});
         		},
            complete:function(){
         		initSize();
            }
         }); // END XML
         
         //SPIN THE GLOBE
         function spinGlobe(x){
         		var lat=-590-(x*100/72);//-610=Greenwich 594
         		var latBack=-420+(x*100/72);
         		sym.getSymbol("intro").getSymbol("globe").getSymbol("continents").$("mapFront").stop().animate ({left:lat}, 800, 'easeOutCubic');
         		sym.getSymbol("intro").getSymbol("globe").getSymbol("continents").$("mapBack").stop().animate ({left:latBack}, 800, 'easeOutCubic', function(){sym.getSymbol("intro").play(0);});
         }
         spinGlobe(x);
         sym.lat = function() {
              // var s =Math.round(230-(Math.sin(y*Math.PI*0.95/180)*206));//230=equator, 206=radius of globe
               var s =Math.round(230-(Math.sin(y*Math.PI*0.75/180)*206));//230=equator, 206=radius of globe
         		sym.getSymbol("intro").$("logoMc").animate({'top':s},200, 'easeOutCubic');
         }
         // STOP ELEMENTS INTERACTING WITH MOUSE
         	sym.$("handMc").css("pointer-events","none");
         sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").fadeOut(0);
         
         // MENU BUTTONS --------------------------------------------	
         var menuClicked = 0;
         menuArray = []; //the array that will hold references to the buttons.
         for (var h = 0; h < menuIcon.length; h++){
         		var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
         		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
         		menuArray.push(menuBtnSymbols); //push it into the array
         	}
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
         		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
         		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
         		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
         })
         sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").off("touchstart click");
         sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn2").off("touchstart click");
         function resetmenu(){
         		for (var h=0; h<menuIcon.length; h++){
         			sym.getSymbol("styleHead").getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);//new		
         			for (var i=0;i<3;i++){
         				sym.getSymbol('liveMc').getSymbol('phaseBtn'+i).$('bg').css({'background-color':'rgba(157,174,182,1.00)'});//rgb(182,175,157)
         				sym.getSymbol('liveMc').getSymbol('phaseBtn'+i).$('txt').css({'font-weight':400, 'color':'rgb(255,255,255)'});
         				sym.getSymbol("liveMc").getSymbol("phaseBtn"+i).$("top").fadeIn(0);
         				sym.getSymbol("liveMc").getSymbol("phaseBtn"+i).$("top").css({"cursor":"pointer"});
         			}		
         		}
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         }
         resetmenu();
         var playTime;
         function menuBtnClick (e){
         		e.preventDefault(); e.stopPropagation();
         		resetmenu(); //set them all back to normal state
         		clearTimeout(playTime);//stop circuit playing at start
         		sym.$("intro").stop().fadeOut(300);
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		menuClicked = menuMenu_id;
         		var menuPhaseLive= (e.data.phaseLive);
         		var sessLive=(e.data.sessionLive);
         		var numPhases;
         		sym.getSymbol("styleHead").getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuClicked).$("bg").css(red);
         		sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuTxt").html(menuTxtArr[menuClicked]);
         		for (var i=0;i<mcArr.length; i++){
         			if (i==menuMenu_id){
         				sym.$(mcArr[i]).fadeIn(1000);
         				fadeOutCircuit();
         				showMc=menuMenu_id;
         				if (menuMenu_id==0) {
         					fadeInCircuit();
         				}else if (menuMenu_id==1) {
         					if (mob==0){sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").delay(500).fadeIn(1000);}
         					sym.getSymbol('liveMc').getSymbol('phaseBtn'+menuPhaseLive).$('bg').css({'background-color':'rgb(255,255,255)'});
         					sym.getSymbol('liveMc').getSymbol('phaseBtn'+menuPhaseLive).$('txt').css({'font-weight':700, 'color':'rgb(0,0,0)'});
         					sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).$("top").fadeOut(0);
         					sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).$("top").css({"cursor":"auto"});
         					sym.getSymbol("liveMc").$("timingMc"). fadeOut(0);
         					sym.getSymbol("liveMc").$("latestMc"). fadeIn(0);
         					sym.getSymbol("liveMc").$("gridMc"). fadeOut(0);
         					if(menuPhaseLive==2){
         						numPhases=2;
         						if(sessLive==0){
         							sym.getSymbol("liveMc").$("latestMc"). fadeOut(0);
         							sym.getSymbol("liveMc").$("gridMc"). fadeIn(0);
         						}
         					}else{
         						numPhases=3;
         					}
         					for (n=0;n<numPhases;n++){	
         						if (menuPhaseLive<2){
         							nos=n+1;
         						}else{
         							nos=n;
         						}
         						if (nos==sessLive){
         							sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).getSymbol(phaseArray[menuPhaseLive]+nos).$("live").css({"background-color":"rgb(119,192,61)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(76,129,0) rgb(119,192,61) rgb(119,192,61) rgb(76,129,0)"});
         							sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).getSymbol(phaseArray[menuPhaseLive]+nos).$("fin").css({"background-color":"rgb(220,0,0)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(134,20,0) rgb(255,180,150) rgb(255,180,150) rgb(134,20,0)"});							
         						}else{
         							sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).getSymbol(phaseArray[menuPhaseLive]+nos).$("live").css({"background-color":"rgb(119,192,61)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(119,192,61) rgb(76,129,0) rgb(76,129,0) rgb(119,192,61)"});
         							sym.getSymbol("liveMc").getSymbol("phaseBtn"+menuPhaseLive).getSymbol(phaseArray[menuPhaseLive]+nos).$("fin").css({"background-color":"rgb(220,0,0)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",																																				"border-color":"rgb(255,180,150) rgb(134,20,0) rgb(134,20,0) rgb(255,180,150)"});
         						}																																												
         					}
         				}else{
         					if (menuMenu_id==2){
         						for (m=0; m<10; m++){
         							var carMove=(nRaceDrivers>20)?353-(m*440/nRaceDrivers):353-(m*22);
         							sym.getSymbol("resultsMc").$("car"+m).animate({'bottom':carMove}, 1000);
         						}
         					}
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").fadeOut(1000);
         				}
         			}else{
         				sym.$(mcArr[i]).fadeOut(1000);
         			}
         		}
         		sym.getSymbol("circuitOverlay").$("status").fadeOut(0);
         }
         
         function menuShow (e){
         		var menuMenu_id = (e.data.menuId); //get the id of the over button
         		sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuTxt").html(menuTxtArr[menuMenu_id]);
         		//sym.getSymbol("circuitOverlay").$("status").fadeOut(0);
         }
         function menuHide (e){
         		var menuMenu_id = (e.data.menuId); //get the id of the out button
         		sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuTxt").html(menuTxtArr[menuClicked]);
         }
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.getSymbol("styleHead").$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	stageWidth=sym.$("Stage").width();
         	var noOfBtns=4, btnWidth=40, btnHeight=40;//change as necessary
         	var menuTxtMove=(mob<1)?(noOfBtns*btnWidth)+5:btnWidth+5	
         	var leftright=	(RTL==false)?(menuTxt.css({"text-align":"right", "right":menuTxtMove+"px"}),"'right','0px'"):
         	(menuTxt.css({"text-align":"left", "left":menuTxtMove+"px"}),"'left','0px'");
         	sym.getSymbol("styleHead").$("menuBtnsMc").css(leftright);
         	switch(mob){
         		case (0)://hide
         			sym.getSymbol("styleHead").$("menuBtnMob").stop().animate({top:-1*btnHeight}, 0);
         			for (var s=0; s<noOfBtns; s++){ 
         				RTL==false?sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, right:((noOfBtns-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic'):
         				sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, left:((noOfBtns-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic');
         				}
         		break;
         		case (1)://closed
         			sym.getSymbol("styleHead").$("menuBtnMob").stop().animate({top:2}, 0);
         			mobOpen = false;
         			for (var s=0; s<noOfBtns; s++){ 
         				RTL==false?sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, right:0}, 200, 'easeOutCubic'):
         				sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, left:0}, 200, 'easeOutCubic')
         				}
         		break;
         		case (2)://open
         			sym.getSymbol("styleHead").$("menuBtnMob").stop().animate({top:2}, 0);
         			mobOpen = true;
         			for (var s=0; s<noOfBtns; s++){ 
         			RTL==false?sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':(s+1)*btnHeight, right:0}, 200, 'easeOutCubic'):
         			sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':(s+1)*btnHeight, left:0}, 200, 'easeOutCubic');
         			}
         		break;
         	}
         }
         
         
         //RECENT RESULTS
         var inOut=0
         sym.getSymbol("circuitOverlayTop").$("recent").css({'cursor':'pointer'});
         sym.getSymbol("circuitOverlayTop").$("recent").on('click', function(){
         	if(inOut==0){
         	sym.getSymbol("circuitOverlayTop").$("recent").stop().animate({'right':'0%'},400,'easeOutCubic');
         	inOut=1;
         	}else{
         	sym.getSymbol("circuitOverlayTop").$("recent").stop().animate({'right':'-85%'},400,'easeOutCubic');	
         	inOut=0;
         	}
         });
         
         sym.fadeIt = function(){
         	sym.$("intro").fadeOut(300);
         }
         
         //SHOW SESSION BUTTON LABELS
         var sessNo=["-","I","II","III"];
         for (var i=0;i<3;i++){
         	sym.getSymbol("liveMc").getSymbol("phaseBtn0").getSymbol("FP"+(i+1)).$("phaseTxt").html(sessNo[i+1]);
         	sym.getSymbol("liveMc").getSymbol("phaseBtn1").getSymbol("Q"+(i+1)).$("phaseTxt").html(sessNo[i+1]);
         	sym.getSymbol("liveMc").getSymbol("phaseBtn"+i).$("top").css({"cursor":"pointer"});
         }
         for (var r=0;r<2;r++){
         sym.getSymbol("liveMc").getSymbol("phaseBtn2").getSymbol("R"+(r)).$("phaseTxt").html(sessNo[r]);
         }
         //STATUS COUNTDOWN - TIME
         var counter, diff=0, timeAdjust;
         var todayDate = new Date();
         var gpDate= Date.UTC(yearNo,gpMonth[raceRnd],gpDay[raceRnd],gpHr,00,00);
         var raceDate= Date.UTC(yearNo,raceMonth[raceRnd],raceDay[raceRnd],raceHr,00,00);
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var gmtEnd = Date.parse("March 25, 2017, 00:59 UTC");
         var gmtStart = Date.parse("October 29, 2017, 01:59 UTC");
         function parsedDate(thisDateStr){
                  	var sessionDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                  	var dDate = parseInt(sessionDate,10)+localOffset+timeAdjust;
                  	return dDate;
                  }
         function countDown(){
         	todayDate = new Date();
         	var raceTime=(raceStart)?(raceDate>raceStart)?raceDate:raceStart:raceDate;
         	var timeShift=(todayDate<gmtStart&&raceTime>gmtStart)?-1:(todayDate<gmtEnd&&raceTime>gmtEnd)?1:0;
         	timeShift=3600000*timeShift;
         	diff = raceTime-todayDate+timeShift;
         	var days = Math.floor(diff/86400000);
         	var hours = Math.floor((diff%86400000)/3600000);
         	var mins = Math.floor((diff%86400000)%3600000/60000);
         	var secs = Math.floor((diff%86400000)%3600000%60000/1000);
         	var dd = leadingZero(days).toString();
         	var hh = leadingZero(hours).toString();
         	var mm = leadingZero(mins).toString();
         	var ss = leadingZero(secs).toString();
         	var gpTime=(gpStart)?(gpDate>gpStart)?gpDate:gpStart:gpDate;
         if(todayDate<gpTime){
         		var gpdiff = gpTime-todayDate;
         		var gpdays = Math.floor(gpdiff/86400000);
         		counterTxt.html(statCap[3]+": "+days+" "+stat[0]+" "+hh+":"+mm+":"+ss);
         	}
         }
         function leadingZero(time) {
             return (time < 10) ? "0" + time : time;
         }
         counter=setInterval(countDown,1000);
         // PHASE BUTTONS
         var phArr=["F","Q","R"];
         var phaseArray = ["FP","Q","R"];
         //*********************************************************
         function pieChart(data1,data2,data3,placeholder){
         var width = 90;
         var height = 90;
         var svg = d3.select(placeholder).append("svg")
           .attr("height", height).attr("width", width);
         var g = svg.append('g')
           .attr('transform', 'translate(' + width / 2 + ',' + height / 2 + ')')
           .style('-webkit-transform', 'translate('+width/2+'px,'+height/2+'px)');
         var color = d3.scale.ordinal().range(["#ff0000","#edbdbd","#e6e1d7","#f0f0f0"]);
         var min = Math.min(width, height);
         var oRadius = min / 2;
         var iRadius = min / 2 * 0.88;
         // construct default pie layout
         var pie = d3.layout.pie().value(function(d){ return d; }).sort(null);
         // construct arc generator
         var arc = d3.svg.arc()
           .outerRadius(oRadius)
           .innerRadius(iRadius);
         var dataSet = [ data1,data2,data3];
         // enter data and draw pie chart
         var path = g.datum(dataSet).selectAll("path")
           .data(pie)
           .enter().append("path")
             .attr("class","piechart")
             .attr("fill", function(d,i){ return color(i); })
             .attr("d", arc)
           .each(function(d){ this._current = d; })
         }
         //*******************************************************
         //LIVE DATA
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://data.graphicnews.com/")+ "infostradasports/api.php";
         var raceData, timer, barHeight, order, raceFinished=0, firstPhase, phase, resultCar, scaleresult, minTime, scale, nRaceDrivers, points, raceStage, phaseNo, showMc=0;
         var gridClicker = function(phaseNo){ //to handle lexical scope
         							return function (e) {
         							getGrid(phaseNo);
         							sym.getSymbol('liveMc').getSymbol('phaseBtn0').$('bg').css({'background-color':'rgba(157,174,182,1.00)'});
         							sym.getSymbol('liveMc').getSymbol('phaseBtn1').$('bg').css({'background-color':'rgba(157,174,182,1.00)'});//rgb(182,175,157)
         							sym.getSymbol('liveMc').getSymbol('phaseBtn2').$('bg').css({'background-color':'rgb(255,255,255)'});
         					for (n=0;n<2;n++){	
         							if (n==0){
         								sym.getSymbol("liveMc").getSymbol('phaseBtn2').getSymbol(phaseArray[2]+(n)).$("live").css({"background-color":"rgb(119,192,61)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(76,129,0) rgb(119,192,61) rgb(119,192,61) rgb(76,129,0)"});
         								sym.getSymbol("liveMc").getSymbol('phaseBtn2').getSymbol(phaseArray[2]+(n)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(134,20,0) rgb(255,180,150) rgb(255,180,150) rgb(134,20,0)"});							
         								}else{
         								sym.getSymbol("liveMc").getSymbol('phaseBtn2').getSymbol(phaseArray[2]+(n)).$("live").css({"background-color":"rgb(119,192,61)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(119,192,61) rgb(76,129,0) rgb(76,129,0) rgb(119,192,61)"});
         								sym.getSymbol("liveMc").getSymbol('phaseBtn2').getSymbol(phaseArray[2]+(n)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																					"border-style":"solid",
         																																					"border-width": "2px",
         																																					"border-color":"rgb(255,180,150) rgb(134,20,0) rgb(134,20,0) rgb(255,180,150)"});
         								}					
         						}					
         							sym.getSymbol("liveMc").$("gridMc"). fadeIn(1000);
         							sym.getSymbol("liveMc").$("timingMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("latestMc"). fadeOut(1000);
         								e.preventDefault();
         								e.stopPropagation();
         							};
         						};
         var showPhase = function(phaseNo,stage,session){
         				return function(e){
         				getPhases(phaseNo);
         				var ps = stage.substr(0,1);
         				var nos;
         				for (var i=0;i<3; i++){
         						var button="phaseBtn"+i;
         						if(i==2){
         							var numPhases=2;
         						}else{
         							var numPhases=3;
         						}				
         					if (ps==phArr[i]){
         						sym.getSymbol("liveMc").getSymbol(button).$("top").fadeOut(0);
         						sym.getSymbol('liveMc').getSymbol(button).$('bg').css({'background-color':'rgb(255,255,255)'});
         						sym.getSymbol('liveMc').getSymbol(button).$('txt').css({'font-weight':700, 'color':'rgb(0,0,0)'});
         						sym.getSymbol("liveMc").getSymbol(button).$("top").css({"cursor":"auto"});
         						liveTxt[10].html(statCap[4] + " "+ sessNo[session]);
         						for (n=0;n<numPhases;n++){	
         							if (i<2){
         							nos=n+1;
         							}else{
         							nos=n;
         							}
         							if (nos==session){
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(119,192,61)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(76,129,0) rgb(119,192,61) rgb(119,192,61) rgb(76,129,0)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(134,20,0) rgb(255,180,150) rgb(255,180,150) rgb(134,20,0)"});							
         							}else{
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(119,192,61)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(119,192,61) rgb(76,129,0) rgb(76,129,0) rgb(119,192,61)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(255,180,150) rgb(134,20,0) rgb(134,20,0) rgb(255,180,150)"});
         							}																														
         						}
         						//Show starting grid caption in phasebtn
         				}else{
         						sym.getSymbol("liveMc").getSymbol(button).$("top").fadeIn(0);
         						sym.getSymbol('liveMc').getSymbol(button).$('bg').css({'background-color':'rgba(157,174,182,1.00)'});//rgb(182,175,157)
         						sym.getSymbol('liveMc').getSymbol(button).$('txt').css({'font-weight':400, 'color':'rgb(255,255,255)'});
         						sym.getSymbol("liveMc").getSymbol(button).$("top").css({"cursor":"pointer"});
         						for (n=0;n<numPhases;n++){	
         							if (i<2){
         							nos=n+1;
         							}else{
         							nos=n;
         							}
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(40,142,86)","border":"solid 2px rgba(157,174,182,1.00)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(216,89,80)","border":"solid 2px rgba(157,174,182,1.00)"});
         						}
         				}
         			}					
         			sym.getSymbol("liveMc").$("gridMc"). fadeOut(1000);
         			sym.getSymbol("liveMc").$("timingMc"). fadeIn(1000);
         			sym.getSymbol("liveMc").$("latestMc"). fadeOut(1000);
         showMc=1;
         			e.preventDefault();
         			e.stopPropagation();
         		}
         }
         var showLive = function(phaseNo,stage){
         				return function(e){
         				var ps = stage.substr(0,1);
         				var session=stage.substr(-1);
         				var nos;
         				for (var i=0;i<3; i++){
         						var button="phaseBtn"+i;
         						if(i==2){
         							var numPhases=2;
         						}else{
         							var numPhases=3;
         						}
         						if (ps==phArr[i]){
         						sym.getSymbol("liveMc").getSymbol(button).$("top").fadeOut(0);
         						sym.getSymbol('liveMc').getSymbol(button).$('bg').css({'background-color':'rgb(255,255,255)'});
         						sym.getSymbol('liveMc').getSymbol(button).$('txt').css({'font-weight':700, 'color':'rgb(0,0,0)'});
         						sym.getSymbol("liveMc").getSymbol(button).$("top").css({"cursor":"auto"});
         						if(ps=="R"){
         							if(stage.substr(1,1)==1){	//if its the race
         							sym.getSymbol("liveMc").$("gridMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("timingMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("latestMc"). fadeIn(1000);
         							}else{ 							//if its starting grid
         							sym.getSymbol("liveMc").$("gridMc"). fadeIn(1000);
         							sym.getSymbol("liveMc").$("timingMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("latestMc"). fadeOut(1000);					
         							}
         						}else{
         							sym.getSymbol("liveMc").$("gridMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("timingMc"). fadeOut(1000);
         							sym.getSymbol("liveMc").$("latestMc"). fadeIn(1000);
         						}
         						for (n=0;n<numPhases;n++){	
         							if (i<2){
         							nos=n+1;
         							}else{
         							nos=n;
         							}
         						if (nos==session){
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(119,192,61)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(76,129,0) rgb(119,192,61) rgb(119,192,61) rgb(76,129,0)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(134,20,0) rgb(255,180,150) rgb(255,180,150) rgb(134,20,0)"});							
         							}else{
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(119,192,61)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(119,192,61) rgb(76,129,0) rgb(76,129,0) rgb(119,192,61)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(220,0,0)",
         																																				"border-style":"solid",
         																																				"border-width": "2px",
         																																				"border-color":"rgb(255,180,150) rgb(134,20,0) rgb(134,20,0) rgb(255,180,150)"});
         							}					
         						}
         					}else{
         						sym.getSymbol("liveMc").getSymbol(button).$("top").fadeIn(0);
         						sym.getSymbol('liveMc').getSymbol(button).$('bg').css({'background-color':'rgba(157,174,182,1.00)'});
         						sym.getSymbol('liveMc').getSymbol(button).$('txt').css({'font-weight':400, 'color':'rgb(255,255,255)'});
         						sym.getSymbol("liveMc").getSymbol(button).$("top").css({"cursor":"pointer"});
         						for (n=0;n<numPhases;n++){	
         							if (i<2){
         							nos=n+1;
         							}else{
         							nos=n;
         							}
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("live").css({"background-color":"rgb(40,142,86)","border":"solid 2px rgba(157,174,182,1.00)"});
         							sym.getSymbol("liveMc").getSymbol(button).getSymbol(phaseArray[i]+(nos)).$("fin").css({"background-color":"rgb(216,89,80)","border":"solid 2px rgba(157,174,182,1.00)"}); 
         						}
         					}
         				}
         				showMc=1;										
         				e.preventDefault();
         				e.stopPropagation();
         				}
         }
         function showFinished(latest){//Elements if race finished
         							sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn2").on("touchstart click", {menuId:2}, menuBtnClick); //enable third menu button
         							sym.getSymbol("styleHead").$("menuTxt").html(menuTxtArr[2]);
         							sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("txt").html(statCap[3]);//Change phaseBtn text to Race
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("pitstop").fadeIn(0);
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("txt0").fadeIn(0);	
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").fadeIn(0);
         							sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"background-color":"rgb(220,0,0)"});
         							sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").html(latest+" "+txtArr[6].toLowerCase());
         							getStandings(); //get latest standings 
         							clearInterval(raceInterval);
         							raceInterval=setInterval(getRace,600000);
         							raceFinished=1;
         }
         function sessLiveOrFin(latest){//Elements to show if live or finished
         						sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").html(latest);
         }
         //GET race weekend data
         function getRace(){
         	sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").off("click touchstart");
         	sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn2").off("click touchstart");
         	$.ajax({ type: "GET", 
         				url: dataURL,
                     data: "gn="+gnNo+"&yr="+yearNo+"&q=race&race="+raceID,
                     contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                     async: true,
                     crossDomain: true,
                     success: function (data) {                	
         				for (var z=0;z<3;z++){
         					sym.getSymbol("liveMc").getSymbol("phaseBtn"+z).$('top').off("click");
         					sym.getSymbol("liveMc").getSymbol("phaseBtn0").$("FP"+(z+1)).off("click");
         					sym.getSymbol("liveMc").getSymbol("phaseBtn1").$("Q"+(z+1)).off("click");
         					sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("R"+z).off("click");
         				}	
         				var racePhases = data;
         				var n;
         				var latestPhase;
         				var getFunction;
         				var phaseBtnNo;
         				if(racePhases){
         					for (var i = 0; i < racePhases.length; i++) {
         						phase=racePhases[i].n_PhaseID;
         						var sessionNo=(racePhases[i].n_SessionNr>0)?racePhases[i].n_SessionNr:"";
         						var sessLive=(racePhases[i].b_Current==true)?1:0;
         						var sessStarted=(racePhases[i].b_Started==true)?1:0;
         						var sessFin=(racePhases[i].b_Finished==true)?1:0;
         						timeAdjust=racePhases[i].d_DateStart.substr(-6,4)*36000;//Mar 27
         						var nullSession=0;
         						var notStarted;
         						if(i==0){
         							gpStart=parsedDate(racePhases[i].d_DateStart);//Mar27
         						}
         						if (racePhases[i].b_FreePractice==true){
         							n = racePhases[i].n_Phase1Nr;
         							phaseBtnNo="0";
         							raceStage = "FP";
         							latestPhase = statCap[0];
         						}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr==null){//show nothing
         							sessLive=0;
         							sessFin=0;
         							sessStarted=0;
         							nullSession=1;													
         						}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr>0){						
         							n = racePhases[i].n_Phase2Nr;
         							phaseBtnNo="1";						
         							raceStage = "Q";
         							latestPhase = statCap[1];
         						}else if (racePhases[i].b_StartingGrid==true){	
         							n="0";
         							phaseBtnNo="2";
         							raceStage ="R";
         							latestPhase = statCap[2];						
         						}else if (racePhases[i].b_Race==true){
         							n="1";
         							phaseBtnNo="2";
         							raceStage ="R";
         							latestPhase = statCap[3];
         							raceStart=parsedDate(racePhases[i].d_DateStart);//Mar27						
         						}
         						if(nullSession<1){
         							sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).$("top").off("click");
         							if(sessLive==1){											
         								sessLiveOrFin(latestPhase);
         								if(sessStarted==1){
         									getInfo(phase);
         									getLive(phase);
         									if(racePhases[i].b_Race==true){
         										sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("txt").html(statCap[3]);
         										getFunction=showLive(phase,raceStage+n);
         									}else if(racePhases[i].b_StartingGrid==true){
         										getFunction=gridClicker(phase); 
         										//show start grid on phase btn
         									}else{
         										getFunction=showPhase(phase,raceStage+n,sessionNo);
         									}
         									if(sessFin==1){	
         										sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).getSymbol(raceStage+n).$("fin").show();
         										if(racePhases[i].b_Race==true){
         											showFinished(latestPhase);									
         										}else if(racePhases[i].b_StartingGrid==true){
         											sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"background-color":"rgb(119,192,61)"});
         										}else{
         											sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"background-color":"rgb(220,0,0)"});
         										}
         									}else{
         										sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).getSymbol(raceStage+n).$("live").show();
         										sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn2").off("touchstart click");
         										sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"background-color":"rgb(119,192,61)"});
         									}
         								}else{
         									if(raceStage == "FP"&&n==1){
         										notStarted=1;
         									}else{
         										getInfo(phase);
         										getLive(phase);
         									}
         								}
         							}else if(sessFin==1){	
         								sessLiveOrFin(latestPhase);
         								sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).getSymbol(raceStage+n).$("fin").show();
         								sym.getSymbol("circuitOverlayTop").getSymbol("status").$("statusTxt").css({"background-color":"rgb(220,0,0)"});
         							if (racePhases[i].b_Race==true){
         									showFinished(latestPhase);
         									getInfo(phase);
         									getLive(phase);
         									getFunction=showLive(phase,raceStage+n);
         								}else if(racePhases[i].b_StartingGrid==true){
         									getFunction=gridClicker(phase);
         								}else{
         									liveTxt[4].fadeIn(0);
         									getFunction=showPhase(phase,raceStage+n,sessionNo);
         								}
         							}															
         						sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).$(raceStage+n).css({"cursor":"pointer"});
         						sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).$(raceStage+n).on('click',getFunction);
         						sym.getSymbol("liveMc").getSymbol("phaseBtn"+phaseBtnNo).$("top").on('click',getFunction);
         						}
         				}//end for
         				phaseNo=phaseBtnNo;
         				//
         				if (notStarted==1){
         					getInfo(raceID);
         					getStartList();
         				}			
         			}else{
         			getInfo(raceID);
         			getStartList();
         			}
         		},
         		error:function(){
         			getInfo(raceID);
         			getStartList();
         		}
         	});
         }
         getRace();
         raceInterval=setInterval(getRace,60000);
         
         sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").append('<img src="images/weather0.png" width="27px" height="27px">');
         var gridPhase=0;
         //GET individual phase info for laps/live race conditions
         function getInfo(phaseID){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gnNo+"&yr="+yearNo+"&q=info&race="+phaseID,
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").empty(); // Empty weather symbol
         							liveTxt[0].fadeOut(0);
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").empty();
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").fadeOut(0);
         							var lap="#Stage_liveMc_latestMc_lapCounter";
         						if(data){	
         							if (data[0].n_WeatherConditionType!=null){
         							var weather = '<img src="images/weather'+ data[0].n_WeatherConditionType +'.png" width="24px" height="24px">';
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").append(weather); // Add weather symbol
         							liveTxt[2].fadeIn(0);					
         							}else{
         							sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").empty();
         							liveTxt[2].fadeOut(0);
         							}
         							var sessionNo=(data[0].n_SessionNr>0)?data[0].n_SessionNr:"";
         							//Angle per lap:
         								var laps = data[0].n_LapsScheduled;
         								var lapsDriven = data[0].n_LapsDriven;
         								liveTxt[0].html(txtArr[0]+" <b>"+lapsDriven+"/"+laps+"</b>");
         
         							sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").off("touchstart click");
         							clearInterval(raceInterval);
         							if (data[0].b_FreePractice==true){
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("touchstart click", {menuId:1,"phaseLive":0,"sessionLive":sessionNo}, menuBtnClick);
         								liveTxt[1].html(txtArr[4]);
         								liveTxt[9].html(statCap[0] + " "+ sessionNo);
         								phaseNo=0;	
         								showMc=1;
         							}else if(data[0].b_Qualifying==true){
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("touchstart click", {menuId:1,"phaseLive":1,"sessionLive":sessionNo}, menuBtnClick);
         								liveTxt[1].html(txtArr[4]);
         								liveTxt[9].html(statCap[1] + " "+ sessionNo);
         								phaseNo=1;
         								showMc=1;
         							}else if(data[0].b_StartingGrid==true){
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("click touchstart", {menuId:1,"phaseLive":2,"sessionLive":0}, menuBtnClick);
         								phaseNo=2;
         								showMc=1;
         								gridPhase=phaseID;
         							}else if(data[0].b_Race==true){				
         								phaseNo=2;
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("touchstart click", {menuId:1,"phaseLive":2,"sessionLive":1}, menuBtnClick);
         								liveTxt[1].html(txtArr[1]);
         								liveTxt[11].fadeIn(0);
         								liveTxt[0].fadeIn(0);
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").fadeIn(400, function(){ pieChart(lapsDriven,0,laps-lapsDriven,lap); });
         								if (data[0].b_Finished==true){
         									liveTxt[9].html(txtArr[6]);
         									showMc=2;
         								}else{
         									liveTxt[9].html(txtArr[5]);
         									showMc=1;
         								}				
         							}else{
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("touchstart click", {menuId:1,"phaseLive":0,"sessionLive":1}, menuBtnClick);
         								liveTxt[1].html(txtArr[4]);
         								liveTxt[9].html(statCap[0]);
         								liveTxt[0].html(txtArr[0]);
         								liveTxt[0].fadeIn(0);
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").empty(); // Empty weather symbol
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").append('<img src="images/weather1.png" width="24px" height="24px">');	
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").fadeIn(0);	
         								showMc=0;
         							}
         							if (data[0].b_Finished==true){
         								raceInterval=setInterval(getRace,300000);
         							}else if (data[0].b_Started==true){
         								raceInterval=setInterval(getRace,45000);
         							}else{
         								raceInterval=setInterval(getRace,300000);
         							}
         			}else{
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").on("touchstart click", {menuId:1,"phaseLive":0,"sessionLive":1}, menuBtnClick);
         								liveTxt[1].html(txtArr[4]);
         								liveTxt[9].html(statCap[0]);
         								liveTxt[0].html(txtArr[0]);
         								//liveTxt[0].fadeIn(0);//Apr10
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").empty(); // Empty weather symbol
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("weather").append('<img src="images/weather1.png" width="24px" height="24px">');	
         								//sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").fadeIn(0);//Apr10
         								showMc=0;
         			}
         		}
         	});
         }
         
         //GET Start list if race hasn't started
         function getStartList(){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gnNo+"&yr="+yearNo+"&q=startlist&race=",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         						var startData=data;
         						if(startData.length>0){	
         							 if (startData.length>20){
         								//barHeight = Math.floor((423/startData.length)-(40/startData.length)); // to allow for more than 20 starters
         								barHeight = Math.floor(423/startData.length-3); // to allow for more than 20 starters (423/startData.length-4)
         							 }else{
         								barHeight = 18;
         							 }
         							for (var i=0; i<startData.length; i++){
         								if(i==0){ //show lead driver details
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").empty();
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").empty();
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").empty();
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").empty();
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").empty();
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").empty();
         								var imgHelmet = '<img src="drivers/'+ startData[i].n_PersonID +'.png" width="105px" height="82px">';
         								var imgDriver = '<img src="drivers/'+ startData[i].n_PersonID +'.jpg" width="105px">';
         								var imgCar = '<img src="cars/'+ startData[i].c_TeamShort +'.png" width="330px">';
         								var leadDriver = '<b>' +startData[i].c_Person+ '</b> <span style="font-size:12px"><i>' +startData[i].c_NOCShort+ '</i></span>';
         								liveTxt[5].html(leadDriver);
         								var conText=(startData[i].c_ConstructorTeam=="RedBull - Renault")?"Red Bull - Renault":startData[i].c_ConstructorTeam;
         								liveTxt[6].text(conText);
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").append(imgHelmet);
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").append(imgDriver);
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").append(imgCar);
         								}
         								//create graph for each driver and for final results
         								var tableText ="<div class='race'>";
         								tableText += "<div class='graphbar' id='driverdata"+i+"'>";
         								tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         								tableText += "<td id='driverNo"+i+"'></td>";
         								tableText += "<td class='driver' id='driver"+i+"'width='140px'></td>";
         								tableText += "<td class='driverShort' id='drivershort"+i+"'width='90px'></td>";
         								tableText += "<td class='team' id='team"+i+"' style='font-style:italic' width='20px'></td>";
         								tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='20px'></td>";
         								tableText += "</tr></table>";
         								tableText += "</div></div>";
         								sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").append(tableText);
         								$('#driver' + i).text(startData[i].c_Person);
         								$('#drivershort'+i).text((startData[i].c_PersonShort).toUpperCase());
         								$('#pitstops' + i).text("0");
         								$('#pitstops' + i).css({'font-weight':'bold','text-align':'center','color':'rgb(255,255,255)','background-color':'rgba(0,0,0,0.15)'});
         								$('#driverNo' + i).text(startData[i].c_ShirtNr);
         								var fontSize=(barHeight>16)?13:barHeight-3;
         								var teamLogo='<img class="teamsmall" src="teams/'+ startData[i].c_TeamShort +'.png" width='+fontSize+'"px">';
         								$('#team' + i).html(teamLogo);
         								$(".race").css({'font-size':fontSize+'px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':3});//'margin-bottom':Math.floor(40/startData.length)
         								$(".team").css({'padding':0,'margin':0});
         								$("#driverNo" + i).css({'width':'10%','padding-right':'5px'});	
         								barHeight=(barHeight>15)?barHeight:fontSize+3;
         								scale=57;
         							}
         							$("img.teamsmall").css({'margin-bottom':'-2px','width':'16px'});
         							$(".graphbar").css({'height':barHeight,'width':'65%','background-color':graphcolor,'padding-left':'5px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         						}else{
         							//disable button
         								sym.getSymbol("styleHead").getSymbol("menuBtnsMc").$("menuBtn1").off("touchstart click");
         						}
         		},
         		complete:function(){
         		initSize();
         		}
         	});
         }
         //GET individual phase data for live and final result
         var liveScale=[];
         function getLive(phaseID) { 
         	liveScale=[];
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gnNo+"&yr="+yearNo+"&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			raceData = data;
         			//Ensure all drivers will fit in graph
         			nRaceDrivers = raceData.length;
         			barHeight=(nRaceDrivers>20)?Math.round(440/nRaceDrivers)-2:20;	//scale results graph
         			//barHeight=20;
         			//calculate relative length of each bar
         			if (raceStage =="R"){
         				minTime = raceData[0].n_TimeRel;
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 0;	
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeRel!=null && raceData[n].n_TimeRel>mxm) {
         						mxm = raceData[n].n_TimeRel;
         					}
         				}
         			}else if (raceData[0].n_TimeAbs!=undefined){//during other phases	
         				minTime = raceData[0].n_TimeAbs; 
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 1;
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeAbs!=null && raceData[n].n_TimeAbs>mxm) {
         						mxm = raceData[n].n_TimeAbs;									
         					}
         					if (raceData[n].n_TimeAbs!=null && raceData[n].n_TimeAbs<minTime) {
         						minTime = raceData[n].n_TimeAbs;									
         					}
         				}
         			}
         			sym.getSymbol("resultsMc").$("graph").empty();
         			sym.getSymbol("resultsMc").$("helmetPic").empty();					
         			sym.getSymbol("resultsMc").$("driverPic").empty();					
         			for (var i = 0; i < raceData.length; i++) {
         				if(i==0){ //show lead driver details
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").empty();
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").empty();
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").empty();
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").empty();
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").empty();
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").empty();
         					var imgHelmet = '<img src="drivers/'+ raceData[i].n_PersonID +'.png" width="105px" height="82px">';
         					var imgDriver = '<img src="drivers/'+ raceData[i].n_PersonID +'.jpg" width="105px">';
         					var imgCar = '<img src="cars/'+ raceData[i].c_TeamShort +'.png" width="330px">';
         					var leadDriver = '<b>' +raceData[i].c_Person+ '</b> <span style="font-size:12px"><i>' +raceData[i].c_NOCShort+ '</i></span>';
         					liveTxt[5].html(leadDriver);
         					liveTxt[6].text(raceData[i].c_ConstructorTeam);
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").append(imgHelmet);
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").append(imgDriver);
         					sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").append(imgCar);
         					sym.getSymbol("resultsMc").$("helmetPic").append(imgHelmet);
         					sym.getSymbol("resultsMc").$("driverPic").append(imgDriver);
         					resTxt[5].html(leadDriver);
         				}
         				//create graph for each driver and for final results
         				var tableText ="<div class='race'>";
         				tableText += "<div id='driverdata"+i+"' class='driverdata'>";
         				tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr >";
         				tableText += "<td class='driver' id='driver"+i+"'width='140px'></td>";
         				tableText += "<td class='driverShort' id='drivershort"+i+"'width='90px'></td>";
         				tableText += "<td id='team"+i+"' width='20px'></td>";
         				tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='20px'></td>";
         				tableText +="<td id='time"+i+"'></td>";
         				tableText += "</tr></table>";
         				tableText += "</div></div>";
         
         				var resultsText ="<div class='resultrace'>";
         				resultsText += "<div id='resultdata"+i+"' class='resultdata'>";
         				resultsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				resultsText += "<td id='resultorder"+i+"' width='20px'></td>";
         				resultsText += "<td class='driver' id='resultdriver"+i+"' width='140px'></td>";
         				resultsText += "<td class='driverShort' id='resultdriverS"+i+"' width='85px'></td>";
         				resultsText += "<td id='resultteam"+i+"' style='font-style:italic' width='20px'></td>";
         				resultsText += "<td id='points"+i+"'></td>";
         				resultsText += "</tr></table>";
         				resultsText += "</div>";
         				resultsText += "</div>";					
         				var teamLogo='<img src="teams/'+ raceData[i].c_TeamShort +'.png" width="16px" class="teamsmall">';
         				sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").append(tableText);
         				$('#driver' + i).text(raceData[i].c_Person);
         				$('#drivershort'+i).text((raceData[i].c_PersonShort).toUpperCase());
                     $('#team' + i).html(teamLogo);
         				if (raceData[i].n_PitStops){
         					$('#pitstops' + i).text(raceData[i].n_PitStops);
         					$('#pitstops' + i).css({'font-weight':'bold','text-align':'center','color':'rgb(255,255,255)','background-color':'rgba(0,0,0,0.15)'});
                     }
                     if (timeRel==1){
         					var hrs =(raceData[i].n_TimeAbs>3600000)?Math.floor(raceData[i].n_TimeAbs/3600000)+":":"";
         					var mins=(raceData[i].n_TimeAbs>3600000)?Math.floor((raceData[i].n_TimeAbs%3600000)/60000):Math.floor(raceData[i].n_TimeAbs/60000);
         					if (mins<10){
         						mins="0"+mins+":";
         					}else if(mins<1){
         						mins="00:";
         					}else{
         						mins=mins+":";
         					}
         					var secs=(raceData[i].n_TimeAbs>3600000)?(raceData[i].n_TimeAbs%3600000%60000)/1000:(raceData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					var timing = hrs+mins+secs;
         					$('#time' + i).text(timing);
         					if (minTime==mxm && raceData[i].n_TimeAbs==mxm) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scale=100;
         					}else if(raceData[i].n_TimeAbs==null){
         						scale=68;//57
         					}else{
         						scale = 100-((raceData[i].n_TimeAbs-minTime)*32/(mxm-minTime));
         					}	
         				}else if (timeRel==0){
         					if(raceData[i].n_RankSort==1&&raceData[i].n_TimeAbs==null){
         						scale=100;
         						$('#time' + i).text();
         					}else if(raceData[i].n_TimeRel==null){						
         						scale=57;
         						if (raceData[i].c_ResultSuffix==null){
         						}else{
         							if(raceData[i].c_ResultSuffix=="DNF"||raceData[i].c_ResultSuffix=="DNS/NC"){
         								$('#time' + i).html("<span style='color:rgb(255,0,0)'>X</span>");
         							}else{
         								$('#time' + i).text(raceData[i].c_ResultSuffix);
         							}
         						}
         					}else{
         						scale = 100-(raceData[i].n_TimeRel*32/mxm);
         						if(raceData[i].c_Result=="DNF"||raceData[i].c_Result=="DNS/NC"){
         						$('#time' + i).text('X');
         						}else{
         						$('#time' + i).text(raceData[i].c_Result);
         						}
         					}
         				}
         				liveScale.push(scale);
         				$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});					
         				if (raceFinished==1){ //final results only
         					sym.getSymbol("resultsMc").$("graph").append(resultsText);	
         					sym.getSymbol("resultsMc").$("car"+i).empty();				
         					resultCar = '<img src="cars/'+ raceData[i].c_TeamShort +'o.png" width="30px">';
         					order = raceData[i].n_RankSort;
         					if (raceData[i].c_ChampionshipPoints!=undefined){
         						points = raceData[i].c_ChampionshipPoints;
         					}else{
         						points=0;
         					}				
         					$('#resultorder' + i).html("<b>"+order+"</b>");
         					$('#resultdriver' + i).text(raceData[i].c_Person);
         					$('#resultdriverS'+i).text((raceData[i].c_PersonShort).toUpperCase());
         					$('#resultteam' + i).html(teamLogo);
         					$('#points' + i).html("<b>"+points+"</b>");
         					$(".resultrace").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         					$("#points" + i).css({'text-align':'right', 'padding-right':'5px'});
         					sym.getSymbol("resultsMc").$("car"+i).append(resultCar);
         				}
         			}
         			$("img.teamsmall").css({'margin-bottom':'-4px','width':'16px'});
         			$(".resultdata").css({'height':barHeight+'px'});
         			$(".driverdata, .resultdata").css({'background-color':graphcolor,'padding-left':'5px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$(".race").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         		},
         		complete:function(){
         			initSize();
         		}		
         	});
         }
         
         var scalePhase;
         function getPhases(phaseID){
         sym.getSymbol("liveMc").$("loader-bar").fadeIn(0);				
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gnNo+"&yr="+yearNo+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         					sym.getSymbol("liveMc").$("loader-bar").fadeOut(0);				
         					var phaseData = data;
         					sym.getSymbol("liveMc").getSymbol("timingMc").$("graph").empty();
         					sym.getSymbol("liveMc").getSymbol("timingMc").$("helmetPic").empty();
         					sym.getSymbol("liveMc").getSymbol("timingMc").$("driverPic").empty();
         					sym.getSymbol("liveMc").getSymbol("timingMc").$("carPic").empty();
         					//Ensure all drivers will fit in graph
         					 if (phaseData.length>20){
         					 barHeight = (420/phaseData.length)-4;
         					 }else{
         					 barHeight = 20;
         					 }
         					 minTime = phaseData[0].n_TimeAbs;
         					 var max = (minTime!=null) ? minTime : 0;
         								for (var n=0; n<phaseData.length; n++) {
         									if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs>max) {
         									max = phaseData[n].n_TimeAbs;
         									}
         									if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs<minTime) {
         									minTime = phaseData[n].n_TimeAbs;									
         									}
         								}
                        for (var i = 0; i < phaseData.length; i++) {
         							if(i==0){					
         							var imgHelmet = '<img src="drivers/'+ phaseData[i].n_PersonID +'.png" width="105px" height="82px">';
         							var imgDriver = '<img src="drivers/'+ phaseData[i].n_PersonID +'.jpg" width="105px">';
         							var imgCar = '<img src="cars/'+ phaseData[i].c_TeamShort +'.png" width="330px">';
         							var leadDriver = '<b>' +phaseData[i].c_Person+ '</b> <span style="font-size:12px"><i>' +phaseData[i].c_NOCShort+ '</i></span>';
         							liveTxt[7].html(leadDriver);
         							liveTxt[8].text(phaseData[i].c_ConstructorTeam);
         							sym.getSymbol("liveMc").getSymbol("timingMc").$("helmetPic").append(imgHelmet);
         							sym.getSymbol("liveMc").getSymbol("timingMc").$("driverPic").append(imgDriver);
         							sym.getSymbol("liveMc").getSymbol("timingMc").$("carPic").append(imgCar);
         							}			
         					var phaseText ="<div class='phaserace'>";
           					phaseText += "<div id='phasedriverdata"+i+"' class='driverdata'>";
           					phaseText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
           					phaseText +="<td class='driver' id='phasedriver"+i+"' style='width:140px'></td>";
           					phaseText +="<td class='driverShort' id='phasedriverS"+i+"' style='width:95px'></td>";
         					phaseText +="<td id='phaseteam"+i+"' style='font-style:italic' width='20px'></td>";
           					phaseText +="<td id='phasetime"+i+"'></td>";
           					phaseText +="</tr></table>";
         					phaseText +="</div>";
         					phaseText +="</div>";
         					sym.getSymbol("liveMc").getSymbol("timingMc").$("graph").append(phaseText);
         					var teamLogo='<img src="teams/'+ phaseData[i].c_TeamShort +'.png" width="15px">';
         					$('#phasedriver' + i).text(phaseData[i].c_Person);
         					$('#phasedriverS' + i).text((phaseData[i].c_PersonShort).toUpperCase());
                        $('#phaseteam' + i).html(teamLogo);
         
                        var mins=Math.floor(phaseData[i].n_TimeAbs/60000)+":";
         					var secs=(phaseData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					$('#phasetime' + i).text(mins+secs);
         					if (minTime==max && phaseData[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scalePhase=100;
         					}else if(phaseData[i].n_TimeAbs==null){
         						scalePhase=57;
         					}else{
         						scalePhase = 100-((phaseData[i].n_TimeAbs-minTime)*40/(max-minTime));
         					}
         					$("#phasedriverdata"+i).css({'width':scalePhase+'%'});
         					$("#phasetime" + i).css({'text-align':'right', 'padding-right':'5px'});
         					}
         					$(".phaserace").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         					//$(".driverdata").css({'background-color':graphcolor,'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$(".driverdata").css({'background-color':graphcolor,'padding-left':'5px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
                     },
                     complete:function(){
         					initSize();
                     }
         		});
         }
         // GRID BUTTON
         function getGrid(phaseID){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gnNo+"&yr="+yearNo+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
                  var gridData = data;
         				var gridMove;
         				var go;
         				for (var i = 0; i < gridData.length; i++) {
         					sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("grid"+i).empty();												
         					var gridText ="<div class='gridlist'><table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'>";
         					gridText += "<tr><td id='gridorder"+i+"' width='10%'></td>";
         					gridText +="<td class='driver' id='griddriver"+i+"' width='62%'></td>";
         					gridText +="<td class='driverShort' id='griddriverS"+i+"' width='62%'></td>";
         					gridText +="<td id='gridteam"+i+"' width='28%' font-style:italic'></td>";
         					gridText +="</tr></table></div>";
         					if (i%2==0){
         					sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("gridtxt0").append(gridText);
         					}else{
         					sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("gridtxt1").append(gridText);
         					}
         					var gridCar = '<img src="cars/'+ gridData[i].c_TeamShort +'o.png" width="24px">';
         					var order = gridData[i].n_RankSort;
         					var teamLogo='<img src="teams/'+ gridData[i].c_TeamShort +'.png" width="24px">';
         					$('#gridorder' + i).html("<b>"+order+"</b>");
         					$('#griddriver' + i).text(gridData[i].c_Person);
         					$('#griddriverS' + i).text((gridData[i].c_PersonShort).toUpperCase());
         					$('#gridteam' + i).html(teamLogo);
         					$(".gridlist").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'height':'66px','border-bottom':'solid 1px rgb(150,150,150)','padding-top':'5px'});
         					sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("grid"+i).append(gridCar);
         					//if (i%2==0){ gridMove=5+(i*35); }else{ gridMove=-15+(i*35); }
         					gridMove=(i%2==0)?5+(i*35):-15+(i*35);
         					sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("grid"+i).delay(i*400).animate({'top':gridMove}, 1000);								
         				}
         				sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("gridtxt1").css({'margin-top':'5px'});
         				sym.getSymbol("liveMc").getSymbol("gridMc").getSymbol("grid").$("gridtxt1").css({'margin-top':'17px'});
         				sym.getSymbol("liveMc").$("gridMc").css({'overflow-y':'scroll'});
                  },
                  complete:function(){
         				initSize();
                  }
               });
         }
         function getStandings(){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gnNo+"&q=champdrivers&yr="+yearNo+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         					var rankData = data;
                        for (var i = 0; i < rankData.length; i++) {
         						if (i<10){
         							if (i%2 == 0){
         							var rankText ="<div class='rankingeven'><table style='width:98%; border:none; border-collapse:collapse; padding:0; margin:0'><tr><td id='rank"+i+"' width='15%'></td><td id='rankdriver"+i+"' width='60%' style='font-weight:600'></td><td id='rankpoints"+i+"' width='20%' style='text-align:right; font-style:italic'></td></tr></table></div>";
         							}else{
         							var rankText ="<div class='rankingodd'><table style='width:98%; border:none; border-collapse:collapse; padding:0; margin:0'><tr><td id='rank"+i+"' width='15%'></td><td id='rankdriver"+i+"' width='60%' style='font-weight:600'></td><td id='rankpoints"+i+"' width='20%' style='text-align:right; font-style:italic'></td></tr></table></div>";							
         							}					
         						}
         					sym.getSymbol("resultsMc").$("standings").append(rankText);
         					$('#rank' + i).text(rankData[i].n_RankSort);		
         					$('#rankdriver' + i).text(rankData[i].c_PersonShort);		
         					$('#rankpoints' + i).text((rankData[i].n_PointsSort)/1000);
                        }
                     $(".rankingeven").css({'background-color':'rgb(150,210,255)','font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%'});
         				$(".rankingodd").css({'background-color':'rgb(213,239,255)','font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%'});									
         			}
         	});
         }
         // CIRCUIT BUTTONS & TIMELINE FUNCTIONS
         sym.gearChange = function(gearIn,gearOut,duration) {
         					sym.$({countNum: gearIn}).animate({countNum: gearOut}, {
         						duration: duration,
         						easeOut:'cubic',
         						step: function() {
         						 sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("gear").text(Math.round(this.countNum));
         						},
         					});
         }
         sym.speedChange = function(speedIn,speedOut,duration) {
         					sym.$({countNum: speedIn}).animate({countNum: speedOut}, {
         					  duration: duration,
         					  easeOut:'cubic',
         					  step: function() {
         						 sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("speed").html(Math.round(this.countNum));
         					  },
         					});			
         }
         
         //*********************************************
         var resultsBits=["helmetPic","driverPic","resultTxt4","resultTxt5"];
         var circuitBits=["circuit","pit","pitPoint","carMc"];
         function fadeOutCircuit(){
         	stopIt();
         	sym.$("circuitOverlay").fadeOut(0);
         	sym.$("circuitOverlayTop").fadeOut(0);
         	for (var c=0;c<16;c++){
         		cornerTxt[c]= sym.getSymbol("circuitMc").$("corner"+c).fadeOut(0);
         	}
         	sym.$("circuitMc").fadeOut(0);
         }
         sym.getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeOut();
         fadeOutCircuit();
         
         function fadeInCircuit(){
         	inPlay = true;
         	stageWidth=sym.$("Stage").width();
         	sym.$("circuitMc").stop().fadeIn(0);
         	sym.$("circuitOverlay").fadeIn(0);
         	sym.$("circuitOverlayTop").fadeIn(0);
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeOut(0);
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeIn(0);
         	if (stageWidth<600){
         		sym.getSymbol("circuitOverlay").$("circuitMini").fadeIn(0);
         	}else{
         		sym.getSymbol("circuitOverlay").$("circuitMini").fadeOut(0);
         	}
         	sym.getSymbol("circuitMc").$("circuit").fadeIn(90);
         	for (var i=0;i<circuitBits.length;i++){
         		sym.getSymbol("circuitMc").$(circuitBits[i]).fadeIn(90);
         	}
         	startTimer();
         	sym.getSymbol("circuitMc").play();
         	sym.getSymbol("circuitOverlay").getSymbol("circuitMini").play();
         	for (var c=0;c<16;c++){
         		cornerTxt[c]= sym.getSymbol("circuitMc").$("corner"+c).fadeIn(90);
         	}
         }
         
         // PLAY/PAUSE BTN
         sym.getSymbol("circuitOverlay").$("playPause").on('click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("circuitOverlay").getSymbol("playPause").$("play").is(":visible") ) {
         		playIt();
         	} else{
         		stopIt();
         	}
         });
         
         function playIt() {
         	if (inPlay == true){
         		startTimer();
         		sym.getSymbol("circuitMc").play();
         		sym.getSymbol("circuitOverlay").getSymbol("circuitMini").play();
         	} else {
         		fadeInCircuit();
         	}
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeOut(0);
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeIn(0);
         	sym.$("circuitMc").css({'overflow-x':'hidden'});
         }
         function stopIt() {
         	stopTimer();
         	sym.getSymbol("circuitMc").stop();
         	sym.getSymbol("circuitOverlay").getSymbol("circuitMini").stop();
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeIn(0);
         	sym.getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeOut(0);
         	sym.$("circuitMc").css({'overflow-x':'auto'});
         }
         	var timer;
         
         	function startTimer() {
         	  timer = setInterval(startReplay, 150);
         	}
         	function startReplay() {
         		var stageWidth=sym.$("Stage").width();
         		var pos = sym.getSymbol("circuitMc").getPosition();
         		var x = sym.getSymbol("circuitMc").$("carMc").position();
         		sym.$("circuitMc").stop().animate({scrollLeft: x.left+20}, 500);
         		if (pos == 0 || pos == 15000) {
         			stopIt();
         			inPlay = false;
         			sym.$("circuitMc").css({'overflow-x':'auto'});
         			}
         	}
         	function stopTimer() {
         	  clearInterval(timer);
         	}
         //*************** START **********************************************************************************
         var mcArr=['circuitMc','liveMc','resultsMc','winnersMc'];
         function startPanel(){//this runs on first loading to determine which Mc to display on opening
         	for (var i=0; i<3; i++){
         		if(showMc==i){	//from getInfo
         			sym.$(mcArr[i]).stop().fadeIn(1000);//show the relevant Mc
         			sym.getSymbol("styleHead").getSymbol("menuBtnsMc").getSymbol("menuBtn" + i).$("bg").css(red);
         			menuTxt.html(menuTxtArr[i]);
         			if (i==0){ //circuitMc
         					//setTimeout( playIt, 2850);
         				sym.$("circuitOverlay").fadeIn(1000);
         				sym.$("circuitOverlayTop").fadeIn(1000);
         				playTime=setTimeout(playIt,2850);
         			}else if(i==1){//liveMc
         			//show grid
                  					if(gridPhase>0){ //with grid
                  						sym.getSymbol("liveMc").$("gridMc").fadeIn(1000);
                  						sym.getSymbol("liveMc").$("timingMc").fadeOut(0);
                  						sym.getSymbol("liveMc").$("latestMc").fadeOut(0);
                  						getGrid(gridPhase);
                  					}else{	//without grid
                  						sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").delay(500).fadeIn(1000);
                  						setTimeout(startPanel,2000);
                  					}
         			}else if(i==2){
         				for (m=0; m<10; m++){
         					var carMove=(nRaceDrivers>20)?353-(m*440/nRaceDrivers):353-(m*22);
         					sym.getSymbol("resultsMc").$("car"+m).animate({'bottom':carMove}, 1000);
         				}
         			}
         		}else{
         			sym.$(mcArr[i]).stop().fadeOut(1000);
         			sym.getSymbol("styleHead").getSymbol("menuBtnsMc").getSymbol("menuBtn" + i).$("bg").css(grey);
         		}			
         	}
         }
         setTimeout(startPanel,2000);
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable
         $('img').attr('draggable',false); //make images undraggable
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	var scale=stageWidth/600;
         	sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("gearsMc").stop().animate({left:stageWidth/2-66}, 0);
         	sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("distance").css({'width':stageWidth/2-75});
         	sym.getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("lap").css({'width':stageWidth/2-75});
         	sym.getSymbol("circuitOverlay").$("playPause").stop().animate({left:stageWidth/2-25}, 0);
         	sym.$("intro").stop().animate({left:stageWidth/2-300}, 0);
         	var liveHeight=(nRaceDrivers>20)?Math.round(423/raceData.length)-2:19;//scale for live graph
         	var fontSize=(liveHeight>16)?13:liveHeight-3;
         	for (var n=0;n<nRaceDrivers;n++){
         		if (n<10){
         			scaleresult= (stageWidth<600)?98-(n*5):94-(n*6);
         		}else{
         			scaleresult= (stageWidth<600)?48:37;						
         		}
         		$("#resultdata"+n).css({'width':scaleresult+'%'});
         		var scale=(stageWidth<400)?(liveScale[n]<68)?52:100-(n*2.2):liveScale[n];
         		$("#phasedriverdata"+n+ ", #driverdata"+n).css({'height':liveHeight+'px'});
         		$("#driverdata" + n).stop().animate({'width':scale+'%'},800);
         	}
         	if(stageWidth<600){
         		if (sym.$("circuitMc").is(":visible")) {
         			sym.getSymbol("circuitOverlay").$("circuitMini").fadeIn(0);
         		}
         		for (var i=0;i<resultsBits.length;i++){
         		sym.getSymbol("resultsMc").$(resultsBits[i]).fadeOut(0);
         		}
         		$(".cars").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("carPic").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("txt0").css({'top':'-20px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").css({'top':'288px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").css({'top':'182px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("driverTxt").css({'top':'151px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("teamTxt").css({'top':'375px'});
         		sym.getSymbol("styleHead").$("headlineTxt").html(headlinemob);	sym.getSymbol("styleHead").$("standTxt").html(standmob);
         		}else{
         		if (sym.$("circuitMc").is(":visible")) {
         			sym.getSymbol("circuitOverlay").$("circuitMini").fadeOut(0);
         		}
         		for (var i=0;i<resultsBits.length;i++){
         		sym.getSymbol("resultsMc").$(resultsBits[i]).fadeIn(0);
         		}
         		$(".cars").fadeIn(0);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("carPic").fadeIn(1000);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("carPic").fadeIn(1000);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("txt0").css({'top':'-20px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("helmetPic").css({'top':'238px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("driverPic").css({'top':'132px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("driverTxt").css({'top':'101px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("teamTxt").css({'top':'325px'});
         		sym.getSymbol("styleHead").$("headlineTxt").html(headline); sym.getSymbol("styleHead").$("standTxt").html(capsArr[0]);
         	}
         	if(stageWidth<480){
         		$(".wteam").fadeOut(0);
         		$(".driver").fadeOut(0);
         		$(".driverShort").fadeIn(0);
         		//$(".resultrace, .race").css({'font-size':'12px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").css({'width':'95%'});
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("graph").css({'width':'95%'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("stopwatch").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("leadDriver").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").css({'top':'340px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("txt0").css({'top':'292px'});
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("txt4").css({'right':'5px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("pitstop").css({'left':'-50px'});
         		sym.getSymbol("styleHead").$("flag").fadeOut(0);sym.getSymbol("styleHead").$("number").fadeOut(0);sym.getSymbol("styleHead").$("numberbg").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({'left':'5px'});sym.getSymbol("styleHead").$("standTxt").css({'left':'5px'});
         		sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("gridTxt").fadeOut(0);
         		$(".graphbar").css({'width':'100%'});
         		for (var i=0; i<3; i++){
                  sym.getSymbol("liveMc").getSymbol("phaseBtn"+i).$("txt").html(statCap0[i]);
                }
         	}else{
         		$(".wteam").fadeIn(0);
         		$(".driver").fadeIn(0);
         		$(".driverShort").fadeOut(0);
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("graph").css({'width':'79%'});
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("graph").css({'width':'79%'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("lapCounter").css({'top':'30px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("leadDriver").fadeIn(1000);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("stopwatch").fadeIn(1000);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("leadDriver").fadeIn(1000);
         		sym.getSymbol("liveMc").getSymbol("timingMc").$("txt4").css({'right':'120px'});
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("pitstop").css({'left':'0px'});
         		sym.getSymbol("styleHead").$("flag").fadeIn(0);sym.getSymbol("styleHead").$("number").fadeIn(0);sym.getSymbol("styleHead").$("numberbg").fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({'left':'110px'});sym.getSymbol("styleHead").$("standTxt").css({'left':'110px'});
         		sym.getSymbol("liveMc").getSymbol("phaseBtn2").$("gridTxt").fadeIn(0);
         		$(".graphbar").css({'width':'65%'});
         	}
         	if(stageWidth<400){
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("txt2").fadeOut(0);
         	}else{
         		sym.getSymbol("liveMc").getSymbol("latestMc").$("txt2").fadeIn(0);
         	}
         	mob=(stageWidth<480)?1:0;
         	setStyle();
         	menuMob();
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("circuitMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Phase'
   (function(symbolName) {   
   
   })("Phase");
   //Edge symbol end:'Phase'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'Phase1'
   (function(symbolName) {   
   
   })("Phase1");
   //Edge symbol end:'Phase1'

   //=========================================================
   
   //Edge symbol: 'Phase0'
   (function(symbolName) {   
   
   })("Phase0");
   //Edge symbol end:'Phase0'

   //=========================================================
   
   //Edge symbol: 'results'
   (function(symbolName) {   
   
   })("PhasesMc");
   //Edge symbol end:'PhasesMc'

   //=========================================================
   
   //Edge symbol: 'Phase3'
   (function(symbolName) {   
   
   })("Phase2");
   //Edge symbol end:'Phase2'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'resLive'
   (function(symbolName) {   
   
   })("LatestMc");
   //Edge symbol end:'LatestMc'

   //=========================================================
   
   //Edge symbol: 'pitstop'
   (function(symbolName) {   
   
   })("Pitstop");
   //Edge symbol end:'Pitstop'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'Results'
   (function(symbolName) {   
   
   })("Results");
   //Edge symbol end:'Results'

   //=========================================================
   
   //Edge symbol: 'TimmingMc'
   (function(symbolName) {   
   
   })("TimingMc");
   //Edge symbol end:'TimingMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'flatmap_two'
   (function(symbolName) {   
   
   })("flatmap-two");
   //Edge symbol end:'flatmap-two'

   //=========================================================
   
   //Edge symbol: 'Intro'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().lat();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getSymbol("wheelMc").stop();
         sym.getComposition().getStage().fadeIt();

      });
      //Edge binding end

   })("Intro");
   //Edge symbol end:'Intro'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
         

   })("continents-animation");
   //Edge symbol end:'continents-animation'

   //=========================================================
   
   //Edge symbol: 'wheelMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 633, function(sym, e) {
         sym.play(500);

      });
      //Edge binding end

   })("wheelMc");
   //Edge symbol end:'wheelMc'

   //=========================================================
   
   //Edge symbol: 'logoMc'
   (function(symbolName) {   
   
   })("logoMc");
   //Edge symbol end:'logoMc'

   //=========================================================
   
   //Edge symbol: 'globe'
   (function(symbolName) {   
   
      

      

   })("globe");
   //Edge symbol end:'globe'

   //=========================================================
   
   //Edge symbol: 'roadMc'
   (function(symbolName) {   
   
   })("roadMc");
   //Edge symbol end:'roadMc'

   //=========================================================
   
   //Edge symbol: 'WinnersMc'
   (function(symbolName) {   
   
   })("WinnersMc");
   //Edge symbol end:'WinnersMc'

   //=========================================================
   
   //Edge symbol: 'status'
   (function(symbolName) {   
   
   })("Status");
   //Edge symbol end:'Status'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
   })("keyMc");
   //Edge symbol end:'keyMc'

   //=========================================================
   
   //Edge symbol: 'Recent'
   (function(symbolName) {   
   
   })("Recent");
   //Edge symbol end:'Recent'

   //=========================================================
   
   //Edge symbol: 'playPause'
   (function(symbolName) {   
   
   })("playPause");
   //Edge symbol end:'playPause'

   //=========================================================
   
   //Edge symbol: 'gearsMc'
   (function(symbolName) {   
   
   })("gearsMc");
   //Edge symbol end:'gearsMc'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'speedGearsMc'
   (function(symbolName) {   
   
   })("speedGearsMc");
   //Edge symbol end:'speedGearsMc'

   //=========================================================
   
   //Edge symbol: 'CircuitOverlay'
   (function(symbolName) {   
   
   })("CircuitOverlay");
   //Edge symbol end:'CircuitOverlay'

   //=========================================================
   
   //Edge symbol: 'circuitOverlayTop'
   (function(symbolName) {   
   
   })("circuitOverlayTop");
   //Edge symbol end:'circuitOverlayTop'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn2_1'
   (function(symbolName) {   
   
      })("menuBtn3");
   //Edge symbol end:'menuBtn3'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'GridSlider'
   (function(symbolName) {   
   
   })("GridSlider");
   //Edge symbol end:'GridSlider'

   //=========================================================
   
   //Edge symbol: 'Grid'
   (function(symbolName) {   
   
   })("Grid");
   //Edge symbol end:'Grid'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,315,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,155,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,80,400);
         sym.getComposition().getStage().gearChange(3,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,205,600);
         sym.getComposition().getStage().gearChange(2,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,265,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,185,250);
         sym.getComposition().getStage().gearChange(7,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,330,1250);
         sym.getComposition().getStage().gearChange(5,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,130,400);
         sym.getComposition().getStage().gearChange(8,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5350, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,205,400);
         sym.getComposition().getStage().gearChange(3,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,140,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,278,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(278,140,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,115,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,210,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,80,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,285,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,95,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,250,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,125,500);
         sym.getComposition().getStage().gearChange(5,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,210,350);
         sym.getComposition().getStage().gearChange(3,4,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12350, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,95,250);
         sym.getComposition().getStage().gearChange(4,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,145,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,250,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,190,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,230,250);
         sym.getComposition().getStage().gearChange(4,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,300,500);
         sym.getComposition().getStage().gearChange(5,8,500);

      });
      //Edge binding end

   })("SINMc");
   //Edge symbol end:'SINMc'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("SINmini");
   //Edge symbol end:'SINmini'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews35763");