/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnNo=35479;
         var gnYear=2017;
         var league=127095;//121071;
         var clickEventType;
         var showguide=0;//show guide
         var showStats=0;//show statistics
         var showLocal=0;
         var shootOut=0;// penalty shootout
         var matchView=0;//view of matchtracker
         var stageWidth;
         var matchStatus=0;//status of match
         var mob = 0;
         var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"width":"auto", "pointer-events":"none"});
         var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css({"width":"auto", "pointer-events":"none"});
         var screenArr=['latest','fixtures','matchtracker','team'];
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var teamIDs =[4007,102706,100050,4486,4034,100094,4047,100092,4693,4075,4222,4080,4087,4874,4286,4908,4129,4970,4972,4144];
         var venueID=[10438,15899,26737,35238,35239,36882,37425,49670,49671,49672,49673,49674];
         //GET QUERY STRING PARAMETERS
         var get = [];
         location.search.replace('?', '').split('&').forEach(function (val) {
           split = val.split("=", 2);
           get[split[0]] = split[1];
         });
         //REFRESH RATES & OTHER STUFF
         var fixtureInterval, groupInterval, matchInterval, playInterval, headline, headlineMob, notice, guideTxt, timerTxt, dateFormat, teamSelect;
         //TEXT
         var menuTxt=sym.getSymbol("styleHead").getSymbol("menuBtns").$("menuTxt").css("pointer-events","none");	
         var menuTxtArr=[], txt=[], txtArr=[], timetxt=[], teamArr=[], tableCaps=[], months=[], key=[], yearArr=[], champsArr=[], stadArr=[], venueTimes=[], localTimes=[];
         txt[0]=sym.getSymbol("team").$("txt0").css("pointer-events","none");txt[1]=sym.getSymbol("team").$("txt1").css("pointer-events","none");
         var timeZoneTxtArr=[sym.getSymbol("styleHead").getSymbol("timeZone").$("timezoneTxt"),sym.getSymbol("latest").getSymbol("latestTable").getSymbol("timeZone").$("timezoneTxt"),sym.getSymbol("team").getSymbol("teamTable").getSymbol("timeZone").$("timezoneTxt")];
         $.ajax({	
         	type: "GET",
         	url: "GN"+gnNo+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		var headline=$(xml).find('headline').text();
         		headlinetxt.html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		dateFormat=$(xml).find('dateformat').text();//for different date formats
         		for (var m=0;m<2;m++){
         			sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn"+m).$("icon").css({'background-position':'0px '+(-40*m)+'px'});
         			menuTxtArr[m]= $(xml).find('menuTxt'+m).text();
         		}
         		var monthsArr = $(xml).find('months').text(); months=monthsArr.split(";");
               var keyArr = $(xml).find('key').text(); key=keyArr.split(";");
               var timeArr = $(xml).find('time').text(); timetxt=timeArr.split(";");
               for (var i=0;i<3;i++){
         			timeZoneTxtArr[i].html(timetxt[0]);
               }
               var teamLongArr= $(xml).find("teams").text(); teamArr=teamLongArr.split(";");
               var teamShortNameArr= $(xml).find("teamShort").text(); teamShortArr=teamShortNameArr.split(";");
               var matchBtns=$(xml).find("matchBtns").text(); var matchBtnArr=matchBtns.split(";");
               for (var m=0;m<4;m++){
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("icon").css({'background-position':'0px '+(-30*m)+'px'});
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("menuTxt").html(matchBtnArr[m]);
         			sym.getSymbol("matchtracker").$("matchBtn"+m).on('click',matchMenu(m));
               }
         		for  (var i=0;i<37;i++){
         			txtArr[i]= $(xml).find('txt'+i).text(); //fixed text captions
         			if(i<txt.length){
         				txt[i].html(txtArr[i]);
         			}
         		}
         		for (var t=0;t<20;t++){		//get details for each team
         				$(xml).find("team"+t).each(function(){
         					var $teams = $(this);
         					yearArr[t]=$teams.find('founded').text();
         					champsArr[t]=$teams.find('champs').text();
         					stadArr[t]=$teams.find('home').text();		
         				});
         			}
         		//instruction page
                  		sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").html(txtArr[2]);	
                  		timerTxt="<div class='action period4'>";//style by period
                  		timerTxt+="<div class='personh'>"+txtArr[3]+"</div>";
                  		//timerTxt+="<div class='type'><img src='images/goal.png'></div>";
                  		timerTxt+="<div class='type'><div class='actionImg' style='background-position:-60px -20px'></div></div>";//
                  		timerTxt+="<div class='actiontime'>"+txtArr[4]+"</div><div class='type'></div><div class='persona'></div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+txtArr[5]+"</div>";
                  		//timerTxt+="<div class='type'><img src='images/sub.png'></div>";
                  		timerTxt+="<div class='type'><div class='actionImg' style='background-position:-60px 0px'></div></div>";//
                  		timerTxt+="<div class='persona'>"+txtArr[6]+"</div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+txtArr[9]+"</div>";
                  		//timerTxt+="<div class='type'><img src='images/yellow.png'></div>";
                  		timerTxt+="<div class='type'><div class='actionImg' style='background-position:-60px -60px'></div></div>";//
                  		timerTxt+="<div class='persona'>"+txtArr[10]+"</div>";
                  		timerTxt+="</div>";
                  		guideTxt="<div style='display:inline-block;background-image:url(images/artwork.png);background-position:0px -465px;width:310px;height:135px;overflow:hidden;background-repeat:no-repeat'></div><br>";
                  		guideTxt+=txtArr[20]+", "+txtArr[21]+", "+txtArr[22]+", "+txtArr[23];
                  	sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt0").html(txtArr[24]);
                  	sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
                  	sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
                  	sym.getSymbol("matchtracker").getSymbol("matchStats").$("txt18").html(txtArr[20]);
         		sym.getSymbol("fixtures").$("txt0").html(txtArr[33]);
         		sym.getSymbol("latest").$("txt0").html(menuTxtArr[0]);
         		var tableHeadCaps = $(xml).find('table0').text();
               tableCaps=tableHeadCaps.split(";");
               var tableHead = "<table style='width:55%; position:left; margin-left:45%; font-family:Helvetica, Arial, sans-serif; font-weight:700; border:none; border-collapse:collapse; font-size:12px; text-align:center'>";
         		tableHead += "<tr><td width='13%'><center id='tp'></center></td><td width='13%'><center id='tw'></center></td><td width='13%'><center id='td'></center></td><td width='13%'><center id='tl'></center></td><td width='17%'><center id='tf'></center></td><td width='17%'><center id='ta'></center></td><td width='14%'><center id='tpts'></td></tr>";
         		tableHead += "</table>";
               sym.getSymbol("latest").$("tableHead").append(tableHead);
               $("#tp").text(tableCaps[0]);
               $("#tw").text(tableCaps[1]);
               $("#td").text(tableCaps[2]);
               $("#tl").text(tableCaps[3]);
               $("#tf").text(tableCaps[4]);
               $("#ta").text(tableCaps[5]);
               $("#tpts").text(tableCaps[6]);
         		var tooltipCaps = $(xml).find('table1').text();//tool tip for group table
         		sym.getSymbol("latest").$("tooltip0").html(tooltipCaps);
         		sym.getSymbol("latest").$("tooltip0").css({'background-color':'rgb(255,235,165)','border':'solid 1px rgb(0,0,0)','border-radius':'2px','display':'none'});
         		var iconTable="<table id='icontable' class='fixtable'>";
               iconTable+="<tr class='fixHead'><td class='matchBox fixHead'></td>";
               var shortList="<table class='fixtable'>";
              	for (var c=0; c<teamArr.length; c++){
                  iconTable+="<td class='matchBox fixHead'>"+teamShortArr[c]+"<br/>";
                  iconTable+="<div class='teamBtn' id='teamBtn"+c+"' style='background-position:0px "+(-35*c)+"px'></div>";
                  iconTable+="</td>";
                  var tableTxt="<table class='fixtable'><tr class='fixHead'><td class='fixName' id='fixName"+c+"'></td>";
                  shortList+="<tr><td class='shortName'>"+teamShortArr[c]+"</td></tr>";
         			for(var t=0;t<20; t++){
         				if(t==c){
         				tableTxt+="<td class='matchBox noMatch' id='m"+c+"_"+t+"'>";	
         				}else{
         					if((c%2==0&&t%2==0)||(c%2>0&&t%2>0)){
         						tableTxt+="<td class='matchBox green' id='m"+c+"_"+t+"'>";	
         					}else{
         						tableTxt+="<td class='matchBox white' id='m"+c+"_"+t+"'>";	
         					}	
         				}				
         			}
         			tableTxt+="</tr></table>";
         			sym.getSymbol("fixtures").$('fixTable').append(tableTxt);
         			$("#fixName"+c).html(teamShortArr[c]);
               }
               shortList+="</table>";
               iconTable+="</tr></table>";
               	sym.getSymbol("fixtures").getSymbol('teamBtnStrip').$('teamBtns').append(iconTable);
               	sym.getSymbol("fixtures").$('shortList').append(shortList);
         			$(".fixtable").css({'width':'100%','font-size':'11px', 'font-family':'Helvetica, Arial, sans-serif','border':'none','border-collapse':'collapse'});
         			$(".fixtable tr").css({'height':17})
         			$(".fixName").css({'width':'5%','padding-left':'4px'});
         			$(".shortName").css({'padding-left':'4px'});
         			$(".matchBox").css({'width':'4.75%','font-size':'10px','text-align':'center'});
         			$(".noMatch").css({'background-color':'rgba(0,0,0,0.4)'});
         			$(".green").css({'background-color':'rgba(202,232,226,0.6)'});
         			$(".white").css({'background-color':'rgba(255,255,255,0.8)'});
         			$(".matchBox.fixHead").css({'font-weight':700,'height':'40px'});
         			$(".teamBtn").css({'display':'table-cell','width':'35px','background-image': 'url(images/crests.png)','height':'35px','overflow':'hidden','background-size': '100%','background-repeat':'no-repeat'});
         	},
         	complete: function(){
         	setTimeout(openMatch,400);
         	initSize();
         	}
         });
         //DATES
         var startDate= Date.parse("August 12, 2017, 15:59 UTC");
         var endDate = Date.parse("May 13, 2018, 23:59 UTC");
         var gmtStart = Date.parse("October 29, 2017, 01:59 UTC");
         var gmtEnd = Date.parse("March 25, 2018, 00:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt(dateTxt, 10)+oneDay);
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() + " "+ months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         } 
         function getDateLocal(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() + " "+ months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,venuetime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-venuetime;//localOffset to UTC - offset to time at venue
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         var offsetBrazil;//Offset between time at venue and UTC
         function getDST(thisDateStr){
         	var thisDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf('+'));
         	var offsetUTC=(thisDate<gmtStart||thisDate>gmtEnd)?-3600000:0;
         	return offsetUTC;
         }
         function parseTime(thisTimeStr){
                   var matchTime=thisTimeStr.substring(thisTimeStr.indexOf('(') + 1, thisTimeStr.indexOf('+'));
                   return matchTime;
         }
         var timeZoneArr=[sym.getSymbol("styleHead").$("timeZone"),sym.getSymbol("latest").getSymbol("latestTable").$("timeZone"),sym.getSymbol("team").getSymbol("teamTable").$("timeZone")];
         for(var t=0;t<3;t++){
         timeZoneArr[t].css({'cursor':'pointer'});timeZoneArr[t].on("click",timeZoneClick);timeZoneArr[t].on("mouseover",timeZoneOver);timeZoneArr[t].on("mouseout",timeZoneOut);
         }
         function timeZoneClick(){
         	showLocal==0? showLocal=1:showLocal=0; getTeamFixtures(teamSelect);
         	for(var t=0;t<3;t++){ timeZoneTxtArr[t].html(timetxt[showLocal]); }
         }
         function timeZoneOver(){
         	for(var t=0;t<3;t++){ showLocal==0?timeZoneTxtArr[t].html(timetxt[1]):timeZoneTxtArr[t].html(timetxt[0]); }
         }
         function timeZoneOut(){
         	for(var t=0;t<3;t++){ showLocal==0?timeZoneTxtArr[t].html(timetxt[0]):timeZoneTxtArr[t].html(timetxt[1]); }
         }
         //--------------------------------------------------------------------------------------------------------
         //RESPONSIVE
         var matchArr=['h2hMc','timer','matchStats','tactics','guide','teams'];
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("latest").stop(stageWidth*10);
         	sym.getSymbol("team").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("teams").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("tactics").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("h2hMc").stop(stageWidth*10);
         	sym.getSymbol("latest").getSymbol("latestTable").stop(stageWidth*10);
         	sym.getSymbol("team").getSymbol("teamTable").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("timeZone").fadeIn(0);
         	sym.$('cup').css({'left':(stageWidth/2-117)-567+'px'});
         	sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn0").fadeIn(0);
         	headlinetxt.css({'font-size':'24px'});
         	sym.getSymbol("styleHead").getSymbol("menuBtns").$("menuTxt").css({'opacity':1});
         	mob = 0;
         	clickEventType = "click";
         		$(".squadnat").css({'display':'none'});//matchtracker
         	var btnWidth=sym.getSymbol("matchtracker").$("matchBtn0").width();
         	if(matchStatus>=8){ sym.getSymbol("matchtracker").$("clock").fadeIn(0);matchView=1; }
         	for (var i=0;i<4;i++){
         		sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("icon").css({'left':btnWidth/2-22+'px'});	
         		i==matchView?(sym.getSymbol("matchtracker").$(matchArr[matchView]).fadeIn(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+matchView).$("menuBg").css({'opacity':0.75})):
         		(sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").css({'opacity':0.25}));
         		if(stageWidth>=640){
         			var xtraPanel= (matchStatus<8)?0:1; sym.getSymbol("matchtracker").$(matchArr[xtraPanel]).fadeIn(0);
         		}else{
         			sym.getSymbol("matchtracker").$('teams').fadeOut(0);
         		}
         	}
         	showguide==0?sym.getSymbol("matchtracker").$("guide").fadeOut(0):sym.getSymbol("matchtracker").$("guide").fadeIn(0);
         	var statWidth=sym.getSymbol("matchtracker").$("matchStats").width();
         	sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder").css({'left':statWidth/2-150+'px'});
         	shootOut==1?sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0):sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         
         	var tableArr=[sym.getSymbol("latest").getSymbol("latestTable").$("table"),sym.getSymbol("team").getSymbol("teamTable").$("table")];
         	var boxArr=[sym.getSymbol("latest").$("latestTable"),sym.getSymbol("team").$("teamTable")];
         	var tableBgArr=[sym.getSymbol("latest").getSymbol("latestTable").$("tableBg"),sym.getSymbol("team").getSymbol("teamTable").$("tableBg")];
         	var standingsArr=[sym.getSymbol("latest").$("standings"),sym.getSymbol("team").$("standings")];
         	var minimArr=[sym.getSymbol("latest").getSymbol("latestTable").getSymbol("minim").$('plus'),sym.getSymbol("team").getSymbol("teamTable").getSymbol("minim").$('plus')];
         	var miniBoxArr=[sym.getSymbol("latest").getSymbol("latestTable").$("tableBox"),sym.getSymbol("team").getSymbol("teamTable").$("tableBox")];
         for (var i=0;i<2;i++){
         	if (stageWidth>=480){
         		boxArr[i].css({'height':'485px','top':'3px'});tableArr[i].fadeIn(0);tableBgArr[i].fadeIn(0);standingsArr[i].fadeIn(0);miniBoxArr[i].fadeOut(0);
         	}else{
         		if(min==0){
         			boxArr[i].css({'height':'485px','top':'3px'});tableArr[i].fadeIn(0); tableBgArr[i].fadeIn(0);standingsArr[i].fadeOut(0);minimArr[i].fadeOut(0);miniBoxArr[i].fadeOut(0);
         		}else{
         			boxArr[i].css({'height':'25px','top':'463px'});tableArr[i].fadeOut(0); tableBgArr[i].fadeOut(0);standingsArr[i].fadeIn(0);minimArr[i].fadeIn(0);miniBoxArr[i].fadeIn(0);
         		}
         	}
         }
         	if (stageWidth<=480){
         		mob = 1;
         		$('.teamf').css({'display':'table-cell'});//latest
         		$('.shortf, .stad, .att').css({'display':'none'});
         		clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'ew-resize'});
         		headlinetxt.css({'font-size':'18px'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'12px'});
         		sym.getSymbol("styleHead").getSymbol("menuBtns").$("menuTxt").css({'opacity':0});
         		sym.getSymbol("styleHead").$("timeZone").fadeOut(0);
         	}else if (stageWidth<510){
         		$('.teamf, .shortf, .stad').css({'display':'none'});
         		$('.att').css({'display':'block'});
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'ew-resize'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'11px'});
         		sym.getSymbol("styleHead").$("timeZone").fadeOut(0);
         	}else if(stageWidth<641){
         		$('.teamf, .stad').css({'display':'none'});
         		$('.att').css({'display':'block'});
         		$('.shortf').css({'display':'table-cell'});
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'ew-resize'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'11px'});
         		sym.getSymbol("styleHead").$("timeZone").fadeOut(0);
         	}else if(stageWidth<768){
         		$('.teamf').css({'display':'none'});
         		$('.shortf').css({'display':'table-cell'});
         		$('.stad').css({'display':'block'});
         		$('.att').css({'display':'block'});
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'ew-resize'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'11px'});
         	}else if(stageWidth<800){
         		$('.teamf').css({'display':'table-cell'});
         		$('.shortf').css({'display':'none'});
         		$('.stad').css({'display':'block'});
         		$('.att').css({'display':'block'});
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'ew-resize'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'13px'});
         	}else{
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").css({'cursor':'auto'});
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn0").fadeOut(0);
         		$(".squadCol3, squadCol4, squadCol5").css({'display':'table-cell'});
         		$('.att').css({'display':'block'});
         		$(".squadnat").css({'display':'inline'});
         		sym.getSymbol("latest").$("tooltip0").css({'font-size':'13px'});
         	}
         };
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //---------------------------------------------------
         // MENU BUTTONS
                  menuArray = []; //the array that will hold references to the buttons.
                  for (var m = 0; m < 2; m++){
                  		var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
                  		menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
                  		menuArray.push(menuBtnSymbols); //push it into the array
                  	}
                  $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
                  		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
                  		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  		menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
                  		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
                  		menuBtnElement.css({"cursor":"pointer"});
                  })
                  function resetmenu(){
                  		for (var m=0; m<menuArray.length; m++){	
                           menuArray[m].$("menuBg").fadeOut(0);
                  		}
                  		menuTxt.fadeOut(0);
                  }
                  resetmenu();
                  function menuBtnClick (e){
                  		e.preventDefault();
                  		e.stopPropagation();
                  		resetmenu(); //set them all back to normal state
                  		sym.$("latest").animate({opacity:1.0},0);
                  		clearInterval(matchInterval);
         					clearInterval(playInterval);
                  		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         					for (var i=0;i<5;i++){
         						if (menuMenu_id==i){
         							sym.$(screenArr[i]).fadeIn(400);
         							sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn" + i).$("menuBg").fadeIn(0);
         							menuTxt.html(menuTxtArr[i]);
         							menuTxt.fadeIn(0);
         							if(menuMenu_id==0){
         								getTeamFixtures();
         								clearInterval(fixtureInterval);
         								fixtureInterval = setInterval(getTeamFixtures,300000);
         								sym.$("epl").animate({opacity:0.4},400);
         								sym.$("cup").animate({opacity:0.4},400)
         							}else{
         								sym.$("epl").animate({opacity:0.1},400);
         								sym.$("cup").animate({opacity:0.1},400)
         							}
         						}else{
         							sym.$(screenArr[i]).fadeOut(400);
         						}						 
         					}
                  }
                  function menuShow (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the over button
                  		menuTxt.html(menuTxtArr[menuMenu_id]);
         					menuTxt.fadeIn(0);
                  }
                  function menuHide (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the out button
                  		menuTxt.fadeOut(0);
                  }
         sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn0").$("menuBg").fadeIn(0);	
         //MATCH MENU
         function makeGuide(n){
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").empty();
         	var title=(n==1)?2:11;
         	var txtObj=(n==1)?timerTxt:guideTxt;
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").html(txtArr[title]);
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").append(txtObj);
         	$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'Helvetica, Arial, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
            $(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
            $('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
            $('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
            $('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
            $('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
            $(".action img").css({'width':'20px'});
            $(".actionImg").css({'display':'inline-block','background-image': 'url(images/artwork.png)','width':'20px','height':'20px','overflow':'hidden','background-repeat':'no-repeat'});
         }
         var matchMenu = function(n){ //to handle lexical scope
         	return function (e) {
         		for (i=0;i<4;i++){
         			if (i==n){
         				matchView=n;
         				sym.getSymbol("matchtracker").getSymbol("matchBtn"+n).$("menuBg").animate({'opacity':0.75},0);
         				if(matchStatus<8&&(n==1||n==2)){
         					makeGuide(n); sym.getSymbol("matchtracker").$(matchArr[4]).fadeIn(600);showguide=1;
         				}else{
         					sym.getSymbol("matchtracker").$(matchArr[n]).fadeIn(600); sym.getSymbol("matchtracker").$(matchArr[4]).fadeOut(600);showguide=0;					
         				}	
         			}else{
         				sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(600); sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").animate({'opacity':0.25},0);
         			}														
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         }; 
         //LATEST TABLE BUTTONS
         sym.getSymbol("latest").$("tableHead").on('click',showTip);
         var showtip=0;
         function showTip(){
         	showtip=(showtip==0)?(sym.getSymbol("latest").$("tooltip0").fadeIn(0),1):(sym.getSymbol("latest").$("tooltip0").fadeOut(0),0);
         	e.preventDefault(); e.stopPropagation();
         }
         function rowColOver(e){
         	$(this).css({'background-color':'rgba(255,0,0,1.0)','color':'rgba(255,255,255,1.0)','font-weight':700,'font-size':'90%'});
         	var row = (e.data.row);
         	var col = (e.data.col);
         	for(var c=0;c<teamArr.length; c++){
         			if(row==teamIDs[c]){
         				var x=c;
         			}
         			if(col==teamIDs[c]){
         				var y=c;
         			}
         			for(var t=0;t<teamArr.length;t++){
         				$("#m"+x+"_"+t).addClass("view");
         				$("#m"+t+"_"+y).addClass("view");
         			}
         		}
         	$(".view").css({'background-color':'rgba(255,200,0,0.2)'});
         }
         function rowColOut(e){
         	$(this).css({'background-color':'rgba(255,255,255,0)','color':'rgba(0,0,0,1.0)','font-weight':400,'font-size':'100%'});
         	var row = (e.data.row);
         	var col = (e.data.col);
         	for(var c=0;c<teamArr.length; c++){
         		if(row==teamIDs[c]){
         				var x=c;
         		}
         		if(col==teamIDs[c]){
         				var y=c;
         		}
         		for(var t=0;t<teamArr.length;t++){
         			$("#m"+x+"_"+t).removeClass("view");
         			$("#m"+t+"_"+y).removeClass("view");
         		}
         	}		
         	$(".green").css({'background-color':'rgba(202,232,226,0.6)'});
         	$(".white").css({'background-color':'rgba(255,255,255,0.8)'});
         	$(".noMatch").css({'background-color':'rgba(0,0,0,0.4)'});
         }
         //MINIMISE LATEST
         sym.getSymbol("latest").getSymbol("latestTable").getSymbol("minim").$('plus').fadeOut(0);
         sym.getSymbol("latest").getSymbol("latestTable").$("minim").on('click',function(){ minimise(0);});
         sym.getSymbol("latest").getSymbol("latestTable").$("minim").css('cursor','pointer');
         sym.getSymbol("team").getSymbol("teamTable").getSymbol("minim").$('plus').fadeOut(0);
         sym.getSymbol("team").getSymbol("teamTable").$("minim").on('click',function(){ minimise(1); });
         sym.getSymbol("team").getSymbol("teamTable").$("minim").css('cursor','pointer');
         var min=0;
         function minimise(n){
         		var panel=(n==0)?"latest":"team";
         		if(min==0){
         			sym.getSymbol(panel).$(panel+"Table").animate({'height':'25px','top':'463px'},200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("table").fadeOut(200);sym.getSymbol(panel).getSymbol(panel+"Table").$("tableBg").fadeOut(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("timeZone").fadeOut(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("tableBox").fadeIn(200);
         			sym.getSymbol(panel).$("standings").fadeIn(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").getSymbol("minim").$('plus').fadeIn(0);
         			min=1;
         		}else{
         			sym.getSymbol(panel).$(panel+"Table").animate({'height':'485px','top':'3px'},200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("table").fadeIn(200);sym.getSymbol(panel).getSymbol(panel+"Table").$("tableBg").fadeIn(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("timeZone").fadeIn(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").$("tableBox").fadeOut(200);
         			sym.getSymbol(panel).$("standings").fadeOut(200);
         			sym.getSymbol(panel).getSymbol(panel+"Table").getSymbol("minim").$('plus').fadeOut(0);
         			min=0;
         		}
         	e.preventDefault(); e.stopPropagation();
         }
         //LOAD FUNCTIONS
         var tacticH=0, tacticA=0, lineUp, tacticSelected=0;
         var homeArr=[], awayArr=[];
         function loadMatch(match){
         		resetmenu();
         		showguide=0;matchView=0;matchStatus=0;
         		clearInterval(matchInterval);
         		clearInterval(playInterval);
         		getMatchInfo(match);
         		getMatch(match);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		playInterval = setInterval(function() { getMatch(match); }, 60000);
         		for (var i=0;i<screenArr.length;i++){
         			i==2?sym.$(screenArr[i]).fadeIn(400):sym.$(screenArr[i]).fadeOut(400);
         		}
         		sym.$("epl").animate({opacity:0},400);
         		sym.$("cup").animate({opacity:0.25},1000);
         		initSize();
         }
         var showMatch = function(match){ //to handle lexical scope
         	return function (e) {
         		loadMatch(match);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         function openMatch(){
         	if (get["match"] + "" != "undefined"){// Check if there is a matchID
         		if (isNaN(get["match"])){// if its letters
         			var teamid=get["match"];
         			for (var n=0;n<20;n++){
         				if (teamShortArr[n]==teamid){
         					var startTeam=teamIDs[n];
         				}
         			}
         			loadTeam(startTeam);
         		}else{// if its numbers
         			var startMatch=parseInt(get["match"],10);
         			loadMatch(startMatch);
         		}
         	}else{
         		sym.play();
         	}	
         }
         function loadTeam(team){
         		resetmenu();
         		sym.getSymbol('team').$('teamTxt1').empty();
         		sym.$("epl").animate({opacity:0},400);
         		sym.$("cup").animate({opacity:0.25},1000);
         		teamSelect=team;
         		getTeamFixtures(team);
         		getSquad(team);
         		for (var n=0;n<20;n++){
         			if (teamIDs[n]==team){
         				sym.getSymbol('team').$('teamTxt0').html(teamArr[n]);
         				sym.getSymbol('team').$('teamTxt1').append("<br>"+txtArr[36]+stadArr[n]+"<br><i>"+txtArr[34]+yearArr[n]+"<br>"+champsArr[n]+"</i>");	
         				sym.getSymbol('team').$('crest').css({'background-position':'0px '+(-n*160)+'px'});
         			}
         		}
         		clearInterval(fixtureInterval);
         		fixtureInterval = setInterval(function(){ getTeamFixtures(teamSelect); },600000);
         		sym.$("matchtracker").fadeOut(400);
         		sym.$("fixtures").fadeOut(400);
         		sym.$("latest").fadeOut(400);
         		sym.$("team").fadeIn(400);
         		sym.getSymbol("team").$("teamTable").css({'height':'485px','top':'3px'});
         		min=0;
         }
         var showTeam = function(team){ //to handle lexical scope
         	return function (e) {
         		loadTeam(team);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         var teamOver = function(team){ //to handle lexical scope
         	return function (e) {
         		$('#team' + team).css({'font-weight':700});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         var teamOut = function(team){ //to handle lexical scope
         	return function (e) {
         		$('#team' + team).css({'font-weight':400});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         function lineUpf(n){
         		$(".formations").fadeOut(0);
         		var thisArray;
         		tacticSelected=n;
         		var thisTactic=(n==0)?(sym.getSymbol("matchtracker").getSymbol("tactics").$("btn1").css({'opacity':0.5}),thisArray=homeArr,tacticH):
         		(sym.getSymbol("matchtracker").getSymbol("tactics").$("btn0").css({'opacity':0.5}),thisArray=awayArr, tacticA);
         		for (var i=1;i<12;i++){
         			sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").getSymbol("f"+thisTactic).$("playerTxt"+i).html("<span>"+thisArray[i-1]+"</span>");
         			sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersH").getSymbol("h"+tacticH).$("playerTxt"+i).html("<span>"+homeArr[i-1]+"</span>");
         			sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersA").getSymbol("a"+tacticA).$("playerTxt"+i).html("<span>"+awayArr[i-1]+"</span>");
         		}
         		sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").$("f"+thisTactic).fadeIn(0);
         		$(".players").css({'font-size':'12px','width':'auto'});
         		$(".centre").css({'width':'100%'});
         		$(".players span").css({'background-color':'rgba(255,255,255,0.6)','height':'13px','padding':'2px 3px 1px','border-radius':'6px'});
         		e.preventDefault();
         		e.stopPropagation();
         }
         var showLineup = function(n){
         	return function (e) {
         		for(var i=0;i<2;i++){
         		i==n?(sym.getSymbol("matchtracker").getSymbol("tactics").$("btn"+n).stop().animate({'opacity':1.0},200),sym.getSymbol("matchtracker").getSymbol("tactics").$("crestTactic"+n).css({'opacity':0.3})):
         		(sym.getSymbol("matchtracker").getSymbol("tactics").$("btn"+i).stop().animate({'opacity':0.5},200),sym.getSymbol("matchtracker").getSymbol("tactics").$("crestTactic"+i).css({'opacity':0}));
         		}
         		lineUpf(n);
         	};
         };
         for(var b=0;b<2;b++){
         	sym.getSymbol("matchtracker").getSymbol("tactics").$("btn"+b).on('click',showLineup(b));
         	sym.getSymbol("matchtracker").getSymbol("tactics").$("btn"+b).css({'cursor':'pointer'});
         }
         //----------------------------------------------
         //LIVE DATA
         function getTable() {           //GET STANDINGS  
         		var tableData;
               $.ajax({ type: "GET", url: dataURL,
                                  data: "gn="+gnNo+"&phaseID="+league+"&yr="+gnYear,
                                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                                  async: true,
                                  crossDomain: true,
                                  success: function (data) {
                                      tableData = data;
                                      if(tableData.length>0){
                                      for (var i = 0; i < tableData.length; i++) {
                                     		if (i==0){
         												sym.getSymbol('latest').$("pltable").empty();
         											}			
         											var tableTxt = "<table class='pltable' id='teamTable"+i+"'>";
         											if (i==0){
         											tableTxt += "<tr class='first'>";//first place
         											}else if (i< 5){
         											tableTxt += "<tr class='euq'>";//cl and el qualifier
         											}else if (i>16){
         											tableTxt += "<tr class='releg'>";//relegation places
         											}else{
         											tableTxt += "<tr class='mid'>";
         											}
         											tableTxt +="<td class='rank' id='rank" + i + "'></td><td class='team' id='team" + i + "'></td>";
         											tableTxt +="<td class='play' id='p" + i + "'></td><td class='won' id ='w" + i + "'></td>";
         											tableTxt +="<td class='draw' id ='d" + i + "'></td><td class='lost' id ='l" + i + "'></td>";
         											tableTxt +="<td class='for' id ='f" + i + "'></td><td class='against' id ='a" + i + "'></td>";
         											tableTxt +="<td class='pts' id ='pts" + i + "'></td>";
         											tableTxt +="</tr></table>";
         											sym.getSymbol('latest').$("pltable").append(tableTxt);
         											$('#team' + i).text(tableData[i].c_Team); $('#rank' + i).text(i+1);
         											$('#p' + i).text(tableData[i].n_Matches); $('#w' + i).text(tableData[i].n_MatchesWon);
         											$('#d' + i).text(tableData[i].n_MatchesDrawn); $('#l' + i).text(tableData[i].n_MatchesLost);
         											$('#f' + i).text(tableData[i].n_GoalsFor); $('#a' + i).text(tableData[i].n_GoalsAgainst);
         											$('#pts' + i).text(tableData[i].n_Points);
         											$('.pltable').css({'width':'100%','font-size':'13px','font-family':'Helvetica, Arial, sans-serif','border-collapse':'collapse','border-top':'solid 1px rgba(100,100,100,0.5)','border-bottom':'solid 1px rgba(255,255,255,1.0)'});
         											$('.pltable td').css({'padding-top':'2px','padding-bottom':'3px'});
         											$('.rank').css({'width':'5%'});
         											$('.team').css({'width':'40%'});
         											$('.play').css({'width':'7%','text-align':'center'});
         											$('.won').css({'width':'7%','text-align':'center'});
         											$('.draw').css({'width':'7%','text-align':'center'});
         											$('.lost').css({'width':'7%','text-align':'center'});
         											$('.for').css({'width':'10%','text-align':'center'});
         											$('.against').css({'width':'10%','text-align':'center'});
         											$('.pts').css({'width':'7%','text-align':'right','font-weight':700});
         											$('tr.first').css({'background-color':'rgba(245,230,140,0.7)'});
         											$('tr:odd.euq').css({'background-color':'rgba(230,230,190,0.7)'});
         											$('tr:even.euq').css({'background-color':'rgba(250,250,220,0.7)'});
         											$('tr:even.releg').css({'background-color':'rgba(255,190,160,0.7)'});
         											$('tr:odd.releg').css({'background-color':'rgba(255,220,205,0.7)'});
         											$('tr:even.mid').css({'background-color':'rgba(215,230,245,0.7)'});
         											$('tr:odd.mid').css({'background-color':'rgba(225,240,255,0.7)'});
         											var teamIndex=teamIDs.indexOf(tableData[i].n_TeamID);
         											$("#teamTable"+i).on("click",showTeam(teamIDs[teamIndex]));//team buttons on standings table
         											$("#teamTable"+i).on("mouseover",teamOver(i));$("#teamTable"+i).on("mouseout",teamOut(i));
         											$("#teamTable"+i).css({'cursor':'pointer'});
         										}
         										initSize();
         									}else{
         										console.log('No table');
         									}
         		},
         		error:function(){
         			console.log('Table not found');
         		}
         	});
         }
         getTable();
         
         function getTeamFixtures(teamID){//GET FIXTURES
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&editionID=22333",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("team").getSymbol("teamTable").$("table").empty();
         			sym.getSymbol("latest").getSymbol('latestTable').$('table').empty();
         			var fixtureData = data;
         			var teamHome, teamAway, showLatest=0, lastMatches=0, nextMatches=0;
         			if(fixtureData.length>0){
         			for (var i = 0; i < fixtureData.length; i++) {				
         				var matchesRnd = (fixtureData[i].d_DateUTC!=null)?parsedDate(fixtureData[i].d_DateUTC):endDate;
         				var matchDay = fixtureData[i].n_PhaseID;
         				var phaseLevel = fixtureData[i].n_PhaseLevel;
         				var matchNo = fixtureData[i].n_MatchNr;
         				var city=fixtureData[i].c_City
         				var stad=fixtureData[i].c_Stadium
         				var matchDate = (fixtureData[i].d_DateUTC!=null)?getDDmonthYY(fixtureData[i].d_DateUTC):"TBC";
         				var offsetVenue = (fixtureData[i].d_DateUTC!=null)?getDST(fixtureData[i].d_DateUTC):"TBC";
         				var matchID = fixtureData[i].n_MatchID;
         				var homeTeamID=fixtureData[i].n_HomeTeamID;
         				var awayTeamID=fixtureData[i].n_AwayTeamID;
         				if (fixtureData[i].d_DateUTC!=null){
         					var matchTime = (showLocal==0)?getDDmonthYY(fixtureData[i].d_DateUTC)+", "+getMatchTime(fixtureData[i].d_Date,offsetVenue):getDateLocal(fixtureData[i].d_Date)+", "+getMatchLocal(fixtureData[i].d_Date);
         				}else{
         					var matchTime = "TBC";
         				}
         				var matchddmm= (fixtureData[i].d_Date!=null)?getDDMMYY(fixtureData[i].d_Date):"TBC";
         				for(var c=0;c<20;c++){
         					if (fixtureData[i].n_HomeTeamID>0){
         						if (fixtureData[i].n_HomeTeamID==teamIDs[c]){
         							teamHome=teamArr[c];
         							teamHshort=teamShortArr[c];
         							var crestH = "0px "+(-35*c)+"px";
         						}
         					}else{
         						teamHome=fixtureData[i].c_HomeTeam;
         					}
         					if (fixtureData[i].n_AwayTeamID>0){
         						if (fixtureData[i].n_AwayTeamID==teamIDs[c]){
         							teamAway=teamArr[c];
         							teamAshort=teamShortArr[c];
         							var crestA = "0px "+(-35*c)+"px";
         						}
         					}else{
         						teamAway=fixtureData[i].c_AwayTeam;
         					}
         				}
         				var fixtureTxt = (i%2 == 0)?"<table class='fixtxt even' id='matchf" + i + "'>":"<table class='fixtxt' id='matchf" + i + "'>";
         				fixtureTxt += "<tr>";
         				fixtureTxt += "<td class='crestcell'><div class='crestf' id='homecrestf" + i + "'></div></td>";
         				fixtureTxt += "<td class='teamf' style='padding-left:3px' id='homef" + i + "'></td>";
         				fixtureTxt += "<td class='shortf' id='hshortf" + i + "'></td>";
         				fixtureTxt += "<td class='scoref' id='scoref" + i + "'></td>";
         				fixtureTxt += "<td class='shortf away' id='ashortf" + i + "'></td>";
         				fixtureTxt += "<td class='teamf away' id ='awayf" + i + "'></td>";
         				fixtureTxt += "<td class='crestcell'><div class='crestf away' id='awaycrestf" + i + "'></div></td>";
         				fixtureTxt += "</tr></table>";
         				if (typeof teamID!="undefined"){//get team fixtures
         					if (fixtureData[i].n_HomeTeamID==teamID||fixtureData[i].n_AwayTeamID==teamID){
         						sym.getSymbol("team").getSymbol("teamTable").$("table").append(fixtureTxt);
         					}
         				}else{//get all fixtures
         					//SHOW LATEST MATCHES ONLY
         					if(fixtureData[i].b_Finished==true&&matchesRnd>=lastMatches){//Aug15
         						lastMatches=matchesRnd;
         						showLatest=i;
         					}
         					if(fixtureData[i].b_Finished==true&&todayTime==matchesRnd){
         						nextMatches=matchesRnd;				
         					}else if(fixtureData[i].b_Finished==false&&i==showLatest+1){
         						nextMatches=matchesRnd;
         					}//ends
         					//if ((todayTime<startDate&&i<10)||(todayTime>endDate&&i>fixtureData.length-10)||(matchesRnd>todayTime-(oneDay*2)&&matchesRnd<todayTime+(oneDay*15))){
         					//if ((todayTime<startDate&&i<10)||(todayTime>endDate&&i>fixtureData.length-10)||(matchesRnd>todayTime-(oneDay)&&i<showLatest+11)){
         					if ((todayTime<startDate&&matchesRnd<startDate+(oneDay*3)&&fixtureData[i].d_Date!=null)||(todayTime>endDate&&i>fixtureData.length-10)||(todayTime>startDate&&matchesRnd>todayTime-(oneDay)&&i<showLatest+11)&&(fixtureData[i].d_Date!=null)){//Feb 24
         						sym.getSymbol("latest").getSymbol('latestTable').$('table').append(fixtureTxt);
         					}
                  	}
                  	var fixtBox = "<div id='match"+i+"'></div>";
         				for (var t=0; t<20;t++){
         					if (homeTeamID==teamIDs[t]){
         						for (var c=0;c<20;c++){
         							if(awayTeamID==teamIDs[c]){
         								$("#m"+c+"_"+t).html(fixtBox);
         							}
         						}
         					}
         				}
         				$('#homecrestf' + i).css({'background-position':crestH});
         				$('#awaycrestf' + i).css({'background-position':crestA});
         				var score =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '-' + (fixtureData[i].n_AwayGoals)+'</b>':matchDate;
         				var scoref =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '-' + (fixtureData[i].n_AwayGoals)+'</b>':'<i>'+matchTime+'</i>';
         				$("#match"+i).html(score);
         				$('#scoref' + i).html(scoref+"<br/><span class='stad'>"+stad+"</span>");
         				$("#match"+i).on('click',showMatch(matchID));
         				$("#match"+i).on('mouseover',{'row':awayTeamID,'col':homeTeamID},rowColOver);
         				$("#match"+i).on('mouseout',{'row':awayTeamID,'col':homeTeamID},rowColOut);
         				$("#match"+i).css({'cursor':'pointer'});
         				$("#matchf"+i).css({'cursor':'pointer'});
         				$("#matchf"+i).on('click',showMatch(matchID));
         				$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)','font-weight':700});});
         				$("#matchf"+i).on('mouseout',function(){ 
         					if(this.className=="fixtxt even"){ 
         						$(this).css({'background-color':'rgba(215,230,245,0.5)','font-weight':400});
         					}else{
         						$(this).css({'background-color':'rgba(255,255,255,0)','font-weight':400});
         					}
         				});
         
         				$('#homef' + i).text(teamHome);
         				$('#awayf' + i).text(teamAway);
         				$('#hshortf' + i).text(teamHshort);
         				$('#ashortf' + i).text(teamAshort);
         			}//end for
         			$('.even').css({'background-color':'rgba(215,230,245,0.5)'});
         			$('.fixtxt').css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-top':'2px', 'margin-bottom':'3px'});
         			$('.teamf').css({'width':'27%','font-weight':700});
         			$('.shortf').css({'width':'20%','font-weight':700,'display':'none'});
         			$(".crestcell").css({'width':'7%'});
         			$(".crestf").css({'width':'35px','background-image': 'url(images/crests.png)','height':'35px','overflow':'hidden','background-size': '100%','background-repeat':'no-repeat','cursor':'pointer'});
         			$(".away").css({'text-align':'right'});
         			$(".scoref").css({'width':'32%','text-align':'center'}); $('.stad').css({'font-style':'italic'});
         			$('.match').css({'margin-left':'2px','cursor':'pointer','height':'32px','font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif','border-collapse':'collapse', 'width':'100%'});
         			sym.getSymbol("team").getSymbol("teamTable").$("table").css({'overflow-y':'auto'});
         			initSize();
         		}else{
         			console.log('No fixtures');
         		}
         		},//end success
         		error:function(){
         			console.log('Fixtures not found');
         		}
         	});
         }
         getTeamFixtures();
         if(todayTime>startDate-(oneDay*3)&&todayTime<endDate+(oneDay*3)){
         	groupInterval = setInterval(getTable,600000);
         	fixtureInterval = setInterval(getTeamFixtures,600000);
         }
         sym.getSymbol("latest").getSymbol("latestTable").$('table').css({'overflow-y':'auto'});
         //------------------------------------------------------------------------------
         // LIVE MATCH 			
         function getMatchInfo(matchID){
         	var infoData;lineUp=0;
            sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
            var minutes = sym.getSymbol("matchtracker").$("timeTxt");
            minutes.text('0');
         	sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1ID=infoData[0].n_HomeTeamID;var matchteam2ID=infoData[0].n_AwayTeamID;
         			var city=infoData[0].c_City;
         			var offsetVenue, matchTime, matchDate, localTime, venueTime, offsetZone=0, matchddmm;
         			var startPeriod=infoData[0].d_CurrentPeriodStartTime;
         			var timeUpdate = new Date(); var newTime=timeUpdate.getTime();var timeUnknown=infoData[0].b_TimeUnknown;
         			var matchteam1, matchteam2;
         			//getTeams(matchID,matchteam1ID,matchteam2ID);
         			for(var c=0;c<20;c++){
         				if (matchteam1ID>0){
         					if (matchteam1ID==teamIDs[c]){
         						matchteam1=teamArr[c];
         						var imgH = "0px "+(-160*c)+"px";
         					}
         				}else{
         					matchteam1=infoData[0].c_HomeTeamShort;
         				}
         				if (matchteam2ID>0){
         					if (matchteam2ID==teamIDs[c]){
         						matchteam2=teamArr[c];
         						var imgA = "0px "+(-160*c)+"px";
         					}
         				}else{
         					matchteam2=infoData[0].c_AwayTeamShort;
         				}
         			}
         			var score1, score2;
         			var notStarted=['h2hMc'];
         			var showStarted=['timer','timeTxt','clock'];
         			matchStatus = infoData[0].n_MatchStatusCode;
         			getH2H(matchID);	
         			if(infoData[0].b_Started==false){
         				score1="0";
         				score2="0";
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeIn(600);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeOut(0);
         				}
         				clearInterval(playInterval);
         			}else{
         				if(infoData[0].b_Live==true){
         					clearInterval(matchInterval);
         					clearInterval(playInterval);
         					matchInterval = setInterval(function() { getMatchInfo(matchID); }, 45000);
         					playInterval = setInterval(function() { getMatch(matchID); }, 45000);
         				}
         				score1=infoData[0].n_HomeGoals;
         				score2=infoData[0].n_AwayGoals;
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeOut(0);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeIn(600);
         				}
         				getmatchStats(matchID);
         			}
                  if (infoData[0].d_DateUTC!=null){
                  		offsetVenue = getDST(infoData[0].d_DateUTC,offsetZone);
         					var timeAdjust=timeUnknown==true?infoData[0].d_Date.substr(-6,4)*36000:0;
         					localTime=getDateLocal(infoData[0].d_Date)+(timeUnknown==true?"":", "+getMatchLocal(infoData[0].d_Date));
         					venueTime=getDDmonthYY(infoData[0].d_DateUTC,timeAdjust)+(timeUnknown==true?"":", "+getMatchTime(infoData[0].d_Date,offsetVenue));
         					matchDate = getDDmonthYY(infoData[0].d_DateUTC,timeAdjust);
         					matchddmm=getDDMMYY(infoData[0].d_Date);
                  	}else{
                  		offsetVenue = "TBC"; matchTime = "TBC";localTime="TBC";venueTime="TBC";matchDate =  "TBC";matchddmm="TBC";
                  	}
         			if(infoData[0].b_Finished==true){
         				clearInterval(matchInterval);
         				matchInterval = setInterval(function() { getMatchInfo(matchID); }, 300000);
         				clearInterval(playInterval);
         				playInterval = setInterval(function() { getMatch(matchID); }, 300000);
         				localTime=matchDate;
         				venueTime=matchDate;
         			}
                  var periodTime=0, currentTime=0;		
                  switch (infoData[0].n_PeriodSort){
         				case 1:periodTime=0;break;
         				case 2:periodTime=1;break;
         				case 3:periodTime=45;break;
         				case 4:periodTime=46;break;
         				case 5:periodTime=90;break;
         				case 6:periodTime=91;break;
         				case 7:periodTime=105;break;
         				case 8:periodTime=106;break;
         				case 9:periodTime=120;break;
         				case 10:periodTime=120;break;
         				case 11: periodTime=(infoData[0].n_PhaseLevel<17&&infoData[0].n_HomeGoals105mins!=null)?120:90;break;
         				default:periodTime=0;break;
                  }
                  if(infoData[0].n_MatchStatusCode>6&&infoData[0].n_MatchStatusCode<128){
         				if(infoData[0].b_Suspended==true||infoData[0].b_Abandoned==true){   
         					currentTime= Math.round(infoData[0].n_CurrentPeriodTimePlayed/60000);
         				}else if(startPeriod!=null){
         					currentTime= Math.round((newTime-parseTime(startPeriod)-infoData[0].n_CurrentPeriodTimeNotPlayed)/60000);
         				}else{
         					currentTime=0;
         				}
         			}
         			minutes.text(periodTime+currentTime); //SHOW LATEST TIME
         			//end timeplayed
         			//tactics
         			if(infoData[0].b_TacticsPositions==true){
         				lineUp=1;
         				var homeTactics=infoData[0].c_HomeTactics;
         				var awayTactics=infoData[0].c_AwayTactics;
         				switch (homeTactics){
         					case '4-4-2': tacticH=0;break;
         					case '3-4-3': tacticH=1;break;
         					case '3-5-2': tacticH=2;break;
         					case '4-3-1-2': tacticH=3;break;
         					case '4-3-3': tacticH=4;break;
         					case '4-2-1-3': tacticH=5;break;
         					case '4-5-1': tacticH=6;break;
         					case '5-3-2': tacticH=7;break;
         					case '5-4-1': tacticH=8;break;
         					default: tacticH=0;break;
         				}
         				switch (awayTactics){
         					case '4-4-2': tacticA=0;break;
         					case '3-4-3': tacticA=1;break;
         					case '3-5-2': tacticA=2;break;
         					case '4-3-1-2': tacticA=3;break;
         					case '4-3-3': tacticA=4;break;
         					case '4-2-1-3': tacticA=5;break;
         					case '4-5-1': tacticA=6;break;
         					case '5-3-2': tacticA=7;break;
         					case '5-4-1': tacticA=8;break;
         					default: tacticA=0;break;
         				}
         				$(".formations").fadeOut(0);
         				if(tacticSelected==0){
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").$("f"+tacticH).fadeIn(0);
         				}else{
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").$("f"+tacticA).fadeIn(0);
         				}
         			}else{
         				homeArr.length=0;awayArr.length=0;tacticH=0;tacticA=0;
         				homeArr=[1,2,3,4,5,6,7,8,9,10,11];awayArr=[1,2,3,4,5,6,7,8,9,10,11];
         				lineUpf(0);
         			}
         			for (var t=0;t<9;t++){
         				if(t==tacticH){
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersH").$("h"+tacticH).fadeIn(0);
         				}else{
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersH").$("h"+t).fadeOut(0);
         				}
         				if(t==tacticA){
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersA").$("a"+tacticA).fadeIn(0);
         				}else{
         					sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("playersA").$("a"+t).fadeOut(0);
         				}
         			}
         			getTeams(matchID,matchteam1ID,matchteam2ID);
         			//end tactics
         			var matchRef=(infoData[0].c_Referee==null)?"":txtArr[18] + infoData[0].c_Referee + " <i>" + infoData[0].c_RefereeNatioShort+"</i>";
         			var spectators=(infoData[0].n_Spectators==null)?"":txtArr[19] + infoData[0].n_Spectators;
         			var matchscore = score1 + "-" + score2;
         			var tacticsH =(infoData[0].c_HomeTactics==null)?"":infoData[0].c_HomeTactics;
         			var tacticsA = (infoData[0].c_AwayTactics==null)?"":infoData[0].c_AwayTactics;
         			//*************************************time.png
         			var matchInfo = infoData[0].c_Stadium + "<span class='city'>, " + city + "</span><br /><img id='timezone' src='images/time.png'><span class='venuetime'>"+venueTime+"</span><span class='localtime'>"+localTime+"</span><br /><span class='ref'>" + matchRef + "</span><br /><span class='att'>" + spectators+ "</span>";
         			sym.getSymbol("matchtracker").$("matchcrest1").css({'background-position':imgH});
         			sym.getSymbol("matchtracker").$("matchcrest2").css({'background-position':imgA});
         			sym.getSymbol("matchtracker").getSymbol("tactics").$("crestTactic0").css({'background-position':imgH});
         			sym.getSymbol("matchtracker").getSymbol("tactics").$("crestTactic1").css({'background-position':imgA});			
         			sym.getSymbol("matchtracker").$("matchteam1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("matchteam2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("matchscoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchinfoTxt").html(matchInfo);
         			$("#timezone").css({'cursor':'pointer','width':'15px','margin-right':'5px'});
         			$("#timezone").on("click",timeZoneClick);
         
         			showLocal==0?($(".venuetime").fadeOut(0),$(".localtime").fadeIn(0)):($(".venuetime").fadeIn(0),$(".localtime").fadeOut(0));
         			//PENALTY SHOOTOUT ONLY
         			if (infoData[0].n_PeriodSort>=10&&infoData[0].n_HomeGoalsShootout!=null){
         				//if (lastPeriod==10){	
         				var pensH=(infoData[0].n_HomeGoalsShootout>=0)?infoData[0].n_HomeGoalsShootout:"";
         				var pensA=(infoData[0].n_AwayGoalsShootout>=0)?infoData[0].n_AwayGoalsShootout:"";
         				var penalties= txtArr[30]+" (" +pensH+ "-" +pensA+ ")";
         				if (infoData[0].n_HomeGoalsShootout>=0||infoData[0].n_AwayGoalsShootout>=0){
         						sym.getSymbol("matchtracker").$("penaltiesTxt").html(penalties);
         						sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0);
         					}
         			}	               							
         		}
         	});
         }
         
         var lastAction, lastTime, lastPeriod;
         function getMatch(matchID) { 
         	var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         	minutes.text("0"); 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var matchData = data;
         				if(matchData){
         					lastAction = matchData[0].n_ActionTime;
         					lastPeriod = matchData[0].n_PeriodSort;
         					var lastTimetxt;
         					sym.getSymbol("matchtracker").$("timer").empty();
         					//create display for each action	
         					var actionTxt, penTxt, HorA, actionSet, actionType, action, actionTime, actionMs, actionPeriod;
         					var keyTxt="<div class='action'>";
         					keyTxt+="<div class='key'><div class='actionImg' style='background-position:-60px -20px'></div> "+key[0]+"</div>";//goal
         					keyTxt+="<div class='key'><div class='actionImg' style='background-position:-60px -80px'></div> "+key[1]+"</div>";//pen
         					keyTxt+="<div class='key'><div class='actionImg' style='background-position:-60px 0px'></div> "+key[2]+"</div>";//sub
         					keyTxt+="<div class='key'><div class='actionImg' style='background-position:-60px -60px'></div> "+key[3]+"</div>";//yellow
         					keyTxt+="</div>";
         					sym.getSymbol("matchtracker").$("timer").append(keyTxt)
         					for (var i = 0; i <= matchData.length; i++) {
         						if (matchData[i].n_ActionTime>lastAction){
         							lastAction=matchData[i].n_ActionTime;
         						}
         						if (matchData[i].n_PeriodSort>lastPeriod){
         							lastPeriod=matchData[i].n_PeriodSort;
         						}         		        
         						actionSet = matchData[i].n_ActionSet;
         						actionType = matchData[i].n_ActionCode;
         						actionTime = (matchData[i].c_ActionMinute==null)?"":matchData[i].c_ActionMinute;
         						var HorA = (matchData[i].n_HomeOrAway==1)?"h":"a";
         						if (actionSet==1||actionSet==2||actionSet==3||actionSet==5){
         							actionMs = matchData[i].n_ActionTime;
         							actionPeriod = matchData[i].n_PeriodSort;
         							var actionTxt="<div class='action period"+actionPeriod+"' id=action"+i+"'>";//style by period
         							actionTxt+="<div class='personh' id='person"+i+"h'></div>";
         							actionTxt+="<div class='type' id='type"+i+"h'></div>";	
         							actionTxt+="<div class='actiontime' id='actionMins"+i+"'></div>";
         							actionTxt+="<div class='type' id='type"+i+"a'></div>";
         							actionTxt+="<div class='persona' id='person"+i+"a'></div>";
         							actionTxt+="</div>";
         							//then append each action (latest at top)
         							sym.getSymbol("matchtracker").$("timer").prepend(actionTxt);
         							var player=matchData[i].c_PersonShort;     
         							var sub=(matchData[i].n_ActionSet==5)?" (" + matchData[i].c_SubPersonShort + ")":"";
         							$('#person' + i + HorA).text(player+sub);
         							$('#actionMins' + i).text(actionTime);
         							//************ ACTION ICONS
         							switch (actionSet){
         								case 1: action =(actionType==12)?4:1; break;//pen:goal
         								case 2: action =(actionType==12)?4:5; break;//pen:miss
         								case 3: action =(actionType==2048)?3:2; break;//yellow:red
         								case 5: action=0; break;//sub
         							}
         							var imgHTML="<div class='actionImg' style='background-position:-60px "+(-20*action)+"px'></div>";
         							$('#type' + i + HorA).html(imgHTML);
         							//**********************
         						} //close if
         
         					$('.key').css({'display':'table-cell','font-style':'italic','padding-left':'5px'});
         					$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'Helvetica, Arial, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         					$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         					$(".period6, .period8").css({'background-color':'rgba(255,0,0,0.1)'});
         					$(".period10").css({'background-color':'rgba(255,40,0,0.3)'});
         					$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         					$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         					$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         					$(".actionImg").css({'display':'inline-block','background-image': 'url(images/artwork.png)','width':'20px','height':'20px','overflow':'hidden','background-repeat':'no-repeat'});
         					$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
         					} //close for 
         				}
         		},//close success 
         		error: function(){ 
         			console.log("Match not started");
         		}  	                                                  	           
         	}); //close ajax
         }
         function getTeams(matchID,home,away) {           
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").empty(); //PASS teamIDs to teamInterval
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").empty();
                     var teamData;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&q=teams&match="+matchID,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			teamData = data;
                  			if (!teamData){
         							getSquad(home,"home");
         							getSquad(away,"away");
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         							homeArr.length=0;awayArr.length=0;
         							homeArr=[1,2,3,4,5,6,7,8,9,10,11];awayArr=[1,2,3,4,5,6,7,8,9,10,11];
         							lineUpf(0);
                  			}else{
         							var coach,teamlist,team,hORa;
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[16]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[16]);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloaderh").fadeOut(0);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloadera").fadeOut(0);
         							for (var i = 0; i < teamData.length; i++) {		
         								if (teamData[i].n_HomeOrAway==1){
         									teamlist = "matchSquadh";
         									hORa='h';
         								}else if (teamData[i].n_HomeOrAway==-1){
         									teamlist = "matchSquada";
         									hORa='a';
         								}
         								if(teamData[i].b_StartingLineUp==true){//start get positions
         									var playerPosition=teamData[i].n_Position;
         									//attach to player on tactic diagram
         									hORa=='h'?sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players"+hORa.toUpperCase()).getSymbol("h"+tacticH).$("playerTxt"+playerPosition).html("<span>"+teamData[i].c_PersonShort+"</span>"):
         									sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players"+hORa.toUpperCase()).getSymbol("a"+tacticA).$("playerTxt"+playerPosition).html("<span>"+teamData[i].c_PersonShort+"</span>");
         									var arrayname=(teamData[i].n_HomeOrAway==1)?homeArr:awayArr;
         									arrayname[playerPosition-1]=teamData[i].c_PersonShort;//players into arrays
         									if(tacticSelected==0&&hORa=='h'){
         										sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").getSymbol("f"+tacticH).$("playerTxt"+playerPosition).html("<span>"+teamData[i].c_PersonShort+"</span>");
         									}else if(hORa=='a'){
         										sym.getSymbol("matchtracker").getSymbol("tactics").getSymbol("players").getSymbol("f"+tacticA).$("playerTxt"+playerPosition).html("<span>"+teamData[i].c_PersonShort+"</span>");
         									}
         								}//end
         								if (teamData[i].n_ActionSet<8){
         									if (teamData[i].n_ActionSet==4){
         										var lineupTxt = "<div class='lineup' id='lineup" + i + "'>";
         									} else if (teamData[i].n_ActionSet==5||teamData[i].n_ActionSet==6){
         										var lineupTxt = "<div class='substitute' id='lineup" + i + "'>";
         									}	
         										lineupTxt += "<div class='shirtNr' id='teamShirt" + i + "'></div>";
         										lineupTxt += "<div class='playerNm' id='teamPerson" + i + "'></div>";
         										lineupTxt += "</div>";
         										sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(lineupTxt);
         								}
         								if (teamData[i].n_FunctionType==16){
         									coach = "<div style='padding-left:3px'><b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'>" + teamData[i].c_PersonNatioShort + "</span></div>";
         									sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).prepend(coach);
         								}
         								sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).css({'font-family':'Helvetica, Arial, sans-serif','font-size':'13px'}); 
         								$('.lineup').css({'width':'100%','display':'inline-table','margin':'1px 0px 1px'});
         								$('.substitute').css({'width':'100%','display':'inline-table','font-style':'oblique'});
         								$('.shirtNr').css({'width':'10%','display':'table-cell','text-align':'left','padding-left':'3px'});  
         								$('.playerNm').css({'width':'90%','display':'table-cell','text-align':'left','padding-left':'5px'});                        
         								var actionMins;	                
         								if (teamData[i].c_ActionMinute==null){
         									actionMins="";
         								}else{
         									actionMins=" ("+ teamData[i].c_ActionMinute + ")";
         								}			
         								$('#teamShirt' + i).text(teamData[i].n_ShirtNr);
         								$('#teamPerson' + i).html(teamData[i].c_Person + actionMins);
         								$('#subPerson' + i).text(teamData[i].c_SubPersonShort);
         								var posn = teamData[i].n_Position;			
         							}
         						}
         					$(".players").css({'font-size':'12px','width':'auto'});
         					$(".centre").css({'width':'100%'});
         					$(".players span").css({'background-color':'rgba(255,255,255,0.6)','height':'13px','padding':'2px 3px 1px','border-radius':'6px'});
                  		},
                  		error:function(){//Aug10
         						getSquad(home,"home");
         						getSquad(away,"away");
                  		}
                  	});
         }
         
         function getSquad(team,homeOrAway){
         	sym.getSymbol("team").$("squadTable").empty();
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&squad="+team,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			squadData=data;
         			if(squadData.length>0){
         			for (var i = 0; i <squadData.length; i++) {
         				var shirtNr = (squadData[i].n_ShirtNr!=null)?squadData[i].n_ShirtNr:"";
         				var player = squadData[i].c_Person+" <span class='squadnat'>" + squadData[i].c_PersonNatioShort + "</span>";
         				var ycards = squadData[i].n_CardsYellow;
         				var rcards = squadData[i].n_CardsRed;
         				var cards = ycards + "/" + rcards;
         				var goals = squadData[i].n_Goals;
         				var starts = squadData[i].n_MatchesStart;
         				var goals = squadData[i].n_Goals;
         				var date = (squadData[i].d_BirthDate!=null)?getDDMMYY(squadData[i].d_BirthDate):'';
         				var position=squadData[i].n_FunctionCode;
         				var contractEnd=(squadData[i].d_ContractEndDate==null)?endDate:parsedDate(squadData[i].d_ContractEndDate);
         				if(todayTime<contractEnd){
         					if(homeOrAway){
         						var hORa=(homeOrAway=="home")?"h":"a";
         						if (position>0&&position<16){
         							var squadlist = "<div id='"+hORa+"player"+i+"' class='squadplayer'>";//Aug10
         							squadlist += "<div class='squadNo' id='"+hORa+"sqdshirt"+i+"'></div>";
         							squadlist += "<div class='squadNm' id='"+hORa+"sqdplayerName"+i+"'></div>";
         							squadlist += "</div>";
         						}
         						sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(squadlist);  
         						sym.getSymbol("matchtracker").getSymbol("teams").$("preloader"+hORa).fadeOut(0);              
         						$('#'+hORa+'player'+i).css({'width':'100%','font-size':'12px','display':'inline-table'});
         						$('.squadNo').css({'width':'10%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         						$('.squadNm').css({'width':'90%', 'padding-left':'3%','display':'table-cell'});
         						$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
         						$('#'+hORa+'sqdshirt'+i).text(shirtNr);
         						$('#'+hORa+'sqdplayerName'+i).html(player);
         					}else{
         						if (position>0&&position<16){
         							var squadlist = "<div id='player"+i+"' class='squadplayer'>";
         							squadlist += "<div class='squadCol1' id='sqdshirt"+i+"'></div><div class='squadCol2' id='sqdplayerName"+i+"'></div>";
         							squadlist += "<div class='squadCol5' id='sqddate"+i+"'></div><div class='squadCol3' id='sqdmatches"+i+"'></div>";
         							squadlist += "<div class='squadCol3' id='sqdcards"+i+"'></div><div class='squadCol4' id='sqdgls"+i+"'></div>";
         							squadlist += "</div>";
         						}else if(position==16){
         							sym.getSymbol("team").$("teamTxt1").prepend(txtArr[15]+player);
         						}
         						sym.getSymbol("team").$("squadTable").append(squadlist);
         						$('#player'+i).css({'width':'100%', 'display':'inline-table','border-bottom':'solid 1px rgba(100,100,100,0.5)','border-top':'solid 1px rgba(255,255,255,0.8)'});
         						$('#sqdplayerName'+i).css({'font-weight':400});
         						$('#sqdshirt'+i).text(shirtNr);
         						$('#sqdplayerName'+i).html(player);
         						$('#sqddate'+i).text(date);
         						$('#sqdmatches'+i).text(starts);
         						$('#sqdcards'+i).text(cards);
         						$('#sqdgls'+i).text(goals);
         					}
         				}
         			}
         			sym.getSymbol("matchtracker").getSymbol("teams").$("preloader"+hORa).fadeOut(0);
         			}else{
         				var squadlist = "<div id='player"+i+"' class='squadplayer'>";
         				squadlist += "<div class='squadCol1' id='sqdshirt'></div><div class='squadCol2' id='sqdplayerName'>"+txtArr[35]+"</div>";
         				squadlist += "<div class='squadCol5' id='sqddate'></div><div class='squadCol3' id='sqdmatches'></div>";
         				squadlist += "<div class='squadCol3' id='sqdcards'></div><div class='squadCol4' id='sqdgls'></div>";
         				squadlist += "</div>";
         				sym.getSymbol("team").$("squadTable").append(squadlist);
         			}
         		},
         		complete: function(){
         			$('.squadplayer').css({'font-size':'12px','font-family':'Helvetica, Arial, sans-serif'});
         			$('.squadCol1').css({'width':'5%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         			$('.squadCol2').css({'width':'50%', 'padding-left':'3%','display':'table-cell'});
         			$('.squadCol5').css({'width':'25%', 'display':'table-cell', 'text-align':'center','font-style':'italic'});
         			$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
         			$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
         			$('.squadnat').css({'text-align':'right','font-style':'oblique','font-size':'90%'});
         			initSize();
         		}
         	});
         }
           //PIE CHART
           function pieChart(hwins,awins,draws,placeholder){	
           							var data = [ {"label": txtArr[26],val:parseInt(awins,10)},
           							{"label": txtArr[27],val:draws},
           							{"label": txtArr[25],val:parseInt(hwins,10)}
           							];
           			var w = 300,
           				 h = 156,
           				 r = (Math.min(w, h) / 2)-30,
           				 labelr = r + 8, // radius for label anchor
           				 color = d3.scale.ordinal().range(["#006666","#4e9799","#33c5cc","#FF6666"]),
           				 donut = d3.layout.pie(),
           				 arc = d3.svg.arc().innerRadius(r * .6).outerRadius(r),
           				 textOffset=10;
           			var vis = d3.select(placeholder)
           			  .append("svg:svg")
           				 .data([data])
           				//.attr('transform', 'translate(' + w / 2 + ',' + h / 2 + ')')
           				 .attr("width", w)
           				 .attr("height", h);
         
           			var arcs = vis.selectAll("g.arc")
           				 .data(donut.value(function(d) { return d.val }).sort(null))
           			  .enter().append("svg:g")
           				 .attr("class", "arc")
           				.attr('transform', 'translate(' + w / 2 + ',' + (h+15)/2 + ')')
           			arcs.append("svg:path")
           				 .attr("fill", function(d, i) { return color(i); })
           				 .attr("d", arc);
           			var labels = arcs.append("svg:text")
           				 .attr("transform", function(d) {
           					  var c = arc.centroid(d),
           							x = c[0],
           							y = c[1],
           							// pythagorean theorem for hypotenuse
           							h = Math.sqrt(x*x + y*y);
           					  return "translate(" + (x/h * labelr) +  ',' +
           						  (y/h * labelr) +  ")"; 
           				 })
           				 .attr("dy", ".35em")
           				 .attr("text-anchor", function(d) {
           					  // are we past the center?
           					  return (d.endAngle + d.startAngle)/2 > Math.PI ?
           							"end" : "start";
           				 })
           				 .style("fill", "Black")
           					.style("font", "12px Helvetica")
           					//.style("background-color","Red")
           				 .text(function(d, i) {  
         						return data[i].val>0&&i==1?data[i].label+": "+ data[i].val:"";
         					});
           		//offset text
           			var prev;
           			labels.each(function(d, i) {
           				 if(i > 0) {
           					  var thisbb = this.getBoundingClientRect(),
           							prevbb = prev.getBoundingClientRect();
           					  // move if they overlap
           					  if(!(thisbb.right < prevbb.left || 
           								 thisbb.left > prevbb.right || 
           								 thisbb.bottom < prevbb.top || 
           								 thisbb.top > prevbb.bottom)) {
           							var ctx = thisbb.left + (thisbb.right - thisbb.left)/2,
           								 cty = thisbb.top + (thisbb.bottom - thisbb.top)/2,
           								 cpx = prevbb.left + (prevbb.right - prevbb.left)/2,
           								 cpy = prevbb.top + (prevbb.bottom - prevbb.top)/2,
           								 off = Math.sqrt(Math.pow(ctx - cpx, 2) + Math.pow(cty - cpy, 2))/2;
           							d3.select(this).attr("transform",
           								 "translate(" + Math.cos(((d.startAngle + d.endAngle - Math.PI) / 2)) * (r + textOffset + off) + "," + Math.sin((d.startAngle + d.endAngle - Math.PI) / 2) * (r + textOffset + off) + ")");
           					  }
           				 }
           				 prev = this;
           			});
            }
         
         function getH2H(match){
         	sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").html("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&q=h2hsum&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt3").fadeOut(0);
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").fadeOut(0);
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").fadeOut(0);
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").html(txtArr[14]);
         			h2hData = data;
         			if(h2hData.length>0&&h2hData[0].n_Matches>0){			
         				var hwins=h2hData[0].n_MatchesWonHome;
         				var awins=h2hData[0].n_MatchesWonAway;
         				var draws=h2hData[0].n_MatchesDrawn;
         				var hgoals=h2hData[0].n_GoalsForHome;
         				var agoals=h2hData[0].n_GoalsForAway;
         				var placeHolder="#Stage_matchtracker_h2hMc_h2hmatch";
         				pieChart(hwins,awins,draws,placeHolder);
         				if(hwins>0||(draws==0&&awins>0)){ sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").html(txtArr[25]+": <b>"+hwins+"</b>").fadeIn(0); }
         				if (awins>0||(draws==0&&hwins>0)){ sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").html(txtArr[26]+": <b>"+awins+"</b>").fadeIn(0); }
         				var barTxt="<div class='barGraph'>";
         					barTxt+="<div id='capGoals'></div>";
         				barTxt+="<div id='hbarGoals'></div>";
         				barTxt+="<div id='abarGoals'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").append(barTxt);
         				var hwidth=(hgoals/(hgoals+agoals)*100)+"%";
         				var awidth=(agoals/(hgoals+agoals)*100)+"%";
         				$("#hbarGoals").text(hgoals);
         				$("#abarGoals").text(agoals);
         				var acolor=(agoals==0)?'#33c5cc':'#006666';
         				var hcolor=(hgoals==0)?'#006666':'#33c5cc';
         				$("#capGoals").html(txtArr[28]);
         				$(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px','font-weight':700, 'display':'inline-table'});
         				$("#capGoals").css({'text-align':'center','width':'100%','display':'table-caption'});
         				$("#hbarGoals").css({'background-color':hcolor,'color':'#ffffff','padding-left':'5px','padding-top':'2px','text-align':'left', 'display':'table-cell','width':hwidth});
         				$("#abarGoals").css({'background-color':acolor,'color':'#ffffff','padding-right':'5px','padding-top':'2px','text-align':'right','width':awidth,'display':'table-cell'});
         			}else{
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").append("<div style='font-family:Helvetica, Arial, sans-serif;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         			}
         		}
         	});
         }
         
         function getmatchStats(match){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&q=stats&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder").empty();
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").empty();
         			matchData = data;
         			var bar;
         			var placeHolder="#Stage_matchtracker_matchStats_chartHolder";
         			function drawBar(){
         				var barTxt="<div class='barGraph'>";
         				barTxt+="<div id='cap"+bar+"'></div>";
         				barTxt+="<div id='hbar"+bar+"'></div>";
         				barTxt+="<div id='abar"+bar+"'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").append(barTxt);
         			}
         			if (matchData.length>0){
         				for (var i = 0; i < matchData.length; i++) {
         					if(matchData[i].n_ActionSet==13&&matchData[i].c_ActionShort=="BP"){//possession
         						var hPoss=matchData[i].n_HomePoints;
         						var aPoss=matchData[i].n_AwayPoints;
         						pieChart(hPoss,aPoss,0,placeHolder);
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("hpiTxt").html(hPoss+"%");
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("apiTxt").html(aPoss+"%");
         					}else if(matchData[i].n_ActionSet==12){
         						if(matchData[i].n_ActionSort==104){//on target
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="shots";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==106){//saves
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="saves";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==112){//fouls against
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="fouls";
         							drawBar();
         						}
         						var hwidth=(hPts/(hPts+aPts)*100)+"%";
         						var awidth=(aPts/(hPts+aPts)*100)+"%";
         						$("#hbar"+bar).text(hPts);
         						$("#abar"+bar).text(aPts);
         						$(".barGraph").css({'margin':'0px 0px 10px','font-family':'Helvetica, Arial, sans-serif','width':'100%','height':'20px','font-size':'13px', 'display':'inline-table'});
         						$("#cap"+bar).css({'text-align':'center','width':'100%','display':'table-caption','font-weight':700});
         						$("#hbar"+bar).css({'background-color':'#33c5cc','color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         						$("#abar"+bar).css({'background-color':'#006666','color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         					}
         						$("#capshots").html(txtArr[21]);
         						$("#capsaves").html(txtArr[22]);
         						$("#capfouls").html(txtArr[23]);
         				}
         			}
         		}
         	});
         }
         //TEAM BUTTONS
         //EDIT THE FOLLOWING	NUMBERS
         var thumbWidth=38; //distance between origin of thumbnail images
         var space = 40; //pixels offset at beginning of buttonstrip
         var ttime= 300; //transition time in milliseconds
         //END CHANGES
         //TOUCH / DRAG SLIDER Declare variables for use in touch functions
         var num=20; //total number of images
         var rail = sym.getSymbol("fixtures").$('teamBtnStrip');//--------HERE
         var railWidth, railX, railRightX, thumbs, moveStrip;
         var stripShow = sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns");//strip details
         var stripWidth = stripShow.width();
         var thumbs;
         function getRail(){
         railWidth = rail.width();//width of the slder
         thumbs = railWidth/thumbWidth; //number of thumbnails visible at same time
         railX = rail.offset().left; //distance from left hand side at which slider starts
         railRightX = railX + railWidth;
         moveStrip=(railRightX<800)?stripWidth-railWidth+thumbWidth:stripWidth-railWidth;
         }
         getRail();
         var startX=0;
         var moveIt=0
         var startPos=railX;
         rail.on("touchstart", touchStartX); //binds touch function to slider
         rail.on("touchmove", moveMe); //binds touch function to slider
         rail.on("mousedown", mouseMoveMe); //binds mouse function to slider
         function touchStartX(e){ //handle touch event
         		startX = e.touches[0].pageX;
         }	
         function moveMe(e) {
         	e.preventDefault(); //prevents it firing a click when touched
         	e.stopPropagation();
         	getRail();
         	var orig = e.originalEvent;
         	var pos = 0;
         	pos = orig.touches[0].pageX;
         	var moveDistance=startX-pos;
         	moveIt=startPos-moveDistance;
         	if(pos>=railX&&pos<=railRightX){
         		if(moveIt<=0&&moveIt>=-moveStrip){
         			stripShow.css({'left':moveIt});
         			sym.getSymbol("fixtures").$('fixTable').css({'left':moveIt});
         			sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$('fixBtn0').css({'left':moveIt});
         			sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$('fixBtn1').css({'left':moveIt+780});//800
         		}
         	}
         }
         function mouseMoveMe(e){ //handle mousedown event
         	e.preventDefault();
         	e.stopPropagation();
         	startX = e.pageX;
         	sym.getComposition().getStage().getSymbolElement().mousemove(handleMouseMove); //bind mousemove functions to stage in case cursor goes oustide the thumb
         	sym.getComposition().getStage().getSymbolElement().mouseup(handleMouseUp); //bind mouseup functions to stage 
         }	
         function handleMouseMove(jqEvent){//move using mouse
         	e.preventDefault(); //prevents it firing a mouse click when mousedown
         	e.stopPropagation();
         	getRail();
         	var pos = 0;
         	pos = jqEvent.pageX;
         	var moveDistance=startX-pos;	
         	moveIt=startPos-moveDistance; 
         	moveIt=Math.ceil(moveIt/thumbWidth)*thumbWidth;
         	if(pos>=railX&&pos<=railRightX){
         		if(moveIt<=0&&moveIt>=-moveStrip){
         			stripShow.css({'left':moveIt});
         			sym.getSymbol("fixtures").$('fixTable').css({'left':moveIt});
         			sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$('fixBtn0').css({'left':moveIt});
         			sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$('fixBtn1').css({'left':moveIt+780});//800
         		}
         	}
         }
         function handleMouseUp(jqEvent){ // handle mouseup event
         	sym.getComposition().getStage().getSymbolElement().unbind("mousemove");
         	sym.getComposition().getStage().getSymbolElement().unbind("mouseup");
         	startPos=moveIt;
         }
         function handleTouchUp(jqEvent){ // handle touchup event
         	sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         	sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         var mvStrip= function(x){//FWD BACK BUTTONS
         	return function(e){
         		getRail();
         		var moveAll=(x==1)?0:(railRightX<800)?railWidth-stripWidth-thumbWidth:railWidth-stripWidth;
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("teamBtns").stop().animate ({'left': moveAll},ttime); 
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn0").stop().animate ({'left': moveAll},ttime); 
         		sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn1").stop().animate ({'left': moveAll+780},ttime); //800
         		sym.getSymbol("fixtures").$('fixTable').stop().animate ({'left': moveAll}, ttime);
         	};
         };
         for (var i=0;i<2;i++){
         sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn"+i).on('click',mvStrip(i));
         sym.getSymbol("fixtures").getSymbol("teamBtnStrip").$("fixBtn"+i).css({'cursor':'pointer'});
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtns'
   (function(symbolName) {   
   
   })("MenuBtns");
   //Edge symbol end:'MenuBtns'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'StyleHead'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'TimeZone'
   (function(symbolName) {   
   
   })("TimeZone");
   //Edge symbol end:'TimeZone'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'Team'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4790, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Team");
   //Edge symbol end:'Team'

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'fixtures'
   (function(symbolName) {   
   
   })("fixtures");
   //Edge symbol end:'fixtures'

   //=========================================================
   
   //Edge symbol: 'TeamBtnStrip'
   (function(symbolName) {   
   
   })("TeamBtnStrip");
   //Edge symbol end:'TeamBtnStrip'

   //=========================================================
   
   //Edge symbol: 'Minimize'
   (function(symbolName) {   
   
   })("Minimize");
   //Edge symbol end:'Minimize'

   //=========================================================
   
   //Edge symbol: 'LatestTable'
   (function(symbolName) {   
   
   })("LatestTable");
   //Edge symbol end:'LatestTable'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'Match'
   (function(symbolName) {   
   
   })("Match");
   //Edge symbol end:'Match'

   //=========================================================
   
   //Edge symbol: 'A5'
   (function(symbolName) {   
   
   })("A5");
   //Edge symbol end:'A5'

   //=========================================================
   
   //Edge symbol: 'A7'
   (function(symbolName) {   
   
   })("A7");
   //Edge symbol end:'A7'

   //=========================================================
   
   //Edge symbol: 'A3'
   (function(symbolName) {   
   
   })("A3");
   //Edge symbol end:'A3'

   //=========================================================
   
   //Edge symbol: 'A1'
   (function(symbolName) {   
   
   })("A1");
   //Edge symbol end:'A1'

   //=========================================================
   
   //Edge symbol: 'Players'
   (function(symbolName) {   
   
   })("Players");
   //Edge symbol end:'Players'

   //=========================================================
   
   //Edge symbol: 'H6'
   (function(symbolName) {   
   
   })("H6");
   //Edge symbol end:'H6'

   //=========================================================
   
   //Edge symbol: 'F1_1'
   (function(symbolName) {   
   
   })("F2");
   //Edge symbol end:'F2'

   //=========================================================
   
   //Edge symbol: 'H4'
   (function(symbolName) {   
   
   })("H4");
   //Edge symbol end:'H4'

   //=========================================================
   
   //Edge symbol: 'H2'
   (function(symbolName) {   
   
   })("H2");
   //Edge symbol end:'H2'

   //=========================================================
   
   //Edge symbol: 'F0_1'
   (function(symbolName) {   
   
   })("F4");
   //Edge symbol end:'F4'

   //=========================================================
   
   //Edge symbol: 'H0'
   (function(symbolName) {   
   
   })("H0");
   //Edge symbol end:'H0'

   //=========================================================
   
   //Edge symbol: 'F1_1'
   (function(symbolName) {   
   
   })("F6");
   //Edge symbol end:'F6'

   //=========================================================
   
   //Edge symbol: 'HomePlayers_1'
   (function(symbolName) {   
   
      })("PlayersHome");
   //Edge symbol end:'PlayersHome'

   //=========================================================
   
   //Edge symbol: 'H8'
   (function(symbolName) {   
   
   })("H8");
   //Edge symbol end:'H8'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'Tactics'
   (function(symbolName) {   
   
   })("Tactics");
   //Edge symbol end:'Tactics'

   //=========================================================
   
   //Edge symbol: 'A8'
   (function(symbolName) {   
   
   })("A8");
   //Edge symbol end:'A8'

   //=========================================================
   
   //Edge symbol: 'A4'
   (function(symbolName) {   
   
   })("A4");
   //Edge symbol end:'A4'

   //=========================================================
   
   //Edge symbol: 'A6'
   (function(symbolName) {   
   
   })("A6");
   //Edge symbol end:'A6'

   //=========================================================
   
   //Edge symbol: 'A2'
   (function(symbolName) {   
   
   })("A2");
   //Edge symbol end:'A2'

   //=========================================================
   
   //Edge symbol: 'A0'
   (function(symbolName) {   
   
   })("A0");
   //Edge symbol end:'A0'

   //=========================================================
   
   //Edge symbol: 'H7'
   (function(symbolName) {   
   
   })("H7");
   //Edge symbol end:'H7'

   //=========================================================
   
   //Edge symbol: 'F0_1'
   (function(symbolName) {   
   
   })("F1");
   //Edge symbol end:'F1'

   //=========================================================
   
   //Edge symbol: 'H5'
   (function(symbolName) {   
   
   })("H5");
   //Edge symbol end:'H5'

   //=========================================================
   
   //Edge symbol: 'F0_1'
   (function(symbolName) {   
   
   })("F3");
   //Edge symbol end:'F3'

   //=========================================================
   
   //Edge symbol: 'F4_1'
   (function(symbolName) {   
   
   })("F5");
   //Edge symbol end:'F5'

   //=========================================================
   
   //Edge symbol: 'H3'
   (function(symbolName) {   
   
   })("H3");
   //Edge symbol end:'H3'

   //=========================================================
   
   //Edge symbol: 'F6_1'
   (function(symbolName) {   
   
   })("F7");
   //Edge symbol end:'F7'

   //=========================================================
   
   //Edge symbol: 'H1'
   (function(symbolName) {   
   
   })("H1");
   //Edge symbol end:'H1'

   //=========================================================
   
   //Edge symbol: 'PlayersA_1'
   (function(symbolName) {   
   
         })("PlayersAway");
   //Edge symbol end:'PlayersAway'

   //=========================================================
   
   //Edge symbol: 'Teams'
   (function(symbolName) {   
   
   })("Teams");
   //Edge symbol end:'Teams'

   //=========================================================
   
   //Edge symbol: 'H2hMc'
   (function(symbolName) {   
   
   })("H2hMc");
   //Edge symbol end:'H2hMc'

   //=========================================================
   
   //Edge symbol: 'F0'
   (function(symbolName) {   
   
   })("F0");
   //Edge symbol end:'F0'

   //=========================================================
   
   //Edge symbol: 'F7_1'
   (function(symbolName) {   
   
   })("F8");
   //Edge symbol end:'F8'

   //=========================================================
   
   //Edge symbol: 'example'
   (function(symbolName) {   
   
   })("example");
   //Edge symbol end:'example'

   //=========================================================
   
   //Edge symbol: 'MatchMenuBtn'
   (function(symbolName) {   
   
   })("MatchMenuBtn");
   //Edge symbol end:'MatchMenuBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews35479");