/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var RTL="false"; //select true if right to left
         var stageWidth, graphcolor="#e6e1d7", yel="rgba(255,210,50,0.75)", strap="rgba(93,115,120,1.00)", gnYear=2017, gn=34870;//2017 34870 gnYear=2016, gn=33835
         
         //ARRAYS
         var screenArr=['driverchampMc','teamChampMc','driversMc'];
         var teamArr=['FER','FOR','HAA','MLA','MER','RBR','REN','SAU','TOR','WIL'];//2016 'MER','FER','WIL','RBR','FOR','REN','TOR','SAU','MLA','MAN','HAA'
         var menuText=[];
         for (var i=0; i<4; i++){
         	menuText[i]= sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var capsText= sym.getSymbol("driversMc").$("detailstxt").css("pointer-events","none");
         sym.getSymbol("driverchampMc").$("driversTxt0").css("pointer-events","none");
         var teamText=[];
         for (var tt=0;tt<teamArr.length;tt++){
         	teamText[tt]=sym.getSymbol("driversMc").$("teamTxt"+tt).css("pointer-events","none");
         }
         var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         //ARRAY FOR CAPTIONS FROM XML			
         var months, headline, headlinemob, carStop;
         var champHead=[], teamTxtArr=[], driverTxtArr=[], caps=[], gpDate=[];
         for (var t=0;t<teamArr.length; t++){
         	teamTxtArr[t]=[]; driverTxtArr[t]=[];
         } 
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         $.ajax({	
         type: "GET",
         url: "GN35095.xml",
         dataType: "xml",
         success: function(xml) {
         	headline=$(xml).find('headline').text();
         	headlinemob=$(xml).find('headlinemob').text();
         	var source=$(xml).find('source').text();
         	sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         	graphcolor=$(xml).find('graphcolor').text();
         	var source=$(xml).find('source').text();
         	sourcetxt.html(source);
         	for (var i=0;i<menuText.length;i++){ //get menu labels
         	 menuTxtArr[i]= $(xml).find('menu'+i).text();
         	 menuText[i].html(menuTxtArr[i]);
         	}
         
         	for (var h=0;h<3;h++){
         		champHead[h]=$(xml).find('head'+h).text();
         	}
         	sym.getSymbol("driverchampMc").$("driversTxt0").html(champHead[1]);
         	caps[0]=$(xml).find('cap0').text(); //fixed text captions
         	caps[1]= $(xml).find('cap1').text();
         	caps[2]= $(xml).find('cap2').text();
         	capsText.html(caps[0]);
         	for (var t=0;t<teamArr.length;t++){	
         			$(xml).find("team"+t).each(function(){
         				var $teams = $(this);
         				for (var m=0; m<4; m++){
         					teamTxtArr[t][m] = $teams.find('teamCap'+m).text(); 	//get details for each team
         				}
         				$teams.find("driver").each(function(){
         					var $driver = $(this);
         					driverTxtArr[t].push($driver);
         				});
         			});
         		}
         		getStats('FER',2);
         		sym.getSymbol(screenArr[2]).$("driveCar"+carPos).css({'left':carStop+'px'});	
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("mainCar").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("reflection").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("driverHead").attr("src","drivers/"+teamArr[0]+".png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("bkwheel").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[2]).getSymbol("driveCar0").$("frwheel").attr("src","cars/"+teamArr[0]+"fr.png");
            },
            complete: function(){
         				initSize();
         	}
         }); // END XML
         //REFRESH RATE
         var seasonInterval, conInterval, driverInterval, gpInterval, phaseInterval;
         var latestGP, latestGPno;
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         for (var m = 0; m < 4; m++){
         	var menuBtnSymbols = sym.getSymbol("menuButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("menuButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.off ("click",menuBtnClick);
         	menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         });
         
         function resetmenu(){
         	sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         	sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-505px'},400);
         	for (var i=0; i<menuArray.length; i++){
                  menuArray[i].$("menuBg").fadeIn(0);
                 sym.getSymbol(screenArr[1]).$("carPic").animate ({'left':'-800px'}, 0);
         			sym.getSymbol(screenArr[2]).$("carPic").animate ({'left':'-800px'}, 0);
                 sym.$(screenArr[i]).fadeOut(200);       
         		}
         }
         //resetmenu();
         var raceIDno; //number to select live race
         var raceNo =0;
         var clicked;
         function menuBtnClick (e){
         		e.preventDefault();
         		e.stopPropagation();
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		if(menuMenu_id==0){//standings
         			if (clicked==0){
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         				clicked=1;
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-505px'},400);
         				clicked=0;
         			}
         		}else if(menuMenu_id==3){ //teams
         			if (clicked==3){
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-505px'},400);
         				clicked=1;
         			}else{
         				sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'40px'},400);
         				sym.getSymbol("menuButtons").$("menuBtn0xtra").stop().animate({'top':'-55px'},400);
         				clicked=3;
         			}
         		}else{
         			resetmenu(); //set them all back to normal state
         			clicked=menuMenu_id;
         			for (i=1;i<4;i++){
         				if (i==menuMenu_id){
         					if(menuMenu_id>0){
         						sym.$(screenArr[menuMenu_id-1]).fadeIn(200);
         						menuArray[i].$("menuBg").fadeOut(0);
         					}
         					if (menuMenu_id==1){ //drivers champs
         						getDriverStandings();
         					}
         					if (menuMenu_id==2){ //team champs
         						getConsStandings();
         						sym.getSymbol(screenArr[1]).$("carPic").delay(200).stop().animate ({left:carStop}, 800, 'easeOutCirc');	
         						sym.getSymbol(screenArr[1]).getSymbol("carPic").play();
         					}	
         				}else{
         					if (menuMenu_id!=0){
         						sym.$(screenArr[i]).fadeOut(400);
         					}
         				}														
         			}
         
         		}
         }
         menuArray[3].$("menuBg").fadeOut(0);
         //******************************* RESPONSIVE *****************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	var scaleCar=stageWidth/600;
         	sym.getSymbol("teamChampMc").$("carPic").css({'transform':'scale('+0.88*scaleCar+','+0.88*scaleCar+')'});
         	for (var i=0;i<2;i++){
         	 sym.getSymbol("driversMc").$("driveCar"+i).css({'transform':'scale('+scaleCar+','+scaleCar+')'});
         	}
         	var carWidth=sym.getSymbol("teamChampMc").$("carPic").width();
         	carStop=(stageWidth-carWidth)/2;
         	sym.getSymbol("teamChampMc").$("carPic").css({'left':carStop+'px'});
         	sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':carStop+'px'});
         	if(stageWidth<=480){
         		sym.getSymbol('styleMc').$('headlinetxt').html(headlinemob);
         		sym.getSymbol("driversMc").$("teamTxt1").css({'top':'395px'});sym.getSymbol("driversMc").$("teamTxt3").css({'top':'370px'});
         		$(".driverShort").fadeIn(0); $(".driver, .rankLogo").fadeOut(0);
         		mob=1;
         	}else{
         		sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         		sym.getSymbol("driversMc").$("teamTxt1").css({'top':'345px'});sym.getSymbol("driversMc").$("teamTxt3").css({'top':'324px'});
         		$(".driverShort").fadeOut(0); $(".driver, .rankLogo").fadeIn(0);
         		mob=0;
         	}
         	if(stageWidth>=640){
         	}else{
         	}
         	//buttons centre icons
         	var menuWidth=sym.$("menuButtons").width()/2;
         	for (var i=0;i<menuArray.length;i++){
         		sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").css({'left':(menuWidth-37)/2+'px'});
         	}
         	for (var j=0;j<teamArr.length;j++){
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({'left':(menuWidth-42)/2+'px'});
         	}
         };
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //***************************** END RESPONSIVE ***********************************
         //TEAM STRIP BUTTONS	
         var carPos=0, hidden=1, teamIndex=0;//for showTeam
         sym.getSymbol("driversMc").$("nextBtn").on("click",nextTeam); sym.getSymbol("driversMc").$("lastBtn").on("click",lastTeam);
         sym.$("driversMc").on("swipeleft",nextTeam); sym.$("driversMc").on("swiperight",lastTeam);
         function nextTeam(){
         	$(".prevnext").fadeOut(0);
         	teamIndex=(teamIndex==9)?0:teamIndex+1;
         	teamDetails(teamArr[teamIndex]);
         }
         function lastTeam(){
         	$(".prevnext").fadeOut(0);
         	teamIndex=(teamIndex==0)?9:teamIndex-1;
         	teamDetails(teamArr[teamIndex]);
         }    
         var showTeam = function(team){ //to handle lexical scope
         	return function (e) {
         		teamDetails(team);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         function teamDetails(teamdetails){
         	resetmenu();
         	teamIndex=teamArr.indexOf(teamdetails);
         	sym.$(screenArr[2]).fadeIn(200);
         	menuArray[3].$("menuBg").fadeOut(0);
         	getStats(teamdetails,2);
         	carPos=(carPos==0)?(hidden=0,1):(hidden=1,0);
               sym.getSymbol("driversMc").$("teamlogo").attr("src","images/"+teamdetails+"bg.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':'-200%'});	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("mainCar").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("reflection").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("driverHead").attr("src","drivers/"+teamdetails+".png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("bkwheel").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("frwheel").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar0").$("bkwheelR").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar0").$("frwheelR").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).delay(1600).stop().animate ({left:carStop}, 1100);	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).play();
         		sym.getSymbol("driversMc").$("driveCar"+hidden).stop().animate ({left:'110%'}, 1200);
         		sym.getSymbol("driversMc").getSymbol("driveCar"+hidden).play();
         		var team=teamdetails;
         		initSize();
         		$(".prevnext").stop().delay(1200).fadeIn(1200);
         }
         for (var j=0;j<teamArr.length;j++){ //Create team buttons
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({"cursor":'pointer'});
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).click(showTeam(teamArr[j],teamTxtArr[j][0]));
         }
         //GET GP SEASON
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         //GET Start list if race hasn't started
         function getStartList(){
         $.ajax({ type: "GET", 
         						url: dataURL,
                         data: "gn="+gn+"&yr="+gnYear+"&q=startlist&race=",
                         contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                         async: true,
                         crossDomain: true,
                         success: function (data) {
         						var startData=data;
         						 if (startData.length>20){
         							barHeight = ((500/startData.length)-2);
         						 }else{
         							barHeight = 23;
         						 }
         						for (var i=0; i<startData.length; i++){
         							if(i==0){ //show lead driver details
         								var drivershort = startData[i].c_PersonShort;
         								var driverID = startData[i].n_PersonID;
         								var imgCar = startData[i].c_TeamShort;
         								var leadDriver = '<b>' +startData[i].c_Person+ '</b> ' +startData[i].c_NOCShort+ '</span>';
         								sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         								sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         							}	
         							var tableText ="<div class='driverschamp'>";
         							tableText += "<div id='driverdata"+i+"'>";
         							tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         							tableText += "<td id='driverrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         							tableText += "<td id='driverNm"+i+"'width='150px'></td>";
         							tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         							tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         							tableText += "</tr></table>";
         							tableText += "</div></div>";
         							sym.getSymbol("driverchampMc").$("graph").append(tableText);
                  $('#driverrnk' + i).text(startData[i].c_ShirtNr);		
         			$('#driverNm' + i).text(startData[i].c_Person);
                  $('#driverteam' + i).text(startData[i].c_Team);
                  if (i==0){
         				$('#driverpts' + i).text("0"+caps[1]);
         			}else{
         				$('#driverpts' + i).text("0");
         			}
                  $(".driverschamp").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'2px'});
         			$("#driverdata" + i).css({'height':barHeight+'px','width':'65%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px','box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         			$("#driverdata" + i).animate({width:scale+'%'},1500);
                 }
         		}
         	});
         }
         var barHeight;
         var nRaceDrivers;
         var maxPoints;
         var scale;
         function getDriverStandings(){
         	$.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&q=champdrivers&yr="+gnYear+"&race=",
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
         				var rankData = data;
         					sym.getSymbol("driverchampMc").$("loading").hide();
         					sym.getSymbol("driverchampMc").$("graph").empty();
         					if (rankData.length<1){
         						getStartList();
         					}else{
         					//Ensure all drivers will fit in graph
         					nRaceDrivers = rankData.length;
         					if (rankData.length>20){
         					barHeight = ((500/rankData.length)-2);
         					}else{
         					barHeight = 23;
         					}
         					//calculate relative length of each bar
         					maxPoints = rankData[0].n_PointsSort;
         					var min = (maxPoints!=null) ? maxPoints : 0;
         					for (var n=0; n<rankData.length; n++) {
         						if (rankData[n].n_PointsSort!=null && rankData[n].n_PointsSort<min) {
         							min = rankData[n].n_PointsSort;									
         						}
         					}					
         					for (var i = 0; i < rankData.length; i++) {
         						if(i==0){ //show lead driver details
         							var drivershort = rankData[i].c_PersonShort;
         							var driverID = rankData[i].n_PersonID;
         							var imgCar = rankData[i].c_TeamShort;
         							var leadDriver = '<b>' +rankData[i].c_Person+ '</b> ' +rankData[i].c_NOCShort+ '</span>';
         							sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         							sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         						}	
         						var tableText ="<div class='driverschamp'>";
         						tableText += "<div id='driverdata"+i+"' class='driverbar'>";
         						tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         						tableText += "<td id='driverrnk"+i+"' width='25px' style='font-weight:bold'></td>";
         						tableText += "<td class='driver' id='driverNm"+i+"'width='140px'></td>";
         						tableText += "<td class='driverShort' id='driverNmSht"+i+"'width='110px'></td>";
         						tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         						tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         						tableText += "</tr></table>";
         						tableText += "</div></div>";
         						sym.getSymbol("driverchampMc").$("graph").append(tableText);
         						var teamLogo='<img class="teamsmall" src="images/'+ rankData[i].c_TeamShort +'.png" width="16px">';
         						if (rankData[i].n_Rank!=null){
         							$('#driverrnk' + i).text(rankData[i].n_Rank);
         						}else{
         						 $('#driverrnk' + i).text(i+1);
         						}         	
         						$('#driverNmSht' + i).text((rankData[i].c_PersonShort).toUpperCase());
         						$('#driverNm' + i).text(rankData[i].c_Person);
         						$('#driverteam' + i).html(teamLogo);
         						if (rankData[i].c_Points!=null){
         							if (i==0&&caps[12]!=undefined){
         								$('#driverpts' + i).text(rankData[i].c_Points+caps[1]);
         							}else{
         								$('#driverpts' + i).text(rankData[i].c_Points);
         							}	
         						}else{
         							$('#driverpts' + i).text("0");
         						}          		
         						if (maxPoints==min && rankData[i].n_PointsSort==maxPoints) {
         							scale=100;
         						}else if(rankData[i].n_PointsSort==null){
         							scale=50;
         						}else{
         							scale = 100-((maxPoints-rankData[i].n_PointsSort)*45/(maxPoints-min));
         						}
         						$("#driverdata" + i).css({'height':barHeight+'px','width':'50%'});
         						$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         						$("#driverdata" + i).animate({'width':scale+'%'},800,'easeOutQuad');
         					}
         				$(".driverschamp").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%', 'margin-bottom':'2px','line-height':'120%'});
         				$(".driverbar").css({'background-color':graphcolor, 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         				$("img.teamsmall").css({'margin-bottom':'-2px','width':'16px'});
         			}
         		},
         		complete:function(){
         			initSize();
         		}
         	});
         	setTimeout(getDriverStandings,600000);
         }
         getDriverStandings();
         var nTeams;
         var teamBar;
         function getConsStandings(){
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=champteams&yr="+gnYear+"&race=",
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) {
         		var teamData = data;
         		sym.getSymbol("menuButtons").$("menuBtn2").off('click',menuBtnClick);//disable button
         		if (teamData.length<1){//if championship hasn't started
         			sym.getSymbol("menuButtons").$("menuBtn2").on ("click", {menuId:3}, menuBtnClick);
         		}else{
         			sym.getSymbol("menuButtons").$("menuBtn2").on ("click", {menuId:2}, menuBtnClick);
         			sym.getSymbol("teamChampMc").$("loading").css({'display':'none'});
         			sym.getSymbol("teamChampMc").$("graph").empty();
         			//Ensure all teams will fit in graph
         			nTeams = teamData.length;
         			if (teamData.length>=10){
         				teamBar = ((260/teamData.length)-2);
         			}else{
         				teamBar = 25;
         			}
         			//calculate relative length of each bar
         			teamPoints = teamData[0].n_PointsSort;
         			var minpts = (teamPoints!=null) ? teamPoints : 0;
         			for (var n=0; n<teamData.length; n++) {
         						if (teamData[n].n_PointsSort!=null && teamData[n].n_PointsSort<minpts) {
         							minpts = teamData[n].n_PointsSort;									
         						}
         			}	
         			for (var i = 0; i < teamData.length; i++) {
         				teamname=teamData[i].c_TeamShort;
         				longname=teamData[i].c_Team;
         				if(i==0){ //show lead team details
         					var imgCar = teamData[i].c_TeamShort;
         					sym.getSymbol("teamChampMc").getSymbol("carPic").$("mainCar").attr("src","cars/"+imgCar+"big.png");
         					sym.getSymbol("teamChampMc").getSymbol("carPic").$("reflection").attr("src","cars/"+imgCar+"big.png");
         					sym.getSymbol("teamChampMc").getSymbol("carPic").$("driverHead").attr("src","drivers/"+imgCar+".png");
         					sym.getSymbol("teamChampMc").getSymbol("carPic").$("bkwheel").attr("src","cars/"+imgCar+"bk.png");
         					sym.getSymbol("teamChampMc").getSymbol("carPic").$("frwheel").attr("src","cars/"+imgCar+"fr.png");
         					getStats(teamname,1);
         				}
         				var teamindex=teamArr.indexOf(teamname);
         				var teamtxt=teamTxtArr[teamindex][0];				
         				var constructorsText ="<div class='teamchamp'>";
         				constructorsText += "<div id='teamdata"+i+"' class='teambar'>";
         				constructorsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				constructorsText += "<td id='teamrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         				constructorsText += "<td class='teamLogo' width='20px' id='teamLogo"+i+"'></td>";
         				constructorsText += "<td id='teamNm"+i+"'></td>";
         				constructorsText += "<td id='teampts"+i+"' style='font-weight:bold'></td>";
         				constructorsText += "</tr></table>";
         				constructorsText += "</div></div>";
         				sym.getSymbol("teamChampMc").$("graph").append(constructorsText);
         				var teamLogo='<img class="teamsmall" src="images/'+ teamData[i].c_TeamShort +'.png" width="16px">';
         					if (teamData[i].n_Rank!=null){
         						$('#teamrnk' + i).text(teamData[i].n_Rank);
         					}else{
         						$('#teamrnk' + i).text(i+1);
         					} 		
         					//$('#teamNm' + i).text(teamData[i].c_Team.toUpperCase());
         					$('#teamNm' + i).text(teamtxt);
         					$('#teamLogo' + i).html(teamLogo);
         					if(teamData[i].c_Points!=null){
         						if (i==0){
         							$('#teampts' + i).text(teamData[i].c_Points+caps[1]);
         						}else{
         							$('#teampts' + i).text(teamData[i].c_Points);
         						}
         					}else{
         						$('#teampts' + i).text("0");
         					}				                                   
         					if (teamPoints==minpts && teamData[i].n_PointsSort==teamPoints) {
         						scale=100;
         					}else if(teamData[i].n_PointsSort==null){
         						scale=58;
         					}else{
         						scale = 100-((teamPoints-teamData[i].n_PointsSort)*42/(teamPoints-minpts));
         					}
         					$("#teamdata" + i).css({'height':teamBar+'px','width':'55%'});
         					$("#teamdata" + i).stop().animate({'width':scale+'%'},800,'easeOutQuad');
         					$("#teampts" + i).css({'text-align':'right', 'padding-right':'3px'});
         				}
         				$(".teamchamp").css({'font-size':'13px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'99%','margin-bottom':'2px','line-height':'120%'});
         				$(".teambar").css({'background-color':graphcolor, 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)','padding-top':'2px'});
         				$("img.teamsmall").css({'margin-bottom':'-2px','width':'16px'});
         			}
         		},
         		complete:function(){
         			initSize();
         		}
         	});
         	setTimeout(getConsStandings,600000);
         }
         getConsStandings();
         var flag1txt, flag2txt;
         function getStats(teamdetails,view){//show team facts from xml arrays
         	sym.getSymbol(screenArr[view]).$("teamTxt0").css({'font-weight':700});	//team name	
         	var headprefix=(view==2)?champHead[1]+": ":"";
         	for (var i=0;i<teamArr.length;i++){
         		if (teamdetails==teamArr[i]){
         			sym.getSymbol(screenArr[view]).$("teamTxt0").html((view==2)?teamTxtArr[i][0]:champHead[2]);//if view=3 Constructors else team name
         			sym.getSymbol(screenArr[view]).$("teamTxt1").html(teamTxtArr[i][1]);
         			sym.getSymbol(screenArr[view]).$("teamTxt2").html("<i>"+caps[2]+": "+teamTxtArr[i][2]+"</i>");
         			sym.getSymbol(screenArr[view]).$("teamTxt3").html(teamTxtArr[i][3]);
         
         			//create array of each team in xml, 
         			for (var n=0;n<2;n++){
         					var number=driverTxtArr[i][n].find('d0').text();var name =driverTxtArr[i][n].find('d1').text();
         					var stats=driverTxtArr[i][n].find('d2').text();var nat=driverTxtArr[i][n].find('d3').text();
         					var id = driverTxtArr[i][n].find('driverid').text().toString();
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt0").html(number);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt1").html(name);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt2").html(nat);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt3").html(stats);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverflag").attr("src","images/"+nat+".gif");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverpic").attr("src","drivers/"+id+".jpg");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverHelmet").attr("src","drivers/"+id+".png");
         			}
         		}
         	}
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Bg'
   (function(symbolName) {   
   
   })("Bg");
   //Edge symbol end:'Bg'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'ChampionshipMc'
   (function(symbolName) {   
   
   })("DriverChampMc");
   //Edge symbol end:'DriverChampMc'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtn_1'
   (function(symbolName) {   
   
   })("RaceBtn");
   //Edge symbol end:'RaceBtn'

   //=========================================================
   
   //Edge symbol: 'DriveCar'
   (function(symbolName) {   
   
   })("DriveCar");
   //Edge symbol end:'DriveCar'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Home'
   (function(symbolName) {   
   
   })("Home");
   //Edge symbol end:'Home'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'DriversMc'
   (function(symbolName) {   
   
   })("DriversMc");
   //Edge symbol end:'DriversMc'

   //=========================================================
   
   //Edge symbol: 'TeamDriverMc'
   (function(symbolName) {   
   
   })("TeamDriverMc");
   //Edge symbol end:'TeamDriverMc'

   //=========================================================
   
   //Edge symbol: 'TeamChampMc'
   (function(symbolName) {   
   
   })("TeamChampMc");
   //Edge symbol end:'TeamChampMc'

   //=========================================================
   
   //Edge symbol: 'TeamButtonStrip'
   (function(symbolName) {   
   
   })("TeamButtonStrip");
   //Edge symbol end:'TeamButtonStrip'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews35095");