/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var scene = 0;
         	var scenePath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"#ebebec", "padding":"5px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var redTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"#fff",
         	"background-color":"#da0000", "height":"auto", "width":"auto", "padding":"7px"};
         
         	var blackTxtBox = {"border-radius":"5px", "color":"#fff", "background-color":"rgba(0,0,0,0.3)", "height":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<13; i++){
         		txt[i] = sym.getSymbol("scene0").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=13; i<17; i++){
         		txt[i] = sym.getSymbol("scene1Key").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=17; i<32; i++){
         		txt[i] = scenePath.getSymbol("scene1").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=32; i<37; i++){
         		txt[i] = scenePath.getSymbol("island1").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=37; i<41; i++){
         		txt[i] = scenePath.getSymbol("island0").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=41; i<45; i++){
         		txt[i] = scenePath.getSymbol("island2").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=45; i<47; i++){
         		txt[i] = sym.getSymbol("key").$("txt"+i).css({"pointer-events":"none", 'height':'auto'});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34961.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<47; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			sym.getSymbol("scene0").$("txt2").css(redTxtBox);
         			sym.getSymbol("scene0").$("txt12").css({'line-height':'20px'});
         			sym.getSymbol("scene1Key").$("txt14").css({'line-height':'18px'});
         			sym.getSymbol("scene1Key").$("txt15").css({'line-height':'18px'});
         			sym.getSymbol("scene1Key").$("txt16").css({'line-height':'18px'});
         			scenePath.getSymbol("scene1").$("txt17").css(redTxtBox);
         			scenePath.getSymbol("scene1").$("txt22").css(redTxtBox);
         			scenePath.getSymbol("scene1").$("txt24").css(redTxtBox);
         			scenePath.getSymbol("scene1").$("txt30").css({'line-height':'20px'});
         			scenePath.getSymbol("island1").$("txt35").css({'line-height':'21px'});
         			scenePath.getSymbol("island0").$("txt40").css({'line-height':'21px'});
         			scenePath.getSymbol("island2").$("txt41").css(blackTxtBox);
         			scenePath.getSymbol("island2").$("txt43").css({'line-height':'21px'});
         			scenePath.getSymbol("scene1").$("txt17").css({'left':224-scenePath.getSymbol("scene1").$("txt17").width()-10});
         			sym.getSymbol("key").$("txt45").css({'line-height':'24px'});
         
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("standTxt").css({"width":stageWidth-10+"px"});
         	sym.$("closeBtn").css({"left":stageWidth-40+"px"});
         	sym.$("standBtn").css({"left":stageWidth-40+"px"});
         
         	sym.getSymbol("scrollMc").$("scrollableMc").css({'width':stageWidth+'px'});
         	sym.getSymbol("key").$("txt46").css({'width':stageWidth-(stageWidth/4)+'px'});
         	sym.getSymbol("key").$("plane").css({'top':sym.getSymbol("key").$("txt46").height()+60+'px'});
         	sym.$("key").css({'height':sym.getSymbol("key").$("txt46").height()+(stageWidth/3)+'px'});
         	
         	sym.$("scrollMc").css({'left':'0px'});
         
         	if (scene == 3){ 
         		sym.$("scrollMc").css({'left':(stageWidth-420)/2+'px'});
         		sym.getSymbol("scrollMc").$("scrollableMc").css({'width':'420px'});
         		scenePath.getSymbol("island1").$("txt36").css({"width":400+'px'});
         	}
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		if (scene == 4){
         			scenePath.getSymbol("island2").$("txt41").css({'width':stageWidth-150+'px'});
         		}
         		sym.$("scene0").css({"left":(stageWidth-640)/2+17+"px"});
         	}else{
         		if (scene == 4){
         			scenePath.getSymbol("island2").$("txt41").css({'width':stageWidth-250+'px'});
         		}
         		sym.$("scene0").css({"left":(stageWidth-640)/2+"px"});
         	}
         	if (stageWidth<420){
         		if (scene==3){
         			sym.$("scrollMc").css({'left':'0px'});
         			sym.getSymbol("scrollMc").$("scrollableMc").css({'width':stageWidth+'px'});
         			scenePath.getSymbol("island1").$("txt36").css({"width":(stageWidth-20)+'px'});
         		}
         	}else{
         
         	}
         	setStyle();
         	closeSource();
         	standOut();
         }
         
         //********************************************************************************************************
         // SCENE0 BTN
         //********************************************************************************************************
         sym.getSymbol("scene0").$("btnRnd").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol('scene0').play(0);
         	sym.$('scene0').fadeOut(500);
         	scenePath.$('scene1').fadeIn(500);
         	sym.$('scene1Key').fadeIn(500);
         	scene=1;
         	initSize();
         });
         
         //********************************************************************************************************
         // ISLAND0 BTN
         //********************************************************************************************************
         scenePath.getSymbol('scene1').$("islandBtn0").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$('scene1Key').fadeOut(500);
         	scenePath.$('scene1').fadeOut(500);
         	scenePath.$('island0').fadeIn(500);
         	scene=2;
         	sym.$("scrollMc").animate ({scrollLeft:0}, 200, 'easeInCubic');
         	initSize();
         	checkKeyClicked();
         });
         
         //********************************************************************************************************
         // ISLAND1 BTN
         //********************************************************************************************************
         scenePath.getSymbol('scene1').$("islandBtn1").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$('scene1Key').fadeOut(500);
         	scenePath.$('scene1').fadeOut(500);
         	scenePath.$('island1').fadeIn(500);
         	scene=3;
         	sym.$("scrollMc").animate ({scrollLeft:0}, 200, 'easeInCubic');
         	initSize();
         	checkKeyClicked();
         });
         
         //********************************************************************************************************
         // ISLAND2 BTN
         //********************************************************************************************************
         scenePath.getSymbol('scene1').$("islandBtn2").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$('scene1Key').fadeOut(500);
         	scenePath.$('scene1').fadeOut(500);
         	scenePath.$('island2').fadeIn(500);
         	scene=4;
         	sym.$("scrollMc").animate ({scrollLeft:0}, 200, 'easeInCubic');
         	initSize();
         	checkKeyClicked();
         });
         
         //********************************************************************************************************
         // CLOSE BTN
         //********************************************************************************************************
         sym.$("closeBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (scene>1){
         		scene=2;
         	}
         	scene--;
         	if (scene==1){
         		sym.$('scene1Key').fadeIn(0);
         		scenePath.$('scene1').fadeIn(0);
         		fadeIslands();
         		scene=1;
         		checkStandClicked();
         		initSize();
         	}
         	if (scene==0){
         		sym.$('scene1Key').fadeOut(0);
         		sym.$('scene0').fadeIn(500);
         		sym.getSymbol('scene0').playReverse();
         		scenePath.$('scene1').fadeOut(0);
         		scenePath.$('island1').fadeOut(0);
         		scene=0;
         		checkStandClicked();
         		initSize();
         	}
         	
         	initSize();
         	sym.$("scrollMc").animate ({scrollLeft:0}, 200, 'easeInCubic');
         });
         
         function fadeIslands(){
         	scenePath.$('island0').fadeOut(500);
         	scenePath.$('island1').fadeOut(500);
         	scenePath.$('island2').fadeOut(500);
         }
         fadeIslands();
         
         //********************************************************************************************************
         // STANDBTN
         //********************************************************************************************************
         var standVis = false;
         var standClicked = false;
         var keyVis = false;
         var keyClicked = false;
         
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (scene<2){
         		if (standVis == false){
         			sym.$("standTxt").stop().animate ({top:41}, 400, 'easeOutCubic');
         			sym.$("standBtn").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         			sym.getSymbol("standBtn").stop(999);
         			standVis = true;
         			standClicked = true;
         			checkStandClicked();
         		}else{
         			standOut();
         		}
         	}
         	if (scene>1){
         		if (keyVis == false){
         			sym.$("key").stop().animate ({top:41}, 400, 'easeOutCubic');
         			sym.$("standBtn").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         			sym.getSymbol("standBtn").stop(999);
         			keyVis = true;
         			keyClicked = true;
         			checkKeyClicked();
         		}else{
         			standOut();
         		}
         	}
         });
         
         function standOut(){
         	sym.$("standTxt").stop().animate ({top:-400}, 400, 'easeInCubic');
         	sym.$("key").stop().animate ({top:-400}, 400, 'easeInCubic');
         	sym.$("standBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         	standVis = false;
         	keyVis = false;
         }
         standOut();
         
         function checkStandClicked(){
         	if (standClicked == false){
         		sym.getSymbol("standBtn").play(0);
         		sym.getSymbol("standBtn").$('bg').css({'background-color':'#da0000'});
         	}else{
         		sym.getSymbol("standBtn").stop(999);
         		sym.getSymbol("standBtn").$('bg').css({'background-color':'#da0000'});
         	}
         }
         function checkKeyClicked(){
         	if (keyClicked == false){
         		sym.getSymbol("standBtn").play(0);
         		sym.getSymbol("standBtn").$('bg').css({'background-color':'orange'});
         	}else{
         		sym.getSymbol("standBtn").stop(999);
         		sym.getSymbol("standBtn").$('bg').css({'background-color':'orange'});
         	}
         }
         sym.getSymbol("standBtn").play(0);
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("key").getSymbol("plane").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	sym.$("scrollMc").css({'overflow-y':'hidden', 'overflow-x':'auto'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'scene1'
   (function(symbolName) {   
   
   })("scene1");
   //Edge symbol end:'scene1'

   //=========================================================
   
   //Edge symbol: 'scene1_1'
   (function(symbolName) {   
   
   })("scene0");
   //Edge symbol end:'scene0'

   //=========================================================
   
   //Edge symbol: 'btnRnd'
   (function(symbolName) {   
   
   })("btnRnd");
   //Edge symbol end:'btnRnd'

   //=========================================================
   
   //Edge symbol: 'scene1_1'
   (function(symbolName) {   
   
   })("scene1Key");
   //Edge symbol end:'scene1Key'

   //=========================================================
   
   //Edge symbol: 'island0'
   (function(symbolName) {   
   
   })("island1");
   //Edge symbol end:'island1'

   //=========================================================
   
   //Edge symbol: 'scene1_1'
   (function(symbolName) {   
   
      })("island0");
   //Edge symbol end:'island0'

   //=========================================================
   
   //Edge symbol: 'island0_1'
   (function(symbolName) {   
   
      })("island2");
   //Edge symbol end:'island2'

   //=========================================================
   
   //Edge symbol: 'key'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("key");
   //Edge symbol end:'key'

   //=========================================================
   
   //Edge symbol: 'plane'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("plane");
   //Edge symbol end:'plane'

   //=========================================================
   
   //Edge symbol: 'jet'
   (function(symbolName) {   
   
   })("jet");
   //Edge symbol end:'jet'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34961");