/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0, check = 0, correct = 0, replayNo = 0, quiz0 = 0, quiz1 = 0, quiz2 = 0;
         	var timePath = sym.getSymbol('playMc').getSymbol('timerMc');
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	var green  = {"background-color":"#00a651"};
         
         //********************************************************************************************************
         // ADD BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){
         		var iconNo = symbolInTheArray.getVariable("id");
         }
         
         for (var i = 0; i < 12; i++){
          var mySymbolObject = sym.getSymbol('startScreen').createChildSymbol("startPic", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         for (var i=0; i<imageSymbolArray.length; i++){
         	for (var t=0; t<3; t++){
         		imageSymbolArray[i].$("images"+t).stop().animate ({top:-137*i}, 0);
         	}
         }
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.getSymbol("startScreen").getSymbol("startInfo").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("startScreen").getSymbol("startInfo").getSymbol("greenBtn").$("gbTxt").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({'height':'auto', "pointer-events":"none"});
         	for (var i=6; i<17; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[], data=[], quizEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34955.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<17; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			sym.getSymbol("startScreen").getSymbol("startInfo").$("txt0").css({'height':'auto', "line-height":"20px"});
         			sym.getSymbol("startScreen").getSymbol("startInfo").$("greenBtn").css({'top':sym.getSymbol("startScreen").getSymbol("startInfo").$("txt0").height()+30+"px"});
         			sym.getSymbol("startScreen").$("startInfo").css({'height':sym.getSymbol("startScreen").getSymbol("startInfo").$("txt0").height()+80+"px"});
         
         			$(xml).find("data").each(function(){
         			var $quiz=$(this);
         			quizEvents.push($quiz);
         			changeQuestions();//NEW
         			changeData();
         		});
         	},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         var questionDat=[], answer0Dat=[], answer1Dat=[], answer2Dat=[], answerDat=[], correctDat=[], monthDat=[];
         
         function changeQuestions(){
         		questionDat=[]; answer0Dat=[]; answer1Dat=[]; answer2Dat=[]; answerDat=[];correctDat=[];//Clear arrays
         		var $events=quizEvents[0].find('quiz');
         		$events.each(function(){
         			var $event=$(this);
         			var monthdat=$event.find("month").text();
         			monthDat.push(monthdat);
         
         			var $eventsNo=quizEvents[0].find('questionNo'+replayNo);
         
         			for (var h=0; h<3; h++){
         				sym.getSymbol('playMc').getSymbol('mainImage').$("images"+h).fadeOut(0);
         			}
         			sym.getSymbol('playMc').getSymbol('mainImage').$("images"+replayNo).fadeIn(0);
         
         			for (var i=0; i<imageSymbolArray.length; i++){
         				for (var t=0; t<3; t++){
         					imageSymbolArray[i].$("images"+t).fadeOut(0);
         					imageSymbolArray[i].$("images"+replayNo).fadeIn(0);
         				}
         			}
         
         			$eventsNo.each(function(){
         				var $q=$(this);
         				var questiondat=$q.find("question").text();
         				questionDat.push(questiondat);
         				var answer0dat=$q.find("answer0").text();
         				answer0Dat.push(answer0dat);
         				var answer1dat=$q.find("answer1").text();
         				answer1Dat.push(answer1dat);
         				var answer2dat=$q.find("answer2").text();
         				answer2Dat.push(answer2dat);
         				var answerdat=$q.find("answer").text();
         				answerDat.push(answerdat);
         				var correctdat=$q.find("correct").text();
         				correctDat.push(correctdat);
         			});
         		});
         }
         
         function changeData() {
         		sym.getSymbol("nextInfo").$("answerTxt").css({'height':'auto'});
         		sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]);
         		//sym.$("nextInfo").css({'height':'0px', 'height':90+ sym.getSymbol("nextInfo").$("answerTxt").height() +60+'px'});
         		sym.$("nextInfo").css({'height':90+ sym.getSymbol("nextInfo").$("answerTxt").height() +60+'px'});
         		sym.getSymbol("nextInfo").$("greenBtn").css({'top':'0px', 'top':sym.getSymbol("nextInfo").$("answerTxt").height() +105+'px'});
         
         		sym.getSymbol('playMc').$("qTxt").html('<b>'+monthDat[clicked]+'</b>' +' '+ questionDat[clicked]);
         		sym.getSymbol('playMc').getSymbol('btn0').$("aTxt").html(answer0Dat[clicked]);
         		sym.getSymbol('playMc').getSymbol('btn1').$("aTxt").html(answer1Dat[clicked]);
         		sym.getSymbol('playMc').getSymbol('btn2').$("aTxt").html(answer2Dat[clicked]);
         		for (var h=0; h<3; h++){
         			sym.getSymbol('playMc').getSymbol('mainImage').$("images"+h).stop().animate ({top:-300*clicked}, 0);
         		}
         		checkRTL();
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("startScreen").css({"width":stageWidth+"px"});
         	sym.getSymbol("startScreen").$("startInfo").css({"left":stageWidth/2-125+"px"});
         	sym.$("nextInfo").css({"left":stageWidth/2-125+"px"});
         	sym.$("fireworks").css({"left":(stageWidth-186)/2+"px"});
         	sym.getSymbol('playMc').$('mainImage').css({"width":stageWidth-30+"px"});
         	sym.getSymbol('playMc').$('overlayRight').css({"left":stageWidth-465+"px"});
         	for (var h=0; h<3; h++){
         		sym.getSymbol('playMc').getSymbol('mainImage').$("images"+h).css({"left":(stageWidth-480)/2+"px"});
         	}
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         
         	setStyle();
         	closeSource();
         	checkRTL();
         	for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         		imageSymbolArray[i].getSymbolElement().css({'width':stageWidth/3+'px'});
         		for (var t=0; t<3; t++){
         			imageSymbolArray[i].$("images"+t).stop().animate ({left:(stageWidth/3)-imageSymbolArray[i].$("images"+t).width()+40}, 0);
         		}
         	}
         }
         
         //********************************************************************************************************
         // START QUIZ BUTTON
         //********************************************************************************************************
         sym.getSymbol("startScreen").getSymbol("startInfo").$("greenBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$("startScreen").fadeOut(300);
         	startTimer();
         });
         
         //********************************************************************************************************
         // NEXT BUTTON
         //********************************************************************************************************
         sym.getSymbol("nextInfo").$("greenBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++
         	changeData();
         	startTimer();
         	resetmenu();
         	if (clicked == 12){
         			sym.$("startScreen").fadeOut(300);
         			clicked=0;
         			correct=0;
         			check=0;
         			startTimer();
         			changeQuestions();//NEW
         			changeData();
         			for (var h=0; h<12; h++){
         				sym.getSymbol("nextInfo").$("dot" + h).css(grey);
         			}
         		}
         });
         
         //********************************************************************************************************
         // ANSWER BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("playMc").getSymbol("btn" + h).$("bgBox").css(white);
         		sym.getSymbol('playMc').getSymbol('btn' + h).$("aTxt").css({'color':'black'});
         	}
         }
         resetmenu();
         
         // BUTTON CLICKED
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stopTimer();
         		sym.$("nextInfo").fadeIn(200);
         		check = menuNo;
         		resetmenu();
         		showResult();
         		closeSource();
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("playMc").$("btn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("playMc").$("btn"+b).css({'cursor':'pointer'});
         }
         
         function showResult(){
         	sym.getSymbol("playMc").getSymbol("btn" + correctDat[clicked]).$("bgBox").css(green);
         	sym.getSymbol('playMc').getSymbol('btn' + correctDat[clicked]).$("aTxt").css({'color':'white'});
         	sym.getSymbol("nextInfo").$("txt3").empty();
         	if (check == correctDat[clicked]){
         		correct++;
         		if (replayNo==0){ quiz0++; }
         		if (replayNo==1){ quiz1++; }
         		if (replayNo==2){ quiz2++; }
         		sym.getSymbol("nextInfo").$("dot" + clicked).css(green);
         		sym.getSymbol("nextInfo").$("txt3").html(txtArr[2]);
         		}else{
         			sym.getSymbol("nextInfo").$("dot" + clicked).css(red);
         			sym.getSymbol("playMc").getSymbol("btn" + check).$("bgBox").css(red);
         			sym.getSymbol("nextInfo").$("txt3").html(txtArr[3]);
         		}
         		if (clicked == 11){
         			var totalScore=quiz0+quiz1+quiz2;
         			sym.$("startScreen").fadeIn(200);
         			sym.getSymbol("startScreen").$("startInfo").fadeOut(0);
         			sym.getSymbol("nextInfo").$("txt3").html(correct +' '+ txtArr[5] + ' 12');
         				if (correct>10){
         					sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[10]+'<br>'+txtArr[12]);
         					sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[4]);
         					sym.$("bravo")[0].play();
         					replayNo++;
         					if(replayNo==2){
         						sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[10]+'<br>'+txtArr[16]);
         					}
         					if(replayNo==3){
         						if(totalScore>30){
         							sym.$("trophy").fadeIn(0);sym.getSymbol("trophy").play(0);
         							sym.$("fireworks").fadeIn(0);sym.getSymbol("fireworks").play(0);
         						}
         						sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+ "<div style='font-size:18px; border-radius:6px; padding:10px; background-color:#da0000; color:#fff; line-height:20px'>"+"<b>"+totalScore+'</b>'+' '+txtArr[5]+'<b> 36</b>'+"</div>"+'<br>'+txtArr[15]);
         						sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[11]);
         					}
         				}
         				if (correct>7&&correct<=10){
         					sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[9]+'<br>'+txtArr[12]);
         					sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[4]);
         					replayNo++;
         					if(replayNo==2){
         						sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[9]+'<br>'+txtArr[16]);
         					}
         					if(replayNo==3){
         						if(totalScore>30){
         							sym.$("trophy").fadeIn(0);sym.getSymbol("trophy").play(0);
         							sym.$("fireworks").fadeIn(0);sym.getSymbol("fireworks").play(0);
         							sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[11]);
         							sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+"<div style='font-size:18px; border-radius:6px; padding:10px; background-color:#da0000; color:#fff; line-height:20px'>"+"<b>"+totalScore+"</b>"+" "+txtArr[5]+"<b> 36</b>"+"</div>"+'<br>'+txtArr[15]);
         						}else{
         							sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[6]);
         							sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+"<div style='font-size:18px; border-radius:6px; padding:10px; background-color:#da0000; color:#fff; line-height:20px'>"+"<b>"+totalScore+"</b>"+" "+txtArr[5]+"<b> 36</b>"+"</div>"+'<br>'+txtArr[15]);
         						}
         					}
         				}
         				if (correct>4&&correct<=7){
         					sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[8]+'<br>'+txtArr[13]);
         					sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[6]);
         					//if(replayNo==3){
         					if(replayNo==2){
         						sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[8]+'<br>'+txtArr[14]);
         					}
         					if (replayNo==0){ quiz0=0; }
         					if (replayNo==1){ quiz1=0; }
         					if (replayNo==2){ quiz2=0; }
         				}
         				if (correct<=4){
         					sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[7]+'<br>'+txtArr[13]);
         					sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").html(txtArr[6]);
         					sym.$("klaxon")[0].play();
         					if(replayNo==2){
         						sym.getSymbol("nextInfo").$("answerTxt").html(answerDat[clicked]+'<br><br>'+txtArr[8]+'<br>'+txtArr[14]);
         					}
         					if (replayNo==0){ quiz0=0; }
         					if (replayNo==1){ quiz1=0; }
         					if (replayNo==2){ quiz2=0; }
         				}	
         				if(replayNo==3){
         					replayNo=0;quiz0=0;quiz1=0;quiz2=0;
         				}
         				sym.getSymbol("nextInfo").$("answerTxt").css({'text-align':'center', 'line-height':'16px'});
         			}else{
         				sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").empty();
         				sym.getSymbol("nextInfo").getSymbol("greenBtn").$("gbTxt").append(txtArr[4]);
         				sym.getSymbol("nextInfo").$("answerTxt").css({'text-align':'center','font-size':'14px', 'line-height':'16px'});
         				if (RTL == true){
         					sym.getSymbol("nextInfo").$("answerTxt").css({'text-align':'right'});
         			}
         		}
         		console.log(replayNo + ": " + quiz0 + " " + quiz1 + " " + quiz2 );
         		sym.$("nextInfo").css({'height':'0px', 'height':90+ sym.getSymbol("nextInfo").$("answerTxt").height() +60+'px'});
         		if (sym.$("trophy").is(":visible")){ 
         		sym.$("nextInfo").css({'top':'60px'}); 
         		}else{ 
         		sym.$("nextInfo").css({'top':(542-sym.$("nextInfo").height())/2+'px'}); 
         		}
         		sym.getSymbol("nextInfo").$("greenBtn").css({'top':'0px', 'top':sym.getSymbol("nextInfo").$("answerTxt").height() +105+'px'});
         }
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
           timePath.play(0);
           sym.$("nextInfo").fadeOut(200);
           sym.$("mask").fadeOut(200);
           sym.$("trophy").fadeOut(0);sym.$("fireworks").fadeOut(0);
         }
         function startReplay() {
         	var pos = timePath.getPosition();
         	if (pos == 20000) {
         		stopTimer();
         		noAnswer();
         	}
         }
         function stopTimer() {
         	clearInterval(timer);
         	timePath.stop();
         	sym.$("nextInfo").fadeIn(200);
         	sym.$("mask").fadeIn(200);
         }
         function noAnswer(){
         	check=4;
         	showResult();
         	clearInterval(timer);
         }
         sym.$("nextInfo").fadeOut(200);
         sym.$("mask").fadeOut(200);
         
         //********************************************************************************************************
         // RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		sym.getSymbol("nextInfo").$("answerTxt").css({'text-align':'right'});
         		sym.getSymbol('playMc').$("qTxt").css({'text-align':'right'});
         		sym.getSymbol('playMc').getSymbol('btn0').$("aTxt").css({'text-align':'right'});
         		sym.getSymbol('playMc').getSymbol('btn1').$("aTxt").css({'text-align':'right'});
         		sym.getSymbol('playMc').getSymbol('btn2').$("aTxt").css({'text-align':'right'});
         	}
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("playMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("startScreen").css({'overflow-y':'hidden', 'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'startScreen'
   (function(symbolName) {   
   
   })("startScreen");
   //Edge symbol end:'startScreen'

   //=========================================================
   
   //Edge symbol: 'mainImage'
   (function(symbolName) {   
   
   })("mainImage");
   //Edge symbol end:'mainImage'

   //=========================================================
   
   //Edge symbol: 'startInfo'
   (function(symbolName) {   
   
   })("startInfo");
   //Edge symbol end:'startInfo'

   //=========================================================
   
   //Edge symbol: 'playMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("playMc");
   //Edge symbol end:'playMc'

   //=========================================================
   
   //Edge symbol: 'btn'
   (function(symbolName) {   
   
   })("btn");
   //Edge symbol end:'btn'

   //=========================================================
   
   //Edge symbol: 'greenBtn'
   (function(symbolName) {   
   
   })("greenBtn");
   //Edge symbol end:'greenBtn'

   //=========================================================
   
   //Edge symbol: 'timerMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20000, function(sym, e) {
         sym.getComposition().getStage().checkAnswer();

      });
      //Edge binding end

   })("timerMc");
   //Edge symbol end:'timerMc'

   //=========================================================
   
   //Edge symbol: 'startPic'
   (function(symbolName) {   
   
   })("startPic");
   //Edge symbol end:'startPic'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'startInfo_1'
   (function(symbolName) {   
   
      })("nextInfo");
   //Edge symbol end:'nextInfo'

   //=========================================================
   
   //Edge symbol: 'trophy'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("trophy");
   //Edge symbol end:'trophy'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'starburst_red'
   (function(symbolName) {   
   
   })("starburst_red");
   //Edge symbol end:'starburst_red'

   //=========================================================
   
   //Edge symbol: 'starburst_group'
   (function(symbolName) {   
   
   })("starburst_group");
   //Edge symbol end:'starburst_group'

   //=========================================================
   
   //Edge symbol: 'star_yellow_arm'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("star_yellow_arm");
   //Edge symbol end:'star_yellow_arm'

   //=========================================================
   
   //Edge symbol: 'star_purple_arm'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 626, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("star_purple_arm");
   //Edge symbol end:'star_purple_arm'

   //=========================================================
   
   //Edge symbol: 'star_red_arm'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 690, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("star_red_arm");
   //Edge symbol end:'star_red_arm'

   //=========================================================
   
   //Edge symbol: 'star_blue_arm'
   (function(symbolName) {   
   
      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("star_blue_arm");
   //Edge symbol end:'star_blue_arm'

   //=========================================================
   
   //Edge symbol: 'starburst_yellow'
   (function(symbolName) {   
   
   })("starburst_yellow");
   //Edge symbol end:'starburst_yellow'

   //=========================================================
   
   //Edge symbol: 'starburst_blue'
   (function(symbolName) {   
   
   })("starburst_blue");
   //Edge symbol end:'starburst_blue'

   //=========================================================
   
   //Edge symbol: 'starburst_green'
   (function(symbolName) {   
   
   })("starburst_green");
   //Edge symbol end:'starburst_green'

   //=========================================================
   
   //Edge symbol: 'starburst_purple'
   (function(symbolName) {   
   
   })("starburst_purple");
   //Edge symbol end:'starburst_purple'

   //=========================================================
   
   //Edge symbol: 'star_green_arm'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 565, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("star_green_arm");
   //Edge symbol end:'star_green_arm'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34955");