/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false;
         	var rows = 5;
         	var columns = 4;
         	var items = rows*columns;
         	var clicked = 0;
         	
         	var btnNo = 0;
         	var speed = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var mainColour
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"background-color":"rgba(255,255,255,1)", 'color':'#999', "height":"auto", "padding":"5px"};
         
         //********************************************************************************************************
         // ADD BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < items; i++){
          var mySymbolObject = sym.createChildSymbol("holderMain", "dateBtnsMc");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          	imageSymbolArray.push(mySymbolObject);  //push it into the array
          	imageSymbolArray[i].$('btnStroke').fadeOut(0);
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){dateClicked(symbolInTheArray);});
         })
         
         for (var i=0; i<items; i++){
         	imageSymbolArray[i].getSymbolElement().animate ({width:64, left:64 * i}, 0);
         	imageSymbolArray[i].$('btnStroke').css ({'width':'56px', 'height':'35px'});
         	imageSymbolArray[i].$('stroke').animate ({width:60, height:60}, 0);
         	imageSymbolArray[i].$('images10').animate ({width:64, height:450, top:-45 * i}, 0);
         	imageSymbolArray[i].$('images20').animate ({width:64, height:450, top:-45 * (i-10)}, 0);
         }
         
         function dateClicked (symbolInTheArray){ //a function to call to make sure we know it’s working!
          	clicked = symbolInTheArray.getVariable("id");
          	resetClicked();
         }
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var gadgets=[], gadget=[], pictureSource=[], headName=[], captionTxt=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34954.xml",
         		dataType: "xml",
         		success: function(xml) {
         			mainColour = $(xml).find('mainColour').text();
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         
         			sym.getSymbol("dateNavBtnBack").$("btnBg").css({"background-color":mainColour});
         			sym.getSymbol("dateNavBtnBackOut").$("btnBg").css({"background-color":'#999'});
         			sym.getSymbol("dateNavBtnNext").$("btnBg").css({"background-color":mainColour});
         			sym.getSymbol("dateNavBtnNextOut").$("btnBg").css({"background-color":'#999'});
         			sym.getSymbol("menuBtnMob").$("bg").css({"background-color":mainColour});
         
         			for (var i=0; i<items; i++){
         				imageSymbolArray[i].$('btnStroke').css ({'border-color':mainColour});
         			}
         
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			$(xml).find("gadgets").each(function(){
         			var $gadget=$(this);
         			gadget.push($gadget);
         			});
         			changeEvent();
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         function changeEvent() {
         		var $events=gadget[0].find('gadget');
         		$events.each(function(){
         			var $event=$(this);
         			var picturesource=$event.find("picture").text();
         			pictureSource.push(picturesource);
         			var headname=$event.find("name").text();
         			headName.push(headname);
         			var captiontxt=$event.find("txt").text();
         			captionTxt.push(captiontxt);
         		});
         		loadCaption();
         }
         
         function loadCaption(){
         	sym.$("caption").empty();
         	var html = "<div style='font-size:20px; font-weight:400; line-height: 20px; color:#999'>"+'<b>'+headName[clicked]+'</b>'+" "+"</div><div style='padding-bottom:5px; padding-top:5px; color:#333'>"+captionTxt[clicked]+"</div>";
         	sym.$("caption").append(html).css(blackTxtBox);
         }
         
         //********************************************************************************************************
         // ADD START SCREEN BUTTONS
         //********************************************************************************************************
         imageSymbolArray3 = []; //the array that will hold references to your new symbols.
         
         function traceSelected3 (symbolInTheArray3){
          	sym.$('startScreen').fadeOut(100);
          	clicked = symbolInTheArray3.getVariable("id");
          	resetClicked();
         }
         
         for (var i = 0; i < items; i++){
          var mySymbolObject3 = sym.getSymbol('startScreen').createChildSymbol("holderMain", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject3.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray3.push(mySymbolObject3);  //push it into the array
          imageSymbolArray3[i].$('btnStroke').fadeOut(0);
         }
         
         $.each(imageSymbolArray3, function( count, symbolInTheArray3 ){ //a 'for each' loop through the newly populated array.
          var menuItem3 = $(symbolInTheArray3); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement3 = $(symbolInTheArray3.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement3.bind ("click",function(){traceSelected3(symbolInTheArray3);});
         })
         
         //********************************************************************************************************
         // LOAD IMAGES
         //********************************************************************************************************
         imageSymbolArray2 = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i <items; i++){
          var mySymbolObject2 = sym.createChildSymbol("holderMain", "holder");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject2.setVariable("id", i);  //set the value of a Symbol variable
          	imageSymbolArray2.push(mySymbolObject2);  //push it into the array
          	imageSymbolArray2[i].$('stroke').fadeOut(0);
          	imageSymbolArray2[i].$('btnStroke').fadeOut(0);
         }
         
         
         
         //********************************************************************************************************
         // RESET ON CLICK
         //********************************************************************************************************
         function resetClicked(){
         	speed = 500;
         	sym.$("menuBtnMob").fadeIn(0);
         	for (var i=0; i<imageSymbolArray.length; i++){
          		imageSymbolArray[i].$("bg").css({'background-color':'#7d93bc'});
          		imageSymbolArray[i].$('btnStroke').fadeOut(0);
          	}
          	imageSymbolArray[clicked].$("bg").css({'background-color':'#2e4b82'});
          	imageSymbolArray[clicked].$('btnStroke').fadeIn(0);
          	sym.$("caption").empty();
         	sym.$("caption").css('height','');
         	sym.$("caption").css('height','auto');
         	loadCaption();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").empty();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','auto');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source +'<br>'+ pictureSource[clicked]);
         
          	sym.$("dateNavBtnBack").fadeIn(0);
          	sym.$("dateNavBtnNext").fadeIn(0);
         
          	if (clicked>(items-2)){
          		sym.$("dateNavBtnNext").fadeOut(0);
          	}
          	if (clicked<1){
          		sym.$("dateNavBtnBack").fadeOut(0);
          	}
          	initSize();
          	checkRTL();
          	closeSource();
         }
         resetClicked();
         
         //******************************************************************************************************************************************
         // CHECK RTL
         //******************************************************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		for (var i=0; i<imageSymbolArray.length; i++){
         			imageSymbolArray[i].getSymbolElement().animate ({width:64, left:(64*(items-1))-(64 * i)}, 300, 'easeOutCubic');
         		}
         
         		for (var i=0; i<imageSymbolArray2.length; i++){
         			imageSymbolArray2[i].getSymbolElement().css({'left':-stageWidth*i + 'px'});
         		}
         
         		sym.$('holder').stop().animate ({left:clicked * (stageWidth)}, speed, 'easeOutCubic');
         		sym.$("dateBtnsMc").stop().animate({scrollLeft: (64*(items-1))-(clicked*64)-(stageWidth-120)/2+32}, 500);
         
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'left':stageWidth-640+'px'});
         
         		sym.$("dateNavBtnNext").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnNextOut").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnBack").css({'left':stageWidth-60+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$("dateNavBtnBackOut").css({'left':stageWidth-60+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         
         		sym.$("caption").css({'text-align':'right'});
         		sym.$("menuBtnMob").css({'left':'0px'});
         	}
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("dateBtnsMc").stop().animate({width:stageWidth-120}, 0);
         	sym.$("dateBtnsMc").stop().animate({scrollLeft: (clicked*64)-(stageWidth-120)/2+32}, 500);
         	sym.$("dateNavBtnNext").css({'left':stageWidth-60+'px'});
         	sym.$("dateNavBtnNextOut").css({'left':stageWidth-60+'px'});
         
         	for (var i=0;i<imageSymbolArray3.length;i++){
         		imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'left', 'height':542/rows+'px', 'width':stageWidth/columns+'px'});
         		imageSymbolArray3[i].$("images10").css ({'top':-(542/rows)*i+'px', 'width':640/columns+'px', 'height':542/rows*10+'px', 'left':(stageWidth/(columns*2))-(640/(columns*2))+'px'}, 0);
         		imageSymbolArray3[i].$("images20").css ({'top':-(542/rows)*(i-10)+'px', 'width':640/columns+'px', 'height':542/rows*10+'px', 'left':(stageWidth/(columns*2))-(640/(columns*2))+'px'}, 0);
         		imageSymbolArray3[i].$('stroke').css({'width':(stageWidth/columns)-2+'px','height':(542/rows)-2+'px'});
         		imageSymbolArray3[i].$('stroke').fadeOut(0);
         	}
         
         	for (var i=0; i<imageSymbolArray2.length; i++){
         		imageSymbolArray2[i].getSymbolElement().css({'width':stageWidth+'px', 'height':(stageWidth/1.45)+'px', 'left':stageWidth * i+'px'});
         		imageSymbolArray2[i].$('images10').css ({'top':(-stageWidth/1.45) * i+'px', 'width':stageWidth+'px', 'height':'1000%'});
         		imageSymbolArray2[i].$('images20').css ({'top':(-stageWidth/1.45) * (i-10)+'px', 'width':stageWidth+'px', 'height':'1000%'});
         	}
         
         	sym.$('holder').stop().animate ({left:clicked * (-stageWidth)}, speed, 'easeOutCubic');
         	imgHeight = imageSymbolArray2[0].$("imgHolder").height();
         	txtHeight = sym.$("caption").height();
         
         	if (480 - (stageWidth/1.45) > sym.$("caption").height()){
         		sym.$("caption").css({'top':(stageWidth/1.45)+45+'px'});
         	} else {
         		sym.$("caption").css({'top':520-txtHeight+'px'});
         	}
         
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         
         	checkRTL();
         	setStyle();
         	speed = 0;
         	closeSource();
         }
         
         
         //******************************************************************************************************************************************
         // ARROW BUTTONS
         //******************************************************************************************************************************************
         sym.$("dateNavBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	resetClicked();
         	});
         sym.$("dateNavBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	resetClicked();
         	});
         
         //******************************************************************************************************************************************
         // SWIPE
         //******************************************************************************************************************************************
         sym.$("mask").on("swipeleft",function(){
         	clicked++;
         	if (clicked>items-1){
         		clicked = items-1;
         	} else {
         		resetClicked();
         	}
         });
         sym.$("mask").on("swiperight",function(){
         	clicked--;
         	if (clicked<0){
         		clicked = 0;
         	} else {
         		resetClicked();
         	}
         });
         
         //******************************************************************************************************************************************
         // MENU BUTTON
         //******************************************************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	sym.$("startScreen").fadeIn(100);
         	sym.$("menuBtnMob").fadeOut(0);
         	closeSource();
         });
         sym.$("menuBtnMob").fadeOut(0);
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("dateBtnsMc").css({'overflow-x':'hidden', 'overflow-y':'hidden'});
         	sym.$("startScreen").css({'overflow-y':'hidden', 'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************
         

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'stageBtnsMc'
   (function(symbolName) {   
   
   })("stageBtnsMc");
   //Edge symbol end:'stageBtnsMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn'
   (function(symbolName) {   
   
   })("stageNavBtn");
   //Edge symbol end:'stageNavBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'holderMain'
   (function(symbolName) {   
   
   })("holderMain");
   //Edge symbol end:'holderMain'

   //=========================================================
   
   //Edge symbol: 'startScreen'
   (function(symbolName) {   
   
   })("startScreen");
   //Edge symbol end:'startScreen'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34954");