/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false;
         	var rows = 4;
         	var columns = 3;
         	var items = rows*columns;
         	var clicked = 0;
         	var startVis = true;
         	var btnPath = sym.getSymbol('startScreen').$('btnsMc');
         	var btnNo = 0;
         	var speed = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var mainColour
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"5px"};
         
         	var blackTxtBox = {"background-color":"rgba(255,255,255,1)", 'color':'#999', "height":"auto", "padding":"5px"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var gadgets=[], gadget=[], pictureSource=[], headName=[], captionTxt=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34942.xml",
         		dataType: "xml",
         		success: function(xml) {
         			mainColour = $(xml).find('mainColour').text();
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         
         			sym.getSymbol("dateNavBtnBack").$("btnBg").css({"background-color":mainColour});
         			sym.getSymbol("dateNavBtnBackOut").$("btnBg").css({"background-color":'#999'});
         			sym.getSymbol("dateNavBtnNext").$("btnBg").css({"background-color":mainColour});
         			sym.getSymbol("dateNavBtnNextOut").$("btnBg").css({"background-color":'#999'});
         			sym.getSymbol("menuBtnMob").$("bg").css({"background-color":mainColour});
         
         			for (var i=0; i<items; i++){
         				imageSymbolArray3[i].$('btnStroke').css ({'border-color':mainColour});
         			}
         
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			$(xml).find("gadgets").each(function(){
         			var $gadget=$(this);
         			gadget.push($gadget);
         			});
         			changeEvent();
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         function changeEvent() {
         		var $events=gadget[0].find('gadget');
         		$events.each(function(){
         			var $event=$(this);
         			var picturesource=$event.find("picture").text();
         			pictureSource.push(picturesource);
         			var headname=$event.find("name").text();
         			headName.push(headname);
         			var captiontxt=$event.find("txt").text();
         			captionTxt.push(captiontxt);
         		});
         		loadCaption();
         }
         
         function loadCaption(){
         	sym.$("caption").empty();
         	var html = "<div style='font-size:20px; font-weight:400; padding:5px; color:gray'>"+'<b>'+headName[clicked]+'</b>'+" "+"</div><div style='padding:5px; color:#333'>"+captionTxt[clicked]+"</div>";
         	sym.$("caption").append(html).css(blackTxtBox);
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source +" "+ pictureSource[clicked]);
         }
         
         //********************************************************************************************************
         // ADD START SCREEN BUTTONS
         //********************************************************************************************************
         imageSymbolArray3 = []; //the array that will hold references to your new symbols.
         
         function traceSelected3 (symbolInTheArray3){
          	clicked = symbolInTheArray3.getVariable("id");
          	resetClicked();
          	initSize();
         }
         
         for (var i = 0; i < items; i++){
          var mySymbolObject3 = sym.getSymbol('startScreen').createChildSymbol("holderMain", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject3.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray3.push(mySymbolObject3);  //push it into the array
          imageSymbolArray3[i].$('btnStroke').fadeOut(0);
         }
         
         $.each(imageSymbolArray3, function( count, symbolInTheArray3 ){ //a 'for each' loop through the newly populated array.
          var menuItem3 = $(symbolInTheArray3); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement3 = $(symbolInTheArray3.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement3.bind ("click",function(){traceSelected3(symbolInTheArray3);});
         })
         
         //********************************************************************************************************
         // LOAD IMAGES
         //********************************************************************************************************
         imageSymbolArray2 = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i <items; i++){
          var mySymbolObject2 = sym.createChildSymbol("holderMain", "holder");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject2.setVariable("id", i);  //set the value of a Symbol variable
          	imageSymbolArray2.push(mySymbolObject2);  //push it into the array
          	imageSymbolArray2[i].$('stroke').fadeOut(0);
          	imageSymbolArray2[i].$('btnStroke').fadeOut(0);
         }
         
         
         
         //********************************************************************************************************
         // RESET ON CLICK
         //********************************************************************************************************
         function resetClicked(){
         	speed = 500;
         	sym.$("menuBtnMob").fadeIn(0);
         	for (var i=0; i<imageSymbolArray3.length; i++){
          		imageSymbolArray3[i].$('btnStroke').fadeOut(0);
          	}
          	imageSymbolArray3[clicked].$('btnStroke').fadeIn(0);
          	sym.$("caption").empty();
         	sym.$("caption").css('height','');
         	sym.$("caption").css('height','auto');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").empty();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','auto');
         	loadCaption();
         
          	initSize();
          	checkRTL();
          	closeSource();
         }
         resetClicked();
         
         //******************************************************************************************************************************************
         // CHECK RTL
         //******************************************************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		sym.$('holder').stop().animate ({left:clicked * (stageWidth)}, speed, 'easeOutCubic');
         		sym.$("startscreen").stop().animate({scrollLeft: (64*(items-1))-(clicked*64)-(stageWidth-120)/2+32}, 500);
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'left':stageWidth-640+'px'});
         		sym.$("dateNavBtnNext").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnNextOut").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnBack").css({'left':stageWidth-60+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$("dateNavBtnBackOut").css({'left':stageWidth-60+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$("caption").css({'text-align':'right'});
         		sym.$("menuBtnMob").css({'left':'0px'});
         	}
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("dateNavBtnNext").css({'left':stageWidth-60+'px'});
         	sym.$("dateNavBtnNextOut").css({'left':stageWidth-60+'px'});
         	sym.$('holder').stop().animate ({left:clicked * (-stageWidth)}, speed, 'easeOutCubic');
         	imgHeight = imageSymbolArray2[0].$("imgHolder").height();
         	txtHeight = sym.$("caption").height();
         	imageSymbolArray3[clicked].$('btnStroke').fadeIn(0);
         
         	if (stageWidth<640){
         		for (var i=0; i<imageSymbolArray2.length; i++){
         			imageSymbolArray2[i].getSymbolElement().css({'width':stageWidth+'px', 'height':(stageWidth/1.45)+'px', 'left':stageWidth * i+'px'});
         			imageSymbolArray2[i].$('images10').css ({'top':(-stageWidth/1.45) * i+'px', 'width':stageWidth+'px', 'height':'1000%', 'left':'0px'});
         			imageSymbolArray2[i].$('images20').css ({'top':(-stageWidth/1.45) * (i-10)+'px', 'width':stageWidth+'px', 'height':'1000%', 'left':'0px'});
         
         		}
         		sym.$("menuBtnMob").fadeIn(0);
         		sym.$('startScreen').css({'left':'60px', 'top':'537px', 'width':stageWidth-120+'px', 'height':'45px'});
         		btnPath.css({'width':64*(rows*columns)+'px'});
         		for (var i=0;i<imageSymbolArray3.length;i++){
         			imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'left', 'height':'45px', 'width':'64px'});
         			imageSymbolArray3[i].$("images10").css ({'top':-(180/rows)*i+'px', 'width':'64px', 'height':'450px', 'left':(stageWidth/(columns*2))-(stageWidth/(columns*2))+'px'}, 0);	
         			imageSymbolArray3[i].$("images20").css ({'top':-(180/rows)*(i-10)+'px', 'width':'64px', 'height':'450px', 'left':(stageWidth/(columns*2))-(stageWidth/(columns*2))+'px'}, 0);
         			imageSymbolArray3[i].$('stroke').fadeIn(0);
         			imageSymbolArray3[i].$('stroke').css({'width':'62px','height':'44px'});
         			imageSymbolArray3[i].$('btnStroke').css({'left':'2px','width':'54px','height':(542/rows)-2+'px'});
         		}
         
         		sym.$('startScreen').stop().animate({scrollLeft: (clicked*64)-(stageWidth-120)/2+32}, 500);
         		sym.$('dateNavBtnNextOut').fadeIn(0);
         		sym.$('dateNavBtnBackOut').fadeIn(0);
         		sym.$("caption").css({'left':'0px', 'top':520-txtHeight+'px', 'width':stageWidth-10+'px', 'height':'auto'});
         		if (480 - (stageWidth/1.45) > txtHeight){
         			sym.$("caption").css({'left':'0px', 'width':stageWidth-10+'px', 'top':(stageWidth/1.45)+45+'px', 'height':'auto'});
         		}
         		sym.$("dateNavBtnBack").fadeIn(0);
         		sym.$("dateNavBtnNext").fadeIn(0);
         
         		if (clicked>(items-2)){
         			sym.$("dateNavBtnNext").fadeOut(0);
         		}
         		if (clicked<1){
         			sym.$("dateNavBtnBack").fadeOut(0);
         		}
         		if (RTL == true){
         			for (var i=0;i<imageSymbolArray3.length;i++){
         				imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'right', 'height':'45px', 'width':'64px'});
         			}
         			for (var i=0; i<imageSymbolArray2.length; i++){
         				imageSymbolArray2[i].getSymbolElement().css({'left':-stageWidth * i+'px'});
         			}
         			sym.$('holder').stop().animate ({left:clicked * (-stageWidth)}, speed, 'easeOutCubic');
         			sym.$('startScreen').stop().animate({scrollLeft: (64*12)-stageWidth/2-(64*clicked)+32}, 500);
         		}
         	}else{
         		for (var i=0; i<imageSymbolArray2.length; i++){
         			imageSymbolArray2[i].getSymbolElement().css({'width':stageWidth+'px', 'height':'542px', 'left':stageWidth * i+'px'});
         			imageSymbolArray2[i].$('images10').css ({'top':-542 * i+'px', 'width':800+'px', 'height':542*(rows*columns-2)+'px', 'left':(stageWidth-800)/2});
         			imageSymbolArray2[i].$('images20').css ({'top':-542 * (i-10)+'px', 'width':800+'px', 'height':542*(rows*columns-2)+'px', 'left':(stageWidth-800)/2});
         		}
         		btnPath.css({'width':stageWidth/4+'px'});
         		sym.$("menuBtnMob").fadeOut(0);
         		sym.$('startScreen').css({'width':stageWidth/4+'px', 'top':'40px', 'height':'200px', 'left':(stageWidth/4)*3+'px'});
         		sym.$('startScreen').stop().animate({scrollLeft:0}, 0);
         		for (var i=0;i<imageSymbolArray3.length;i++){
         			imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'left', 'height':'50px', 'width':(stageWidth/4)/columns+'px'});
         			imageSymbolArray3[i].$("images10").css ({'top':-(200/rows)*i+'px', 'width':'90px', 'height':'500px', 'left':(stageWidth/(rows*4))-(btnPath.width()/columns)+'px'}, 0);	
         			imageSymbolArray3[i].$("images20").css ({'top':-(200/rows)*(i-10)+'px', 'width':'90px', 'height':'500px', 'left':(stageWidth/(rows*4))-(btnPath.width()/columns)+'px'}, 0);	
         			sym.$("caption").css({'left':(stageWidth/4)*3, 'top':'240px', 'width':(stageWidth/4)-10+'px', 'height':'332px'});
         			imageSymbolArray3[i].$('stroke').fadeIn(0);
         			imageSymbolArray3[i].$('stroke').css({'height':'50px', 'width':(stageWidth/4)/columns+'px'});
         			imageSymbolArray3[i].$('btnStroke').css({'left':'0px', 'top':'0px', 'width':(stageWidth/4)/columns-8+'px','height':'42px'});
         		}
         		sym.$('dateNavBtnNext').fadeOut(0);
         		sym.$('dateNavBtnBack').fadeOut(0);
         		sym.$('dateNavBtnNextOut').fadeOut(0);
         		sym.$('dateNavBtnBackOut').fadeOut(0);
         		if (RTL == true){
         			for (var i=0;i<imageSymbolArray3.length;i++){
         				imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'right', 'height':'50px', 'width':(stageWidth/4)/columns+'px'});
         			}
         			for (var i=0; i<imageSymbolArray2.length; i++){
         				imageSymbolArray2[i].getSymbolElement().css({'left':-stageWidth * i+'px'});
         			}
         			sym.$('holder').stop().animate ({left:clicked * (-stageWidth)}, speed, 'easeOutCubic');
         		}
         	}
         
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         
         	checkRTL();
         	setStyle();
         	speed = 0;
         	closeSource();
         }
         
         
         //******************************************************************************************************************************************
         // ARROW BUTTONS
         //******************************************************************************************************************************************
         sym.$("dateNavBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	resetClicked();
         	});
         sym.$("dateNavBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	resetClicked();
         	});
         
         //******************************************************************************************************************************************
         // SWIPE
         //******************************************************************************************************************************************
         sym.$("mask").on("swipeleft",function(){
         	if (RTL == false){
         		clicked++;
         		if (clicked>items-1){
         			clicked = items-1;
         		} else {
         			resetClicked();
         		}
         	}else{
         		clicked--;
         		if (clicked<0){
         			clicked = 0;
         		}else{
         			resetClicked();
         		}
         }
         });
         sym.$("mask").on("swiperight",function(){
         	if (RTL == false){
         		clicked--;
         		if (clicked<0){
         			clicked = 0;
         		}else{
         			resetClicked();
         		}
         	}else{
         		clicked++;
         		if (clicked>items-1){
         			clicked = items-1;
         		} else {
         			resetClicked();
         		}
         	}
         });
         
         //******************************************************************************************************************************************
         // MENU BUTTON
         //******************************************************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	sym.$("menuBtnMob").fadeOut(0);
         	closeSource();
         	startVis = true;
         	showStartScreen();
         });
         sym.$("menuBtnMob").fadeOut(0);
         
         function showStartScreen(){
         	if (stageWidth < 640 || startVis == true){
         		btnPath.css({'width':stageWidth+'px'});
         		sym.$('startScreen').css({'left':'0px', 'top':'40px', 'width':stageWidth+'px', 'height':'542px'});
         		sym.$('startScreen').stop().animate({scrollLeft:0}, 0);
         		for (var i=0;i<imageSymbolArray3.length;i++){
         			imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'left', 'height':542/rows+'px', 'width':stageWidth/columns+'px'});
         			imageSymbolArray3[i].$("images10").css ({'top':-(542/rows)*i+'px', 'width':640/columns+'px', 'height':542/rows*10+'px', 'left':(stageWidth/(columns*2))-(640/(columns*2))+'px'}, 0);
         			imageSymbolArray3[i].$("images20").css ({'top':-(542/rows)*(i-10)+'px', 'width':640/columns+'px', 'height':542/rows*10+'px', 'left':(stageWidth/(columns*2))-(640/(columns*2))+'px'}, 0);
         			imageSymbolArray3[i].$('stroke').fadeIn(0);
         			imageSymbolArray3[i].$('stroke').css({'height':542/rows+'px', 'width':stageWidth/columns+'px'});
         			imageSymbolArray3[i].$('btnStroke').fadeOut(0);
         		}
         		if (RTL == true){
         			for (var i=0;i<imageSymbolArray3.length;i++){
         				imageSymbolArray3[i].getSymbolElement().css({'position':'relative','float':'right', 'height':542/rows+'px', 'width':stageWidth/columns+'px'});
         			}
         		}
         	}else{
         		initSize();
         	}
         	startVis = false;
         }
         showStartScreen();
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("caption").css({'overflow-x':'hidden', 'overflow-y':'auto'});
         	sym.$("startScreen").css({'overflow-y':'hidden', 'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************
         

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'stageBtnsMc'
   (function(symbolName) {   
   
   })("stageBtnsMc");
   //Edge symbol end:'stageBtnsMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn'
   (function(symbolName) {   
   
   })("stageNavBtn");
   //Edge symbol end:'stageNavBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'holderMain'
   (function(symbolName) {   
   
   })("holderMain");
   //Edge symbol end:'holderMain'

   //=========================================================
   
   //Edge symbol: 'startScreen'
   (function(symbolName) {   
   
   })("startScreen");
   //Edge symbol end:'startScreen'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34942");