/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline, headlinemob, stand, source, ussr;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white", "padding":"5px", 'height':'auto'});
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	var venueName=[];
         	var venueDate=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol('map').$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol('map').$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol('map').$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol('map').$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol('map').$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol('map').$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34941.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<20; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			var ussrstring=txtArr[12]; ussr= ussrstring.split(";");
         			txt[12].html(ussr[0]);
         			sym.getSymbol('map').$("txt17").css({"line-height":"16px"});
         			sym.getSymbol('map').$("txt18").css({"line-height":"20px"});
         
         		//NEW TABLE
         for (var t=0;t<12; t++){	//get details for each team
         $(xml).find("chapter").each(function(){
         	var $event=$(this);
         	var venuename=$event.find("txt"+t).text();
         	venueName.push(venuename);
         });
         }
         var tableTxt="<table id='venueTable'>";
         for (var i=0;i<12;i++){ //create a row for each sport
         	tableTxt+="<tr id='venue"+i+"' class='venue'>";
         	tableTxt+="<td id='name"+i+"' class='venueName'>"+venueName[i]+"</td>";
         	tableTxt+="</tr>";
         }
         
         sym.$('table').append(tableTxt);
         
         $("#venueTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px",'border-collapse':'collapse', 'width':'100%'});
         $("#venueTable tr:odd").css({"background-color":"#E9E9EA",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $("#venueTable tr:even").css({"background-color":"#f8f8f9",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $(".venue").css({'height':'30px'});
         $(".venueName").css({'padding-left':'8px', 'padding-top':'6px',"vertical-align":"top"});
         
         	table = document.getElementById("venueTable");
         	row0 = table.insertRow(6);
         	cell0 = row0.insertCell(0);
         	cell0.innerHTML = ('<br>' + txtArr[19]);
         	cell0.style.height = "30px";
         
         	sym.$('table').find(cell0).css({'padding-left':'10px', 'vertical-align':'top', 'background':'url(images/boris.jpg)'}); 
         	},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("table").css({"top":60+sym.$("standTxt").height()+"px", 'height':522-sym.$("standTxt").height()+"px"});
         	sym.$("mapBtn").css({"left":stageWidth-40+"px"});
         	cell0.style.height = 300+"px";
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		sym.$("statue").fadeOut(0);
         		sym.$("table").css({'left':'0px', 'width':stageWidth+"px"});
         		sym.$("standTxt").css({'left':'0px', "width":stageWidth-10+"px"});
         		sym.$("map").css({'width':stageWidth +'px'});
         		sym.getSymbol('map').$("txt17").css({'top':'38px'});
         	}else{
         		sym.$("statue").fadeIn(0);
         		sym.$("table").css({'left':'108px', 'width':stageWidth-108+"px"});
         		sym.$("standTxt").css({'left':'108px', "width":stageWidth-120+"px"});
         		sym.$("map").css({'width':'535px'}); sym.getSymbol('map').$("txt17").css({'top':'23px'});
         	}
         	setStyle();
         	closeSource();
         	closeMap();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right'});
         		sym.$("standTxt").css({'text-align':'right'});
         		$(".venueName").css({'text-align':'right', 'padding-right':'5px'});
         		sym.$("mapBtn").css({"left":"0px"});
         		sym.getSymbol('map').$("txt14").css({'text-align':'right'});
         		sym.getSymbol('map').$("txt15").css({'text-align':'right'});
         		sym.getSymbol('map').$("txt17").css({'text-align':'right'});
         	}
         }
         
         //********************************************************************************************************
         // MAP BTN
         //********************************************************************************************************
         var mapVis = false;
         sym.$("mapBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(mapVis == false){
         		sym.$('map').stop().animate ({left:stageWidth-(stageWidth<480?stageWidth:535)+'px'}, 500, 'easeOutCubic');
         		sym.$("mapBtn").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.getSymbol("map").getSymbol("collapse").play(0);
         		setTimeout(function(){ sym.getSymbol("map").$("txt12").html(ussr[1]); },9000);
         		mapVis = true;
         	}else{
         		closeMap(); sym.getSymbol("map").$("txt12").html(ussr[0]);
         	}
         });
         function closeMap(){
         	sym.$('map').stop().animate ({left:stageWidth+10+'px'}, 100, 'easeOutCubic');
         	sym.$("mapBtn").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	mapVis = false;
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	$(".venueName p").css({'margin':0});		sym.getSymbol('map').$("txt17").css({'height':'auto','padding':'1.5%','background-color':'rgba(255,255,255,0.5)','border-radius':'15px','margin':'0 1%'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'statue'
   (function(symbolName) {   
   
   })("statue");
   //Edge symbol end:'statue'

   //=========================================================
   
   //Edge symbol: 'boris'
   (function(symbolName) {   
   
   })("boris");
   //Edge symbol end:'boris'

   //=========================================================
   
   //Edge symbol: 'map'
   (function(symbolName) {   
   
   })("map");
   //Edge symbol end:'map'

   //=========================================================
   
   //Edge symbol: 'heads'
   (function(symbolName) {   
   
   })("heads");
   //Edge symbol end:'heads'

   //=========================================================
   
   //Edge symbol: 'collapse'
   (function(symbolName) {   
   
   })("collapse");
   //Edge symbol end:'collapse'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34941");