/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clickGal = 0;
         	var stageWidth=sym.$("Stage").width();
         	var galHeight = stageWidth/1.33;
         	var galWidth  = stageWidth;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"1px", "padding-botom":"6px", "padding-left":"6px"};
         	
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	}
         
         //********************************************************************************************************
         	for (var i=0; i<5; i++){
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn"+i).$("no").html(i+1);
         		sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn"+i).$("no").html(i+1);
         	}
         //********************************************************************************************************
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0;i<6; i++){
         		txt[i] = sym.getSymbol("carMc").$("txt"+i).css(whiteTxtBox);
         	}
         	for (var i=6;i<12; i++){
         		txt[i] = sym.getSymbol("carMc").getSymbol("iconStats").$("txt"+i).css({"pointer-events":"none", "height":"auto"});
         	}
         	txt[12] = sym.getSymbol("intMc").$("txt12").css(whiteTxtBox);
         	txt[13] = sym.getSymbol("intMc").$("txt13").css(whiteTxtBox);
         	txt[14] = sym.getSymbol("intMc").$("txt14").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34920.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<15; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			sym.getSymbol("carMc").$("text").empty();
         			sym.getSymbol("carMc").$("text").append(txtArr[0]);
         			sym.getSymbol("carMc").$("text").css({'font-size':"14px"});
         			sym.getSymbol("carMc").$("txt1").css(whiteTxtBox);
         
         			for (var i=6; i<9; i++){
         				sym.getSymbol("carMc").getSymbol("iconStats").$("txt"+i).css({'font-size':"26px"});
         			}
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("galleryMc").$("galBtns").stop().animate({left:stageWidth/2-160}, 0);
         	sym.getSymbol("galleryMc").$("btnBg").stop().animate({left:stageWidth/2-161}, 0);
         	sym.getSymbol("carMc").$("carBtns").stop().animate({left:stageWidth/2-125}, 0);
         	standHeight = sym.$("standTxt").height()+10;
         	galHeight = stageWidth/1.27;
         	galWidth  = stageWidth;
         	sym.getSymbol("galleryMc").$("zoomBtn").css({"left":stageWidth-40 + "px", "top":standHeight});
         	setStyle();
         
         	if(stageWidth<800){
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	}
         	if(stageWidth<640){
         		sym.getSymbol("galleryMc").$("zoomBtn").fadeIn(0);
         		sym.getSymbol("galleryMc").$("galScroll").css({'width':stageWidth + "px", "top":standHeight + "px", "height":542 - standHeight + "px"});
         		for (var i=0; i<5; i++){
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+i).stop().animate ({left:0, top:i*galHeight, height:galHeight, width:stageWidth}, 0);
         		}
         		sym.getSymbol("carMc").getSymbol("carNew").$("red"+clickAux).fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		closeZoom();
         	}else{
         		sym.getSymbol("galleryMc").$("galBtns").stop().animate ({top:504}, 0);
         		sym.getSymbol("galleryMc").$("zoomBtn").fadeOut(0);
         		sym.getSymbol("galleryMc").$("galScroll").css({"width":stageWidth + "px", "top":standHeight + "px", "height":542 - standHeight + "px"});
         		for (var i=0; i<5; i++){
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+i).stop().animate ({left:stageWidth*i, top:0, height:galHeight, width:stageWidth}, 0);
         			sym.getSymbol("carMc").getSymbol("carNew").$("red"+i).fadeOut(0);
         		}
         		sym.getSymbol("galleryMc").$("galScroll").stop().animate({scrollLeft:clickGal*galWidth}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		mob = 1;
         	}else{
         		mob = 0;
         	}
         	menuMob();
         	setStyleUpdate();
         	closeSource();
         	doCheck();
         }
         
         //********************************************************************************************************
         // SCROLL SHOW / HIDE
         //********************************************************************************************************
         $.fn.isVisible = function() {
             var rect = this[0].getBoundingClientRect();
             return (
                 (rect.height > 0 || rect.width > 0) && rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth)
             );
         };
         
         function doCheck() {
         		if (sym.getSymbol("intMc").$("box1").isVisible() && sym.getSymbol("intMc").$("box2").isVisible()) {
         			sym.getSymbol("intMc").$("pointer90").stop().animate({opacity:1}, 200);
         			sym.getSymbol("intMc").$("txt12").stop().animate({opacity:1}, 200);
         		} else {
         			sym.getSymbol("intMc").$("pointer90").stop().animate({opacity:0}, 50);
         			sym.getSymbol("intMc").$("txt12").stop().animate({opacity:0}, 50);
         		}
         		if (sym.getSymbol("intMc").$("box3").isVisible() && sym.getSymbol("intMc").$("box4").isVisible()) {
         			sym.getSymbol("intMc").$("pointer").stop().animate({opacity:1}, 200);
         			sym.getSymbol("intMc").$("txt13").stop().animate({opacity:1}, 200);
         		} else {
         			sym.getSymbol("intMc").$("pointer").stop().animate({opacity:0}, 50);
         			sym.getSymbol("intMc").$("txt13").stop().animate({opacity:0}, 50);
         		}
         }
         
         var TO = false;
         var scroll_static = true;
         
         sym.$("intMc").scroll(function(){
         	doCheck();
         	if( scroll_static ){
         		scroll_static = false;
         	}
         
         	if (TO !== false){ clearTimeout(TO); }           
         	TO = setTimeout(myfunction, 100); 
         });
         
         function myfunction(){
         	scroll_static = true;
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		closeZoom();
         		doCheck();
         		sym.$("carMc").stop().fadeOut(200);
         		//sym.$("intMc").stop().fadeOut(200);
         		sym.$("txt12").stop().fadeOut(200);
         		sym.$("galleryMc").stop().fadeOut(200);
         		clicked = menuNo;
         		resetmenu();
         		closeSource();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0){
         			sym.$("carMc").stop().fadeIn(200);
         		}
         		if (menuNo == 1){
         			sym.$("txt12").stop().fadeIn(200);
         			sym.$("intMc").stop().fadeIn(200);
         		}
         		if (menuNo == 2){
         			sym.$("galleryMc").stop().fadeIn(200);
         			resetGal();
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal0").stop().animate ({opacity:1}, 0);
         			sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn0").$("bg").css({"background-color":"#da0000", "border-color":"#da0000"});
         			sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn0").$("no").css({"color":"#fff"});
         			sym.getSymbol("galleryMc").$("galScroll").stop().animate({scrollLeft:0, scrollTop:0}, 0);
         		}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:180+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:80-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"right", "padding-top":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         		sym.getSymbol('intMc').$("txt12").css({"text-align":"right"});
         		sym.getSymbol('intMc').$("txt13").css({"text-align":"right"});
         		for (var i=0;i<5; i++){
         			sym.getSymbol("carMc").$("txt"+i).css({"text-align":"right", "pointer-events":"none", "height":"auto"});
         			sym.getSymbol("carMc").getSymbol("carBtns").$("btn"+i).stop().animate({left:192-(64*i)}, 0);
         			sym.getSymbol("galleryMc").getSymbol("galBtns").$("btn"+i).stop().animate({left:256-(64*i)}, 0);
         		}
         	}
         }
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // CAR BUTTONS
         var clickAux = 0;
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<5; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + a).$("bg").css(outBtn);
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + a).$("bg").css({"background-color":"#fff", "border-color":"#666"});
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + a).$("no").css({"color":"#666"});
         		sym.getSymbol("carMc").getSymbol("carNew").$("red"+a).fadeOut(0);
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + auxNo).$("bg").css(overBtn);
         		sym.getSymbol("carMc").getSymbol("carNew").$("red"+auxNo).fadeIn(0);
         		sym.getSymbol("carMc").$("text").html(txtArr[auxNo]);
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + auxNo).$("bg").css({"background-color":"#da0000", "border-color":"#da0000"});
         		sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn" + auxNo).$("no").css({"color":"#fff"});
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("carMc").getSymbol("carBtns").$("btn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("carMc").getSymbol("carBtns").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn0").$("bg").css(overBtn);
         sym.getSymbol("carMc").getSymbol("carNew").$("red0").fadeIn(0);
         sym.getSymbol("carMc").getSymbol("carBtns").getSymbol("btn0").$("no").css({"color":"#fff"});
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // GALLERY BUTTONS
         var clickGal = 0;
         galArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<5; a++){
         	galArray.push(a);
         	sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + a).$("pic").attr("src", "images/gal" + a + ".jpg");
         	sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + a).$("pic").stop().animate ({opacity:1}, 0);
         	sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + a).$("no").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + a).$("bg").stop().animate ({opacity:0}, 0);
         }
         
         function resetGal(){
         	for (var a=0; a<galArray.length; a++){
         		sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+a).stop().animate ({opacity:0.2}, 100);
         	}
         }
         resetGal();
         
         // GALLERY CLICK
         var galBtnClick = function(galNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickGal = galNo;
         		resetGal();
         		sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + galNo).$("bg").css({"background-color":"#da0000", "border-color":"#da0000"});
         		sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn" + galNo).$("no").css({"color":"#fff"});
         		sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+clickGal).stop().animate ({opacity:1}, 100);
         		if(stageWidth<640){
         			sym.getSymbol("galleryMc").$("galScroll").stop().animate({scrollTop:clickGal*galHeight}, 500, 'easeOutCubic');
         		}else{
         			sym.getSymbol("galleryMc").$("galScroll").stop().animate({scrollLeft:clickGal*stageWidth}, 500, 'easeOutCubic');
         			for (var a=0; a<galArray.length; a++){
         				sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+a).stop().animate ({opacity:1}, 0);
         			}
         		}
         	};
         };
         for (var b=0;b<galArray.length;b++){
         	sym.getSymbol("galleryMc").getSymbol("galBtns").$("btn" + b).on('touchstart click',galBtnClick(b));
         	sym.getSymbol("galleryMc").getSymbol("galBtns").$("btn" + b).css({'cursor':'pointer'});
         }
         sym.getSymbol("galleryMc").getSymbol("galBtns").getSymbol("btn0").$("pic").css({"background-color":"#da0000", "border-color":"#da0000"});
         
         sym.getSymbol("galleryMc").$("galScroll").css({'overflow-x':'hidden', 'overflow-y':'hidden'});
         sym.$("intMc").css({'overflow-y':'hidden'});
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // ZOOM BTN
         sym.getSymbol("galleryMc").$("zoomBtn").on('touchstart click', function(e){
         		e.preventDefault(); e.stopPropagation();
         		if (sym.getSymbol("galleryMc").getSymbol("zoomBtn").$("plus").is(":visible") ) { 
         		for (var a=0; a<5; a++){
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+a).stop().animate ({opacity:0}, 200);
         		}
         		sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+clickGal).stop().animate ({opacity:1, left:0, top:galHeight*clickGal, height:480, width:650},  500, 'easeOutCubic');
         		sym.getSymbol("galleryMc").$("galScroll").css({'overflow-x':'visible', 'overflow-y':'hidden'});
         		sym.getSymbol("galleryMc").getSymbol("zoomBtn").$("plus").fadeOut(0);
         		sym.getSymbol("galleryMc").$("galBtns").stop().animate ({top:600},  500, 'easeOutCubic');
         		if (clickGal == 4){
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+clickGal).stop().animate ({left:0, top:(galHeight*clickGal)-galHeight, height:480, width:650},  500, 'easeOutCubic');
         		}
         	} else {
         		closeZoom();
         	}
         });
         
         function closeZoom(){
         	var stageWidth=sym.$("Stage").width();
         	for (var a=0; a<5; a++){
         			sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+a).stop().animate ({opacity:0.2}, 500);
         		}
         		sym.getSymbol("galleryMc").getSymbol("galScroll").$("gal"+clickGal).stop().animate ({opacity:1, left:0, top:galHeight*clickGal, height:galHeight, width:stageWidth},  500, 'easeOutCubic');
         		sym.getSymbol("galleryMc").$("galScroll").css({'overflow-x':'hidden', 'overflow-y':'hidden'});
         		sym.getSymbol("galleryMc").getSymbol("zoomBtn").$("plus").fadeIn(0);
         		sym.getSymbol("galleryMc").$("galBtns").stop().animate ({top:504},  500, 'easeOutCubic');
         		if (clickGal == 4){
         			sym.getSymbol("galleryMc").$("galScroll").animate({scrollTop:galHeight*4},  500, 'easeOutCubic');
         		}
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("carMc").stop(stageWidth*10);
         	sym.getSymbol("intMc").stop(stageWidth*10);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'carNew'
   (function(symbolName) {   
   
   })("carNew");
   //Edge symbol end:'carNew'

   //=========================================================
   
   //Edge symbol: 'iconStats'
   (function(symbolName) {   
   
   })("iconStats");
   //Edge symbol end:'iconStats'

   //=========================================================
   
   //Edge symbol: 'pointer'
   (function(symbolName) {   
   
   })("pointer");
   //Edge symbol end:'pointer'

   //=========================================================
   
   //Edge symbol: 'pointRed'
   (function(symbolName) {   
   
   })("pointRed");
   //Edge symbol end:'pointRed'

   //=========================================================
   
   //Edge symbol: 'galleryMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("galleryMc");
   //Edge symbol end:'galleryMc'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("galBtns");
   //Edge symbol end:'galBtns'

   //=========================================================
   
   //Edge symbol: 'galScroll'
   (function(symbolName) {   
   
   })("galScroll");
   //Edge symbol end:'galScroll'

   //=========================================================
   
   //Edge symbol: 'zoomBtn'
   (function(symbolName) {   
   
   })("zoomBtn");
   //Edge symbol end:'zoomBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtn_1'
   (function(symbolName) {   
   
      })("carBtn");
   //Edge symbol end:'carBtn'

   //=========================================================
   
   //Edge symbol: 'pointer90'
   (function(symbolName) {   
   
   })("pointer90");
   //Edge symbol end:'pointer90'

   //=========================================================
   
   //Edge symbol: 'galBtns_1'
   (function(symbolName) {   
   
      })("carBtns");
   //Edge symbol end:'carBtns'

   //=========================================================
   
   //Edge symbol: 'intNew'
   (function(symbolName) {   
   
   })("intNew");
   //Edge symbol end:'intNew'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'intMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("intMc");
   //Edge symbol end:'intMc'

   //=========================================================
   
   //Edge symbol: 'intNew_1'
   (function(symbolName) {   
   
   })("intNew_1");
   //Edge symbol end:'intNew_1'

   //=========================================================
   
   //Edge symbol: 'pointer_1'
   (function(symbolName) {   
   
   })("pointer_1");
   //Edge symbol end:'pointer_1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34920");