/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var sceneVis = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("scene0").$("standTxt").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         //Date -5/04/17 01:00	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var orangeTxtBox = {"border-radius":"5px", "color":"#000", "background-color":"#faa61a", "padding":"6px", 'height':"auto"};
         	var sandTxtBox = {"border-radius":"5px", "color":"#000", "background-color":"#f2e3c5", "padding":"6px", 'height':"auto"};
         
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<15; i++){
         		txt[i] = sym.getSymbol("scene0").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=15; i<33; i++){
         		txt[i] = sym.getSymbol("scene1").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=33; i<48; i++){
         		txt[i] = sym.getSymbol("scene2").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=48; i<59; i++){
         		txt[i] = sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[59]=sym.getSymbol("scene3").getSymbol("scrollableMc").$("txt59").css({"pointer-events":"none"});
         	for (var i=60; i<62; i++){
         		txt[i] = sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=62; i<64; i++){
         		txt[i] = sym.getSymbol("scene4").$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34901.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<64; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			sym.getSymbol("scene1").$("txt30").css(orangeTxtBox);
         			sym.getSymbol("scene1").$("txt31").css(orangeTxtBox);
         			sym.getSymbol("scene1").$("txt32").css(sandTxtBox);
         			sym.getSymbol("scene1").$("txt32").css({"padding-left":"130px"});
         			sym.getSymbol("scene2").$("txt45").css({'line-height':'21px'});
         			sym.getSymbol("scene2").$("txt46").css(orangeTxtBox);
         			sym.getSymbol("scene3").getSymbol("scrollableMc").$("txt59").css(sandTxtBox);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("scene0").stop(stageWidth*10);
         	sym.getSymbol("scene1").stop(stageWidth*10);
         	sym.getSymbol("scene2").stop(stageWidth*10);
         	sym.getSymbol("scene3").stop(stageWidth*10);
         	sym.getSymbol("scene4").stop(stageWidth*10);
         	sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").stop(stageWidth*10);
         	//sym.getSymbol("scene3").$("starsMc").css({'top':sym.getSymbol("scene3").$("txt59").height()+30+'px'}, 0);
         
         	sym.$("nextBtn").css({'left':stageWidth-40+'px'});
         	sym.$("scene0").css({'left':stageWidth/2-240+'px'});
         	sym.$("scene1").css({'left':stageWidth/2-240+'px'});
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		//sym.getSymbol("scene3").$("starscapeMc").css({'overflow-x':'auto'});
         		sym.$("scene3").css({'cursor':'ew-resize'});
         		sym.getSymbol("scene3").getSymbol("scrollableMc").$("starscapeMc").css({"top":"-15px"});
         		sym.$("scene3").css({'overflow-x':'auto'});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("scene0").css({'left':'0px'});
         		sym.$("scene1").css({'left':'320px'});
         		sym.getSymbol("scene0").stop(320);
         		sym.getSymbol("scene1").stop(320);
         		//sym.getSymbol("scene3").$("starscapeMc").css({'overflow-x':'hidden'});
         		sym.getSymbol("scene3").getSymbol("scrollableMc").$("starscapeMc").css({"top":"0px"});
         		sym.$("scene3").css({'cursor':'default'});
         		sym.$("scene3").css({'overflow-x':'hidden'});
         	}
         	if (stageWidth<480){
         		sym.$("scene0").css({'left':'0px'});
         		sym.$("scene1").css({'left':'0px'});
         		sym.$("scene2").css({'left':'0px'});
         		sym.getSymbol("scene3").getSymbol("scrollableMc").$("txt59").css({"padding-left":"117px"});
         	}else{
         		sym.getSymbol("scene3").getSymbol("scrollableMc").$("txt59").css({"padding-left":"130px"});
         	}
         
         	var x = sym.getSymbol("scene1").$('base').position();
         	sym.getSymbol("scene1").$("txt30").stop().animate({left: x.left-44, top: x.top-sym.getSymbol("scene1").$("txt30").height()-8}, 0);
         
         	setStyle();
         	closeSource();
         	checkScene();
         	doCheck();
         }
         //********************************************************************************************************
         // NEXT BTN
         //********************************************************************************************************
         sym.$("nextBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++
         	sym.$("clickTxt").html(clicked);
         	checkScene();
         });
         
         function checkScene(){
         	stageWidth=sym.$("Stage").width();
         	for (var i=0; i<5; i++){
         		sym.$("scene"+i).stop().animate({opacity:0}, 200);
         	}
         	sym.$("scene"+clicked).stop().animate({opacity:1}, 200);
         	if (stageWidth == 640){
         		if (clicked == 0 || clicked == 1){
         			sym.$("scene0").stop().animate({opacity:1}, 200);
         			sym.$("scene1").stop().animate({opacity:1}, 200);
         			clicked = 1;
         		}else{
         			sym.$("scene0").stop().animate({opacity:0}, 200);
         			sym.$("scene1").stop().animate({opacity:0}, 200);
         		}
         	}
         	if (clicked == 2){
         		sym.getSymbol("scene2").getSymbol("arrowMc").play(0);
         	}
         	if (clicked == 3){
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt52").fadeOut(0)
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt53").fadeOut(0)
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt54").fadeOut(0)
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt50").fadeOut(0)
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt48").fadeOut(0)
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt49").fadeOut(0)
         		//sym.getSymbol("scene3").getSymbol("starsMc").getSymbol("starScape").play(0);
         		sym.$("scene3").scrollLeft(0);
         		//sym.getSymbol("scene3").$("starscapeMc").scrollLeft(0);
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").play(0);
         
         	}
         
         	if (clicked > 3){
         		sym.getSymbol("nextBtn").$("replay").fadeIn(0);
         		clicked = -1;
         	}else{
         		sym.getSymbol("nextBtn").$("replay").fadeOut(0);
         	}
         
         	if (clicked > 4){
         		clicked = -1;
         		checkScene();
         	}
         }
         checkScene();
         
         //********************************************************************************************************
         // VISIBLE CHECK
         //********************************************************************************************************
         $.fn.isVisible = function() {
             var rect = this[0].getBoundingClientRect();
             return (
                 (rect.height > 0 || rect.width > 0) && rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth)
             );
         };
         
         function doCheck() {
         	//if(sym.getSymbol("scene3").$("head").isVisible()){
         	if(sym.$("scene3").scrollLeft()<30){
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt60").stop().animate({'opacity':1},200);
         	}else{
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt60").stop().animate({'opacity':0},200);
         	}
         	if(sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("ellipse0").isVisible()){
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt61").stop().animate({'opacity':1},200);
         		console.log("Saturn");
         	}else{
         		sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt61").stop().animate({'opacity':0},200);
         	}
         }
         
         var TO = false;
         var scroll_static = true;
         sym.$("scene3").scroll(function(){
         	doCheck();
         	if( scroll_static ){
         		scroll_static = false;
         	}
         
         	if (TO !== false){ clearTimeout(TO); }           
         	TO = setTimeout(myfunction, 100); 
         });
         function myfunction(){
         	scroll_static = true;	
         }
         
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("scene3").getSymbol("scrollableMc").getSymbol("starscapeMc").$("txt61").css({"height":"auto"});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************
         

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("nextBtn");
   //Edge symbol end:'nextBtn'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'scene0'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scene0");
   //Edge symbol end:'scene0'

   //=========================================================
   
   //Edge symbol: 'graph'
   (function(symbolName) {   
   
   })("graph");
   //Edge symbol end:'graph'

   //=========================================================
   
   //Edge symbol: 'graphPoint'
   (function(symbolName) {   
   
   })("graphPoint");
   //Edge symbol end:'graphPoint'

   //=========================================================
   
   //Edge symbol: 'graphHead'
   (function(symbolName) {   
   
   })("graphHead");
   //Edge symbol end:'graphHead'

   //=========================================================
   
   //Edge symbol: 'scene1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scene1");
   //Edge symbol end:'scene1'

   //=========================================================
   
   //Edge symbol: 'spaceHead'
   (function(symbolName) {   
   
   })("spaceHead");
   //Edge symbol end:'spaceHead'

   //=========================================================
   
   //Edge symbol: 'spaceSpace'
   (function(symbolName) {   
   
   })("spaceSpace");
   //Edge symbol end:'spaceSpace'

   //=========================================================
   
   //Edge symbol: 'scene2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scene2");
   //Edge symbol end:'scene2'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'scene4'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scene4");
   //Edge symbol end:'scene4'

   //=========================================================
   
   //Edge symbol: 'replay'
   (function(symbolName) {   
   
   })("replay");
   //Edge symbol end:'replay'

   //=========================================================
   
   //Edge symbol: 'starscapeMc'
   (function(symbolName) {   
   
   })("starscapeMc");
   //Edge symbol end:'starscapeMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34901");