/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var RTL="false"; //select true if right to left
         var stageWidth, graphcolor="#e6e1d7", yel="rgba(255,210,50,0.75)", strap="rgba(93,115,120,1.00)", seasonstatus=0, gnYear=2017, gn=34870;//gnYear=2016, gn=33835 
         //CREATE ARRAYS
         var screenArr=['globeMc','driverChampMc','teamChampMc','driversMc','liveMc','circuitMc','timingMc','resultMc']; //scenes
         var teamArr=['FER','FOR','HAA','MLA','MER','RBR','REN','SAU','TOR','WIL'];//2017
         var countryArr=['aus','chn','brn','rus','esp','mon','can','eur','aut','eng','hun','bel','ita','sin','mas','jpn','usa','mex','bra','uae'];//2017
         var latlong=[[-38,145],[31,121],[26,50],[44,40],[41,2],[44,7],[46,-74],[40,50],[47,14],[52,1],[47,19],[50,6],[50,6],[46,9],[1,104],[3,102],[35,137],[29,-95],[19,-99],[-24,-47],[24,55]];
         var sourceStyle = {"background-color":"rgba(93,115,120,1.00)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         //LIVE DATA ADDRESS
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://data.graphicnews.com/")+ "infostradasports/api.php";
         //***************************** XML FOR TEXT *************************************
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         var headline, headlinemob, months, keyWidth, liveCap, statCap, loaded=0, clicked=0, selectPhase, carStop, racestatus, latestGPno=0;
         var champHead=[], caps=[], capsText=[], raceArr=[], raceText=[], raceCorners=[], teamTxtArr=[], driverTxtArr=[], gpDate=[], driverID=[], phaseBtnTxt=[], phaseTxtArr=[], menuArray=[], menuText=[], menuTxtArr=[], coundownCap=[];
         for (var r=0;r<countryArr.length; r++){
         	raceArr[r]=[];
         }
         //var teamDriverArr=[];
         for (var t=0;t<teamArr.length; t++){
         	teamTxtArr[t]=[]; driverTxtArr[t]=[];
         } 
         for (var i=0; i<5; i++){ //menu icons
         	menuText[i]= sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');//sprite
         }
         for (var i=5; i<8; i++){ //race button icons
         	menuText[i]= sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');//sprite
         }
         for (var p=0;p<8;p++){//phase buttons
         	phaseBtnTxt[p] = sym.getSymbol("raceButtons").getSymbol("phaseBtn"+p).$("phaseTxt").css({"pointer-events":"none"});
         	sym.getSymbol("raceButtons").$("phaseBtn"+p).css({"opacity":0.3});
         }
         sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("menuTxt").css({"opacity":0.3});sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("icon").css({"opacity":0.3});
         capsText[0]=sym.getSymbol("circuitMc").$("weatherTxt").css("pointer-events","none");
         capsText[1]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("gearTxt").css("pointer-events","none");
         capsText[2]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("speedTxt").css("pointer-events","none");
         capsText[3]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key1").css("pointer-events","none");
         capsText[4]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key2").css("pointer-events","none");
         capsText[5]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key3").css("pointer-events","none");
         capsText[6]= sym.getSymbol("liveMc").$("lapTxt").css("pointer-events","none");
         capsText[7]= sym.getSymbol("liveMc").$("timeTxt").css("pointer-events","none");
         capsText[8]= sym.getSymbol("resultMc").$("resultTxt").css("pointer-events","none");
         raceText[0]=sym.getSymbol("circuitMc").$("gpTxt").css("pointer-events","none");
         raceText[1]=sym.getSymbol("circuitMc").$("venueTxt").css("pointer-events","none");
         raceText[2]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("distanceTxt").css("pointer-events","none");
         raceText[3]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("lapTxt").css("pointer-events","none");
         
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",//"GN34870.xml"
         	dataType: "xml",
         	success: function(xml) {
         		headline=$(xml).find('headline').text();
         		headlinemob=$(xml).find('headlinemob').text();
         		sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		graphcolor=$(xml).find('graphcolor').text();
         		for (var i=0;i<menuText.length;i++){ //get menu labels
         			menuTxtArr[i]= $(xml).find('menu'+i).text();
         			menuText[i].html(menuTxtArr[i]);
         		}
         		var phaseString=$(xml).find('phasebuttons').text(); //get phase button labels
         		phaseTxtArr = phaseString.split(";");
         		for (var p=0;p<8;p++){
         			phaseBtnTxt[p].html(phaseTxtArr[p]);
         		}
         		for (var h=0;h<2;h++){
         			champHead[h]=$(xml).find('head'+h).text();
         		}
         		sym.getSymbol("driverChampMc").$("driverChampTxt").html(champHead[0]);
         		var monthstring = $(xml).find('months').text(); //get month names
         		months=monthstring.split(";");
         		var statCapString=$(xml).find('statusCap').text();
         		statCap= statCapString.split(";");
         		var liveCapString=$(xml).find('statusTxt').text();
         		liveCap= liveCapString.split(";");
         		var countdownString=$(xml).find('countdown').text();
         		coundownCap= countdownString.split(";");
         		for (var c=0;c<15;c++){
         			caps[c]= $(xml).find('cap'+c).text(); //fixed text captions
         			if (c<capsText.length){
         				capsText[c].html(caps[c]);
         			}
         		}
         		sym.getSymbol("timingMc").$("timeTxt").html(caps[7]);
         		sym.getSymbol("globeMc").$("mapTxt0").html(caps[13]);
         		sym.getSymbol("globeMc").$("mapTxt1").html(caps[14]);
         		for (var r=0;r<raceArr.length;r++){			//get details for each race
         			$(xml).find("race"+r).each(function(){
         				var $races = $(this);
         				for (var n=0; n<5; n++){
         					raceArr[r][n] = $races.find('raceCap'+n).text();
         				}
         				gpDate[r]=$races.find('raceDate').text();
         				var cornerString=$races.find('corners').text();
         				raceCorners[r]=cornerString.split(";");		
         			});
         		}	
         		for (var i=0; i<raceText.length; i++){ //add labels for first race circuit
         			raceText[i].html(raceArr[0][i]);
         		}
         		for (var t=0;t<teamArr.length;t++){	
         			$(xml).find("team"+t).each(function(){
         				var $teams = $(this);
         				for (var m=0; m<2; m++){
         					teamTxtArr[t][m] = $teams.find('teamCap'+m).text(); 	//get details for each team
         				}
         				$teams.find("driver").each(function(){
         					var $driver = $(this);
         					driverTxtArr[t].push($driver);
         				});
         			});
         		}
         		sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(179, 196, 200)"});
         		getStats('FER',3);
         		sym.getSymbol(screenArr[3]).$("driveCar"+carPos).css({'left':carStop+'px'});	
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("mainCar").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("reflection").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("driverHead").attr("src","drivers/"+teamArr[0]+".png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheel").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheel").attr("src","cars/"+teamArr[0]+"fr.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheelR").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheelR").attr("src","cars/"+teamArr[0]+"fr.png");
         	},
         	complete: function(){
         				initSize(); counter=setInterval(countDown,1000);
         	}
         }); 
         //******************************* END XML *******************************************
         //******************************* MENU BUTTONS **************************************
         var raceNo=0, mob, mobGraph, raceIDno, clicked=0; //number to select live race
         for (var m = 0; m < 5; m++){
         	var menuBtnSymbols = sym.getSymbol("menuButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("menuButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         for (var m = 5; m < 8; m++){
         	var menuBtnSymbols = sym.getSymbol("raceButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("raceButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         });
         sym.getSymbol("raceButtons").$("menuBtn7").off('click');//unbind results button
         function resetmenu(){
         	sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-95px'},200);//show standings btns
         	sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-540px'},200);//show phases btns
         	sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'0px'},200);//hide
         	clicked=0;//reset clicked button
         	for (var i=0; i<menuArray.length; i++){
         		menuArray[i].$("menuBg").fadeIn(0);
         	}
         }
         var submenu;
         function menuBtnClick (e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         	resetmenu();
         		switch (menuMenu_id){
         			case(1)://show standings btns
         				if (submenu!=1){ sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'40px'},200);submenu=1; }else{ sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-95px'},200);submenu=0;}
         			break;
         			case(4)://show team btns
         				if (submenu!=4){ sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'40px'},200);submenu=4; }else{ sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-540px'},200);submenu=0;}
         			break;
         			case(6)://hide
         				if (submenu!=6){ sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'-285px'},200);submenu=6; }else{ sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'0px'},200);submenu=0;}
         			break;
         			default:
         				if(clicked!=menuMenu_id){ 
         				$(".screens").fadeOut(0);
         				}
         				menuMenu_id>1?sym.$(screenArr[menuMenu_id-1]).fadeIn(0):(mob==1)?sym.$("calendarMc").fadeIn(0):sym.$(screenArr[menuMenu_id]).fadeIn(0);
         				$(".gpname, gpdate, .gpstat").fadeIn(0);
         				sym.$("calendarMc").stop().animate({width:"40%"},0);
         				sym.$("circuitMc").stop().animate({width:"60%"},0);
         				sym.$("raceButtons").stop().animate({width:"60%"},0);
         				if (menuMenu_id==0){
         					getSeason();
         					clearInterval(seasonInterval);
         					seasonInterval=setInterval(getSeason,900000);
         					getRace(latestGP);
         				}
         				if (menuMenu_id==2){ //drivers champs
         					getDriverStandings();
         				}
         				if (menuMenu_id==3){ //team champs
         					getConsStandings();
         				}
         				if	(menuMenu_id==5){ //4 live 5 circuit, 6 timings 7 results
         						playIt(latestGPno);
         				}
         				if(menuMenu_id<5&&menuMenu_id!=0){
         				sym.$("raceButtons").animate({'bottom':'-25px'},400);
         				}else{
         					sym.$("raceButtons").animate({'bottom':'15px'},400);
         				}
         				clicked=menuMenu_id;	
         				initSize();
         			break;
         
         	}
         	menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         }
         menuArray[0].$("menuBg").fadeOut(0);//show first button as clicked
         //******************************* END MENU **************************************************
         //******************************* RESPONSIVE *****************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.stop(stageWidth*10);
         	//car animations
         	var symWidth=sym.$("teamChampMc").width();
         	var scaleCar=(symWidth<480)?symWidth/480:1;
         	sym.getSymbol("teamChampMc").$("carPic").css({'transform':'scale('+0.5*scaleCar+','+0.5*scaleCar+')'});
         	for (var i=0;i<2;i++){
         	 sym.getSymbol("driversMc").$("driveCar"+i).css({'transform':'scale('+0.55*scaleCar+','+0.55*scaleCar+')'});
         	}
         	var carWidth=sym.getSymbol("teamChampMc").$("carPic").width();
         	carStop=(symWidth-carWidth)/2;
         	sym.getSymbol("teamChampMc").$("carPic").css({'left':carStop+'px'});
         	sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':carStop+'px'});
         	$(".screens").fadeOut(0);
         	(symWidth<=480)?($(".griddriver").fadeOut(0),$(".driverShort").fadeIn(0)):($(".griddriver").fadeIn(0),$(".driverShort").fadeOut(0));
         	if(stageWidth<=480){
         		sym.getSymbol('styleMc').$('headlinetxt').html(headlinemob);
         		$(".resultrace").css({'font-size':'12px'});
         		$(".liverace").css({'font-size':'12px'});
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$((countryArr[latestGPno].toUpperCase())+"mini").fadeIn(0);
         		mob=1;
         	}else{
         		sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         		$(".resultrace").css({'font-size':'12px'});
         		$(".liverace").css({'font-size':'12px'});
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$((countryArr[latestGPno].toUpperCase())+"mini").fadeOut(0);
         		mob=0;
         	}
         	if(stageWidth>=640){
         		sym.$('calendarMc').fadeIn(0);
         		if(clicked>1&&clicked<5){
         		sym.$(screenArr[clicked-1]).fadeIn(0);
         		}else if(clicked==6){
         		sym.$(screenArr[4]).fadeIn(0);//liveMc
         		}else if(clicked==8){
         		sym.$(screenArr[6]).fadeIn(0);//timingMc
         		}else{
         		sym.$(screenArr[clicked]).fadeIn(0);
         		}
         		if(clicked==5){ sym.$('calendarMc').css({'width':'10%'});sym.$('circuitMc').css({'width':'90%'}); sym.$('raceButtons').css({'width':'90%'});};
         	}else{
         		sym.$('calendarMc').fadeOut(0);
         		if(clicked>1){
         			if(clicked<5){
         			sym.$(screenArr[clicked-1]).fadeIn(0);
         			}else{
         				if(clicked==6){
         						sym.$(screenArr[4]).fadeIn(0);//liveMc
         				}else if(clicked==8){
         					sym.$(screenArr[6]).fadeIn(0);//timingMc
         				}else{
         					sym.$(screenArr[clicked]).fadeIn(0);
         				}
         			}
         		}else{
         		sym.$('calendarMc').fadeIn(0);
         		}
         	}
         	clicked==5?$(".gpname, .gpdate, .gpstat").fadeOut(0):$(".gpname, .gpdate, .gpstat").fadeIn(0);
         	mobGraph=(symWidth<=400)?1:0;
         	var globeWidth=sym.$("globeMc").width();	//globe centre
         	sym.getSymbol('globeMc').$('globe').css({'left':(globeWidth-230)/2+'px'});
         	sym.getSymbol("globeMc").$("countdown").css({'left':(globeWidth-320)/2+'px'});
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("playPause").css({'left':((sym.$("circuitMc").width())-50)/2+'px'});
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("gearsMc").css({'left':((sym.$("circuitMc").width())-132)/2+'px'});
         	var menuWidth=sym.$("menuButtons").width()/3;	//buttons centre icons
         	var racebtnWidth=sym.$("raceButtons").width()/3;
         	for (var i=0;i<menuArray.length;i++){
         		i<5?(sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").css({'left':(menuWidth-37)/2+'px'}),(mob==1?menuText[i].fadeOut(0):menuText[i].fadeIn(0))):sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("icon").css({'left':(racebtnWidth-37)/2+'px'});
         	}
         	for (var j=0;j<teamArr.length;j++){
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({'left':(menuWidth-45)/2+'px'});
         	}
         };
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //***************************** END RESPONSIVE ***********************************
         //***************************** DATE FUNCTIONS ***********************************
         var d=new Date();
         function getDDMMYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth() + 1;
         	var dd = thisDate.getDate()+1;
         	mm = ((mm < 10) ? '0' : "") + mm;
         	dd = ((dd < 10) ? '0' : "") + dd;
         	return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
         }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate()+1;
         	return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         }
         //***************************** END DATE **************************************
         //******************************* TEAM STRIP BUTTONS ************************************************
         var carPos=0, hidden=1, teamIndex=0;//for showTeam
         sym.getSymbol("driversMc").$("nextBtn").on("click",nextTeam); sym.getSymbol("driversMc").$("lastBtn").on("click",lastTeam);
         sym.$("driversMc").on("swipeleft",nextTeam); sym.$("driversMc").on("swiperight",lastTeam);
         function nextTeam(){
         	$(".prevnext").fadeOut(0);
         	teamIndex=(teamIndex==9)?0:teamIndex+1;
         	teamDetails(teamArr[teamIndex]);
         }
         function lastTeam(){
         	$(".prevnext").fadeOut(0);
         	teamIndex=(teamIndex==0)?9:teamIndex-1;
         	teamDetails(teamArr[teamIndex]);
         }
         var showTeam = function(team){ //to handle lexical scope
         	return function (e) {
         		teamDetails(team);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         function teamDetails(teamdetails){
         	resetmenu();
         	teamIndex=teamArr.indexOf(teamdetails);
         	sym.$(screenArr[3]).fadeIn(200);
         	sym.$("raceButtons").animate({'bottom':'-25px'},400);
         	menuArray[4].$("menuBg").fadeOut(0);
         	getStats(teamdetails,3);
         		if (carPos==0){
                  carPos=1;
                  hidden=0;
               }else{
                  carPos=0;
                  hidden=1;
               }
               sym.getSymbol("driversMc").$("teamlogo").attr("src","images/"+teamdetails+"bg.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':'-200%'});	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("mainCar").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("reflection").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("driverHead").attr("src","drivers/"+teamdetails+".png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("bkwheel").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("frwheel").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheelR").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheelR").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).delay(1600).stop().animate ({left:carStop}, 1100);	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).play();
         		sym.getSymbol("driversMc").$("driveCar"+hidden).stop().animate ({left:'110%'}, 1200);
         		sym.getSymbol("driversMc").getSymbol("driveCar"+hidden).play();
         		var team=teamdetails;
         		clicked=4;
         		initSize();
         		$(".prevnext").stop().delay(1200).fadeIn(1200);
         }
         for (var j=0;j<teamArr.length;j++){ //Create team buttons
         	sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({"cursor":'pointer'});
         	sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).click(showTeam(teamArr[j]));
         }
         //******************************* END TEAM BUTTONS *******************************************
         function setStyle(){
         	$(".continents").css({"-webkit-border-radius":"50%","-khtml-border-radius":"50%","-moz-border-radius":"50%","border-radius":"50%","-webkit-mask-image":"-webkit-gradient(linear, left top, right top, color-stop(0, rgba(0,0,0,1)), color-stop(1, rgba(0,0,0,1)))"});
         }
         setStyle();
         //***************************** LIVE DATA ****************************************
         var latestGP, seasonInterval,conInterval,driverInterval,gpInterval,phaseInterval,scrubPos=1, raceFinished; //REFRESH RATE
         //FUNCTIONS
         //STATUS COUNTDOWN - TIME
         var counter, raceDate, diff=0, todayDate = new Date(), localOffset=todayDate.getTimezoneOffset()*60000, timeAdjust=0;//localOffset=0;//Mar22
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10)+localOffset+timeAdjust;//Mar22
         	return dDate;
         } 
         var countdownPath=sym.getSymbol("globeMc").getSymbol("countdown");
         function countDown(){
         	//var gpDate= Date.UTC(raceDate)//Mar22
         	todayDate = new Date();
         	diff = raceDate-todayDate;
         	var days = Math.floor(diff/86400000);
         	var hours = Math.floor((diff%86400000)/3600000);
         	var mins = Math.floor((diff%86400000)%3600000/60000);
         	var secs = Math.floor((diff%86400000)%3600000%60000/1000);
         	var dd = leadingZero(days).toString();	
         	var hh = leadingZero(hours).toString();
         	var mm = leadingZero(mins).toString();
         	var ss = leadingZero(secs).toString();
         	if(todayDate<raceDate){
         		sym.getSymbol("globeMc").$("countdown").fadeIn(0);//Mar 24
         		var gpdiff = raceDate-todayDate;
         		var gpdays = Math.floor(gpdiff/86400000);
         		if (gpdays>1){//Mar22 (gpdays>0)
         			for(var i=0;i<4;i++){ sym.getSymbol("globeMc").getSymbol("countdown").$("timeTxt"+i).html(coundownCap[i].toUpperCase()); }
         			countdownPath.$("dd1").attr("src","images/"+dd.substring(0,1)+".png"); countdownPath.$("dd2").attr("src","images/"+dd.substring(1)+".png");
         			countdownPath.$("hh1").attr("src","images/"+hh.substring(0,1)+".png"); countdownPath.$("hh2").attr("src","images/"+hh.substring(1)+".png");
         			countdownPath.$("mm1").attr("src","images/"+mm.substring(0,1)+".png"); countdownPath.$("mm2").attr("src","images/"+mm.substring(1)+".png");
         			countdownPath.$("ss1").attr("src","images/"+ss.substring(0,1)+".png"); countdownPath.$("ss2").attr("src","images/"+ss.substring(1)+".png");
         		}else{
         			sym.getSymbol("globeMc").$("mapTxt1").html("");
         			sym.getSymbol("globeMc").$("countdown").fadeOut(0);//Mar 24
         		}
         	}
         }
         function leadingZero(time) {
             return (time < 10) ? "0" + time : time;
         }
         //END COUNTDOWN
         function spinGlobe(gpno){
         	var x=Math.round(-591-(parseInt((latlong[gpno][1]),10)*500/360));	var xBack=Math.round(-420+(parseInt((latlong[gpno][1]),10)*500/360));
         	var y=Math.round(115-(Math.sin((latlong[gpno][0])*Math.PI*0.75/180)*115)+3);
         	sym.getSymbol("globeMc").getSymbol("globe").getSymbol("continents").$("mapFront").stop().animate({left:x},700,'easeOutCubic');
         	sym.getSymbol("globeMc").getSymbol("globe").getSymbol("continents").$("mapBack").stop().animate({left:xBack},700,'easeOutCubic');
         	sym.getSymbol("globeMc").getSymbol("globe").$("dot0").stop().animate({'top':y},700,'easeOutElastic');
         	sym.getSymbol("calendarMc").$("graph").stop().animate({scrollTop:45*gpno},200);
         	}
         function raceDetails(gp,gpNo){//get circuit
         	getRace(gp);
         	latestGP=gp;
         	for (var i=0; i<raceText.length; i++){ //add labels for race circuit
         		raceText[i].html(raceArr[gpNo][i]);
         	}
         	sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("gpTxt").html(raceArr[gpNo][1].toUpperCase());
         	for (var r=0; r<raceCorners[gpNo].length;r++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("corner"+r).html(raceCorners[gpNo][r]);
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("corner"+r).css({'font-size':'14px','line-height':'15px'});
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("pit").html(raceCorners[gpNo][raceCorners[gpNo].length-1]);
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("pit").css({'font-size':'14px'});
         	}
         	stopIt();
         	scrubPos=1;//reset scrub position
         	$(".circuits").fadeOut(0); //all circuits
         	$(".minicircuits").fadeOut(0); //all mini circuits
         	for (var n=0;n<countryArr.length; n++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[n].toUpperCase())+"Mc").getSymbol("carMc").stop();						
         	}
         	sym.getSymbol("circuitMc").$((countryArr[gpNo].toUpperCase())+"Mc").fadeIn(0);
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$((countryArr[gpNo].toUpperCase())+"mini").fadeIn(0);
         }
         var showGP = function(gp,status,gpNo){ //get race
         	return function (e) {
         		resetmenu();
         		$(".screens").fadeOut(0);
         		sym.$("raceButtons").animate({'bottom':'15px'},400);
         		latestGPno=gpNo;
         		raceDetails(gp,gpNo);			
         		sym.getSymbol("resultMc").$("gpTxt").html(raceArr[gpNo][0]);
         		sym.getSymbol("raceButtons").$("menuBtn7").off('click');//unbind results button
         		sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("menuTxt").css({"opacity":0.3});sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("icon").css({"opacity":0.3});
         		sym.getSymbol("raceButtons").$('menuBtn5').off('click',playLatest);//unbind circuit button
         		for (var n=0;n<8; n++){
         			sym.getSymbol("raceButtons").getSymbol("phaseBtn"+n).$("btnBg").css({'background-color':'rgb(93,115,120)','border':'solid 1px rgb(255,255,255)'});
         			sym.getSymbol("raceButtons").$("phaseBtn"+n).off('click'); sym.getSymbol("raceButtons").$("phaseBtn"+n).css({"opacity":0.3});
         		}
         		sym.getSymbol("circuitMc").$("weather").attr('src','images/weather0.png');//sprite
         		sym.getSymbol("circuitMc").$("weatherTxt").fadeOut(0);
         		//sym.getSymbol("circuitMc").$("statusTxt").html(statCap[4]);
         		//sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);
         		sym.getSymbol("timingMc").$("loading").fadeIn(0);
         		sym.getSymbol("liveMc").$("loading").fadeIn(0);
         		sym.getSymbol("resultMc").$("loading").fadeIn(0);
         		sym.getSymbol("timingMc").$("graph").empty();
         		sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt0").empty();
         		sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").empty();
         		for (var i = 0; i < (teamArr.length*2); i++) {
         			sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).stop().animate({'top':781}, 0);								
         			sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();
         		}
         		sym.getSymbol("timingMc").$("gridSlider").fadeOut(0);
         		sym.getSymbol("timingMc").$("graph").fadeOut(0);
         		sym.getSymbol("timingMc").$("timeTxt").fadeOut(0);
         		clearInterval(seasonInterval);
         	inPlay=false;
         		if (status==0){//Pre-race
         			sym.getSymbol("circuitMc").$("statusTxt").html(gpDate[gpNo]);
         			sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(179, 196, 200)"});
         			sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);
         			menuArray[5].$("menuBg").fadeOut(0);
         			sym.$(screenArr[5]).fadeIn(0);
         			playIt(gpNo);
         			clicked=5;
         		}else if(status==2){//Live
         			menuArray[6].$("menuBg").fadeOut(0);
         			sym.$(screenArr[4]).fadeIn(0);
         			clicked=6;
         		}else if(status==4){//Finished
         			menuArray[7].$("menuBg").fadeOut(0);
         			sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("menuTxt").css({"opacity":1});sym.getSymbol("raceButtons").getSymbol("menuBtn7").$("icon").css({"opacity":1});
         			sym.$(screenArr[7]).fadeIn(0);
         			clicked=7;
         		}
         		sym.getSymbol("raceButtons").$('menuBtn5').on('click',playLatest(gp,gpNo));
         		sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:gpNo*45+'px'},400);
         		$(".gpweekend").css({'background-color':'rgba(230,225,215,0)'});
         		$("#gp"+gpNo).css({'background-color':yel});
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         // PLAY/PAUSE BTN
         var inPlay;
         sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("playPause").on('click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").is(":visible") ) {
         		playIt(latestGPno);
         	} else{
         		stopIt();
         	}
         });
         function playIt(number){ //play circuit animation
         	if (inPlay==false){
         		startTimer();
         		$(".gpname, .gpdate, .gpstat").fadeOut(0);
         		if(stageWidth>=640){
         		sym.$("calendarMc").stop().animate({width:"10%"},200);
         		sym.$("circuitMc").stop().animate({width:"90%"},200);
         		sym.$("raceButtons").animate({width:"90%"},200);
         		}else{
         		sym.$("calendarMc").stop().animate({width:"10%"},0);
         		sym.$("circuitMc").stop().animate({width:"100%"},0);
         		sym.$("raceButtons").animate({width:"100%"},0);
         		}
         		sym.getSymbol("circuitMc").getSymbol((countryArr[number].toUpperCase())+"Mc").getSymbol("carMc").play();	
         		sym.getSymbol("circuitMc").getSymbol((countryArr[number].toUpperCase())+"Mc").play(scrubPos);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol((countryArr[number].toUpperCase())+"mini").play(scrubPos);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeOut(0);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeIn(0);
         		sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'hidden'});
         		inPlay=true;
         	}
         }
         function stopIt() {
         	stopTimer();
         	for(var r=0;r<countryArr.length;r++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[r].toUpperCase())+"Mc").stop();
         		sym.getSymbol("circuitMc").getSymbol('circuitOverlay').getSymbol((countryArr[r].toUpperCase())+"mini").stop();
         	}
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeIn(0);
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeOut(0);
         	sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'auto'});
         	scrubPos=sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").getPosition();
         	scrubPos=(scrubPos>1&&scrubPos<15000)?scrubPos:1;
         	inPlay=false;
         }
         var playLatest = function(gp,gpNo){
         	return function (e) {
         		raceDetails(gp,gpNo);
         		playIt(gpNo);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         var playTimer=0;
         function startTimer() {
         	playTimer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var symWidth=sym.$("circuitMc").width();
         	var pos = sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").getPosition();
         	var x = sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").$("carMc").position();
         	sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").stop().animate({scrollLeft: x.left+20}, 500);
         	if (pos == 0 || pos == 15000) {
         		stopIt();
         		sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'auto'});
         	}else{
         
         	}
         }
         function stopTimer() {
         	clearInterval(playTimer);
         }
         var showPhase = function(phaseNo,stage,session){//show phase timing graph
         	return function(e){
         		resetmenu();
         		$(".screens").fadeOut(0);
         			$(".gpname, gpdate, .gpstat").fadeIn(0);
         			sym.$("calendarMc").stop().animate({width:"40%"},0);
         			sym.$("circuitMc").stop().animate({width:"60%"},0);
         			sym.$("raceButtons").stop().animate({width:"60%"},0);
         		sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);
         		if (stage<6){
         			if(stage<3){
         				var stageCap=statCap[0];
         			}else{
         			var stageCap=statCap[1];
         			}
         			getPhases(phaseNo);
         			sym.$("timingMc").fadeIn(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeOut(0);
         			sym.getSymbol("timingMc").$("graph"). fadeIn(0);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeIn(0);
         			sym.getSymbol("timingMc").$("statusTxt").html(stageCap+" "+session);
         			sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);
         			var statWidth=sym.getSymbol("timingMc").$("statusTxt").width();
         			sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(225,5,20)'});
         			selectPhase=6;
         			clicked=8;
         		}else if(stage==6){
         			getGrid(phaseNo);
         			sym.$("timingMc").fadeIn(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeIn(0);
         			sym.getSymbol("timingMc").$("graph"). fadeOut(0);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeOut(0);
         			sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);
         			sym.getSymbol("timingMc").$("statusTxt").html(raceArr[latestGPno][0]+" "+statCap[2]);
         			sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(225,5,20)'});
         			selectPhase=6;
         			clicked=8;
         		}else{
         			getLive(phaseNo);
         			sym.$(screenArr[6]).fadeOut(0);//timing
         			sym.$(screenArr[4]).fadeIn(0);//live
         			selectPhase=4;
         			clicked=6;
         		}
         		menuArray[6].$("menuBg").fadeOut(0);
         		sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'0px'},400);
         		for (var i=0; i<8;i++){
         			if(i==stage){
         				sym.getSymbol('raceButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(0,0,0)'});
         			}else{
         				sym.getSymbol('raceButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(93,115,120)'});//93,93,93
         			}
         		}
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         	}
         };
         function showFinished(){//Elements if race finished
         	raceFinished=1;
         }
         function sessLiveOrFin(latest,number,status){//Elements to show if live or finished
         	var stat=(number>0)?number+" "+status:status;
         	sym.getSymbol("circuitMc").$("statusTxt").html(latest+" "+stat);
         	sym.getSymbol("liveMc").$("statusTxt").html(latest+" "+stat);
         }
         function pieChart(data1,data2,data3,placeholder){
         var width = 120;
         var height = 120;
         var svg = d3.select(placeholder).append("svg")
           .attr("height", height).attr("width", width);
         var g = svg.append('g')
           .attr('transform', 'translate(' + width / 2 + ',' + height / 2 + ')')
           .style('-webkit-transform', 'translate('+width/2+'px,'+height/2+'px)');
         var color = d3.scale.ordinal().range(["#ff0000","#edbdbd","#e6e1d7","#f0f0f0"]);
         var min = Math.min(width, height);
         var oRadius = min / 2;
         var iRadius = min / 2 * 0.88;
         // construct default pie layout
         var pie = d3.layout.pie().value(function(d){ return d; }).sort(null);
         // construct arc generator
         var arc = d3.svg.arc()
           .outerRadius(oRadius)
           .innerRadius(iRadius);
         var dataSet = [ data1,data2,data3];
         // enter data and draw pie chart
         var path = g.datum(dataSet).selectAll("path")
           .data(pie)
           .enter().append("path")
             .attr("class","piechart")
             .attr("fill", function(d,i){ return color(i); })
             .attr("d", arc)
           .each(function(d){ this._current = d; })
         }
         //END FUNCTIONS
         //*************************** LIVE DATA ****************************
         function getSeason(){//get live season data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=season&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("calendarMc").$('loading').fadeOut(0);
         			sym.getSymbol("calendarMc").$("graph").empty();
         			var seasondata=data;
         			if(data.length>0){
         				var raceFinished, raceLive, gpflag, flagHTML, gpstatusHTML,latestStatus;
         				for (var i = 0; i < seasondata.length; i++) {
         					var gpID = seasondata[i].n_EventPhaseID;
         					var gpStatus=seasondata[i].n_StatusCode;
         					var countryShort = seasondata[i].c_CountryShort;
         					var orderNo;
         						if(i==0){
         							orderNo=i;
         						}
         						if(gpStatus>512){//Cancelled
         							orderNo=i;
         						}else{
         							orderNo++;
         						if(seasondata[i].b_Current==true){
         							if(gpStatus>=128){//race finished
         								racestatus = 4;
         								sym.getSymbol("globeMc").$("mapTxt1").html("");//Replace countdown
         							}else if(gpStatus>=8&&gpStatus<192){//live
         								racestatus = 2;
         							}else{//not started
         								racestatus = 0;
         							}
         							raceDate=parsedDate(seasondata[i].d_DateEnd);//seasondata[i].d_DateStart = date of current GP //Mar22
         							timeAdjust=seasondata[i].d_DateStart.substr(-6,4)*36000;//Mar22
         							latestGP=gpID; //assign latest race to menu buttons
         							latestGPno=i;
         							latestStatus=racestatus;
         							sym.getSymbol("raceButtons").$('menuBtn5').off('click',playLatest);
         							sym.getSymbol("raceButtons").$('menuBtn5').on('click',playLatest(gpID,i));
         						}else if(seasondata[i].b_Finished==true){
         							racestatus = 4;
         						}else{
         							racestatus = 0;
         						}
         						if(i==seasondata.length-1&&racestatus==4){
         							seasonstatus=2;//finished
         						}else if(racestatus>0){
         							seasonstatus=1;//mid-season
         						}
         						var seasonText="<div class='gpseason'>";//create season graph
         						seasonText +="<table class='gpweekend' id='gp"+i+"'><tr>";
         						seasonText +="<td class='gpflag' id='gpflag"+i+"'></td>";
         						seasonText +="<td class='gpname' id='gpname"+i+"'></td>";
         						seasonText +="<td class='gpdate' id='gpdate"+i+"'></td>";
         						seasonText +="<td class='gpstat' id='gpstatus"+i+"'></td>";
         						seasonText +="</tr></table>";
         						seasonText +="</div>";	
         						sym.getSymbol("calendarMc").$("graph").append(seasonText);
         						gpflag =  countryArr[i];
         						flagHTML = "<img src='images/" +gpflag+ "Flag.png' height='35px' width='30px'>";//sprite
         						gpstatusHTML = "<img src='images/flag" +racestatus+ ".png' height='26px' width='26px'>";//sprite
         						//var gpdate=getDDmonthYY(seasondata[i].d_DateEnd);
         						$('#gp' + i).css({'cursor':'pointer'});
         						$('#gp' + i).on('click',showGP(gpID,racestatus,i));
         						$('#gpflag' + i).html(flagHTML);
         						$('#gpname' + i).text(raceArr[i][0]);
         						$('#gpdate' + i).html(gpDate[i]);
         						$('#gpstatus' + i).html(gpstatusHTML);
         						$('.gpseason').css({'width':'100%','height':'42px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','font-family':'Helvetica, Arial, sans-serif','font-size':'14px'});
         						$('.gpweekend').css({'width':'100%'});
         						$('.gpflag').css({'width':'10%','text-align':'center'});
         						$('.gpname').css({'width':'42%','font-weight':700,'font-size':'14px'});
         						$('.gpdate').css({'width':'38%', 'font-style':'oblique','text-align':'left'});
         						$('.gpstat').css({'width':'10%','padding':'3px'});
         					}
         				}
         				$("#gp"+latestGPno).css({'background-color':yel});
         				if (loaded==0){
         					spinGlobe(latestGPno);
         					var latestStatCap=(latestStatus==4)?liveCap[2]:(latestStatus==2)?liveCap[1]:caps[13];
         					latestStatCap=latestStatCap.toUpperCase();
         					sym.getSymbol("globeMc").$("mapTxt0").html(latestStatCap+": "+raceArr[latestGPno][0]);
         					if(seasonstatus==2){//get championship standings
         						getDriverStandings();
         						resetmenu();
         						sym.$("raceButtons").animate({'bottom':'-25px'},400);
         						clicked=2;	
         						initSize();
         					}
         				}
         				loaded++;
         			}else{
         				console.log("Season data failed");
         				setTimeout(getSeason, 5000);
         			}
         		},
         		error:function(){
         			setTimeout(getSeason, 5000);
         		}
         	});
         	initSize();
         }
         getSeason();
         seasonInterval = setInterval(getSeason,900000);
         
         function getStartList(){//get startlist data if race hasn't started
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=startlist&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var startData=data;
         			if (startData.length>20){
         				barHeight = ((590/startData.length)-4);
         			}else{
         				barHeight = 24;
         			}
         			for (var i=0; i<startData.length; i++){
         				if(i==0){ //show lead driver details
         					var drivershort = startData[i].c_PersonShort;
         					var driverID = startData[i].n_PersonID;
         					var imgCar = startData[i].c_TeamShort;
         					var leadDriver = '<b>' +startData[i].c_Person+ '</b> ' +startData[i].c_NOCShort+ '</span>';
         					sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         					sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         				}	
         				var tableText ="<div class='driverschamp'>";
         				tableText += "<div id='driverdata"+i+"'>";
         				tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				tableText += "<td id='driverrnk"+i+"' width='25px' style='font-weight:bold'></td>";
         				tableText += "<td id='driverNm"+i+"'width='100px'></td>";
         				tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         				tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         				tableText += "</tr></table>";
         				tableText += "</div></div>";
         				sym.getSymbol("driverchampMc").$("graph").append(tableText);
         				$('#driverrnk' + i).text(i+1);		
         				$('#driverNm' + i).text(startData[i].c_PersonShort);
         				$('#driverteam' + i).text(startData[i].c_TeamShort);
         				if (i==0){
         					$('#driverpts' + i).text("0"+caps[12]);
         				}else{
         					$('#driverpts' + i).text("0");
         				}
         				$(".driverschamp").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%', 'margin-bottom':'4px','line-height':'150%'});
         				$("#driverdata" + i).css({'height':barHeight+'px','width':'60%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         				$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         				$("#driverdata" + i).animate({width:scale+'%'},1500);
         				sym.getSymbol("driverchampMc").$("graph").css({'margin-top':'3px'});
         			}
         		}
         	});
         }
         var barHeight, nRaceDrivers, maxPoints, scale;
         function getDriverStandings(){//get drivers championship data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=champdrivers&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var rankData = data;
         			sym.getSymbol("driverChampMc").$("loading").hide();
         			sym.getSymbol("driverChampMc").$("graph").empty();
         			if (!data){
         				getStartList();
         			}else{
         			//Ensure all drivers will fit in graph
         				nRaceDrivers = rankData.length;
         				if (rankData.length>20){
         					barHeight = ((510/rankData.length)-4);
         				}else{
         					barHeight = 20;
         				}
         				//calculate relative length of each bar
         				maxPoints = rankData[0].n_PointsSort;
         				var min = (maxPoints!=null) ? maxPoints : 0;
         				for (var n=0; n<rankData.length; n++) {
         					if (rankData[n].n_PointsSort!=null && rankData[n].n_PointsSort<min) {
         						min = rankData[n].n_PointsSort;									
         					}
         				}					
         				for (var i = 0; i < rankData.length; i++) {
         					if(i==0){ //show lead driver details
         						var drivershort = rankData[i].c_PersonShort;
         						var driverID = rankData[i].n_PersonID;
         						var imgCar = rankData[i].c_TeamShort;
         						var leadDriver = '<b>' +rankData[i].c_Person+ '</b> ' +rankData[i].c_NOCShort+ '</span>';
         						sym.getSymbol("driverChampMc").$("driversTxt").html(leadDriver);
         						sym.getSymbol("driverChampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");//sprite
         					}
         					var tableText ="<div class='driverschamp'>";//build drivers standings table
         					tableText += "<div id='driverdata"+i+"' class='driverbar'>";
         					tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					tableText += "<td id='driverrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         					tableText += "<td id='driverNm"+i+"'width="+(mobGraph==1?'90px':'100px')+"></td>";
         					tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         					tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div></div>";
         					sym.getSymbol("driverChampMc").$("graph").append(tableText);
         					var teamLogo='<img class="teamsmall" src="images/'+ rankData[i].c_TeamShort +'.png" width="16px">';
         					if (rankData[i].n_Rank!=null){
         						$('#driverrnk' + i).text(rankData[i].n_Rank);
         					}else{
         						$('#driverrnk' + i).text(i+1);
         					}		
         					$('#driverNm' + i).text((rankData[i].c_PersonShort).toUpperCase());
         					$('#driverteam' + i).html(teamLogo);
         					if (rankData[i].c_Points!=null){
         						if (i==0&&caps[12]!=undefined){
         							$('#driverpts' + i).text(rankData[i].c_Points+caps[12]);
         						}else{
         							$('#driverpts' + i).text(rankData[i].c_Points);
         						}	
         					}else{
         						$('#driverpts' + i).text("0");
         					}					                                        
         					if (maxPoints==min && rankData[i].n_PointsSort==maxPoints) {
         						scale=100;//max length
         					}else if(rankData[i].n_PointsSort==null){
         						scale=54; //min length
         					}else{
         						scale = 100-((maxPoints-rankData[i].n_PointsSort)*45/(maxPoints-min));
         					}
         					$("#driverdata" + i).css({'height':barHeight+'px','width':'54%'});
         					$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         					$("#driverdata" + i).animate({'width':scale+'%'},800,'easeOutQuad');
         					sym.getSymbol("driverChampMc").$("graph").css({'margin-top':'3px'});
         				}
         				$(".driverschamp").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%', 'margin-bottom':'4px','line-height':'150%'});
         				$(".driverbar").css({'background-color':graphcolor, 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         				$("img.teamsmall").css({'margin-bottom':'-4px','width':'16px'});
         			}
         		}
         	});
         }
         var nTeams, teamBar;
         function getConsStandings(){//get constructors championship live data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=champteams&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var teamData = data;
         			sym.getSymbol("menuButtons").$("menuBtn3").off('click',menuBtnClick);//disable button
         			if (!data){//if championship hasn't started
         				sym.getSymbol("menuButtons").$("menuBtn3").on ("click", {menuId:4}, menuBtnClick);//reassign button
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn3").on ("click", {menuId:3}, menuBtnClick);
         				sym.getSymbol("teamChampMc").$("loading").css({'display':'none'});
         				sym.getSymbol("teamChampMc").$("graph").empty();
         				sym.getSymbol("teamChampMc").$("teamTxt0").html(champHead[1]);
         				//Ensure all teams will fit in graph
         				nTeams = teamData.length;
         				if (teamData.length>=10){
         					teamBar = ((297/teamData.length)-5);
         				}else{
         					teamBar = 25;
         				}
         				//calculate relative length of each bar
         				teamPoints = teamData[0].n_PointsSort;
         				var minpts = (teamPoints!=null) ? teamPoints : 0;
         				for (var n=0; n<teamData.length; n++) {
         					if (teamData[n].n_PointsSort!=null && teamData[n].n_PointsSort<minpts) {
         						minpts = teamData[n].n_PointsSort;									
         					}
         				}	
         				for (var i = 0; i < teamData.length; i++) {
         					teamname=teamData[i].c_TeamShort;
         					longname=teamData[i].c_Team;
         					var teamindex=teamArr.indexOf(teamname);
         					var teamtxt=(teamindex>=0)?teamTxtArr[teamindex][0]:"";		
         					if(i==0){ //show lead team details
         						var imgCar = teamData[i].c_TeamShort;
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("mainCar").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("reflection").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("driverHead").attr("src","drivers/"+imgCar+".png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("bkwheel").attr("src","cars/"+imgCar+"bk.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("frwheel").attr("src","cars/"+imgCar+"fr.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("teamlogo").attr("src","images/"+imgCar+"bg.png");
         						//getStats(teamname,2);
         					}
         					var constructorsText ="<div class='teamchamp'>";//build championship table
         					constructorsText += "<div id='teamdata"+i+"' class='teambar'>";
         					constructorsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					constructorsText += "<td id='teamrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         					constructorsText += "<td id='teamLogo"+i+"' width="+(mobGraph==1?'1px':'20px')+"></td>";
         					constructorsText += "<td id='teamNm"+i+"'></td>";
         					constructorsText += "<td id='teampts"+i+"' style='font-weight:bold'></td>";
         					constructorsText += "</tr></table>";
         					constructorsText += "</div></div>";
         					sym.getSymbol("teamChampMc").$("graph").append(constructorsText);
         					var teamLogo=(mobGraph==1)?'':'<img class="teamsmall" src="images/'+ teamData[i].c_TeamShort +'.png">';
         					if (teamData[i].n_Rank!=null){
         						$('#teamrnk' + i).text(teamData[i].n_Rank);
         					}else{
         						$('#teamrnk' + i).text(i+1);
         					}
         					$('#teamLogo' + i).html(teamLogo);
         					//$('#teamNm' + i).text((teamData[i].c_Team).toUpperCase());
         					$('#teamNm' + i).text(teamtxt);
         					if(teamData[i].c_Points!=null){
         						if (i==0){
         							$('#teampts' + i).text(teamData[i].c_Points+caps[12]);
         						}else{
         							$('#teampts' + i).text(teamData[i].c_Points);
         						}
         					}else{
         						$('#teampts' + i).text("0");
         					}					                                        
         					if (teamPoints==minpts && teamData[i].n_PointsSort==teamPoints) {
         						scale=100;//max length of bar
         					}else if(teamData[i].n_PointsSort==null){
         						scale=(mobGraph==1)?70:56;//minimum
         					}else{
         						scale = 100-((teamPoints-teamData[i].n_PointsSort)*(mobGraph==1?30:44)/(teamPoints-minpts));
         					}
         					$("#teamdata" + i).css({'height':teamBar+'px','width':'55%'});
         					$("#teamdata" + i).stop().animate({'width':scale+'%'},800,'easeOutQuad');
         					$("#teampts" + i).css({'text-align':'right', 'padding-right':'3px'});
         				}
         				sym.getSymbol("teamChampMc").$("graph").css({'margin-top':'3px'});
         				$(".teamchamp").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%','margin-bottom':'3px','line-height':'150%'});
         				$(".teambar").css({'background-color':graphcolor, 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)','padding-top':'2px'});
         				$("img.teamsmall").css({'margin-bottom':'-2px','width':'16px'});
         			}
         		}
         	});
         }
         getDriverStandings();
         getConsStandings();
         var flag1txt, flag2txt;
         function getStats(teamdetails,view){//show team facts from xml arrays
         	sym.getSymbol(screenArr[view]).$("teamTxt0").css({'font-weight':700});	//team name	
         	var headprefix=(view==2)?champHead[1]+": ":"";
         	for (var i=0;i<teamArr.length;i++){
         		if (teamdetails==teamArr[i]){
         			sym.getSymbol(screenArr[view]).$("teamTxt0").html((view==2)?champHead[1]:teamTxtArr[i][0]);//if view=3 Constructors else team name
         			sym.getSymbol(screenArr[view]).$("teamTxt1").html(teamTxtArr[i][1]);
         			//create array of each team in xml, 
         			for (var n=0;n<2;n++){
         					var number=driverTxtArr[i][n].find('d0').text();var name =driverTxtArr[i][n].find('d1').text();
         					var stats=driverTxtArr[i][n].find('d2').text();var nat=driverTxtArr[i][n].find('d3').text();var natTxt=(nat=='null')?"":nat;
         					var id = driverTxtArr[i][n].find('driverid').text().toString();
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt0").html(number);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt1").html(name);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt2").html(natTxt);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt3").html(stats);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverflag").attr("src","images/"+nat+".gif");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverpic").attr("src","drivers/"+id+".jpg");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverHelmet").attr("src","drivers/"+id+".png");
         			}
         		}
         	}
         }
         var raceStage;
         function getRace(raceID){ //GET race weekend live data
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=race&race="+raceID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {                	
         			var racePhases = data;
         			var n;//session number
         			var latestPhase;var getFunction;var phaseBtnNo;
         			for (var i = 0; i < racePhases.length; i++) {
         				sym.getSymbol("raceButtons").$("phaseBtn"+i).off("click");
         				phase=racePhases[i].n_PhaseID;
         				var sessionNo=(racePhases[i].n_SessionNr>0)?racePhases[i].n_SessionNr:"";
         				var sessLive=(racePhases[i].b_Current==true)?1:0;
         				var sessStarted=(racePhases[i].b_Started==true)?1:0;
         				var sessFin=(racePhases[i].b_Finished==true)?1:0;
         				var nullSession=0;
         				if (racePhases[i].b_FreePractice==true){//free practice
         					n = racePhases[i].n_Phase1Nr;						
         					phaseBtnNo=sessionNo-1;
         					raceStage = "FP";
         					if(racePhases[i].b_Started==true){
         						latestPhase = statCap[0];
         					}else if(sessLive==1&&sessStarted==0){//Apr7
         						latestPhase = statCap[0];
         					}else{
         						if(n==1){
         							sessLive=0;
         						}
         						latestPhase = statCap[4];
         						sessionNo="";
         					}
         				}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr==null){//show nothing if null
         					sessLive=0;
         					sessFin=0;
         					sessStarted=0;	
         					nullSession=1;													
         				}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr>0){//qualifying						
         					n = racePhases[i].n_Phase2Nr;
         					phaseBtnNo=sessionNo+2;						
         					raceStage = "Q";
         					latestPhase = statCap[1];
         				}else if (racePhases[i].b_StartingGrid==true){//grid	
         					n="0";
         					phaseBtnNo="6";
         					raceStage ="Q";
         					latestPhase = statCap[2];						
         				}else if (racePhases[i].b_Race==true){//race
         					n="1";
         					phaseBtnNo="7";
         					raceStage ="R";
         					latestPhase = statCap[3];						
         				}
         				clearInterval(gpInterval);
         				var lC=0;
         				if (nullSession<1){//if its a real session
         					if(sessLive==1){											
         						if(sessStarted==0&&sessFin==0){//Apr7
         							if(racePhases[i].n_PhaseStatusCode>400&&racePhases[i].n_PhaseStatusCode<30000){
         								lC=3;
         							}else if(racePhases[i].n_PhaseStatusCode>30000){
         								lC=4;
         							}
         							getInfo(phase);
         							getLive(phase);
         						}else	if(sessStarted==1){
         							getInfo(phase);
         							getLive(phase);
         							if(sessFin==1){	
         								sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)"}); 
         								if(racePhases[i].b_Race==true){
                  						showFinished();
                  						sym.getSymbol("raceButtons").$("menuBtn7").on ("click", {menuId:7}, menuBtnClick);
         								}else{
                  						sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
                  					}
         								lC=2;
                  				}else{
                  					sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(85,192,40)"});
                  					sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
                  					lC=1;
                  				}
                  			}else{
                  				sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(179, 196, 200)"});
                  				sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 1px rgb(100,100,100)"});
         							lC=0;
                  			}
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).on('click',showPhase(phase,phaseBtnNo,sessionNo));
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"opacity":1});
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"cursor":"pointer"});
                  			sessLiveOrFin(latestPhase,sessionNo,liveCap[lC]);
                  		}else if(sessFin==1){	
                  			sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)","opacity":1});
                  			sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
                  			if (racePhases[i].b_Race==true){
                  				showFinished();
                  				getInfo(phase);
                  				getLive(phase);
                  			}
         						lC=2;
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).on('click',showPhase(phase,phaseBtnNo,sessionNo));
                   			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"opacity":1});
         						sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"cursor":"pointer"});
                  		}else{
         						lC=0;
         					}         											
         					//sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"cursor":"pointer"});
         				}
                  }//end for
         			phaseNo=phaseBtnNo;
         		}
         	});
         }
         function getInfo(phaseID){//GET individual phase info for laps/live race conditions
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=info&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var latestPhase, laps=0, lapsDriven=0;
         			sym.getSymbol("liveMc").$("lap").empty(); sym.getSymbol("liveMc").$("lap").fadeOut(0);//hide lapCounter
         			var lap="#Stage_liveMc_lap";
         			capsText[6].fadeOut(0);
         			if (data[0].n_WeatherConditionType!=null){
         				sym.getSymbol("circuitMc").$("weatherTxt").show();
         				sym.getSymbol("circuitMc").$("weather").attr('src','images/weather'+ data[0].n_WeatherConditionType +'.png'); // Add weather symbol						
         			}
         			var sessionNo=(data[0].n_SessionNr>0)?data[0].n_SessionNr:"";
         			if (data[0].b_FreePractice==true){
         				pitstoptxt="";
         			}else if(data[0].b_Qualifying==true){
         				pitstoptxt="";	
         			}else if(data[0].b_StartingGrid==true){
         				pitstoptxt="";		
         			}else if(data[0].b_Race==true){//only show laps, etc if race
         				capsText[7].html(caps[11]);//
         				laps = data[0].n_LapsScheduled;
         				lapsDriven = data[0].n_LapsDriven;
         				capsText[6].html(caps[6] +":<br><b>"+ lapsDriven+"/"+laps); //lap text
         				capsText[6].fadeIn(400);//show lapTxt
         				sym.getSymbol("liveMc").$("pitstop").fadeIn(0);
         				sym.getSymbol("liveMc").$("lap").fadeIn(400, function(){ pieChart(lapsDriven,0,laps-lapsDriven,lap); });	
         			}
         			if (data[0].b_Finished==true){
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
         				gpInterval=setInterval(liveGP,300000);
         			}else if (data[0].b_Started==true){
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
         				gpInterval=setInterval(liveGP,45000);
         			}else{
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         				gpInterval=setInterval(liveGP,300000);
         			}
         		}
         	});
         }
         function getLive(phaseID) { //GET LIVE timing data and final result
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			raceData = data;
         			//Ensure all drivers will fit in graph
         			sym.getSymbol("resultMc").$("graph").empty();
         			sym.getSymbol("resultMc").$("loading").fadeOut(0);
         			sym.getSymbol("liveMc").$("graph").empty();					
         			sym.getSymbol("liveMc").$("loading").fadeOut(0);
         			var nDrivers = raceData.length;
         			var barHeightr;
         			var minTime;
         			if (raceData.length>18){
         				barHeightr = Math.round((470/raceData.length)-5);
         			}else{
         				barHeightr = 18;
         			}
         			//calculate relative length of each bar
         			if (raceStage =="R"){
         				minTime = raceData[0].n_TimeRel;
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 0;							
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeRel!=null && raceData[n].n_TimeRel>mxm) {
         						mxm = raceData[n].n_TimeRel;
         					}
         				}
         			}else if (raceData[0].n_TimeAbs!=undefined){//during other phases	
         				minTime = raceData[0].n_TimeAbs; 
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 1;							
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeAbs!=null && raceData[n].n_TimeAbs>mxm) {
         						mxm = raceData[n].n_TimeAbs;									
         					}
         				}
         			}				
         			for (var i = 0; i < raceData.length; i++) {
         				if(i==0){ //show lead drivers
         					var imgDriver1 = raceData[i].n_PersonID;
         					var leadDriver1 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic1").attr("src", "drivers/"+imgDriver1+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt1").html(leadDriver1);
         				}
         				if(i==1){ //show lead drivers
         					var imgDriver2 = raceData[i].n_PersonID;
         					var leadDriver2 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic2").attr("src", "drivers/"+imgDriver2+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt2").html(leadDriver2);
         				}
         				if(i==2){ //show lead drivers
         					var imgDriver3 = raceData[i].n_PersonID;
         					var leadDriver3 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic3").attr("src", "drivers/"+imgDriver3+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt3").html(leadDriver3);
         				}
         				//create timing tables and final results tanle
         				if (i==0){
         					var tableText ="<div class='liverace'>";
         					tableText += "<div id='livedriverdata"+i+"'>";
         					tableText += "<table class='graphtable' style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr height="+barHeightr+">";
         					tableText += "<td id='livernk"+i+"' class='rank' width='18'></td>";
         					tableText += "<td id='driver"+i+"' width='97px'></td>";
         					tableText += "<td id='team"+i+"' style='font-style:italic' width='18px'></td>";
         					tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='15px'></td>";
         					tableText += "<td id='pitCaps"+i+"'></td>";
         					tableText += "<td id='time"+i+"'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div>";
         					tableText += "</div>";
         				}else{
         					var tableText ="<div class='liverace'>";
         					tableText += "<div id='livedriverdata"+i+"'>";
         					tableText += "<table class='graphtable' style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr height="+barHeightr+">";
         					tableText += "<td id='livernk"+i+"' class='rank' width='18'></td>";
         					tableText += "<td class='driver' id='driver"+i+"' width='97px'></td>";
         					tableText += "<td id='team"+i+"' style='font-style:italic' width='18px'></td>";
         					tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='15px'></td>";
         					tableText += "<td id='time"+i+"'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div>";
         					tableText += "</div>";
         				}
         				var resultsText ="<div class='resultrace'>";
         				resultsText +="<div id='resultdata"+i+"'>";
         				resultsText +="<table class='graphtable' style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr height="+barHeightr+">";
         				resultsText +="<td id='resultorder"+i+"' width='12%'></td>";
         				resultsText +="<td class='driver' id='resultdriver"+i+"' width='50%'></td>";
         				resultsText +="<td id='resultteam"+i+"' style='font-style:italic' width='8%'></td>";
         				resultsText +="<td id='points"+i+"'></td>";
         				resultsText +="</tr></table>";
         				resultsText +="</div>";
         				resultsText +="</div>";					
         				sym.getSymbol("liveMc").$("graph").append(tableText);
         				var teamLogo=(mobGraph==1)?'':'<img class="teamsmall" src="images/'+ raceData[i].c_TeamShort +'.png">';
         				if (raceData[i].c_Rank!=null){
         					$('#livernk' + i).text(raceData[i].c_Rank);
         				}else{
         					$('#livernk' + i).text(i+1);
         				}
         				$('#driver' + i).text((raceData[i].c_PersonShort).toUpperCase());
         				$('#team' + i).html(teamLogo);
         				if (raceData[i].n_PitStops){					
         					$('#pitstops' + i).text(raceData[i].n_PitStops);
         					$('#pitstops' + i).css({'font-weight':'bold','text-align':'center','color':'rgb(255,255,255)','background-color':'rgba(0,0,0,0.20)'});
         					if(i==0){
         						$('#pitCaps' + i).text(caps[10]);
         						$('#pitCaps' + i).css({'font-weight':'bold', 'color':'rgba(0,0,0,0.30)'});
         					}
         				}
         				if (timeRel==1){
         					var hrs =(raceData[i].n_TimeAbs>3600000)?Math.floor(raceData[i].n_TimeAbs/3600000)+":":"";
         					var mins=(raceData[i].n_TimeAbs>3600000)?Math.floor((raceData[i].n_TimeAbs%3600000)/60000):Math.floor(raceData[i].n_TimeAbs/60000);
         					if (mins<10){
         						mins="0"+mins+":";
         					}else if(mins<1){
         						mins="00:";
         					}else{
         						mins=mins+":";
         					}
         					var secs=(raceData[i].n_TimeAbs>3600000)?(raceData[i].n_TimeAbs%3600000%60000)/1000:(raceData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					var timing = hrs+mins+secs;
         					$('#time' + i).text(timing);
         					if (minTime==mxm && raceData[i].n_TimeAbs==mxm) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scale=100;
                  		}else if(raceData[i].n_TimeAbs==null){
                  			scale=(mobGraph==1)?65:59;
                  		}else{
                  			scale = 100-((raceData[i].n_TimeAbs-minTime)*(mobGraph==1?30:39)/(mxm-minTime));
                  		}	
                  	}else if (timeRel==0){
                  		if(raceData[i].n_RankSort==1&&raceData[i].n_TimeAbs==null){
                  			scale=100;
                  			$('#time' + i).text();
                  		}else if(raceData[i].n_TimeRel==null){						
                  			scale=(mobGraph==1)?65:59;
                  			if (raceData[i].c_ResultSuffix==null){
                  			}else{
                  				$('#time' + i).text(raceData[i].c_ResultSuffix);
                  			}
                  		}else{
                  			scale = 100-(raceData[i].n_TimeRel*(mobGraph==1?30:39)/mxm);
                  			$('#time' + i).text(raceData[i].c_Result);
                  		}
                  	}
                  	$("#livedriverdata" + i).css({'height':barHeightr+'px','width':scale+'%'});
                  	$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});
                  	sym.getSymbol("liveMc").$("graph").css({'margin-top':'3px'});
                  	if (raceFinished==1){ // final results
                  		sym.getSymbol("resultMc").$("graph").append(resultsText);					
                  		order = raceData[i].n_RankSort;
                  		if (raceData[i].c_ChampionshipPoints!=undefined){
                  			points = raceData[i].c_ChampionshipPoints;
                  		}else{
                  			points="";
                  		}
                  		$('#resultorder' + i).html("<b>"+order+"</b>");
                  		$('#resultdriver' + i).text((raceData[i].c_PersonShort).toUpperCase());
                        //$('#resultteam' + i).text(raceData[i].c_TeamShort);
                        $('#resultteam' + i).html(teamLogo);
                  		if (i==0){
                  			$('#points' + i).html("<b>"+points+caps[12]+"</b>");
                  		}else{
                  			$('#points' + i).html("<b>"+points+"</b>");
                  		}
                  		$("#resultdata"+i).css({'height':barHeightr+'px','width':'60%'});
                  		$("#points" + i).css({'text-align':'right', 'padding-right':'5px'});
                  		sym.getSymbol("resultMc").$("graph").css({'margin-top':'3px'});
                  	}
                  	$(".rank").css({'font-weight':700});
                  	$(".liverace").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%', 'margin-bottom':'5px', 'margin-left':'1%'});
                  	$(".graphtable").css({'background-color':graphcolor,'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
                  	$("img.teamsmall").css({'margin-bottom':'-4px','width':'16px'});
                  	$(".resultrace").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'margin-bottom':'5px', 'margin-left':'1%'});
         			}
         		},
         		error: function(){
         		}		
         	});
         }
         var scalePhase;
         function getPhases(phaseID){//get timing data for completed phases
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var phaseData = data;
         			var barHeight;var minTime;
         			sym.getSymbol("timingMc").$("loading").fadeOut(0);
         			sym.getSymbol("timingMc").$("graph").empty();
         			//Ensure all drivers will fit in graph
         			if (phaseData.length>18){
         				barHeight = Math.round(470/phaseData.length)-5;
         			}else{
         				barHeight = 18;
         			}
         			minTime = phaseData[0].n_TimeAbs;
         			var max = (minTime!=null) ? minTime : 0;
         			for (var n=0; n<phaseData.length; n++) {
         				if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs>max) {
         					max = phaseData[n].n_TimeAbs;									
         				}
         				if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs<minTime) {
         					minTime = phaseData[n].n_TimeAbs;									
         				}
         			}
         			for (var i = 0; i < phaseData.length; i++) {//build timing table
         				var phaseText ="<div class='phaserace'>";
         				phaseText +="<div id='phasedriverdata"+i+"'>";
         				phaseText +="<table class='graphtable' style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				phaseText += "<td id='phasernk"+i+"' class='rank' width='18'></td>";
         				phaseText +="<td id='phasedriver"+i+"'width='97px'></td>";
         				phaseText +="<td id='phaseteam"+i+"' style='font-style:italic' width='40px'></td>";
         				phaseText +="<td id='phasetime"+i+"'></td>";
         				phaseText +="</tr></table>";
         				phaseText +="</div>";
         				phaseText +="</div>";
         				sym.getSymbol("timingMc").$("graph").append(phaseText);
         				$('#phasedriver' + i).text((phaseData[i].c_PersonShort).toUpperCase());
         				var teamLogo='<img class="teamsmall" src="images/'+ phaseData[i].c_TeamShort +'.png">';
         				//$('#phaseteam' + i).text(phaseData[i].c_TeamShort);
         				$('#phaseteam' + i).html(teamLogo);
         				if (phaseData[i].c_Rank!=null){
         					$('#phasernk' + i).text(phaseData[i].c_Rank);
         				}else{
         					$('#phasernk' + i).text(i+1);
         				}
         				var mins=Math.floor(phaseData[i].n_TimeAbs/60000)+":";
         				var secs=(phaseData[i].n_TimeAbs%60000%60000)/1000;
         				if (secs<10){
         					secs="0"+secs;
         				}
         				$('#phasetime' + i).text(mins+secs);
         				if (minTime==max && phaseData[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         					scalePhase=100;
         				}else if(phaseData[i].n_TimeAbs==null){
         					scalePhase=(mobGraph==1)?65:59;
         				}else{
         					scalePhase = 100-((phaseData[i].n_TimeAbs-minTime)*(mobGraph==1?35:41)/(max-minTime));
         				}
         				$("#phasedriverdata" + i).css({'height':barHeight+'px', 'width':'59%'});
         				$("#phasedriverdata" + i).stop().animate({'width':scalePhase+'%'},800,'easeOutQuad');
         				$("#phasetime" + i).css({'text-align':'right', 'padding-right':'5px'});
         			}
         			sym.getSymbol("timingMc").$("graph").css({'margin-top':'3px'});
         			$(".rank").css({'font-weight':700});
         			$(".phaserace").css({'font-size':'12px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'98%', 'margin-bottom':'5px', 'margin-left':'1%'});
         			$(".graphtable").css({'background-color':graphcolor,'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         			$("img.teamsmall").css({'margin-bottom':'-4px','width':'16px'});
         		},
         		error: function(){
         		}
         	});
         }
         // GRID BUTTON
         function getGrid(phaseID){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
                  var gridData = data;
         			sym.getSymbol("timingMc").$("loading").fadeOut(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeIn(500);
         			sym.getSymbol("timingMc").$("graph"). fadeOut(500);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeOut(500);
         				var gridMove, go;
         				for (var i = 0; i < gridData.length; i++) {
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();												
         					var gridText ="<div class='gridlist'><table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'>";
         					gridText += "<tr><td class='gridorder' id='gridorder"+i+"' width='10%'></td>";
         					gridText +="<td class='griddriver' id='griddriver"+i+"' width='62%'></td>";
         					gridText +="<td class='driverShort' id='griddriverS"+i+"' width='62%'></td>";
         					gridText +="<td class='gridlogo' id='gridteam"+i+"' width='28%' font-style:italic'></td>";
         					gridText +="</tr></table></div>";
         					if (i%2==0){
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt0").append(gridText);
         					}else{
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").append(gridText);
         					}
         					var gridCar = '<img src="cars/'+ gridData[i].c_TeamShort +'o.png" width="24px">';
         					var order = gridData[i].n_RankSort;
         					var teamLogo='<img src="images/'+ gridData[i].c_TeamShort +'.png" width="24px">';
         					$('#gridorder' + i).html("<b>"+order+"</b>");
         					$('#griddriver' + i).text(gridData[i].c_Person);
         					$('#griddriverS' + i).text((gridData[i].c_PersonShort).toUpperCase());
         					$('#gridteam' + i).html(teamLogo);
         					$(".gridorder").css({'width':'8%'});
         					$(".griddriver").css({'width':'52%','padding-left':'2%'});
         					$(".gridlogo").css({'width':'10%','font-style':'italic'});
         					$(".gridlist").css({'font-size':'14px', 'font-family':'Helvetica, Arial, sans-serif', 'width':'100%', 'height':'66px','border-bottom':'solid 1px rgb(150,150,150)','padding-top':'5px'});
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).append(gridCar);
         					if (i%2==0){
         					gridMove=5+(i*35);
         					}else{
         					gridMove=-15+(i*35);
         					}
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).delay(i*400).animate({'top':gridMove}, 1000);								
         				}
         				sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").css({'margin-top':'5px'});
         				sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").css({'margin-top':'17px'});
         				sym.getSymbol("timingMc").$("gridSlider").css({'overflow-y':'scroll'});
         				sym.getSymbol("timingMc").$("gridSlider").scrollTop(0);
                  },
                  complete:function(){
         				initSize();
                  }
               });
         }
         function liveGP(){
         	getRace(latestGP);
         }
         setTimeout(function(){ getSeason(); getDriverStandings(); getConsStandings(); setTimeout(liveGP, 500); }, 1500);
         gpInterval=setInterval(liveGP,60000);
         // CIRCUIT BUTTONS & TIMELINE FUNCTIONS
         sym.gearChange = function(gearIn,gearOut,duration) {
         	sym.$({countNum: gearIn}).animate({countNum: gearOut}, {
         		duration: duration,
         		easeOut:'cubic',
         		step: function() {
         		 sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("gear").text(Math.round(this.countNum));//
         		},
         	});
         }
         sym.speedChange = function(speedIn,speedOut,duration) {
         	sym.$({countNum: speedIn}).animate({countNum: speedOut}, {
         	  duration: duration,
         	  easeOut:'cubic',
         	  step: function() {
         		 sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("speed").html(Math.round(this.countNum));
         	  },
         	});
         }
         $(".alertnote").css({'padding':'3px 5px 3px'});
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'RaceBtn'
   (function(symbolName) {   
   
   })("RaceBtn");
   //Edge symbol end:'RaceBtn'

   //=========================================================
   
   //Edge symbol: 'PhaseBtn'
   (function(symbolName) {   
   
   })("PhaseBtn");
   //Edge symbol end:'PhaseBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'TeamButtonStrip'
   (function(symbolName) {   
   
   })("TeamButtonStrip");
   //Edge symbol end:'TeamButtonStrip'

   //=========================================================
   
   //Edge symbol: 'CalendarMc'
   (function(symbolName) {   
   
   })("CalendarMc");
   //Edge symbol end:'CalendarMc'

   //=========================================================
   
   //Edge symbol: 'ResultMc'
   (function(symbolName) {   
   
   })("ResultMc");
   //Edge symbol end:'ResultMc'

   //=========================================================
   
   //Edge symbol: 'TimingMc'
   (function(symbolName) {   
   
   })("TimingMc");
   //Edge symbol end:'TimingMc'

   //=========================================================
   
   //Edge symbol: 'LiveMc'
   (function(symbolName) {   
   
   })("LiveMc");
   //Edge symbol end:'LiveMc'

   //=========================================================
   
   //Edge symbol: 'lapCounter'
   (function(symbolName) {   
   
   })("lapCounter");
   //Edge symbol end:'lapCounter'

   //=========================================================
   
   //Edge symbol: 'DriverChampMc'
   (function(symbolName) {   
   
   })("DriverChampMc");
   //Edge symbol end:'DriverChampMc'

   //=========================================================
   
   //Edge symbol: 'TeamChampMc'
   (function(symbolName) {   
   
   })("TeamChampMc");
   //Edge symbol end:'TeamChampMc'

   //=========================================================
   
   //Edge symbol: 'TeamDriverMc'
   (function(symbolName) {   
   
   })("TeamDriverMc");
   //Edge symbol end:'TeamDriverMc'

   //=========================================================
   
   //Edge symbol: 'DriveCar'
   (function(symbolName) {   
   
   })("DriveCar");
   //Edge symbol end:'DriveCar'

   //=========================================================
   
   //Edge symbol: 'DriversMc'
   (function(symbolName) {   
   
   })("DriversMc");
   //Edge symbol end:'DriversMc'

   //=========================================================

//=========================================================

//=========================================================

//Edge symbol: 'flatmap_two'
(function(symbolName){})("flatmap-two");
   //Edge symbol end:'flatmap-two'

//=========================================================

//Edge symbol: 'Symbol_1'
(function(symbolName){})("continents-animation");
   //Edge symbol end:'continents-animation'

//=========================================================

//Edge symbol: 'globe'
(function(symbolName){})("globe");
   //Edge symbol end:'globe'

   //=========================================================
   
   //Edge symbol: 'GlobeMc'
   (function(symbolName) {   
   
   })("GlobeMc");
   //Edge symbol end:'GlobeMc'

   //=========================================================
   
   //Edge symbol: 'RaceButtons'
   (function(symbolName) {   
   
   })("RaceButtons");
   //Edge symbol end:'RaceButtons'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
   })("CircuitMc");
   //Edge symbol end:'CircuitMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("AUSmini");
   //Edge symbol end:'AUSmini'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,325,1050);
         sym.getComposition().getStage().gearChange(1,8,1050);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,160,200);
         sym.getComposition().getStage().gearChange(8,4,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1350, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,200,500);
         sym.getComposition().getStage().gearChange(4,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1859, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,310,1150);
         sym.getComposition().getStage().gearChange(4,8,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,100,175);
         sym.getComposition().getStage().gearChange(8,3,175);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3424, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,140,325);
         sym.getComposition().getStage().gearChange(3,4,325);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,235,650);
         sym.getComposition().getStage().gearChange(4,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,283,850);
         sym.getComposition().getStage().gearChange(6,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(283,150,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(186,270,450);
         sym.getComposition().getStage().gearChange(4,7,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6450, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,290,800);
         sym.getComposition().getStage().gearChange(7,7,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,120,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,300,1750);
         sym.getComposition().getStage().gearChange(3,8,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(292,226,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(226,235,400);
         sym.getComposition().getStage().gearChange(6,6,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10142, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,290,600);
         sym.getComposition().getStage().gearChange(6,7,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,305,400);
         sym.getComposition().getStage().gearChange(7,8,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,150,200);
         sym.getComposition().getStage().gearChange(8,4,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11938, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,190,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12923, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,90,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,160,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,300,1000);
         sym.getComposition().getStage().gearChange(4,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,186,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,190,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

   })("AUSMc");
   //Edge symbol end:'AUSMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'gearsMc'
   (function(symbolName) {   
   
   })("gearsMc");
   //Edge symbol end:'gearsMc'

   //=========================================================
   
   //Edge symbol: 'playPause'
   (function(symbolName) {   
   
   })("playPause");
   //Edge symbol end:'playPause'

   //=========================================================
   
   //Edge symbol: 'CircuitOverlay'
   (function(symbolName) {   
   
   })("CircuitOverlay");
   //Edge symbol end:'CircuitOverlay'

   //=========================================================
   
   //Edge symbol: 'speedGearsMc'
   (function(symbolName) {   
   
   })("speedGearsMc");
   //Edge symbol end:'speedGearsMc'

   //=========================================================
   
   //Edge symbol: 'status'
   (function(symbolName) {   
   
   })("Status");
   //Edge symbol end:'Status'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,330,1250);
         sym.getComposition().getStage().gearChange(2,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,90,400);
         sym.getComposition().getStage().gearChange(8,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,160,450);
         sym.getComposition().getStage().gearChange(2,4,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2600, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,240,300);
         sym.getComposition().getStage().gearChange(4,5,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,280,500);
         sym.getComposition().getStage().gearChange(5,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,120,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,245,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,250,750);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,79,250);
         sym.getComposition().getStage().gearChange(6,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(79,260,750);
         sym.getComposition().getStage().gearChange(1,6,750);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,320,1250);
         sym.getComposition().getStage().gearChange(2,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,160,500);
         sym.getComposition().getStage().gearChange(8,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,257,500);
         sym.getComposition().getStage().gearChange(7,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11650, function(sym, e) {
         sym.getComposition().getStage().speedChange(154,180,300);
         sym.getComposition().getStage().gearChange(4,4,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,135,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,190,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("310");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,305,500);
         sym.getComposition().getStage().gearChange(7,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,180,500);
         sym.getComposition().getStage().gearChange(6,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,85,500);
         sym.getComposition().getStage().gearChange(6,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,260,750);
         sym.getComposition().getStage().gearChange(4,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(257,154,300);
         sym.getComposition().getStage().gearChange(7,4,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,310,1250);
         sym.getComposition().getStage().gearChange(4,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,290,500);
         sym.getComposition().getStage().gearChange(4,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,310,250);
         sym.getComposition().getStage().gearChange(7,8,250);

      });
      //Edge binding end

   })("BRNMc");
   //Edge symbol end:'BRNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BRNmini");
   //Edge symbol end:'BRNmini'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,325,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,205,400);
         sym.getComposition().getStage().gearChange(8,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1400, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,130,350);
         sym.getComposition().getStage().gearChange(5,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,215,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,90,750);
         sym.getComposition().getStage().gearChange(7,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,260,500);
         sym.getComposition().getStage().gearChange(2,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5163, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,225,550);
         sym.getComposition().getStage().gearChange(6,5,550);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,185,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(261,100,500);
         sym.getComposition().getStage().gearChange(6,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,170,750);
         sym.getComposition().getStage().gearChange(2,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,225,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,65,250);
         sym.getComposition().getStage().gearChange(2,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,260,750);
         sym.getComposition().getStage().gearChange(1,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,160,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,290,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,265,600);
         sym.getComposition().getStage().gearChange(6,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,115,1000);
         sym.getComposition().getStage().gearChange(5,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,261,1000);
         sym.getComposition().getStage().gearChange(4,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,260,250);
         sym.getComposition().getStage().gearChange(5,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,310,1250);
         sym.getComposition().getStage().gearChange(6,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,335,1250);
         sym.getComposition().getStage().gearChange(8,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,80,500);
         sym.getComposition().getStage().gearChange(8,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14307, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,305,500);
         sym.getComposition().getStage().gearChange(4,7,500);

      });
      //Edge binding end

   })("CHNMc");
   //Edge symbol end:'CHNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("CHNmini");
   //Edge symbol end:'CHNmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,270,750);
         sym.getComposition().getStage().gearChange(1,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,330,600);
         sym.getComposition().getStage().gearChange(8,8,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,135,250);
         sym.getComposition().getStage().gearChange(8,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,160,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,290,750);
         sym.getComposition().getStage().gearChange(4,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,165,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,135,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,270,750);
         sym.getComposition().getStage().gearChange(3,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,170,750);
         sym.getComposition().getStage().gearChange(7,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,240,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,140,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,110,200);
         sym.getComposition().getStage().gearChange(8,3,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,265,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,115,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14750, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,250,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("200");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,305,250);
         sym.getComposition().getStage().gearChange(7,8,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,275,750);
         sym.getComposition().getStage().gearChange(4,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,220,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,285,250);
         sym.getComposition().getStage().gearChange(5,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,335,750);
         sym.getComposition().getStage().gearChange(7,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,120,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

   })("RUSMc");
   //Edge symbol end:'RUSMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("RUSmini");
   //Edge symbol end:'RUSmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,330,1750);
         sym.getComposition().getStage().gearChange(1,8,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,140,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,165,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,210,600);
         sym.getComposition().getStage().gearChange(4,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,225,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,295,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,150,500);
         sym.getComposition().getStage().gearChange(7,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,230,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,110,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,265,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,185,500);
         sym.getComposition().getStage().gearChange(6,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,200,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,280,250);
         sym.getComposition().getStage().gearChange(5,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,305,1250);
         sym.getComposition().getStage().gearChange(7,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,100,500);
         sym.getComposition().getStage().gearChange(8,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,110,800);
         sym.getComposition().getStage().gearChange(2,3,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11600, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,135,800);
         sym.getComposition().getStage().gearChange(3,3,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,95,500);
         sym.getComposition().getStage().gearChange(3,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,130,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,250,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,305,750);
         sym.getComposition().getStage().gearChange(6,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("305");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ESPMc");
   //Edge symbol end:'ESPMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ESPmini");
   //Edge symbol end:'ESPmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,210,500);
         sym.getComposition().getStage().gearChange(1,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,105,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,180,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,275,1000);
         sym.getComposition().getStage().gearChange(4,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,150,1000);
         sym.getComposition().getStage().gearChange(7,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,130,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,220,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,85,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,45,500);
         sym.getComposition().getStage().gearChange(2,1,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(45,125,500);
         sym.getComposition().getStage().gearChange(1,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,85,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,255,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,295,1000);
         sym.getComposition().getStage().gearChange(6,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,95,350);
         sym.getComposition().getStage().gearChange(7,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9100, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,70,400);
         sym.getComposition().getStage().gearChange(2,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,230,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,236,1000);
         sym.getComposition().getStage().gearChange(5,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(236,105,750);
         sym.getComposition().getStage().gearChange(6,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,190,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,58,500);
         sym.getComposition().getStage().gearChange(4,1,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(58,97,250);
         sym.getComposition().getStage().gearChange(1,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(97,80,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,290,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

   })("MONMc");
   //Edge symbol end:'MONMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MONmini");
   //Edge symbol end:'MONmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,330,1450);
         sym.getComposition().getStage().gearChange(1,8,1450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,90,300);
         sym.getComposition().getStage().gearChange(8,2,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1800, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,65,350);
         sym.getComposition().getStage().gearChange(2,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,245,850);
         sym.getComposition().getStage().gearChange(2,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,310,1000);
         sym.getComposition().getStage().gearChange(6,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,100,400);
         sym.getComposition().getStage().gearChange(8,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,205,350);
         sym.getComposition().getStage().gearChange(3,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,210,1250);
         sym.getComposition().getStage().gearChange(5,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,265,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,160,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,170,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,280,1000);
         sym.getComposition().getStage().gearChange(4,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,215,1000);
         sym.getComposition().getStage().gearChange(7,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,140,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,260,750);
         sym.getComposition().getStage().gearChange(4,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,265,350);
         sym.getComposition().getStage().gearChange(6,7,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,218,400);
         sym.getComposition().getStage().gearChange(7,6,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         sym.getComposition().getStage().speedChange(218,98,450);
         sym.getComposition().getStage().gearChange(6,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11450, function(sym, e) {
         sym.getComposition().getStage().speedChange(98,205,250);
         sym.getComposition().getStage().gearChange(2,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,320,1250);
         sym.getComposition().getStage().gearChange(5,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,210,1000);
         sym.getComposition().getStage().gearChange(8,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,300,750);
         sym.getComposition().getStage().gearChange(5,8,750);

      });
      //Edge binding end

   })("MASMc");
   //Edge symbol end:'MASMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MASmini");
   //Edge symbol end:'MASmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,338,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(338,270,650);
         sym.getComposition().getStage().gearChange(8,7,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,155,600);
         sym.getComposition().getStage().gearChange(7,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,240,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,200,600);
         sym.getComposition().getStage().gearChange(5,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,170,450);
         sym.getComposition().getStage().gearChange(5,4,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4050, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,300,1200);
         sym.getComposition().getStage().gearChange(4,8,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,240,250);
         sym.getComposition().getStage().gearChange(8,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,250,250);
         sym.getComposition().getStage().gearChange(6,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,95,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,250,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,313,750);
         sym.getComposition().getStage().gearChange(6,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(313,220,500);
         sym.getComposition().getStage().gearChange(8,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,160,500);
         sym.getComposition().getStage().gearChange(5,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,210,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,325,1250);
         sym.getComposition().getStage().gearChange(5,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,318,1250);
         sym.getComposition().getStage().gearChange(8,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(318,95,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,140,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,210,250);
         sym.getComposition().getStage().gearChange(3,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,300,500);
         sym.getComposition().getStage().gearChange(5,8,500);

      });
      //Edge binding end

   })("JPNMc");
   //Edge symbol end:'JPNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("JPNmini");
   //Edge symbol end:'JPNmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,700);
         sym.getComposition().getStage().gearChange(1,7,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,290,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,120,650);
         sym.getComposition().getStage().gearChange(7,3,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,90,450);
         sym.getComposition().getStage().gearChange(3,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2600, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,270,750);
         sym.getComposition().getStage().gearChange(2,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3350, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,330,1150);
         sym.getComposition().getStage().gearChange(7,8,1150);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,180,400);
         sym.getComposition().getStage().gearChange(8,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4900, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,120,600);
         sym.getComposition().getStage().gearChange(4,3,600);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,200,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,280,500);
         sym.getComposition().getStage().gearChange(5,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,320,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,265,350);
         sym.getComposition().getStage().gearChange(8,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7850, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,310,900);
         sym.getComposition().getStage().gearChange(6,8,900);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,295,500);
         sym.getComposition().getStage().gearChange(8,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,185,950);
         sym.getComposition().getStage().gearChange(8,5,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10200, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,280,600);
         sym.getComposition().getStage().gearChange(5,7,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10850, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,330,1300);
         sym.getComposition().getStage().gearChange(7,8,1300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,210,500);
         sym.getComposition().getStage().gearChange(8,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,235,250);
         sym.getComposition().getStage().gearChange(5,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,280,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,110,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13900, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,114,350);
         sym.getComposition().getStage().gearChange(3,3,350);
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(114,220,250);
         sym.getComposition().getStage().gearChange(3,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,300,500);
         sym.getComposition().getStage().gearChange(5,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ENGMc");
   //Edge symbol end:'ENGMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ENGmini");
   //Edge symbol end:'ENGmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,330,1200);
         sym.getComposition().getStage().gearChange(1,8,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,105,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,250,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,280,1000);
         sym.getComposition().getStage().gearChange(6,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,140,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,220,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,300,1200);
         sym.getComposition().getStage().gearChange(5,8,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,205,350);
         sym.getComposition().getStage().gearChange(8,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6100, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,165,500);
         sym.getComposition().getStage().gearChange(5,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,150,400);
         sym.getComposition().getStage().gearChange(4,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,240,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,115,350);
         sym.getComposition().getStage().gearChange(6,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7850, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,125,150);
         sym.getComposition().getStage().gearChange(3,3,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,165,600);
         sym.getComposition().getStage().gearChange(4,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,140,400);
         sym.getComposition().getStage().gearChange(4,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,250,900);
         sym.getComposition().getStage().gearChange(4,6,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9900, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,210,600);
         sym.getComposition().getStage().gearChange(6,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,280,900);
         sym.getComposition().getStage().gearChange(5,7,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11400, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,120,450);
         sym.getComposition().getStage().gearChange(7,3,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11850, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,95,900);
         sym.getComposition().getStage().gearChange(3,3,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,125,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,205,250);
         sym.getComposition().getStage().gearChange(3,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,300,1000);
         sym.getComposition().getStage().gearChange(5,8,1000);

      });
      //Edge binding end

   })("HUNMc");
   //Edge symbol end:'HUNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("HUNmini");
   //Edge symbol end:'HUNmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,90,450);
         sym.getComposition().getStage().gearChange(1,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,200,500);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,285,250);
         sym.getComposition().getStage().gearChange(5,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,317,750);
         sym.getComposition().getStage().gearChange(7,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(317,310,500);
         sym.getComposition().getStage().gearChange(8,8,500);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,325,500);
         sym.getComposition().getStage().gearChange(8,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,335,1250);
         sym.getComposition().getStage().gearChange(8,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,160,400);
         sym.getComposition().getStage().gearChange(8,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4900, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,190,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5400, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,275,600);
         sym.getComposition().getStage().gearChange(5,7,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,135,400);
         sym.getComposition().getStage().gearChange(7,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,305,1300);
         sym.getComposition().getStage().gearChange(4,8,1300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,265,500);
         sym.getComposition().getStage().gearChange(8,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,305,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,185,250);
         sym.getComposition().getStage().gearChange(8,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,245,750);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,270,1000);
         sym.getComposition().getStage().gearChange(6,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,325,1100);
         sym.getComposition().getStage().gearChange(7,8,1100);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,320,500);
         sym.getComposition().getStage().gearChange(8,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,330,1000);
         sym.getComposition().getStage().gearChange(8,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,100,250);
         sym.getComposition().getStage().gearChange(8,2,250);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,300,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

   })("BELMc");
   //Edge symbol end:'BELMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BELmini");
   //Edge symbol end:'BELmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,350,1950);
         sym.getComposition().getStage().gearChange(1,8,1950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,90,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,220,500);
         sym.getComposition().getStage().gearChange(2,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,295,750);
         sym.getComposition().getStage().gearChange(6,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,335,1250);
         sym.getComposition().getStage().gearChange(8,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,120,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,125,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,260,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,185,400);
         sym.getComposition().getStage().gearChange(6,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6650, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,260,600);
         sym.getComposition().getStage().gearChange(5,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,175,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,225,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,342,1250);
         sym.getComposition().getStage().gearChange(6,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(342,180,250);
         sym.getComposition().getStage().gearChange(8,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,200,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,300,750);
         sym.getComposition().getStage().gearChange(5,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,340,1250);
         sym.getComposition().getStage().gearChange(8,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(340,200,750);
         sym.getComposition().getStage().gearChange(8,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,290,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,325,750);
         sym.getComposition().getStage().gearChange(7,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("325");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ITAMc");
   //Edge symbol end:'ITAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ITAmini");
   //Edge symbol end:'ITAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,315,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,155,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,80,400);
         sym.getComposition().getStage().gearChange(3,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,205,600);
         sym.getComposition().getStage().gearChange(2,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,265,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,185,250);
         sym.getComposition().getStage().gearChange(7,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,330,1250);
         sym.getComposition().getStage().gearChange(5,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,130,400);
         sym.getComposition().getStage().gearChange(8,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5350, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,205,400);
         sym.getComposition().getStage().gearChange(3,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,140,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,278,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(278,140,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,115,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,210,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,80,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,285,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,95,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,250,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,125,500);
         sym.getComposition().getStage().gearChange(5,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,210,350);
         sym.getComposition().getStage().gearChange(3,4,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12350, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,95,250);
         sym.getComposition().getStage().gearChange(4,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,145,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,250,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,190,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,230,250);
         sym.getComposition().getStage().gearChange(4,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,300,500);
         sym.getComposition().getStage().gearChange(5,8,500);

      });
      //Edge binding end

   })("SINMc");
   //Edge symbol end:'SINMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("SINmini");
   //Edge symbol end:'SINmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,330,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,135,400);
         sym.getComposition().getStage().gearChange(8,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1382, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,225,600);
         sym.getComposition().getStage().gearChange(4,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,320,2000);
         sym.getComposition().getStage().gearChange(6,8,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,85,600);
         sym.getComposition().getStage().gearChange(8,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,260,400);
         sym.getComposition().getStage().gearChange(2,6,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,330,2000);
         sym.getComposition().getStage().gearChange(6,8,2000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,115,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,170,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,270,750);
         sym.getComposition().getStage().gearChange(4,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,175,750);
         sym.getComposition().getStage().gearChange(7,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,185,1000);
         sym.getComposition().getStage().gearChange(5,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,245,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,290,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,315,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,200,650);
         sym.getComposition().getStage().gearChange(8,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,235,450);
         sym.getComposition().getStage().gearChange(6,6,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13350, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,160,400);
         sym.getComposition().getStage().gearChange(6,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,265,450);
         sym.getComposition().getStage().gearChange(4,7,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14150, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,300,850);
         sym.getComposition().getStage().gearChange(7,8,850);

      });
      //Edge binding end

   })("AUTMc");
   //Edge symbol end:'AUTMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("AUTmini");
   //Edge symbol end:'AUTmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,129,350);
         sym.getComposition().getStage().gearChange(1,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(91,330,750);
         sym.getComposition().getStage().gearChange(3,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(91,330,2000);
         sym.getComposition().getStage().gearChange(3,8,2000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,100,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,88,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(88,246,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(246,100,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,130,500);
         sym.getComposition().getStage().gearChange(3,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,100,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,93,400);
         sym.getComposition().getStage().gearChange(3,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6650, function(sym, e) {
         sym.getComposition().getStage().speedChange(93,115,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6900, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,288,850);
         sym.getComposition().getStage().gearChange(3,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(288,315,500);
         sym.getComposition().getStage().gearChange(7,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,105,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8900, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,206,600);
         sym.getComposition().getStage().gearChange(3,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(206,115,350);
         sym.getComposition().getStage().gearChange(5,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9850, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,255,250);
         sym.getComposition().getStage().gearChange(3,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10350, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,300,550);
         sym.getComposition().getStage().gearChange(6,8,550);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10900, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,307,450);
         sym.getComposition().getStage().gearChange(8,8,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11400, function(sym, e) {
         sym.getComposition().getStage().speedChange(307,340,1750);
         sym.getComposition().getStage().gearChange(8,8,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("340");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("EURMc");
   //Edge symbol end:'EURMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("EURmini");
   //Edge symbol end:'EURmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,155,500);
         sym.getComposition().getStage().gearChange(1,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,85,750);
         sym.getComposition().getStage().gearChange(4,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(855,260,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,130,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,160,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,265,750);
         sym.getComposition().getStage().gearChange(4,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,115,750);
         sym.getComposition().getStage().gearChange(7,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,170,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,307,1500);
         sym.getComposition().getStage().gearChange(4,8,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(307,125,500);
         sym.getComposition().getStage().gearChange(8,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,210,250);
         sym.getComposition().getStage().gearChange(4,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,290,500);
         sym.getComposition().getStage().gearChange(5,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,300,750);
         sym.getComposition().getStage().gearChange(7,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,80,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,250,1750);
         sym.getComposition().getStage().gearChange(3,6,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,339,1750);
         sym.getComposition().getStage().gearChange(6,8,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("318");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(339,145,500);
         sym.getComposition().getStage().gearChange(8,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,318,1500);
         sym.getComposition().getStage().gearChange(4,8,1500);

      });
      //Edge binding end

   })("CANMc");
   //Edge symbol end:'CANMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("CANmini");
   //Edge symbol end:'CANmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,310,1000);
         sym.getComposition().getStage().gearChange(1,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1050, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,110,450);
         sym.getComposition().getStage().gearChange(8,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,90,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,230,500);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,285,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,240,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,190,1000);
         sym.getComposition().getStage().gearChange(6,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,165,750);
         sym.getComposition().getStage().gearChange(4,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,260,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,290,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,90,250);
         sym.getComposition().getStage().gearChange(7,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,280,1250);
         sym.getComposition().getStage().gearChange(2,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,335,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,105,500);
         sym.getComposition().getStage().gearChange(8,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,80,1250);
         sym.getComposition().getStage().gearChange(2,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,250,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,285,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,195,400);
         sym.getComposition().getStage().gearChange(7,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13650, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,260,400);
         sym.getComposition().getStage().gearChange(4,6,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14100, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,105,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14350, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,145,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14600, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,290,500);
         sym.getComposition().getStage().gearChange(3,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("USAMc");
   //Edge symbol end:'USAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("USAmini");
   //Edge symbol end:'USAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("295");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(357,115,750);
         sym.getComposition().getStage().gearChange(8,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,357,3200);
         sym.getComposition().getStage().gearChange(1,8,3200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,105,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,98,350);
         sym.getComposition().getStage().gearChange(8,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7100, function(sym, e) {
         sym.getComposition().getStage().speedChange(98,70,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7850, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,255,650);
         sym.getComposition().getStage().gearChange(2,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,158,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.getComposition().getStage().speedChange(158,200,350);
         sym.getComposition().getStage().gearChange(4,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,155,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,200,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(312,125,350);
         sym.getComposition().getStage().gearChange(8,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,185,400);
         sym.getComposition().getStage().gearChange(3,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(75,105,250);
         sym.getComposition().getStage().gearChange(1,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,75,250);
         sym.getComposition().getStage().gearChange(4,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,175,650);
         sym.getComposition().getStage().gearChange(2,4,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,110,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,240,250);
         sym.getComposition().getStage().gearChange(3,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,320,1250);
         sym.getComposition().getStage().gearChange(6,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7350, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,80,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9350, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,210,400);
         sym.getComposition().getStage().gearChange(5,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,230,250);
         sym.getComposition().getStage().gearChange(5,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,312,1500);
         sym.getComposition().getStage().gearChange(5,8,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14154, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,230,350);
         sym.getComposition().getStage().gearChange(4,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,295,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

   })("MEXMc");
   //Edge symbol end:'MEXMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MEXmini");
   //Edge symbol end:'MEXmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,348,750);
         sym.getComposition().getStage().gearChange(1,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(348,130,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,216,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,265,250);
         sym.getComposition().getStage().gearChange(5,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,290,500);
         sym.getComposition().getStage().gearChange(7,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,335,1250);
         sym.getComposition().getStage().gearChange(7,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,155,250);
         sym.getComposition().getStage().gearChange(8,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,200,250);
         sym.getComposition().getStage().gearChange(4,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,250,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,300,1000);
         sym.getComposition().getStage().gearChange(6,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,238,250);
         sym.getComposition().getStage().gearChange(8,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(238,200,500);
         sym.getComposition().getStage().gearChange(6,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,225,250);
         sym.getComposition().getStage().gearChange(5,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,110,1000);
         sym.getComposition().getStage().gearChange(6,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,90,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,210,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(210,270,500);
         sym.getComposition().getStage().gearChange(5,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,125,350);
         sym.getComposition().getStage().gearChange(7,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("348");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11100, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,218,650);
         sym.getComposition().getStage().gearChange(3,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(218,270,250);
         sym.getComposition().getStage().gearChange(5,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,290,500);
         sym.getComposition().getStage().gearChange(7,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,315,1000);
         sym.getComposition().getStage().gearChange(8,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,340,1500);
         sym.getComposition().getStage().gearChange(8,8,1500);

      });
      //Edge binding end

   })("BRAMc");
   //Edge symbol end:'BRAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BRAmini");
   //Edge symbol end:'BRAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,298,700);
         sym.getComposition().getStage().gearChange(1,8,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(298,115,400);
         sym.getComposition().getStage().gearChange(8,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1150, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,255,600);
         sym.getComposition().getStage().gearChange(3,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,275,650);
         sym.getComposition().getStage().gearChange(6,7,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2400, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,300,850);
         sym.getComposition().getStage().gearChange(7,8,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,95,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,290,750);
         sym.getComposition().getStage().gearChange(1,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,335,800);
         sym.getComposition().getStage().gearChange(8,8,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,81,500);
         sym.getComposition().getStage().gearChange(8,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(81,98,350);
         sym.getComposition().getStage().gearChange(2,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7850, function(sym, e) {
         sym.getComposition().getStage().speedChange(98,275,650);
         sym.getComposition().getStage().gearChange(3,7,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(328,90,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,115,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,120,350);
         sym.getComposition().getStage().gearChange(3,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11100, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,275,1100);
         sym.getComposition().getStage().gearChange(3,7,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,115,1000);
         sym.getComposition().getStage().gearChange(7,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,250,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("250");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,65,500);
         sym.getComposition().getStage().gearChange(3,1,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,328,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,180,500);
         sym.getComposition().getStage().gearChange(6,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14600, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,250,400);
         sym.getComposition().getStage().gearChange(4,6,400);

      });
      //Edge binding end

   })("UAEMc");
   //Edge symbol end:'UAEMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("UAEmini");
   //Edge symbol end:'UAEmini'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'GridSlider'
   (function(symbolName) {   
   
   })("GridSlider");
   //Edge symbol end:'GridSlider'

   //=========================================================
   
   //Edge symbol: 'Grid'
   (function(symbolName) {   
   
   })("Grid");
   //Edge symbol end:'Grid'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'Screen0'
   (function(symbolName) {   
   
   })("Countdown");
   //Edge symbol end:'Countdown'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34870");