/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white", "padding":"5px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var scrollPath = sym.getSymbol('scrollMc').getSymbol('scrollableMc');
         	var scrollStopped = false;
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {'font-size':'14px', 'line-height':'15px', "border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"0px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = scrollPath.getSymbol('pMc0').$("txt0").css({"pointer-events":"none"});
         	txt[1] = scrollPath.getSymbol('pMc2').$("txt1").css({"pointer-events":"none"});
         	txt[2] = scrollPath.getSymbol('pMc5').$("txt2").css({"pointer-events":"none"});
         	txt[3] = scrollPath.getSymbol('pMc0').$("txt3").css({"pointer-events":"none"});
         	txt[4] = scrollPath.getSymbol('pMc3').$("txt4").css({"pointer-events":"none"});
         	txt[5] = scrollPath.getSymbol('pMc4').$("txt5").css({"pointer-events":"none"});
         	txt[6] = scrollPath.getSymbol('pMc0').$("txt6").css({"pointer-events":"none"});
         	txt[7] = scrollPath.getSymbol('pMc1').$("txt7").css({"pointer-events":"none"});
         	txt[8] = scrollPath.getSymbol('pMc2').$("txt8").css({"pointer-events":"none"});
         	txt[9] = scrollPath.getSymbol('pMc0').$("txt9").css({"pointer-events":"none"});
         	txt[10] = scrollPath.getSymbol('pMc1').$("txt10").css({"pointer-events":"none"});
         	txt[11] = scrollPath.getSymbol('pMc1').$("txt11").css({"pointer-events":"none"});
         	txt[12] = scrollPath.getSymbol('pMc6').$("txt12").css({"pointer-events":"none"});
         	var txtArr=[];
         	var venueDateM=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34837.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<13; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			scrollPath.getSymbol('pMc6').$("txt12").css(whiteTxtBox);
         			scrollPath.getSymbol('pMc6').$("txt12").css({"top":314 - scrollPath.getSymbol('pMc6').$("txt12").height()+"px"});
         
         			for (var t=0;t<8; t++){	//get details for each team
         			$(xml).find("venue"+t).each(function(){
         				var $event=$(this);
         				var venuedatem=$event.find("dateM").text();
         				venueDateM.push(venuedatem);
         				});
         			}
         			var tableTxt="<table id='venueTable'>";
         			for (var i=0;i<8;i++){
         				tableTxt+="<tr id='venue"+i+"' class='venue'>";
         				tableTxt+="<td id='datem"+i+"' class='venueDateM'>"+venueDateM[i]+"</td>";
         				tableTxt+="</tr>";
         			}
         			sym.$('table').append(tableTxt);
         			$("#venueTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px", 'line-height':'15px','border-collapse':'collapse', 'width':'100%'});
         			$("#venueTable tr:odd"). css({"background-color":"rgba(100,100,100,0.11)", 'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         			$("#venueTable tr:even").css({'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         			$(".venueDateM").css({'width':'100%','padding':'10px', "vertical-align":"top", 'font-weight':'regular', "background-color":"rgba(100,100,100,0.1)"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         scrollPath.$("pMc6").stop().animate({opacity:0}, 0);
         
         //********************************************************************************************************
         // VISIBLE CHECK
         //********************************************************************************************************
         $.fn.isVisible = function() {
             var rect = this[0].getBoundingClientRect();
             return (
                 (rect.height > 0 || rect.width > 0) && rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth)
             );
         };
         
         function doCheck() {
             for (var h=0; h<6; h++){
         
         		if (scrollPath.$("pLeft"+h).isVisible() && scrollPath.$("pRight"+h).isVisible()) {
         			scrollPath.$("pMc"+h).stop().animate({opacity:1}, 200);
         
         			if (scrollPath.$("pLeft0").isVisible()){
         				scrollPath.$("pMc0").stop().animate({opacity:0}, 0);
         				scrollPath.getSymbol("roofMc").$("roofShad").stop().animate({opacity:1}, 500);
         				scrollPath.$("roofMc").stop().animate({top:41}, 500, 'easeOutCubic', function(){ 
         					scrollPath.$("pMc0").stop().animate({opacity:1}, 200);
         				});
         			}else{
         				scrollPath.$("roofMc").stop().animate({top:233}, 200, 'easeOutCubic');
         				scrollPath.getSymbol("roofMc").$("roofShad").stop().animate({opacity:0}, 500);
         			}
         			if (scrollPath.$("pRight6").isVisible()){
         				scrollPath.$("pMc6").stop().animate({opacity:1}, 500);
         			}else{
         				scrollPath.$("pMc6").stop().animate({opacity:0}, 200);
         			}
         
         		} else {
         			scrollPath.$("pMc"+h).stop().animate({opacity:0}, 50);
         		}
         
         	}
         }
         
         var TO = false;
         var scroll_static = true;
         
         sym.$("scrollMc").scroll(function(){
         	doCheck();
         	if( scroll_static ){
         		scroll_static = false;
         	}
         
         	if (TO !== false){ clearTimeout(TO); }           
         	TO = setTimeout(myfunction, 100); 
         });
         
         function myfunction(){
         	scroll_static = true;	
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("toggleBtn").css({'left':stageWidth-40+'px'});
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		sym.$("table").css({'width':stageWidth+'px'});
         	}else{
         		sym.$("table").css({'width':'320px'});
         	}
         	setStyle();
         	closeSource();
         	doCheck();
         	closeToggle();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // TOGGLE BUTTON
         //********************************************************************************************************
         var tableVis = false;
         sym.$("toggleBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (tableVis==false){
         		sym.$("table").stop().animate ({left:stageWidth-sym.$("table").width()}, 200, 'easeOutCubic');
         		sym.getSymbol("toggleBtn").$("arrowHead").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		tableVis = true;
         	}else{
         		closeToggle();
         	}
         });
         function closeToggle(){
         	sym.$("table").stop().animate ({left:stageWidth+10}, 200);
         	sym.getSymbol("toggleBtn").$("arrowHead").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	tableVis = false;
         }
         
         //********************************************************************************************************
         // CHECK RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL==true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		scrollPath.getSymbol('pMc6').$("txt12").css({"text-align":"right"});
         		sym.getSymbol("toggleBtn").$("bg").css({'left':'-40px'});
         		sym.$("toggleBtn").css({"left":"0px"});
         		$(".venueDateM").css({'text-align':'right'});
         	}
         }
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'roofMc'
   (function(symbolName) {   
   
   })("roofMc");
   //Edge symbol end:'roofMc'

   //=========================================================
   
   //Edge symbol: 'pointer1'
   (function(symbolName) {   
   
   })("pointer1");
   //Edge symbol end:'pointer1'

   //=========================================================
   
   //Edge symbol: 'pointer2'
   (function(symbolName) {   
   
   })("pointer2");
   //Edge symbol end:'pointer2'

   //=========================================================
   
   //Edge symbol: 'pMc0'
   (function(symbolName) {   
   
   })("pMc0");
   //Edge symbol end:'pMc0'

   //=========================================================
   
   //Edge symbol: 'pMc1'
   (function(symbolName) {   
   
   })("pMc1");
   //Edge symbol end:'pMc1'

   //=========================================================
   
   //Edge symbol: 'pMc2'
   (function(symbolName) {   
   
   })("pMc2");
   //Edge symbol end:'pMc2'

   //=========================================================
   
   //Edge symbol: 'pMc3'
   (function(symbolName) {   
   
   })("pMc3");
   //Edge symbol end:'pMc3'

   //=========================================================
   
   //Edge symbol: 'pMc4'
   (function(symbolName) {   
   
   })("pMc4");
   //Edge symbol end:'pMc4'

   //=========================================================
   
   //Edge symbol: 'pMc5'
   (function(symbolName) {   
   
   })("pMc5");
   //Edge symbol end:'pMc5'

   //=========================================================
   
   //Edge symbol: 'pMc6'
   (function(symbolName) {   
   
   })("pMc6");
   //Edge symbol end:'pMc6'

   //=========================================================
   
   //Edge symbol: 'arrowHead'
   (function(symbolName) {   
   
   })("arrowHead");
   //Edge symbol end:'arrowHead'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34837");