/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white", "padding":"5px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var redTxtBox = {"border-radius":"5px", "color":"white", "background-color":"#da0000", "height":"auto", "padding":"6px"};
         
         	var blueTxtBox = {"border-radius":"5px", "color":"white", "background-color":"#0071bb", "height":"auto", "padding":"6px"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<14; i++){
         		txt[i] = sym.getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	for (var i=15; i<22; i++){
         		txt[i] = sym.getSymbol("wallMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         	var venueDateM=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34834.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<22; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			sym.getSymbol("mapMc").$("txt0").css({'font-size':"18px"});
         			sym.getSymbol("mapMc").$("txt9").css({'font-size':"18px"});
         			sym.getSymbol("mapMc").$("txt14").css({'font-size':"16px"});
         			sym.getSymbol("wallMc").$("txt15").css({'font-size':"16px", 'line-height':"18px"});
         			sym.getSymbol("mapMc").$("txt12").css(redTxtBox);
         			sym.getSymbol("mapMc").$("txt13").css(blueTxtBox);
         			sym.getSymbol("mapMc").$("txt10").css({'line-height':"20px"});
         
         //NEW TABLE
         for (var t=0;t<4; t++){	//get details for each team
         	$(xml).find("venue"+t).each(function(){
         		var $event=$(this);
         		var venuedatem=$event.find("dateM").text();
         		venueDateM.push(venuedatem);
         		});
         	}
         	var tableTxt="<table id='venueTable'>";
         	for (var i=0;i<4;i++){
         		tableTxt+="<tr id='venue"+i+"' class='venue'>";
         		tableTxt+="<td id='datem"+i+"' class='venueDateM'>"+venueDateM[i]+"</td>";
         		tableTxt+="</tr>";
         	}
         	sym.$('table').append(tableTxt);
         	$("#venueTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px", 'line-height':'15px','border-collapse':'collapse', 'width':'100%'});
         	$("#venueTable tr:odd"). css({'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         	$("#venueTable tr:even").css({'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         	$(".venueDateM").css({'width':'100%','padding':'5.2px', "vertical-align":"top", 'font-weight':'bold', "background-color":"rgba(100,100,100,0.1)"});
         	},
            complete:function(){
         		initSize();
         		sym.$('wallMc').fadeOut(0);
         		sym.$('mapBg').fadeOut(0);
            }
         	}); // END XML
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var pos = sym.getSymbol("wallMc").getPosition();
         	if (pos > 31800) {
         		sym.$('wallMc').fadeOut(500);
         		sym.$("playBtn").fadeIn(0);
         		sym.$('mapBg').fadeOut(500);
         		stopTimer();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("standTxt").css({"width":stageWidth-10+"px"});
         	sym.$("mapMc").css({"top":sym.$("standTxt").height()-30+"px"});
         	sym.$("mapBg").css({"top":sym.$("standTxt").height()-30+"px"});
         	sym.$("wallMc").css({"top":sym.$("standTxt").height()+35+"px"});
         	sym.$('table').css({"width":stageWidth+"px"});
         	sym.$("playBtn").css({"left":stageWidth-40+"px"});
         	sym.$("wallMc").css({"left":stageWidth/2-320+"px"});
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         	closeSource();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // CHECK RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		$(".venueDateM").css({'text-align':"right"});
         		sym.getSymbol("mapMc").$("txt12").css({'text-align':"right"});
         		sym.$("standTxt").css({'text-align':"right"});
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':"right"});
         		sym.$("playBtn").css({"left":"0px", 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		//sym.getSymbol("wallMc").$("txt16").css({'text-align':"right"});
         		//sym.getSymbol("wallMc").$("txt17").css({'text-align':"right"});
         		sym.getSymbol("wallMc").$("txt19").css({'text-align':"right"});
         		sym.getSymbol("wallMc").$("txt20").css({'text-align':"right"});
         		sym.getSymbol("wallMc").$("txt21").css({'text-align':"right"});
         	}
         }
         
         //********************************************************************************************************
         // PLAY BTN
         //********************************************************************************************************
         sym.$("playBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	startTimer();
         	sym.$('wallMc').fadeIn(500);
         	sym.$('mapBg').fadeIn(500);
         	sym.getSymbol('wallMc').play(0);
         	sym.getSymbol('wallMc').getSymbol('blocksMc_0').play(0);
         	sym.getSymbol('wallMc').getSymbol('blocksMc_1').play(0);
         	sym.getSymbol('wallMc').getSymbol('blocksMc_2').play(0);
         	sym.getSymbol('wallMc').getSymbol('blocksMc_3').play(0);
         	sym.$("playBtn").fadeOut(0);
         	})
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("mapMc").stop(stageWidth*10);
         	sym.getSymbol("mapBg").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	sym.getSymbol("mapMc").$('table').css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'wallMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 31815, function(sym, e) {
         

      });
      //Edge binding end

   })("wallMc");
   //Edge symbol end:'wallMc'

   //=========================================================
   
   //Edge symbol: 'base'
   (function(symbolName) {   
   
   })("base");
   //Edge symbol end:'base'

   //=========================================================
   
   //Edge symbol: 'wire'
   (function(symbolName) {   
   
   })("wire");
   //Edge symbol end:'wire'

   //=========================================================
   
   //Edge symbol: 'block'
   (function(symbolName) {   
   
   })("block");
   //Edge symbol end:'block'

   //=========================================================
   
   //Edge symbol: 'blocksMc'
   (function(symbolName) {   
   
      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24000, function(sym, e) {
         

      });
      //Edge binding end

   })("blocksMc");
   //Edge symbol end:'blocksMc'

   //=========================================================
   
   //Edge symbol: 'blocksMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("blocksMc_1");
   //Edge symbol end:'blocksMc_1'

   //=========================================================
   
   //Edge symbol: 'blocksMc_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 17000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("blocksMc_2");
   //Edge symbol end:'blocksMc_2'

   //=========================================================
   
   //Edge symbol: 'blocksMc_3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 19000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("blocksMc_3");
   //Edge symbol end:'blocksMc_3'

   //=========================================================
   
   //Edge symbol: 'mapMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("mapBg");
   //Edge symbol end:'mapBg'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34834");