/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // TEXT AND XML
         //*******************************************************************************************************
         
         	var date=[], dateEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34808.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         	$(xml).find("timeline").each(function(){
         		var $date=$(this);
         		dateEvents.push($date);
         	});
         	changeDate();
         	},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         var dates=[];
         function changeDate() {
         		var $events=dateEvents[0].find('years');
         		sym.$("table").empty();
         
         		var i=0;
         		var tableTxt="<table id='datestable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			if($event.attr('number')==clicked){//only get the event that matches 
         				var $dates=$event.find("dates");
         				$dates.each(function(){
         					var $dates=$(this);
         					var dates=$dates.find("date").text();
         					tableTxt+="<td id='"+"dateId"+i+"' class='"+"dateCl'>"+dates+"</td>";
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		sym.$("table").append(tableTxt); //Then attach the buttons:
         		$("#datestable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px", "line-height":"19px",'border-collapse':'collapse', 'width':'100%'});
         		$("#datestable tr:odd").css({"background-color":"rgba(0,110,180,0.18)",'border-color':"rgb(255,255,255)","border-width":"2px 0px","border-style":"solid","opacity":"1"});
         		$("#datestable tr:even").css({"background-color":"rgba(0,110,180,0.1)",'border-color':"rgb(255,255,255)","border-width":"2px 0px","border-style":"solid","opacity":"1"});
         
         		$(".dateCl").css({'width':'90%', "font-weight":"regular", 'padding-top':'10px', 'padding-bottom':'10px', 'padding-left':'6px', 'padding-right':'6px', 'text-align':'left'});
         
         		$("#datestable tr:nth-child(2)").css({"background-color":"#006eb8", "color":"#fff"});
         		$("#datestable tr:nth-child(8)").css({"background-color":"#006eb8", "color":"#fff"});
         		$("#datestable tr:nth-child(15)").css({"background-color":"#006eb8", "color":"#fff"});
         		$("#datestable tr:nth-child(18)").css({"background-color":"#006eb8", "color":"#fff"});
         		$("#datestable tr:nth-child(23)").css({"background-color":"#006eb8", "color":"#fff"});
         		checkRTL();
         		sourceOut();
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	checkRTL();
         	setStyle();
         	sourceOut();
         }
         
         //********************************************************************************************************
         // RTL CHECK
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		var stageWidth=sym.$("Stage").width();
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		$(".dateCl").css({'text-align':'right'});
         	}
         }
         checkRTL();
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sourceOut();
         	}
         }); 
         function sourceOut(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      

      

      

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34808");