/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var stage = 0
         	var standIn = false;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"5px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"background-color":"#da0000", "pointer-events":"none", "color":"white", "padding":"5px", 'height':'auto'});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,0.4)", "height":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.getSymbol("stages").getSymbol("stage0").getSymbol("apollo").$("txt0").css({"pointer-events":"none"});
         	for (var i=1; i<7; i++){
         		txt[i] = sym.getSymbol("stages").getSymbol("stage0").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=7; i<14; i++){
         		txt[i] = sym.getSymbol("stages").$("txt"+i).css(blackTxtBox);
         	}
         	for (var i=14; i<18; i++){
         		txt[i] = sym.getSymbol("stages").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34798.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<18; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			sym.getSymbol("stages").getSymbol("stage0").$("txt1").css({'line-height':"15px"});
         			sym.getSymbol("stages").getSymbol("stage0").$("txt5").css({'line-height':"15px"});
         			sym.$("standTxt").animate ({top:0-sym.$("standTxt").height()}, 0);
         
         			for (var i=7; i<14; i++){
         				txt[i] = sym.getSymbol("stages").$("txt"+i).css({'font-size':'15px', 'line-height':'16px', 'text-align':'center'});
         			}
         			for (var i=14; i<17; i++){
         				txt[i] = sym.getSymbol("stages").$("txt"+i).css({'line-height':'22px'});
         			}
         			sym.getSymbol("stages").$("txt13").css({'top':330-sym.getSymbol("stages").$("txt13").height()+'px','text-align':'left'});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("standTxt").css({"width":stageWidth-10+"px"});
         	sym.$("standBtn").css({'left':stageWidth-40+'px'});
         	sym.$("nextBtn").css({'left':stageWidth-40+'px'});
         	sym.$("stages").css({'top':'30px'});
         
         	if(stageWidth<640){	
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("stages").getSymbol("stage0").$("apollo").fadeOut(0);
         	}else{
         		sym.getSymbol("stages").getSymbol("stage0").$("apollo").fadeIn(0);
         	}
         	setStyle();
         	stageSet();
         	closeStand();
         	checkRTL()
         }
         
         function stageSet(){
         	closeSource();
         	sym.$("stages").css({"left":stageWidth/2-320+"px"});
         	if (stage == 0){
         		if (stageWidth < 480){
         			sym.$("stages").css({"left":stageWidth/2-388+"px"});
         		}else{
         			sym.$("stages").css({"left":stageWidth/2-352+"px"});
         		}
         		sym.getSymbol("stages").stop(0);
         		sym.$("nextBtn").css({"left":stageWidth-40+"px"});
         	}
         }
         
         //********************************************************************************************************
         // RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right'});
         		sym.$("standTxt").css({'text-align':'right'});
         		sym.$("standBtn").css({'left':'0px'});
         		sym.$("nextBtn").css({'left':'0px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	}
         }
         //********************************************************************************************************
         // REPLAY BTN
         //********************************************************************************************************
         sym.getSymbol("stages").$("replayBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("stages").stop(0);
         	sym.$("nextBtn").fadeIn(0);
         	stage = 0;
         	stageSet();
         	});
         	
         //********************************************************************************************************
         // NEXT BTN
         //********************************************************************************************************
         sym.$("nextBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	stage=1;
         	sym.getSymbol("stages").play();
         	stageSet();
         	sym.$("nextBtn").fadeOut(0);
         	});
         
         //********************************************************************************************************
         // STAND BTN
         //********************************************************************************************************
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (standIn==false){
         		sym.$("standTxt").animate ({top:40}, 400, 'easeOutCubic');
         		sym.getSymbol("standBtn").$("arrow").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         		standIn = true;
         		sym.getSymbol("stages").stop();
         	}else{
         		closeStand();
         	}
         });
         
         function closeStand(){
         	if (standIn == true){
         		sym.getSymbol("stages").play();
         		sym.$("standTxt").animate ({top:0-sym.$("standTxt").height()}, 400, 'easeInCubic');
         		sym.getSymbol("standBtn").$("arrow").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         		standIn = false;
         	}
         	if (stage == 0){
         			sym.getSymbol("stages").stop();
         		}
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("nextBtn");
   //Edge symbol end:'nextBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'flamesMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1667, function(sym, e) {
         sym.play(1333);

      });
      //Edge binding end

   })("flamesMc");
   //Edge symbol end:'flamesMc'

   //=========================================================
   
   //Edge symbol: 'stage1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         //sym.stop(0);
         sym.getSymbol('booster').$('flames').fadeOut(0);
         sym.getSymbol('booster').$('boosterTop').fadeOut(0);
         sym.getSymbol('capsuleLand').$('flamesMc').fadeOut(0);
         sym.getSymbol('boosterMini').$('boosterTop').fadeOut(0);
         sym.getSymbol('capsuleFuel').$('flamesMc').fadeOut(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getSymbol('boosterMini').$('flames').fadeOut(200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getSymbol('booster').$('flames').fadeIn(100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10142, function(sym, e) {
         sym.getSymbol('boosterMini').$('flames').fadeIn(200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13511, function(sym, e) {
         sym.getSymbol('boosterMini').$('flames').fadeIn(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14406, function(sym, e) {
         sym.getSymbol('boosterMini').$('flames').fadeOut(200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21000, function(sym, e) {
         sym.getSymbol('boosterMini').$('flames').fadeIn(200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 37929, function(sym, e) {
         sym.getSymbol('capsuleLand').$('flamesMc').fadeIn(200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 39500, function(sym, e) {
         sym.getSymbol('capsuleLand').$('flamesMc').fadeOut(500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getSymbol('boosterMini').$('boosterTop').fadeOut(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 16750, function(sym, e) {
         sym.getSymbol('boosterMini').$('boosterTop').fadeIn(500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 27000, function(sym, e) {
         sym.getSymbol('capsuleFuel').$('flamesMc').fadeIn(1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getSymbol('boosterMini').$('boosterTop').fadeIn(500);

      });
      //Edge binding end

   })("stages");
   //Edge symbol end:'stages'

   //=========================================================
   
   //Edge symbol: 'rocketRear'
   (function(symbolName) {   
   
   })("rocketRear");
   //Edge symbol end:'rocketRear'

   //=========================================================
   
   //Edge symbol: 'appollo'
   (function(symbolName) {   
   
   })("appollo");
   //Edge symbol end:'appollo'

   //=========================================================
   
   //Edge symbol: 'capsule'
   (function(symbolName) {   
   
   })("capsule");
   //Edge symbol end:'capsule'

   //=========================================================
   
   //Edge symbol: 'booster'
   (function(symbolName) {   
   
   })("booster");
   //Edge symbol end:'booster'

   //=========================================================
   
   //Edge symbol: 'stage0'
   (function(symbolName) {   
   
   })("stage0");
   //Edge symbol end:'stage0'

   //=========================================================
   
   //Edge symbol: 'blueRing'
   (function(symbolName) {   
   
   })("blueRing");
   //Edge symbol end:'blueRing'

   //=========================================================
   
   //Edge symbol: 'capsule_1'
   (function(symbolName) {   
   
      })("capsuleFuel");
   //Edge symbol end:'capsuleFuel'

   //=========================================================
   
   //Edge symbol: 'earthFull'
   (function(symbolName) {   
   
   })("earthFull");
   //Edge symbol end:'earthFull'

   //=========================================================
   
   //Edge symbol: 'rocketRear_1'
   (function(symbolName) {   
   
      })("rocketRearGo");
   //Edge symbol end:'rocketRearGo'

   //=========================================================
   
   //Edge symbol: 'earthFull_1'
   (function(symbolName) {   
   
      })("marsFull");
   //Edge symbol end:'marsFull'

   //=========================================================
   
   //Edge symbol: 'marsFull_1'
   (function(symbolName) {   
   
      })("marsLand");
   //Edge symbol end:'marsLand'

   //=========================================================
   
   //Edge symbol: 'capsuleFuel_1'
   (function(symbolName) {   
   
         })("capsuleLand");
   //Edge symbol end:'capsuleLand'

   //=========================================================
   
   //Edge symbol: 'nextBtn_1'
   (function(symbolName) {   
   
      })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'fuelMach'
   (function(symbolName) {   
   
   })("fuelMach");
   //Edge symbol end:'fuelMach'

   //=========================================================
   
   //Edge symbol: 'marsMini'
   (function(symbolName) {   
   
   })("marsMini");
   //Edge symbol end:'marsMini'

   //=========================================================
   
   //Edge symbol: 'txtTable'
   (function(symbolName) {   
   
   })("txtTable");
   //Edge symbol end:'txtTable'

   //=========================================================
   
   //Edge symbol: 'nextBtn_1'
   (function(symbolName) {   
   
      })("replayBtn");
   //Edge symbol end:'replayBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34798");