/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var speed = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"background-color":"rgba(255,255,255,1)", 'color':'#999', "height":"auto","width":"auto", "padding":"6px", "padding-bottom":"20px"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var president=[], person=[], pictureSource=[], personName=[], yearStart=[], yearEnd=[], captionTxt=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34779.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			$(xml).find("president").each(function(){
         			var $president=$(this);
         			person.push($president);
         			});
         			changeEvent();
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         function changeEvent() {
         		var $events=person[0].find('person');
         		$events.each(function(){
         			var $event=$(this);
         			var picturesource=$event.find("picture").text();
         			pictureSource.push(picturesource);
         			var personname=$event.find("name").text();
         			personName.push(personname);
         			var yearstart=$event.find("yearStart").text();
         			yearStart.push(yearstart);
         			var yearend=$event.find("yearEnd").text();
         			yearEnd.push(yearend);
         			var captiontxt=$event.find("txt").text();
         			captionTxt.push(captiontxt);
         		});
         		loadCaption();
         }
         
         function loadCaption(){
         	sym.$("caption").empty();
         	var html = "<div style='font-size:20px; font-weight:400; color:#ca212e'>"+'<b>'+personName[clicked]+'</b>'+' '+'<i>'+yearStart[clicked]+yearEnd[clicked]+'</i>'+'</div><div style="padding-bottom:5px; padding-top:5px; font-size:13px; color:#333">'+captionTxt[clicked]+'</div>';
         	sym.$("caption").append(html).css(blackTxtBox);
         }
         
         //********************************************************************************************************
         // LOAD IMAGES
         //********************************************************************************************************
         imageSymbolArray2 = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i <45; i++){
          var mySymbolObject2 = sym.createChildSymbol("holderMain", "holder");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject2.setVariable("id", i);  //set the value of a Symbol variable
          	imageSymbolArray2.push(mySymbolObject2);  //push it into the array
         }
         
         for (var i=0; i<imageSymbolArray2.length; i++){
         	move = sym.$("Stage").width();
         	imageSymbolArray2[i].$("imgHolder").attr("src", "images/pic_" + (i) + ".jpg");
         	imageSymbolArray2[i].getSymbolElement().animate ({width:move, left:move * i}, 0);
         }
         
         //********************************************************************************************************
         // ADD DATE BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 45; i++){
          var mySymbolObject = sym.createChildSymbol("dateBtn", "dateBtnsMc");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          	imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){dateClicked(symbolInTheArray);});
         })
         
         for (var i=0; i<imageSymbolArray.length; i++){
         	imageSymbolArray[i].getSymbolElement().animate ({width:50, left:50 * i}, 300, 'easeOutCubic');
         }
         
         function dateClicked (symbolInTheArray){ //a function to call to make sure we know it’s working!
          	clicked = symbolInTheArray.getVariable("id");
          	resetClicked();
         }
         
         //********************************************************************************************************
         // RESET ON CLICK
         //********************************************************************************************************
         function resetClicked(){
         	speed = 500;
         	for (var i=0; i<imageSymbolArray.length; i++){
          		imageSymbolArray[i].$("bg").css({'background-color':'#7d93bc'});
          		imageSymbolArray[i].$("txt").css({'color':'#fff'});
          	}
          	imageSymbolArray[clicked].$("bg").css({'background-color':'#2e4b82'});
          	imageSymbolArray[clicked].$("txt").css({'color':'#fff'});
          	sym.$("caption").empty();
         	sym.$("caption").css('height','');
         	sym.$("caption").css('height','auto');
         	loadCaption();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").empty();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css('height','auto');
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source +'<br>'+ pictureSource[clicked]);
         
          	sym.$("dateNavBtnBack").fadeIn(0);
          	sym.$("dateNavBtnNext").fadeIn(0);
         
          	if (clicked>43){
          		sym.$("dateNavBtnNext").fadeOut(0);
          	}
          	if (clicked<1){
          		sym.$("dateNavBtnBack").fadeOut(0);
          	}
          	initSize();
          	checkRTL();
         }
         resetClicked();
         
         //******************************************************************************************************************************************
         // CHECK RTL
         //******************************************************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		for (var i=0; i<imageSymbolArray.length; i++){
         			imageSymbolArray[i].getSymbolElement().animate ({width:50, left:2200-(50 * i)}, 300, 'easeOutCubic');
         		}
         
         		for (var i=0; i<imageSymbolArray2.length; i++){
         			imageSymbolArray2[i].stop(stageWidth*10);
         			imageSymbolArray2[i].getSymbolElement().css({'left':-stageWidth*i + 'px'});
         		}
         
         		for (var i=0; i<imageSymbolArray2.length; i++){
         			imageSymbolArray2[i].$("imgHolder").attr("src", "images/pic_" + (i) + ".jpg");
         		}
         		sym.$('holder').stop().animate ({left:clicked * (stageWidth)}, speed, 'easeOutCubic');
         		sym.$("dateBtnsMc").stop().animate({scrollLeft: 2200-(clicked*50)-(stageWidth-128)/2+25}, 500);
         
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'left':stageWidth-640+'px'});
         		sym.getSymbol("styleHead").$("headArt").css({'left':stageWidth-800+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         
         		sym.$("dateNavBtnNext").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnNextOut").css({'left':'0px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.$("dateNavBtnBack").css({'left':stageWidth-64+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$("dateNavBtnBackOut").css({'left':stageWidth-64+'px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         
         		sym.$("caption").css({'text-align':'right'});
         	}
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("dateBtnsMc").stop().animate({width:stageWidth-128}, 0);
         	sym.$("dateBtnsMc").stop().animate({scrollLeft: (clicked*50)-(stageWidth-128)/2+25}, 500);
         
         	for (var i=0; i<imageSymbolArray2.length; i++){
         		imageSymbolArray2[i].stop(stageWidth*10);
         		imageSymbolArray2[i].getSymbolElement().css({'left':stageWidth*i + 'px'});
         	}
         	sym.$('holder').stop().animate ({left:clicked * (-stageWidth)}, speed, 'easeOutCubic');
         	imgHeight = imageSymbolArray2[0].$("imgHolder").height();
         	txtHeight = sym.$("caption").height();
         
         	if (502-imgHeight <= txtHeight){
         		sym.$("caption").css({'top':540-txtHeight+'px'});
         	}else{
         		sym.$("caption").css({'top':(imgHeight+40)+'px'});
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	checkRTL();
         	setStyle();
         	speed = 0;
         	closeSource();
         }
         
         
         //******************************************************************************************************************************************
         // ARROW BUTTONS
         //******************************************************************************************************************************************
         sym.$("dateNavBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	resetClicked();
         	});
         sym.$("dateNavBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	resetClicked();
         	});
         //******************************************************************************************************************************************
         // SWIPE
         //******************************************************************************************************************************************
         sym.$("mask").on("swipeleft",function(){
         	clicked++;
         	if (clicked>44){
         		clicked = 44;
         	} else {
         		resetClicked();
         	}
         });
         sym.$("mask").on("swiperight",function(){
         	clicked--;
         	if (clicked<0){
         		clicked = 0;
         	} else {
         		resetClicked();
         	}
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("dateBtnsMc").css({'overflow-x':'hidden', 'overflow-y':'hidden'});
         	for (var i=0; i<imageSymbolArray.length; i++){
          		imageSymbolArray[i].$("txt").text(yearStart[i]);
          	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************
         

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("dateBtn");
   //Edge symbol end:'dateBtn'

   //=========================================================
   
   //Edge symbol: 'stageBtnsMc'
   (function(symbolName) {   
   
   })("stageBtnsMc");
   //Edge symbol end:'stageBtnsMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn'
   (function(symbolName) {   
   
   })("stageNavBtn");
   //Edge symbol end:'stageNavBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'arrowOutMc'
   (function(symbolName) {   
   
   })("arrowOutMc");
   //Edge symbol end:'arrowOutMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtnOut'
   (function(symbolName) {   
   
   })("stageNavBtnOut");
   //Edge symbol end:'stageNavBtnOut'

   //=========================================================
   
   //Edge symbol: 'holderMain'
   (function(symbolName) {   
   
   })("holderMain");
   //Edge symbol end:'holderMain'

   //=========================================================
   
   //Edge symbol: 'arrowMc_1'
   (function(symbolName) {   
   
      })("arrowGreyMc");
   //Edge symbol end:'arrowGreyMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34779");