/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL=false; // ARABIC CONVERSION
         	
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none", "line-height":"15px"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"1px","border-style":"solid","border-color":"black", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"white", "height":"auto","width":"auto", "padding":"6px"};
         	var blackTxtBox = {"border-width":"1px","border-style":"solid","border-color":"white", "border-radius":"5px", "color":"white",
         	"background-color":"black", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	var mapTxt = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var txt=[];
         		txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         		txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	
         	for (var i=2; i<18; i++){
         		txt[i] = mapTxt.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	for (var i=19; i<32; i++){
         		txt[i] = sym.getSymbol("profileMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	
         	for (var i=33; i<54; i++){
         		txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34757.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<54 ; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			mapTxt.$("txt2").css(blackTxtBox);
         			mapTxt.$("txt3").css(blackTxtBox);
         			mapTxt.$("txt15").css(whiteTxtBox);
         			mapTxt.$("txt3").animate({left:590-(mapTxt.$("txt3").width()/2)}, 0);
         			sym.$("txt32").css({"font-size":"15px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		startTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		sym.getSymbol("profileMc").getSymbol("profile").play();
         	}else{
         		stopTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		sym.getSymbol("profileMc").getSymbol("profile").stop();
         		sym.$("mask").fadeOut(0);
         		sym.$("scrollMc").css({'overflow-x':'auto'});
         	}
         }); 
         
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
           var stageWidth=sym.$("Stage").width();
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	sym.getSymbol("controlsMc").$("km").text((pos / 381.7).toFixed(1) + " " + (txtArr[0]));
         	sym.getSymbol("controlsMc").$("miles").text((pos / 237).toFixed(1) + " " + (txtArr[1]));
         	var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotRed").position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500);
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         	sym.$("mask").fadeIn(0);
         	if (pos == 0 || pos == 10000) {
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.$("scrollMc").css({'overflow-x':'auto'});
         		stopTimer();
         		sym.$("mask").fadeOut(0);
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("panelMc").stop().animate({left:stageWidth + 200}, 200, 'easeOutCubic');
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	sym.$("controlsMc").animate({left:stageWidth/2-160}, 0);
         	sym.$("controlsMc").fadeIn(100);
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         	sym.$("controlsMc").fadeIn(100);
         	setStyle();
         
         	if(stageWidth<640){
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         	}else{
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").stop().animate({left:stageWidth - 320}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeOut(100);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("panelMc").stop().animate({left:stageWidth + 20}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeIn(100);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	if (RTL == true) {
         		var itemArray1 = ["txt35","txt37","txt39","txt41","txt43","txt45","txt47","txt50","txt52"];
         		$.each(itemArray1, function(index, value) {
         			sym.getSymbol("panelMc").$(value).animate({left:260}, 0);
         		});
         		var itemArray2 = ["txt36","txt38","txt40","txt42","txt44","txt46","txt48"];
         		$.each(itemArray2, function(index, value) {
         			sym.getSymbol("panelMc").$(value).animate({left:8}, 0);
         		});
         		sym.getSymbol("panelMc").$("txt51").animate({left:10}, 0);
         		sym.getSymbol("panelMc").$("txt53").animate({left:10}, 0);
         		for (var i=33; i<54; i++){
         			txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"text-align":"right", "pointer-events":"none"});
         		}
         	} else {
         		var itemArray1 = ["txt35","txt37","txt39","txt41","txt43","txt45","txt47","txt50","txt52"];
         		$.each(itemArray1, function(index, value) {
         			sym.getSymbol("panelMc").$(value).animate({left:11}, 0);
         		});
         		var itemArray2 = ["txt36","txt38","txt40","txt42","txt44","txt46","txt48"];
         		$.each(itemArray2, function(index, value) {
         			sym.getSymbol("panelMc").$(value).animate({left:58}, 0);
         		});
         		sym.getSymbol("panelMc").$("txt51").animate({left:72}, 0);
         		sym.getSymbol("panelMc").$("txt53").animate({left:72}, 0);
         		for (var i=33; i<54; i++){
         			txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"text-align":"left", "pointer-events":"none"});
         		}
         	}
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("profileMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize});
         	//sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeOut(100);
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		sym.$("controlsMc").fadeIn(100);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'profileMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'profile'
   (function(symbolName) {   
   
   })("profile");
   //Edge symbol end:'profile'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews34757");