/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false;
         	var slideLeftMen =   ["304","264","275","275","029","352","358","288","274","612","078","106","401","478","321","251","247","478","275","224","224"];
         	var slideTopMen  =   ["110","089","052","071","215","153","145","165","153","264","126","116","077","091","061","090","088","188","071","140","140"];
         							//  "001","002","003","004","005","006","007","008","009","010","011","012","013","014","015","016","017","018","019","020"
         	var slideLeftWomen = ["304","264","309","275","015","029","006","619","612","597","457","470","321","374","380","251","075","393","254","275","224"];
         	var slideTopWomen  = ["110","089","075","052","255","215","216","067","264","191","096","105","061","149","179","090","126","149","077","071","140"];
         	var slideLeft = slideLeftMen;
         	var slideTop = slideTopMen;
         	var clicked = 0;
         	var nextClick = 0;
         	var scrollPos = 0;
         	var btnNo = 0;
         	var venueNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var gnRed = "#da0000";
         	var whiteTxtBox = {"border-width":"1px","border-style":"solid", "border-radius":"3px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,0.8)", "height":"auto","width":"auto", "padding":"3px", "padding-left":"6px", "padding-right":"6px", "box-shadow":"2px 2px 2px rgba(0,0,0,0.0)"};
         	
         //********************************************************************************************************
         // doneClick()
         //********************************************************************************************************
         function doneClick(){
         	if (venueNo < 1){
         		sym.getSymbol('navBtns').$("backBtn").fadeOut(0);
         	} else {
         		sym.getSymbol('navBtns').$("backBtn").fadeIn(0);
         	}
         	closeSource();
         	resetMenu();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeAsiaMc').fadeOut(0);
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeSaMc').fadeOut(0);
         
         	if (slideLeft == slideLeftMen){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").stop().animate ({left:(slideLeftMen[venueNo]), top:(slideTopMen[venueNo])}, 0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#3777bc"});
         	}
         	if (slideLeft == slideLeftWomen){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").stop().animate ({left:(slideLeftWomen[venueNo]), top:(slideTopWomen[venueNo])}, 0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#da0000"});
         	}
         
         	var tableScroll = sym.$("table").scrollTop();
         	sym.$("table").stop().animate({ scrollTop: tableScroll+$("#venue"+venueNo).position().top }, 100);
         
         	var txt2 = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("place")
         	var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").position();
         	txt2.stop().animate({top:x.top-22, left:x.left}, 50);
         	txt2.empty();
         	txt2.css({"width":"0px", "height":"0px"});
         	txt2.css({"width":"auto", "height":"auto"});
         	txt2.css(whiteTxtBox);
         
         	if (slideLeft == slideLeftMen){
         		if (venueNo > 18){
         			sym.getSymbol('navBtns').$("nextBtn").fadeOut(0);
         			venueNo = 19;
         			resetMenu();
         		}else{
         			sym.getSymbol('navBtns').$("nextBtn").fadeIn(0);
         		}
         		txt2.append(venueNameM[venueNo]);
         	}
         	if (slideLeft == slideLeftWomen){
         		if (venueNo > 19){
         			sym.getSymbol('navBtns').$("nextBtn").fadeOut(0);
         		}else{
         			sym.getSymbol('navBtns').$("nextBtn").fadeIn(0);
         		}
         		txt2.append(venueNameW[venueNo]);
         	}
         
         	var stageWidth=sym.$("Stage").width();
         
         	if (slideLeft[venueNo] < 640){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:300}, 200);
         	}
         	if (slideLeft[venueNo] < 500){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:200}, 200);
         	}
         	if (slideLeft[venueNo] < 400){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()/2}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:150}, 200);
         	}
         	if (slideLeft[venueNo] < 300){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()/2}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:100}, 200);
         	}
         	if (slideLeft[venueNo] < 200){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:50}, 200);
         	}
         	if (slideLeft[venueNo] < 100){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:0}, 200);
         	}
         
         	if (slideLeft == slideLeftMen){
         		if (venueNo == 1||venueNo == 15||venueNo == 16){
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeAsiaMc').fadeIn(0);
         			sym.$("scrollMc").stop().animate({scrollLeft:(640-sym.$("scrollMc").width())/2}, 0);
         		}
         		if (venueNo == 2||venueNo == 3||venueNo == 18){
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeSaMc').fadeIn(0);
         			sym.$("scrollMc").stop().animate({scrollLeft:(640-sym.$("scrollMc").width())/2}, 0);
         		}
         		$("#venue"+20).hide();
         		$(".venueCountryW").hide();
         		$(".venueNameW").hide();
         		$(".eventNameW").hide();
         		$(".venueDateW").hide();
         		$(".venueCountryM").show();
         		$(".venueNameM").show();
         		$(".eventNameM").show();
         		$(".venueDateM").show();
         		sym.getSymbol('sexBtns').getSymbol('btnMen').$("bg").css({"background-color":"#3777bc"});
         		sym.getSymbol('sexBtns').getSymbol('btnWomen').$("bg").css({"background-color":"#999"});
         	}else{ // WOMEN VIEW
         		if (venueNo == 1||venueNo == 15||venueNo == 17){
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeAsiaMc').fadeIn(0);
         			sym.$("scrollMc").stop().animate({scrollLeft:(640-sym.$("scrollMc").width())/2}, 0);
         		}
         		if (venueNo == 2||venueNo == 3||venueNo == 18||venueNo == 19){
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").$('globeSaMc').fadeIn(0);
         			sym.$("scrollMc").stop().animate({scrollLeft:(640-sym.$("scrollMc").width())/2}, 0);
         		}
         		$("#venue"+20).show();
         		$(".venueCountryM").hide();
         		$(".venueNameM").hide();
         		$(".eventNameM").hide();
         		$(".venueDateM").hide();
         		$(".venueCountryW").show();
         		$(".venueNameW").show();
         		$(".eventNameW").show();
         		$(".venueDateW").show();
         		sym.getSymbol('sexBtns').getSymbol('btnWomen').$("bg").css({"background-color":gnRed});
         		sym.getSymbol('sexBtns').getSymbol('btnMen').$("bg").css({"background-color":"#999"});
         	}
         	if (stageWidth < 640){
         		if (slideLeft == slideLeftMen){
         			$(".venueNameM").hide();
         		}
         		if (slideLeft == slideLeftWomen){
         			$(".venueNameW").hide();
         		}
         	}
         }
         
         //********************************************************************************************************
         // NAV BUTTONS
         //********************************************************************************************************
         	sym.getSymbol('navBtns').$("nextBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		venueNo++;
         		doneClick();
         	});
         
         	sym.getSymbol('navBtns').$("backBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		venueNo--;
         		doneClick();
         	});
         
         //********************************************************************************************************
         // XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.getSymbol("panelMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("panelMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("panelMc").$("txt2").css({"pointer-events":"none"});
         	for (var i=3; i<10; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         	var venueNameM=[];
         	var eventNameM=[];
         	var venueDateM=[];
         	var venueCountryM=[];
         	var venueNameW=[];
         	var eventNameW=[];
         	var venueDateW=[];
         	var venueCountryW=[];
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34753.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			standBackgroudColour = $(xml).find('standBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			//var fontSize= $(xml).find('fontSize').text();
         
         			for (var i=0; i<10; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				//txt[i].css({'font-size':fontSize});
         			}
         
         //NEW TABLE
         for (var t=0;t<21; t++){	//get details for each team
         	$(xml).find("venue"+t).each(function(){
         		var $event=$(this);
         		var venuenamem=$event.find("venueM").text();
         		venueNameM.push(venuenamem);
         		var venuedatem=$event.find("dateM").text();
         		venueDateM.push(venuedatem);
         		var eventnamem=$event.find("eventM").text();
         		eventNameM.push(eventnamem);
         		var venuecountrym=$event.find("countryM").text();
         		venueCountryM.push(venuecountrym);
         		var venuenamew=$event.find("venueW").text();
         		venueNameW.push(venuenamew);
         		var venuedatew=$event.find("dateW").text();
         		venueDateW.push(venuedatew);
         		var eventnamew=$event.find("eventW").text();
         		eventNameW.push(eventnamew);
         		var venuecountryw=$event.find("countryW").text();
         		venueCountryW.push(venuecountryw);
         	});
         }
         var tableTxt="<table id='venueTable'>";
         for (var i=0;i<21;i++){ //create a row for each sport
         tableTxt+="<tr id='venue"+i+"' class='venue'>";
         	if (RTL == false){
         		tableTxt+="<td id='datem"+i+"' class='venueDateM'>"+venueDateM[i]+"</td>";
         		tableTxt+="<td id='eventm"+i+"' class='eventNameM'>"+eventNameM[i]+"</td>";
         		tableTxt+="<td id='venuem"+i+"' class='venueNameM'>"+venueNameM[i]+"</td>";
         		tableTxt+="<td id='countrym"+i+"' class='venueCountryM'>"+venueCountryM[i]+"</td>";
         
         		tableTxt+="<td id='datew"+i+"' class='venueDateW'>"+venueDateW[i]+"</td>";
         		tableTxt+="<td id='eventw"+i+"' class='eventNameW'>"+eventNameW[i]+"</td>";
         		tableTxt+="<td id='venuew"+i+"' class='venueNameW'>"+venueNameW[i]+"</td>";
         		tableTxt+="<td id='countryw"+i+"' class='venueCountryW'>"+venueCountryW[i]+"</td>";
         	}else{
         		tableTxt+="<td id='countryw"+i+"' class='venueCountryW'>"+venueCountryW[i]+"</td>";
         		tableTxt+="<td id='venuew"+i+"' class='venueNameW'>"+venueNameW[i]+"</td>";
         		tableTxt+="<td id='eventw"+i+"' class='eventNameW'>"+eventNameW[i]+"</td>";
         		tableTxt+="<td id='datew"+i+"' class='venueDateW'>"+venueDateW[i]+"</td>";
         
         		tableTxt+="<td id='countrym"+i+"' class='venueCountryM'>"+venueCountryM[i]+"</td>";
         		tableTxt+="<td id='venuem"+i+"' class='venueNameM'>"+venueNameM[i]+"</td>";
         		tableTxt+="<td id='eventm"+i+"' class='eventNameM'>"+eventNameM[i]+"</td>";
         		tableTxt+="<td id='datem"+i+"' class='venueDateM'>"+venueDateM[i]+"</td>";
         	}
         	tableTxt+="</tr>";
         }
         
         sym.$('table').append(tableTxt);
         for (var i=0;i<venueNameM.length;i++){
         	$("#venue"+i).on('click',showSport(i));
         }
         $("#venueTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px", 'line-height':'28px','border-collapse':'collapse', 'width':'100%'});
         $("#venueTable tr:odd"). css({'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         $("#venueTable tr:even").css({'border-color':"rgb(255,255,255)", "border-width":"2px 0px 0px 0px", "border-style":"solid"});
         $(".venue").css({'height':'10px', 'cursor':'pointer'});
         
         $(".venueCountryM").css({'padding':'6px', "vertical-align":"top"});
         $(".venueNameM")   .css({'padding':'6px', "vertical-align":"top", 'font-weight':'bold', "background-color":"rgba(100,100,100,0.1)"});
         $(".eventNameM")   .css({'padding':'6px', "vertical-align":"top"});
         $(".venueDateM")   .css({'width':'25%','padding':'6px', "vertical-align":"top", 'font-weight':'bold', "background-color":"rgba(100,100,100,0.1)"});
         
         $(".venueCountryW").css({'padding':'6px', "vertical-align":"top"});
         $(".venueNameW")   .css({'padding':'6px', "vertical-align":"top", 'font-weight':'bold', "background-color":"rgba(100,100,100,0.1)"});
         $(".eventNameW")   .css({'padding':'6px', "vertical-align":"top"});
         $(".venueDateW")   .css({'padding':'6px', "vertical-align":"top", 'font-weight':'bold', "background-color":"rgba(100,100,100,0.1)"});
         },
         complete:function(){
         	resetMenu();
         	doneClick();
         	initSize();
         }
         }); // END XML
         
         //********************************************************************************************************
         // TABLE CLICKS
         //********************************************************************************************************
         var showSport = function(showSport){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		venueNo = showSport;
         		doneClick();
         	};
         };
         
         //********************************************************************************************************
         // GENDER BUTTONS
         //********************************************************************************************************
         sym.getSymbol('sexBtns').$('btnMen').on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	men = true;
         	slideLeft = slideLeftMen;
         	slideTop = slideTopMen;
         	doneClick();
         });
         sym.getSymbol('sexBtns').$('btnWomen').on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	men = false;
         	slideLeft = slideLeftWomen;
         	slideTop = slideTopWomen;
         	doneClick();
         });
         
         //********************************************************************************************************
         // RESET MENU
         //********************************************************************************************************
         function resetMenu(){
         	if (slideLeft == slideLeftMen){
         		for (var i=0; i<21; i++){
         			$("#venue"+i).css({"color":"#000", "background-color":"#e5f2ff"});
         		}
         		$("#venue"+venueNo).css({"color":"#fff", "background-color":"#3777bc"});
         	} else {
         		for (var i=0; i<21; i++){
         			$("#venue"+i).css({"color":"#000", "background-color":"#f4dcdc"});
         		}
         		$("#venue"+venueNo).css({"color":"#fff", "background-color":"#da0000"});
         	}
         }
         resetMenu();
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	sym.$("sexBtns").animate({left:stageWidth-80}, 0);
         	doneClick();
         
         	if(stageWidth<640){
         		sym.$("standBtn").animate({top:40}, 0);
         		sym.$("scrollMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("table").animate({width:stageWidth}, 0);
         		sym.$("panelMc").animate({left:stageWidth+20}, 0);
         		sym.$("scrollMc").css({left:0, width:stageWidth}, 0);
         		sym.$('navBtns').css({left:(stageWidth/2)-40}, 0);
         		$(".venueNameW").hide();
         		$(".venueNameM").hide();
         
         	}else{
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("table").animate({width:stageWidth-204}, 0);
         		sym.$("panelMc").animate({left:stageWidth-200}, 0);
         		sym.$("scrollMc").stop().animate({left:0, width:stageWidth-190}, 0);
         		sym.$('navBtns').css({left:(stageWidth/2)-125}, 0);
         		if (slideLeft == slideLeftMen){
         			$(".venueNameM").show();
         		}
         		if (slideLeft == slideLeftWomen){
         			$(".venueNameW").show();
         		}
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         	setStyleUpdate();
         
         	closeSource();
         	checkRTL();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").stop().animate({left:stageWidth-200}, 200);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("panelMc").stop().animate({left:stageWidth+10}, 200);
         	}
         	closeSource();
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function checkRTL(){
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":'right'});
         		sym.$("sexBtns").animate({left:0}, 0);
         		sym.$("navBtns").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		$(".venueCountryM").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueM").css({"text-align":'right',"padding-right":'5px'});
         		$(".eventNameM").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueNameM").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueDateM").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueCountryW").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueW").css({"text-align":'right',"padding-right":'5px'});
         		$(".eventNameW").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueNameW").css({"text-align":'right',"padding-right":'5px'});
         		$(".venueDateW").css({"text-align":'right',"padding-right":'5px'});
         		sym.getSymbol("panelMc").$("txt0").css({"text-align":'right'});
         		sym.getSymbol("panelMc").$("txt1").css({"text-align":'right'});
         		sym.getSymbol("panelMc").$("txt2").css({"text-align":'right'});
         	}
         }
         
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize});
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         });
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtnHead");
   //Edge symbol end:'menuBtnHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtn_1'
   (function(symbolName) {   
   
   })("navBtnBack");
   //Edge symbol end:'navBtnBack'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'sexBtn'
   (function(symbolName) {   
   
   })("btnMen");
   //Edge symbol end:'btnMen'

   //=========================================================
   
   //Edge symbol: 'btnMen_1'
   (function(symbolName) {   
   
   })("btnWomen");
   //Edge symbol end:'btnWomen'

   //=========================================================
   
   //Edge symbol: 'sexBtns'
   (function(symbolName) {   
   
   })("sexBtns");
   //Edge symbol end:'sexBtns'

   //=========================================================
   
   //Edge symbol: 'globeSaMc'
   (function(symbolName) {   
   
   })("globeSaMc");
   //Edge symbol end:'globeSaMc'

   //=========================================================
   
   //Edge symbol: 'globeAsiaMc'
   (function(symbolName) {   
   
   })("globeAsiaMc");
   //Edge symbol end:'globeAsiaMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews34753");