/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var gn=34746;
         	var stand, standmob, todayDate, endDate, status, votetxt;
         	var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://data.graphicnews.com/")+ "data/api.php";
         	//********************************************************************************************************
         	// CSS STYLES
         	//********************************************************************************************************
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         		"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         		"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,0.15)","border":"solid 1px rgba(0,0,0,0.6)"};
         	var white  = {"background-color":"rgba(255,255,255,1)","border":"solid 1px rgba(255,255,255,0)"};
         	var leaveColor="rgba(233,74,49,1)";
         	var remainColor="rgba(52,144,206,1)";
         	//********************************************************************************************************
         	// DATE
         	//********************************************************************************************************
         	var pollsOpen = Date.parse("November 8, 2016, 00:01 UTC");
         	var pollsClose = Date.parse("November 8, 2016, 23:59 UTC");
         	endDate = Date.parse("November 9, 2016, 23:59 UTC");
         	function getDate(){
         		todayDate = new Date();
         		if(todayDate<pollsOpen){
         			status=0;
         		}else if(todayDate>pollsClose){
         			status=2;
         		}else{
         			status=1;
         		}
         		setTimeout(function(){ getDate(); },3600000);
         	}
         	getDate();
         	//********************************************************************************************************
         	// TEXT AND XML
         	//********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<3; i++){
         			txt[i]=sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var searchtxt, constitArr=[], statusArr=[]; regionArr=[], txtArr=[], localWin=[], candArr=[], leanArr=[];
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gn+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			stand = $(xml).find('standtxt').text();
         			standmob = $(xml).find('mobstandtxt').text();
         			votetxt = $(xml).find('votes').text();
         			source = $(xml).find('source').text();
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source);
         			for(var i=0;i<txt.length;i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         			}
         			var statustxt=$(xml).find('status').text(); statusArr=statustxt.split(';');
         			var candidates=$(xml).find('candidatesShort').text(); candArr=candidates.split(';');
         		},
         		complete:function(){
         			initSize();
         	   }
         	});
         	//********************************************************************************************************
         	// INIT SIZE
         	//********************************************************************************************************
         	function initSize(){
         		var stageWidth=sym.$("Stage").width();
         			sym.stop(stageWidth*10);
         		stageWidth<640?sym.$("standTxt").html(standmob):sym.$("standTxt").html(stand);
         		if(stageWidth<480){
         			mob = 1;
         			sym.$("standTxt").css({'font-size':'14px'});
         			sym.$("barchart").css({'width':"98%"});sym.$("styleBase").css({'width':"100%"});
         		}else if(stageWidth<640){
         			sym.$("standTxt").css({'font-size':'15px'});
         			sym.$("barchart").css({'width':"73%"});sym.$("styleBase").css({'width':"73%"});
         		}else{
         			mob = 0;
         			sym.$("standTxt").css({'font-size':'15px'});
         			sym.$("barchart").css({'width':stageWidth-166+"px"});sym.$("styleBase").css({'width':stageWidth-166+"px"});
         		}
         		setStyle();
         	}
         	//********************************************************************************************************
         	// SET STYLE  
         	function setStyle(){
         		var stageWidth=sym.$("Stage").width();
         		$(".key").css({'padding':'1px 10px 1px','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto','height':'15px'});
         		$(".dem").css({'background-color':'#3490ce'});$(".rep").css({'background-color':'#e94a31'});
         		$(".regiontxt").css({'padding':'1px 10px 3px','background-color':'#009640','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto'});
         		sym.getSymbol("barchart").$("marker").css({'border-right':'dotted 2px rgba(0,0,0,1)'});
         		$(".winner").css({'font-size':'90%','font-style':'oblique'});
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css({ "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"});
         	}
         	setStyle();
         	//********************************************************************************************************
         	// SOURCE BUTTON
         	sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         		if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		}else{
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		}
         	}); 
         	sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         	});
         	sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         	});
         	//********************************************************************************************************
         	//LIVE TOTAL
         	function getSum(){
         		$.ajax({ type: "GET", 
         					url: dataURL,
         	            data: "gn=34691&q=sum&yr=2016",
         	            contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	            async: true,
         	            crossDomain: true,
         	            success: function (data) {         
         						var voteCount = data;
         						if(voteCount.length>0){
         							var demNo = (voteCount[0].DemECvotes>0?voteCount[0].DemECvotes:0); var demTot = voteCount[0].DemTotal; var demStates = Number(voteCount[0].DemStates);
         							var repNo = (voteCount[0].RepECvotes>0?voteCount[0].RepECvotes:0); var repTot = voteCount[0].RepTotal; var repStates = Number(voteCount[0].RepStates);
         							var IndNo = voteCount[0].IndECvotes; var indTot = voteCount[0].IndTotal; var indStates = voteCount[0].IndStates;
         							var statesCounted= voteCount[0].StatesCounted;
         							var timeStamp = voteCount[0].Time;
         							undeclared=(demStates>0||repStates>0||indStates>0)?51-(demStates+repStates+indStates):51;
         							if(status>0){
         								sym.getSymbol("barchart").$("dembar").stop(0).animate({'width':demNo/538*100+'%'},400,'easeOutQuad');
         								sym.getSymbol("barchart").$("repbar").stop(0).animate({'width':repNo/538*100+'%'},400,'easeOutQuad');
         								sym.getSymbol("barchart").$("demNoTxt").html(demNo); sym.getSymbol("barchart").$("repNoTxt").html(repNo);
         							}
         						}
         					}
         		});
         		setTimeout(function(){getSum()}, 60000);
         	}
         	getSum();
         	//********************************************************************************************************
         	$(window).on('resize',initSize);
         	initSize();
         	//-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'MapMc'
   (function(symbolName) {   
   
   })("MapMc");
   //Edge symbol end:'MapMc'

   //=========================================================
   
   //Edge symbol: 'GraphMc'
   (function(symbolName) {   
   
   })("GraphMc");
   //Edge symbol end:'GraphMc'

   //=========================================================
   
   //Edge symbol: 'RegionGraphMc'
   (function(symbolName) {   
   
   })("RegionGraphMc");
   //Edge symbol end:'RegionGraphMc'

   //=========================================================
   
   //Edge symbol: 'AuxBtn'
   (function(symbolName) {   
   
   })("AuxBtn");
   //Edge symbol end:'AuxBtn'

   //=========================================================
   
   //Edge symbol: 'KeyMc'
   (function(symbolName) {   
   
   })("KeyMc");
   //Edge symbol end:'KeyMc'

   //=========================================================
   
   //Edge symbol: 'propMc'
   (function(symbolName) {   
   
   })("propMc");
   //Edge symbol end:'propMc'

   //=========================================================
   
   //Edge symbol: 'barchartMc'
   (function(symbolName) {   
   
   })("Barchart");
   //Edge symbol end:'Barchart'

   //=========================================================
   
   //Edge symbol: 'SearchBtnMc'
   (function(symbolName) {   
   
   })("SearchBtnMc");
   //Edge symbol end:'SearchBtnMc'

   //=========================================================
   
   //Edge symbol: 'ListMc'
   (function(symbolName) {   
   
   })("ListMc");
   //Edge symbol end:'ListMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34746");