/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var nextClick = 0;
         	var scrollPos = 0;
         	var btnNo = 0;
         	var venueNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var gnRed = "#da0000";
         	var whiteTxtBox = {"border-width":"1px","border-style":"solid", "border-radius":"3px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,0.8)", "height":"auto","width":"auto", "padding":"3px", "padding-left":"6px", "padding-right":"6px", "box-shadow":"2px 2px 2px rgba(0,0,0,0.0)"};
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function doneClick(){
         	if (venueNo <= 0){
         		sym.$("backBtn").fadeOut(0);
         	} else if (venueNo >= 47){
         		sym.$("nextBtn").fadeOut(0);
         	} else {
         		sym.$("nextBtn").fadeIn(0);
         		sym.$("backBtn").fadeIn(0);
         	}
         	resetMenu();
         
          	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#3777bc"});
         	if (venueNo == 21|| venueNo == 31 || venueNo == 36 || venueNo == 41) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#da0000"});
         	}
         	if (venueNo == 43|| venueNo == 44 || venueNo == 45 || venueNo == 46) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"rgba(252,175,23,1)"});
         	}
         	var itemArray = ["al","az","ct","fl","ga","il","in","la","ma","md","mn","ms","nc","nj","nv","ny","oh","pa","sc","tn","tx","wi","wv","ca","globeAsia","globeSA"];
         	$.each(itemArray, function(index, value) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$(value).fadeOut(200);
         	});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$((stShortArr[venueNo])).stop().fadeIn(200);
         
         	var slideleft = ["007","268","288","289","065","200","364","102","102","050","046","090","007","024","390","180","365","379","212","256","238","355","368","208","286","384","370","219","215","333","284","287","413","380","360","275","155","328","221","031","339","359","363","413","421","288","334","402"];
         	var slideTop  = ["114","231","190","160","143","117","195","097","097","172","175","172","126","158","243","117","235","223","223","121","223","173","178","231","222","158","208","197","197","095","166","072","066","100","120","095","076","183","066","108","086","152","145","073","061","085","170","086"];
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").stop().animate ({left:(slideleft[venueNo]), top:(slideTop[venueNo])}, 0);
         
         	var txt2 = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2")
         	var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").position();
         	txt2.stop().animate({top:x.top-22, left:x.left - txt2.width()/2}, 50);
         	txt2.empty();
         	txt2.css({"width":"0px", "height":"0px"});
         	txt2.css({"width":"auto", "height":"auto"});
         	txt2.append(stateArr[venueNo]);
         
         	var stageWidth=sym.$("Stage").width();
         	txt2.stop().animate({top:x.top-26, left:x.left+0}, 200);
         	sym.$("scrollMc").stop().animate({scrollLeft:(460-stageWidth)/2}, 50);
         
         	if (x.left < 100){
         		sym.$("scrollMc").stop().animate({scrollLeft:-160}, 50);
         	}
         	if (x.left > 200){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()/2}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:+160}, 50);
         	}
         	if (x.left > 400){
         		txt2.stop().animate({top:x.top - txt2.height()-12, left:x.left - txt2.width()}, 200);
         	}
         	if (venueNo == 1 || venueNo == 3 || venueNo == 5 || venueNo == 7 || venueNo == 8 || venueNo == 19 || venueNo == 36 || venueNo == 38){
         		sym.$("scrollMc").stop().animate({scrollLeft:scrollPos}, 200);
         	}
         	var tableScroll = sym.$("table").scrollTop();
         	sym.$("table").stop().animate({ scrollTop: tableScroll+$("#venue"+venueNo).position().top }, 100);
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU TEXT START
         	var state=[];
         	var stShort=[];
         	for (var i=0; i<48; i++){
         		state[i] = sym.$("txt2").css({"pointer-events":"none"});
         		stShort[i] = sym.$("txt2").css({"pointer-events":"none"});
         		state[0] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css(whiteTxtBox);
         	}
         	var stShortArr=[];
         	var stateArr=[];
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // NEXT BUTTONS COUNT
         	sym.$("nextBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		venueNo++;
         		doneClick();
         	});
         
         // BACK BUTTONS COUNT
         	sym.$("backBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		venueNo--;
         		doneClick();
         	});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none", "width":"auto", "height":"auto"});
         	txt[3] = sym.getSymbol("panelMc").$("txt3").css({"pointer-events":"none", "background-color":"rgba(255,255,255,0.9)", "height":"auto"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none", "padding":"5px"});
         	var txtArr=[];
         	var venueName=[];
         	var venueDate=[];
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34726.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			standBackgroudColour = $(xml).find('standBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         
         			for (var i=0; i<48; i++){
         				stateArr[i]=$(xml).find('state'+i).text();
         				state[i].html(stateArr[i]);
         				stShortArr[i]=$(xml).find('stShort'+i).text();
         				stShort[i].html(stShortArr[i]);
         			} // MENU TEXT END
         
         			for (var i=0; i<5; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("txt2").css({"pointer-events":"none", 'font-size':"13px", 'line-height':"16px"});
         			sym.getSymbol("panelMc").$("txt3").css({"top":530-sym.getSymbol("panelMc").$("txt3").height()+"px", "padding":"6px"});
         
         //NEW TABLE
         for (var t=0;t<48; t++){	//get details for each team
         $(xml).find("venue"+t).each(function(){
         	var $event=$(this);
         	var venuename=$event.find("name").text();
         	venueName.push(venuename);
         	var venuedate=$event.find("date").text();
         	venueDate.push(venuedate);
         });
         }
         var tableTxt="<table id='venueTable'>";
         for (var i=0;i<48;i++){ //create a row for each sport
         	tableTxt+="<tr id='venue"+i+"' class='venue'>";
         	tableTxt+="<td id='no"+i+"' class='venueNo'>"+(i+1)+"</td>";
         	tableTxt+="<td id='name"+i+"' class='venueName'>"+venueName[i]+"</td>";
         	tableTxt+="<td id='date"+i+"' class='venueDate'>"+venueDate[i]+"</td>";
         	tableTxt+="</tr>";
         }
         
         sym.$('table').append(tableTxt);
         for (var i=0;i<venueName.length;i++){
         	$("#venue"+i).on('click',showSport(i));
         }
         
         $("#venueTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px",'border-collapse':'collapse', 'width':'100%'});
         $("#venueTable tr:odd").css({"background-color":"#E9E9EA",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $("#venueTable tr:even").css({"background-color":"#f8f8f9",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $(".venue").css({'height':'30px', 'cursor':'pointer'});
         $(".venueNo").css({'width':'6%', 'padding-top':'6px',"vertical-align":"top", "background-color":"rgba(0,0,0,0.1)", 'font-weight':'bold', 'text-align':'center'});
         $(".venueName").css({'width':'72%','padding-left':'8px', 'padding-top':'6px',"vertical-align":"top"});
         $(".venueDate").css({'width':'22%','padding-left':'8px', 'padding-top':'6px',"vertical-align":"top", 'font-weight':'bold',"background-color":"rgba(0,0,0,0.1)"});
         
         var table = document.getElementById("venueTable");
             var row1 = table.insertRow(43);
             var cell0 = row1.insertCell(0);
             var cell1 = row1.insertCell(1);
             cell1.innerHTML = (txtArr[0]);
         
             var row2 = table.insertRow(48);
             var cell2 = row2.insertCell(0);
             var cell2 = row2.insertCell(1);
             cell2.innerHTML = (txtArr[1]);
         
             var row3 = table.insertRow(50);
             var cell3 = row3.insertCell(0);
             var cell3 = row3.insertCell(1);
             cell3.innerHTML = (txtArr[4]);
         
             cell1.style.height = "30px";
             cell2.style.height = "30px";
             cell3.style.height = "30px";
         	},
            complete:function(){
         		initSize();
         		resetMenu();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // TABLE CLICKS
         //********************************************************************************************************
         var showSport = function(showSport){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		venueNo = showSport;
         		doneClick();
         	};
         };
         //********************************************************************************************************
         // RESET MENU
         //********************************************************************************************************
         function resetMenu(){
         	for (var i=0; i<48; i++){
         		$("#venue"+i).css({"color":"#000", "background-color":"#e5f2ff"});
         	}
         	$("#venue"+21).css({"background-color":"rgba(218,0,0,0.1)"});
         	$("#venue"+31).css({"background-color":"rgba(218,0,0,0.1)"});
         	$("#venue"+36).css({"background-color":"rgba(218,0,0,0.1)"});
         	$("#venue"+41).css({"background-color":"rgba(218,0,0,0.1)"});
         	$("#venue"+43).css({"background-color":"rgba(252,175,23,0.2)"});
          	$("#venue"+44).css({"background-color":"rgba(252,175,23,0.2)"});
          	$("#venue"+45).css({"background-color":"rgba(252,175,23,0.2)"});
          	$("#venue"+46).css({"background-color":"rgba(252,175,23,0.2)"});
          	if (venueNo<48){
          		$("#venue"+venueNo).css({"color":"#fff", "background-color":"#3777bc"});
          	}
          	if (venueNo==21 || venueNo==31 || venueNo==36 || venueNo==41){
          		$("#venue"+venueNo).css({"color":"#fff", "background-color":"rgba(218,0,0,1)"});
          	}
          	if (venueNo==43 || venueNo==44 || venueNo==45 || venueNo==46){
          		$("#venue"+venueNo).css({"color":"#000", "background-color":"rgba(252,175,23,1)"});
          	}
         }
         resetMenu();
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         
         	if(stageWidth<640){
         		scrollPos = (460-stageWidth)/2;
         		sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         		sym.$("standBtn").animate({top:0}, 0);
         		sym.$("scrollMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("table").animate({width:stageWidth}, 0);
         		sym.$("panelMc").animate({left:stageWidth+20}, 0);
         	}else{
         		scrollPos = (780-stageWidth)/2
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("table").animate({width:stageWidth-325}, 0);
         		sym.$("panelMc").animate({left:stageWidth-320}, 0);
         		sym.$("scrollMc").stop().animate({width:stageWidth-320}, 0);
         		sym.$("scrollMc").stop().animate({scrollLeft:scrollPos}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").stop().animate({left:stageWidth-320}, 200);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("panelMc").stop().animate({left:stageWidth+20}, 200);
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize});
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("txt2").fadeOut(0);
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		sym.$("txt2").stop().delay(200).fadeIn(0);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         doneClick();
         sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("ca").fadeIn(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtnHead");
   //Edge symbol end:'menuBtnHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtn_1'
   (function(symbolName) {   
   
   })("navBtnBack");
   //Edge symbol end:'navBtnBack'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34726");