/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<19; i++){
         		txt[i] = sym.getSymbol("mapPanel").getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	var txtArr=[], data=[], dataEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34718.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<19; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			$(xml).find("dataTable").each(function(){
         				var $data=$(this);
         				dataEvents.push($data);
         			});
         			addDataTable();
         			
         			sym.getSymbol("mapPanel").getSymbol("mapMc").$("txt17").css({'line-height':"20px"});
         			sym.getSymbol("mapPanel").getSymbol("mapMc").$("txt18").css({'line-height':"20px"});
         		},
            complete:function(){
         		initSize();
            }
         }); // END XML
         
         var dat=[]
         function addDataTable() {
         		var $events=dataEvents[0].find('data');
         		sym.$("table").empty();
         		var i=0;
         		var tableTxt="<table id='datatable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			if($event.attr('number')==0){//only get the event that matches 
         				var $dat=$event.find("dat");
         				$dat.each(function(){
         					var $dat=$(this);
         					var tab=$dat.find("tab").text();
         					tableTxt+="<tr id='"+"data"+i+"' class='"+"data'>";
         					tableTxt+="<td id='"+"tabId"+i+"' class='"+"tabCl'>"+tab+"</td>";
         
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		sym.$("table").append(tableTxt); //Then attach the buttons:
         		$("#datatable").css({"font-family":"pragmatica-web, arial sans-serif", "line-height":"18px","font-size":"14px",'border-collapse':'collapse', 'width':'100%'});
         		$("#datatable tr:odd").css({"background-color":"#fff",'border-color':"rgb(255,255,255)","border-width":"0px ","border-style":"solid"});
         		$("#datatable tr:even").css({"background-color":"#ebe6da",'border-color':"rgb(255,255,255)","border-width":"0px ","border-style":"solid"});
         		$("#datatable tr:first-child").css({"background-color":"#ffffff"});
         		$("#datatable tr:nth-child(12)").css({"background-color":"#778786", "color":"#fff", 'border-color':"#fff","border-top":"2px", "border-bottom":"2px","border-style":"solid"});
         		$("#datatable tr:nth-child(13)").css({"background-color":"#778786", "color":"#fff", 'border-color':"#fff","border-top":"2px", "border-bottom":"2px","border-style":"solid"});
         		$("#datatable tr:nth-child(14)").css({"background-color":"#778786", "color":"#fff", 'border-color':"#fff","border-top":"2px","border-style":"solid"});
         
         		$(".data").css({'height':'30px', "vertical-align":"top"});
         		$(".tabCl").css({'width':'100%', "font-weight":"regular", 'padding-left':'8px', 'padding-right':'5px', 'text-align':'left', 'padding-top':'10px', 'padding-bottom':'8px'});
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$('mapBtn').css({'left':stageWidth-40 + 'px'});
         	sym.getSymbol("mapPanel").$('mapMc').css({'left':(stageWidth/2)-160 + 'px'});
         
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         	closeSource();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // MAP BTN
         //********************************************************************************************************
         var mapVis = false;
         sym.$("mapBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	closeSource();
         	if (mapVis == false){
         		sym.$("mapPanel").animate ({left:0}, 200, 'easeOutCubic');
         		sym.$("mapBtn").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		mapVis = true;
         	} else {
         		sym.$("mapPanel").animate ({left:stageWidth}, 200, 'easeInCubic');
         		sym.$("mapBtn").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		mapVis = false;
         	}
         });
         
         //********************************************************************************************************
         // RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		$(".tabCl").css({'text-align':'right'});
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right'});
         		sym.getSymbol("mapPanel").getSymbol("mapMc").$("txt18").css({'left':'15px', 'text-align':'right'});
         		sym.getSymbol("mapPanel").getSymbol("mapMc").$("keyMc").css({'left':'290px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$('mapBtn').css({'left':'0px'});
         	}
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("table").css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'mapPanel'
   (function(symbolName) {   
   
   })("mapPanel");
   //Edge symbol end:'mapPanel'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
   })("keyMc");
   //Edge symbol end:'keyMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34718");