/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob=0, mobOpen=false, clicked=0, btnNo=0, local=0, showsearch=0, mapClick=0, targetCon=0;
         	var gn=34691;
         	var menuBtnCount=2;//number of menu items
         	var headline, headlinemob, stand, standmob, todayDate, endDate, status, votetxt, preelection;
         	var demcolor, repcolor, replcolor, demlcolor, indcolor, indlcolor;//Oct27
         	var headlinetxt = sym.getSymbol("styleHead").$("headlinetxt").css({"pointer-events":"none"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://data.graphicnews.com/")+ "data/api.php";//Nov8
         	//********************************************************************************************************
         	// CSS STYLES
         	//********************************************************************************************************
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         		"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         		"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,0.15)","border":"solid 1px rgba(0,0,0,0.6)"};
         	var white  = {"background-color":"rgba(255,255,255,1)","border":"solid 1px rgba(255,255,255,0)"};
         	var leaveColor="rgba(233,74,49,1)";
         	var remainColor="rgba(52,144,206,1)";
         	//********************************************************************************************************
         	// MENU TEXT START
         	//********************************************************************************************************
         	var menuArr=[];;
         	var menuTxt = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	//********************************************************************************************************
         	// DATE
         	//********************************************************************************************************
         	var pollsOpen = Date.parse("November 8, 2016, 00:01 UTC");
         	var pollsClose = Date.parse("November 8, 2016, 23:59 UTC");
         	endDate = Date.parse("November 9, 2016, 23:59 UTC");
         	function getDate(){
         		todayDate = new Date();
         		if(todayDate<pollsOpen){
         			status=0;
         		}else if(todayDate>pollsClose){
         			status=2;
         		}else{
         			status=1;
         		}
         		setTimeout(function(){ getDate(); },3600000);
         	}
         	getDate();
         	//********************************************************************************************************
         	// TEXT AND XML
         	//********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<5; i++){
         			txt[i]=sym.$("txt"+i).css({"pointer-events":"none"});
         			//		txt[i] = sym.getSymbol("graphMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=5; i<10; i++){
         			txt[i] = sym.getSymbol("graphMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=10; i<14; i++){
         			txt[i] = sym.getSymbol("regionGraphMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[14] = sym.getSymbol("regionGraphMc").getSymbol("auxBtn").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	var searchtxt, constitArr=[], statusArr=[]; regionArr=[], txtArr=[], localWin=[], candArr=[], leanArr=[];
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gn+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			preelection = $(xml).find('preelection').text();//Oct27
         			stand = $(xml).find('standtxt').text();
         			standmob = $(xml).find('mobstandtxt').text();
         			votetxt = $(xml).find('votes').text();
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			demcolor=$(xml).find('demcolor').text();repcolor=$(xml).find('repcolor').text();indcolor=$(xml).find('indcolor').text();//Oct27
         			replcolor=$(xml).find('repleancolor').text();demlcolor=$(xml).find('demleancolor').text();indlcolor=$(xml).find('indleancolor').text();//Oct27
         			source = $(xml).find('source').text();
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source);
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css({"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"});
         			// MENU TEXT START
         			for (var i=0; i<menuBtnCount; i++){
         				menuArr[i]=$(xml).find('menu'+i).text();
         			}
         			menuTxt.html(menuArr[0]);
         			 // MENU TEXT END
         			for(var i=0;i<txt.length;i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         			}
         			searchtxt=$(xml).find('searchtxt').text();
         			sym.getSymbol("keyMc").$("txt2").html(txtArr[4]);sym.getSymbol("keyMc").$("txt3").html(txtArr[3]);
         			var constits=$(xml).find('constituencies').text(); constitArr=constits.split(';');
         			var statustxt=$(xml).find('status').text(); statusArr=statustxt.split(';');
         			var candidates=$(xml).find('candidatesShort').text(); candArr=candidates.split(';');
         			var leaning=$(xml).find('leaning').text(); leanArr=leaning.split(';');
         			sym.getSymbol("keyMc").$("leandtxt").html(leanArr[0]);sym.getSymbol("keyMc").$("leanrtxt").html(leanArr[1]);
         			var constitJSON=[];
         			var htmlTable="<div class='localTable'>";
         			for (var c=0;c<constitArr.length;c++){	
         				htmlTable+="<div id='c"+c+"' class='constit'><table class='localTable'><tr><td class='name'>"+constitArr[c]+"</td><td><div class='blob' id='col"+c+"'></div></td></tr></table></div>"
         				constitJSON[c]={ value: constitArr[c], data: 'c'+c };
         			}
         			htmlTable+="</div>";		
         			sym.getSymbol("listMc").$("constituencies").append(htmlTable);
         			sym.getSymbol("listMc").$("constituencies").css({'overflow-y':'auto'});
         			sym.$(".localTable").css({'width':'100%'});
         			$('.name').css({'width':'90%'});
         			$('.constit').css({'font-family':'pragmatica-web, sans-serif','font-size':'13px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','width':'100%'});
         			$('.col').css({'width':'5%'});
         			$('.blob').css({'height':'16px','width':'16px','border-radius':'8px','background-color':'rgb(200,200,200)','right':'5px','vertical-align':'middle'});
         			//AUTO-COMPLETE
         			var acDiv="<input type='text' name='constituency' placeholder='"+searchtxt+"' id='autocomplete' style='width:98%;font-size:14px;font-family:pragmatica-web,sans-serif;border:solid 1px rgb(150,150,150)'>";
         			sym.getSymbol("listMc").$("autocomp").append(acDiv);
         			sym.getSymbol("listMc").$("autocomp").css({'padding':0});
         			$("#autocomplete").css({'margin':0});
         			$('#autocomplete').autocomplete({
         				lookup: constitJSON,
         				onSelect: function (suggestion) {
         					for (var i=1;i<constits.length+1;i++){
         						$('#c'+i).css({'background-color':'rgba(255,200,150,0)'});
         					}
         					sym.getSymbol("listMc").$('constituencies').animate({scrollTop:$('#c0').position().top}, 0,
         							function(){sym.getSymbol("listMc").$('constituencies').animate({scrollTop:$('#'+suggestion.data).position().top}, 200);
         					});
         					$('#'+suggestion.data).css({'background-color':'rgba(255,200,150,0.3)'});
         				}
         			});
         			$(".autocomplete-suggestions").css({'padding-left':'2px', 'font-family':'pragmatica-web, sans-serif', 'font-size':'13px','color':'rgb(50,75,150)', 'background-color':'rgb(255,255,255)', 'box-shadow':'3px 3px 3px rgba(150,150,150,0.5)',
         			'max-height':'140px','overflow':'hidden'});
         			$(".autocomplete-suggestion").css({});
         			$(".autocomplete-selected").css({});
         			$(".autocomplete-group").css({});
         			$(".autocomplete-group strong").css({});
         		},
         		complete:function(){
         			buildMap();//Nov3
         			initSize();
         	   }
         	});
         	//********************************************************************************************************
         	// INIT SIZE
         	//********************************************************************************************************
         	function initSize(){
         		var stageWidth=sym.$("Stage").width();
         			sym.stop(stageWidth*10);
         		stageWidth<640?(sym.$("standTxt").html(standmob),$(".party").fadeOut(0),sym.$("voteTxt").css({'top':'170px'})):
         							(sym.$("standTxt").html(stand),$(".party").fadeIn(0),sym.$("voteTxt").css({'top':'145px'}));
         		if(stageWidth<480){
         			mob = 1;
         			headlinemob=(status==0)?preelection:headlinemob;//Oct27
         			headlinetxt.html(headlinemob);
         			sym.$("menuBtnsMc").fadeOut(0);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         			sym.$("standTxt").css({'font-size':'14px'});
         			sym.$("barchart").css({'width':'98%'});
         			sym.$("graphMc").css({'width':'100%'}); $(".candidates").css({'margin':'0px 15px'});
         			sym.$("listMc").css({'width':'100%'});sym.$("graphMc").css({'width':'100%'});sym.$("regionGraphMc").css({'width':'100%'});
         			sym.$("voteTxt").fadeOut(0); sym.$("txt15").fadeOut(0); sym.getSymbol("regionGraphMc").$("votenoTxt").fadeIn(0);
         				if(local==1){
         					sym.$("regionGraphMc").fadeIn(0);
         				}
         				sym.$("graphMc").fadeIn(0);
         				status==0?sym.$("keyMc").css({'left':'auto','right':'0px','top':'320px'}):sym.$("keyMc").css({'left':'6px','right':'auto','top':'540px'});//Nov1
         		}else{
         			mob = 0;
         			headline=(status==0)?preelection:headline;//Oct27
         			headlinetxt.html(headline);
         			sym.$("menuBtnsMc").fadeIn(0);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         			sym.$("standTxt").css({'font-size':'15px'});
         			sym.$("barchart").css({'width':stageWidth-166+"px"});
         			sym.$("graphMc").css({'width':'200px'}); $(".candidates").css({'margin':'0px'});
         			sym.$("listMc").css({'width':'192px'});sym.$("graphMc").css({'width':'192px'});sym.$("regionGraphMc").css({'width':'192px'});
         			sym.$("txt15").fadeIn(0); sym.getSymbol("regionGraphMc").$("votenoTxt").fadeOut(0);
         			if(local==1){
         				sym.$("regionGraphMc").fadeIn(0);
         				sym.$("voteTxt").fadeIn(0); 
         			}else{
         				sym.$("regionGraphMc").fadeOut(0);
         				sym.$("voteTxt").fadeOut(0);
         			}
         			status==0?(sym.$("graphMc").fadeOut(0),sym.$("keyMc").css({'left':'75.5%','right':'auto','top':'500px'})):(sym.$("keyMc").css({'left':'6px','right':'auto','top':'540px'}));//Oct27
         		}
         		showsearch=0;
         		var graphWidth=sym.$("graphMc").width();
         		sym.getSymbol("graphMc").$("graph").css({'left':(graphWidth-130)/2+'px'});
         		sym.getSymbol("regionGraphMc").$("graph").css({'left':(graphWidth-130)/2+'px'});
         		setStyle();
         		var voteWidth= sym.$("voteTxt").width(); sym.$("voteTxt").css({'left':(stageWidth-voteWidth)/2+'px'});
         	}
         	//********************************************************************************************************
         	// MENU BUTTONS
         	//********************************************************************************************************
         	menuArray = [];//the array that will hold references to the buttons.
         	for (var h=0; h<menuBtnCount; h++){
         		menuArray.push(h);
         	}
         	function resetmenu(){
         		for (var h=0; h<menuArray.length; h++){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(white);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		}
         	}
         	resetmenu(); sym.$("propMc").css({'top':'-600px'});
         	// MENU CLICK
         	var menuBtnClick = function(menuNo){ //to handle lexical scope
         		return function (e) {
         			e.preventDefault(); e.stopPropagation();
         			clicked = menuNo;
         			resetmenu();
         			var mapArr=['mapMc','propMc'];
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(black);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").html(menuArr[menuNo]);
         			for (var i=0;i<2;i++){
         				menuNo==i?sym.$(mapArr[menuNo]).css({'top':'0px'}):sym.$(mapArr[i]).css({'top':'-600px'});
         			}
         			if(mob==1){
         			}
         			initSize();
         		};
         	};
         	for (var b=0;b<menuArray.length;b++){
         		sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         		sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         	}
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(black);
         	function showSearch(){
         	 showsearch=(showsearch==0)?($(".search").stop().animate({'right':'0px'},200,'easeInQuad'),sym.$("searchBtn").stop().animate({'right':'0px'},200,'easeInQuad'),sym.$("txt15").fadeOut(200),1):
         										($(".search").stop().animate({'right':'-200px'},200,'easeInQuad'),sym.$("searchBtn").stop().animate({'right':'-200px'},200,'easeInQuad'),sym.$("txt15").fadeIn(200),0);
         	}
         	sym.$("searchBtn").on('click',showSearch);sym.$("searchBtn").css({'cursor':'pointer'});
         	
         	//********************************************************************************************************
         	// SET STYLE  
         	function setStyle(){
         		var stageWidth=sym.$("Stage").width();
         		$(".key").css({'padding':'1px 10px 1px','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto','height':'15px'});
         		//$(".dem").css({'background-color':'#3490ce'});$(".rep").css({'background-color':'#e94a31'});$(".leand").css({'background-color':'#8dbeeb'});$(".leanr").css({'background-color':'#feb6ad'});
         		$(".dem").css({'background-color':demcolor});$(".rep").css({'background-color':repcolor});$(".leand").css({'background-color':demlcolor});$(".leanr").css({'background-color':replcolor});//Oct27
         		$(".regiontxt").css({'padding':'1px 10px 3px','background-color':'#009640','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto'});
         		sym.getSymbol("searchBtn").$("btn").css({'border-right':'solid 1px rgb(255,255,255)'});
         		sym.getSymbol("barchart").$("marker").css({'border-right':'dotted 2px rgba(0,0,0,1)'});
         		sym.$("voteTxt").css({'width':'auto','height':'auto','padding':'4px 6px','background-color':'rgba(0,0,0,0.5)','border-radius':'10px','margin':'0 auto'});
         		$(".winner").css({'font-size':'90%','font-style':'oblique'});
         	}
         	setStyle();
         	//********************************************************************************************************
         	// SOURCE BUTTON
         	sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         		if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		}else{
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		}
         	}); 
         	sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         	});
         	sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         	});
         	//********************************************************************************************************
         	function partyColors(){//Oct27
         	$(".dem").css({'background-color':demcolor}); $(".deml").css({'background-color':demlcolor});
         	$(".rep").css({'background-color':repcolor}); $(".repl").css({'background-color':replcolor});
         	$(".ind").css({'background-color':indcolor}); $(".indl").css({'background-color':indlcolor});
         	}
         	//********************************************************************************************************
         	//BUILD PIE CHART
         	//PIE CHART
         	function pieChart(hwins,awins,other,draw,placeHolder){			
         	     var canvasWidth = 130, //width
         	      canvasHeight = 130,   //height
         	      outerRadius = 65,   //radius
         	      //color = d3.scale.category20(); //builtin range of colors
         			color = d3.scale.ordinal().range([repcolor,indcolor,"#c0cbc6",demcolor]);
         	    var dataSet = [
         	      {"legendLabel":"Rep", "magnitude":awins},  
         	      {"legendLabel":"Ind", "magnitude":other},
         	      {"legendLabel":"Undec", "magnitude":draw},  
         	      {"legendLabel":"Dem", "magnitude":hwins}];
         	    var vis = d3.select(placeHolder)
         	      .append("svg:svg") //create the SVG element inside the <body>
         	        .data([dataSet]) //associate our data with the document
         	        .attr("width", canvasWidth) //set the width of the canvas
         	        .attr("height", canvasHeight) //set the height of the canvas
         	        .append("svg:g") //make a group to hold our pie chart
         				.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         				//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
         				.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
         	    // This will create <path> elements for us using arc data...
         	    var arc = d3.svg.arc()
         	      .outerRadius(outerRadius)
         			.innerRadius(outerRadius-30); //donut chart
         	    var pie = d3.layout.pie() //this will create arc data for us given a list of values
         	      .value(function(d) { return d.magnitude; }) // Binding each value to the pie
         	      .sort( function(d) { return null; } );
         	    // Select all <g> elements with class slice (there aren't any yet)
         	    var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
         	      .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
         	      .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
         	      .append("svg:g")
         	      .attr("class", "slice");    //allow us to style things in the slices (like text)
         	    arcs.append("svg:path")
         	      //set the color for each slice to be chosen from the color function defined above
         	      .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
         	      .attr("d", arc);
         	}
         	//SELECT STATE
         	//var conWidth, conHeight, conX, conY;
         	var selectName = function(number,svgDocument){ //to handle lexical scope
         	         	return function (e) {
         	         		for (var n=0;n<constitArr.length;n++){
         	         			if (number==n){
         	         				targetCon=number+1;
         	         				$("#"+(stateArr[number]), svgDocument).animate({'opacity':1.0},0);
         								showState(number);
         	         			}else{
         	         				$("#"+(stateArr[n]), svgDocument).animate({opacity:0.6},300);
         	         				$("#c"+n).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         	         			}
         	         		}
         	         	//targetParty="all";
         	         	e.preventDefault();
         	         	e.stopPropagation();
         	         	};
         	         };
         	function showState(num){
         				local=1;
         				sym.getSymbol("regionGraphMc").$("graph").empty();
         				var placeHolder="#Stage_regionGraphMc_graph";
         				$("#c"+num).css({'background-color':'rgba(255,200,150,0.3)','font-weight':700});
         				var tableScroll=sym.getSymbol("listMc").$('constituencies').scrollTop();
         				sym.getSymbol("listMc").$('constituencies').stop().animate({ scrollTop: tableScroll+$('#c'+num).position().top }, 200);
         				txt[10].html(candArr[0]+"<br><b>"+Math.round(regDemPc[num])+"%</b>");//dem
         				txt[11].html(candArr[1]+"<br><b>"+Math.round(regRepPc[num])+"%</b>");//rep
         				txt[12].html(candArr[2]+" <b>"+Math.round(regIndPc[num])+"%</b>");//ind
         				txt[13].html(constitArr[num]);
         				var winner=(status==0)?4:(regWin[num]=="dem")?0:(regWin[num]=="rep")?1:(regWin[num]=="other")?2:3;
         				sym.$("voteTxt").html("<b>"+constitArr[num]+": "+evArr[num]+"</b><br><span class='winner'>"+candArr[winner])+"</span>" ; sym.$("voteTxt").fadeIn(0);
         				sym.getSymbol("regionGraphMc").$("votenoTxt").html(evArr[num]);
         				var undec=(regDemPc[num]==0&&regRepPc[num]==0&&regIndPc[num]==0)?100:0;
         				pieChart(regDemPc[num],regRepPc[num],regIndPc[num],undec,placeHolder);
         				sym.$("regionGraphMc").fadeIn(0); initSize();
         	}
         	//LIVE TOTAL
         	function getSum(){
         		//getDate();
         		$.ajax({ type: "GET", 
         					url: dataURL,
         	            data: "gn="+gn+"&q=sum&yr=2016",
         	            contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	            async: true,
         	            crossDomain: true,
         	            success: function (data) {         
         						var voteCount = data;
         						var placeHolder="#Stage_graphMc_graph";
         						if(voteCount.length>0){
         							sym.getSymbol("graphMc").$("graph").empty();
         							var demNo = voteCount[0].DemECvotes; var demTot = voteCount[0].DemTotal; var demStates = Number(voteCount[0].DemStates); var demLean = Number(voteCount[0].DemLean);
         							var repNo = voteCount[0].RepECvotes; var repTot = voteCount[0].RepTotal; var repStates = Number(voteCount[0].RepStates); var repLean = Number(voteCount[0].RepLean);
         							var IndNo = voteCount[0].IndECvotes; var indTot = voteCount[0].IndTotal; var indStates = voteCount[0].IndStates;
         							var statesCounted= voteCount[0].StatesCounted;
         							var timeStamp = voteCount[0].Time;
         							demLean>0?sym.getSymbol("barchart").$("demLTxt").fadeIn(0):sym.getSymbol("barchart").$("demLTxt").fadeOut(0);
         							repLean>0?sym.getSymbol("barchart").$("repLTxt").fadeIn(0):sym.getSymbol("barchart").$("repLTxt").fadeOut(0);
         							undeclared=(demStates>0||repStates>0||indStates>0)?51-(demStates+repStates+indStates):51;
         							pieChart(demStates,repStates,indStates,undeclared,placeHolder);
         							txt[6].html(candArr[1]+"<br><b>"+(repStates>0?repStates:"0")+"</b>");
         							txt[7].html(candArr[0]+"<br><b>"+(demStates>0?demStates:"0")+"</b>");
         							txt[8].html(indStates>0?candArr[2]+" <b>"+indStates+"</b>":"");
         							txt[9].html(undeclared>0?candArr[3]+" <b>"+undeclared+"</b>":"");
         							sym.getSymbol("barchart").$("dembar").stop(0).animate({'width':demNo/538*100+'%'},400,'easeOutQuad');
         							sym.getSymbol("barchart").$("demlbar").stop(0).animate({'left':demNo/538*100+'%'},400,'easeOutQuad', function(){ sym.getSymbol("barchart").$("demlbar").animate({'width':demLean/538*100+'%'},400,'easeOutQuad')});
         							sym.getSymbol("barchart").$("demLTxt").delay(400).animate({'left':1+(demNo/538*100)+'%'},400,'easeOutQuad');
         							sym.getSymbol("barchart").$("repbar").stop(0).animate({'width':repNo/538*100+'%'},400,'easeOutQuad');
         							sym.getSymbol("barchart").$("replbar").stop(0).animate({'right':repNo/538*100+'%'},400,'easeOutQuad', function(){ sym.getSymbol("barchart").$("replbar").animate({'width':repLean/538*100+'%'},400,'easeOutQuad')});
         							sym.getSymbol("barchart").$("repLTxt").delay(400).animate({'right':1+(repNo/538*100)+'%'},400,'easeOutQuad');
         							sym.getSymbol("barchart").$("demNoTxt").html(demNo); sym.getSymbol("barchart").$("repNoTxt").html(repNo);
         							sym.getSymbol("barchart").$("demLTxt").html(demLean); sym.getSymbol("barchart").$("repLTxt").html(repLean);
         						}
         					}
         		});
         		setTimeout(function(){getSum()}, 60000);
         	}
         	getSum();
         	
         	
         	//********************************************************************************************************
         	//BUILD SVG MAP
         	var stateArr=["AL","AK","AZ","AR","CA","CO","CT","DE","DC","FL","GA","HI","ID","IL","IN","IA","KS","KY","LA","ME","MD","MA","MI","MN","MS","MO","MT","NE","NV","NH","NJ","NM","NY","NC","ND","OH","OK","OR","PA","RI","SC","SD","TN","TX","UT","VT","VA","WA","WV","WI","WY"];
         	var regName=[], regWin=[], regDemNo=[], regRepNo=[], regIndNo=[]; regDemPc=[], regRepPc=[], regIndPc=[], evArr=[], areasComplete=[], areasTotal=[]; 
         	function buildMap(){
         	EC.SVG.accessSVG(sym.getSymbol("mapMc").$("usmap")).done(
         		function(svgDocument){
         			//LIVE DATA
         			function getData(){
         				$.ajax({ type: "GET", 
         					url: dataURL,
         	            data: "gn="+gn+"&q=data&yr=2016",
         	            contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	            async: true,
         	            crossDomain: true,
         	            success: function (data) {         
         						var mapData = data;
         						if(mapData){
         							for (var i = 0; i < mapData.length; i++) {
         								var cno=mapData[i].index;//index=name of json attr e.g. uk1
         								regWin[i]=mapData[i].Winner;
         								$("#"+(stateArr[i]), svgDocument).attr({'class':regWin[i]});
         								$("#col"+i).attr('class','blob '+regWin[i]);
         								regDemNo[i]=mapData[i].DemNo; regRepNo[i]=mapData[i].RepNo; regIndNo[i]=mapData[i].IndNo;
         								regDemPc[i]= Number(mapData[i].DemPc); regRepPc[i]=Number(mapData[i].RepPc); regIndPc[i]=Number(mapData[i].IndPc);
         								evArr[i]= mapData[i].EV;
         							}
         						}
         						$(".dem", svgDocument).attr('style', "fill:"+demcolor); $(".rep", svgDocument).attr('style', "fill:"+repcolor);//Oct27
         						$(".deml", svgDocument).attr('style', "fill:"+demlcolor); $(".repl", svgDocument).attr('style', "fill:"+replcolor);//Oct27
         						$(".ind", svgDocument).attr('style', "fill:"+indcolor); $(".indl", svgDocument).attr('style', "fill:"+indlcolor);//Oct27
         					},
         					complete:function(){
         						//buildCarto();//Nov6
         						//partyColors();//Nov6
         						for (var i=0; i<constitArr.length; i++){//Nov6
         							if(targetCon>0){//Nov1
         									$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},100);//Nov6
         									if (i+1==targetCon){
         										$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},100);//Nov6
         										showState(i);
         									}
         							}
         						}
         					}
         				});
         				if(status==1){
         					setTimeout(function(){getData()}, 600000);
         				}else if(status==2&&todayDate<endDate+86400000){ 
         					setTimeout(function(){getData()}, 60000); 
         				}
         			}
         			getData();
         			buildCarto();//Nov6
         			partyColors();//Nov6
         			function clickConstit(event){
         				sym.setVariable("selectedPart", event.target);
         				var constitSelect = sym.getVariable("selectedPart");
         				for (var i=0; i<constitArr.length; i++){
         					if (event.target.id==stateArr[i]){
         							constitSelect.style.opacity=1.0;
         							var undec=(regDemPc[i]>0||regRepPc[i]>0)?0:1;
         							targetCon=i+1;
         							showState(i);
         					}else{
         						$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},300);
         						$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         					}
         				}
         			}
         			function clickTxt(event){//Nov1
         				sym.setVariable("selectedPart", event.target);
         				var txtSelect = sym.getVariable("selectedPart");
         				for (var i=0; i<constitArr.length; i++){
         					if (event.target.id==stateArr[i]+"t"){
         							$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},300);
         							targetCon=i+1;
         							showState(i);
         					}else{
         						$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},300);
         						$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         					}
         				}
         			}
         			function overConstit(event){
         				sym.setVariable("overPart", event.target);
         				var constitOver = sym.getVariable("overPart");
         					if(targetCon!=stateArr.indexOf(event.target.id)+1){
         						if(targetCon<1){
         							constitOver.style.opacity=0.6;
         						}else{
         							constitOver.style.opacity=1.0;
         						}
         					}
         			}
         			function outConstit(event){
         				sym.setVariable("outPart", event.target);
         				var constitOut = sym.getVariable("outPart");
         							if(targetCon!=stateArr.indexOf(event.target.id)+1){
         								if(targetCon<1){
         									constitOut.style.opacity=1.0;
         								}else{
         									constitOut.style.opacity=0.6;
         								}
         							}
         			}
         			//SHOW CONSTITUENCY
         			for (var i=0;i<constitArr.length;i++){
         				$("#c"+i).on("click",selectName(i,svgDocument));
         				$('#c'+i).css({'cursor':'pointer'});
         				$('#'+stateArr[i], svgDocument).css({'cursor':'pointer'});$('#'+stateArr[i]+"t", svgDocument).css({'cursor':'pointer'});//Nov1
         				$("#"+stateArr[i], svgDocument).on("click",clickConstit);
         				$("#"+stateArr[i]+"t", svgDocument).on("click",clickTxt);//Nov1
         				$("#"+stateArr[i], svgDocument).on("mouseover",overConstit);
         				$("#"+stateArr[i], svgDocument).on("mouseout",outConstit);
         			}
         			sym.getSymbol("regionGraphMc").$("auxBtn").on('click', function(){
         				targetCon=0; local=0;
         				sym.$("regionGraphMc").fadeOut(300);sym.$("voteTxt").fadeOut(300);
         				for (var i=0; i<constitArr.length; i++){
         					$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},300);
         				}
         			});
         	
         	});
         	
         			//if(status==1){
         			//	setTimeout(function(){buildMap()}, 600000);
         			//	}else if(status==2&&todayDate<endDate+86400000){ 
         			//		setTimeout(function(){buildMap()}, 60000); 
         			//	}
         	}
         	//BUILD SVG CARTOGRAM
         	function buildCarto(){
         	EC.SVG.accessSVG(sym.getSymbol("propMc").$("uscarto")).done(
         		function(svgDocument){
         			function getProportional(){
         				for(var i=0;i<constitArr.length;i++){
         					$("#"+(stateArr[i]), svgDocument).attr({'class':regWin[i]});
         					if(targetCon>0){//Nov6
         						$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},100);
         						if (i+1==targetCon){
         							$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},100);
         							showState(i);
         						}
         					}
         				}
         				$(".dem", svgDocument).attr('style', "fill:"+demcolor); $(".rep", svgDocument).attr('style', "fill:"+repcolor);//Oct27
         				$(".deml", svgDocument).attr('style', "fill:"+demlcolor); $(".repl", svgDocument).attr('style', "fill:"+replcolor);//Oct27
         				$(".ind", svgDocument).attr('style', "fill:"+indcolor); $(".indl", svgDocument).attr('style', "fill:"+indlcolor);//Oct27
         				/*			
         				if(targetCon>0){//Nov1
         					for (var i=0; i<stateArr.length; i++){
         						if (i+1==targetCon){//Nov6
         							$("#"+(stateArr[i]), svgDocument).style.opacity=1.0;
         							showState(i);
         						}else{
         							$("#"+(stateArr[i]), svgDocument).style.opacity=0.6;
         						}
         					}
         				}
         				*/
         			setTimeout(function(){getProportional()}, 30000);//outNov3//inNov6
         			}
         		setTimeout(function(){getProportional()}, 2500);//outNov3//inNov6
         		getProportional();//Nov3
         			function clickConstit(event){
         				sym.setVariable("selectedPart", event.target);
         				var constitSelect = sym.getVariable("selectedPart");
         				for (var i=0; i<constitArr.length; i++){
         					if (event.target.id==stateArr[i]){
         							constitSelect.style.opacity=1.0;
         							var undec=(regDemPc[i]>0||regRepPc[i]>0)?0:1;
         							targetCon=i+1;
         							showState(i);
         					}else{
         						$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},300);
         						$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         					}
         				}
         			}
         			function clickTxt(event){//Nov1
         				sym.setVariable("selectedPart", event.target);
         				var txtSelect = sym.getVariable("selectedPart");
         				for (var i=0; i<constitArr.length; i++){
         					if (event.target.id==stateArr[i]+"t"){
         							$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},300);
         							targetCon=i+1;
         							showState(i);
         					}else{
         						$("#"+(stateArr[i]), svgDocument).animate({opacity:0.6},300);
         						$("#c"+i).css({'background-color':'rgba(255,200,150,0)','font-weight':400});
         					}
         				}
         			}
         			function overConstit(event){
         				sym.setVariable("overPart", event.target);
         				var constitOver = sym.getVariable("overPart");
         					if(targetCon!=stateArr.indexOf(event.target.id)+1){
         						if(targetCon<1){
         							constitOver.style.opacity=0.6;
         						}else{
         							constitOver.style.opacity=1.0;
         						}
         					}
         			}
         			function outConstit(event){
         				sym.setVariable("outPart", event.target);
         				var constitOut = sym.getVariable("outPart");
         							if(targetCon!=stateArr.indexOf(event.target.id)+1){
         								if(targetCon<1){
         									constitOut.style.opacity=1.0;
         								}else{
         									constitOut.style.opacity=0.6;
         								}
         							}
         			}
         			for (var i=0;i<constitArr.length;i++){
         				$('#'+stateArr[i], svgDocument).css({'cursor':'pointer'});$('#'+stateArr[i]+"t", svgDocument).css({'cursor':'pointer'});//Nov1
         				$("#"+stateArr[i], svgDocument).on("click",clickConstit);
         				$("#"+stateArr[i]+"t", svgDocument).on("click",clickTxt);//Nov1
         				$("#"+stateArr[i], svgDocument).on("mouseover",overConstit);
         				$("#"+stateArr[i], svgDocument).on("mouseout",outConstit);
         			}
         			//SHOW CONSTITUENCY
         			for (var i=0;i<constitArr.length;i++){
         					$("#c"+i).on("click",selectName(i,svgDocument));
         			}
         			sym.getSymbol("regionGraphMc").$("auxBtn").on('click', function(){
         				targetCon=0; local=0;
         				sym.$("regionGraphMc").fadeOut(300);sym.$("voteTxt").fadeOut(300);
         				for (var i=0; i<constitArr.length; i++){
         					$("#"+(stateArr[i]), svgDocument).animate({opacity:1.0},300);
         				}
         			});
         	
         		});
         	}
         	//buildMap();
         	//********************************************************************************************************
         	$(window).on('resize',initSize);
         	initSize();
         	//********************************************************************************************************
         	//-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'MapMc'
   (function(symbolName) {   
   
   })("MapMc");
   //Edge symbol end:'MapMc'

   //=========================================================
   
   //Edge symbol: 'GraphMc'
   (function(symbolName) {   
   
   })("GraphMc");
   //Edge symbol end:'GraphMc'

   //=========================================================
   
   //Edge symbol: 'RegionGraphMc'
   (function(symbolName) {   
   
   })("RegionGraphMc");
   //Edge symbol end:'RegionGraphMc'

   //=========================================================
   
   //Edge symbol: 'AuxBtn'
   (function(symbolName) {   
   
   })("AuxBtn");
   //Edge symbol end:'AuxBtn'

   //=========================================================
   
   //Edge symbol: 'KeyMc'
   (function(symbolName) {   
   
   })("KeyMc");
   //Edge symbol end:'KeyMc'

   //=========================================================
   
   //Edge symbol: 'propMc'
   (function(symbolName) {   
   
   })("propMc");
   //Edge symbol end:'propMc'

   //=========================================================
   
   //Edge symbol: 'barchartMc'
   (function(symbolName) {   
   
   })("Barchart");
   //Edge symbol end:'Barchart'

   //=========================================================
   
   //Edge symbol: 'SearchBtnMc'
   (function(symbolName) {   
   
   })("SearchBtnMc");
   //Edge symbol end:'SearchBtnMc'

   //=========================================================
   
   //Edge symbol: 'ListMc'
   (function(symbolName) {   
   
   })("ListMc");
   //Edge symbol end:'ListMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34691");