/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"white",  "border-color":"white", 
         	"background-color":"black", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt1").css(txtBox);
         	txt[2] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css(txtBox);
         	
         	for (var i=3;i<9; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none", "background-color":"#e5e5e5"});
         	}
         	txt[9] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt9").css({"pointer-events":"none"});
         	for (var i=10;i<13; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none", "background-color":"#e5e5e5"});
         	}
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	for (var i=14;i<22; i++){
         		txt[i] = sym.getSymbol("profileMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol('tableMc').$("txt25").css({"pointer-events":"none"});
         	
         	var txtArr=[], winner=[], winnerEvents=[]
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34659.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<26; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			$(xml).find("winnerTable").each(function(){
         				var $winner=$(this);
         				winnerEvents.push($winner);
         			});
         			addWinnerTable();
         	
         			sym.$("txt24").text("50" + " " + (txtArr[24]));
         			sym.$("txt0").css({'font-size':'16px'});
         			sym.getSymbol('tableMc').$("txt25").css({'font-size':'22px'});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         var win=[]
         function addWinnerTable() {
         		var $events=winnerEvents[0].find('winner');
         		sym.getSymbol('tableMc').$("table").empty();
         		var i=0;
         		var tableTxt="<table id='wintable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			if($event.attr('number')==0){//only get the event that matches 
         				var $win=$event.find("win");
         				$win.each(function(){
         					var $win=$(this);
         					var year=$win.find("year").text();
         					var name=$win.find("name").text();
         					var country=$win.find("country").text();
         					var time=$win.find("time").text();
         					if (RTL == true){
         						tableTxt+="<tr id='"+"winner"+i+"' class='"+"winner'>";
         						tableTxt+="<td id='"+"timeId"+i+"' class='"+"timeCl'>"+time+"</td>";
         						tableTxt+="<td id='"+"countryId"+i+"' class='"+"countryCl'>"+country+"</td>";
         						tableTxt+="<td id='"+"nameId"+i+"' class='"+"nameCl'>"+name+"</td>";
         						tableTxt+="<td id='"+"yearId"+i+"' class='"+"yearCl'>"+year+"</td>";
         					} else {
         						tableTxt+="<tr id='"+"winner"+i+"' class='"+"winner'>";
         						tableTxt+="<td id='"+"yearId"+i+"' class='"+"yearCl'>"+year+"</td>";
         						tableTxt+="<td id='"+"nameId"+i+"' class='"+"nameCl'>"+name+"</td>";
         						tableTxt+="<td id='"+"countryId"+i+"' class='"+"countryCl'>"+country+"</td>";
         						tableTxt+="<td id='"+"timeId"+i+"' class='"+"timeCl'>"+time+"</td>";
         					}
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		sym.getSymbol('tableMc').$("table").append(tableTxt); //Then attach the buttons:
         		$("#wintable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse', 'width':'100%'});
         		$("#wintable tr:odd").css({"background-color":"#efefef",'border-color':"rgb(255,255,255)","border-width":"2px ","border-style":"solid"});
         		$("#wintable tr:even").css({"background-color":"#fff",'border-color':"rgb(255,255,255)","border-width":"2px ","border-style":"solid"});
         		$("#wintable tr:first-child").css({"background-color":"#ffffff"});
         
         		$(".winner").css({'height':'30px', "vertical-align":"top"});
         		$(".yearCl").css({'width':'5%', "font-weight":"regular", 'padding-left':'5px', 'padding-right':'0px', 'text-align':'left', 'padding-top':'5px'});
         		$(".nameCl").css({'width':'80%', "font-weight":"bold", "color":"#000", 'text-align':'left', 'padding-top':'5px'});
         		$(".countryCl").css({'width':'10%', "font-style":"italic", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'left', 'padding-top':'5px'});
         		$(".timeCl").css({'width':'5%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'right', 'padding-top':'5px'});
         		if (RTL == true){
         			$(".winner").css({'height':'30px', "vertical-align":"top"});
         			$(".yearCl").css({'width':'5%', "font-weight":"regular", 'padding-left':'5px', 'padding-right':'5px', 'text-align':'right', 'padding-top':'5px'});
         			$(".nameCl").css({'width':'50%', "font-weight":"bold", "color":"#000", 'text-align':'right', 'padding-top':'5px'});
         			$(".countryCl").css({'width':'20%', "font-style":"italic", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'right', 'padding-top':'5px'});
         			$(".timeCl").css({'width':'20%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'left', 'padding-top':'5px'});
         			sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         			sym.getSymbol("tableMc").$("txt25").css({"text-align":"right"});
         			sym.$("txt0").css({"text-align":"center"});
         		}
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		start();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		sym.getSymbol("profileMc").play();
         	}else{
         		stop();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		sym.getSymbol("profileMc").stop();
         	}
         }); 
         
         var timer = 0;
         function start(){
         	timer = setInterval(function(){
         		var stageWidth=sym.$("Stage").width();
         		sym.$("mask").fadeIn(0);
         		var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         		sym.getSymbol("controlsMc").$("km").text((pos / 367.3).toFixed(1) + " " + (txtArr[23]));
         		sym.getSymbol("controlsMc").$("miles").text((pos / 591.6).toFixed(1) + " " + (txtArr[22]));
         		var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("racer").position();
         		sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 100);
         		if (pos == 0 || pos == 15500) {
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         			stop();
         		}
         	},150);
         }
         function stop() {
             clearInterval(timer);
             sym.$("mask").fadeOut(0);
         }
         start();
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("controlsMc").fadeIn(0);
         	//SCROLL START
         	sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	//SCROLL END
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	setStyle();
         
         	if(stageWidth<778){
         		sym.$("standBtn").animate({top:40, left:stageWidth-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); //SCROLL CODE
         		sym.$("tableMc").stop().animate({left:stageWidth + 20, width:295}, 0);
         	}else{
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); //SCROLL CODE
         		sym.$("tableMc").stop().animate({left:stageWidth-(stageWidth-485), width:stageWidth-485}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("profileMc").$("profile320").fadeIn(0);
         		sym.getSymbol("profileMc").$("profileBg320").fadeIn(0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("profileMc").$("profile320").fadeOut(0);
         		sym.getSymbol("profileMc").$("profileBg320").fadeOut(0);
         	}
         	setStyleUpdate();
         	hideSource();
         }
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on(' mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on(' mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);
         	}
         
         });
         sym.$("scrollMc").on(' mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	hideSource();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("tableMc").stop().animate({left:stageWidth-295}, 200);
         		sym.$("standBtn").stop().animate({left:stageWidth-345}, 200);
         		hideControls();
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("tableMc").stop().animate({left:stageWidth+20}, 200);
         		sym.$("standBtn").stop().animate({left:stageWidth-50}, 180);
         		showControls();
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function hideControls() {
         	sym.$("controlsMc").fadeOut(0);
         	sym.$("playNext").fadeOut(0);
         	sym.$("playBack").fadeOut(0);
         }
         
         function showControls() {
         	sym.$("controlsMc").fadeIn(0);
         	sym.$("playNext").fadeIn(0);
         	sym.$("playBack").fadeIn(0);
         }
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		hideControls();
         	}else{
         		hideSource();
         	}
         }); 
         function hideSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	showControls();
         }
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7780, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'courseContMc'
   (function(symbolName) {   
   
   })("courseContMc");
   //Edge symbol end:'courseContMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'prifileMc'
   (function(symbolName) {   
   
   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews34659");