/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var tab0 = sym.getSymbol("table").getSymbol("tab0");
         	var tab1 = sym.getSymbol("table").getSymbol("tab1");
         	var tab2 = sym.getSymbol("table").getSymbol("tab2");
         	var tab3 = sym.getSymbol("table").getSymbol("tab3");
         	var tab4 = sym.getSymbol("table").getSymbol("tab4");
         	var tab5 = sym.getSymbol("table").getSymbol("tab5");
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("table").$("standTxt").css({"pointer-events":"none", "background-color":"white", "padding":"5px", "height":"auto"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = tab0.$("txt0").css({"pointer-events":"none", "height":"auto"});
         	txt[1] = tab0.$("txt1").css({"pointer-events":"none", "height":"auto"});
         	txt[2] = tab1.$("txt2").css({"pointer-events":"none", "height":"auto"});
         	txt[3] = tab2.$("txt3").css({"pointer-events":"none", "height":"auto"});
         	txt[4] = tab3.$("txt4").css({"pointer-events":"none", "height":"auto"});
         	txt[5] = tab4.$("txt5").css({"pointer-events":"none", "height":"auto"});
         	txt[6] = tab5.$("txt6").css({"pointer-events":"none", "height":"auto"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34643.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<7; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         				if (RTL == true){
         					txt[i].css({'text-align':'right'});
         				}
         			}
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var table = sym.getSymbol("table");
         	var stand = sym.getSymbol("table").$("standTxt");
         	var standH = sym.getSymbol("table").$("standTxt").height();
         	console.log(tab0.$("no").height()+tab0.$("txt1").height()+260);
         	stageWidth=sym.$("Stage").width();
         	table.$("standTxt").css({"width":stageWidth-30+"px"});
         //********************************************************************************************************
         	tab0.$("txt0").css({"width":stageWidth-60+"px"});
         	tab0.$("headsMc").css({"top":tab0.$("txt0").height()+40+"px", 'left':stageWidth/2-240+'px'});
         	tab0.$("headLeft").css({"top":tab0.$("txt0").height()+20+"px"});
         	tab0.$("headRight").css({"top":tab0.$("txt0").height()+20+"px", "left":stageWidth-100+'px'});
         	tab0.$("logoLeft").css({"top":tab0.$("txt0").height()+240+"px"});
         	tab0.$("logoRight").css({"top":tab0.$("txt0").height()+190+"px", "left":stageWidth-80+'px'});
         	tab0.$("txt1").css({"width":stageWidth-120+"px", "top":tab0.$("txt0").height()+250+"px"});
         	var firstH=(tab0.$("txt0").height()>tab0.$("no").height())?tab0.$("txt0").height():tab0.$("no").height();
         	table.$("tab0").css({'top':sym.getSymbol("table").$("standTxt").height()+20+'px', "height":firstH+tab0.$("txt1").height()+260+"px"});
         //********************************************************************************************************
         	tab1.$("txt2").css({"width":stageWidth-160+"px"});
         	tab1.$("badges").css({"left":stageWidth-114+"px"});
         	table.$("tab1").css({'top':(table.$("tab0").height() + standH) +20+"px", 'height':tab1.$("txt2").height()+20+'px'});
         //********************************************************************************************************
         	tab2.$("txt3").css({"width":stageWidth-150+"px"});
         	table.$("tab2").css({'top':(table.$("tab0").height() + table.$("tab1").height() + standH) +20+"px", 'height':tab2.$("txt3").height()+20+'px', 'min-height':'88px'});
         //********************************************************************************************************
         	tab3.$("txt4").css({"width":stageWidth-80+"px"});
         	table.$("tab3").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + standH) +20+"px", 'height':tab3.$("txt4").height()+15+'px'});
         //********************************************************************************************************
         	tab4.$("txt5").css({"width":stageWidth-185+"px"});
         	var conTop=table.$("tab4").height();
         	tab4.$("con").css({"left":stageWidth-140+"px","top":(conTop-140>0?conTop-140:0)+"px"});
         	table.$("tab4").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + table.$("tab3").height() + standH) +20+"px", 'height':tab4.$("txt5").height()+20+'px', 'min-height':'110px'});
         //********************************************************************************************************
         	tab5.$("txt6").css({"width":stageWidth-175+"px"});
         	//tab5.$("seal").css({"left":stageWidth-125+"px"});
         	table.$("tab5").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + table.$("tab3").height() + table.$("tab4").height() + standH) +20+"px", 'height':tab5.$("txt6").height()+20+'px', 'min-height':'100px'});
         //********************************************************************************************************
         
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		sym.getSymbol("table").$("standTxt").css({"text-align":"right"});
         		tab0.$("no").css({"left":stageWidth-50+"px"});
         		tab1.$("no").css({"left":stageWidth-50+"px"});
         		tab2.$("no").css({"left":stageWidth-50+"px"});
         		tab3.$("no").css({"left":stageWidth-50+"px"});
         		tab4.$("no").css({"left":stageWidth-50+"px"});
         		tab5.$("no").css({"left":stageWidth-50+"px"});
         		//********************************************************************************************************
         		tab0.$("txt0").css({"width":stageWidth-68+"px", "left":15+"px"});
         		tab0.$("txt1").css({"width":stageWidth-100+"px", "top":tab0.$("txt0").height()+250+"px"});
         		table.$("tab0").css({'top':sym.getSymbol("table").$("standTxt").height()+20+'px', "height":tab0.$("txt0").height()+tab0.$("txt1").height()+260+"px"});
         	//********************************************************************************************************
         		tab1.$("txt2").css({"width":stageWidth-160+"px", "left":105+"px"});
         		tab1.$("badges").css({"left":0+"px"});
         		table.$("tab1").css({'top':(table.$("tab0").height() + standH) +20+"px", 'height':tab1.$("txt2").height()+20+'px'});
         	//********************************************************************************************************
         		tab2.$("txt3").css({"width":stageWidth-164+"px"});
         		table.$("tab2").css({'top':(table.$("tab0").height() + table.$("tab1").height() + standH) +20+"px", 'height':tab2.$("txt3").height()+20+'px', 'min-height':'88px'});
         	//********************************************************************************************************
         		tab3.$("txt4").css({"width":stageWidth-95+"px"});
         		table.$("tab3").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + standH) +20+"px", 'height':tab3.$("txt4").height()+15+'px'});
         	//********************************************************************************************************
         		tab4.$("txt5").css({"width":stageWidth-175+"px"});
         		tab4.$("con").css({"left":stageWidth-125+"px"});
         		table.$("tab4").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + table.$("tab3").height() + standH) +20+"px", 'height':tab4.$("txt5").height()+20+'px', 'min-height':'110px'});
         	//********************************************************************************************************
         		tab5.$("txt6").css({"width":stageWidth-195+"px"});
         		table.$("tab5").css({'top':(table.$("tab0").height() + table.$("tab1").height() + table.$("tab2").height() + table.$("tab3").height() + table.$("tab4").height() + standH) +20+"px", 'height':tab5.$("txt6").height()+20+'px', 'min-height':'60px'});
         	//********************************************************************************************************
         	}
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         	closeSource();
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("table").css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         initSize();
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'table'
   (function(symbolName) {   
   
   })("table");
   //Edge symbol end:'table'

   //=========================================================
   
   //Edge symbol: 'tab0'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tab0");
   //Edge symbol end:'tab0'

   //=========================================================
   
   //Edge symbol: 'tab0_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tab1");
   //Edge symbol end:'tab1'

   //=========================================================
   
   //Edge symbol: 'headsMc'
   (function(symbolName) {   
   
   })("headsMc");
   //Edge symbol end:'headsMc'

   //=========================================================
   
   //Edge symbol: 'headLeft'
   (function(symbolName) {   
   
   })("headLeft");
   //Edge symbol end:'headLeft'

   //=========================================================
   
   //Edge symbol: 'headLeft_1'
   (function(symbolName) {   
   
   })("headRight");
   //Edge symbol end:'headRight'

   //=========================================================
   
   //Edge symbol: 'logoLeft'
   (function(symbolName) {   
   
   })("logoLeft");
   //Edge symbol end:'logoLeft'

   //=========================================================
   
   //Edge symbol: 'logoRight'
   (function(symbolName) {   
   
   })("logoRight");
   //Edge symbol end:'logoRight'

   //=========================================================
   
   //Edge symbol: 'tab0_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab3");
   //Edge symbol end:'tab3'

   //=========================================================
   
   //Edge symbol: 'badges'
   (function(symbolName) {   
   
   })("badges");
   //Edge symbol end:'badges'

   //=========================================================
   
   //Edge symbol: 'tab0_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
            //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
            //Edge binding end

         })("tab2");
   //Edge symbol end:'tab2'

   //=========================================================
   
   //Edge symbol: 'tab0_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
            //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
            //Edge binding end

         })("tab5");
   //Edge symbol end:'tab5'

   //=========================================================
   
   //Edge symbol: 'tab0_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
            //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
            //Edge binding end

         })("tab4");
   //Edge symbol end:'tab4'

   //=========================================================
   
   //Edge symbol: 'con'
   (function(symbolName) {   
   
   })("con");
   //Edge symbol end:'con'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34643");