/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	
         	var mob = 0;
         	var mobOpen = false;
         	var btnNo = 0;
         	var speed = 0;
         	var navMove = 0;
         	var clicked = 0;
         	var clickedCard = 0;
         	var clickedAux = 0;
         	var clickedDot = 0;
         	var coursePath = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc");
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         for (var a=0; a<18; a++){
         	coursePath.getSymbol("roundBtn"+a).$("txt").html(a+1);
         	coursePath.getSymbol("roundBtn"+a).$("txt").css({"pointer-events":"none"});
         }
         
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = '#bfbfbf';
         	var red = '#da0000';
         	var paleRed = '#fde4e3';
         	var blue = '#5481c1';
         	var paleBlue  = '#e2eefa';
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	var green = '#a6b194';
         	var darkGreen = '#516653';
         
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[3] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[4] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[5] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // ADD HOLE IMAGES
         //********************************************************************************************************
         holesArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 18; i++){
         	var holeObject = sym.getSymbol("holesMc").createChildSymbol("holeMc", "holesHolderMc");  // Create an instance element of a symbol as a child of the given parent element
         	holeObject.setVariable("id", i);  //set the value of a Symbol variable
         	holesArray.push(holeObject);  //push it into the array
         }
         
         for (var i=0; i<holesArray.length; i++){
         	holesArray[i].$("holesArt").animate ({left:-200*i}, 0);
         }
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = coursePath.$("txt0").css({"pointer-events":"none"});
         	txt[1] = coursePath.$("txt1").css({"pointer-events":"none"});
         	txt[2] = coursePath.$("txt2").css({"pointer-events":"none", "width":"auto"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	for (var i=6; i<15; i++){
         		txt[i] = sym.getSymbol("cardMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("matchplayMc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("matchplayMc").$("txt23").css({"pointer-events":"none", "height":"auto"});
         	txt[24] = sym.getSymbol("matchplayMc").getSymbol("play0").$("txt24").css({"pointer-events":"none", "height":"auto"});
         	txt[25] = sym.getSymbol("matchplayMc").getSymbol("play1").$("txt25").css({"pointer-events":"none", "height":"auto"});
         	txt[26] = sym.getSymbol("matchplayMc").getSymbol("play2").$("txt26").css({"pointer-events":"none", "height":"auto"});
         	txt[27] = sym.getSymbol("matchplayMc").getSymbol("play3").$("txt27").css({"pointer-events":"none", "height":"auto"});
         
         	txt[28] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.getSymbol("matchplayMc").getSymbol("play4").$("txt37").css({"pointer-events":"none"});
         	txt[38] = sym.getSymbol("teamsMc").$("txt38").css({"pointer-events":"none"});
         
         	var txtArr=[], winner=[], winnerEvents=[], teameuro=[], euroEvents=[], teamusa=[], usaEvents=[], datestring, parstring, yardsstring, stadia=[], stadiaEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34639.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<6; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<39; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			$(xml).find("teamEuro").each(function(){
         				var $teameuro=$(this);
         				euroEvents.push($teameuro);
         			});
         			addEuroTeam();
         
         			$(xml).find("teamUsa").each(function(){
         				var $teamusa=$(this);
         				usaEvents.push($teamusa);
         			});
         			addUsaTeam();
         
         			$(xml).find("winnerTable").each(function(){
         				var $winner=$(this);
         				winnerEvents.push($winner);
         			});
         			addWinnerTable();
         
         			stringPar = $(xml).find('txt4').text(); // Stage date for stage btn info
                  parstring=stringPar.split("<br>");
                  stringYards = $(xml).find('txt5').text(); // Stage date for stage btn info
                  yardsstring=stringYards.split("<br>");
                  for (var h=0; h<18; h++){
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").html(h+1).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").append(parstring[h]).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").append(yardsstring[h]).css({"pointer-events":"none"});
         			}
         			coursePath.$("txt0").css({"font-size":"15px", "line-height":"17px"});
         			sym.getSymbol('cardMc').$("txt10").css({"line-height":"22px"});
         			sym.getSymbol('cardMc').$("txt12").css({"line-height":"22px"});
         			sym.getSymbol('cardMc').$("txt14").css({"line-height":"22px"});
         			sym.getSymbol("holesMc").$("holeData").empty();
         			sym.getSymbol("holesMc").$("holeData").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         			sym.getSymbol("teamsMc").getSymbol("teamEuroMc").$("teamTxt").html(txtArr[17]);
         			sym.getSymbol("teamsMc").getSymbol("teamEuroMc").$("captainTxt").html(txtArr[18]);
         			sym.getSymbol("teamsMc").getSymbol("teamUsaMc").$("teamTxt").html(txtArr[19]);
         			sym.getSymbol("teamsMc").getSymbol("teamUsaMc").$("captainTxt").html(txtArr[20]);
         
         			sym.getSymbol("matchplayMc").$("txt22").css({"font-size":"20px"});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         
         //********************************************************************************************************
         // TEAM EUROPE
         //********************************************************************************************************
         var playerName=[], playerAge=[], playerRank=[], playerRecord=[];
         
         euroArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 12; i++){
         	var mySymbolObject = sym.getSymbol('teamsMc').getSymbol('teamEuroMc').createChildSymbol("playerEuroMc", "players");  // Create an instance element of a symbol as a child of the given parent element
         	euroArray.push(mySymbolObject);  //push it into the array
         }
         
         var move = 80;
         for (var i=0; i<euroArray.length; i++){
         	euroArray[i].getSymbolElement().animate ({top:move * i}, 0);
         	euroArray[i].$('playerPic').animate ({top:-80 * i}, 0);
         }
         sym.getSymbol('teamsMc').getSymbol('teamEuroMc').$('players').css({'overflow-x':'hidden'});
         
         function addEuroTeam() {
         		var $events=euroEvents[0].find('player');
         
         		$events.each(function(){
         			var $event=$(this);
         			var playname=$event.find("name").text();
         			playerName.push(playname);
         			var playage=$event.find("age").text();
         			playerAge.push(playage);
         			var playrank=$event.find("rank").text();
         			playerRank.push(playrank);
         			var playrecord=$event.find("record").text();
         			playerRecord.push(playrecord);
         		});
         
         		for (var h=0; h<12; h++){
         			euroArray[h].$('name').html(playerName[h]);
         			euroArray[h].$('age').html(txtArr[15] + "<b>"+playerAge[h]+"</b>" + '<span style="font-size:12px; color:white">___</span>' + txtArr[16] + "<b>"+playerRank[h]+"</b>");
         			euroArray[h].$('record').html(playerRecord[h]);
         		}
         }
         
         //********************************************************************************************************
         // TEAM USA
         //********************************************************************************************************
         var playerName2=[], playerAge2=[], playerRank2=[], playerRecord2=[];
         
         usaArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 12; i++){
         	var mySymbolObject = sym.getSymbol('teamsMc').getSymbol('teamUsaMc').createChildSymbol("playerUsaMc", "players");  // Create an instance element of a symbol as a child of the given parent element
         	usaArray.push(mySymbolObject);  //push it into the array
         }
         
         var move = 80;
         for (var i=0; i<usaArray.length; i++){
         	usaArray[i].getSymbolElement().animate ({top:move * i}, 0);
         	usaArray[i].$('playerPic').animate ({top:-80 * i}, 0);
         }
         sym.getSymbol('teamsMc').getSymbol('teamUsaMc').$('players').css({'overflow-x':'hidden'});
         
         function addUsaTeam() {
         		var $events=usaEvents[0].find('player');
         
         		$events.each(function(){
         			var $event=$(this);
         			var playname=$event.find("name").text();
         			playerName2.push(playname);
         			var playage=$event.find("age").text();
         			playerAge2.push(playage);
         			var playrank=$event.find("rank").text();
         			playerRank2.push(playrank);
         			var playrecord=$event.find("record").text();
         			playerRecord2.push(playrecord);
         		});
         
         		for (var h=0; h<12; h++){
         			usaArray[h].$('name').html(playerName2[h]);
         			usaArray[h].$('age').html(txtArr[15] + "<b>"+playerAge2[h]+"</b>" + '<span style="font-size:12px; color:white">___</span>' + txtArr[16] + "<b>"+playerRank2[h]+"</b>");
         			usaArray[h].$('record').html(playerRecord2[h]);
         		}
         }
         
         //********************************************************************************************************
         // POINTS TABLE
         //********************************************************************************************************
         
         var win=[]
         function addWinnerTable() {
         		var $events=winnerEvents[0].find('winner');
         		sym.getSymbol('winnersMc').$("table").empty();
         		var i=0;
         		var tableTxt="<table id='wintable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			if($event.attr('number')==0){//only get the event that matches 
         				var $win=$event.find("win");
         				$win.each(function(){
         					var $win=$(this);
         					var year=$win.find("year").text();
         					var venue=$win.find("venue").text();
         					var europe=$win.find("europe").text();
         					var usa=$win.find("usa").text();
         					var winlose=$win.find("winlose").text();
         					if (RTL == true){
         						//tableTxt+="<tr id='"+"stadia"+i+"' class='"+"stadia'>";
         						//tableTxt+="<td id='"+"matchId"+i+"' class='"+"matchCl'>"+match+"</td>";
         						//tableTxt+="<td id='"+"dayId"+i+"' class='"+"dayCl'>"+day+"</td>";
         						//tableTxt+="<td id='"+"monthId"+i+"' class='"+"monthCl'>"+month+"</td>";
         					} else {
         						tableTxt+="<tr id='"+"winner"+i+"' class='"+"winner'>";
         						tableTxt+="<td id='"+"yearId"+i+"' class='"+"yearCl'>"+year+"</td>";
         						tableTxt+="<td id='"+"venueId"+i+"' class='"+"venueCl'>"+venue+"</td>";
         						tableTxt+="<td id='"+"europeId"+i+"' class='"+"europeCl'>"+europe+"</td>";
         						tableTxt+="<td id='"+"usaId"+i+"' class='"+"usaCl'>"+usa+"</td>";
         						tableTxt+="<td id='"+"winloseId"+i+"' class='"+"winloseCl'>"+winlose+"</td>";
         					}
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		sym.getSymbol('winnersMc').$("table").append(tableTxt); //Then attach the buttons:
         		$("#wintable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse', 'width':'100%'});
         		$("#wintable tr:odd").css({"background-color":"#bfd9f4",'border-color':"rgb(255,255,255)","border-width":"2px ","border-style":"solid"});
         		$("#wintable tr:even").css({"background-color":"#bfd9f4",'border-color':"rgb(255,255,255)","border-width":"2px ","border-style":"solid"});
         		$("#wintable tr:nth-child(4)").css({"background-color":"#f8d4d4"});
         		$("#wintable tr:nth-child(8)").css({"background-color":"#f8d4d4"});
         		$("#wintable tr:nth-child(11)").css({"background-color":"#f8d4d4"});
         		$("#wintable tr:nth-child(12)").css({"background-color":"rgba(215,215,215,1)"});
         		$("#wintable tr:nth-child(13)").css({"background-color":"rgba(200,200,200,1)"});
         
         		$(".winner").css({'height':'30px', "vertical-align":"top"});
         		$(".yearCl").css({'width':'10%', "font-weight":"bold", 'padding-left':'5px', 'padding-right':'5px', 'text-align':'left', 'padding-top':'5px'});
         		$(".venueCl").css({'width':'60%', "font-weight":"regular", "color":"#000", 'text-align':'left', 'padding-top':'5px'});
         		$(".europeCl").css({'width':'10%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'right', 'padding-top':'5px'});
         		$(".usaCl").css({'width':'10%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'right', 'padding-top':'5px'});
         		$(".winloseCl").css({'width':'10%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'10px', 'text-align':'left', 'padding-top':'5px', "color":"rgba(0,0,0,1)", "background-color":"rgba(255,255,255,0.3)"});
         }
         
         function setPlay(){
         	stageWidth=sym.$("Stage").width();
         	var txt23 = sym.getSymbol("matchplayMc").$('txt23').height();
         	var play0 = sym.getSymbol("matchplayMc").$("play0").height();
         	var play1 = sym.getSymbol("matchplayMc").$("play1").height();
         	var play2 = sym.getSymbol("matchplayMc").$("play2").height();
         	var play3 = sym.getSymbol("matchplayMc").$("play3").height();
         	var matchWidth = 0;
         
         	if (stageWidth<800){
         		matchWidth = 20;
         		sym.getSymbol("matchplayMc").$("playerMc").css({"opacity":'0'});
         	} else {
         		matchWidth = 300;
         		sym.getSymbol("matchplayMc").$("playerMc").css({"opacity":'1'});
         	}
         	sym.getSymbol("matchplayMc").$("txt23").css({"width":(stageWidth-matchWidth)-10+"px"});
         	sym.getSymbol("matchplayMc").$("play0").css({"width":(stageWidth-matchWidth)+0+"px"});
         	sym.getSymbol("matchplayMc").$("play1").css({"width":(stageWidth-matchWidth)+0+"px"});
         	sym.getSymbol("matchplayMc").$("play2").css({"width":(stageWidth-matchWidth)+0+"px"});
         	sym.getSymbol("matchplayMc").$("play3").css({"width":(stageWidth-matchWidth)+0+"px"});
         
         	sym.getSymbol("matchplayMc").getSymbol("play0").$("txt24").css({"width":(stageWidth-matchWidth)-150+"px"});
         	sym.getSymbol("matchplayMc").getSymbol("play0").$("ball0").css({"left":(stageWidth-matchWidth)-30+"px"});
         	sym.getSymbol("matchplayMc").$("play0").css({'min-height':'70px', "top":txt23+45+"px", "height":sym.getSymbol("matchplayMc").getSymbol("play0").$("txt24").height()+20+"px"});
         
         	sym.getSymbol("matchplayMc").getSymbol("play1").$("txt25").css({"width":(stageWidth-matchWidth)-150+"px"});
         	sym.getSymbol("matchplayMc").getSymbol("play1").$("ball1").css({"left":(stageWidth-matchWidth)-30+"px"});
         	sym.getSymbol("matchplayMc").$("play1").css({'min-height':'70px', "top":(txt23 + play0)+45+"px", "height":sym.getSymbol("matchplayMc").getSymbol("play1").$("txt25").height()+20+"px"});
         
         	sym.getSymbol("matchplayMc").getSymbol("play2").$("txt26").css({"width":(stageWidth-matchWidth)-150+"px"});
         	sym.getSymbol("matchplayMc").getSymbol("play2").$("ball2").css({"left":(stageWidth-matchWidth)-30+"px"});
         	sym.getSymbol("matchplayMc").$("play2").css({'min-height':'70px', "top":(txt23 + play0 + play1)+45+"px", "height":sym.getSymbol("matchplayMc").getSymbol("play2").$("txt26").height()+20+"px"});
         
         	sym.getSymbol("matchplayMc").getSymbol("play3").$("txt27").css({"width":(stageWidth-matchWidth)-50+"px"});
         	sym.getSymbol("matchplayMc").getSymbol("play3").$("ball3").css({"left":(stageWidth-matchWidth)-30+"px"});
         	sym.getSymbol("matchplayMc").$("play3").css({"top":(txt23 + play0 + play1 + play2)+45+"px", "height":sym.getSymbol("matchplayMc").getSymbol("play3").$("txt27").height()+20+"px"});
         
         	sym.getSymbol("matchplayMc").$("play4").css({"top":(txt23 + play0 + play1 + play2 + play3)+45+"px"});
         }
         setPlay();
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	speed = 0;
         	setPlay();
         	sym.getSymbol('winnersMc').$('euFlag').css({'left':$(".yearCl").width() + $(".venueCl").width() + $(".europeCl").width()-20+'px'});
         	sym.getSymbol('winnersMc').$('usFlag').css({'left':$(".yearCl").width() + $(".venueCl").width() + $(".europeCl").width() + $(".usaCl").width()-10+'px'});
         	sym.getSymbol('winnersMc').$('cup').css({'left':$(".yearCl").width() + $(".venueCl").width() + $(".europeCl").width()+ $(".usaCl").width()+ $(".winloseCl").width()-15+'px'});
         	sym.getSymbol('winnersMc').$('winTop').css({'scaleX':'80%','left':stageWidth/2-sym.getSymbol('winnersMc').$('winTop').width()/2 +'px'});
         
         	if(stageWidth<750){
         		sym.$("scrollMc").css({'cursor':'ew-resize'});
         	}else{
         		sym.$("scrollMc").css({'cursor':'default'});
         	};
         	if(stageWidth<640){
         		sym.getSymbol('teamsMc').$('teamToggle').css({'opacity':'1', 'left':stageWidth-45 +'px'});
         		sym.getSymbol('teamsMc').$('teamEuroMc').css({'left':'0px', 'width':stageWidth +'px'});
         		sym.getSymbol('teamsMc').$('teamUsaMc').css({'left':'0px', 'width':stageWidth +'px'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		teamEuroIn();
         		sym.getSymbol('teamsMc').$('teamToggle').css({'opacity':'0'});
         		sym.getSymbol('teamsMc').$('teamEuroMc').css({'left':'0px', 'width':stageWidth/2 +'px'});
         		sym.getSymbol('teamsMc').$('teamUsaMc').css({'left':stageWidth/2 +'px', 'width':stageWidth/2 +'px'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	};
         	if (stageWidth<480){
         		sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         		mob = 1;
         	}else{
         		sym.$("scrollMc").stop().animate({width:stageWidth-200}, 0);
         		mob = 0;
         		navClick();
         	};
         
         	setStyle();
         	menuMob();
         	menuClicked()
         	setPlay();
         };
         
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<6; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css({"background-color":grey});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		speed = 200;
         		menuClicked();
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         function menuClicked(){
         	stageWidth=sym.$("Stage").width();
         	resetmenu();
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + clicked).$("bg").css({'background-color':red});
         	sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         	sym.$("winnersMc").stop().animate ({left:stageWidth+10}, speed, 'easeInCubic');
         	sym.$("cardMc").stop().animate ({left:stageWidth+10}, speed, 'easeInCubic');
         	sym.$("holesMc").stop().animate ({left:stageWidth+10}, speed, 'easeInCubic');
         	sym.$("teamsMc").stop().animate ({left:stageWidth+10}, speed, 'easeInCubic');
         	sym.$("matchplayMc").stop().animate ({left:stageWidth+10}, speed, 'easeInCubic');
         	sym.$("scrollMc").stop().animate ({width:stageWidth-200}, speed, 'easeOutCubic');
         
         	if (clicked == 0){
         		sym.$("scrollMc").stop().animate ({width:stageWidth}, speed, 'easeOutCubic');
         	} 
         
         	if (stageWidth>480){
         		if (clicked == 1){
         			sym.$("cardMc").stop().animate ({left:stageWidth-200, width:200}, speed, 'easeOutCubic');
         		}
         		if (clicked == 2){
         			sym.$("holesMc").stop().animate ({width:200}, 0);
         			sym.$("holesMc").stop().animate ({left:stageWidth-200, width:200}, speed, 'easeOutCubic');
         		}
         		if (clicked == 3){
         			sym.$("teamsMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         		if (clicked == 4){
         			sym.$("winnersMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         		if (clicked == 5){
         			sym.$("matchplayMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         	}
         	if (stageWidth<481){
         		if (clicked == 1){
         			resetCard();
         			sym.$("cardMc").stop().animate ({left:0, width:stageWidth}, speed, 'easeOutCubic');
         		}
         		if (clicked == 2){
         			sym.$("holesMc").stop().animate ({width:stageWidth}, 0);
         			sym.$("holesMc").stop().animate ({left:0, width:stageWidth}, speed, 'easeOutCubic');
         		}
         		if (clicked == 3){
         			sym.$("teamsMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         		if (clicked == 4){
         			sym.$("winnersMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         		if (clicked == 5){
         			sym.$("matchplayMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         	}
         	for (var i=0; i<18; i++){
         		holesArray[i].getSymbolElement().css({'left':(sym.$("holesMc").width()/2)-100+'px'});
         	}
         }
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<6; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:60+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<6; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<6; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<6; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:120-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<6; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<6; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         		sym.getSymbol("menuBtnsMc").$("menuBtn0").css({'left':'0px'});
         		sym.getSymbol("holesMc").$("redBox").css({'left':'150px'});
         		sym.getSymbol("holesMc").$("holeNo").css({'left':'150px'});
         		sym.getSymbol("holesMc").$("holeData").css({'left':'0px', 'text-align':'right'});
         		sym.getSymbol("holesMc").$("navBtnNext").css({'left':'0px','top':'501px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.getSymbol("holesMc").$("navBtnBack").css({'left':'160px','top':'501px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         
         		if (stageWidth<480){
         			sym.getSymbol("holesMc").$("navBtnBack").css({'left':stageWidth-40+'px','top':'501px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         			sym.getSymbol("holesMc").$("redBox").css({'left':stageWidth-50 + "px"});
         			sym.getSymbol("holesMc").$("holeNo").css({'left':stageWidth-50 + "px"});
         			sym.getSymbol("holesMc").$("holeData").css({'text-align':'right', 'left':stageWidth-202 + 'px'});
         		} else {
         
         		}
         		for (var h=0; h<18; h++){
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").css({"left":"66%"});
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").css({"left":"33%"});
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").css({"left":"0px"});
         		}
         		sym.getSymbol("cardMc").$("txt6").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt8").css({"left":"0px"});
         		sym.getSymbol("cardMc").$("txt9").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt10").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt13").css({"left":"0px"});
         		sym.getSymbol("cardMc").$("txt14").css({"left":"0px"});
         
         		coursePath.$("txt0").css({"text-align":"right"});
         		coursePath.$("txt1").css({"text-align":"right"});
         	}
         }
         
         //********************************************************************************************************
         // DOT BUTTONS
         //********************************************************************************************************
         dotArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	dotArray.push(a);
         }
         
         function resetDot(){
         	for (var a=0; a<dotArray.length; a++){
         		coursePath.getSymbol("roundBtn" + a).$("btnBg").css({"background-color":"white"});
         		coursePath.getSymbol("roundBtn" + a).$("txt").css({"color":"black"});
         	}
         }
         resetDot();
         
         // DOT CLICK
         var dotBtnClick = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		if (stageWidth<480){
         			sym.$("holesMc").stop().animate ({left:0}, 200, 'easeOutCubic');
         			clicked = 2;
         			menuClicked();
         		}
         		clickedAux = dotNo;
         		clickedDot = clickedAux;
         		navClick();
         	};
         };
         for (var b=0;b<dotArray.length;b++){
         	coursePath.$("roundBtn"+b).on('touchstart click',dotBtnClick(b));
         	coursePath.$("roundBtn"+b).css({'cursor':'pointer'});
         }
         coursePath.getSymbol("roundBtn0").$("btnBg").css({"background-color":red});
         coursePath.getSymbol("roundBtn0").$("txt").css({"color":"white"});
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         // NAV CLICK FUNCTION
         //********************************************************************************************************
         function navClick(){
         	for (var i=0; i<holesArray.length; i++){
         		holesArray[i].getSymbolElement().animate ({opacity:0}, 0);
         	}
         	holesArray[clickedAux].getSymbolElement().stop().animate ({opacity:1}, 0);
         	sym.getSymbol("holesMc").$("holeNo").html(clickedAux + 1);
         	sym.getSymbol("holesMc").$("holeData").empty();
         	sym.getSymbol("holesMc").$("holeData").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         	sym.getSymbol("holesMc").$("holeName").empty();
         	sym.getSymbol("holesMc").$("holeName").append(txtArr[clickedAux+21]);
         
         	if (clickedAux <=0 ){
         		sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnBack").fadeIn(0);
         	}
         	if (clickedAux >= 17){
         		sym.getSymbol("holesMc").$("navBtnNext").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnNext").fadeIn(0);
         	}
         	resetCard();
         	resetDot();
         	sym.getSymbol("cardMc").getSymbol("btn" + clickedAux).$("btnBg").fadeIn(0);
         	coursePath.getSymbol("roundBtn" + clickedAux).$("btnBg").css({"background-color":red});
         	coursePath.getSymbol("roundBtn" + clickedAux).$("txt").css({"color":"white"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt01").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt02").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt03").css({"color":"white", "font-weight":"bold"});
         
         	var x = coursePath.$("roundBtn" + clickedAux).position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500, 'easeOutCubic');
         }
         
         //********************************************************************************************************
         // NAVIGATION BUTTONS
         //********************************************************************************************************
         sym.getSymbol("holesMc").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux++;
         	navClick();
         	});
         sym.getSymbol("holesMc").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux--;
         	navClick();
         	});
         
         //********************************************************************************************************
         // TEAM TOGGLE BUTTONS
         //********************************************************************************************************
         var toggled = 0;
         sym.getSymbol("teamsMc").$("teamToggle").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (toggled == 0){
         		sym.getSymbol("teamsMc").$("teamToggle").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.getSymbol("teamsMc").getSymbol("teamToggle").$('bg').css({'background-color':blue});
         		sym.getSymbol("teamsMc").$("teamEuroMc").stop().animate({left:stageWidth}, 200, 'easeInCubic');
         		toggled = 1;
         	} else {
         		teamEuroIn();
         	}
         });
         function teamEuroIn(){
         	sym.getSymbol("teamsMc").$("teamToggle").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	sym.getSymbol("teamsMc").getSymbol("teamToggle").$('bg').css({'background-color':red});
         	sym.getSymbol("teamsMc").$("teamEuroMc").stop().animate({left:0}, 200, 'easeOutCubic');
         	toggled = 0;
         }
         sym.getSymbol("teamsMc").getSymbol("teamToggle").$('bg').css({'background-color':red});
         
         //********************************************************************************************************
         // CARD BUTTONS
         //********************************************************************************************************
         cardArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	cardArray.push(a);
         }
         
         function resetCard(){
         	for (var a=0; a<cardArray.length; a++){
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt03").css({"color":"black", "font-weight":"normal"});
         	}
         }
         resetCard();
         
         // CARD CLICK
         var cardBtnClick = function(cardNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		clickedAux = cardNo;
         		navClick();
         		if (stageWidth<480){
         			sym.$("cardMc").stop().animate ({left:stageWidth+10}, 200, 'easeInCubic');
         			resetmenu();
         			clicked=2;
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("bg").css(red);
         			menuClicked();
         		}
         	};
         };
         
         for (var b=0;b<cardArray.length;b++){
         	sym.getSymbol("cardMc").$("btn"+b).on('touchstart click',cardBtnClick(b));
         	sym.getSymbol("cardMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("cardMc").getSymbol("btn0").$("btnBg").fadeIn(0);
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt01").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt02").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt03").css({"color":"white", "font-weight":"bold"});
         
         sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         sym.getSymbol("holesMc").getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("matchplayMc").getSymbol("play4").stop((stageWidth*10));
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.$("matchplayMc").css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         });
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'roundBtnsMc'
   (function(symbolName) {   
   
   })("roundBtnsMc");
   //Edge symbol end:'roundBtnsMc'

   //=========================================================
   
   //Edge symbol: 'roundBtn'
   (function(symbolName) {   
   
   })("roundBtn");
   //Edge symbol end:'roundBtn'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMc");
   //Edge symbol end:'holesMc'

   //=========================================================
   
   //Edge symbol: 'holeMc'
   (function(symbolName) {   
   
   })("holeMc");
   //Edge symbol end:'holeMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'holesHolderMc'
   (function(symbolName) {   
   
   })("holesHolderMc");
   //Edge symbol end:'holesHolderMc'

   //=========================================================
   
   //Edge symbol: 'cardBtn'
   (function(symbolName) {   
   
   })("cardBtn");
   //Edge symbol end:'cardBtn'

   //=========================================================
   
   //Edge symbol: 'cardMc'
   (function(symbolName) {   
   
   })("cardMc");
   //Edge symbol end:'cardMc'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2_1'
   (function(symbolName) {   
   
      })("menuBtn3");
   //Edge symbol end:'menuBtn3'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn4");
   //Edge symbol end:'menuBtn4'

   //=========================================================
   
   //Edge symbol: 'teamEuroMc'
   (function(symbolName) {   
   
   })("teamEuroMc");
   //Edge symbol end:'teamEuroMc'

   //=========================================================
   
   //Edge symbol: 'playerMc'
   (function(symbolName) {   
   
   })("playerEuroMc");
   //Edge symbol end:'playerEuroMc'

   //=========================================================
   
   //Edge symbol: 'teamsMc'
   (function(symbolName) {   
   
   })("teamsMc");
   //Edge symbol end:'teamsMc'

   //=========================================================
   
   //Edge symbol: 'playerEuroMc_1'
   (function(symbolName) {   
   
      })("playerUsaMc");
   //Edge symbol end:'playerUsaMc'

   //=========================================================
   
   //Edge symbol: 'teamEuroMc_1'
   (function(symbolName) {   
   
      })("teamUsaMc");
   //Edge symbol end:'teamUsaMc'

   //=========================================================
   
   //Edge symbol: 'teamToggle'
   (function(symbolName) {   
   
   })("teamToggle");
   //Edge symbol end:'teamToggle'

   //=========================================================
   
   //Edge symbol: 'euFlag'
   (function(symbolName) {   
   
   })("euFlag");
   //Edge symbol end:'euFlag'

   //=========================================================
   
   //Edge symbol: 'euFlag_1'
   (function(symbolName) {   
   
   })("usFlag");
   //Edge symbol end:'usFlag'

   //=========================================================
   
   //Edge symbol: 'usFlag_1'
   (function(symbolName) {   
   
   })("cup");
   //Edge symbol end:'cup'

   //=========================================================
   
   //Edge symbol: 'winTop'
   (function(symbolName) {   
   
   })("winTop");
   //Edge symbol end:'winTop'

   //=========================================================
   
   //Edge symbol: 'menuBtn4_1'
   (function(symbolName) {   
   
         })("menuBtn5");
   //Edge symbol end:'menuBtn5'

   //=========================================================
   
   //Edge symbol: 'matchplayMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("matchplayMc");
   //Edge symbol end:'matchplayMc'

   //=========================================================
   
   //Edge symbol: 'play0'
   (function(symbolName) {   
   
   })("play0");
   //Edge symbol end:'play0'

   //=========================================================
   
   //Edge symbol: 'ball0'
   (function(symbolName) {   
   
   })("ball0");
   //Edge symbol end:'ball0'

   //=========================================================
   
   //Edge symbol: 'play0_1'
   (function(symbolName) {   
   
   })("play1");
   //Edge symbol end:'play1'

   //=========================================================
   
   //Edge symbol: 'play1_1'
   (function(symbolName) {   
   
   })("play2");
   //Edge symbol end:'play2'

   //=========================================================
   
   //Edge symbol: 'ball0_1'
   (function(symbolName) {   
   
   })("ball2");
   //Edge symbol end:'ball2'

   //=========================================================
   
   //Edge symbol: 'play2_1'
   (function(symbolName) {   
   
   })("play3");
   //Edge symbol end:'play3'

   //=========================================================
   
   //Edge symbol: 'ball2_1'
   (function(symbolName) {   
   
   })("ball3");
   //Edge symbol end:'ball3'

   //=========================================================
   
   //Edge symbol: 'play3_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("play4");
   //Edge symbol end:'play4'

   //=========================================================
   
   //Edge symbol: 'playerMc'
   (function(symbolName) {   
   
   })("playerMc");
   //Edge symbol end:'playerMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34639");