/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var artPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var scrollStopped = false;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"5px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "padding":"5px"});
         	var standmob;
         	var standtxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var yellowTxtBox = {"border-color":"white", "border-width":"1px", "border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#f7ac00", "height":"auto", "padding":"5px", "pointer-events":"none"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px", "pointer-events":"none"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = artPath.getSymbol('pMc0').$("txt0").css({"pointer-events":"none"});
         	txt[1] = artPath.getSymbol('pMc0').$("txt1").css(yellowTxtBox);
         	txt[2] = artPath.getSymbol('pMc0').$("txt2").css({"pointer-events":"none"});
         	txt[3] = artPath.getSymbol('pMc0').$("txt3").css({"pointer-events":"none"});
         	txt[4] = artPath.getSymbol('pMc0').$("txt4").css(yellowTxtBox);
         	txt[5] = artPath.getSymbol('pMc0').$("txt5").css({"pointer-events":"none"});
         	txt[6] = artPath.getSymbol('pMc0').$("txt6").css({"pointer-events":"none"});
         	txt[7] = artPath.getSymbol('pMc1').$("txt7").css(yellowTxtBox);
         	for (var i=8; i<15; i++){
         		txt[i] = artPath.getSymbol('pMc2').$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=15; i<21; i++){
         		txt[i] = artPath.getSymbol('pMc3').$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[21] = artPath.getSymbol('pMc4').$("txt21").css({"pointer-events":"none"});
         	txt[22] = artPath.getSymbol('pMc4').$("txt22").css({"pointer-events":"none"});
         	txt[23] = artPath.getSymbol('pMc4').$("txt23").css(yellowTxtBox);
         	for (var i=24; i<30; i++){
         		txt[i] = artPath.getSymbol('pMc5').$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[30] = artPath.getSymbol('pMc7').$("txt30").css(yellowTxtBox);
         	for (var i=31; i<34; i++){
         		txt[i] = artPath.getSymbol('pMc7').$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[34] = artPath.getSymbol('pMc6').$("txt34").css({"pointer-events":"none"});
         	txt[35] = artPath.getSymbol('pMc6').$("txt35").css({"pointer-events":"none"});
         	txt[36] = artPath.getSymbol('pMc8').$("txt36").css({"pointer-events":"none"});
         	txt[37] = artPath.getSymbol('pMc8').$("txt37").css({"pointer-events":"none"});
         	txt[38] = artPath.getSymbol('pMc8').$("txt38").css({"pointer-events":"none"});
         	txt[39] = artPath.getSymbol('pMc8').$("txt39").css(yellowTxtBox);
         	txt[40] = artPath.getSymbol('pMc8').$("txt40").css(yellowTxtBox);
         	txt[41] = artPath.getSymbol('pMc8').$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.getSymbol('key').$("txt42").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34587.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			standmob = $(xml).find('standmob').text();
         			standtxtmob.html(standmob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<43; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			artPath.getSymbol('pMc8').$("txt40").css({'top':404-artPath.getSymbol('pMc8').$("txt40").height()+'px'});
         			artPath.getSymbol('pMc5').$("txt29").css({"line-height":"20px"});
         			sym.getSymbol('key').$("txt42").css({"line-height":"16px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         
         	if(stageWidth<640){
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(stand);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("standTxt").css({"top":30-sym.$("standTxt").height()+"px", "background-color":"rgba(255,255,255,1)", 'padding-bottom':'45px', 'width':stageWidth-10+'px'});
         		sym.$("standBtn").css({"left":stageWidth-40+"px"});
         		sym.$("key").css({"left":"0px"});
         		closeStand();
         	}else{
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(standmob);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("standTxt").css({"top":"40px", 'width':stageWidth-330+'px', "background-color":"rgba(255,255,255,0)", 'padding-bottom':'0px'});
         		sym.$("standBtn").css({"left":stageWidth+"px"});
         		sym.$("key").css({"left":stageWidth-320+"px"});
         	}
         	setStyle();
         	doCheck();
         }
         
         //********************************************************************************************************
         // VISIBLE CHECK
         //********************************************************************************************************
         $.fn.isVisible = function() {
             var rect = this[0].getBoundingClientRect();
             return (
                 (rect.height > 0 || rect.width > 0) && rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth)
             );
         };
         
         function doCheck() {
             for (var h=0; h<9; h++){
         
         		if (artPath.$("pLeft"+h).isVisible() && artPath.$("pRight"+h).isVisible()) {
         			artPath.$("pMc"+h).stop().animate({opacity:1}, 200);
         		} else {
         			artPath.$("pMc"+h).stop().animate({opacity:0}, 50);
         		}
         
         	}
         }
         
         var TO = false;
         var scroll_static = true;
         
         sym.$("scrollMc").scroll(function(){
         	doCheck();
         	if( scroll_static ){
         		scroll_static = false;
         	}
         
         	if (TO !== false){ clearTimeout(TO); }           
         	TO = setTimeout(myfunction, 100); 
         });
         
         function myfunction(){
         	scroll_static = true;	
         }
         
         //********************************************************************************************************
         // STAND BUTTON
         //********************************************************************************************************
         var standVis = false;
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	closeSource();
         	if (standVis == false){
         		sym.$("standBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         		sym.$("standBtn").stop().animate ({top:sym.$("standTxt").height()+50}, 200, 'easeOutCubic');
         		sym.$("standTxt").stop().animate ({top:40}, 200, 'easeOutCubic');
         		standVis = true;
         	} else{
         		closeStand();
         	}
         });
         function closeStand(){
         	sym.$("standBtn").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         	sym.$("standBtn").stop().animate ({top:0}, 200, 'easeOutCubic');
         	sym.$("standTxt").stop().animate ({top:-sym.$("standTxt").height()-80}, 200, 'easeOutCubic');
         	standVis = false;
         }
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         sym.$("scrollMc").css({'overflow-y':'hidden'});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("pMc3").$("txt16").css({'width':'auto','background-color':'rgba(255,255,255,0.8)','padding':'0px 1px 3px'});
         	closeSource();
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'pMc0'
   (function(symbolName) {   
   
   })("pMc0");
   //Edge symbol end:'pMc0'

   //=========================================================
   
   //Edge symbol: 'pMc1'
   (function(symbolName) {   
   
   })("pMc1");
   //Edge symbol end:'pMc1'

   //=========================================================
   
   //Edge symbol: 'pMc2'
   (function(symbolName) {   
   
   })("pMc2");
   //Edge symbol end:'pMc2'

   //=========================================================
   
   //Edge symbol: 'pMC3'
   (function(symbolName) {   
   
   })("pMC3");
   //Edge symbol end:'pMC3'

   //=========================================================
   
   //Edge symbol: 'pMc4'
   (function(symbolName) {   
   
   })("pMc4");
   //Edge symbol end:'pMc4'

   //=========================================================
   
   //Edge symbol: 'pMc5'
   (function(symbolName) {   
   
   })("pMc5");
   //Edge symbol end:'pMc5'

   //=========================================================
   
   //Edge symbol: 'pMc6'
   (function(symbolName) {   
   
   })("pMc6");
   //Edge symbol end:'pMc6'

   //=========================================================
   
   //Edge symbol: 'pMc7'
   (function(symbolName) {   
   
   })("pMc7");
   //Edge symbol end:'pMc7'

   //=========================================================
   
   //Edge symbol: 'pMc8'
   (function(symbolName) {   
   
   })("pMc8");
   //Edge symbol end:'pMc8'

   //=========================================================
   
   //Edge symbol: 'key'
   (function(symbolName) {   
   
   })("key");
   //Edge symbol end:'key'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34587");