/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var standmob;
         	var standtxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", 'padding':'6px'});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto", "padding":"5px"};
         	
         	var whiteTxtBox2 = {"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"5px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css(whiteTxtBox);
         	txt[6] = sym.$("txt6").css(whiteTxtBox2);
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol('turn').$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol('map').$("txt10").css(whiteTxtBox);
         	txt[11] = sym.getSymbol('map').$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol('map').$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol('map').$("txt13").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34585.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			standmob = $(xml).find('standmob').text();
         			standtxtmob.html(standmob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<14; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         				if (RTL == true){
         					txt[i].css({'text-align':'right'});
         				}
         			}
         			sym.getSymbol('map').$("txt13").css({"line-height":"20px"});
         			sym.$("txt5").css({'top':565 - sym.$("txt5").height()+"px"});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         	
         //********************************************************************************************************
         // RTL 
         //********************************************************************************************************
         function RTLcheck(){
         	sym.$("txt2").css({"text-align":"left"});
         	sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         	sym.$("standTxt").css({"text-align":"right"});
         	sym.$("btnNext").css({'left':'0px', 'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	sym.$("btnNextCopy").css({'left':'0px', 'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	sym.$("btnBack").css({'left':'52px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	sym.$("btnBackCopy").css({'left':'52px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("btnBack").css({'left':stageWidth-102+'px'});
         	sym.$("btnBackCopy").css({'left':stageWidth-102+'px'});
         	sym.$("standTxt").css({"width":stageWidth-10+'px'});
         	sym.$("turn").css({"top":sym.$("standTxt").height()+60+'px', 'left':stageWidth-310+'px'});
         	sym.$("map").css({"top":sym.$("standTxt").height()+60+'px', 'left':stageWidth-360+'px'});
         
         	if(stageWidth<640){
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(standmob);
         		sym.$("txt6").css({'text-align':'right'});
         	}else{
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(stand);
         		sym.$("txt6").css({'text-align':'left'});
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<360){
         		sym.$("map").css({'left':'-8px'});
         	}
         	setStyle();
         	closeSource();
         	if (RTL == true){
         		RTLcheck();
         	}
         }
         //********************************************************************************************************
         // NAV BUTTON
         //********************************************************************************************************
         var nav = 0;
         sym.$("btnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	nav++;
         	resetNav();
         	navClicked();
         });
         sym.$("btnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	nav--;
         	resetNav();
         	navClicked();
         });
         //********************************************************************************************************
         function resetNav(){
         	sym.$('powerPop').stop().fadeOut(200);
         	sym.$('powerPopTop').stop().fadeOut(200);
         	sym.$('map').stop().animate({opacity:0}, 200);
          	sym.$('turn').stop().animate({opacity:0}, 200);
          	sym.$('map').stop().animate({opacity:0}, 200);
          	
         	sym.$('txt0').stop().animate({opacity:0}, 200);
          	sym.$('txt1').stop().animate({opacity:0}, 200);
          	sym.$('txt2').stop().animate({opacity:0}, 200);
          	sym.$('txt3').stop().animate({opacity:0}, 200);
          	sym.$('txt6').stop().animate({opacity:0}, 200);
          	
          	sym.$('pointer1').stop().fadeOut(200);
          	sym.$('pointer2').stop().fadeOut(200);
          	sym.$('pointer3').stop().fadeOut(200);
          	sym.$('pointer4').stop().fadeOut(200);
          	
          	sym.$("btnBack").fadeIn(0);
          	sym.$("btnNext").fadeIn(0);
         }
         resetNav();
         //********************************************************************************************************
         function navClicked(){
         	if (nav==0){
         		sym.$("btnBack").fadeOut(0);
          		sym.$('powerPop').stop().fadeIn(200);
          		sym.$('powerPopTop').stop().fadeIn(200);
          		sym.$('txt1').stop().animate({opacity:1}, 200);
         	}
         	if (nav==1){
          		sym.$('pointer1').stop().fadeIn(200);
          		sym.$('txt3').stop().animate({opacity:1}, 200);
          		sym.$('pointer2').stop().fadeIn(200);
          		sym.$('txt0').stop().animate({opacity:1}, 200);
         	}
         	if (nav==2){
         		sym.$('pointer3').stop().fadeIn(200);
          		sym.$('txt2').stop().animate({opacity:1}, 200);
          		sym.$('pointer4').stop().fadeIn(200);
          		sym.$('txt6').stop().animate({opacity:1}, 200);
         	}
         	if (nav==3){
         		sym.$('turn').stop().animate({opacity:1}, 200);
         	}
         	if (nav==4){
         		sym.$('map').stop().animate({opacity:1}, 200);
         		sym.$("btnNext").fadeOut(0);
         	}
         	closeSource();
         }
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         sym.$('powerPop').stop().fadeOut(0);
         sym.$('powerPop').delay(5000).fadeIn(200);
         sym.$('powerPopTop').stop().fadeOut(0);
         sym.$('powerPopTop').delay(5000).fadeIn(200);
         sym.$("btnNext").fadeOut(0);
         sym.$("btnNext").delay(5000).fadeIn(200);
         sym.$("btnNextCopy").fadeOut(0);
         sym.$("btnNextCopy").delay(5000).fadeIn(200);
         sym.$("btnBack").fadeOut(0);
         sym.$("btnBackCopy").fadeOut(0);
         sym.$("btnBackCopy").delay(5000).fadeIn(200);
         
         sym.$('txt1').stop().animate({opacity:0}, 0);
         sym.$('txt1').delay(5000).animate({opacity:1}, 200);
         sym.$('txt5').stop().animate({opacity:0}, 0);
         sym.$('txt5').delay(5000).animate({opacity:1}, 200);
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'roadPiece'
   (function(symbolName) {   
   
   })("roadPiece");
   //Edge symbol end:'roadPiece'

   //=========================================================
   
   //Edge symbol: 'roadMc'
   (function(symbolName) {   
   
   })("roadMc");
   //Edge symbol end:'roadMc'

   //=========================================================
   
   //Edge symbol: 'station'
   (function(symbolName) {   
   
   })("station");
   //Edge symbol end:'station'

   //=========================================================
   
   //Edge symbol: 'power'
   (function(symbolName) {   
   
   })("power");
   //Edge symbol end:'power'

   //=========================================================
   
   //Edge symbol: 'barrier'
   (function(symbolName) {   
   
   })("barrier");
   //Edge symbol end:'barrier'

   //=========================================================
   
   //Edge symbol: 'bus'
   (function(symbolName) {   
   
   })("bus");
   //Edge symbol end:'bus'

   //=========================================================
   
   //Edge symbol: 'truck'
   (function(symbolName) {   
   
   })("truck");
   //Edge symbol end:'truck'

   //=========================================================
   
   //Edge symbol: 'mainMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.play(6000);

      });
      //Edge binding end

   })("mainMc");
   //Edge symbol end:'mainMc'

   //=========================================================
   
   //Edge symbol: 'car1'
   (function(symbolName) {   
   
   })("car1");
   //Edge symbol end:'car1'

   //=========================================================
   
   //Edge symbol: 'car1_1'
   (function(symbolName) {   
   
   })("car2");
   //Edge symbol end:'car2'

   //=========================================================
   
   //Edge symbol: 'car2_1'
   (function(symbolName) {   
   
   })("car3");
   //Edge symbol end:'car3'

   //=========================================================
   
   //Edge symbol: 'car3_1'
   (function(symbolName) {   
   
   })("car4");
   //Edge symbol end:'car4'

   //=========================================================
   
   //Edge symbol: 'map'
   (function(symbolName) {   
   
   })("map");
   //Edge symbol end:'map'

   //=========================================================
   
   //Edge symbol: 'powerMini'
   (function(symbolName) {   
   
   })("powerMini");
   //Edge symbol end:'powerMini'

   //=========================================================
   
   //Edge symbol: 'powerPop'
   (function(symbolName) {   
   
   })("powerPop");
   //Edge symbol end:'powerPop'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn'
   (function(symbolName) {   
   
   })("stageNavBtn");
   //Edge symbol end:'stageNavBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'pointer'
   (function(symbolName) {   
   
   })("pointer");
   //Edge symbol end:'pointer'

   //=========================================================
   
   //Edge symbol: 'turn'
   (function(symbolName) {   
   
   })("turn");
   //Edge symbol end:'turn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34585");