/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var artPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var colInView = false;
         	var scrollStopped = false;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var standmob;
         	var standtxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var whiteTxtBox100 = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var whiteTxtBox2 = {"border-color":"#999", "border-width":"1px","border-style":"solid", "border-radius":"3px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0)", "height":"auto","width":"auto", "padding":"5px", "padding-left":"21px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var redTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"20px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(218,0,0,1)", "height":"auto","width":"auto", "padding":"3px", "padding-left":"8px", "padding-right":"8px"};
         
         
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = artPath.getSymbol("pMc0").$("txt0").css({"pointer-events":"none"});
         	txt[1] = artPath.getSymbol("pMc0").$("txt1").css({"pointer-events":"none"});
         	txt[2] = artPath.getSymbol("pMc0").$("txt2").css({"pointer-events":"none"});
         	txt[3] = artPath.getSymbol("pMc0").$("txt3").css({"pointer-events":"none"});
         	txt[4] = artPath.getSymbol("pMc0").$("txt4").css(redTxtBox);
         	txt[5] = artPath.getSymbol("pMc0").$("txt5").css(whiteTxtBox);
         	txt[6] = artPath.getSymbol("pMc1").$("txt6").css({"pointer-events":"none"});
         	txt[7] = artPath.getSymbol("pMc1").$("txt7").css({"pointer-events":"none"});
         	txt[8] = artPath.getSymbol("pMc1").$("txt8").css({"pointer-events":"none"});   
         	txt[9] = artPath.getSymbol("pMc2").$("txt9").css(redTxtBox);
         	txt[10] = artPath.getSymbol("pMc2").$("txt10").css(whiteTxtBox100);
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = artPath.getSymbol("pMc3").$("txt12").css(whiteTxtBox100);
         	txt[13] = artPath.getSymbol("pMc3").$("txt13").css(redTxtBox);
         	txt[14] = artPath.getSymbol("pMc3").$("txt14").css(whiteTxtBox100);
         	txt[15] = artPath.getSymbol("pMc3").$("txt15").css(whiteTxtBox100);
         	txt[16] = artPath.getSymbol("pMc3").$("txt16").css({"pointer-events":"none"});
         	txt[17] = artPath.getSymbol("pMc3").$("txt17").css({"pointer-events":"none"});
         	txt[18] = artPath.getSymbol("pMc4Over").$("txt18").css({"pointer-events":"none"});
         	txt[19] = artPath.getSymbol("pMc4Over").$("txt19").css({"pointer-events":"none"});
         	txt[20] = artPath.getSymbol("pMc4Over").$("txt20").css({"pointer-events":"none"});
         	txt[21] = artPath.getSymbol("pMc0").$("txt21").css(whiteTxtBox2);
         	txt[22] = artPath.getSymbol("pMc0").$("txt22").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34583.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			standmob = $(xml).find('standmob').text();
         			standtxtmob.html(standmob);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<23; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(standmob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(stand);
         	}
         
         	setStyle();
         	hideCol();
         	doCheck();
         }
         
         $.fn.isVisible = function() {
             var rect = this[0].getBoundingClientRect();
             return (
                 (rect.height > 0 || rect.width > 0) && rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth)
             );
         };
         
         function doCheck() {
             for (var h=0; h<5; h++){
         		if (artPath.$("pLeft"+h).isVisible() && artPath.$("pRight"+h).isVisible()) {
         			artPath.$("pMc"+h).stop().animate({opacity:1}, 200);
         		} else {
         			artPath.$("pMc"+h).stop().animate({opacity:0}, 50);
         		}
         	}
         }
         
         var TO = false;
         var scroll_static = true;
         
         sym.$("scrollMc").scroll(function(){
         	doCheck();
         	if( scroll_static ){
         		scroll_static = false;
         		hideCol();
         	}
         
         	if (TO !== false){ clearTimeout(TO); }           
         	TO = setTimeout(myfunction, 100); 
         });
         
         function myfunction(){
         	scroll_static = true;	
         	if (colInView == true){
         		showCol();
         		colInView = false;
         	}else{
         		hideCol();
         		colInView = false;
         	}
         }
         
         //********************************************************************************************************
         // COLUMN BUTTON
         //********************************************************************************************************
         
         artPath.$("pMc4").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	artPath.getSymbol("pMc4").stop(0);
         	if (artPath.getSymbol("pMc4").$("plus").is(":visible")) { 
         		colInView = true;
         		sym.$("scrollMc").stop().animate({scrollLeft:378}, 400, 'easeOutCubic');
         		showCol();
         	} else {
         		colInView = false;
         		hideCol();
         	}
         
         });
         
         function hideCol(){
         	artPath.getSymbol("pMc4").$("plus").fadeIn(0);
         	artPath.$('pMc4Over').stop().fadeOut(100);
         	artPath.getSymbol("pMc2").$("roofBtn").fadeIn(0);
         	doCheck();
         }
         
         function showCol(){
         	artPath.getSymbol("pMc4").$("plus").fadeOut(0);
         	artPath.$('pMc4Over').stop().fadeIn(400);
         	artPath.$("pMc2").stop().animate({opacity:0}, 200);
         	artPath.$("pMc3").stop().animate({opacity:0}, 200);
         }
         
         //********************************************************************************************************
         // ROOF BUTTON
         //********************************************************************************************************
         artPath.getSymbol("pMc2").$("roofBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	artPath.getSymbol("pMc2").getSymbol("roofBtn").stop(0);
         	if (artPath.getSymbol("pMc2").getSymbol("roofBtn").$("plus").is(":visible") ) { 
         		artPath.getSymbol('roofMc').play();
         		artPath.getSymbol("pMc2").getSymbol("roofBtn").$("plus").fadeOut(0);
         	} else {
         		artPath.getSymbol('roofMc').playReverse();
         		artPath.getSymbol("pMc2").getSymbol("roofBtn").$("plus").fadeIn(0);
         	}
         	});
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	colInView = false;
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	//sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'pointer'
   (function(symbolName) {   
   
   })("pointer");
   //Edge symbol end:'pointer'

   //=========================================================
   
   //Edge symbol: 'p1Mc'
   (function(symbolName) {   
   
   })("pMc0");
   //Edge symbol end:'pMc0'

   //=========================================================
   
   //Edge symbol: 'p2Mc'
   (function(symbolName) {   
   
   })("pMc1");
   //Edge symbol end:'pMc1'

   //=========================================================
   
   //Edge symbol: 'pMc2'
   (function(symbolName) {   
   
   })("pMc2");
   //Edge symbol end:'pMc2'

   //=========================================================
   
   //Edge symbol: 'pMc3'
   (function(symbolName) {   
   
   })("pMc3");
   //Edge symbol end:'pMc3'

   //=========================================================
   
   //Edge symbol: 'roof1'
   (function(symbolName) {   
   
   })("roof1");
   //Edge symbol end:'roof1'

   //=========================================================
   
   //Edge symbol: 'roofBtn'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("roofBtn");
   //Edge symbol end:'roofBtn'

   //=========================================================
   
   //Edge symbol: 'pMc4'
   (function(symbolName) {   
   
   })("pMc4");
   //Edge symbol end:'pMc4'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34583");