/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<5; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	var txtArr=[], tab=[], tabEvents=[]
         	$.ajax({	
         		type: "GET",
         		url: "GN34555.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<5; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			for (var a=0; a<3; a++){
         				sym.getSymbol("auxBtnsMc").getSymbol("auxBtn"+a).$("txt").html(txtArr[a+2]);
         			}
         
         			$(xml).find("olympics").each(function(){
         				var $tab=$(this);
         				tabEvents.push($tab);
         			});
         			addMedals();
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         var medals=[];
         function addMedals() {
         		var $events=tabEvents[0].find('tab');
         		sym.$("table").empty();
         
         		var i=0;
         		var tableTxt="<table id='medaltable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         				var $medals=$event.find("medals");
         				$medals.each(function(){
         					var $medals=$(this);
         					var year=$medals.find("year").text();
         					var city=$medals.find("city").text();
         					var nat1=$medals.find("nat1").text();
         					var gold1=$medals.find("gold1").text();
         					var silver1=$medals.find("silver1").text();
         					var bronze1=$medals.find("bronze1").text();
         					var nat2=$medals.find("nat2").text();
         					var gold2=$medals.find("gold2").text();
         					var silver2=$medals.find("silver2").text();
         					var bronze2=$medals.find("bronze2").text();
         					var nat3=$medals.find("nat3").text();
         					var gold3=$medals.find("gold3").text();
         					var silver3=$medals.find("silver3").text();
         					var bronze3=$medals.find("bronze3").text();
         					if (RTL == true){
         						tableTxt+="<tr id='"+"tab"+i+"' class='"+"tab'>";
         						tableTxt+="<td id='"+"bronze3Id"+i+"' class='"+"bronze3Cl'>"+bronze3+"</td>";
         						tableTxt+="<td id='"+"silver3Id"+i+"' class='"+"silver3Cl'>"+silver3+"</td>";
         						tableTxt+="<td id='"+"gold3Id"+i+"' class='"+"gold3Cl'>"+gold3+"</td>";
         						tableTxt+="<td id='"+"nat3Id"+i+"' class='"+"nat3Cl'>"+nat3+"</td>";
         						tableTxt+="<td id='"+"bronze2Id"+i+"' class='"+"bronze2Cl'>"+bronze2+"</td>";
         						tableTxt+="<td id='"+"silver2Id"+i+"' class='"+"silver2Cl'>"+silver2+"</td>";
         						tableTxt+="<td id='"+"gold2Id"+i+"' class='"+"gold2Cl'>"+gold2+"</td>";
         						tableTxt+="<td id='"+"nat2Id"+i+"' class='"+"nat2Cl'>"+nat2+"</td>";
         						tableTxt+="<td id='"+"bronze1Id"+i+"' class='"+"bronze1Cl'>"+bronze1+"</td>";
         						tableTxt+="<td id='"+"silver1Id"+i+"' class='"+"silver1Cl'>"+silver1+"</td>";
         						tableTxt+="<td id='"+"gold1Id"+i+"' class='"+"gold1Cl'>"+gold1+"</td>";
         						tableTxt+="<td id='"+"nat1Id"+i+"' class='"+"nat1Cl'>"+nat1+"</td>";
         						tableTxt+="<td id='"+"cityId"+i+"' class='"+"cityCl'>"+city+"</td>";
         						tableTxt+="<td id='"+"yearId"+i+"' class='"+"yearCl'>"+year+"</td>";
         					} else {
         						tableTxt+="<tr id='"+"tab"+i+"' class='"+"tab'>";
         						tableTxt+="<td id='"+"yearId"+i+"' class='"+"yearCl'>"+year+"</td>";
         						tableTxt+="<td id='"+"cityId"+i+"' class='"+"cityCl'>"+city+"</td>";
         						tableTxt+="<td id='"+"nat1Id"+i+"' class='"+"nat1Cl'>"+nat1+"</td>";
         						tableTxt+="<td id='"+"gold1Id"+i+"' class='"+"gold1Cl'>"+gold1+"</td>";
         						tableTxt+="<td id='"+"silver1Id"+i+"' class='"+"silver1Cl'>"+silver1+"</td>";
         						tableTxt+="<td id='"+"bronze1Id"+i+"' class='"+"bronze1Cl'>"+bronze1+"</td>";
         						tableTxt+="<td id='"+"nat2Id"+i+"' class='"+"nat2Cl'>"+nat2+"</td>";
         						tableTxt+="<td id='"+"gold2Id"+i+"' class='"+"gold2Cl'>"+gold2+"</td>";
         						tableTxt+="<td id='"+"silver2Id"+i+"' class='"+"silver2Cl'>"+silver2+"</td>";
         						tableTxt+="<td id='"+"bronze2Id"+i+"' class='"+"bronze2Cl'>"+bronze2+"</td>";
         						tableTxt+="<td id='"+"nat3Id"+i+"' class='"+"nat3Cl'>"+nat3+"</td>";
         						tableTxt+="<td id='"+"gold3Id"+i+"' class='"+"gold3Cl'>"+gold3+"</td>";
         						tableTxt+="<td id='"+"silver3Id"+i+"' class='"+"silver3Cl'>"+silver3+"</td>";
         						tableTxt+="<td id='"+"bronze3Id"+i+"' class='"+"bronze3Cl'>"+bronze3+"</td>";
         					}
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         		});
         		sym.$("table").append(tableTxt); //Then attach the buttons:
         		$("#medaltable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px", 'width':'100%'});
         		$("#medaltable tr:odd").css({"background-color":"rgba(217,230,246,0.6)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$("#medaltable tr:even").css({"background-color":"rgba(183,211,238,0.6)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$(".tab").css({"border-color":"#fff222", "border":"1px", "border-style":"solid", 'height':'22px'});
         		$(".yearCl").css({'width':'20px', "font-weight":"bold", 'padding-right':'0px', 'padding-left':'5px', 'text-align':'left'});
         		$(".cityCl").css({'width':'90px', "font-style":"italic", 'padding-right':'2px', 'padding-left':'5px',"font-weight":"regular", "color":"#000", 'text-align':'left'});
         
         		for (var a=1; a<4; a++){
         			$(".nat"+a+"Cl").css({'width':'10px', "font-weight":"regular", 'padding-right':'0px', 'padding-left':'4px', 'text-align':'left'});
         			$(".gold"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(253,185,19,.8)"});
         			$(".silver"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(192,203,210,.8)"});
         			$(".bronze"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(245,200,160,.8)"});
         		}
         }
         
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	var colWidth = ($(".yearCl").width() + $(".cityCl").width()+17)
         
         	sym.$("auxBtnsMc").css({'top':sym.$('standTxt').height()+50+'px'});
         
         	for (var i=0;i<3; i++){
         		sym.getSymbol("auxBtnsMc").$("auxBtn"+i).css({'position':'relative','float':'right'});
         	}
         
         	sym.$("mask").css({'top':sym.$('standTxt').height()+50+'px'});
         
         	if(stageWidth<640){
         		sym.$("txt0").css({'left':'10px', 'width':$(".yearCl").width(), 'top':sym.$('standTxt').height()+80+'px'});
         		sym.$("txt1").css({'left':'16%', 'width':$(".cityCl").width(), 'top':sym.$('standTxt').height()+80+'px'});
         		sym.$("auxBtnsMc").css({'left':'0px', 'width':stageWidth +'px'});
         		sym.$("table").css({'top':sym.$('standTxt').height()+96+'px', 'height':600-sym.$('standTxt').height()-116+'px'});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		$(".nat2Cl").hide();
         		$(".gold2Cl").hide();
         		$(".silver2Cl").hide();
         		$(".bronze2Cl").hide();
         		$(".nat3Cl").hide();
         		$(".gold3Cl").hide();
         		$(".silver3Cl").hide();
         		$(".bronze3Cl").hide();
         		sym.$('mask').fadeOut(0);
         		btnClick();
         
         	}else{
         		sym.$("txt0").css({'left':'10px', 'width':$(".yearCl").width(), 'top':sym.$('standTxt').height()+100+'px', 'top':sym.$('standTxt').height()+60+'px'});
         		sym.$("txt1").css({'left':$(".yearCl").width()+10+'px', 'width':$(".cityCl").width(), 'top':sym.$('standTxt').height()+100+'px', 'top':sym.$('standTxt').height()+60+'px'});
         		sym.$("auxBtnsMc").css({'left':colWidth-7+'px', 'width':stageWidth-colWidth -11 +'px'});
         		sym.$("table").css({'top':sym.$('standTxt').height()+80+'px', 'height':600-sym.$('standTxt').height()-98+'px'});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		$(".nat2Cl").show();
         		$(".gold2Cl").show();
         		$(".silver2Cl").show();
         		$(".bronze2Cl").show();
         		$(".nat3Cl").show();
         		$(".gold3Cl").show();
         		$(".silver3Cl").show();
         		$(".bronze3Cl").show();
         		sym.$('mask').fadeIn(0);
         		resetAux();
         	}
         	setStyle();
         	checkRTL();
         	closeSource();
         }
         
         //********************************************************************************************************
         // CHECK RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		var stageWidth=sym.$("Stage").width();
         		sym.getSymbol("styleHead").$("headlineTxt").css({'left':'0px','text-align':'right'});
         		sym.getSymbol("styleHead").$("headArt").css({'left':'0px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.$("standTxt").css({'left':'0px','text-align':'right', 'padding-left':'5px'});
         		var colWidth = ($(".yearCl").width() + $(".cityCl").width()+17)
         		for (var i=0;i<3; i++){
         			sym.getSymbol("auxBtnsMc").$("auxBtn"+i).css({'position':'relative','float':'left'});
         		}
         		if(stageWidth<640){
         			sym.$("txt0").css({'text-align':'right', 'left':stageWidth - $(".yearCl").width()-20+'px', 'width':$(".yearCl").width(), 'top':sym.$('standTxt').height()+80+'px'});
         			sym.$("txt1").css({'text-align':'right', 'left':'45%', 'width':$(".cityCl").width(), 'top':sym.$('standTxt').height()+80+'px'});
         			sym.$("auxBtnsMc").css({'left':'0px', 'width':stageWidth+2 +'px'});
         		} else {
         			sym.$("txt0").css({'text-align':'right', 'left':stageWidth-$(".yearCl").width()-20+'px', 'width':$(".yearCl").width(), 'top':sym.$('standTxt').height()+100+'px', 'top':sym.$('standTxt').height()+60+'px'});
         			sym.$("txt1").css({'text-align':'right', 'left':stageWidth-($(".yearCl").width()+$(".cityCl").width())-30+'px', 'width':$(".cityCl").width(), 'top':sym.$('standTxt').height()+60+'px'});
         			sym.$("auxBtnsMc").css({'left':'0px', 'width':stageWidth-colWidth -8 +'px'});
         		}
         		for (var a=1; a<4; a++){
         			$(".nat"+a+"Cl").css({'width':'10px', "font-weight":"regular", 'padding-right':'4px', 'padding-left':'0px', 'text-align':'right'});
         			$(".gold"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(253,185,19,.8)"});
         			$(".silver"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(192,203,210,.8)"});
         			$(".bronze"+a+"Cl").css({'width':'10px', "font-weight":"bold", 'padding-right':'4px', 'padding-left':'4px', 'text-align':'center', "background-color":"rgba(245,200,160,.8)"});
         		}
         		$(".yearCl").css({'width':'20px', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'0px', 'text-align':'right'});
         		$(".cityCl").css({'width':'90px', "font-style":"italic", 'padding-right':'5px', 'padding-left':'0px',"font-weight":"regular", "color":"#000", 'text-align':'right'});
         	}
         }
         
         //********************************************************************************************************
         // AUX BUTTONS
         //********************************************************************************************************
         var outAux  = {"background-color":"#3d66b8"};
         var overAux = {"background-color":"#da0000"};
         auxArray = []; //the array that will hold references to the buttons.
         
         for (var a=0; a<3; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         		closeSource();
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clicked = auxNo;
         		resetAux();
         		btnClick();
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         
         
         function btnClick(){	
         	sym.getSymbol("auxBtnsMc").getSymbol("auxBtn"+clicked).$("bg").css(overAux);
         	for (var i=1; i<4; i++){
         		$(".nat"+(i)+"Cl").hide();
         		$(".gold"+(i)+"Cl").hide();
         		$(".silver"+(i)+"Cl").hide();
         		$(".bronze"+(i)+"Cl").hide();
         	}
         	$(".nat"+(clicked+1)+"Cl").show();
         	$(".gold"+(clicked+1)+"Cl").show();
         	$(".silver"+(clicked+1)+"Cl").show();
         	$(".bronze"+(clicked+1)+"Cl").show();
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         initSize();
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34555");