/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var slide = 0;
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var standTxt = {"color":"black", "background-color":"#ccc", "height":"auto", "padding":"10px"};
         	var blueTxt = {"color":"white", "background-color":"#00579f", "height":"auto", "padding":"10px", 'font-size':'16px', 'line-height':'18px'};
         	var blueTxt0 = {"color":"white", "background-color":"#00579f", "height":"auto", "padding":"10px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css(standTxt);
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<5; i++){
         		txt[i] = sym.getSymbol("sceneMc0").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[5] = sym.getSymbol("sceneMc1").$("txt5").css(blueTxt);
         	for (var i=6; i<12; i++){
         		txt[i] = sym.getSymbol("sceneMc2").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=12; i<14; i++){
         		txt[i] = sym.getSymbol("sceneMc3").$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	var txtArr=[], drug=[], drugEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34536.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<14; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			$(xml).find("drugs").each(function(){
         				var $drug=$(this);
         				drugEvents.push($drug);
         			});
         			loadDrugs();
         			sym.getSymbol("sceneMc0").$("txt0").css(blueTxt0);
         			sym.getSymbol("sceneMc1").$("txt5").css(blueTxt);
         			sym.getSymbol("sceneMc2").$("txt11").css(blueTxt);
         			sym.getSymbol("sceneMc3").$("txt13").css(blueTxt);
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // TABLE
         //********************************************************************************************************
         function loadDrugs() {
         		var $events=drugEvents[0].find('drug');
         		sym.getSymbol("sceneMc1").$("table").empty();
         		var i=0;
         		var tableTxt="<table id='datestable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         				var $type=$event.find("type");
         				$type.each(function(){
         					var $type=$(this);
         					var image=$type.find("image").text();
         					var txt=$type.find("txt").text();
         					tableTxt+="<tr id='"+"drug"+i+"' class='"+"drug'>";
         					tableTxt+="<td id='"+"imageId"+i+"' class='"+"imageCl'>"+image+"</td>";
         					tableTxt+="<td id='"+"txtId"+i+"' class='"+"txtCl'>"+txt+"</td>";
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         		});
         		sym.getSymbol("sceneMc1").$("table").append(tableTxt); //Then attach the buttons:
         		$("#datestable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse', 'width':'100%'});
         		$("#datestable tr:odd").css({"background-color":"rgba(0,0,0,0.1.5)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$("#datestable tr:even").css({"background-color":"rgba(0,0,0,0.1)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$(".drug").css({'height':'13px', 'padding':'50px', "vertical-align":"top"});
         		$(".imageCl").css({'width':'10%', 'padding-left':'5px', 'padding-right':'5px', 'text-align':'left'});
         		$(".txtCl").css({'width':'90%', "font-weight":"regular", "color":"#000", 'text-align':'left', 'line-height':'14px', 'padding':'5px'});
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("standBtn").css({"left":stageWidth-40+"px"});
         	sym.$("standTxt").css({"width":stageWidth-20+"px"});
         	sym.$("downBtn").css({"left":stageWidth/2-50+"px"});
         	sym.$("upBtn").css({"left":stageWidth/2+0+"px"});
         	sym.$("downBtnOut").css({"left":stageWidth/2-50+"px"});
         	sym.$("upBtnOut").css({"left":stageWidth/2+0+"px"});
         	sym.getSymbol("sceneMc1").$("txt5").css({"top":"0px", "width":stageWidth-20+"px"});
         	sym.getSymbol("sceneMc2").$("txt11").css({"top":"0px", "width":stageWidth-20+"px"});
         	sym.getSymbol("sceneMc3").$("txt13").css({"top":"0px", "width":stageWidth-20+"px"});
         	sym.getSymbol("sceneMc1").$("table").css({"top":sym.getSymbol("sceneMc1").$("txt5").height()+20+"px", 'height':542-sym.getSymbol("sceneMc1").$("txt5").height()-20+"px"});
         
         	if (stageWidth<480){
         		sym.$("standBtn").css({"left":stageWidth-40+"px"});
         		sym.getSymbol("sceneMc0").$("txt0").css({"top":"0px", "width":stageWidth-20+"px"});
         		sym.$("standTxt").css({"top": - sym.$("standTxt").height()+"px"});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		closeStand();
         	}else{
         		sym.$("standBtn").css({"left":stageWidth+"px"});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("sceneMc0").$("txt0").css({"top":sym.$("standTxt").height()+20+"px", "width":stageWidth-20+"px"});
         		sym.$("standTxt").css({"top":"40px"});
         		if (slide == 0){
         			sym.$("standTxt").stop().animate ({top:40}, 200, 'easeOutCubic');
         		} else {
         			closeStand();
         		}
         	}
         	setStyle();
         }
         
         //********************************************************************************************************
         // STAND BUTTON
         //********************************************************************************************************
         var standIn = false;
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (standIn == false){
         		sym.$("standBtn").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         		sym.$("standTxt").stop().animate ({top:40}, 200, 'easeOutCubic');
         		standIn = true;
         	}else{
         		closeStand();
         	}
         });
         function closeStand(){
         	sym.$("standBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         	sym.$("standTxt").stop().animate ({top:-200}, 200, 'easeOutCubic');
         	standIn = false;
         }
         
         //********************************************************************************************************
         // SLIDE
         //********************************************************************************************************
         function slideIt(){
         	sym.$("downBtn").fadeIn(0);
         	sym.$("upBtn").fadeIn(0);
         	if (slide>=0){
         		sym.$("upBtn").fadeOut(0);
         		slide = 0;
         	}
         	if (slide<=-3){
         		slide = -3;
         		sym.$("downBtn").fadeOut(0);
         	}
         	for (var i=0; i<4; i++){
         		sym.$("sceneMc"+i).stop().animate ({top:542*(slide+i)+40}, 1000, 'easeOutCubic');
         	}
         	initSize();
         }
         slideIt();
         
         //********************************************************************************************************
         // SLIDE BUTTONS
         //********************************************************************************************************
         sym.$("downBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	slide--;
         	slideIt();
         	});
         sym.$("upBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	slide++;
         	slideIt();
         	});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("sceneMc0").stop(stageWidth*10);
         	sym.getSymbol("sceneMc2").stop(stageWidth*10);
         	sym.getSymbol("sceneMc3").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("downBtn").fadeOut(0);
         		sym.$("upBtn").fadeOut(0);
         		sym.$("downBtnOut").fadeOut(0);
         		sym.$("upBtnOut").fadeOut(0);
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	slideIt();
         	sym.$("downBtnOut").fadeIn(0);
         	sym.$("upBtnOut").fadeIn(0);
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'sceneMc1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("sceneMc0");
   //Edge symbol end:'sceneMc0'

   //=========================================================
   
   //Edge symbol: 'pointer'
   (function(symbolName) {   
   
   })("pointer");
   //Edge symbol end:'pointer'

   //=========================================================
   
   //Edge symbol: 'bottle1'
   (function(symbolName) {   
   
   })("bottle1");
   //Edge symbol end:'bottle1'

   //=========================================================
   
   //Edge symbol: 'bottle1_1'
   (function(symbolName) {   
   
   })("bottle2");
   //Edge symbol end:'bottle2'

   //=========================================================
   
   //Edge symbol: 'downBtn'
   (function(symbolName) {   
   
   })("downBtn");
   //Edge symbol end:'downBtn'

   //=========================================================
   
   //Edge symbol: 'sceneMc1'
   (function(symbolName) {   
   
   })("sceneMc1");
   //Edge symbol end:'sceneMc1'

   //=========================================================
   
   //Edge symbol: 'sceneMc1_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("sceneMc2");
   //Edge symbol end:'sceneMc2'

   //=========================================================
   
   //Edge symbol: 'sceneMc2_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("sceneMc3");
   //Edge symbol end:'sceneMc3'

   //=========================================================
   
   //Edge symbol: 'downBtn_1'
   (function(symbolName) {   
   
      })("downBtnOut");
   //Edge symbol end:'downBtnOut'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34536");