/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var key;
         	var keyTxt = sym.$("key").css({"pointer-events":"none", "background-color":"rgba(0,0,0,1)","width":"auto", "padding":"4px"});
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         //********************************************************************************************************
         // ADD DATES
         //********************************************************************************************************
         tabArray=[]
         	
         for (var i = 0; i < 17; i++){
         	var mySymbolObject = sym.createChildSymbol("tab"+i, "scrollMc");
         	mySymbolObject.setVariable("id", i);
         	tabArray.push(mySymbolObject);
         	tabArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         }
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var date=[];
         	var capt=[];
         	for (var i = 0; i < tabArray.length; i++){
         		date[i] = tabArray[i].$("dateTxt").css({"pointer-events":"none"});
         		capt[i] = tabArray[i].$("capTxt").css({"pointer-events":"none", "height":"auto"});
         	}
         	var dateArr=[];
         	var captArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34491.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			key = $(xml).find('key').text();
         			keyTxt.html(key);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<17; i++){
         				captArr[i]=$(xml).find('capt'+i).text();
         				capt[i].html(captArr[i]);
         				dateArr[i]=$(xml).find('date'+i).text();
         				date[i].html(dateArr[i]);
         				capt[i].css({'font-size':fontSize});
         				capt[i].css({'line-height':lineHeight});
         			}
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         	
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	closeSource();
         	var stageWidth=sym.$("Stage").width();
         	tabArray[0].$("capTxt").css({"width":stageWidth-224 + "px"});
         
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<360){
         		for (var i = 0; i < tabArray.length; i++){
         			tabArray[i].$("dateTxt").css({"text-align":"center", "width":"305px"});
         			tabArray[i].$("dateBox").css({"width":stageWidth+"px", "height":"40px"});
         		}
         		tabArray[0].getSymbolElement().css({"min-height":"140px", "max-height":tabArray[0].$("capTxt").height() + 60+ "px"});
         		tabArray[1].getSymbolElement().css({"height":tabArray[1].$("capTxt").height() + tabArray[1].$("tabPic1").height()+60+"px"});
         		tabArray[2].getSymbolElement().css({"height":tabArray[2].$("capTxt").height() + tabArray[2].$("tabPic2").height()+60+"px"});
         		for (var i = 3; i < 7; i++){
         			tabArray[i].getSymbolElement().css({"height":tabArray[i].$("capTxt").height() + 60 + "px", "min-height":"40px"});
         		}
         		tabArray[7].getSymbolElement().css({"height":tabArray[7].$("capTxt").height() + 60 + "px", "min-height":"340px"});
         		tabArray[8].getSymbolElement().css({"height":tabArray[8].$("capTxt").height() + 60 + "px", "min-height":"220px"});
         		tabArray[9].getSymbolElement().css({"height":tabArray[9].$("capTxt").height() + 60 + "px", "min-height":"40px"});
         		tabArray[10].getSymbolElement().css({"height":tabArray[10].$("capTxt").height() + 60 + "px", "min-height":"340px"});
         		tabArray[11].getSymbolElement().css({"height":tabArray[11].$("capTxt").height() + 60 + "px", "min-height":"340px"});
         		for (var i = 12; i < 16; i++){
         			tabArray[i].getSymbolElement().css({"height":tabArray[i].$("capTxt").height() + 60 + "px", "min-height":"40px"});
         		}
         		tabArray[16].getSymbolElement().css({"height":tabArray[11].$("capTxt").height() + 10 + "px", "min-height":"100px"});
         	} else {
         		for (var i = 0; i < tabArray.length; i++){
         			tabArray[i].$("dateTxt").css({"text-align":"right", "width":"90px"});
         			tabArray[i].$("dateBox").css({"width":"94px", "height":"100%"});
         		}
         		tabArray[0].getSymbolElement().css({"min-height":"105px", "max-height":tabArray[0].$("capTxt").height() + 15 + "px"});
         		tabArray[1].getSymbolElement().css({"height":tabArray[1].$("capTxt").height() + tabArray[1].$("tabPic1").height()+15+"px"});
         		tabArray[2].getSymbolElement().css({"height":tabArray[2].$("capTxt").height() + tabArray[2].$("tabPic2").height()+15+"px"});
         		for (var i = 3; i < 7; i++){
         			tabArray[i].getSymbolElement().css({"height":tabArray[i].$("capTxt").height() + 20 + "px", "min-height":"40px"});
         		}
         		tabArray[7].getSymbolElement().css({"height":tabArray[7].$("capTxt").height() + 15 + "px", "min-height":"300px"});
         		tabArray[8].getSymbolElement().css({"height":tabArray[8].$("capTxt").height() + 15 + "px", "min-height":"180px"});
         		tabArray[9].getSymbolElement().css({"height":tabArray[9].$("capTxt").height() + 20 + "px", "min-height":"40px"});
         		tabArray[10].getSymbolElement().css({"height":tabArray[10].$("capTxt").height() + 15 + "px", "min-height":"300px"});
         		tabArray[11].getSymbolElement().css({"height":tabArray[11].$("capTxt").height() + 15 + "px", "min-height":"300px"});
         		for (var i = 12; i < 16; i++){
         			tabArray[i].getSymbolElement().css({"height":tabArray[i].$("capTxt").height() + 20 + "px", "min-height":"40px"});
         		}
         		tabArray[16].getSymbolElement().css({"height":tabArray[11].$("capTxt").height() + 0 + "px", "min-height":"100px"});
         	}
         	setStyle();
         }
         
         function timelineScroll(){
         	var scrollPos = sym.$("scrollMc").scrollTop()+1;
         	var tableHeight = sym.$("scrollMc")[0].scrollHeight;
         	var tabHeight = sym.$("scrollMc").height();
         	
         	if (scrollPos >= (tableHeight-tabHeight)){
         		sym.$("transfer")[0].play();
         	}
         
         	sym.stop(scrollPos);
         	sym.$("beep")[0].play();
         
         }	
         sym.$("scrollMc").on('scroll',timelineScroll);	
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	for (var i = 0; i < tabArray.length; i++){
         		tabArray[i].stop(stageWidth*10);
         	}
         	sym.getSymbol("styleHead").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         sym.$("scrollMc").css({'overflow-x':'hidden'});
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.$("borg")[0].play();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 1000, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 500, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'tab'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tab0");
   //Edge symbol end:'tab0'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'tab_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3580, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tab1");
   //Edge symbol end:'tab1'

   //=========================================================
   
   //Edge symbol: 'tab1_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tab2");
   //Edge symbol end:'tab2'

   //=========================================================
   
   //Edge symbol: 'tab2_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab3");
   //Edge symbol end:'tab3'

   //=========================================================
   
   //Edge symbol: 'tab3_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab4");
   //Edge symbol end:'tab4'

   //=========================================================
   
   //Edge symbol: 'tab4_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab5");
   //Edge symbol end:'tab5'

   //=========================================================
   
   //Edge symbol: 'tab5_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab6");
   //Edge symbol end:'tab6'

   //=========================================================
   
   //Edge symbol: 'tab0_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab7");
   //Edge symbol end:'tab7'

   //=========================================================
   
   //Edge symbol: 'tab7_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab8");
   //Edge symbol end:'tab8'

   //=========================================================
   
   //Edge symbol: 'tab6_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab9");
   //Edge symbol end:'tab9'

   //=========================================================
   
   //Edge symbol: 'tab8_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab10");
   //Edge symbol end:'tab10'

   //=========================================================
   
   //Edge symbol: 'tab8_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab11");
   //Edge symbol end:'tab11'

   //=========================================================
   
   //Edge symbol: 'tab9_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab12");
   //Edge symbol end:'tab12'

   //=========================================================
   
   //Edge symbol: 'tab12_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab13");
   //Edge symbol end:'tab13'

   //=========================================================
   
   //Edge symbol: 'tab13_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab14");
   //Edge symbol end:'tab14'

   //=========================================================
   
   //Edge symbol: 'tab14_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab15");
   //Edge symbol end:'tab15'

   //=========================================================
   
   //Edge symbol: 'tab15_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("tab16");
   //Edge symbol end:'tab16'

   //=========================================================
   
   //Edge symbol: 'tableMC'
   (function(symbolName) {   
   
   })("tableMC");
   //Edge symbol end:'tableMC'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34491");