/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var eventCal=0;
         	var eventsComplete=0;//Moved Jul12
         	var noEvents=0;//Aug7
         	var headline, headlinemob0, headlinemob1, stand0, stand1, source;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var gn = 34462;
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var stageWidth=sym.$("Stage").width();
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         //********************************************************************************************************
         // SCROLLING
         //********************************************************************************************************
         sym.getSymbol("eventsMc").$("sports").css({'overflow-x':'hidden'});
         var scrollPos;
         function timelineScroll(num) {
         	sym.getSymbol("eventsMc").$("sports").scrollTop(30*num);
         }
         function resetBtns(){
         	for (var i=0; i<olySports.length; i++){
         		$(".sportMob").fadeOut(0);
         		$(".evResults").fadeOut(0);
         		$("#sport"+i).animate ({top:30 * i}, 0);
         		var bg=(i%2==0)?'rgba(114,206,255,0.15)':'rgba(255,255,255,1)';
         		$("#sport"+i).css({"background-color":bg});
         		$("#name"+i+ ", #ico"+i).css({"background-color":"rgba(255,255,255,0)","color":"#000", "font-weight":"normal"});
         		//$(".sportMob").css({'border-bottom':0});
         		$(".evResults").css({'border-bottom':0});
         	}
         }
         var showSport = function(sportNo){//show phase timing graph
         	return function(e){
         		var stageWidth=sym.$("Stage").width();
         		sym.getSymbol("eventsMc").$("sports").stop().animate({scrollTop:(31*sportNo)}, 0);
         		resetBtns();
         		eventCal=sportNo;
         		getResults(sportNo);
         		$("#name"+sportNo+ ", #ico"+sportNo).css({"background-color":"#f15a24","color":"#fff", "font-weight":700});
         		$("#sport"+sportNo).css({"background-color":"rgba(255,150,0,0.3)"});
         		//$("#mob"+sportNo).css({'border-bottom':'1px solid rgb(0,0,0)'});
         		$("#ev"+sportNo).css({'border-bottom':'1px solid rgb(0,0,0)'});
         		$("#ev"+sportNo).fadeIn(0)
         		if(stageWidth<600){
         			$("#mob"+sportNo).fadeIn(0);
         		}
         		e.preventDefault();
         		e.stopPropagation();
         	}
         };
         var showLatest = function(sportNo){//show latest medals
         	return function(e){
         		var pos=$("#eventToday"+sportNo).position().top;
         		//sym.getSymbol("latestMc").$("todayTable").stop().animate({scrollTop:pos+"px"}, 0);
         		$(".eventTab").addClass("hidden");
         		$("#eventToday"+sportNo).removeClass("hidden");
         		e.preventDefault();
         		e.stopPropagation();
         	}
         };
         //********************************************************************************************************
         //----------------------------------------- DATE FUNCTIONS -----------------------------------------------
         var d=new Date();
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     var thisDate = new Date(parseInt(dateTxt, 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         
         var oneday = 1000*60*60*24;
         var startDate = new Date("August 5, 2016 13:55:00 GMT+0000 (GMT)"); //first medals awarded
         var olyDate = new Date();
         var endDate = new Date("August 22, 2016 00:00:01 GMT+0000 (GMT)");
         var endTime = endDate.getTime();
         var startTime = startDate.getTime();
         var olyTime = olyDate.getTime();
         var todayTime =(olyTime>endTime)?endTime:olyTime;
         var dateToday=(olyTime>=startTime)?Math.floor((todayTime-startTime)/oneday)+1:Math.floor((todayTime-startTime)/oneday);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var daystring, calTable, countryCaps, countryCapShort, sportNames, eventNames, medalCols, dateFormat;
         	var txt=[], txtArr=[], olySports=[], olyDates=[], olyOrder=[], dateArr = [], medalDateArr=[], screenArr=["latestMc","medTableMc","eventsMc"], medalArray = [];
         	for (var t=26;t<30;t++){
         		txt[t]=sym.getSymbol("latestMc").$("txt"+t);
         	}
         	var startDay = 3, endDay = 21;
         	while(startDay <= endDay){
         		dateArr.push(startDay++);
         	}
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gn+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob0 = $(xml).find('headlinemob0').text();
         			headlinemob1 = $(xml).find('headlinemob1').text();
         			headlinetxtmob.html(headlinemob0);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			stand0 = $(xml).find('stand0').text();
         			stand1 = $(xml).find('stand1').text();
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			dateFormat=$(xml).find('dateformat').text();//for different date formats
         			if(RTL==true){
         					headlinetxt.attr({'dir':'rtl'});
         					headlinetxtmob.attr({'dir':'rtl'});
         			}
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         			} // MENU TEXT END
         			menuTxt.html(menuArr[0]);
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<31; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				if(i>25&&i<30){
         					txt[i].html(txtArr[i]);
         				}
         			}
                  medalCols=txtArr[22].split(";");
                  for (var m=0;m<medalCols.length;m++){
         				sym.getSymbol('medTableMc').getSymbol('medalHd'+m).$('medalTxt').html(medalCols[m]);
                  }
         			olyDate>=startDate&&olyDate<=endDate?sym.getSymbol("latestMc").$("latestTxt").html(txtArr[24]):sym.getSymbol("latestMc").$("latestTxt").html(txtArr[30]);//Aug21
           			var stringDay = txtArr[19];
         			daystring = stringDay.split(';');//makes array of day names
         			var monthsArr = $(xml).find('months').text();
                  months=monthsArr.split(";");
         			var sportstring = $(xml).find('sports').text();
         			sportNames = sportstring.split(';');
         			var eventstring = $(xml).find('events').text();
         			eventNames = eventstring.split(';');
         			var countryNames = $(xml).find('countries').text();
         			countryCaps = countryNames.split(';');
         			var shortNames = $(xml).find('ol_abbreviations').text();
         			countryCapShort = shortNames.split(';');
         			//********************************************************************************************************
         			//SPORT TABLE
         			$(xml).find("sport").each(function(){
         				var $event=$(this);
         				olyOrder.push($event.attr('id'));
         				var eventname=$event.find("event").text();
         				olySports.push(eventname);
         				var eventdates=$event.find("dates").text();
         				var dateString=eventdates.split(";").map(Number);
         				olyDates.push(dateString);
         				var medalString=$event.find("medals").text();
         				var medalDates=medalString.split(";").map(Number);
         				medalDateArr.push(medalDates);
         			});
         			makeTable();
         			//********************************************************************************************************
         		},
            complete:function(){
         			initSize();
            }
         	}); // END XML
         function makeTable(){
         				var weekdays=0;
         				var txtArrStart=0;
         				var stand=stand0;
         				var totalDays=19;
         				var eventList=olySports;
         				var numOfDays=21;
         				var startCal=1;
         				var eventDates=olyDates;
         				var allDates=dateArr;
         				var iconImg="sportIcons";
         				var order=olyOrder;
         				var medals=medalDateArr
         			var dateTable="<div class='sportTable dayHeader'>";
         			dateTable+="<div class='eventdates' ><div class='mm'>"+stand+"</div>";
         			for (var d=0;d<totalDays;d++){
         				dateTable+="<div class='dd'>"+txtArr[d+txtArrStart]+"</div>";
         			}
         			dateTable+="</div></div>";
         			var tableTxt="<table class='sportTable'>";
         			for (var i=0;i<eventList.length;i++){ //create a row for each sport
         				//build weekly calendar
         				var counter=startCal;
         				var weekdays2=0;
         				var weekContent="";
         				var weekBody="";
         				//while (weekdays>0){// leave blank for days of previous month
         				//	weekContent += "<div class='monthPre'></div>";
         				//	weekdays--;
         				//}
         				while (counter <= numOfDays){
         					if (weekdays2 > 6){ // start new line after 1 week.
         						weekdays2 = 0;
         						weekContent += "</div><div class='weekdays'>";
         					}	
         					var bgCol=(medals[i].indexOf(counter)>=0)?"rgba(255,200,0,0.3)":(eventDates[i].indexOf(counter)>=0)?"rgba(114,206,255,0.3)":"rgba(255,255,255,0)";
         					var fontCol=(counter>weekdays+2)?"rgb(0,0,0)":"rgb(150,150,150)";
         					weekContent +="<div id='s"+i+"dd"+counter+"' class='month' style='background-color:"+bgCol+";color:"+fontCol+"'>"+counter+"</div>"; 
         					weekdays2++;
         					counter++;
         				}
         				weekBody +="<div class='wcalendar' id='mobcal"+i+"' width='100%'><div class='daysOfWeek'>";
         				for (var d=0;d<7;d++){
         					weekBody +="<div class='wdays'>"+daystring[d]+"</div>";
         				}
         				weekBody +="</div>";
         				weekBody += "<div class='weekdays'>";
         				weekBody += weekContent;
         				weekBody += "</div></div>";
         				//end build
         
         				var bg=(i%2==0)?'rgba(255,255,255,0)':'rgba(114,206,255,0.15)';
         				tableTxt+="<tr id='sport"+i+"' class='sport'  style='background-color:"+bg+"'><td class='sporticon' id='ico"+i+"' style='background-position-y:"+(-30*order[i])+"px'></td>";
         				tableTxt+="<td id='name"+i+"' class='sportName'>"+eventList[i]+"</td>";
         				for (var dd=0;dd<totalDays;dd++){//create a cell for each date
         					tableTxt+="<td id='sport"+i+"_"+dd+"' class='sportdates'>";
         					if(medals[i].indexOf(allDates[dd])>=0){//put icon in cell for each event date
         						tableTxt+="<img src='images/medal.png'>";
         					}else	if(eventDates[i].indexOf(allDates[dd])>=0){//put icon in cell for each event date
         						tableTxt+="<img src='images/icon.png'>";
         					}
         					tableTxt+="</td>";
         				}
         				tableTxt+="</tr><tr class='sportMob' id='mob"+i+"'><td colspan='21'>"+weekBody+"</td></tr>";
         				tableTxt+="</tr><tr class='evResults' id='ev"+i+"'><td colspan='21' id='evresults"+i+"'></td></tr>";
         			}
         			tableTxt+="</table>";
         			sym.getSymbol("eventsMc").$("sports").append(tableTxt);
         			sym.getSymbol("eventsMc").$("dates").append(dateTable);
         			$(".sportTable").css({"display":"table","width":"100%","font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse'});
         			//$(".sportTable tr:odd").css({"background-color":"#fff"});
         			$(".sport").css({'display':'table-row','height':'28px','border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         			$(".eventdates").css({'display':'table-row'});
         			$(".sporticon").css({'display':'table-cell','width':'5%','min-width':'30px','background-image': 'url(images/'+iconImg+'.png)','height':'28px','overflow':'hidden','background-repeat':'no-repeat','cursor':'pointer'});
         			$(".sportName").css({'display':'table-cell','width':'28%','min-width':'120px','padding-left':'3px', 'font-size':'15px'});
         			$(".sportdates, .dd").css({'display':'table-cell','width':'3.5%','min-width':'19px','text-align':'center','border-color':"rgb(150,150,150)","border-width":"0 1px","border-style":"solid","pointer-events":"none",'line-height':"16px"});
         			$(".sportdates").css({'padding': '5px 0px 0px'});
         			$(".sportdates img").css({'vertical-align':'middle'});
         			$(".mm").css({'display':'table-cell','width':'33%','min-width':'150px','padding-left':'5px','font-size':stanSize});
         			$(".dayHeader").css({'position':'absolute','top':'0px'});
         			$(".sportMob").css({'display':'table-row','background-color':'#fff','width':'100%'});
         			sym.$('dates').css({'overflow-y':'scroll'});
         			$(".sportMob").fadeOut(0); $(".evResults").fadeOut(0);
         			$(".daysOfWeek, .weekdays").css({'display':'table-row'});
         			$(".month, .monthPre, .wdays").css({'display':'table-cell','width':'14.25%','vertical-align':'middle','border':'1px solid rgba(255,150,0,0.3)'});
         			$(".wcalendar").css({'display':'table','width':'100%','margin':'3px 0px','font-family':'pragmatica-web,arial,sans-serif','font-size':'12px','border-collapse':'collapse','text-align':'center','background-color':'rgb(255,255,255)'});
         			$('.weekdays').css({'height':'30px'});
         			$(".rtl").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         			if(RTL==true){
         				$(".sportTable, .wcalendar, .sportName, .mm, .dd, .wdays, .daysOfWeek, .weekdays").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         				$(".sportName, .mm").css({'text-align':'right', 'padding-right':'3px'});
         				$('.month').css({'font-size':'16px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         				$(".sportName, .mm").attr({'dir':'rtl'});
         			}else{
         				$(".month").css({'font-size':'16px'});
         			}
         			for (var n=0;n<eventList.length;n++){
         				$("#ico"+n).css({'background-position':'0px '+(-30*order[n])+'px'});//for Firefox
         				$("#ico"+n).on('click',showSport(n));
         				$("#name"+n).css({'cursor':'pointer'});
         				$("#name"+n).on('click',showSport(n));
         			}
         }
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         var menuArray = [];//the array that will hold references to the buttons.
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		resetmenu();
         		for(var i=0;i<menuArray.length;i++){
         			if (i==menuNo){
         				clicked = menuNo;			
         				sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         				sym.getSymbol("menuBtnsMc").$("menuTxt").html(menuArr[menuNo]);
         				sym.$(screenArr[menuNo]).fadeIn(300);
         				if(menuNo==1){
         					olyDate>startDate?getMedals(0):getMedals(1);
         				}
         			}else{
         				sym.$(screenArr[i]).fadeOut(300);
         			}
         		}
         		initSize();	
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	stageWidth=sym.$("Stage").width();
         	var noOfBtns=3, btnWidth=40, btnHeight=40;//change as necessary
         	var menuTxtMove=(mob<1)?(noOfBtns*btnWidth)+5:btnWidth+5	
         	var leftright=	(RTL==false)?(menuTxt.css({"text-align":"right", "right":menuTxtMove+"px"}),"'right','0px'"):
         	(menuTxt.css({"text-align":"left", "left":menuTxtMove+"px"}),"'left','0px'");
         	sym.$("menuBtnsMc").css(leftright);
         	switch(mob){
         		case (0)://hide
         			sym.$("menuBtnMob").stop().animate({top:-1*btnHeight}, 0);
         			for (var s=0; s<noOfBtns; s++){ 
         				RTL==false?sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, right:((noOfBtns-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic'):
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, left:((noOfBtns-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic');
         				}
         		break;
         		case (1)://closed
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			mobOpen = false;
         			for (var s=0; s<noOfBtns; s++){ 
         				RTL==false?sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, right:0}, 200, 'easeOutCubic'):
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':0, left:0}, 200, 'easeOutCubic')
         				}
         		break;
         		case (2)://open
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			mobOpen = true;
         			for (var s=0; s<noOfBtns; s++){ 
         			RTL==false?sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':(s+1)*btnHeight, right:0}, 200, 'easeOutCubic'):
         			sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({'top':(s+1)*btnHeight, left:0}, 200, 'easeOutCubic');
         			}
         		break;
         	}
         }
         //********************************************************************************************************
         // MEDAL BUTTONS
         //********************************************************************************************************
         for (var m=0; m<2; m++){
         	medalArray.push(m);
         }
         function resetmedals(){
         	for (var m=0; m<medalArray.length; m++){
         		sym.getSymbol("medTableMc").getSymbol("medalBtn" + m).$("bg").css(grey);
         	}
         }
         resetmenu();
         // MENU CLICK
         var medalNumber;
         var medalBtnClick = function(medalNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		resetmedals();
         		medalNumber=medalNo;
         		for(var i=0;i<medalArray.length;i++){
         			if (i==medalNo){
         				sym.getSymbol("medTableMc").getSymbol("medalBtn" + medalNo).$("bg").css(red);
         				getMedals(medalNo);
         			}else{
         
         			}
         		}
         	};
         };
         for (var m=0;m<medalArray.length;m++){
         	sym.getSymbol("medTableMc").$("medalBtn"+m).on('touchstart click',medalBtnClick(m));
         	sym.getSymbol("medTableMc").$("medalBtn"+m).css({'cursor':'pointer'});
         }
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("latestMc").stop(stageWidth*10);
         	sym.getSymbol("medTableMc").$("waiting").css({'left':(stageWidth-120)/2+"px"});
         	if (eventsComplete>0&&olyTime<=endTime){for (var i=26; i<30; i++){ txt[i].fadeOut(0); }}//Jul12
         	if(stageWidth<800){
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         		for (var i=0;i<3;i++){
         			sym.getSymbol("medTableMc").getSymbol("medalHd"+i).$("medalTxt").fadeOut(0);
         		}
         	}else{
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         		for (var i=0;i<3;i++){
         			sym.getSymbol("medTableMc").getSymbol("medalHd"+i).$("medalTxt").fadeIn(0);
         		}
         	}
         	var mobhead=(clicked==0)?headlinemob0:headlinemob1;
         	if(stageWidth<600){
         		$(".dd, .sportdates").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(mobhead);
         		$("#mob"+eventCal).fadeIn(0);
         		//$("#mob"+eventCal).css({'border-bottom':'1px solid rgb(0,0,0)'});
         		$("#name"+eventCal+", #ico"+eventCal).css({"background-color":"#f15a24","color":"#fff", "font-weight":700});
         		$("#sport"+eventCal).css({"background-color":"rgba(255,150,0,0.3)"});
         	}else{
         		$(".dd, .sportdates").fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		$(".sportMob").fadeOut(0);
         		//$(".sportMob").css({'border-bottom':0});
         	}
         	if (stageWidth<480){
         		mob = 1;
         		sym.getSymbol("medTableMc").$("medalTot").fadeOut(0);
         		sym.getSymbol("latestMc").$("schedTxt").fadeOut(0);//Aug6
         		$(".resultTable").css({'width':'98%','margin':'5px 1%'});//Aug8
         		//sym.getSymbol("medTableMc").$("medalTxt").fadeOut(0);
         		//sym.getSymbol("medTableMc").$("medalTxt").html(txtArr[20+medalNumber]);
         	}else{
         		mob = 0;
         		sym.getSymbol("medTableMc").$("medalTot").fadeIn(0);
         		sym.getSymbol("latestMc").$("schedTxt").fadeIn(0);//Aug6
         		$(".resultTable").css({'width':'92%','margin':'5px 4%'});//Aug8
         		//sym.getSymbol("medTableMc").$("medalTxt").fadeIn(0);
         		//sym.getSymbol("medTableMc").$("medalTxt").html(txtArr[20+medalNumber]+" "+(menuArr[1].toLowerCase()));
         	}
         	setStyle();
         	menuMob();
         }
         //********************************************************************************************************
         //----------------------------------------- LIVE MEDAL TABLE ---------------------------------------------
         var sportIds=[205,106,121,107,223,481,123,314,313,102,305,119,310,312,311,208,101,124,316,315,317,125,108,126,207,304,604,128,506,116,209,117,120,201,210,105,203,109,118,206,318,319];
         
         var eventIds=[9843,9844,9843,9844,9561,9572,9593,9608,9567,9599,9559,9580,9565,9594,9636,9648,9643,9659,9649,9623,9627,9640,9612,9644,9587,9590,9574,9602,9561,9572,9593,9608,9567,9599,
         9559,9580,9562,9594,9636,9648,9643,9659,9649,9623,9627,9640,9628,9644,9587,9590,9574,10268,10267,10268,10267,10267,0,0,10483,10483,11060,11060,10271,10272,10273,10275,10276,10277,10279,
         10280,10281,10270,11291,13838,13841,10185,10183,10184,10185,10156,10155,10159,10170,10169,10176,10175,10179,10170,10172,10177,10181,10635,10636,10635,10636,9528,9543,9527,9542,9531,9528,
         9543,9527,11467,9531,9783,9781,9786,9785,9783,9781,9786,9785,10143,10146,10152,10153,10149,10151,10345,10344,10346,10350,10349,10345,10344,10346,10349,10351,0,0,9790,9790,10199,10217,10200,
         10205,10207,10208,10204,10211,10195,10199,10216,10217,10204,10211,10191,10189,10219,10219,0,0,0,0,11008,10322,10331,10324,10336,10320,10327,10308,10309,10330,10323,10334,10319,10326,9944,
         9944,9549,9549,9726,9726,9812,9801,9803,9799,9807,9805,9811,9804,9812,9801,9803,9807,9811,9804,0,0,11093,9700,9683,9698,9694,11093,9683,15937,9696,15938,9956,9958,9972,10000,11278,10002,
         10019,10035,10043,9956,9958,9971,11278,10035,10043,9775,9723,9739,9765,9733,9720,9736,9721,9737,9722,9738,9740,9766,9752,9757,9753,9775,9723,9739,9765,9777,9720,9736,9721,9737,9722,9738,
         9740,9766,9752,9757,9753,9787,9789,10340,10694,10340,10694,10387,10385,10391,10389,10386,10384,10390,10388,10266,10265,10266,10265,10265,9814,9814,0,0,0,0,9908,9896,9900,9921,9917,9926,
         9937,10941,10906,9863,9869,9875,11023,11026,9881,16266,16265,16927,16267,16268,16269,16928,16292,16270,16929,16272,16293,16273,16932,16275,16276,16277,16278]
         
         var countries=[257,74,20,155,212,259,24,213,115,258,157,151,214,116,216,75,218,147,76,260,261,78,117,103,25,250,16,215,263,148,246,108,118,159,119,247,134,219,26,88,228,104,264,12,120,35,168,
         89,169,80,17,152,280,254,141,220,170,181,221,145,8,222,267,161,144,43,135,82,211,122,163,266,2,83,171,142,27,37,121,84,224,38,225,28,85,227,55,87,19,86,226,29,114,6,262,248,123,18,160,229,124,
         42,106,98,230,268,9,91,269,255,113,90,167,7,3,271,172,232,272,23,279,156,173,131,231,109,233,3679,22,127,125,136,217,273,275,1,274,93,256,153,182,158,235,236,237,238,174,130,128,46,129,150,10,
         94,277,278,164,178,146,96,138,239,281,110,112,240,30,175,282,283,107,137,265,39,149,99,14,154,288,100,36,284,101,132,285,210,102,31,32,166,33,183,243,249,13,176,5,15,286,162,244,34,133,105,177,
         234,186,213,77,12188,197,73,72,55,12297,2159,58,241,49,12314,12315,242,11,6913];
         
         function getFlag(num){//Aug5
         	for(var c=0;c<countries.length;c++){
         		if (num==countries[c]){
         			imgBG=(c<112)?"0px "+(-19*c)+"px":"-31px "+Math.round(-19*(c-112))+"px";//Aug6 112
         		}
         	}
         }
         var dataURL = ("http:"==document.location.protocol?"http://www2.graphicnews.com/":"https://data.graphicnews.com/")+ "infostradasports/api.php";
         function getMedals(medalPeriod) {
         var medalData;
         //sym.getSymbol("medTableMc").$("medalTxt").html(txtArr[20+medalPeriod]+" "+(menuArr[1].toLowerCase()));
         sym.getSymbol("medTableMc").$("medalTxt").html(txtArr[20+medalPeriod]);
         sym.getSymbol("medTableMc").getSymbol("medalBtn"+medalPeriod).$("bg").css(red);
         var medalQuery=(medalPeriod==0)?"medals":"alltime";
         	$.ajax({ type: "GET", url: dataURL,
         			data: "type=olympics&yr=2016&gn="+gn+"&q="+medalQuery,
         			contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         			async: true,
         			crossDomain: true,
         			success: function (data) {
         				medalData = data;
         				sym.getSymbol("medTableMc").$("table").empty();
         				if (medalData.length==0){
         					sym.getSymbol("medTableMc").$('table').append(txtArr[23]);
         					sym.getSymbol("medTableMc").$("waiting").fadeIn(200);
         				}else{
         					sym.getSymbol("medTableMc").$("table").empty();
         					sym.getSymbol("medTableMc").$("waiting").fadeOut(200);
         					var imgHTML;
                        for (var i = 0; i < medalData.length; i++) {
         						if (i%2 == 0){
         							var tableTxt = "<div class='medalrow even'>";
         						}else{
         							var tableTxt = "<div class='medalrow odd'>";
         						}
         						tableTxt += "<div class='rank' id='rank_a" + i + "'></div><div class='flagcell'><div class='flag' id='flag_a" + i + "'></div></div><div class='country' id='country_a" + i + "'></div>";
         						tableTxt += "<div class='gold' id ='gold_a" + i + "'></div><div class='silver' id='silver_a" + i + "'></div><div class='bronze' id='bronze_a" + i + "'></div>";
         						tableTxt += "<div class='medaltotal' id='total_a" + i + "'></div></div>";
         						sym.getSymbol("medTableMc").$("table").append(tableTxt);
         						var NOCID=medalData[i].n_NOCID;
         						var countryName, countryShort;
         						for(var c=0;c<countries.length;c++){
         							if (NOCID==countries[c]){
         								countryName=countryCaps[c];
         								countryShort=countryCapShort[c];
         							}
         						}
         						$('#rank_a' + i).text(medalData[i].n_RankGold);
         						$('#country_a' + i).text(countryName);
         						$('#gold_a' + i).text(medalData[i].n_Gold);
         						$('#silver_a' + i).text(medalData[i].n_Silver);
         						$('#bronze_a' + i).text(medalData[i].n_Bronze);
         						$('#total_a' + i).text(medalData[i].n_Total);
         						//imgHTML='<img src="flags/'+(medalData[i].n_NOCID)+'.png" height="14px" width="24px">';
         						//$('#flag_a' + i).html(imgHTML);
         						getFlag(NOCID);//Aug5
         						$('#flag_a' + i).css({'background-position':imgBG});
         						$(".medalrow").css({'display':'table','width':'100%', 'height':'16px', 'border-top':'1px solid rgb(255,255,255)', 'border-bottom':'1px solid rgb(200,200,200)'});
         						$(".even").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif', 'background':'rgba(114,206,255,0.15)'});
         						$(".odd").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif'});
         						$(".rank").css({'display':'table-cell', 'text-align':'left','width':'3%', 'padding-left':'1%','min-width':'30px'});
         						$(".gold,.silver,.bronze,.medaltotal").css({'display':'table-cell', 'font-size':'12px','text-align':'right','width':'10%','font-style':'oblique'});
         						$(".gold").css({'font-size':'14px','font-weight':700,'font-style':'normal'});
         						//$(".flag").css({'display':'table-cell','width':'9%', 'padding-left':'1%', 'padding-top':'3px'});
         						$(".flag").css({'width':'31px','background-image': 'url(images/flags.png)','height':'19px','overflow':'hidden','background-repeat':'no-repeat'});//Aug5
         						$(".flagcell").css({'display':'table-cell','width':'31px'});//Aug6
         						//$(".country").css({'display':'table-cell','width':'39%','padding-left':'1%'});
         						$(".country").css({'display':'table-cell','padding-left':'1%'});
         						$(".medaltotal").css({'font-weight':700,'padding-right':'2%','width':'13%'});
         					}
         					if(RTL==true){//Jul12
         						$(".rank, .gold, .silver, .bronze, .medaltotal, .flag, .country").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         						$(".country, .rank").css({'text-align':'right', 'padding-left':'3px'});
         					}
         				} 
         			}
         	});
         }
         //********************************************************************************************************
         //----------------------------------------- GET LATEST MEDALS --------------------------------------------
         function getToday() {
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gn+"&type=olympics&q=today&yr=2016",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var todayData = data;
         			if(todayData){
         				if(todayData.length>0){
         				sym.getSymbol("latestMc").$("todayTable").empty();
         				var dateToday=(getDDmonthYY(todayData[0].d_Date));
         				//sym.getSymbol("latestMc").$("latestTxt").html(txtArr[24]+": "+dateToday);
         				olyDate>=startDate&&olyDate<endDate?sym.getSymbol("latestMc").$("latestTxt").html(txtArr[24]+": "+dateToday):sym.getSymbol("latestMc").$("latestTxt").html(txtArr[30]);//Aug21
         				var eventid=0,sportid=0,eventName,gender=0,sportName,countryShort,lastEvent=0,lastGender=0, lastSport=0;
         				for (var i = 0; i < todayData.length; i++) {
         					gender = (todayData[i].n_GenderID==gender)?gender:todayData[i].n_GenderID;//1 men, 2 women
         					var genderImg = "0px "+(-270-(gender*30))+"px";//Aug8 FF
         					eventid=(todayData[i].n_EventID==eventid)?eventid:todayData[i].n_EventID;
         					for (var n=0;n<eventIds.length;n++){
         						if(eventid==eventIds[n]){
         							eventName=eventNames[n];
         						}
         					}
         					sportid=(todayData[i].n_SportID==sportid)?sportid:todayData[i].n_SportID;
         					for (var x=0;x<sportIds.length;x++){
         						if(sportid==sportIds[x]){
         							sportName=sportNames[x];
         							var sportImg="0px "+(-30*x)+"px";//Aug8 FF
         						}
         					}
         					var NOCID=todayData[i].n_NOCID;
         					for(var c=0;c<countries.length;c++){
         							if (NOCID==countries[c]){
         								countryShort=countryCapShort[c];
         							}
         						}
         					var todayTxt = "<table class='border'><table class='eventTab' id='eventToday"+i+"'><tr id='todayBtn"+i+"'>";
         					todayTxt += "<td class='sportcell'><div id='imgsport" + i + "' class='imgsport'></div></td>";
         					todayTxt += "<td id='todaysport" + i + "' class='sportname' colspan='2'></td>";//Aug8
         					todayTxt += "<td id='todayevent" +i + "' class='eventname'></td>";
         					todayTxt += "<td class='gendercell'><div id ='todaygender" + i + "' class='gender'></div></td>";
         					todayTxt += "</tr><tr class='eventresults winner'>";
         					todayTxt += "<td id='todayrank"+i+"' class='medal'></td>";
         					todayTxt += "<td class='todayflagcell'><div id='todayflag"+i+"' class='todayflag'></div></td>";
         					todayTxt += "<td id='todayperson" + i + "' class='person'></td><td></td>";//Aug8
         					todayTxt += "<td id='todaynoc" + i + "' class='noc'></td>";
         					todayTxt += "</tr>";	
         					todayTxt += "<tr><td colspan='5'><table class='todaywinners' id='eventres"+gender+"_"+sportid+"_"+eventid+"'></table></td><tr></table><table>";//Aug8
         
         					var eventTxt = "<tr class='eventresults'><td id='todayrank"+i+"' class='medal'></td>";
         					eventTxt += "<td class='todayflagcell'><div id='todayflag"+i+"' class='todayflag'></div></td>";
         					eventTxt += "<td id='todayperson" + i + "' class='person'></td>";
         					eventTxt += "<td id='todaynoc" + i + "' class='noc'></td>";
         					eventTxt += "</tr>";
         					if (gender!=lastGender||eventid!=lastEvent){
                  			sym.getSymbol("latestMc").$("todayTable").append(todayTxt);
                  		}
                  		if(gender==lastGender&&eventid==lastEvent&&sportid==lastSport){
                  			$("#eventres"+gender+"_"+sportid+"_"+eventid).append(eventTxt);
                  		}
          					//imgHTML='<img src="flags/'+(todayData[i].n_NOCID)+'.png" height="14px" width="24px">';
          					getFlag(NOCID);//Aug5
                  		$("#todayBtn"+i).on('click',showLatest(i));
                  		$("#todayBtn"+i).css({'cursor':'pointer'});
         					$('#imgsport' + i).css({'background-position':sportImg});//Aug8 FF
         					$('#todaysport' + i).text(sportName);
         					$('#todayevent' + i).text(eventName);
         					$('#todayrank' + i).text(todayData[i].n_Rank);
         					$('#todayflag' + i).css({'background-position':imgBG});//Aug5
         					//$('#todayperson' + i).html(imgHTML+" "+todayData[i].c_Participant);
         					$('#todayperson' + i).text(todayData[i].c_Participant);
         					$('#todaynoc' + i).text(countryShort);
         					$('#todaygender' + i).css({'background-position':genderImg});//Aug8 FF
         					lastGender=gender; lastEvent=eventid; lastSport=sportid;
         				} 
         				$(".border").css({'width':'100%', 'border-top':'1px solid rgb(255,255,255)', 'border-bottom':'1px solid rgb(200,200,200)'});
         				$(".eventTab").css({'width':'100%', 'font-family':'pragmatica-web, sans-serif','font-size':'14px','border-collapse':'collapse','background':'rgba(114,206,255,0.15)'});
         				$(".sportcell").css({'width':'30px'});
         				$(".imgsport").css({'width':'30px','background-image': 'url(images/sportIcons.png)','height':'30px','overflow':'hidden','background-repeat':'no-repeat','opacity':0.8});
         				//$(".sportname").css({'font-weight':700,'width':'35%'});
         				$(".sportname").css({'font-weight':700,'width':'31px'});//Aug8
         				$(".eventname").css({'font-style':'oblique','text-align':'right'});//Aug8
         				$(".gender").css({'width':'50px','background-image': 'url(images/artwork.png)','height':'30px','overflow':'hidden','background-repeat':'no-repeat','background-position-x':'0px'});
         				$(".gendercell").css({'width':'50px'});
         				$(".todayflagcell").css({'width':'31px'});//Aug5
         				$(".todayflag").css({'width':'31px','background-image': 'url(images/flags.png)','height':'19px','overflow':'hidden','background-repeat':'no-repeat'});//Aug5
         				$(".eventresults").css({'font-size':'13px', 'border-top':'1px solid rgb(255,255,255)'});
         				$(".todaywinners").css({'width':'100%','border-collapse':'collapse'});
         				$(".winner").css({'background-color':'rgba(255,255,255,1)'});
         
         				$(".medal").css({'width':'30px', 'text-align':'center', 'font-weight':700});
         				$(".noc").css({'width':'50px','text-align':'left'});
         				noEvents=0;//Aug7
         				}else{
         					noEvents=1;//Aug7
         				}
         			}else{
         				sym.getSymbol("latestMc").$("medalsMc").fadeIn(0);
         			}			                                  
         		}
         	});
         }
         function getSched() {     //shows number of events scheduled, finished     
         	var sched;
         	//olyTime>=startTime&&olyTime<endTime?sym.getSymbol("latestMc").$("schedTxt").fadeIn(0):sym.getSymbol("latestMc").$("schedTxt").fadeOut(0);//Jul12 to show medals animation after end date
         	//TEST
         	olyTime<endTime?sym.getSymbol("latestMc").$("schedTxt").fadeIn(0):sym.getSymbol("latestMc").$("schedTxt").fadeOut(0);//TEST
         	//END TEST
         	$.ajax({ type: "GET", 
         		url:dataURL,
         		data: "gn="+gn+"&yr=2016&type=olympics&q=scheduled",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			schedData = data;
         			if(schedData){
         					eventsComplete=(schedData[0].n_EventsFinished>eventsComplete)?(getToday(),schedData[0].n_EventsFinished):eventsComplete;
         					eventsComplete==0||olyTime>endTime? ( sym.getSymbol("latestMc").$("medalsMc").fadeIn(0), sym.getSymbol("latestMc").$("todayTable").fadeOut(0), sym.getSymbol("latestMc").getSymbol("medalsMc").play()): sym.getSymbol("latestMc").$("medalsMc").fadeOut(0);//Aug21
         					var scheduled=schedData[0].n_EventsFinished+" / "+(schedData[0].n_EventsTotal);
         					sym.getSymbol("latestMc").$("schedTxt").html(txtArr[25]+" "+scheduled);
         					if (eventsComplete>0&&olyTime<=endTime){for (var i=26; i<30; i++){ txt[i].fadeOut(0); }}//Jul12
         					//TEST
         					//eventsComplete=(schedData[0].n_EventsFinished==eventsComplete)?(getToday(),sym.getSymbol("latestMc").$("medalsMc").fadeOut(0),schedData[0].n_EventsFinished):eventsComplete;//TEST
         					//if (eventsComplete==0&&olyTime<=endTime){for (var i=26; i<30; i++){ txt[i].fadeOut(0); }}//TEST
         					//END TEST
         					initSize();//Aug8
                  }
         		}
         	});
         }
         getSched();
         var intervalId = setInterval(getSched,60000);
         //********************************************************************************************************
         //----------------------------------------- EVENT MEDALS -------------------------------------------------
         function getResults(sport) {     //shows number of events scheduled, finished     
         	var sportData;
         	if (olyTime>=startTime){
         		var q="sport", medalPeriod=0;
         	}else{
         		var q="alltime", medalPeriod=1;
         	}
         	$.ajax({ type: "GET", 
         		url:dataURL,
         		data: "gn="+gn+"&yr=2016&type=olympics&q="+q+sportIds[sport],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sportData = data;
         			if(sportData){
         				$("#evresults"+sport).empty();
         				var sportHeader="<div class='sportrow'>";
         				sportHeader+="<div class='erank'></div>";
         				//sportHeader += "<div class='eflag'></div>";
         				//sportHeader += "<div style='width:31px'></div>";
         				sportHeader += "<div class='ecountry' style='color:rgb(100,100,100)'><b>"+txtArr[20+medalPeriod]+"<b></div>";
         				sportHeader+="<div class='egold' style='color:rgb(100,100,100)'><div style='display:inline-block;background-image: url(images/artwork.png);transform: scale(0.8);clip:rect(0px,30px,35px,0px);background-position:-2px -445px;background-repeat:no-repeat;width:35px;height:30px;'></div></div>";
         				sportHeader+="<div class='esilver' style='color:rgb(100,100,100)'><div style='display:inline-block;background-image: url(images/artwork.png);transform: scale(0.8);clip:rect(0px,30px,35px,0px);background-position:-38px -445px;background-repeat:no-repeat;width:35px;height:30px;'></div></div>";
         				sportHeader+="<div class='ebronze' style='color:rgb(100,100,100)'><div style='display:inline-block;background-image: url(images/artwork.png);transform: scale(0.8);clip:rect(0px,30px,35px,0px);background-position:-74px -445px;background-repeat:no-repeat;width:35px;height:30px;'></div></div>";
         				sportHeader+="<div class='emedaltotal'></div>";
         				sportHeader+="</div>";
         				$("#evresults"+sport).append(sportHeader);
         				for (var i = 0; i < sportData.length; i++) {
         					var NOCID=sportData[i].n_NOCID;
         					for(var c=0;c<countries.length;c++){
         							if (NOCID==countries[c]){
         								var countryName=countryCaps[c];
         							}
         						}
         					if (i%2 == 0){
         							var sportTxt = "<div class='sportrow even'>";
         						}else{
         							var sportTxt = "<div class='sportrow odd'>";
         						}
         						sportTxt += "<div class='erank' id='eventrank" + sport + "_"+ i + "'></div>";
         						sportTxt += "<div class='eflag'><div class='eventflag' id='eventflag" + sport + "_"+ i + "'></div></div>";
         						sportTxt += "<div class='ecountry' id='eventcountry" + sport + "_"+ i + "'></div>";
         						sportTxt += "<div class='egold' id ='eventgold" + sport + "_"+ i + "' style='padding-right:1%'></div>";
         						sportTxt += "<div class='esilver' id='eventsilver" + sport + "_"+ i + "' style='padding-right:1%'></div>";
         						sportTxt += "<div class='ebronze' id='eventbronze" + sport + "_"+ i + "' style='padding-right:1%'></div>";
         						sportTxt += "<div class='emedaltotal' id='eventtotal" + sport + "_"+ i +"'></div></div>";
         						$("#evresults"+sport).append(sportTxt);
         						$('#eventrank' + sport + '_' + i).text(sportData[i].n_RankGold);
                           $('#eventcountry' + sport + '_'  + i).text(countryName);
                           $('#eventgold' + sport + '_'  + i).text(sportData[i].n_Gold);
                           $('#eventsilver' + sport + '_'  + i).text(sportData[i].n_Silver);
                           $('#eventbronze' + sport + '_'  + i).text(sportData[i].n_Bronze);
                           $('#eventtotal' + sport + '_'  + i).text(sportData[i].n_Total);
                           //imgHTML='<img src="flags/'+(sportData[i].n_NOCID)+'.png" height="14px" width="24px">';
                           //$('#eventflag' + sport + '_' + i).html(imgHTML);
                           getFlag(NOCID);//Aug5
                           $('#eventflag' + sport + '_' + i).css({'background-position':imgBG});
         				}	
         				$(".sportrow").css({'display':'table','width':'100%', 'height':'16px', 'border-top':'1px solid rgb(255,255,255)', 'border-bottom':'1px solid rgb(200,200,200)'});
         				$(".even").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif', 'background':'rgba(114,206,255,0.15)'});
         				$(".odd").css({'font-size':'14px','font-family':'pragmatica-web, sans-serif'});
         				$(".erank").css({'display':'table-cell', 'text-align':'left','width':'3%', 'padding-left':'1%','min-width':'30px'});
         				$(".egold,.esilver,.ebronze,.emedaltotal").css({'display':'table-cell', 'font-size':'12px','text-align':'right','width':'10%','font-style':'oblique','overflow':'hidden'});
         				$(".egold").css({'font-size':'14px','font-weight':700,'font-style':'normal'});
         				//$(".eflag").css({'display':'table-cell','width':'9%', 'padding-left':'1%', 'padding-top':'3px'});
         				$(".eflag").css({'display':'table-cell','width':'31px'});//Aug5
         				$(".eventflag").css({'width':'31px','background-image': 'url(images/flags.png)','height':'19px','overflow':'hidden','background-repeat':'no-repeat'});//Aug8
         				//$(".ecountry").css({'display':'table-cell','width':'39%','padding-left':'1%'});
         				$(".ecountry").css({'display':'table-cell','padding-left':'1%'});//Aug5
         				$(".emedaltotal").css({'font-weight':700,'padding-right':'2%','width':'13%'});
                  }
                  if (sportData.length>0){
         				getEvents(sport);//get results for each event
         			}
         		}
         	});
         }
         function getEvents(sport) {     //shows number of events scheduled, finished    REWRITTEN Aug 5 
         	var eventData;
         	$.ajax({ type: "GET", 
         		url:dataURL,
         		data: "gn="+gn+"&yr=2016&type=olympics&q=events"+sportIds[sport],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			eventData = data;
         			if(eventData){//Aug5
         				for (var i = 0; i < eventData.length; i++) {
         					var eventid=eventData[i].n_EventID;
         					var gender=eventData[i].n_GenderID;
         					var genderImg = -270-(gender*30);//background-position-y
         					for (var n=0;n<eventIds.length;n++){
         						if(eventid==eventIds[n]){
         							eventName=eventNames[n];
         						}
         					}
         					//Start Aug7
         					var NOCID1=eventData[i].n_Rank1NOCID;
         					var NOCID2=eventData[i].n_Rank2NOCID;
         					var NOCID3=eventData[i].n_Rank3NOCID;
         					for(var c=0;c<countries.length;c++){
         						if (NOCID1==countries[c]){
         							var goldnat=(NOCID1!=null)?countryCapShort[c]:"";
         							var img1BG=(NOCID1==countries[c]&&NOCID1>0)?(c<111)?"0px "+(-19*c)+"px":"-31px "+Math.round(-19*(c-112))+"px":"35px 20px"
         						}
         						if (NOCID2==countries[c]){
         							var silvernat=(NOCID2!=null)?countryCapShort[c]:"";
         							var img2BG=(NOCID2==countries[c]&&NOCID2>0)?(c<111)?"0px "+(-19*c)+"px":"-31px "+Math.round(-19*(c-112))+"px":"35px 20px"
         						}
         						if (NOCID3==countries[c]){
         							var bronzenat=(NOCID3!=null)?countryCapShort[c]:"";
         							var img3BG=(NOCID3==countries[c]&&NOCID3>0)?(c<111)?"0px "+(-19*c)+"px":"-31px "+Math.round(-19*(c-112))+"px":"35px 20px"
         						}
         					}
         					//End Aug7
         					var goldwin=eventData[i].c_Rank1Participant;
         					var silverwin=eventData[i].c_Rank2Participant;
         					var bronzewin=eventData[i].c_Rank3Participant;
         					var finished=eventData[i].b_Finished;	
         					var resultTxt = "<table class='resultTable'><tr>";
         					resultTxt += "<td id='resEvent" +sport+ "_" +i + "' class='resevent' colspan='3'></td>";
         					resultTxt += "<td class='resgendercell'><div id ='resgender" +sport+ "_"  + i + "' class='gender'></div></td>";
         					resultTxt += "</tr><tr class='resultrow'>";
         					resultTxt += "<td class='resrank'>1</td>";
         					resultTxt += "<td class='resflagcell'><div style='background-position:"+img1BG+"' class='resflag'></td>";
         					resultTxt += "<td id='res1win" +sport+ "_"  + i + "' class='reswin'></td>";
         					resultTxt += "<td id='res1nat" +sport+ "_"  + i + "' class='resnat'></td>";
         					resultTxt += "</tr><tr class='resultrow'>";
         					resultTxt += "<td class='resrank'>2</td>";
         					resultTxt += "<td class='resflagcell'><div style='background-position:"+img2BG+"' class='resflag'></td>";
         					resultTxt += "<td id='res2win" +sport+ "_"  + i + "' class='reswin'></td>";
         					resultTxt += "<td id='res2nat" +sport+ "_"  + i + "' class='resnat'></td>";
         					resultTxt += "</tr><tr class='resultrow'>";
         					resultTxt += "<td class='resrank'>3</td>";
         					resultTxt += "<td class='resflagcell'><div style='background-position:"+img3BG+"' class='resflag'></td>";
         					resultTxt += "<td id='res3win" +sport+ "_"  + i + "' class='reswin'></td>";
         					resultTxt += "<td id='res3nat" +sport+ "_"  + i + "' class='resnat'></td>";
         					resultTxt += "</tr>";	
         					resultTxt += "</table>";
         					if(finished==true){
         						$("#evresults"+sport).append(resultTxt);
         					}
         					$("#resEvent" +sport+ "_" +i).text(eventName);
         					$("#resgender"+i).text();
         					$("#res1win" +sport+ "_" +i).text(goldwin);
         					$("#res2win" +sport+ "_" +i).text(silverwin);
         					$("#res3win" +sport+ "_" +i).text(bronzewin);
         					$("#res1nat" +sport+ "_" +i).text(goldnat);
         					$("#res2nat" +sport+ "_" +i).text(silvernat);
         					$("#res3nat" +sport+ "_" +i).text(bronzenat);
         					$('#resgender' +sport+ "_"  + i).css({'background-position':'0px '+genderImg+'px'});
         				}
         				$(".resultTable").css({'font-family':'pragmatica-web, sans-serif','font-size':'13px','border-collapse':'collapse','background':'rgba(114,206,255,0.15)','width':'92%','margin':'5px 4%','border-radius':'10px','border':'solid 1px rgba(114,206,255,0.6)'});
         				$(".resevent").css({'padding-left':'1%'});
         				$(".resultrow").css({'font-size':'13px', 'border-top':'1px solid rgb(255,255,255)'});
         				$(".gender").css({'width':'50px','background-image': 'url(images/artwork.png)','height':'30px','overflow':'hidden','background-repeat':'no-repeat'});
         				$(".resgendercell").css({'width':'50px'});
         				$(".resrank").css({'width':'30px', 'text-align':'center', 'font-weight':700});
         				$(".resnat").css({'width':'50px','text-align':'left'});
         				$(".resflagcell").css({'width':'31px'});
         				$(".resflag").css({'width':'31px','background-image': 'url(images/flags.png)','height':'19px','overflow':'hidden','background-repeat':'no-repeat'});//Aug5
                  }
         		}
         	});
         }
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("eventsMc").$("dates").css({"overflow-y":"scroll"});
         	if(RTL==true){
         		sym.$("medTableMc").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		//sym.getSymbol("medTableMc").$("table").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.getSymbol("medTableMc").$("medalTxt").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)','text-align':'right'});
         		sym.getSymbol("medTableMc").$("medalTxt").attr({'dir':'rtl'});
         		sym.getSymbol("medTableMc").$("medalBtn0").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		for (var n=0;n<3;n++){
         			sym.getSymbol("medTableMc").$("medalHd"+n).css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		}
         	}
         }
         setStyle();
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         setTimeout(function(){ 
         }, 200);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'dateBx_1'
   (function(symbolName) {   
   
   })("iconBx");
   //Edge symbol end:'iconBx'

   //=========================================================
   
   //Edge symbol: 'EventsMc'
   (function(symbolName) {   
   
   })("EventsMc");
   //Edge symbol end:'EventsMc'

   //=========================================================
   
   //Edge symbol: 'MedTableMc'
   (function(symbolName) {   
   
   })("MedTableMc");
   //Edge symbol end:'MedTableMc'

   //=========================================================
   
   //Edge symbol: 'LatestMc'
   (function(symbolName) {   
   
   })("LatestMc");
   //Edge symbol end:'LatestMc'

   //=========================================================
   
   //Edge symbol: 'medalHd0'
   (function(symbolName) {   
   
   })("medalHd0");
   //Edge symbol end:'medalHd0'

   //=========================================================
   
   //Edge symbol: 'medalHd1'
   (function(symbolName) {   
   
   })("medalHd1");
   //Edge symbol end:'medalHd1'

   //=========================================================
   
   //Edge symbol: 'medalHd2'
   (function(symbolName) {   
   
   })("medalHd2");
   //Edge symbol end:'medalHd2'

   //=========================================================
   
   //Edge symbol: 'MedalsMc'
   (function(symbolName) {   
   
   })("MedalsMc");
   //Edge symbol end:'MedalsMc'

   //=========================================================
   
   //Edge symbol: 'medalBtn0'
   (function(symbolName) {   
   
   })("medalBtn0");
   //Edge symbol end:'medalBtn0'

   //=========================================================
   
   //Edge symbol: 'medalBtn1'
   (function(symbolName) {   
   
   })("medalBtn1");
   //Edge symbol end:'medalBtn1'

   //=========================================================
   
   //Edge symbol: 'SportMedalsMc'
   (function(symbolName) {   
   
   })("SportMedalsMc");
   //Edge symbol end:'SportMedalsMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34462");