/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	
         	var mob = 0;
         	var mobOpen = false;
         	var btnNo = 0;
         	var speed = 0;
         	var navMove = 0;
         	var clicked = 0;
         	var clickedCard = 0;
         	var clickedAux = 0;
         	var clickedDot = 0;
         	var coursePath = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc");
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var winner;
         	var winnertxt = sym.getSymbol("winnersMc").$("winner").css("pointer-events","none");
         	var course;
         	var coursetxt = sym.getSymbol("winnersMc").$("course0").css("pointer-events","none");
         	
         for (var a=0; a<18; a++){
         	coursePath.getSymbol("roundBtn"+a).$("txt").html(a+1);
         	coursePath.getSymbol("roundBtn"+a).$("txt").css({"pointer-events":"none"});
         }
         for (var s=0; s<10; s++){
         	sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("btn"+s).css({'position':'relative','float':'left'});
         }
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(120,120,120,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[3] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // ADD HOLE IMAGES
         //********************************************************************************************************
         holesArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 18; i++){
         	var holeObject = sym.getSymbol("holesMc").createChildSymbol("holeMc", "holesHolderMc");  // Create an instance element of a symbol as a child of the given parent element
         	holeObject.setVariable("id", i);  //set the value of a Symbol variable
         	holesArray.push(holeObject);  //push it into the array
         }
         
         for (var i=0; i<holesArray.length; i++){
         	holesArray[i].$("holesArt").animate ({left:-200*i}, 0);
         }
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = coursePath.$("txt0").css({"pointer-events":"none"});
         	txt[1] = coursePath.$("txt1").css({"pointer-events":"none"});
         	txt[2] = coursePath.$("txt2").css({"pointer-events":"none", "width":"auto"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	for (var i=6; i<15; i++){
         		txt[i] = sym.getSymbol("cardMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[15] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"pointer-events":"none"});
         
         	var txtArr=[];
         	var datestring;
         	var parstring;
         	var yardsstring;
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34460.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<19; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			stringPar = $(xml).find('txt4').text(); // Stage date for stage btn info
                  parstring=stringPar.split("<br>");
                  stringYards = $(xml).find('txt5').text(); // Stage date for stage btn info
                  yardsstring=stringYards.split("<br>");
                  for (var h=0; h<18; h++){
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").html(h+1).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").append(parstring[h]).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").append(yardsstring[h]).css({"pointer-events":"none"});
         			}
         			coursePath.$("txt0").css({"font-size":"15px", "line-height":"17px"});
         			sym.getSymbol('cardMc').$("txt10").css({"line-height":"22px"});
         			sym.getSymbol('cardMc').$("txt12").css({"line-height":"22px"});
         			sym.getSymbol('cardMc').$("txt14").css({"line-height":"22px"});
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt15").css({"pointer-events":"none", "font-size":"16px"});
         			sym.getSymbol("holesMc").$("holeData").empty();
         			sym.getSymbol("holesMc").$("holeData").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	speed = 0;
         
         	if(stageWidth<800){
         		sym.$("scrollMc").css({'cursor':'ew-resize'});
         	}else{
         		sym.$("scrollMc").css({'cursor':'default'});
         	};
         	if(stageWidth<640){
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("winnersMc").$("winnerBtnsMc").stop().animate({left:0, width:stageWidth}, 0);
         	}else{
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("winnersMc").$("winnerBtnsMc").stop().animate({left:200, width:stageWidth-200}, 0);
         	};
         	if (stageWidth<480){
         		sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"left":"49.3%"}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"opacity":"0"}, 0);
         		winBtnPath.$("table td:nth-child(3)").hide();
         		mob = 1;
         	}else{
         		sym.$("scrollMc").stop().animate({width:stageWidth-200}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"left":"32.5%"}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"opacity":"1", "left":"65%"}, 0);
         		winBtnPath.$("table td:nth-child(3)").show();
         		mob = 0;
         		navClick();
         	};
         	setStyle();
         	menuMob();
         	menuClicked()
         };
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css({"background-color":"#3287dd"});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		speed = 200;
         		menuClicked();
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         function menuClicked(){
         	resetmenu();
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + clicked).$("bg").css(red);
         	sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         	sym.$("winnersMc").stop().animate ({left:810}, speed, 'easeInCubic');
         	sym.$("cardMc").stop().animate ({left:810}, speed, 'easeInCubic');
         	sym.$("holesMc").stop().animate ({left:810}, speed, 'easeInCubic');
         	if (stageWidth>480){
         		if (clicked == 0){
         			sym.$("cardMc").stop().animate ({left:stageWidth-200, width:200}, speed, 'easeOutCubic');
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("bg").css(red);
         		}
         		if (clicked == 1){
         			sym.$("cardMc").stop().animate ({left:stageWidth-200, width:200}, speed, 'easeOutCubic');
         		}
         		if (clicked == 2){
         			sym.$("holesMc").stop().animate ({width:200}, 0);
         			sym.$("holesMc").stop().animate ({left:stageWidth-200, width:200}, speed, 'easeOutCubic');
         		}
         		if (clicked == 3){
         			sym.$("winnersMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         			}
         	}
         	if (stageWidth<480){
         		if (clicked == 0){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         		}
         		if (clicked == 1){
         			resetCard();
         			sym.$("cardMc").stop().animate ({left:0, width:stageWidth}, speed, 'easeOutCubic');
         		}
         		if (clicked == 2){
         			sym.$("holesMc").stop().animate ({width:stageWidth}, 0);
         			sym.$("holesMc").stop().animate ({left:0, width:stageWidth}, speed, 'easeOutCubic');
         		}
         		if (clicked == 3){
         			sym.$("winnersMc").stop().animate ({left:0}, speed, 'easeOutCubic');
         		}
         	}
         	for (var i=0; i<18; i++){
         		holesArray[i].getSymbolElement().css({'left':(sym.$("holesMc").width()/2)-100+'px'});
         	}
         }
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=1; s<4; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:140+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<4; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<4; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=1; s<4; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:120-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<4; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<4; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         		sym.getSymbol("menuBtnsMc").$("menuBtn0").css({'left':'0px'});
         		sym.getSymbol("holesMc").$("redBox").css({'left':'150px'});
         		sym.getSymbol("holesMc").$("holeNo").css({'left':'150px'});
         		sym.getSymbol("holesMc").$("holeData").css({'left':'0px', 'text-align':'right'});
         		sym.getSymbol("holesMc").$("navBtnNext").css({'left':'0px','top':'501px','transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.getSymbol("holesMc").$("navBtnBack").css({'left':'160px','top':'501px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.getSymbol("winnersMc").$("winner").css({'text-align':'right'});
         		sym.getSymbol("winnersMc").$("course0").css({'text-align':'right'});
         
         		for (var s=0; s<10; s++){
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("btn"+s).css({'position':'relative','float':'right'});
         		}
         		if (stageWidth<480){
         			sym.getSymbol("holesMc").$("navBtnBack").css({'left':stageWidth-40+'px','top':'501px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         			sym.getSymbol("holesMc").$("redBox").css({'left':stageWidth-50 + "px"});
         			sym.getSymbol("holesMc").$("holeNo").css({'left':stageWidth-50 + "px"});
         			sym.getSymbol("holesMc").$("holeData").css({'text-align':'right', 'left':stageWidth-202 + 'px'});
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt16").css({'left':'0px', 'text-align':'right', "width":"94%"}, 0);
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({'left':'0px', 'text-align':'right',"width":"47.5%"}, 0);
         			winBtnPath.$("table td:nth-child(1)").hide();
         		} else {
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt16").css({'left':'0px', 'text-align':'right', "width":"96.5%"}, 0);
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({'left':'0px', 'text-align':'right',"width":"63.5%"}, 0);
         			winBtnPath.$("table td:nth-child(1)").show();
         		}
         		winBtnPath.$("table td:nth-child(3)").show();
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({'left':'0px', 'text-align':'right',"width":"31.5%"}, 0);
         		for (var h=0; h<18; h++){
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").css({"left":"66%"});
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").css({"left":"33%"});
         			sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").css({"left":"0px"});
         		}
         		sym.getSymbol("cardMc").$("txt6").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt8").css({"left":"0px"});
         		sym.getSymbol("cardMc").$("txt9").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt10").css({"left":"66%"});
         		sym.getSymbol("cardMc").$("txt13").css({"left":"0px"});
         		sym.getSymbol("cardMc").$("txt14").css({"left":"0px"});
         
         		coursePath.$("txt0").css({"text-align":"right"});
         		coursePath.$("txt2").css({"text-align":"right"});
         		coursePath.$("txt19").css({"text-align":"center"});
         	}
         }
         
         //********************************************************************************************************
         // DOT BUTTONS
         //********************************************************************************************************
         dotArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	dotArray.push(a);
         }
         
         function resetDot(){
         	for (var a=0; a<dotArray.length; a++){
         		coursePath.getSymbol("roundBtn" + a).$("btnBg").css({"background-color":"white"});
         		coursePath.getSymbol("roundBtn" + a).$("txt").css({"color":"black"});
         	}
         }
         resetDot();
         
         // DOT CLICK
         var dotBtnClick = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		if (stageWidth<480){
         			sym.$("holesMc").stop().animate ({left:0}, 200, 'easeOutCubic');
         			clicked = 2;
         			menuClicked();
         		}
         		clickedAux = dotNo;
         		clickedDot = clickedAux;
         		navClick();
         	};
         };
         for (var b=0;b<dotArray.length;b++){
         	coursePath.$("roundBtn"+b).on('touchstart click',dotBtnClick(b));
         	coursePath.$("roundBtn"+b).css({'cursor':'pointer'});
         }
         coursePath.getSymbol("roundBtn0").$("btnBg").css({"background-color":"#da0000"});
         coursePath.getSymbol("roundBtn0").$("txt").css({"color":"white"});
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         // NAV CLICK FUNCTION
         //********************************************************************************************************
         function navClick(){
         	for (var i=0; i<holesArray.length; i++){
         		holesArray[i].getSymbolElement().animate ({opacity:0}, 0);
         	}
         	holesArray[clickedAux].getSymbolElement().stop().animate ({opacity:1}, 0);
         	sym.getSymbol("holesMc").$("holeNo").html(clickedAux + 1);
         	sym.getSymbol("holesMc").$("holeData").empty();
         	sym.getSymbol("holesMc").$("holeData").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         	sym.getSymbol("holesMc").$("holeName").empty();
         	sym.getSymbol("holesMc").$("holeName").append(txtArr[clickedAux+21]);
         
         	if (clickedAux <=0 ){
         		sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnBack").fadeIn(0);
         	}
         	if (clickedAux >= 17){
         		sym.getSymbol("holesMc").$("navBtnNext").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnNext").fadeIn(0);
         	}
         	resetCard();
         	resetDot();
         	sym.getSymbol("cardMc").getSymbol("btn" + clickedAux).$("btnBg").fadeIn(0);
         	coursePath.getSymbol("roundBtn" + clickedAux).$("btnBg").css({"background-color":"#da0000"});
         	coursePath.getSymbol("roundBtn" + clickedAux).$("txt").css({"color":"white"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt01").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt02").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt03").css({"color":"white", "font-weight":"bold"});
         
         	var x = coursePath.$("roundBtn" + clickedAux).position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500, 'easeOutCubic');
         }
         
         //********************************************************************************************************
         // NAVIGATION BUTTONS
         //********************************************************************************************************
         sym.getSymbol("holesMc").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux++;
         	navClick();
         	});
         sym.getSymbol("holesMc").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux--;
         	navClick();
         	});
         
         //********************************************************************************************************
         // CARD BUTTONS
         //********************************************************************************************************
         cardArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	cardArray.push(a);
         }
         
         function resetCard(){
         	for (var a=0; a<cardArray.length; a++){
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt03").css({"color":"black", "font-weight":"normal"});
         	}
         }
         resetCard();
         
         // CARD CLICK
         var cardBtnClick = function(cardNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		clickedAux = cardNo;
         		navClick();
         		if (stageWidth<480){
         			sym.$("cardMc").stop().animate ({left:stageWidth+10}, 200, 'easeInCubic');
         			resetmenu();
         			clicked=2;
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("bg").css(red);
         			menuClicked();
         		}
         	};
         };
         
         for (var b=0;b<cardArray.length;b++){
         	sym.getSymbol("cardMc").$("btn"+b).on('touchstart click',cardBtnClick(b));
         	sym.getSymbol("cardMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("cardMc").getSymbol("btn0").$("btnBg").fadeIn(0);
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt01").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt02").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt03").css({"color":"white", "font-weight":"bold"});
         
         sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         sym.getSymbol("holesMc").getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         
         //********************************************************************************************************
         // WINNERS BUTTONS
         //********************************************************************************************************
         var winBtnPath = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc")
         
         winnersBtnArray = []; //the array that will hold references to the buttons.
         
         for (var w = 0; w < 10; w++){
         	var winnersBtnSymbols = winBtnPath.getSymbol("btn"+w); // Create an instance element of a symbol as a child of the given parent element
         	winnersBtnSymbols.setVariable("winnersBtnId", w); //set the value of a Symbol variable
         	winnersBtnArray.push(winnersBtnSymbols); //push it into the array
         	winBtnPath.getSymbol("btn"+w).$("no").html(2015-w)
         	winBtnPath.$("btn"+w).css({'cursor':'pointer'});
         	}
         
         	$.each(winnersBtnArray, function( count, winnersBtnInTheArray ){ //a 'for each' loop through the newly populated array
         		var winnersBtnItem = $(winnersBtnInTheArray); //create jQuery reference to the item
         		var winnersBtnElement = winnersBtnInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         		winnersBtnElement.bind ("click touchstart", {winnersBtnId:count}, winnersBtnClick);
         	})
         
         	function resetwinnersBtn(){
         		for (var k=0; k<winnersBtnArray.length; k++){
               	winnersBtnArray[k].$("bg").css({"background-color":"#3287dd"});
               	winnersBtnArray[k].$("no").css({"color":"#fff"});
         		}
         	}
         	resetwinnersBtn();
         
         function winnersBtnClick (e){
         	winBtnPath.$("table").empty()
         	resetwinnersBtn(); //set them all back to normal state
         	var winnersBtn_id = (e.data.winnersBtnId); //get the id of the clicked item
         	winBtnPath.getSymbol("btn" + winnersBtn_id).$("bg").css({"background-color":"rgba(218,0,0,1)"});
         	winBtnPath.getSymbol("btn" + winnersBtn_id).$("no").css({"color":"#fff"});
         	sym.getSymbol("winnersMc").getSymbol("winPic").$("winners").stop().animate ({left:-1800+(200 * winnersBtn_id)}, 200, 'easeOutCubic');
         	getYear(2015 - winnersBtn_id);
         }
         
         winBtnPath.getSymbol("btn0").$("bg").css({"background-color":"rgba(218,0,0,1)"});
         winBtnPath.getSymbol("btn0").$("no").css({"color":"#fff"});
         
         function getYear(year){
         		$.ajax({	
         		type: "GET",
         		url: year + "_results.xml",
         		dataType: "xml",
         		success: function(xml) {
         		winner = $(xml).find('winner').text();
         		winnertxt.html(winner);
         		course = $(xml).find('course').text();
         		coursetxt.html(course);
         
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="5" cellspacing="1">';
         		var playerName;
         		var playerScore;
         		var playerPrize;
         
         		$('Ranked',xml).each(function(i) {
         			playerName = $(this).find("person").text();
         			playerScore = $(this).find("score").text();
         			playerPrize = $(this).find("prize").text();
         			var playerdata = winnersTable(playerName,playerScore,playerPrize);
         			if (RTL == true){
         				var playerdata = winnersTable(playerPrize,playerScore,playerName);
         			}
         			htmlOutput = htmlOutput + playerdata;
         		});
         
         		htmlOutput += '</table>';
         		winBtnPath.$("table").append(htmlOutput);
         		winBtnPath.$("table tr:odd").css({"text-align":"left", "background-color":"#ebf3fb","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		winBtnPath.$("table tr:even").css({"text-align":"left", "background-color":"#d2e4f6","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		winBtnPath.$("table tr:first-child").css({"text-align":"left", "font-weight":"bold", "background-color":"#e60000","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         		stageWidth=sym.$("Stage").width();	
         
         		if (RTL == true){
         			winBtnPath.$("table tr:odd").css({"text-align":"right"});
         			winBtnPath.$("table tr:even").css({"text-align":"right"});
         			winBtnPath.$("table tr:first-child").css({"text-align":"right"});
         		}
         		if (stageWidth<480){
         			winBtnPath.$("table td:nth-child(3)").hide();
         		}
         	}
         
         });
         
          function winnersTable(playerName,playerScore,playerPrize){
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:33%;font-weight: bold;">'+ playerName +'</td>';
         	output += '<td style="width:33%;">'+ playerScore +'</td>';
         	output += '<td style="width:34%;font-weight: bold;">'+ playerPrize +'</td>';
         	output += '</tr>';
         	return output;
         	}
         }
         getYear(2015);
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	winBtnPath.$("table").css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'roundBtnsMc'
   (function(symbolName) {   
   
   })("roundBtnsMc");
   //Edge symbol end:'roundBtnsMc'

   //=========================================================
   
   //Edge symbol: 'roundBtn'
   (function(symbolName) {   
   
   })("roundBtn");
   //Edge symbol end:'roundBtn'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMc");
   //Edge symbol end:'holesMc'

   //=========================================================
   
   //Edge symbol: 'holeMc'
   (function(symbolName) {   
   
   })("holeMc");
   //Edge symbol end:'holeMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'holesHolderMc'
   (function(symbolName) {   
   
   })("holesHolderMc");
   //Edge symbol end:'holesHolderMc'

   //=========================================================
   
   //Edge symbol: 'cardBtn'
   (function(symbolName) {   
   
   })("cardBtn");
   //Edge symbol end:'cardBtn'

   //=========================================================
   
   //Edge symbol: 'cardMc'
   (function(symbolName) {   
   
   })("cardMc");
   //Edge symbol end:'cardMc'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'winnersBtn'
   (function(symbolName) {   
   
   })("winnersBtn");
   //Edge symbol end:'winnersBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn2_1'
   (function(symbolName) {   
   
      })("menuBtn3");
   //Edge symbol end:'menuBtn3'

   //=========================================================
   
   //Edge symbol: 'winPic'
   (function(symbolName) {   
   
   })("winPic");
   //Edge symbol end:'winPic'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34460");