/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var panelVis = true;
         	var speed = 200;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", 'padding-left':'50px'});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var tablePath = sym.getSymbol("tableMc");
         	var techPath = sym.getSymbol("techMc");
         	sym.getSymbol("tableBtn").$("arrow").fadeOut(0);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var yellowTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#f9a51a", "height":"auto","width":"auto", "padding":"6px"};
         
         	var redTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"#fff",
         	"background-color":"#da0000", "height":"auto","width":"auto", "padding":"6px"};
         
         	var whiteTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"black",
         	"background-color":"#fff", "height":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // ADD CALENDAR
         //********************************************************************************************************
         calArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 38; i++){
          var calObject = sym.createChildSymbol("dateBox", "panelMc");  // Create an instance element of a symbol as a child of the given parent element
          calObject.setVariable("id", i);  //set the value of a Symbol variable
          calArray.push(calObject);  //push it into the array
         }
         
         for (var i=0; i<calArray.length; i++){
         	calArray[i].getSymbolElement().css({'top':'24px', 'left':'4px'});
         	calArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	calArray[i].$('no').css({"color":"white"});
         }
         for (var i=0; i<7; i++){
         	calArray[i].$('bgRight').css({'background-color':'#fff'});
         	calArray[i].$('bgLeft').css({'background-color':'#fff'});
         }
         for (var i=7; i<11; i++){
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=28; i<38; i++){
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=7; i<38; i++){
         	calArray[i].$('no').html(i-6);
         }
         calArray[18].$('bgRight').css({'background-color':'#1382c5'});
         calArray[18].$('bgLeft').css({'background-color':'#1382c5'});
         
         calArray[25].$('bgRight').css({'background-color':'#e21932'});
         calArray[25].$('bgLeft').css({'background-color':'#1382c5'});
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	txt[0] = sym.getSymbol("panelMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"}); // days of week
         	txt[2] = sym.getSymbol("panelMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("keyMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("keyMc").$("txt4").css({"pointer-events":"none"});
         	for (var i=5; i<15; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=15; i<37; i++){
         		txt[i] = sym.getSymbol("tableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=37; i<41; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34456.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<41; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			var dayString = $(xml).find('txt1').text();
                  weekDays = dayString.split(";");
                  for (var w=0; w<7; w++){
         				calArray[w].$('no').html(weekDays[w]);
         				calArray[w].$('no').css({"color":"gray"});
         			}
         
         			sym.getSymbol("panelMc").$("txt2").css(whiteTxtBox);
         			sym.getSymbol("panelMc").$("txt2").css({"top":( 528 - sym.getSymbol("panelMc").$("txt2").height() ) + "px"});
         			
         			mapPath.$("txt9").css(yellowTxtBox);
         			mapPath.$("txt9").css({"left":358-mapPath.$("txt9").width()/2 + 'px'});
         			mapPath.$("txt10").css({"line-height":"20px"});
         			mapPath.$("txt11").css({"line-height":"20px"});
         
         			tablePath.$("or").html(txtArr[16]);
         			tablePath.$("wr").html(txtArr[17]);
         			techPath.$("techTxt").html(txtArr[37]);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // PANEL BTN
         //********************************************************************************************************
         sym.$("panelBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		panelCheck();
         	});
         
         function panelCheck(){
         	if (panelVis == false){
         		speed = 200;
         		panelOpen();
         	}else{
         		speed = 200;
         		panelClose();
         	}
         }
         function panelClose(){
         	sym.$("panelMc").stop().animate({left:stageWidth+10}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	panelVis = false;
         
         }
         function panelOpen(){
         	sym.$("panelMc").stop().animate({left:stageWidth-160}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	panelVis = true;
         }
         //********************************************************************************************************
         // TABLE BTN
         //********************************************************************************************************
         var tableIn = true;
         sym.$("tableBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		panelClose();
         		if (tableIn == false){
         			sym.$("tableMc").fadeIn(500);
         			tableIn = true;
         		} else{
         			sym.$("tableMc").fadeOut(500);
         			tableIn = false;
         		}
         		
         	});
         //********************************************************************************************************
         // TECH BTN
         //********************************************************************************************************
         techPath.$("techNext").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		clicked++;
         		techReset();
         	});
         techPath.$("techBack").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		clicked--;
         		techReset();
         	});
         
         function techReset(){
         	techPath.$("techNext").fadeIn(0);
         	techPath.$("techBack").fadeIn(0);
         	for (var i = 0; i < 4; i++){
         		techPath.$("man"+i).css({"opacity":"0"});
         		techPath.$("man"+clicked).css({"opacity":"1"});
         		techPath.$("techTxt").empty();
         		techPath.$("techTxt").html(txtArr[37+clicked]);
         	}
         	if (clicked<1){
         		techPath.$("techBack").fadeOut(0);
         	}
         	if (clicked>2){
         		techPath.$("techNext").fadeOut(0);
         	}
         }
         techReset();
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	tableWidth=sym.$("tableMc").width();
         	techWidth=sym.$("techMc").width();
         	sym.$("panelBtn").css({"left":(stageWidth-40)+"px"});
         	sym.$("tableBtn").css({"left":(stageWidth-80)+"px"});
         	sym.$("scrollMc").css({"width":"100%"});
         	speed = 0;
         
         	if (stageWidth<640){
         		sym.$("tableMc").css({"left":"0px","width":"100%"});
         		sym.$("techMc").css({"width":"100%"});
         		tableWidth=sym.$("tableMc").width();
         		techWidth=sym.$("techMc").width();
         		sym.$("tableBtn").css({"top":"0px"});
         		sym.$("scrollMc").css({'overflow-x':'auto'});
         		panelClose();
         	}else{
         		sym.$("tableMc").css({"left":"320px","width":"320px"});
         		sym.$("techMc").css({"width":"316px"});
         		tableWidth=sym.$("tableMc").width();
         		techWidth=sym.$("techMc").width();
         		sym.$("tableBtn").css({"top":"-50px"});
         		sym.$("scrollMc").css({'overflow-x':'hidden'});
         		panelClose();
         	}
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         		sym.getSymbol("tableMc").$("txt18").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt19").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt20").css({"left":tableWidth-70 + "px"});
         		sym.getSymbol("tableMc").$("txt21").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt22").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt23").css({"left":tableWidth-70 + "px"});
         		sym.getSymbol("tableMc").$("txt24").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt25").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt26").css({"left":tableWidth-70 + "px"});
         		sym.getSymbol("tableMc").$("txt27").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt28").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt29").css({"left":tableWidth-70 + "px"});
         		sym.getSymbol("tableMc").$("txt31").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt32").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt33").css({"left":tableWidth-70 + "px"});
         		sym.getSymbol("tableMc").$("txt34").css({"width":"40%"});
         		sym.getSymbol("tableMc").$("txt35").css({"left":"55%", "width":"20%"});
         		sym.getSymbol("tableMc").$("txt36").css({"left":tableWidth-70 + "px"});
         		techPath.$("techNext").css({'left':techWidth-40 + 'px'});
         	setStyle();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	var dotPos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotMc").position();
         	if (stageWidth <530){
         		if(dotPos.left > stageWidth-100){
         			sym.$("scrollMc").stop().animate({scrollLeft: 200}, 500);
         		} else if(dotPos.left < stageWidth-110){
         			sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         		} else {
         			sym.$("scrollMc").stop().animate({scrollLeft: 150}, 500);
         		}
         	} else {
         		sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         	}
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         	if (pos == 0 || pos == 8100) {
         		stopTimer();
         		initSize();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         //********************************************************************************************************
         // PLAY BUTTON
         //********************************************************************************************************
         sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("playBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	startTimer();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").play(0);
         	});
         
         //********************************************************************************************************
         // ARABIC RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		stageWidth=sym.$("Stage").width();
         		tableWidth=sym.$("tableMc").width();
         		techWidth = sym.$("techMc").width();
         
         		sym.$("panelBtn").css({"left":"0px"});
         		sym.$("tableBtn").css({"left":"40px"});
         
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'width':(stageWidth-100) + 'px'});
         		sym.getSymbol("styleHead").$("iconMc").css({'left':(stageWidth-50) + 'px'});
         
         		tablePath.$("txt15").css({"text-align":"right"});
         		tablePath.$("txt16").css({"text-align":"left"});
         		tablePath.$("txt17").css({"text-align":"left"});
         		tablePath.$("or").css({"text-align":"left"});
         		tablePath.$("wr").css({"text-align":"left"});
         		tablePath.$("txt30").css({"text-align":"right"});
         		tablePath.$("iconMan0").css({"left":tableWidth-30 + "px"});
         		tablePath.$("iconMan1").css({"left":tableWidth-30 + "px"});
         		tablePath.$("iconMan2").css({"left":tableWidth-30 + "px"});
         		tablePath.$("iconMan3").css({"left":tableWidth-30 + "px"});
         		tablePath.$("iconWoman0").css({"left":tableWidth-30 + "px"});
         		tablePath.$("iconWoman1").css({"left":tableWidth-30 + "px"});
         		tablePath.$("txt18").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt19").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt20").css({"text-align":"left", "left":"5px"});
         		tablePath.$("txt21").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt22").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt23").css({"text-align":"left", "left":"5px"});
         		tablePath.$("txt24").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt25").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt26").css({"text-align":"left", "left":"5px"});
         		tablePath.$("txt27").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt28").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt29").css({"text-align":"left", "left":"5px"});
         		tablePath.$("txt31").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt32").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt33").css({"text-align":"left", "left":"5px"});
         		tablePath.$("txt34").css({"text-align":"right", "width":"40%", "left":"50%"});
         		tablePath.$("txt35").css({"text-align":"right", "left":"25%", "width":"20%"});
         		tablePath.$("txt36").css({"text-align":"left", "left":"5px"});
         		techPath.$("techBack").css({'left':techWidth-40 + 'px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		techPath.$("techNext").css({'left':'0px', 'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});		}
         }
         checkRTL();
         
         if (RTL == true){
         	for (var i=0; i<calArray.length; i++){
         		calArray[i].getSymbolElement().css({'top':'24px', 'left':'-2px'});
         		calArray[i].getSymbolElement().css({'position':'relative','float':'right'});
         	}
         	sym.getSymbol("panelMc").$("calPeeps").css({"left":"60px"});
         	sym.getSymbol("panelMc").$("txt2").css({"text-align":"right"});
         	techPath.$("techNext").css({'left':'0px', 'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	sym.getSymbol("styleHead").$("textureMc").css({'left':'0px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("techMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'dateBox'
   (function(symbolName) {   
   
   })("dateBox");
   //Edge symbol end:'dateBox'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'calPeeps'
   (function(symbolName) {   
   
   })("calPeeps");
   //Edge symbol end:'calPeeps'

   //=========================================================
   
   //Edge symbol: 'playBtn'
   (function(symbolName) {   
   
   })("playBtn");
   //Edge symbol end:'playBtn'

   //=========================================================
   
   //Edge symbol: 'iconMc'
   (function(symbolName) {   
   
   })("iconMc");
   //Edge symbol end:'iconMc'

   //=========================================================
   
   //Edge symbol: 'textureMc'
   (function(symbolName) {   
   
   })("textureMc");
   //Edge symbol end:'textureMc'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
   })("keyMc");
   //Edge symbol end:'keyMc'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'iconMan'
   (function(symbolName) {   
   
   })("iconMan");
   //Edge symbol end:'iconMan'

   //=========================================================
   
   //Edge symbol: 'iconMan_1'
   (function(symbolName) {   
   
   })("iconWoman");
   //Edge symbol end:'iconWoman'

   //=========================================================
   
   //Edge symbol: 'techMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("techMc");
   //Edge symbol end:'techMc'

   //=========================================================
   
   //Edge symbol: 'techBtn'
   (function(symbolName) {   
   
   })("techBtn");
   //Edge symbol end:'techBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34456");