/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var panelVis = false;
         	var speed = 200;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", 'padding-left':'50px'});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var yellowTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#f9a51a", "height":"auto", "padding":"6px"};
         
         	var redTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"#fff",
         	"background-color":"#da0000", "height":"auto","width":"auto", "padding":"6px"};
         
         	var whiteTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"black",
         	"background-color":"rgba(255,255,255,0.5)", "height":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // ADD CALENDAR
         //********************************************************************************************************
         calArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 38; i++){
          var calObject = sym.createChildSymbol("dateBox", "panelMc");  // Create an instance element of a symbol as a child of the given parent element
          calObject.setVariable("id", i);  //set the value of a Symbol variable
          calArray.push(calObject);  //push it into the array
         }
         
         for (var i=0; i<calArray.length; i++){
         	calArray[i].getSymbolElement().css({'top':'24px', 'left':'4px'});
         	calArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	calArray[i].$('no').css({"color":"white"});
         }
         for (var i=0; i<7; i++){
         	calArray[i].$('bgRight').css({'background-color':'#fff'});
         	calArray[i].$('bgLeft').css({'background-color':'#fff'});
         }
         for (var i=7; i<11; i++){
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=28; i<38; i++){
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=7; i<38; i++){
         	calArray[i].$('no').html(i-6);
         }
         calArray[22].$('bgRight').css({'background-color':'#1382c5'});
         calArray[22].$('bgLeft').css({'background-color':'#1382c5'});
         
         calArray[21].$('bgRight').css({'background-color':'#e21932'});
         calArray[21].$('bgLeft').css({'background-color':'#e21932'});
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	txt[0] = sym.getSymbol("panelMc").$("txt0").css({"pointer-events":"none"}); // month
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"}); // days of week
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	for (var i=3; i<14; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=14; i<19; i++){
         		txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=19; i<23; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[23] = mapPath.$("txt23").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34439.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<24; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			var dayString = $(xml).find('txt1').text();
                  weekDays = dayString.split(";");
                  for (var w=0; w<7; w++){
         				calArray[w].$('no').html(weekDays[w]);
         				calArray[w].$('no').css({"color":"gray"});
         			}
         
         			sym.getSymbol("panelMc").$("txt17").css(yellowTxtBox);
         			sym.getSymbol("panelMc").$("txt18").css(yellowTxtBox);
         			mapPath.$("txt4").css(whiteTxtBox);
         			mapPath.$("txt6").css({"line-height":"20px"});
         			sym.getSymbol("panelMc").$("txt15").css({"line-height":"20px"});
         			mapPath.$("txt20").css({"line-height":"20px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // PANEL BTN
         //********************************************************************************************************
         mapPath.$("panelBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		panelCheck();
         	});
         
         function panelCheck(){
         	if (panelVis == false){
         		speed = 200;
         		panelOpen();
         	}else{
         		speed = 200;
         		panelClose();
         	}
         }
         function panelClose(){
         	sym.$("panelMc").stop().animate({left:stageWidth+10}, speed, 'easeOutCubic');
         	mapPath.getSymbol("panelBtn").$("plus").fadeIn(0);
         	if (stageWidth<640){
         		sym.$("pointTop").fadeOut(0);
         		sym.$("pointBot").fadeOut(0);
         	} else {
         		 panelOpen();
         	}
         	panelVis = false;
         }
         function panelOpen(){
         	sym.$("panelMc").stop().animate({left:stageWidth-160}, speed, 'easeOutCubic');
         	mapPath.getSymbol("panelBtn").$("plus").fadeOut(0);
         	sym.$("pointTop").fadeIn(0);
         	sym.$("pointBot").fadeIn(0);
         	panelVis = true;
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	speed = 0;
         
         	if (stageWidth<640){
         		sym.$("scrollMc").css({"width":stageWidth+"px"});
         		panelClose();
         	}else{
         		sym.$("scrollMc").css({"width":(stageWidth-160)+"px"});
         		mapPath.$("box1").fadeIn(0);
         		mapPath.$("box2").fadeIn(0);
         		mapPath.$("panelBtn").fadeOut(0);
         		panelOpen();
         	}
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("scrollMc").css({'overflow-x':'auto'});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("scrollMc").css({'overflow-x':'hidden'});
         	}
         	playStop();
         	setStyle();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         var playing = true;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	stageWidth=sym.$("Stage").width();
         	playing = true;
         	playStop();
         	var pos = mapPath.getPosition();
         	var dotPos = mapPath.$("dotMc").position();
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         
         	if (stageWidth <470){
         		if(dotPos.left < stageWidth-180){
         			sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         		} else {
         			sym.$("scrollMc").stop().animate({scrollLeft: 150}, 500);
         		}
         	} else {
         		sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         	}
         
         	if (pos == 0 || pos == 15000) {
         		stopTimer();
         		initSize();
         		playing = false;
         		playStop();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         function playStop(){
         	if (playing == true){
         		mapPath.$("playBtn").fadeOut(0);
         		mapPath.$("panelBtn").fadeOut(0);
         		if (stageWidth<640){
         			mapPath.$("dot1").fadeIn(0);
         			mapPath.$("dotTxt1").fadeIn(0);
         			mapPath.$("dot5").fadeIn(0);
         			mapPath.$("dotTxt5").fadeIn(0);
         			mapPath.$("box1").fadeOut(0);
         			mapPath.$("box2").fadeOut(0);
         		} else {
         			mapPath.$("box1").fadeIn(0);
         			mapPath.$("box2").fadeIn(0);
         			mapPath.$("dot1").fadeOut(0);
         			mapPath.$("dotTxt1").fadeOut(0);
         			mapPath.$("dot5").fadeOut(0);
         			mapPath.$("dotTxt5").fadeOut(0);
         		}
         	} else {
         		mapPath.$("playBtn").fadeIn(0);
         		if (stageWidth<640){
         			mapPath.$("panelBtn").fadeIn(0);
         			mapPath.$("box1").fadeIn(0);
         			mapPath.$("box2").fadeIn(0);
         			mapPath.$("dot1").fadeOut(0);
         			mapPath.$("dotTxt1").fadeOut(0);
         			mapPath.$("dot5").fadeOut(0);
         			mapPath.$("dotTxt5").fadeOut(0);
         		} else {
         			mapPath.$("panelBtn").fadeOut(0);
         			mapPath.$("box1").fadeIn(0);
         			mapPath.$("box2").fadeIn(0);
         		}
         	}
         }
         
         //********************************************************************************************************
         // PLAY BUTTON
         //********************************************************************************************************
         mapPath.$("playBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	startTimer();
         	mapPath.play(0);
         	panelClose();
         	sym.getSymbol("panelMc").play(0);
         	});
         
         //********************************************************************************************************
         // ARABIC RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		stageWidth=sym.$("Stage").width();
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'width':(stageWidth-100) + 'px'});
         		sym.getSymbol("styleHead").$("iconMc").css({'left':(stageWidth-50) + 'px'});
         		if (stageWidth<640){
         		} else {
         		}
         	}
         }
         checkRTL();
         
         if (RTL == true){
         	for (var i=0; i<calArray.length; i++){
         		calArray[i].getSymbolElement().css({'top':'24px', 'left':'-2px'});
         		calArray[i].getSymbolElement().css({'position':'relative','float':'right'});
         	}
         	sym.getSymbol("panelMc").$("calPeeps").css({"left":"60px"});
         	mapPath.$("txt4").css({"text-align":"right"});
         	mapPath.$("txt10").css({"text-align":"right"});
         	sym.getSymbol("panelMc").$("txt17").css({"text-align":"right"});
         	sym.getSymbol("styleHead").$("textureMc").css({'left':'0px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'dateBox'
   (function(symbolName) {   
   
   })("dateBox");
   //Edge symbol end:'dateBox'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'calPeeps'
   (function(symbolName) {   
   
   })("calPeeps");
   //Edge symbol end:'calPeeps'

   //=========================================================
   
   //Edge symbol: 'playBtn'
   (function(symbolName) {   
   
   })("playBtn");
   //Edge symbol end:'playBtn'

   //=========================================================
   
   //Edge symbol: 'iconMc'
   (function(symbolName) {   
   
   })("iconMc");
   //Edge symbol end:'iconMc'

   //=========================================================
   
   //Edge symbol: 'textureMc'
   (function(symbolName) {   
   
   })("textureMc");
   //Edge symbol end:'textureMc'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'btn'
   (function(symbolName) {   
   
   })("btn");
   //Edge symbol end:'btn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34439");