/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var panelVis = false;
         	var speed = 200;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", 'padding-left':'50px'});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var yellowTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#f9a51a", "height":"auto","width":"auto", "padding":"6px"};
         
         	var redTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"#fff",
         	"background-color":"#da0000", "height":"auto","width":"auto", "padding":"6px"};
         
         	var whiteTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"black",
         	"background-color":"#fff", "height":"auto","width":"auto", "padding":"6px", "padding-left":"36px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // ADD CALENDAR
         //********************************************************************************************************
         calArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 38; i++){
          var calObject = sym.createChildSymbol("dateBox", "panelMc");  // Create an instance element of a symbol as a child of the given parent element
          calObject.setVariable("id", i);  //set the value of a Symbol variable
          calArray.push(calObject);  //push it into the array
         }
         
         for (var i=0; i<calArray.length; i++){
         	calArray[i].getSymbolElement().css({'top':'24px', 'left':'4px'});
         	calArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	calArray[i].$('no').css({"color":"white"});
         }
         for (var i=0; i<7; i++){ // DAYS OF WEEK
         	calArray[i].$('bgRight').css({'background-color':'#fff'});
         	calArray[i].$('bgLeft').css({'background-color':'#fff'});
         }
         for (var i=7; i<11; i++){ // HIDE FIRST 4 DAYS IN AUG
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=28; i<38; i++){ // COLOUR DAYS OF OLYMPICS
         	calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         	calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         }
         for (var i=7; i<38; i++){ //ADD DATE NUMBERS TO CALENDAR
         	calArray[i].$('no').html(i-6);
         }
         calArray[27].$('bgRight').css({'background-color':'#1382c5'});
         calArray[27].$('bgLeft').css({'background-color':'#1382c5'});
         
         calArray[20].$('bgRight').css({'background-color':'#e21932'});
         calArray[20].$('bgLeft').css({'background-color':'#e21932'});
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	txt[0] = sym.getSymbol("panelMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"}); // days of week
         	txt[2] = sym.getSymbol("panelMc").$("txt2").css({"pointer-events":"none"});
         	for (var i=3; i<32; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=32; i<38; i++){
         		txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34412.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<38; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			var dayString = $(xml).find('txt1').text();
                  weekDays = dayString.split(";");
                  for (var w=0; w<7; w++){
         				calArray[w].$('no').html(weekDays[w]);
         				calArray[w].$('no').css({"color":"gray"});
         			}
         
         			mapPath.$("txt13").css(yellowTxtBox);
         			mapPath.$("txt13").css({"left":135 - mapPath.$("txt13").width() + "px"});
         
         			mapPath.$("txt17").css(yellowTxtBox);
         			mapPath.$("txt17").css({"left":141 - mapPath.$("txt17").width() + "px"});
         
         			sym.getSymbol("panelMc").$("txt2").css({"height":"auto"});
         			sym.getSymbol("panelMc").$("txt2").css({"top":( 528 - sym.getSymbol("panelMc").$("txt2").height() ) + "px"});
         
         			mapPath.$("txt23").css({"line-height":"20px"});
         			mapPath.$("txt29").css({"line-height":"20px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // PANEL BTN
         //********************************************************************************************************
         sym.$("panelBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		panelCheck();
         	});
         
         function panelCheck(){
         	if (panelVis == false){
         		speed = 200;
         		panelOpen();
         	}else{
         		speed = 200;
         		panelClose();
         	}
         }
         function panelClose(){
         	sym.$("panelMc").stop().animate({left:stageWidth+10}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	panelVis = false;
         
         }
         function panelOpen(){
         	sym.$("panelMc").stop().animate({left:stageWidth-162}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	panelVis = true;
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("panelBtn").css({"left":(stageWidth-40)+"px"});
         	speed = 0;
         
         	if (stageWidth<640){
         		sym.$("scrollMc").css({"width":stageWidth + "px"});
         		sym.$("panelBtn").css({"top":"0px"});
         		panelClose();
         	}else{
         		sym.$("scrollMc").css({"width":(stageWidth-160)+"px"});
         		sym.$("panelBtn").css({"top":"-50px"});
         		panelOpen();
         	}
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("scrollMc").css({'overflow-x':'auto'});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("scrollMc").css({'overflow-x':'hidden'});
         	}
         	setStyle();
         	checkRTL();
         }
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	var dotPos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotMc").position();
         	if (stageWidth <470){
         		if(dotPos.left < stageWidth-160){//180
         			sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         		} else {
         			sym.$("scrollMc").stop().animate({scrollLeft: 80}, 500);//150
         		}
         	} else {
         		sym.$("scrollMc").stop().animate({scrollLeft: 0}, 500);
         	}
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         	if (pos == 0 || pos == 20000) {
         		stopTimer();
         		initSize();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         //********************************************************************************************************
         // PLAY BUTTON
         //********************************************************************************************************
         sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("playBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	startTimer();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").play(0);
         	});
         
         //********************************************************************************************************
         // ARABIC RTL
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		for (var i=32; i<38; i++){
         			txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"text-align":"right"});
         		}
         		sym.getSymbol("panelMc").$("txt33").css({"left":"5px"});
         		sym.getSymbol("panelMc").$("txt34").css({"left":"5px"});
         		sym.getSymbol("panelMc").$("txt36").css({"left":"5px"});
         		sym.getSymbol("panelMc").$("txt37").css({"left":"5px"});
         		sym.getSymbol("panelMc").$("winners").css({"left":"95px"});
         		stageWidth=sym.$("Stage").width();
         		sym.getSymbol("styleHead").$("headlineTxt").css({'text-align':'right', 'width':(stageWidth-100) + 'px'});
         		sym.getSymbol("styleHead").$("iconMc").css({'left':(stageWidth-50) + 'px'});
         		if (stageWidth<640){
         			sym.getSymbol("styleHead").$("iconMc").fadeOut(0);
         		} else {
         			sym.getSymbol("styleHead").$("iconMc").fadeIn(0);
         		}
         	}
         }
         checkRTL();
         
         if (RTL == true){
         	for (var i=0; i<calArray.length; i++){
         		calArray[i].getSymbolElement().css({'top':'24px', 'left':'-2px'});
         		calArray[i].getSymbolElement().css({'position':'relative','float':'right'});
         	}
         	sym.getSymbol("panelMc").$("calPeeps").css({"left":"60px"});
         	sym.getSymbol("panelMc").$("txt2").css({"text-align":"right"});
         	mapPath.$("key").css({"left":"105px", "text-align":"right"});
         	mapPath.$("txt3").css({"text-align":"right"});
         	sym.getSymbol("styleHead").$("textureMc").css({'left':'0px', 'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		closeSource();
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'dateBox'
   (function(symbolName) {   
   
   })("dateBox");
   //Edge symbol end:'dateBox'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'calPeeps'
   (function(symbolName) {   
   
   })("calPeeps");
   //Edge symbol end:'calPeeps'

   //=========================================================
   
   //Edge symbol: 'playBtn'
   (function(symbolName) {   
   
   })("playBtn");
   //Edge symbol end:'playBtn'

   //=========================================================
   
   //Edge symbol: 'iconMc'
   (function(symbolName) {   
   
   })("iconMc");
   //Edge symbol end:'iconMc'

   //=========================================================
   
   //Edge symbol: 'textureMc'
   (function(symbolName) {   
   
   })("textureMc");
   //Edge symbol end:'textureMc'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34412");