/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var panelPath = sym;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var blueTxtLeft = {"border-radius":"5px", "color":"#fff", "background-color":"#46a0d2","width":"auto", "padding":"3px", "padding-left":"16px", "padding-right":"6px", "pointer-events":"none"};
         	var blueTxtRight = {"border-radius":"5px", "color":"#fff", "background-color":"#46a0d2","width":"auto", "padding":"3px", "padding-right":"16px", "padding-left":"6px", "pointer-events":"none"};
         
         	var redTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#ed1c24", "height":"auto","width":"auto", "padding":"6px", "font-size":"15px"};
         	var blueTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#1c75bc", "height":"auto","width":"auto", "padding":"6px", "font-size":"15px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<6; i++){
         		txt[i] = sym.getSymbol("navBtns").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[6] = sym.getSymbol("graphMc").$("txt6").css({"pointer-events":"none", "font-size":"20px"});
         	txt[7] = sym.getSymbol("graphMc").$("txt7").css(blueTxtBox);
         	txt[8] = sym.getSymbol("graphMc").$("txt8").css(redTxtBox);
         
         	var txtArr=[], date=[], dateEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34392.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<9; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         	$(xml).find("timeline").each(function(){
         		var $date=$(this);
         		dateEvents.push($date);
         	});
         
         		changeDate();
         	},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         var dates=[];
         function changeDate() {
         		var $events=dateEvents[0].find('years');
         		panelPath.$("table").empty();
         		panelPath.$("table").scrollTop( 0 );
         		sym.$("mainPic1").stop().animate({opacity:0}, 500);
         		sym.getSymbol("navBtns").$("txt0").html(txtArr[clicked]).css({"font-size":"18px"});
         
         		var i=0;
         		var tableTxt="<table id='datestable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			if($event.attr('number')==clicked){//only get the event that matches 
         				var $dates=$event.find("dates");
         				$dates.each(function(){
         					var $dates=$(this);
         					var dates=$dates.find("date").text();
         					tableTxt+="<td id='"+"dateId"+i+"' class='"+"dateCl'>"+dates+"</td>";
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		panelPath.$("table").append(tableTxt); //Then attach the buttons:
         		$("#datestable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px", "line-height":"19px",'border-collapse':'collapse', 'width':'100%'});
         		$("#datestable tr:odd").css({"background-color":"rgba(0,0,0,0.1)",'border-color':"rgb(255,255,255)","border-width":"6px 0","border-style":"solid","opacity":"0.95"});
         		$("#datestable tr:even").css({"background-color":"rgba(0,0,0,0.0)",'border-color':"rgb(255,255,255)","border-width":"6px 0","border-style":"solid","opacity":"0.95"});
         		$(".dateCl").css({'width':'90%', "font-weight":"regular", 'padding':'6px', 'text-align':'left'});
         
         		sym.getSymbol("navBtns").$("btnNavNext").fadeIn(0);
         		sym.getSymbol("navBtns").$("btnNavBack").fadeIn(0);
         		if (clicked>4){
         			sym.getSymbol("navBtns").$("btnNavNext").fadeOut(0);
         		}
         		if (clicked<1){
         			sym.getSymbol("navBtns").$("btnNavBack").fadeOut(0);
         		}
         
         		sym.getSymbol("mainPicMc").$("mainPic0").attr("src", "images/trump" + clicked + ".jpg");
         		sym.getSymbol("mainPicMc").play("pic"+clicked);
         
         		if (clicked == 4){
         			sym.$("mainPic0").stop().animate({opacity:0}, 0);
         			sym.$("graphMc").stop().animate ({opacity:1}, 500);
         			sym.getSymbol("graphMc").play(0);
         		} else{
         			sym.$("graphMc").stop().animate ({opacity:0}, 100);
         			sym.$("mainPic0").stop().animate({opacity:1}, 500);
         		}
         
         		checkRTL();
         		sourceOut();
         }
         
         sym.$("table").scroll(function() {
         	var scrollTop = sym.$("table").scrollTop();
         	sym.$("mainPic1").attr("src", "images/trump"+(clicked)+(clicked)+".jpg");
         	scrollH = this.scrollHeight - this.scrollTop === this.clientHeight;
         	if (scrollH == true) {
         		sym.$("mainPic1").stop().animate({opacity:1}, 500);
         	} else {
         		sym.$("mainPic1").stop().animate({opacity:0}, 500);
         	}
         });
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	checkRTL();
         	setStyle();
         	sourceOut();
         }
         
         //********************************************************************************************************
         // NAV ARROW BUTTONS
         //********************************************************************************************************
         sym.getSymbol("navBtns").$("btnNavNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	changeDate();
         });
         sym.getSymbol("navBtns").$("btnNavBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	changeDate();
         });
         
         //********************************************************************************************************
         // NAV SWIPE
         //********************************************************************************************************
         sym.$("swipeImg").on("swipeleft",function(){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	if (clicked>5){
         		clicked = 5;
         	}
         	changeDate();
         });
         sym.$("swipeImg").on("swiperight",function(){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	if (clicked<1){
         		clicked = 0;
         	}
         	changeDate();
         });
         //********************************************************************************************************
         // RTL CHECK
         //********************************************************************************************************
         function checkRTL(){
         	if (RTL == true){
         		var stageWidth=sym.$("Stage").width();
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		$(".dateCl").css({'text-align':'right'});
         		sym.getSymbol("navBtns").$("btnNavNext").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)', "left":"0px"});
         		sym.getSymbol("navBtns").$("btnNavBack").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)', "left":(stageWidth-40) + "px"});
         	}
         }
         checkRTL();
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sourceOut();
         	}
         }); 
         function sourceOut(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'btnNav'
   (function(symbolName) {   
   
   })("btnNav");
   //Edge symbol end:'btnNav'

   //=========================================================
   
   //Edge symbol: 'graphMc'
   (function(symbolName) {   
   
   })("graphMc");
   //Edge symbol end:'graphMc'

   //=========================================================
   
   //Edge symbol: 'mainpicMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("mainpicMc");
   //Edge symbol end:'mainpicMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNEWS34392");