/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
var gnYear=2016;
var gnNo=34329;// 33855
var classifications=[1510198,1695151,1695152,1695154,1695155]; //  General, Points, Mountain, Youth/Combination
var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
var todayDate = new Date();
var startDate= Date.UTC(2016,06,03,11,49,59);
var clickEventType = ('touchstart click');
var mob=0, mobOpen=false, clickIcon=0, btnWidth=0, btnHeight=0, teamNo=0, stgMove=0, move=32, stageMove=160, teamNo=0, scrollBar=0;
//********************************************************************************************************
//DATE FUNCTIONS
//********************************************************************************************************
function getMatchLocal(thisDateStr){
	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
	var thisDate = new Date(parseInt(timeTxt, 10));
	var hh = thisDate.getHours();
	var mm = parseInt(thisDate.getMinutes(),10);
	mm=(mm<10)?"0"+mm:mm;
	return hh+":"+mm;
}
//********************************************************************************************************
// SET UPDATE INTERVAL
//********************************************************************************************************
var raceInterval, stageInterval;
var stageChanger = function(stage){ //to handle lexical scope
	return function (e) {
		clearInterval(stageInterval);
		getStageInfo(stage);
		if(stage==latestStage){
			raceInterval = setInterval(getRace,120000);
			stageInterval = setInterval(function(){getStageInfo(stage);},30000);
		}
	};
};
var classChanger = function(stage){ //to handle lexical scope
	return function (e) {
	getPhase(stage);
	};
};

//********************************************************************************************************
// PATHS
//********************************************************************************************************
var routePath = sym.getSymbol("routeMc").getSymbol("courseScrollMc")
var stageMapPath = sym.getSymbol("stagesMc").getSymbol("stageMapMc");

//********************************************************************************************************
//ADD MAPS
//********************************************************************************************************
var mapArray = []; //the array that will hold references to your new symbols.
for (var i = 0; i < 21; i++){
 var mapSymbol = stageMapPath.createChildSymbol("mapMc"+i, "mapHolderMc");  // Create an instance element of a symbol as a child of the given parent element
	mapSymbol.setVariable("id", i);  //set the value of a Symbol variable
	mapArray.push(mapSymbol);  //push it into the array
}
//********************************************************************************************************
//ADD PROFILES
//********************************************************************************************************
var profileArray = []; //the array that will hold references to your new symbols.
for (var i = 0; i < 21; i++){
 var profileSymbol = sym.createChildSymbol("profileMc"+i, "stagesMc");  // Create an instance element of a symbol as a child of the given parent element
 profileSymbol.setVariable("id", i);  //set the value of a Symbol variable
 profileArray.push(profileSymbol);  //push it into the array
 profileArray[i].getSymbolElement().animate ({top:0}, 0);
}

//********************************************************************************************************
//ADD TEAM BUTTONS
//********************************************************************************************************
var teamArray = []; //the array that will hold references to your new symbols.
for (var i = 0; i < 22; i++){
 var mySymbolObject =  sym.getSymbol("teamsMc").createChildSymbol("teamJerseyBtn", "teamBtnHolder");  // Create an instance element of a symbol as a child of the given parent element
 mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
 teamArray.push(mySymbolObject);  //push it into the array
}

//********************************************************************************************************
// SET TEXT
//********************************************************************************************************
	var yellow  = {"background-color":"#ffac3a"};
	var red  = {"background-color":"rgb(225,125,140)"};
	var grey  = {"background-color":"#808080"};
	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
	var overBtn = {"background-color":"rgba(218,0,0,1)"};
	var mapStart = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "pointer-events":"none", "background-color":"#FAAB18", "height":"auto", "width":"auto", "padding":"4px"};
	var mapFinish = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "pointer-events":"none", "background-color":"#FAAB18", "height":"auto", "width":"auto", "padding":"4px"};
	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
	var keyBox = {"border-width":"2px","border-style":"solid", "border-radius":"5px", "border-color":"#808080", "pointer-events":"none","background-color":"white", "height":"auto", "width":"auto", "padding":"6px"};
	var mapStart = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "pointer-events":"none","background-color":"#FAAB18", "height":"auto", "width":"auto", "padding":"4px"};
	var mapFinish = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "pointer-events":"none","background-color":"#FAAB18", "height":"auto", "width":"auto", "padding":"4px"};
//********************************************************************************************************
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var headlinemob;
	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
	var source;
	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
	var stagestring;
	var datestring;

	var menuTxt=[];
	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
	menuTxt[3] = sym.$("menuTxt").css({"pointer-events":"none"});
	var menuArr=[];

	var txt=[];
	txt[0] = sym.getSymbol("calendarMc").$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.getSymbol("calendarMc").$("txt1").css({"pointer-events":"none"});
	txt[2] = sym.getSymbol("calendarMc").$("txt2").css({"pointer-events":"none"});
	txt[3] = routePath.$("txt3").css(keyBox);
	txt[4] = sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt4").css({"pointer-events":"none"});
	for (var i=5; i<14; i++){
		txt[i] = routePath.$("txt"+i).css({"pointer-events":"none"});
	}
	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("results").getSymbol("resultsScaleMc").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.getSymbol("results").getSymbol("resultsScaleMc").$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.getSymbol("results").$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
	txt[22] = sym.getSymbol("teamsMc").$("txt22").css({"pointer-events":"none"});
	txt[23] = stageMapPath.$("txt23").css({"pointer-events":"none"});
	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
	txt[28] = sym.getSymbol("stagesMc").$("txt28").css({"pointer-events":"none"});
	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
	txt[30] = sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("txt30").css({"pointer-events":"none"});
	txt[31] = sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("txt31").css({"pointer-events":"none"});
	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
	txt[33] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classificationsBtn").$("phaseTxt").css({"pointer-events":"none"});
	txt[34] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn0").$("classTxt").css({"pointer-events":"none"});
	txt[35] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn1").$("classTxt").css({"pointer-events":"none"});
	txt[36] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn2").$("classTxt").css({"pointer-events":"none"});
	txt[37] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn3").$("classTxt").css({"pointer-events":"none"});
	txt[38] = sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn4").$("classTxt").css({"pointer-events":"none"});
	txt[39] = sym.$("txt17").css({"pointer-events":"none"});
	txt[40] = sym.$("txt18").css({"pointer-events":"none"});
	txt[41] = sym.$("txt41").css({"pointer-events":"none"})
	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
	txt[49] = sym.$("txt49").css({"pointer-events":"none"});

	var menuArr=[], txtArr=[], nameArr=[], countryArr=[], ridersArr=[], riderNoArr=[], riderNatArr=[], nameShortArr=[], stageIDs=[], riderActive=[];
	for (var t=0;t<22;t++){ //arrays for each team
		ridersArr[t]=[];
		riderNoArr[t]=[];
		riderNatArr[t]=[];
		riderActive[t]=[];//MAY 4
	}
	var string0, string1, string2, string3, string4, string5, stagestring, datestring, tablestring, resultstring0, resultstring1, resultstring2, distancekm, distancemap, mediterranean;
//Stage array (includes map and profile captions)
	var profilekey, mapkey, keystring;
//end
	var mapStart, mapFinish;

	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN"+gnNo+".xml",
		dataType: "xml",
		success: function(xml) {
			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			headSize = $(xml).find('headSize').text();
			headlinemob = $(xml).find('headlinemob').text();
			headlinetxtmob.html(headlinemob);
			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
			source = $(xml).find('source').text();
			sourcetxt.html(source);

			// MENU TEXT START
			for (var i=0; i<4; i++){
				menuArr[i]=$(xml).find('menuTxt'+i).text();
				menuTxt[i].html(menuArr[i]);
			} // MENU TEXT END

			var fontSize= $(xml).find('fontSize').text();
			for (var i=0; i<50; i++){
				txtArr[i]=$(xml).find('txt'+i).text();
				txt[i].html(txtArr[i]);
				txt[i].css({'font-size':fontSize});
			}

			//sym.getSymbol("results").$("txt19").css({"background-color":"#fff", "padding":"8px"});
			//sym.getSymbol("results").$("txt7").animate({top:528 - sym.getSymbol("results").$("txt7").height()-3}, 0);

			sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("txt3").animate({top:510 - sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("txt3").height()-3}, 0);
			sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").html(txtArr[32]);
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("table").html(txtArr[32]);
			//sym.getSymbol("routeMc").$("txt20").html(txtArr[46]);
			for (var t=0;t<22;t++){		//get details for each team
				$(xml).find("team"+t).each(function(){
					var $teams = $(this);
					nameArr[t]=$teams.find('teamName').text();
					countryArr[t]=$teams.find('country').text();
					nameShortArr[t]=$teams.find('nameShort').text();		

					teamArray[t].$("jersey").attr("src", "teams/" + nameShortArr[t] + ".png");
					teamArray[t].$("classTxt").html(nameShortArr[t]);

					$teams.find("rider").each(function(){
					var $rider = $(this);
						riderNoArr[t].push($rider.find('number').text());
						ridersArr[t].push($rider.find('name').text());
						riderNatArr[t].push($rider.find('nation').text());
						riderActive[t].push(1);//MAY 4
					});

				});
			}
			var stringDate = $(xml).find('txt1').text(); // Stage date for stage btn info
         datestring=stringDate.split("<br>");
         var stringDistance = $(xml).find('txt2').text(); // Stage date for stage btn info
         distancestring=stringDistance.split("<br>");
			txtArr[1]=$(xml).find('txt1').text(datestring[0]+" "+datestring[1]); // Stage + number for stage btn info

			distance = $(xml).find('distancekm').text();
			distancemap = $(xml).find('distancemap').text();
			mapStart = $(xml).find('mapStart').text();
			mapFinish = $(xml).find('mapFinish').text();
	routeArr=[];
	var distArr=[], capsArr=[], stageRoute;
		for (var s=0;s<21;s++){			//get details for each race
		routeArr[s]=[]; //array of place names for each stage e.g. routeArr[0] is an array of names
		distArr[s]=[]; //array of distances for each stage e.g. distArr[0] is an array of numbers	
		$(xml).find("stage"+s).each(function(){
		var $stages = $(this);
		var stageRoute=$stages.find('route').text();
		routeArr[s]=stageRoute.split(";"); //array of place names for each stage, split by ";" 
		var stageDistance=$stages.find('distance').text();
		distArr[s]=stageDistance.split(";");//array of distances for each stage, split by ";" 
		var stageTotalLen=distArr[s].length;
		stageTotal=distArr[s][stageTotalLen-1]; //total distance = final distance in list
		var capsExtra=$stages.find('caps').text();
		capsArr[s]=capsExtra.split(";")

		for (var r=0;r<routeArr[s].length; r++){//ensure txtboxnames match - stagetxt0, stagetxt1, etc
				profileArray[s].$("stagetxt"+r).html(routeArr[s][r]);

				if (r==0){
					mapArray[s].$("maptxt0").html(mapStart +" "+ routeArr[s][0]);//first caption on map
				}else if(r==routeArr[s].length-1){
					mapArray[s].$("maptxt1").html(mapFinish +" "+ routeArr[s][r]);//last caption on map
				}
			}
			for (var d=0;d<distArr[s].length; d++){//ensure txtboxnames match - stagedst0, stagedst1, etc map0_dst1
				profileArray[s].$("stagedst"+d).html(distArr[s][d]);//e.g. 25
				if(d<distArr[s].length-1){
				mapArray[s].$("mapdst"+d).html(distArr[s][d]+distance);//e.g. 25km
				}
			}
			if(capsArr[s].length>0){
				for (var c=0;c<capsArr[s].length;c++){
					mapArray[s].$("cap"+c).html(capsArr[s][c]);//e.g. ROMA
				}
			}
		});
	}
	$(".hrule hr").css({'color':'#CCCCCC','background-color':'#CCCCCC'});
	$(".map i").css({'display':'none'});
	//mapArray[19].$("france").html(txtArr[5]);
	//mapArray[19].$("italy").html(txtArr[6]);

	routePath.$("txt5").css({'font-size':'20px'});

	routePath.$("txt10").css({"border-width":"1px", "border-style":"solid", "border-radius":"5px", "border-color":"white", "background-color":"#FAAB18", "height":"auto", "padding":"4px"});

	routePath.$("txt11").css({"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "background-color":"#FAAB18", "height":"auto", "width":"auto", "padding":"4px"});

	sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt4").css({'font-size':'16px'});

	},
	complete:function(){
		initSize();
		teamLoad();
		loadTable();
		},
	}); // END XML

//********************************************************************************************************
// MENU BUTTONS
//********************************************************************************************************
	menuArray = []; //the array that will hold references to the buttons.
	for (var h = 0; h < 4; h++){
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+h).$("artwork").stop().animate({top:h*(-40)-139});
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}

	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind (clickEventType, {menuId:count}, menuBtnClick);
	})

	function resetmenu(){
		var stageWidth=sym.$("Stage").width();
		if (mobOpen == true) {
			mob = 1;
			menuMob();
		}
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("bg").css(grey);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("bg").css(yellow);
		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuMenu_id]);
		var endMc=sym.getSymbol("routeMc").getSymbol("courseScrollMc").getDuration();
		var playMc=sym.getSymbol("routeMc").getSymbol("courseScrollMc").getPosition();
		sym.$("routeMc").fadeOut(500);
		sym.$("stagesMc").fadeOut(500);
		sym.$("teamsMc").fadeOut(500);
		sym.$("results").fadeOut(500);

		if (menuMenu_id==0) {
			sym.$("routeMc").stop().fadeIn(100);
			sym.$("calendarMc").stop().animate({opacity:1}, 0);
			sym.$("calBtn").stop().animate({opacity:1}, 0);
			if (playMc<endMc){
				sym.getSymbol("routeMc").getSymbol("courseScrollMc").play(playMc);
				startTimer();
			}
		}
		if (menuMenu_id==1) {
			sym.$("stagesMc").stop().fadeIn(500);
			stageLoad();
		}
		if (menuMenu_id==2) {
			sym.$("teamsMc").stop().fadeIn(500);
			loadTable();
			teamLoad();
		}
		if (menuMenu_id==3) {
			sym.$("results").stop().fadeIn(500);
		}
	}
sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(yellow);

//********************************************************************************************************
// MOBILE MENU BUTTON
//********************************************************************************************************
sym.$("menuBtnMob").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (mobOpen == true) {
		mob = 1;
	} else {
		mob = 2;
	}
	menuMob();
});
function menuMob() {
	if (mob == 0){ // HIDE MOBILE MENU
		for (var s=0; s<4; s++){ sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:205+(s*40)}, 200, 'easeOutCubic'); }
	}
	if (mob == 1){ // MOBILE MENU CLOSED
		for (var s=0; s<4; s++){ sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:325}, 200, 'easeOutCubic'); }
		mobOpen = false;
	}
	if (mob == 2){ // MOBILE MENU OPEN
		for (var s=0; s<4; s++){ sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic'); }
		mobOpen = true;
	}
}

//********************************************************************************************************
// START TEAM BUTTONS
//********************************************************************************************************
function traceSelected (teamBtnSymbols){
		var teamId = teamBtnSymbols.getVariable("id");
		resetTeam();
		teamNo = teamId;
		teamLoad();
		loadTable();
}

$.each(teamArray, function( count, teamBtnSymbols ){ //a 'for each' loop through the newly populated array.
 var teamItem = $(teamBtnSymbols); //create jQuery reference to the item - not really needed here but shows how to do it.
 var teamElement = $(teamBtnSymbols.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
 teamElement.bind ("click",function(){traceSelected(teamBtnSymbols);});
})

function resetTeam(){
	for (var i=0; i<22; i++){
		teamArray[i].$("btnBg").css({'background-color':'#f0f0f0'});
		teamArray[i].$("jersey").attr("src", "teams/" + nameShortArr[i] + ".png");
		teamArray[i].$("classTxt").html(nameShortArr[i]);
	}
}
resetTeam();

teamArray[0].$("btnBg").css({'background-color':'#CCCCCC'});

function teamLoad(){
		sym.getSymbol("teamsMc").$("teamMain").stop().fadeOut(0, function(){ 
				sym.getSymbol("teamsMc").$("teamMain").attr("src", "teams/" + nameShortArr[teamNo] + ".png");
				sym.getSymbol("teamsMc").$("teamMain").stop().fadeIn(300); 
				});
		sym.getSymbol("teamsMc").$("teamName").html(nameArr[teamNo]);
		sym.getSymbol("teamsMc").$("country").html(countryArr[teamNo]);
		teamArray[teamNo].$("btnBg").css(yellow);

		if (teamNo == 2||teamNo == 5||teamNo == 8||teamNo == 16||teamNo == 18){
			sym.getSymbol("teamsMc").$("UCLlogo").fadeOut(0);
			sym.getSymbol("teamsMc").$("txt22").fadeOut(0);
		}else{
			sym.getSymbol("teamsMc").$("UCLlogo").fadeIn(0);
			sym.getSymbol("teamsMc").$("txt22").fadeIn(0);
		}
	}
	// TABLE START
function loadTable(){
	sym.getSymbol("teamsMc").$("tableTeams").empty();
	htmlOutput = '<table width="100%" border="0" cellpadding="4" cellspacing="0">';
	for (var n=0;n<ridersArr[teamNo].length;n++){
	htmlOutput+='<tr class="active'+riderActive[teamNo][n]+'"><td  class="riderNo">'+ riderNoArr[teamNo][n] +'</td><td  class="riderName">'+ ridersArr[teamNo][n] +'</td><td class="riderNat">'+ riderNatArr[teamNo][n] +'</td></tr>';
	}//MAY 4
	htmlOutput += '</table>';
	sym.getSymbol("teamsMc").$("tableTeams").append(htmlOutput);
	sym.getSymbol("teamsMc").$("table tr:odd").css({"text-align":"left", "background-color":'rgba(0,0,0,0.2)',"color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
	sym.getSymbol("teamsMc").$("table tr:even").css({"text-align":"left", "background-color":'rgba(0,0,0,0.1)',"color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
	$(".active0").css({"color":"rgb(100,100,100)",'font-style':'oblique'});
	$(".riderNo").css({'width':'10%','border':'solid 0 #FFF','border-top-width':'1px','padding-left':'5px'})
	$(".riderName").css({'width':'65%','border':'solid 0 #FFF', 'border-top-width':'1px'});
	$(".riderNat").css({'width':'25%','border':'solid 0 #FFF', 'border-top-width':'1px','padding-right':'5px','font-style':'oblique'});
}
loadTable();
// TABLE END
// END TEAM BUTTONS

//******************************************************************************************************************************************
// START STAGE BUTTONS
//******************************************************************************************************************************************
sym.getSymbol("stagesMc").$("stageNavBtnBack").on('touchstart click', function(e){
	resetstage();
	clearInterval(raceInterval);
	stgMove--;
	fadeProfilesOut();
	stageLoad();
	getStageInfo(stageIDs[stgMove]);
		if(stageIDs[stgMove]==latestStage){
			raceInterval = setInterval(getRace,120000);
			stageInterval = setInterval(function(){getStageInfo(stageIDs[stgMove]);},30000);
		}
});
sym.getSymbol("stagesMc").$("stageNavBtnNext").on('touchstart click', function(e){
	resetstage();
	clearInterval(raceInterval);
	stgMove++;
	fadeProfilesOut();
	stageLoad();
	getStageInfo(stageIDs[stgMove]);
		if(stageIDs[stgMove]==latestStage){
			raceInterval = setInterval(getRace,120000);
			stageInterval = setInterval(function(){getStageInfo(stageIDs[stgMove]);},30000);
		}
});
stageArray = []; //the array that will hold references to the buttons.
for (var a = 0; a < 21; a++){
		var stageBtnSymbols = sym.getSymbol("stagesMc").getSymbol("stageBtnsMc").getSymbol("stageBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		stageBtnSymbols.setVariable("stageId", a); //set the value of a Symbol variable
		stageArray.push(stageBtnSymbols); //push it into the array

		sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("stageBtn" +a).on ('touchstart click', {menuId:1}, menuBtnClick);
}
$.each(stageArray, function( count, stageInTheArray ){ //a 'for each' loop through the newly populated array
		var stageBtnItem = $(stageInTheArray); //create jQuery reference to the item
		var stageBtnElement = stageInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		stageBtnElement.bind ('touchstart click', {stageId:count}, stageBtnClick);
	})
function resetstage(){
		sym.getSymbol("stagesMc").$("liveline").css({'width':'0%'});
      sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").empty();
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("preloader").fadeIn(400);
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("weather").attr('src','images/weather0.png');
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("wind").attr('src','images/weather0.png');
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("windTxt").html("");
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("preloader").fadeIn(400);
		for (var a=0; a<stageArray.length; a++){
        	stageArray[a].$("btnClick").fadeOut(50);
       	stageArray[a].$("btnOver").fadeOut(50);
       	stageArray[a].$("txt").css({"color":"black"});
		}
	}
resetstage();
function stageBtnClick (e){
		resetstage(); //set them all back to normal state
		clearInterval(raceInterval);
		var stagestage_id = (e.data.stageId); //get the id of the clicked item
		stgMove = stagestage_id;
		fadeProfilesOut();
		stageLoad();
	}
function fadeProfilesOut(){
	for (var p=0;p<21; p++){
		mapArray[p].getSymbolElement().fadeOut(0);
		profileArray[p].getSymbolElement().fadeOut(0);
		}
	}
fadeProfilesOut();
//********************************************************************************************************
// STAGELOAD
//********************************************************************************************************
function stageLoad() {
		var stageWidth=sym.$("Stage").width();
		sym.getSymbol("stagesMc").$("stageBtnsMc").stop().animate({scrollLeft: (stgMove)*32-(stageWidth-128)/2+16}, 500);
		sym.getSymbol("stagesMc").$("profileImg").stop().fadeOut(0, function(){//ONLY FADEIN PROFILE IMAGE AFTER FADEOUT
				sym.getSymbol("stagesMc").$("profileImg").attr("src", "profiles/profile" + stgMove + ".png");
				sym.getSymbol("stagesMc").$("profileImg").stop().fadeIn(300);
				});
		mapArray[stgMove].getSymbolElement().fadeIn(300); // FADE IN MAP DATA
		profileArray[stgMove].getSymbolElement().fadeIn(300); // FADE IN PROFILE DATA

		sym.getSymbol("stagesMc").getSymbol("stageBtnsMc").getSymbol("stageBtn"+stgMove).$("btnClick").fadeIn(0);
		//sym.getSymbol("stagesMc").getSymbol("stageBtnsMc").getSymbol("stageBtn"+stgMove).$("txt").css({'color':'#FFF'});
		sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt4").html(txtArr[4] + " " + ("<b>"+(stgMove + 1)+"</b>") + " - " + (datestring[0]+" "+datestring[stgMove+1]));

		for (var h=stgMove;h<21; h++){
		stageMapPath.$("txt23").html(txtArr[23] + txtArr[24] + txtArr[25]); // ADD PROFILE KEY
		if (stgMove <= 0) {
			sym.getSymbol("stagesMc").$("stageNavBtnBack").fadeOut(0); // FADE OUT BACK BUTTON
		} else {
			sym.getSymbol("stagesMc").$("stageNavBtnBack").fadeIn(0); // FADE IN BACK BUTTON
		}
		if (stgMove == 12||stgMove == 17) {
			stageMapPath.$("txt23").html(txtArr[27]); // ADD INDIVIDUAL TIME TRIAL PROFILE KEY
		}
		if (stgMove >= 20) {
			sym.getSymbol("stagesMc").$("stageNavBtnNext").fadeOut(0); // FADE OUT NEXT BUTTON
		} else {
			sym.getSymbol("stagesMc").$("stageNavBtnNext").fadeIn(0); // FADE IN NEXT BUTTON
		}
		}
		initSize();
	}
for (var r=0;r<21;r++){//Buttons on main map
	sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("stageBtn" +r).on('touchstart click',{stageId:r}, stageBtnClick);
 	sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("stageBtn" +r).on ('touchstart click', {menuId:1}, menuBtnClick);
}
//********************************************************************************************************
//LIVE DATA
//********************************************************************************************************
function resetPhases(){
	sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classificationsBtn").$("tab").css({'background-color':'rgb(206,206,206)'});
	sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classificationsBtn").$("phaseTxt").css({'color':'rgb(100,100,100)'});
}
resetPhases();
var classClicker = function(stage,id){ //to handle lexical scope
							return function (e) {
							getPhase(stage,id);
							txt[39].html(txtArr[39+id]);
							for (i=0;i<5;i++){
									if (i==id){
										sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn"+i).$("classTxt").css({'font-weight':700,'color':'rgb(0,0,0)'});
										sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn"+i).css({'border':'solid 0px rgb(255,0,0)'});
										if(i==1||i==2){
										 txt[40].html(txtArr[45]);
										}else{
											txt[40].html(txtArr[44]);
										}
									}else{
										sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn"+i).$("classTxt").css({'font-weight':400,'color':'rgb(100,100,100)'});
										sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn"+i).css({'border':'solid 0px rgb(255,255,255)'});
									}								
							}
							sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classificationsBtn").$("tab").css({'background-color':'rgb(255,255,255)'});
							sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classificationsBtn").$("phaseTxt").css({'color':'rgb(0,0,0)'});
						};
};
//GET race stage list data
var todayStage=0, latestStage;
function getRace(){
		for (var s=0; s<21; s++){											
			sym.getSymbol("stagesMc").$("stageBtn"+s).off('click',stageChanger);
		}
		stageIDs=[];
		$.ajax({ type: "GET", 
		url: dataURL,
		data: "gn="+gnNo+"&type=cycling&yr="+gnYear+"&q=stages",
		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
		async: true,
		crossDomain: true,
		success: function (data) {
			sym.getSymbol("styleHead").$("menuBtn3").unbind('click');
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("classificationsBtn").unbind('click');
			for (var c=0;c<5;c++){
				sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn"+c).unbind('click');
			}
			for (var i=0; i<data.length; i++){											
					var thisStage=data[i].n_PhaseID;
					stageIDs.push(thisStage);
					if(data[i].b_Current==true){
						todayStage=i;
					}
					if(data[i].b_Live==true){
						var stageFinished='false';
					}else if(data[i].b_Finished==true){
						var stageFinished='true';
					}	
					sym.getSymbol("stagesMc").getSymbol("stageBtnsMc").$("stageBtn"+i).on('click',stageChanger(thisStage));
					sym.getSymbol("menuBtnsMc").$("menuBtn3").off("click").on ("click", {menuId:3}, menuBtnClick);	
			}
			latestStage=data[todayStage].n_PhaseID;
				sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn1").off().on('click',classClicker(classifications[1],1));//Points Classification							  
				sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn2").off().on('click',classClicker(classifications[2],2));//Mountain Classification		
				sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn3").off().on('click',classClicker(classifications[3],3));//Young Rider Classification		

			if (stageFinished=='true'){
						sym.getSymbol("menuBtnsMc").$("menuBtn3").on('click',classClicker(classifications[0],0));//bind classification buttons
			}
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("classificationsBtn").off().on('click',classClicker(classifications[0],0));//bind classification buttons
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("classificationsBtn").css({'cursor':'pointer'});
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn0").off().on('click',classClicker(classifications[0],0));
			sym.getSymbol("results").getSymbol("resultsScaleMc").$("classBtn4").off().on('click',classClicker(classifications[4],4));
		}
   });
}
getRace();
setTimeout(function checkStart(){
	getStageInfo(latestStage);
	if (todayDate>=startDate){
		raceInterval = setInterval(getRace,120000);
		stgMove = todayStage;
		fadeProfilesOut();
		stageLoad();
		stageInterval = setInterval(function(){getStageInfo(latestStage)},30000);
		if (stgMove>0){
			resetmenu;
			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("bg").css(yellow);
			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(grey);
			sym.$("routeMc").fadeOut(800);
			sym.$("stagesMc").fadeIn(800);
			sym.$("results").fadeOut(800);
			sym.$("teamsMc").fadeOut(800);
			sym.getSymbol("routeMc").getSymbol("courseScrollMc").stop(0);
			stopTimer();
		}
	}
},1500);
function getStageInfo(stageID){
sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
sym.getSymbol("stagesMc").$("liveline").css({'width':0});
$.ajax({ type: "GET", 
			url: dataURL,
			data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID+"&q=info",
			contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
			async: true,
			crossDomain: true,
			success: function (data) {
				if(data){
					var stageinfo=data;
				  var weather=stageinfo[0].n_WeatherConditionType;
				  var wind=(stageinfo[0].n_WindDirection)?stageinfo[0].n_WindDirection:0;
				  sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("weather").attr('src','images/weather'+weather+'.png');
				  sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("wind").attr('src','images/wind'+wind+'.png');
				  var stagelive=(stageinfo[0].b_Live==true)?1:0;
				  var stagefin=(stageinfo[0].b_Finished==true)?1:0;
				  var speed =(stageinfo[0].c_AverageSpeed>0)?stageinfo[0].c_AverageSpeed:"";
				  var startTime=getMatchLocal(stageinfo[0].d_DateStart);
				  var completed=(stageinfo[0].n_DistanceDriven/stageinfo[0].n_DistanceScheduled)*100;
					sym.getSymbol("stagesMc").$("liveline").css({'width':completed+'%'});
				  var windSpeed=stageinfo[0].n_WindSpeed;
					windSpeed=windSpeed/1000;
				  if (stagelive==1){
						txt[30].html(txtArr[47]);
						sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("windTxt").html(windSpeed);
						getBreak(stageID);
				  }else{
						if(todayDate>=startDate-(86400000*5)||stgMove==0){
							txt[30].html(txtArr[30]+startTime);
						}else{
							txt[30].html(txtArr[49]);
						}
					}
				if(stagefin==1){
						txt[30].html(txtArr[49]);
						getStage(stageID);
						sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("windTxt").html(windSpeed);
				}
			}
		}
	});
}
function getBreak(stageID){//get breakaway group live
	$.ajax({ type: "GET", 
		url: dataURL,
		data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID+"&q=group",
		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
		async: true,
		crossDomain: true,
		success: function (data) {
			var breakData=data;
			sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").empty();
			if (breakData){
				sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("preloader").fadeOut(400);
				txt[30].html(txtArr[47]+txtArr[48]);
				for (var i = 0; i < breakData.length; i++) {
					var breakAway=breakData[i].n_GroupDisplayNr;
					if(breakData[i].n_GroupSort<0){
						var tableText ="<div class='race'>";
						if(breakData[i].n_GroupDisplayNr==1){
							tableText += "<div id='riderdata"+i+"' class='break1'>";
						}else{
							if(breakData[i].n_GroupPersonSort==1){
								tableText += "<div id='riderdata"+i+"' class='breakLeader'>";
							}else{
								tableText += "<div id='riderdata"+i+"'>";
							}													
						}

						tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
						tableText += "<td id='rank"+i+"' width='7%'></td>";
						tableText += "<td id='rider"+i+"'width='43%'></td>";
						tableText += "<td id='team"+i+"' style='font-style:italic' width='10%'></td>";
						tableText += "<td id='time"+i+"' style='font-style:italic'></td>";
						tableText += "</tr></table>";
						tableText += "</div>";
						tableText += "</div>";
						sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").append(tableText);
						$('#rank' + i).text(breakData[i].c_ShirtNr);
						$('#rider' + i).text(breakData[i].c_Person);
						$('#team' + i).text(breakData[i].c_TeamShort);
						$('#time' + i).text("-"+(Math.floor(breakData[i].n_AttackLeadMax/60000))+":"+(breakData[i].n_AttackLeadMax%60000)/1000);
						$(".race").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%'});
						if (i==0){
							$('#rider' + i).css({'font-weight':'bold','padding-left':'5px','background-color':'rgba(255,255,255,0.7)'});
						}else{
							$('#rider' + i).css({'padding-left':'5px','background-color':'rgba(255,255,255,0.7)'});
						}

						$("#riderdata" + i).css({'padding-left':'3px', 
								'border-top':'solid 1px rgb(255,255,255)',
								'border-bottom':'solid 1px rgb(150,150,150)'});
						if (i%2==0){
							$("#riderdata" + i +".break1").css({'background-color':'rgb(213,218,224)'});
						}else{
							$("#riderdata" + i+".break1").css({'background-color':'rgb(239,239,239)'});							
						}
						$(".breakLeader").css({'border-top':'inset 1px rgb(255,255,255)'});
						$("#team" + i).css({'text-align':'center'});
						$('#time' + i).css({'text-align':'right'});

					}
				}
			}
		}
	});
}
function getStage(stageID){
//sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
$.ajax({ type: "GET", 
					url: dataURL,
               data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID,
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) {
						var classData = data;
						sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").empty();
						if (classData.length>0){
							sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("preloader").fadeOut(400);											
							for (var i = 0; i < classData.length; i++) {
								//create graph for each rider and for final results
								var tableText ="<div class='race'>";
								tableText += "<div id='riderdata"+i+"'>";
								tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
								tableText += "<td id='rank"+i+"' width='7%'></td>";
								tableText += "<td id='rider"+i+"'width='56%'></td>";
								tableText += "<td id='team"+i+"'class='teamStage' style='font-style:italic' width='10%'></td>";
								tableText += "<td id='time"+i+"'></td>";
								tableText += "</tr></table>";
								tableText += "</div>";
								tableText += "</div>";
								sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").append(tableText);
								$('#rank' + i).text(classData[i].c_Rank);
								$('#rider' + i).text(classData[i].c_Participant);
								$('#team' + i).text(classData[i].c_TeamShort);
								if(classData[i].c_Result!=null){
								$('#time' + i).text(classData[i].c_Result);
								}else{
								$('#time' + i).text("");
								}

							$(".race").css({'font-size':'14px', 'color':'black','font-family':'pragmatica-web, sans-serif', 'width':'98%'});
							if (i==0){
								$('#rider' + i).css({'font-weight':'bold','padding-left':'5px','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
							}else{
								$('#rider' + i).css({'padding-left':'5px','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
							}
							if (i%2==0){
									$("#riderdata" + i).css({'background-color':'rgba(0,0,0,0.2)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});
							}else{
									$("#riderdata" + i).css({'background-color':'rgba(0,0,0,0.1)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});							
							}
							$("#team" + i).css({'text-align':'center'});
							$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});
							}
							setStyle();
							}else{
								sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").html(txtArr[32]);
							}
						},
						error: function(){
						sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").empty();					
						}
	});
}
function getPhase(stageID,classID){
sym.getSymbol("results").getSymbol("resultsScaleMc").$("preloader").fadeIn(400);
sym.getSymbol("results").getSymbol("resultsScaleMc").$("table").empty();
$.ajax({ type: "GET", 
					url: dataURL,
               data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID,
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) {                
						var raceStage = data;
				if(data.length>0){
						sym.getSymbol("results").getSymbol("resultsScaleMc").$("preloader").fadeOut(400);
						var scale;
						if (classID==1||classID==2){//Points or Mountain
							var max = raceStage[0].n_Points;
							var minTime = (max!=null) ? max : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points<minTime) {
									minTime = raceStage[n].n_Points;
									}
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points>max) {
									max = raceStage[n].n_Points;									
									}
								}
						/*								
						}else if(classID==3){//Combination
							var minTime = raceStage[0].n_Points;
							var max = (minTime!=null) ? minTime : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points>max) {
									max = raceStage[n].n_Points;
									}
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points<minTime) {
									minTime = raceStage[n].n_Points;									
									}
								}
						*/
						}else{//General or Young rider
							var minTime = raceStage[0].n_TimeAbs;
							var max = (minTime!=null) ? minTime : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_TimeAbs!=null && raceStage[n].n_TimeAbs>max) {
									max = raceStage[n].n_TimeAbs;
									}
									if (raceStage[n].n_TimeAbs!=null && raceStage[n].n_TimeAbs<minTime) {
									minTime = raceStage[n].n_TimeAbs;									
									}
								}						
						}
							for (var i = 0; i < raceStage.length; i++) {
								var stageText ="<div class='stg'>";
								stageText += "<div id='stgdata"+i+"'>";
								stageText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
								stageText += "<td id='stgrank"+i+"' width='35px'></td>";
								stageText += "<td id='stgrider"+i+"' width='180px'></td>";
								stageText += "<td id='stgflag"+i+"' class='counrtyShort' width='30px'></td>";
								stageText += "<td id='stgteam"+i+"' class='teamShort' style='font-style:italic' width='50px'></td>";
								stageText += "<td id='stgtime"+i+"'></td>";
								stageText += "</tr></table>";
								stageText += "</div></div>";
								if (classID==1||classID==2){								
									if (max==minTime && raceStage[i].n_Points==max) {
										scale=100;
									}else if(raceStage[i].n_Points==null){
										scale=59;
									}else{
										scale = 59+((raceStage[i].n_Points-minTime)*41/(max-minTime));
									}
							/*	}else if(classID==3){//Combination
									if (minTime==max && raceStage[i].n_Points==minTime) {
										scale=100;
									}else if(raceStage[i].n_Points==null){
										scale=59;
									}else{
										scale = 100-((raceStage[i].n_Points-minTime)*41/(max-minTime));
									}	*/							
								}else{
								if (minTime==max && raceStage[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
										scale=100;
									}else if(raceStage[i].n_TimeAbs==null){
										scale=59;
									}else{
										scale = 100-((raceStage[i].n_TimeAbs-minTime)*41/(max-minTime));
									}
								}
								sym.getSymbol("results").getSymbol("resultsScaleMc").$("table").append(stageText);
								$('#stgrank' + i).text(raceStage[i].c_Rank);
								$('#stgrider' + i).text(raceStage[i].c_Participant);
								$('#stgteam' + i).text(raceStage[i].c_TeamShort);
								$('#stgflag' + i).text(raceStage[i].c_NOCShort);
								if(raceStage[i].c_Result!=null){
									$('#stgtime' + i).text(raceStage[i].c_Result);
								}else{
									$('#stgtime' + i).text("");
								}
								$(".stg").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'99%'});



								if (i==0){
									$('#stgrider' + i).css({'font-weight':'bold'});
								}
								if (i%2==0){
									$("#stgdata" + i).css({'width':scale+'%',
									'background-color':'rgba(0,0,0,0.2)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});
								}else{
									$("#stgdata" + i).css({'width':scale+'%',
									'background-color':'rgba(0,0,0,0.1)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});								
								}
								$("#stgteam" + i).css({'text-align':'center','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
								$("#stgtime" + i).css({'text-align':'right', 'padding-right':'5px'});
								$("#stgrank" + i).css({'padding-bottom':'3px', 'padding-top':'3px'});
						}
						}else{
							sym.getSymbol("results").getSymbol("resultsScaleMc").$("table").html(txtArr[32]);
						}
						setStyle(); 
               }
			});
}
function getRiders(){
$.ajax({ type: "GET", 
					url: dataURL,
               data: "gn="+gnNo+"&yr="+gnYear+"&type=cycling&q=riders",
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) { 
						var riders = data;
						if(riders.length>0){
							for(var n=0;n<nameShortArr.length;n++){
								riderNoArr[n].length=0;ridersArr[n].length=0;riderNatArr[n].length=0;riderActive[n].length=0;
							}
							for(var i=0;i<riders.length;i++){
								var teamNm = riders[i].c_TeamAbb;
								var riderNo = riders[i].c_ShirtNr;var riderNm = riders[i].c_Person;var riderNat = riders[i].c_PersonNatioShort;var riderAct=riders[i].b_OutOfRace;
								for(var n=0;n<nameShortArr.length;n++){
									if (teamNm==nameShortArr[n]){
										riderNoArr[n].push(riderNo!=null?riderNo:"");
										ridersArr[n].push(riderNm);
										riderNatArr[n].push(riderNat);
										riderAct=(riderAct==true)?0:1;
										riderActive[n].push(riderAct);
									}
								}
							}
						}
               },
               error:function(){

               }
        });
 }
 getRiders();
//********************************************************************************************************
// INIT SIZE
//********************************************************************************************************
function initSize(){
	stageWidth=sym.$("Stage").width();
	sym.getSymbol("stagesMc").$("stageBtnsMc").stop().animate({width:stageWidth - 128, scrollLeft: (stgMove)*32-(stageWidth-128)/2+16}, 0);
	sym.getSymbol("calBtn").$("plus").fadeIn(0);
	if(stageWidth<800){
		scrollBar = 17;
		$(".profileTxt").css({"opacity":"0"});//hide intermediate text and icons
		for (var s=0;s<21;s++){	
			//profileArray[s].$("stagetxt"+ (routeArr[s].length-1)).css({"opacity":"1", "left":(stageWidth/2-35) + "px", "width":stageWidth/2+"px"});
			for (var r=0;r<routeArr[s].length; r++){
				profileArray[s].$("icon"+ r).css({"opacity":"0"});
			}
		}
	}else{
		scrollBar = 0;
		$(".profileTxt").css({"opacity":"1"});
		for (var s=0;s<21;s++){	
		for (var r=0;r<routeArr[s].length; r++){
			profileArray[s].$("icon"+ r).css({"opacity":"1"});
			}
		}
	}
	if(stageWidth<641){
		for (var s=0;s<5;s++){	
			sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn"+s).$("jersey").stop().animate({left:(stageWidth/5)/2-29, width:58}, 0);
		}
		sym.getSymbol("results").$("resultsScaleMc").stop().animate({left:0, width:stageWidth}, 0);
		sym.$("calendarMc").stop().animate({left:stageWidth+100}, 0);
		sym.$("calBtn").stop().animate({left:stageWidth-45}, 0);
	}else{
		for (var s=0;s<5;s++){	
			sym.getSymbol("results").getSymbol("resultsScaleMc").getSymbol("classBtn"+s).$("jersey").stop().animate({left:((stageWidth-200)/5)/2-31, width:62}, 0);
		}
		sym.getSymbol("results").$("resultsScaleMc").stop().animate({left:200, width:stageWidth-200}, 0);
		sym.$("calendarMc").stop().animate({left:stageWidth-160}, 0);
		sym.$("calBtn").stop().animate({left:stageWidth+100}, 0);
	}
	if(stageWidth<640){
		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
		sym.getSymbol("routeMc").$("courseScrollMc").css('cursor', 'ew-resize'); // SCROLL CODE
		sym.$("routeMc").css({"overflow-x":"visible"});
	}else{
		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
		sym.getSymbol("routeMc").$("courseScrollMc").css('cursor', 'default'); // SCROLL CODE
		sym.$("routeMc").css({"overflow-x":"hidden"});
	}
	if(stageWidth<540){//scale stage results
		sym.getSymbol("stagesMc").$("toggleMapBtn").css({'opacity':'1', 'left':stageWidth-26+'px'});
		sym.getSymbol("stagesMc").$("stageResultMc").css({'width':stageWidth+'px'});
		sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").css({'padding':'3px'});
		sym.getSymbol("results").getSymbol("resultsScaleMc").$("table").css({'padding':'3px'});
		stageMapPath.$("mapHolderMc").css({'left':stageWidth/2-160+'px'});
		sym.getSymbol("stagesMc").$("stageMapMc").css({'width':stageWidth+'px'});
		stageIDs[stgMove]>latestStage?(sym.getSymbol("stagesMc").$("stageResultMc").css({'opacity':0}),sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").fadeOut(0)):(sym.getSymbol("stagesMc").$("stageResultMc").css({'opacity':1}),		sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").fadeIn(0));
	}else{
		sym.getSymbol("stagesMc").$("stageResultMc").css({'width':stageWidth-326+'px', 'opacity':'1'});
		sym.getSymbol("stagesMc").$("stageMapMc").css({'width':'320px'});
		stageMapPath.$("mapHolderMc").css({'left':'0px'});
		sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").fadeIn(0);
		sym.getSymbol("stagesMc").$("toggleMapBtn").css({'opacity':'0', 'left':stageWidth-26+'px'});
	}
	if (stageWidth<480){
		sym.$("menuBtnMob").stop().animate({top:0}, 0);	
		mob = 1;
		sym.getSymbol("styleHead").$("headlineTxt").empty();
		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
	}else{
		sym.$("menuBtnMob").stop().animate({top:-40}, 0);
		mob = 0;
		sym.getSymbol("styleHead").$("headlineTxt").empty();
		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
	}

	// ARRANGE TEAM JERSEY BUTTONS
	sym.getSymbol("teamsMc").$("teamBtnHolder").stop().animate ({left:225, width:stageWidth-225}, 0);
		var colNo = ((stageWidth-225)/125).toFixed(0);
		var btnWidth = ((stageWidth-225)-scrollBar)/colNo;
		for (var i=0;i<teamArray.length;i++){
		teamArray[i].getSymbolElement().css({'width':btnWidth,'position':'relative','float':'left'});
		teamArray[i].$("jersey").css({'left':btnWidth/2-40});
	}
	setStyle();
	menuMob();
}
//********************************************************************************************************
// TOGGLE CALENDAR BUTTON
//********************************************************************************************************
sym.$("calBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("calBtn").$("plus").is(":visible") ) { 
		sym.getSymbol("calBtn").$("plus").fadeOut(0);
		sym.$("calendarMc").stop().animate({left:stageWidth-160}, 200, 'easeOutCubic');
		sym.$("calBtn").stop().animate({left:stageWidth-205}, 250, 'easeOutCubic');
	}else{
		sym.getSymbol("calBtn").$("plus").fadeIn(0);
		sym.$("calendarMc").stop().animate({left:stageWidth+20}, 200, 'easeOutCubic');
		sym.$("calBtn").stop().animate({left:stageWidth-45}, 100, 'easeOutCubic');
	}
}); 
//********************************************************************************************************
// TOGGLE MAP/RESULTS STAGE BUTTON
//********************************************************************************************************
sym.getSymbol("stagesMc").$("toggleMapBtn").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	if (sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").is(":visible") ) { 
		sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").fadeOut(0);
		sym.getSymbol("stagesMc").$("stageResultMc").css({'opacity':'0'});

	}else{
		sym.getSymbol("stagesMc").getSymbol("toggleMapBtn").$("plus").fadeIn(0);
		sym.getSymbol("stagesMc").$("stageResultMc").css({'opacity':'1'});
	}
});

//********************************************************************************************************
// COURSE TIMER
//********************************************************************************************************
var timer;

function startTimer() {
  timer = setInterval(startReplay, 150);
}
function startReplay() {
	pos = sym.getSymbol("routeMc").getSymbol("courseScrollMc").getPosition();
	x = sym.getSymbol("routeMc").getSymbol("courseScrollMc").$("dotMc").position();
	if(stageWidth<640){
	sym.$("routeMc").stop().animate({scrollLeft: x.left-100}, 500);
	}
	if (pos == 0 || pos == 12000) {
		stopTimer();
	}
}
function stopTimer() {
	clearInterval(timer);
}
startTimer();

//********************************************************************************************************
// SET STAGE
//********************************************************************************************************
	for (var p=0;p<21; p++){
		sym.getSymbol("stagesMc").getSymbol("stageBtnsMc").getSymbol("stageBtn"+p).$("txt").html(p+1); // ADD NUMBERS TO STAGE BUTTONS
		sym.getSymbol("routeMc").getSymbol("courseScrollMc").getSymbol("stageBtn"+p).$("txt").html(p+1); // ADD NUMBERS TO MAIN ROUTE
	}	
	sym.getSymbol("stagesMc").getSymbol("stageResultMc").$("graph").css({"overflow-y":"scroll"});
	sym.getSymbol("stagesMc").$("stageBtnsMc").css({"overflow-y":"hidden", "overflow-x":"hidden"});
	sym.getSymbol("teamsMc").$("teamBtnHolder").css({'overflow-x':'hidden', 'overflow-y':'auto'});
	sym.$("routeMc").css({'overflow-y':'hidden'});
	sym.$("teamsMc").fadeOut(0);
	sym.$("stagesMc").fadeOut(0);
	sym.$("results").fadeOut(0);



//********************************************************************************************************
// MOUSE SCROLL MAP
//********************************************************************************************************
	var x,left,down;
	sym.$("routeMc").on('mousedown', function(e){
		e.stopPropagation(); e.preventDefault();
		down=true;
		x=e.pageX;
		left=$(this).scrollLeft();
	});

	sym.$("routeMc").on('mousemove', function(e){
		e.stopPropagation(); e.preventDefault();
		if(down){
			var newX=e.pageX;
			sym.$("routeMc").scrollLeft(left-newX+x);    
		}
	});
	sym.$("routeMc").on('mouseup', function(e){
		e.stopPropagation(); e.preventDefault();
		down=false;
	});

//********************************************************************************************************
//----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
//********************************************************************************************************
// SET STYLE SETTING 
function setStyle() {
	sym.getSymbol("Stage").stop(stageWidth*10);
	sym.$("stageWidthTxt").text(stageWidth + "px");
	// SHOW / HIDE TEAM SHORT IN STAGES RESULTS TABLE
	if (sym.getSymbol("stagesMc").$("stageResultMc").width()<400){
		$(".teamStage").hide();
	}else{
		$(".teamStage").show();
	}
	// SHOW / HIDE TEAM + COUNTRY SHORT IN RESULTS TABLE
	if (sym.$("results").width()<480){
		$(".counrtyShort").hide();
		$(".teamShort").hide();
	}else{
		$(".counrtyShort").show();
		$(".teamShort").show();
	}
}

//********************************************************************************************************
// SOURCE BUTTON
//********************************************************************************************************
sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
	e.stopPropagation(); e.preventDefault();
	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
	}else{
		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
	}
}); 

//********************************************************************************************************
$(window).on('resize',initSize);
//********************************************************************************************************

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stagesMc");
   //Edge symbol end:'stagesMc'

   //=========================================================
   
   //Edge symbol: 'teamsMc'
   (function(symbolName) {   
   
   })("teamsMc");
   //Edge symbol end:'teamsMc'

   //=========================================================
   
   //Edge symbol: 'teamBtn0'
   (function(symbolName) {   
   
   })("teamBtn0");
   //Edge symbol end:'teamBtn0'

   //=========================================================
   
   //Edge symbol: 'stgTxtNo'
   (function(symbolName) {   
   
   })("stgTxtNo");
   //Edge symbol end:'stgTxtNo'

   //=========================================================
   
   //Edge symbol: 'MountainBtn'
   (function(symbolName) {   
   
   })("MountainBtn");
   //Edge symbol end:'MountainBtn'

   //=========================================================
   
   //Edge symbol: 'phaseBtn'
   (function(symbolName) {   
   
   })("phaseBtn");
   //Edge symbol end:'phaseBtn'

   //=========================================================
   
   //Edge symbol: 'TeamBtn'
   (function(symbolName) {   
   
   })("TeamBtn");
   //Edge symbol end:'TeamBtn'

   //=========================================================
   
   //Edge symbol: 'GeneralBtn'
   (function(symbolName) {   
   
   })("GeneralBtn");
   //Edge symbol end:'GeneralBtn'

   //=========================================================
   
   //Edge symbol: 'ResultsMc'
   (function(symbolName) {   
   
   })("ResultsMc");
   //Edge symbol end:'ResultsMc'

   //=========================================================
   
   //Edge symbol: 'YouthBtn'
   (function(symbolName) {   
   
   })("YouthBtn");
   //Edge symbol end:'YouthBtn'

   //=========================================================
   
   //Edge symbol: 'ClassificationsBtn'
   (function(symbolName) {   
   
   })("ClassificationsBtn");
   //Edge symbol end:'ClassificationsBtn'

   //=========================================================
   
   //Edge symbol: 'PointsBtn'
   (function(symbolName) {   
   
   })("PointsBtn");
   //Edge symbol end:'PointsBtn'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'stageBtn'
   (function(symbolName) {   
   
   })("stageBtn_1");
   //Edge symbol end:'stageBtn_1'

   //=========================================================
   
   //Edge symbol: 'startMc'
   (function(symbolName) {   
   
   })("startMc");
   //Edge symbol end:'startMc'

   //=========================================================
   
   //Edge symbol: 'finishMc'
   (function(symbolName) {   
   
   })("finishMc");
   //Edge symbol end:'finishMc'

   //=========================================================
   
   //Edge symbol: 'restMc'
   (function(symbolName) {   
   
   })("restMc");
   //Edge symbol end:'restMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'mapMiniMc'
   (function(symbolName) {   
   
   })("mapMiniMc");
   //Edge symbol end:'mapMiniMc'

   //=========================================================
   
   //Edge symbol: 'startDot'
   (function(symbolName) {   
   
   })("dotStart");
   //Edge symbol end:'dotStart'

   //=========================================================
   
   //Edge symbol: 'endDot'
   (function(symbolName) {   
   
   })("dotEnd");
   //Edge symbol end:'dotEnd'

   //=========================================================
   
   //Edge symbol: 'riderDotMc'
   (function(symbolName) {   
   
   })("riderDotMc");
   //Edge symbol end:'riderDotMc'

   //=========================================================
   
   //Edge symbol: 'startEndDot'
   (function(symbolName) {   
   
   })("dotStartEnd");
   //Edge symbol end:'dotStartEnd'

   //=========================================================
   
   //Edge symbol: 'riderMc'
   (function(symbolName) {   
   
   })("riderMc");
   //Edge symbol end:'riderMc'

   //=========================================================
   
   //Edge symbol: 'drinkMc'
   (function(symbolName) {   
   
   })("iconDrink");
   //Edge symbol end:'iconDrink'

   //=========================================================
   
   //Edge symbol: 'iconHill3'
   (function(symbolName) {   
   
   })("iconHill3");
   //Edge symbol end:'iconHill3'

   //=========================================================
   
   //Edge symbol: 'iconHill3_1'
   (function(symbolName) {   
   
   })("iconHill1");
   //Edge symbol end:'iconHill1'

   //=========================================================
   
   //Edge symbol: 'iconHill1_1'
   (function(symbolName) {   
   
   })("iconHill2");
   //Edge symbol end:'iconHill2'

   //=========================================================
   
   //Edge symbol: 'iconHill3_1'
   (function(symbolName) {   
   
   })("iconHill4");
   //Edge symbol end:'iconHill4'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'calIconTimeTrialMc'
   (function(symbolName) {   
   
   })("calIconTimeTrialMc");
   //Edge symbol end:'calIconTimeTrialMc'

   //=========================================================
   
   //Edge symbol: 'calIconTimeTrialMc_1'
   (function(symbolName) {   
   
   })("calIconSprintMc");
   //Edge symbol end:'calIconSprintMc'

   //=========================================================
   
   //Edge symbol: 'calIconSprintMc_1'
   (function(symbolName) {   
   
   })("calIconMountain");
   //Edge symbol end:'calIconMountain'

   //=========================================================
   
   //Edge symbol: 'calLines'
   (function(symbolName) {   
   
   })("calLines");
   //Edge symbol end:'calLines'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'stageBtnsMc'
   (function(symbolName) {   
   
   })("stageBtnsMc");
   //Edge symbol end:'stageBtnsMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn'
   (function(symbolName) {   
   
   })("stageNavBtn");
   //Edge symbol end:'stageNavBtn'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn_1'
   (function(symbolName) {   
   
   })("stageNavBtnOut");
   //Edge symbol end:'stageNavBtnOut'

   //=========================================================
   
   //Edge symbol: 'routeMc'
   (function(symbolName) {   
   
   })("routeMc");
   //Edge symbol end:'routeMc'

   //=========================================================
   
   //Edge symbol: 'diaryMc'
   (function(symbolName) {   
   
   })("diaryMc");
   //Edge symbol end:'diaryMc'

   //=========================================================
   
   //Edge symbol: 'teamBtnsMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("teamBtnsMc");
   //Edge symbol end:'teamBtnsMc'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'teamBtnHolder'
   (function(symbolName) {   
   
   })("teamBtnHolder");
   //Edge symbol end:'teamBtnHolder'

   //=========================================================
   
   //Edge symbol: 'profIconSt'
   (function(symbolName) {   
   
   })("profIconSta");
   //Edge symbol end:'profIconSta'

   //=========================================================
   
   //Edge symbol: 'profIconSt_1'
   (function(symbolName) {   
   
   })("profIconEnd");
   //Edge symbol end:'profIconEnd'

   //=========================================================
   
   //Edge symbol: 'iconHill1_1'
   (function(symbolName) {   
   
      })("iconHill");
   //Edge symbol end:'iconHill'

   //=========================================================
   
   //Edge symbol: 'classBtnsMc'
   (function(symbolName) {   
   
   })("classBtnsMc");
   //Edge symbol end:'classBtnsMc'

   //=========================================================
   
   //Edge symbol: 'resultsScaleMc'
   (function(symbolName) {   
   
   })("resultsScaleMc");
   //Edge symbol end:'resultsScaleMc'

   //=========================================================
   
   //Edge symbol: 'StageResultMc'
   (function(symbolName) {   
   
   })("StageResultMc");
   //Edge symbol end:'StageResultMc'

   //=========================================================
   
   //Edge symbol: 'route'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("route");
   //Edge symbol end:'route'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'stageNavBtn_1'
   (function(symbolName) {   
   
      })("toggleMapBtn");
   //Edge symbol end:'toggleMapBtn'

   //=========================================================
   
   //Edge symbol: 'stageMapMc'
   (function(symbolName) {   
   
   })("stageMapMc");
   //Edge symbol end:'stageMapMc'

   //=========================================================
   
   //Edge symbol: 'mapHolderMc'
   (function(symbolName) {   
   
   })("mapHolderMc");
   //Edge symbol end:'mapHolderMc'

   //=========================================================
   
   //Edge symbol: 'teamJerseyBtn'
   (function(symbolName) {   
   
   })("teamJerseyBtn");
   //Edge symbol end:'teamJerseyBtn'

   //=========================================================
   
   //Edge symbol: 'PROFTEMP_10'
   (function(symbolName) {   
   
   })("profileMc3");
   //Edge symbol end:'profileMc3'

   //=========================================================
   
   //Edge symbol: 'PROFTEMP_1'
   (function(symbolName) {   
   
   })("profileMc2");
   //Edge symbol end:'profileMc2'

   //=========================================================
   
   //Edge symbol: 'PROFTEMP'
   (function(symbolName) {   
   
   })("profileMc1");
   //Edge symbol end:'profileMc1'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc17_3'
   (function(symbolName) {   
   
            })("mapMc20");
   //Edge symbol end:'mapMc20'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc17_2'
   (function(symbolName) {   
   
            })("mapMc19");
   //Edge symbol end:'mapMc19'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc17_1'
   (function(symbolName) {   
   
            })("mapMc18");
   //Edge symbol end:'mapMc18'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_3'
   (function(symbolName) {   
   
            })("mapMc17");
   //Edge symbol end:'mapMc17'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_4'
   (function(symbolName) {   
   
            })("mapMc16");
   //Edge symbol end:'mapMc16'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_5'
   (function(symbolName) {   
   
            })("mapMc15");
   //Edge symbol end:'mapMc15'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_6'
   (function(symbolName) {   
   
            })("mapMc14");
   //Edge symbol end:'mapMc14'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_2'
   (function(symbolName) {   
   
            })("mapMc13");
   //Edge symbol end:'mapMc13'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_1'
   (function(symbolName) {   
   
            })("mapMc12");
   //Edge symbol end:'mapMc12'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_11'
   (function(symbolName) {   
   
            })("mapMc11");
   //Edge symbol end:'mapMc11'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_10'
   (function(symbolName) {   
   
            })("mapMc10");
   //Edge symbol end:'mapMc10'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_9'
   (function(symbolName) {   
   
            })("mapMc9");
   //Edge symbol end:'mapMc9'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_8'
   (function(symbolName) {   
   
            })("mapMc8");
   //Edge symbol end:'mapMc8'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_7'
   (function(symbolName) {   
   
            })("mapMc7");
   //Edge symbol end:'mapMc7'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_6'
   (function(symbolName) {   
   
            })("mapMc6");
   //Edge symbol end:'mapMc6'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_5'
   (function(symbolName) {   
   
            })("mapMc5");
   //Edge symbol end:'mapMc5'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_4'
   (function(symbolName) {   
   
            })("mapMc4");
   //Edge symbol end:'mapMc4'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_3'
   (function(symbolName) {   
   
            })("mapMc3");
   //Edge symbol end:'mapMc3'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_2'
   (function(symbolName) {   
   
            })("mapMc2");
   //Edge symbol end:'mapMc2'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_1'
   (function(symbolName) {   
   
            })("mapMc1");
   //Edge symbol end:'mapMc1'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc20_1'
   (function(symbolName) {   
   
         })("mapMc0");
   //Edge symbol end:'mapMc0'

   //=========================================================
   
   //Edge symbol: 'dotStartEnd_1'
   (function(symbolName) {   
   
      })("dotStartRest");
   //Edge symbol end:'dotStartRest'

   //=========================================================
   
   //Edge symbol: 'logoMc'
   (function(symbolName) {   
   
   })("logoMc");
   //Edge symbol end:'logoMc'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'arrowMc_1'
   (function(symbolName) {   
   
   })("arrowOutMc");
   //Edge symbol end:'arrowOutMc'

   //=========================================================
   
   //Edge symbol: 'profileMc1_1'
   (function(symbolName) {   
   
      })("profileTemplate");
   //Edge symbol end:'profileTemplate'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc4");
   //Edge symbol end:'profileMc4'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc5");
   //Edge symbol end:'profileMc5'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc6");
   //Edge symbol end:'profileMc6'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc7");
   //Edge symbol end:'profileMc7'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc8");
   //Edge symbol end:'profileMc8'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc9");
   //Edge symbol end:'profileMc9'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc10");
   //Edge symbol end:'profileMc10'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc11");
   //Edge symbol end:'profileMc11'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc12");
   //Edge symbol end:'profileMc12'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc13");
   //Edge symbol end:'profileMc13'

   //=========================================================
   
   //Edge symbol: 'profileTemplate_1'
   (function(symbolName) {   
   
      })("profileMc14");
   //Edge symbol end:'profileMc14'

   //=========================================================
   
   //Edge symbol: 'profileMc14_1'
   (function(symbolName) {   
   
      })("profileMc15");
   //Edge symbol end:'profileMc15'

   //=========================================================
   
   //Edge symbol: 'profileMc15_1'
   (function(symbolName) {   
   
      })("profileMc16");
   //Edge symbol end:'profileMc16'

   //=========================================================
   
   //Edge symbol: 'profileMc16_1'
   (function(symbolName) {   
   
      })("profileMc17");
   //Edge symbol end:'profileMc17'

   //=========================================================
   
   //Edge symbol: 'profileMc17_1'
   (function(symbolName) {   
   
      })("profileMc18");
   //Edge symbol end:'profileMc18'

   //=========================================================
   
   //Edge symbol: 'profileMc18_1'
   (function(symbolName) {   
   
      })("profileMc19");
   //Edge symbol end:'profileMc19'

   //=========================================================
   
   //Edge symbol: 'profileMc19_1'
   (function(symbolName) {   
   
      })("profileMc20");
   //Edge symbol end:'profileMc20'

   //=========================================================
   
   //Edge symbol: 'iconIT'
   (function(symbolName) {   
   
   })("iconTT");
   //Edge symbol end:'iconTT'

   //=========================================================
   
   //Edge symbol: 'iconTimeTrial_1'
   (function(symbolName) {   
   
   })("iconTimeTrialTeam");
   //Edge symbol end:'iconTimeTrialTeam'

   //=========================================================
   
   //Edge symbol: 'iconDrink_1'
   (function(symbolName) {   
   
   })("iconTimeTrial");
   //Edge symbol end:'iconTimeTrial'

   //=========================================================
   
   //Edge symbol: 'iconSprint'
   (function(symbolName) {   
   
   })("iconSprint");
   //Edge symbol end:'iconSprint'

   //=========================================================
   
   //Edge symbol: 'iconHill4_1'
   (function(symbolName) {   
   
   })("iconHillH");
   //Edge symbol end:'iconHillH'

   //=========================================================
   
   //Edge symbol: 'profileMc1_1'
   (function(symbolName) {   
   
      })("profileMc0");
   //Edge symbol end:'profileMc0'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34329");