/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var raceDistance = 100;
         	var panelVis = true;
         	var speed = 200
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // ADD CALENDAR
         //********************************************************************************************************
         calArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 28; i++){
          var calObject = sym.createChildSymbol("dateBox", "panelMc");  // Create an instance element of a symbol as a child of the given parent element
          calObject.setVariable("id", i);  //set the value of a Symbol variable
          calArray.push(calObject);  //push it into the array
         }
         
         for (var i=0; i<calArray.length; i++){
         	calArray[i].getSymbolElement().css({'top':'24px', 'left':'4px'});
         	calArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	calArray[i].$('no').css({"color":"white"});
         }
         for (var i=0; i<7; i++){
         	calArray[i].$('bgRight').css({'background-color':'#fff'});
         	calArray[i].$('bgLeft').css({'background-color':'#fff'});
         	}
         for (var i=7; i<11; i++){
         		calArray[i].$('bgRight').css({'background-color':'#c6c6c6'});
         		calArray[i].$('bgLeft').css({'background-color':'#c6c6c6'});
         	}
         function resetCal() {
         	for (var i=11; i<28; i++){
         		calArray[i].$('bgRight').css({'background-color':'#ffc10e'});
         		calArray[i].$('bgLeft').css({'background-color':'#ffc10e'});
         	}
         }
         for (var i=7; i<28; i++){
         	calArray[i].$('no').html(i-6);
         }
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"#da0000"};
         	var blue = {"background-color":"#1382c5"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.getSymbol("keyMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("keyMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("panelMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("panelMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         
         	var txtArr=[], distance=[], distanceEvents=[]
         
         	$.ajax({	
         		type: "GET",
         		url: "GN34314.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<8; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			$(xml).find("sport").each(function(){
         				var $distance=$(this);
         				distanceEvents.push($distance);
         			});
         
         			var dayString = $(xml).find('txt6').text();
                  weekDays = dayString.split(";");
                  for (var w=0; w<7; w++){
         				calArray[w].$('no').html(weekDays[w]);
         				calArray[w].$('no').css({"color":"gray"});
         			}
         			changeDistance();
         		},
         
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("strap").css({"left":(stageWidth-136)+"px"});
         
         	if (clicked == 2 || clicked == 4 || clicked == 5){
         		sym.$("keyMc").stop().animate ({left:stageWidth/1.7, top:80}, 0);
         	}
         	speed = 0;
         	if(stageWidth<640){
         		panelClose();
         		sym.$("panelBtn").stop().animate({top:40},0);
         	}else{
         		panelOpen();
         		sym.$("panelBtn").stop().animate({top:-10},0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").html(headlinemob);
         		sym.$("strap").stop().animate({opacity:0}, 0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").html(headline);
         		sym.$("strap").stop().animate({opacity:1}, 0);
         	}
         	setStyle();
         	sourceDown();
         	checkRTL();
         
         	for (var m=0; m<menYearSplit.length; m++){
         		sym.getSymbol("distance"+raceDistance).$("m"+m).stop().animate({left: sym.getSymbol("distance"+raceDistance).$("m"+m+"Copy").position().left, top: sym.getSymbol("distance"+raceDistance).$("m"+m+"Copy").position().top}, 0);
         	}
         	for (var w=0; w<12; w++){
         		sym.getSymbol("distance"+raceDistance).$("w"+w).stop().animate({left: sym.getSymbol("distance"+raceDistance).$("w"+w+"Copy").position().left, top: sym.getSymbol("distance"+raceDistance).$("w"+w+"Copy").position().top}, 0);
         	}
         }
         
         //********************************************************************************************************
         // CHANGE DISTANCE
         //********************************************************************************************************
         var sportDistance=[], picTxt=[], menYears=[], menTimes=[], menFirst=[], menLast=[], menRecord=[], womenYears=[], womenTimes=[], womenFirst=[], womenLast=[], womenRecord=[];
         
         function changeDistance() {
         	var $events=distanceEvents[0].find('distance');
         	stageWidth=sym.$("Stage").width();
         	if (stageWidth<640){
         		speed = 0;
         		panelClose();
         	} else{
         		speed = 0;
         		panelOpen();
         	}
         	sym.$("keyMc").stop().animate ({left:3, top:70}, 0);
         	resetCal();
         	if (clicked == 0){
         		raceDistance = 100;
         		for (var p=0; p<4; p++){
         			sym.getSymbol("distance100").$("point"+p).stop().animate({opacity:0}, 0);
         			sym.getSymbol("distance100").$("point"+p).stop().delay(1000).animate({opacity:1}, 200);
         			calArray[18].$('bgRight').css(red);
         			calArray[18].$('bgLeft').css(red);
         			calArray[19].$('bgRight').css(red);
         			calArray[19].$('bgLeft').css(blue);
         			calArray[20].$('bgLeft').css(blue);
         			calArray[20].$('bgRight').css(blue);
         		}
         	}
         	if (clicked == 1){
         		raceDistance = 200;
         		calArray[21].$('bgRight').css(red);
         		calArray[21].$('bgLeft').css(red);
         		calArray[22].$('bgRight').css(red);
         		calArray[22].$('bgLeft').css(blue);
         		calArray[23].$('bgRight').css(red);
         		calArray[23].$('bgLeft').css(blue);
         		calArray[24].$('bgLeft').css(blue);
         		calArray[24].$('bgRight').css(blue);
         	}
         	if (clicked == 2){
         		calArray[18].$('bgRight').css(blue);
         		calArray[18].$('bgLeft').css(blue);
         		calArray[19].$('bgRight').css(red);
         		calArray[19].$('bgLeft').css(blue);
         		calArray[20].$('bgRight').css(red);
         		calArray[20].$('bgLeft').css(blue);
         		calArray[21].$('bgLeft').css(red);
         		calArray[21].$('bgRight').css(red);
         		sym.$("keyMc").stop().animate ({left:stageWidth/1.7, top:80}, 0);
         		raceDistance = 400;
         		for (var p=0; p<6; p++){
         			sym.getSymbol("distance400").$("point"+p).stop().animate({opacity:0}, 0);
         			sym.getSymbol("distance400").$("point"+p).stop().delay(1000).animate({opacity:1}, 200);
         		}
         	}
         	if (clicked == 3){
         		calArray[18].$('bgRight').css(blue);
         		calArray[18].$('bgLeft').css(blue);
         		calArray[19].$('bgRight').css(blue);
         		calArray[19].$('bgLeft').css(blue);
         		calArray[21].$('bgRight').css(blue);
         		calArray[21].$('bgLeft').css(blue);
         		calArray[23].$('bgLeft').css(red);
         		calArray[23].$('bgRight').css(red);
         		calArray[24].$('bgLeft').css(red);
         		calArray[24].$('bgRight').css(red);
         		calArray[26].$('bgLeft').css(red);
         		calArray[26].$('bgRight').css(red);
         		raceDistance = 800;
         		for (var p=0; p<2; p++){
         			sym.getSymbol("distance800").$("point"+p).stop().animate({opacity:0}, 0);
         			sym.getSymbol("distance800").$("point"+p).stop().delay(1000).animate({opacity:1}, 200);
         		}
         	}
         	if (clicked == 4){
         		calArray[18].$('bgRight').css(red);
         		calArray[18].$('bgLeft').css(red);
         		calArray[20].$('bgRight').css(red);
         		calArray[20].$('bgLeft').css(red);
         		calArray[22].$('bgRight').css(blue);
         		calArray[22].$('bgLeft').css(red);
         		calArray[24].$('bgLeft').css(blue);
         		calArray[24].$('bgRight').css(blue);
         		calArray[26].$('bgLeft').css(blue);
         		calArray[26].$('bgRight').css(blue);
         		sym.$("keyMc").stop().animate ({left:stageWidth/1.7, top:80}, 0);
         		raceDistance = 1500;
         		for (var p=0; p<3; p++){
         			sym.getSymbol("distance1500").$("point"+p).stop().animate({opacity:0}, 0);
         			sym.getSymbol("distance1500").$("point"+p).stop().delay(1000).animate({opacity:1}, 200);
         		}
         	}
         	if (clicked == 5){
         		calArray[22].$('bgRight').css(red);
         		calArray[22].$('bgLeft').css(red);
         		calArray[23].$('bgLeft').css(blue);
         		calArray[23].$('bgRight').css(blue);
         		calArray[25].$('bgRight').css(red);
         		calArray[25].$('bgLeft').css(red);
         		calArray[26].$('bgLeft').css(blue);
         		calArray[26].$('bgRight').css(blue);
         		sym.$("keyMc").stop().animate ({left:3, top:400}, 0);
         		raceDistance = 5000;
         		sym.getSymbol("distance5000").$("point0").stop().animate({opacity:0}, 0);
         		sym.getSymbol("distance5000").$("point0").stop().delay(1000).animate({opacity:1}, 200);
         	}
         	if (clicked == 6){
         		calArray[18].$('bgRight').css(red);
         		calArray[18].$('bgLeft').css(red);
         		calArray[19].$('bgLeft').css(blue);
         		calArray[19].$('bgRight').css(blue);
         		sym.$("keyMc").stop().animate ({left:3, top:400}, 0);
         		raceDistance = 10000;
         		for (var p=0; p<4; p++){
         			sym.getSymbol("distance10000").$("point"+p).stop().animate({opacity:0}, 0);
         			sym.getSymbol("distance10000").$("point"+p).stop().delay(1000).animate({opacity:1}, 200);
         		}
         	}
         
         	var distanceArray = ["100","200","400","800", "1500","5000","10000"];
         	$.each(distanceArray, function(index, value) {
         		sym.getSymbol("panelMc").$("dates"+value+"m").fadeOut(200);
         		sym.$("distance"+value).stop().animate ({opacity:0}, 300);
         	});
         	sym.getSymbol("panelMc").$("dates"+raceDistance+"m").fadeIn(200);
         	sym.$("distance"+raceDistance).stop().animate ({opacity:1}, 500);
         	sym.getSymbol("distance"+raceDistance).stop(stageWidth*10);
         
         	$events.each(function(){
         		var $event=$(this);
         		var pictxt=$event.find("pictured").text();
         		picTxt.push(pictxt);
         		var sportdistance=$event.find("metres").text();
         		sportDistance.push(sportdistance);
         		var menyears=$event.find("menYears").text();
         		menYears.push(menyears);
         		var mentimes=$event.find("menTimes").text();
         		menTimes.push(mentimes);
         		var menfirst=$event.find("menFirst").text();
         		menFirst.push(menfirst);
         		var menlast=$event.find("menLast").text();
         		menLast.push(menlast);
         		var menrecord=$event.find("menRecord").text();
         		menRecord.push(menrecord);
         		var womenyears=$event.find("womenYears").text();
         		womenYears.push(womenyears);
         		var womentimes=$event.find("womenTimes").text();
         		womenTimes.push(womentimes);
         		var womenfirst=$event.find("womenFirst").text();
         		womenFirst.push(womenfirst);
         		var womenlast=$event.find("womenLast").text();
         		womenLast.push(womenlast);
         		var womenrecord=$event.find("womenRecord").text();
         		womenRecord.push(womenrecord);
         
         		sym.$("subHeadTxt").html(sportDistance[clicked] + " " +txtArr[2]);
         		sym.getSymbol("panelMc").$("picTxt").html(txtArr[7] + picTxt[clicked]);
         		sym.getSymbol("panelMc").$("menRecordTxt").html(menRecord[clicked]);
         		sym.getSymbol("panelMc").$("womenRecordTxt").html(womenRecord[clicked]);
         
         		sym.getSymbol("distance"+raceDistance).$("menFirst").html(menFirst[clicked]);
         		sym.getSymbol("distance"+raceDistance).$("menLast").html(menLast[clicked]).stop().animate({opacity:0},0,function(){
         		sym.getSymbol("distance"+raceDistance).$("menLast").html(menLast[clicked]).animate({opacity:1},200);
         		});
         		//sym.getSymbol("distance"+raceDistance).$("menLast").html(menLast[clicked]).stop().delay(1000).animate({opacity:1},200);
         
         		sym.getSymbol("distance"+raceDistance).$("womenFirst").html(womenFirst[clicked]);
         		sym.getSymbol("distance"+raceDistance).$("womenLast").html(womenLast[clicked]).stop().animate({opacity:0},0, function(){
         		sym.getSymbol("distance"+raceDistance).$("womenLast").html(womenLast[clicked]).animate({opacity:1},200);
         		});
         		//sym.getSymbol("distance"+raceDistance).$("womenLast").html(womenLast[clicked]).stop().delay(1000).animate({opacity:1},200);
         
         		menYearSplit = menYears[clicked].split(";");
         		menTimeSplit = menTimes[clicked].split(";");
         
                for (var m=0; m<menYearSplit.length; m++){
         			sym.getSymbol("distance"+raceDistance).getSymbol("m"+m).$("year").html(menYearSplit[m]);
         			sym.getSymbol("distance"+raceDistance).getSymbol("m"+m).$("time").html(menTimeSplit[m]);
         		}
         
         		womenYearSplit = womenYears[clicked].split(";");
         		womenTimeSplit = womenTimes[clicked].split(";");
               for (var w=0; w<womenYearSplit.length; w++){
         			sym.getSymbol("distance"+raceDistance).getSymbol("w"+w).$("year").html(womenYearSplit[w]);
         			sym.getSymbol("distance"+raceDistance).getSymbol("w"+w).$("time").html(womenTimeSplit[w]);
         		}
         		for (var m=0; m<7; m++){
         			menuArray[m].$("txt").html(sportDistance[m]).css({"font-size":"16px"});
         		}
         		});
         
         	sym.getSymbol("panelMc").$("menPic").attr("src", "images/m" + raceDistance + ".jpg");
         	sym.getSymbol("panelMc").$("womenPic").attr("src", "images/w" + raceDistance + ".jpg");
         
         
         	for (var m=0; m<menYearSplit.length; m++){
         		sym.getSymbol("distance"+raceDistance).$("m"+m).stop().animate({left: sym.getSymbol("distance"+raceDistance).$("m0").position().left, top: sym.getSymbol("distance"+raceDistance).$("m0").position().top}, 0);
         	}
         	for (var w=0; w<womenYearSplit.length; w++){
         		sym.getSymbol("distance"+raceDistance).$("w"+w).stop().animate({left: sym.getSymbol("distance"+raceDistance).$("w0").position().left, top: sym.getSymbol("distance"+raceDistance).$("w0").position().top}, 0);
         	}
         
         	for (var m=0; m<menYearSplit.length; m++){
         		sym.getSymbol("distance"+raceDistance).$("m"+m).stop().delay(m*50).animate({left: sym.getSymbol("distance"+raceDistance).$("m"+m+"Copy").position().left, top: sym.getSymbol("distance"+raceDistance).$("m"+m+"Copy").position().top}, 500, 'easeOutCubic');
         	}
         	for (var w=0; w<womenYearSplit.length; w++){
         		sym.getSymbol("distance"+raceDistance).$("w"+w).stop().delay(w*50).animate({left: sym.getSymbol("distance"+raceDistance).$("w"+w+"Copy").position().left, top: sym.getSymbol("distance"+raceDistance).$("w"+w+"Copy").position().top}, 500, 'easeOutCubic');
         	}
         }
         
         function checkRTL(){
         	if (RTL == true){
         		stageWidth=sym.$("Stage").width();
         		sym.$("menuBtnMob").stop().animate({left:0},0);
         		sym.$("menuBtn").stop().animate({left:0},0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		sym.getSymbol("keyMc").$("keyArt").css({"left":"-15px"});
         		sym.getSymbol("keyMc").$("txt0").css({"left":"-25px", "text-align":"right"});
         		sym.getSymbol("keyMc").$("txt1").css({"left":"-25px", "text-align":"right"});
         		sym.getSymbol("panelMc").$("menRecordTxt").css({"left":"8px", "text-align":"right"});
         		sym.getSymbol("panelMc").$("womenRecordTxt").css({"left":"8px", "text-align":"right"});
         		sym.getSymbol("panelMc").$("picTxt").css({"text-align":"right"});
         		sym.getSymbol("panelMc").$("manIcon").css({"left":"138px"});
         		sym.getSymbol("panelMc").$("womanIcon").css({"left":"124px"});
         		sym.$("sprintIcon").fadeOut(0);
         		for (var i=0; i<calArray.length; i++){
         			calArray[i].getSymbolElement().css({'top':'24px', 'left':'0px'});
         			calArray[i].getSymbolElement().css({'position':'relative','float':'right'});
         		}
         		sym.$("strap").fadeOut(0);
         		if (stageWidth<640){
         			sym.$("subHeadTxt").css({'text-align':'center', 'left':'0', 'width':stageWidth + 'px'});
         		} else{
         			sym.$("subHeadTxt").css({'text-align':'center', 'left':'0', 'width':(stageWidth - 140) + 'px'});
         		}
         	}
         }
         checkRTL();
         //********************************************************************************************************
         // MENU BTNS
         //********************************************************************************************************
         menuArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){ //a function to call to make sure we know it’s working!
         	clicked = symbolInTheArray.getVariable("id");
         	resetmenu();
         	sourceDown();
         	menuArray[clicked].$("txt").css({"color":"#fff", "font-weight":"regular"});
         	menuArray[clicked].$("bg").css(red);
         	changeDistance();
         	setStyle();
         }
         
         for (var i = 0; i < 7; i++){
         	var mySymbolObject = sym.createChildSymbol("menuBtn0", "menuBtn");  // Create an instance element of a symbol as a child of the given parent element
         	mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
         	menuArray.push(mySymbolObject);  //push it into the array
         	menuArray[i].$("txt").html(sportDistance[i]);
         }
         
         $.each(menuArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         var move = 40;
         
         menuArray[clicked].$("txt").css({"color":"#fff", "font-weight":"regular"});
         menuArray[clicked].$("bg").css(red);
         
         function resetmenu(){
         	for (var i=0; i<menuArray.length; i++){
         		menuArray[i].getSymbolElement().animate ({top:-move * i}, 300, 'easeOutCubic');
         		menuArray[i].getSymbolElement().css({'cursor':'pointer'});
         		menuArray[i].$("bg").css(black);
         		menuArray[i].$("txt").css({"color":"#fff"});
         	}
         }
         resetmenu();
         menuArray[0].$("bg").css(red);
         menuArray[0].$("txt").css({"color":"#fff"});
         
         //********************************************************************************************************
         // MENU BTN
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	openMenu();
         });
         
         function openMenu(){
         	for (var i=0; i<menuArray.length; i++){
         		menuArray[i].getSymbolElement().animate ({top:move * i + move}, 300, 'easeOutCubic');
         	}
         }
         
         //********************************************************************************************************
         // PANEL BTN
         //********************************************************************************************************
         sym.$("panelBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		panelCheck();
         	});
         
         function panelCheck(){
         	if (panelVis == false){
         		speed = 200;
         		panelOpen();
         	}else{
         		speed = 200;
         		panelClose();
         	}
         }
         function panelClose(){
         	sym.$("panelMc").stop().animate({left:stageWidth+10}, speed, 'easeOutCubic');
         	sym.$("panelBtn").stop().animate({left:stageWidth-40}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	panelVis = false;
         
         }
         function panelOpen(){
         	sym.$("panelMc").stop().animate({left:stageWidth-160}, speed, 'easeOutCubic');
         	sym.$("panelBtn").stop().animate({left:stageWidth-200}, speed, 'easeOutCubic');
         	sym.getSymbol("panelBtn").$("arrow").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	panelVis = true;
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("distance"+raceDistance).stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		sourceDown();
         	}
         }); 
         function sourceDown(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'yellowTL'
   (function(symbolName) {   
   
   })("yellowTL");
   //Edge symbol end:'yellowTL'

   //=========================================================
   
   //Edge symbol: 'yellowTL_1'
   (function(symbolName) {   
   
   })("yellowTR");
   //Edge symbol end:'yellowTR'

   //=========================================================
   
   //Edge symbol: 'yellowTR_1'
   (function(symbolName) {   
   
   })("yellowBL");
   //Edge symbol end:'yellowBL'

   //=========================================================
   
   //Edge symbol: 'yellowBL_1'
   (function(symbolName) {   
   
   })("yellowBR");
   //Edge symbol end:'yellowBR'

   //=========================================================
   
   //Edge symbol: 'yellowBL_1'
   (function(symbolName) {   
   
   })("redBL");
   //Edge symbol end:'redBL'

   //=========================================================
   
   //Edge symbol: 'redBL_1'
   (function(symbolName) {   
   
   })("redBR");
   //Edge symbol end:'redBR'

   //=========================================================
   
   //Edge symbol: 'redBR_1'
   (function(symbolName) {   
   
   })("redTR");
   //Edge symbol end:'redTR'

   //=========================================================
   
   //Edge symbol: 'redTR_1'
   (function(symbolName) {   
   
   })("redTL");
   //Edge symbol end:'redTL'

   //=========================================================
   
   //Edge symbol: 'redBL_1'
   (function(symbolName) {   
   
   })("blueBL");
   //Edge symbol end:'blueBL'

   //=========================================================
   
   //Edge symbol: 'redTL_1'
   (function(symbolName) {   
   
   })("blueTL");
   //Edge symbol end:'blueTL'

   //=========================================================
   
   //Edge symbol: 'redBR_1'
   (function(symbolName) {   
   
   })("blueBR");
   //Edge symbol end:'blueBR'

   //=========================================================
   
   //Edge symbol: 'redTR_1'
   (function(symbolName) {   
   
   })("blueTR");
   //Edge symbol end:'blueTR'

   //=========================================================
   
   //Edge symbol: 'sprint200'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("sprint200");
   //Edge symbol end:'sprint200'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'panelBtn'
   (function(symbolName) {   
   
   })("panelBtn");
   //Edge symbol end:'panelBtn'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'sprint200_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("sprint100");
   //Edge symbol end:'sprint100'

   //=========================================================
   
   //Edge symbol: 'point100'
   (function(symbolName) {   
   
   })("point100");
   //Edge symbol end:'point100'

   //=========================================================
   
   //Edge symbol: 'dates200m'
   (function(symbolName) {   
   
   })("dates200m");
   //Edge symbol end:'dates200m'

   //=========================================================
   
   //Edge symbol: 'dates200m_1'
   (function(symbolName) {   
   
   })("dates100m");
   //Edge symbol end:'dates100m'

   //=========================================================
   
   //Edge symbol: 'sprint200_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("sprint400");
   //Edge symbol end:'sprint400'

   //=========================================================
   
   //Edge symbol: 'blueTL_1'
   (function(symbolName) {   
   
      })("blueNone");
   //Edge symbol end:'blueNone'

   //=========================================================
   
   //Edge symbol: 'point400'
   (function(symbolName) {   
   
   })("point400");
   //Edge symbol end:'point400'

   //=========================================================
   
   //Edge symbol: 'point401'
   (function(symbolName) {   
   
   })("point401");
   //Edge symbol end:'point401'

   //=========================================================
   
   //Edge symbol: 'redBL_1'
   (function(symbolName) {   
   
      })("redNone");
   //Edge symbol end:'redNone'

   //=========================================================
   
   //Edge symbol: 'point5'
   (function(symbolName) {   
   
   })("point5");
   //Edge symbol end:'point5'

   //=========================================================
   
   //Edge symbol: 'banner'
   (function(symbolName) {   
   
   })("banner");
   //Edge symbol end:'banner'

   //=========================================================
   
   //Edge symbol: 'dates200m_1'
   (function(symbolName) {   
   
      })("dates400m");
   //Edge symbol end:'dates400m'

   //=========================================================
   
   //Edge symbol: 'banner_1'
   (function(symbolName) {   
   
      })("rings");
   //Edge symbol end:'rings'

   //=========================================================
   
   //Edge symbol: 'strap'
   (function(symbolName) {   
   
   })("strap");
   //Edge symbol end:'strap'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
   })("keyMc");
   //Edge symbol end:'keyMc'

   //=========================================================
   
   //Edge symbol: 'sprintIcon'
   (function(symbolName) {   
   
   })("sprintIcon");
   //Edge symbol end:'sprintIcon'

   //=========================================================
   
   //Edge symbol: 'dates400m_1'
   (function(symbolName) {   
   
         })("dates800m");
   //Edge symbol end:'dates800m'

   //=========================================================
   
   //Edge symbol: 'sprint800'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("sprint800");
   //Edge symbol end:'sprint800'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'sprint200_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
         //Edge binding end

      })("sprint1500");
   //Edge symbol end:'sprint1500'

   //=========================================================
   
   //Edge symbol: 'sprint1500_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
            //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
            //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
            //Edge binding end

         })("sprint10000");
   //Edge symbol end:'sprint10000'

   //=========================================================
   
   //Edge symbol: 'point1500'
   (function(symbolName) {   
   
   })("point1500");
   //Edge symbol end:'point1500'

   //=========================================================
   
   //Edge symbol: 'point15002'
   (function(symbolName) {   
   
   })("point15002");
   //Edge symbol end:'point15002'

   //=========================================================
   
   //Edge symbol: 'dates800m_1'
   (function(symbolName) {   
   
            })("dates1500m");
   //Edge symbol end:'dates1500m'

   //=========================================================
   
   //Edge symbol: 'sprintTemp_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
               //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
               //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
               //Edge binding end

            })("sprint5000");
   //Edge symbol end:'sprint5000'

   //=========================================================
   
   //Edge symbol: 'dates800m_1'
   (function(symbolName) {   
   
            })("dates5000m");
   //Edge symbol end:'dates5000m'

   //=========================================================
   
   //Edge symbol: 'point10000'
   (function(symbolName) {   
   
   })("point10000");
   //Edge symbol end:'point10000'

   //=========================================================
   
   //Edge symbol: 'dates5000m_1'
   (function(symbolName) {   
   
               })("dates10000m");
   //Edge symbol end:'dates10000m'

   //=========================================================
   
   //Edge symbol: 'dateBox'
   (function(symbolName) {   
   
   })("dateBox");
   //Edge symbol end:'dateBox'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34314");