/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob=0, mobOpen=false, clicked=0, btnNo=0, local=0;
         	var gn=34282;
         	var menuBtnCount=2;//number of menu items
         	var headline, headlinemob, stand, standmob, todayDate, endDate, status;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlinetxt").css({"pointer-events":"none"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "data/api.php";
         	//********************************************************************************************************
         	// CSS STYLES
         	//********************************************************************************************************
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         		"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         		"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	var leaveColor="rgba(233,74,49,1)";
         	var remainColor="rgba(52,144,206,1)";
         	var targetCon=0;
         	//********************************************************************************************************
         	// MENU TEXT START
         	//********************************************************************************************************
         	var menuTxt=[], menuArr=[];;
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	//********************************************************************************************************
         	// DATE
         	//********************************************************************************************************
         	var pollsOpen = Date.parse("June 23, 2016, 05:59 UTC");
         	var pollsClose = Date.parse("June 23, 2016, 20:59 UTC");
         	endDate = Date.parse("June 24, 2016, 23:59 UTC");
         	function getDate(){
         		todayDate = new Date();
         		if(todayDate<pollsOpen){
         			status=0;
         		}else if(todayDate>pollsClose){
         			status=2;
         		}else{
         			status=1;
         		}
         		setTimeout(function(){ getDate(); },3600000);
         	}
         	getDate();
         	//********************************************************************************************************
         	// TEXT AND XML
         	//********************************************************************************************************
         	var txt=[];
         	txt[0]=sym.$("txt0").css({"pointer-events":"none"});
         	for (var i=1; i<8; i++){
         			txt[i] = sym.getSymbol("graphMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=8; i<12; i++){
         			txt[i] = sym.getSymbol("regionGraphMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[12] = sym.getSymbol("regionGraphMc").getSymbol("auxBtn").$("txt12").css({"pointer-events":"none"});
         	var searchtxt, constitArr=[], statusArr=[]; regionArr=[], txtArr=[], localWin=[];
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gn+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			stand = $(xml).find('standtxt').text();
         			standmob = $(xml).find('mobstandtxt').text();
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").html(source);
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css({"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"});
         			// MENU TEXT START
         			for (var i=0; i<menuBtnCount; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         			for(var i=0;i<txt.length;i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         			}
         			searchtxt=$(xml).find('searchtxt').text();
         			sym.getSymbol("mapMc").getSymbol("keyMc").$("txt2").html(txtArr[2]);sym.getSymbol("mapMc").getSymbol("keyMc").$("txt3").html(txtArr[3]);
         			var constits=$(xml).find('constituencies').text(); constitArr=constits.split(';');
         			var regions=$(xml).find('regions').text(); regionArr=regions.split(';');
         			var statustxt=$(xml).find('status').text(); statusArr=statustxt.split(';');
         			var constitJSON=[];
         			var htmlTable="<div class='localTable'>";
         			for (var c=0;c<constitArr.length;c++){	
         				htmlTable+="<div id='c"+c+"' class='constit'><table class='localTable'><tr><td class='name'>"+constitArr[c]+"</td><td><div class='blob' id='col"+c+"'></div></td></tr></table></div>"
         				constitJSON[c]={ value: constitArr[c], data: 'c'+c };
         			}
         			htmlTable+="</div>";		
         			sym.getSymbol("graphMc").$("constituencies").append(htmlTable);
         			sym.getSymbol("graphMc").$("constituencies").css({'overflow-y':'auto'});
         			sym.$(".localTable").css({'width':'100%'});
         			$('.name').css({'width':'95%'});
         			$('.constit').css({'font-family':'pragmatica-web, sans-serif','font-size':'13px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','width':'100%'});
         			$('.col').css({'width':'5%'});
         			$('.blob').css({'height':'16px','width':'16px','border-radius':'8px','background-color':'rgb(200,200,200)','right':'5px','vertical-align':'middle'});
         			//AUTO-COMPLETE
         			var acDiv="<input type='text' name='constituency' placeholder='"+searchtxt+"' id='autocomplete' style='width:98%;font-size:14px;font-family:pragmatica-web,sans-serif;border:solid 1px rgb(150,150,150)'>";
         			sym.getSymbol("graphMc").$("autocomp").append(acDiv);
         			sym.getSymbol("graphMc").$("autocomp").css({'padding':0});
         			$("#autocomplete").css({'margin':0});
         			$('#autocomplete').autocomplete({
         				lookup: constitJSON,
         				onSelect: function (suggestion) {
         					for (var i=1;i<constits.length+1;i++){
         						$('#c'+i).css({'background-color':'rgba(255,200,150,0)'});
         					}
         					sym.getSymbol("graphMc").$('constituencies').animate({scrollTop:$('#c0').position().top}, 0,
         							function(){sym.getSymbol("graphMc").$('constituencies').animate({scrollTop:$('#'+suggestion.data).position().top}, 200);
         					});
         					$('#'+suggestion.data).css({'background-color':'rgba(255,200,150,0.3)'});
         				}
         			});
         			$(".autocomplete-suggestions").css({'padding-left':'2px', 'font-family':'pragmatica-web, sans-serif', 'font-size':'13px','color':'rgb(50,75,150)', 'background-color':'rgb(255,255,255)', 'box-shadow':'3px 3px 3px rgba(150,150,150,0.5)',
         			'max-height':'140px','overflow':'hidden'});
         			$(".autocomplete-suggestion").css({});
         			$(".autocomplete-selected").css({});
         			$(".autocomplete-group").css({});
         			$(".autocomplete-group strong").css({});
         		},
         		complete:function(){
         			initSize();
         	   }
         	});
         	//********************************************************************************************************
         	// INIT SIZE
         	//********************************************************************************************************
         	function initSize(){
         		var stageWidth=sym.$("Stage").width();
         			sym.stop(stageWidth*10);
         		var graphWidth=sym.$("graphMc").width();
         		sym.getSymbol("graphMc").$("graph").css({'left':(graphWidth-200)/2+'px'});
         		sym.getSymbol("regionGraphMc").$("graph").css({'left':(graphWidth-200)/2+'px'});
         		local==0?sym.$("regionGraphMc").fadeOut(0):sym.$("regionGraphMc").fadeIn(0);
         		stageWidth<640?sym.$("standTxt").html(standmob):sym.$("standTxt").html(stand);
         		if(stageWidth<480){
         			mob = 1;
         			headlinetxt.html(headlinemob);
         			sym.$("menuBtnsMc").fadeIn(0);
         			sym.getSymbol("mapMc").$("keyMc").fadeIn(0);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         				if(clicked==0){
         					sym.$("graphMc").stop().animate({'right':'0%'},0);
         					sym.$("regionGraphMc").stop().animate({'right':'0%'},0);
         					sym.$("mapMc").stop().animate({'right':'100%'},0);
         					sym.$("standTxt").css({'width':'98%','text-align':'center'});
         					txt[0].fadeOut(0);
         				}else{
         					sym.$("graphMc").stop().animate({'right':'-100%'},0);
         					sym.$("regionGraphMc").stop().animate({'right':'-100%'},0);
         					sym.$("mapMc").stop().animate({'right':stageWidth-320+'px'},0);
         					sym.$("standTxt").css({'width':'33%','text-align':'right'});
         					txt[0].fadeIn(0); txt[0].css({'top':'165px','right':'1%'});
         				}
         		}else{
         			mob = 0;
         			headlinetxt.html(headline);
         			sym.$("menuBtnsMc").fadeOut(0);
         			sym.getSymbol("mapMc").$("keyMc").fadeOut(0);
         			sym.$("standTxt").css({'width':'70%','text-align':'center'});
         			txt[0].fadeIn(0); txt[0].css({'top':'107px','right':'51%'});
         			sym.getSymbol("menuBtnsMc").$("menuTxt").stop().animate({right:85}, 0);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         			sym.$("graphMc").stop().animate({'right':'0%'},0);
         			sym.$("regionGraphMc").stop().animate({'right':'0%'},0);
         			sym.$("mapMc").stop().animate({'right':'50%'},0);
         			if (clicked == 1){
         				resetmenu();
         				sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(black);
         				sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[0]);
         				clicked = 0;
         			}
         		}
         		setStyle();
         		menuMob();
         	}
         	//********************************************************************************************************
         	// MENU BUTTONS
         	//********************************************************************************************************
         	menuArray = [];//the array that will hold references to the buttons.
         	for (var h=0; h<menuBtnCount; h++){
         		menuArray.push(h);
         	}
         	function resetmenu(){
         		for (var h=0; h<menuArray.length; h++){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		}
         	}
         	resetmenu();
         	// MENU CLICK
         	var menuBtnClick = function(menuNo){ //to handle lexical scope
         		return function (e) {
         			e.preventDefault(); e.stopPropagation();
         			clicked = menuNo;
         			resetmenu();
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(black);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").html(menuArr[menuNo]);
         			if(mob==1){
         	
         			}
         			initSize();
         		};
         	};
         	for (var b=0;b<menuArray.length;b++){
         		sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         		sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         	}
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(black);
         	
         	//********************************************************************************************************
         	// MOBILE MENU BUTTON
         	//********************************************************************************************************
         	sym.$("menuBtnMob").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		if (mobOpen == true) {
         			mob = 1;
         		} else {
         			mob = 2;
         		}
         		menuMob();
         	});
         	
         	function menuMob() {
         	         		var stageWidth=sym.$("Stage").width();
         	         		var leftright=(RTL == false)?"right":"left";
         	         		var btnWidth=40, btnHeight=40;
         	         		if (mob == 0){ // HIDE MOBILE MENU
         	         				sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         	         			for (var s=0; s<menuBtnCount; s++){ 
         	         					RTL == false?sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, right:((menuBtnCount-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic'):
         	         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:((menuBtnCount-1)*btnWidth)-(s*btnWidth)}, 200, 'easeOutCubic');
         	         				}
         	         			}
         	         		if (mob == 1){ // MOBILE MENU CLOSED
         	         				sym.$("menuBtnMob").stop().animate({top:btnWidth}, 0);
         	         				for (var s=0; s<menuBtnCount; s++){
         	         					RTL == false?sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, right:0}, 200, 'easeOutCubic'):
         	         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         	         				}
         	         				mobOpen = false;
         	         			}
         	         		if (mob == 2){ // MOBILE MENU OPEN
         	         				sym.$("menuBtnMob").stop().animate({top:btnWidth}, 0);
         	         				for (var s=0; s<menuBtnCount; s++){
         	         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*btnHeight}, 200, 'easeOutCubic');
         	         				}
         	         				mobOpen = true;
         	         			}
         	         		if (RTL == true){
         	         			sym.$("menuBtnsMc").css({"left":"0px"});
         	         			sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         	         			sym.getSymbol("styleHead").$("headlineTxt").attr({"dir":"rtl"});
         	         			sym.$("menuBtnMob").css({"left":"0px"});
         	         			sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":(btnWidth*menuBtnCount)+5+"px"});
         	         			sym.getSymbol("menuBtnsMc").$("menuTxt").attr({"dir":"rtl"});
         	         		}
         	         	}
         	
         	
         	//********************************************************************************************************
         	// SET STYLE  
         	function setStyle(){
         		var stageWidth=sym.$("Stage").width();
         		//sym.getSymbol("Stage").stop(stageWidth*10);
         		sym.$("standTxt").css({'padding':'0 1%'});
         		$(".leavetxt").css({'padding':'1px 10px 3px','background-color':'#e94a31','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto'});
         		$(".remaintxt").css({'padding':'1px 10px 3px','background-color':'#3490ce','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto'});
         		$(".regiontxt").css({'padding':'1px 10px 3px','background-color':'#009640','border':'white solid 1px', 'border-radius':'12px','color':'white','width':'auto'});
         	}
         	setStyle();
         	//********************************************************************************************************
         	// SOURCE BUTTON
         	sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         		if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		}else{
         			sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         			sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		}
         	}); 
         	sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         	});
         	sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         	});
         	//********************************************************************************************************
         	function partyColors(){
         	$(".leave").css({'background-color':'#e94a31'});
         	$(".remain").css({'background-color':'#3490ce'});
         	}
         	//********************************************************************************************************
         	//BUILD PIE CHART
         	//PIE CHART
         	function pieChart(hwins,awins,draws,placeHolder){			
         	     var canvasWidth = 200, //width
         	      canvasHeight = 200,   //height
         	      outerRadius = 100,   //radius
         	      //color = d3.scale.category20(); //builtin range of colors
         			color = d3.scale.ordinal().range(["#3490ce","#c0cbc6","#e94a31","#FF6666"]);
         	    var dataSet = [
         	      {"legendLabel":"Won", "magnitude":awins},  
         	      {"legendLabel":"Drawn", "magnitude":draws}, 
         	      {"legendLabel":"Won", "magnitude":hwins}];
         	    var vis = d3.select(placeHolder)
         	      .append("svg:svg") //create the SVG element inside the <body>
         	        .data([dataSet]) //associate our data with the document
         	        .attr("width", canvasWidth) //set the width of the canvas
         	        .attr("height", canvasHeight) //set the height of the canvas
         	        .append("svg:g") //make a group to hold our pie chart
         				.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         				//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
         				.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
         	    // This will create <path> elements for us using arc data...
         	    var arc = d3.svg.arc()
         	      .outerRadius(outerRadius)
         			.innerRadius(outerRadius-40); //donut chart
         	    var pie = d3.layout.pie() //this will create arc data for us given a list of values
         	      .value(function(d) { return d.magnitude; }) // Binding each value to the pie
         	      .sort( function(d) { return null; } );
         	    // Select all <g> elements with class slice (there aren't any yet)
         	    var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
         	      .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
         	      .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
         	      .append("svg:g")
         	      .attr("class", "slice");    //allow us to style things in the slices (like text)
         	    arcs.append("svg:path")
         	      //set the color for each slice to be chosen from the color function defined above
         	      .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
         	      .attr("d", arc);
         	}
         	
         	//LIVE TOTAL
         	function getSum(){
         		//getDate();
         		$.ajax({ type: "GET", 
         					url: dataURL,
         	            data: "gn="+gn+"&q=sum&yr=2016",
         	            contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	            async: true,
         	            crossDomain: true,
         	            success: function (data) {         
         						var voteCount = data;
         						var placeHolder="#Stage_graphMc_graph";
         						if(voteCount.length>0){
         							sym.getSymbol("graphMc").$("graph").empty();
         							var leaveNo = voteCount[0].LeaveNoTOT;
         							var leavePc = voteCount[0].LeavePcTOT;
         							var remainNo = voteCount[0].RemainNoTOT;
         							var remainPc = voteCount[0].RemainPcTOT;
         							var totVote = voteCount[0].TotalVote;
         							var areasCounted= voteCount[0].AreasCounted;
         							var timeStamp = voteCount[0].Time;
         							undeclared=(leavePc>0||remainPc>0)?0:1;
         							pieChart(leavePc,remainPc,undeclared,placeHolder);
         							txt[4].html(leaveNo>0?Number(leaveNo).toLocaleString():"");
         							txt[5].html(remainNo>0?Number(remainNo).toLocaleString():"");
         							txt[6].html(leavePc>0?(leavePc)+"%":"");
         							txt[7].html(remainPc>0?(remainPc)+"%":"");
         							txt[1].html(totVote>0?areasCounted<382?areasCounted+txtArr[10]+"382":txtArr[1]+Number(totVote).toLocaleString():(status>0)?statusArr[1]:statusArr[0]);
         						}
         					}
         		});
         		setTimeout(function(){getSum()}, 60000);
         	}
         	getSum();
         	//LIVE LOCAL
         	function getLocal(){
         		//getDate();
         		$.ajax({ type: "GET", 
         			url: dataURL,
         	      data: "gn="+gn+"&q=local&yr=2016",
         	      contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	      async: true,
         	      crossDomain: true,
         	            success: function (data) {         
         						var localVote = data;
         						if(localVote.length>0){
         							for(var i=0;i<localVote.length;i++){
         								var leave=localVote[i].LeavePc;
         								var remain=localVote[i].RemainPc;
         								localWin[i]=(leave>remain)?"leave":(remain>leave)?"remain":"none";
         								$("#col"+i).attr('class','blob '+localWin[i]);
         							}
         							partyColors();
         						}
         					}
         		});
         		setTimeout(function(){getLocal()}, 60000);
         	}
         	getLocal()
         	//********************************************************************************************************
         	//BUILD SVG MAP
         	var regName=[], regWin=[], regLeaveNo=[], regRemainNo=[], regLeavePc=[], regRemainPc=[], areasComplete=[], areasTotal=[]; 
         	function buildMap(){
         	EC.SVG.accessSVG(sym.getSymbol("mapMc").$("regions")).done(
         		function(svgDocument){
         			//LIVE DATA
         			function getData(){
         				$.ajax({ type: "GET", 
         					url: dataURL,
         	            data: "gn="+gn+"&q=data&yr=2016",
         	            contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         	            async: true,
         	            crossDomain: true,
         	            success: function (data) {         
         						var mapData = data;
         						if(mapData){
         							for (var i = 0; i < mapData.length; i++) {
         								var cno=mapData[i].index;//index=name of json attr e.g. uk1
         								regWin[i]=(mapData[i].LeaveNo>mapData[i].RemainNo)?"leave":(mapData[i].RemainNo>mapData[i].LeaveNo)?"remain":"none";
         								$("#uk"+(cno), svgDocument).attr({'class':regWin[i]});
         								regLeaveNo[i]=mapData[i].LeaveNo; regRemainNo[i]=mapData[i].RemainNo; regLeavePc[i]= mapData[i].LeavePc; regRemainPc[i]=mapData[i].RemainPc;
         								areasComplete[i]=mapData[i].AreasComplete;areasTotal[i]=mapData[i].AreasTotal;
         							}
         						}
         					}
         				});
         				if(status==1){
         					setTimeout(function(){getData()}, 600000);
         				}else if(status==2&&todayDate<endDate+86400000){ 
         					setTimeout(function(){getData()}, 60000); 
         				}
         			}
         			getData();
         			function clickConstit(event){
         				sym.setVariable("selectedPart", event.target);
         				var constitSelect = sym.getVariable("selectedPart");
         				var placeHolder="#Stage_regionGraphMc_graph";
         				sym.getSymbol("regionGraphMc").$("graph").empty();
         				sym.$("regionGraphMc").fadeIn(0);
         				for (var i=0; i<constitArr.length; i++){
         					if (event.target.id=="uk"+(i+1)){
         							constitSelect.style.opacity=1.0;
         							var undec=(regLeavePc[i]>0||regRemainPc[i]>0)?0:1;
         							targetCon=i+1;
         							txt[8].html(Math.round(regLeavePc[i])+"%");
         							txt[9].html(Math.round(regRemainPc[i])+"%");
         							txt[10].html(areasComplete[i]+txtArr[10]+areasTotal[i]);
         							txt[11].html("<span class='regiontxt'>"+regionArr[i]+"</span>");
         							pieChart(regLeavePc[i],regRemainPc[i],undec,placeHolder);
         					}else{
         						$("#uk"+(i+1), svgDocument).animate({opacity:0.6},300);
         					}
         				}
         				local=1;
         				setStyle();
         			}
         			function overConstit(event){
         				sym.setVariable("overPart", event.target);
         				var constitOver = sym.getVariable("overPart");
         					if(targetCon!=parseInt(event.target.id.substr(2),10)){
         						if(targetCon<1){
         							constitOver.style.opacity=0.6;
         						}else{
         							constitOver.style.opacity=1.0;
         						}
         					}
         			}
         			function outConstit(event){
         				sym.setVariable("outPart", event.target);
         				var constitOut = sym.getVariable("outPart");
         							if(targetCon!=parseInt(event.target.id.substr(2),10)){
         								if(targetCon<1){
         									constitOut.style.opacity=1.0;
         								}else{
         									constitOut.style.opacity=0.6;
         								}
         							}
         			}
         			//SHOW CONSTITUENCY
         			for (var i=0;i<constitArr.length;i++){
         				$('#uk'+i).css({'cursor':'pointer'});
         				$("#uk"+i, svgDocument).on("click",clickConstit);
         				$("#uk"+i, svgDocument).on("mouseover",overConstit);
         				$("#uk"+i, svgDocument).on("mouseout",outConstit);
         			}
         			sym.getSymbol("regionGraphMc").$("auxBtn").on('click', function(){
         				targetCon=0; local=0;
         				sym.$("regionGraphMc").fadeOut(300);
         				for (var i=0; i<constitArr.length; i++){
         					$("#uk"+(i+1), svgDocument).animate({opacity:1.0},300);
         				}
         			});
         	});
         	
         			//if(status==1){
         			//	setTimeout(function(){buildMap()}, 600000);
         			//	}else if(status==2&&todayDate<endDate+86400000){ 
         			//		setTimeout(function(){buildMap()}, 60000); 
         			//	}
         	}
         	buildMap();
         	//********************************************************************************************************
         	$(window).on('resize',initSize);
         	initSize();
         	//********************************************************************************************************
         	//-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'MapMc'
   (function(symbolName) {   
   
   })("MapMc");
   //Edge symbol end:'MapMc'

   //=========================================================
   
   //Edge symbol: 'GraphMc'
   (function(symbolName) {   
   
   })("GraphMc");
   //Edge symbol end:'GraphMc'

   //=========================================================
   
   //Edge symbol: 'RegionGraphMc'
   (function(symbolName) {   
   
   })("RegionGraphMc");
   //Edge symbol end:'RegionGraphMc'

   //=========================================================
   
   //Edge symbol: 'AuxBtn'
   (function(symbolName) {   
   
   })("AuxBtn");
   //Edge symbol end:'AuxBtn'

   //=========================================================
   
   //Edge symbol: 'KeyMc'
   (function(symbolName) {   
   
   })("KeyMc");
   //Edge symbol end:'KeyMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34282");