/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 7;//Stade de France
         	var btnNo = 0;
         	var move = -150;
         	
         	var panelPath = sym.getSymbol("panelMc").getSymbol("panelContentMc");
         	var venPath = sym.getSymbol("venList");
         	var mapPath = sym.getSymbol("mapMc");
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white", "height":"40px", "padding":"5px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var blueTxtLeft = {"border-radius":"5px", "color":"#fff", "background-color":"#46a0d2","width":"auto", "padding":"3px", "padding-left":"16px", "padding-right":"6px", "pointer-events":"none"};
         	var blueTxtRight = {"border-radius":"5px", "color":"#fff", "background-color":"#46a0d2","width":"auto", "padding":"3px", "padding-right":"16px", "padding-left":"6px", "pointer-events":"none"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	/*
         	for (var i=0; i<3; i++){
         		txt[i] = sym.getSymbol("SYMBOL").$("txt"+i).css({"pointer-events":"none"});
         	}
         	*/
         	txt[0] = mapPath.$("txt0").css(blueTxtLeft);
         	txt[1] = mapPath.$("txt1").css(blueTxtRight);
         	txt[2] = mapPath.$("txt2").css(blueTxtLeft);
         	txt[3] = mapPath.$("txt3").css(blueTxtLeft);
         	txt[4] = mapPath.$("txt4").css(blueTxtRight);
         	txt[5] = mapPath.$("txt5").css(blueTxtRight);
         	txt[6] = mapPath.$("txt6").css(blueTxtLeft);
         	txt[7] = mapPath.$("txt7").css(blueTxtRight);
         	txt[8] = mapPath.$("txt8").css(blueTxtRight);
         	txt[9] = mapPath.$("txt9").css(blueTxtLeft);
         	txt[10] = mapPath.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = panelPath.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         
         	var txtArr=[], stadia=[], stadiaEvents=[]
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34265.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<20; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         	$(xml).find("stadiums").each(function(){
         		var $stadia=$(this);
         		stadiaEvents.push($stadia);
         	});
         
         		sym.getSymbol("mapMc").$("txt10").css({"font-size":"22px"});
         
         		for (var i=0; i<10; i++){
         			venPath.getSymbol("venBtn"+i).$("txt").html(txtArr[i]).css({"pointer-events":"none"});
         		}
         		venPath.$("txt").html(txtArr[10]).css({"pointer-events":"none"});
         		changeStadia();
         	},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         var stadiaName=[], matches=[], openDate=[], homeTeam=[], capacityNo=[], featuresTxt=[];
         function changeStadia() {
         		var $events=stadiaEvents[0].find('stadia');
         		panelPath.$("table").empty();
         		resetRect();
         		resetmenu();
         		var i=0;
         		var tableTxt="<table id='datestable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			var stadnam=$event.find("stadiaName").text();
         			stadiaName.push(stadnam);
         			var opendate=$event.find("opened").text();
         			openDate.push(opendate);
         			var homenam=$event.find("homeTeam").text();
         			homeTeam.push(homenam);
         			var capno=$event.find("capacity").text();
         			capacityNo.push(capno);
         			var featno=$event.find("features").text();
         			featuresTxt.push(featno);
         			if($event.attr('number')==clicked){//only get the event that matches 
         				var $matches=$event.find("matches");
         				$matches.each(function(){
         					var $matches=$(this);
         					var month=$matches.find("month").text();
         					var day=$matches.find("day").text();
         					var match=$matches.find("match").text();
         					if (RTL == true){
         						tableTxt+="<tr id='"+"stadia"+i+"' class='"+"stadia'>";
         						tableTxt+="<td id='"+"matchId"+i+"' class='"+"matchCl'>"+match+"</td>";
         						tableTxt+="<td id='"+"dayId"+i+"' class='"+"dayCl'>"+day+"</td>";
         						tableTxt+="<td id='"+"monthId"+i+"' class='"+"monthCl'>"+month+"</td>";
         					} else {
         						tableTxt+="<tr id='"+"stadia"+i+"' class='"+"stadia'>";
         						tableTxt+="<td id='"+"monthId"+i+"' class='"+"monthCl'>"+month+"</td>";
         						tableTxt+="<td id='"+"dayId"+i+"' class='"+"dayCl'>"+day+"</td>";
         						tableTxt+="<td id='"+"matchId"+i+"' class='"+"matchCl'>"+match+"</td>";
         					}
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         				}
         		});
         		panelPath.$("table").append(tableTxt); //Then attach the buttons:
         		$("#datestable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse', 'width':'100%'});
         		$("#datestable tr:odd").css({"background-color":"rgba(253,185,19,0.6)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$("#datestable tr:even").css({"background-color":"rgba(253,185,19,0.3)",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$(".stadia").css({'height':'13px', 'padding-top':'1px', "vertical-align":"top"});
         		$(".monthCl").css({'width':'10%', "font-weight":"bold", 'padding-left':'5px', 'padding-right':'5px', 'text-align':'left'});
         		$(".dayCl").css({'width':'10%', "font-weight":"bold", "color":"#000", "background-color":"rgba(253,185,19,0.9)", 'text-align':'center'});
         		$(".matchCl").css({'width':'80%', "font-weight":"bold", 'padding-right':'5px', 'padding-left':'5px', 'text-align':'left'});
         
         		panelPath.$("stadiaNameTxt").html(stadiaName[clicked]);
         		panelPath.$("openTxt").html(txtArr[11] + "<br>" + "<b>"+openDate[clicked]+"</b>");
         		panelPath.$("homeTxt").html(txtArr[12] + "<br>" + "<b>"+homeTeam[clicked]+"</b>");
         		panelPath.$("capacityTxt").html(txtArr[13] + "<br>" + "<b>"+capacityNo[clicked]+"</b>").css({"width":"auto"});
         		panelPath.$("featuresTxt").html(featuresTxt[clicked]);
         		panelPath.$("capMen").css({"left":10 + panelPath.$("capacityTxt").width()+20 + "px"});
         		panelPath.getSymbol("capMen").$("menMask").css({"left":capacityNo[clicked].replace(",", "")/769+"px"});
         
         		venPath.getSymbol("venBtn"+clicked).$("txt").css({"color":"#1e436b"});
         		sym.getSymbol("mapMc").$("txt" + clicked).css({"background-color":"#1e436b"});
         		venPath.getSymbol("miniMap").$("ball"+clicked).fadeIn(0);
         		sym.getSymbol("navBtns").$("btnNavNext").css({"top":"0px"});
         		sym.getSymbol("navBtns").$("btnNavBack").css({"top":"0px"});
         		if (clicked>8){
         			sym.getSymbol("navBtns").$("btnNavNext").css({"top":"40px"});
         		}
         		if (clicked<1){
         			sym.getSymbol("navBtns").$("btnNavBack").css({"top":"40px"});
         		}
         		panelPath.getSymbol("stadiaMc").$("stadia").css({"top":(clicked*move) + "px"});
         
         		checkRTL();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<10; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("mapMc").$("txt" + h).css({"background-color":"#46a0d2"});
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		changeStadia();
         		stageWidth=sym.$("Stage").width();
         		if(stageWidth<610){
         			toggleIn();
         		}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("mapMc").$("btn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("mapMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("mapMc").$("txt0").css({"background-color":"#1e436b"});
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	if(stageWidth<610){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("panelMc").css({"top":"80px", "width":stageWidth/1.54 + "px", "height":"502px"});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("panelMc").css({"top":"80px", "width":"300px", "height":"502px"});
         	}
         	if(stageWidth<460){
         		sym.$("panelMc").css({"top":"40px", "width":stageWidth+"px", "height":"542px"});
         	}else{
         
         	}
         	sym.getSymbol("panelMc").$("panelContentMc").css({"left":(sym.$("panelMc").width()/2-150) + "px"});
         	if (sym.getSymbol("toggleBtn").$("plus").is(":hidden")) {
         		toggleIn();
         	}
         
         	if (RTL == true) {
         		sym.$("toggleBtn").css({"left":"0px"});
         	} else {
         		sym.$("toggleBtn").css({"left":(stageWidth-40) + "px"});
         	}
         
         	mapPath.$("txt1").stop().animate({left: mapPath.$("ball1").position().left-(mapPath.$("txt1").width()+8), top:mapPath.$("ball1").position().top+3}, 0);
         	mapPath.$("txt4").stop().animate({left: mapPath.$("ball4").position().left-(mapPath.$("txt4").width()+8), top:mapPath.$("ball4").position().top+3}, 0);
         	mapPath.$("txt5").stop().animate({left: mapPath.$("ball5").position().left-(mapPath.$("txt5").width()+8), top:mapPath.$("ball5").position().top+3}, 0);
         	mapPath.$("txt7").stop().animate({left: mapPath.$("ball7").position().left-(mapPath.$("txt7").width()+8), top:mapPath.$("ball7").position().top+3}, 0);
         	mapPath.$("txt8").stop().animate({left: mapPath.$("ball8").position().left-(mapPath.$("txt8").width()+8), top:mapPath.$("ball8").position().top+3}, 0);
         	checkRTL();
         	setStyle();
         }
         
         //********************************************************************************************************
         // TOGGLE BUTTON
         //********************************************************************************************************
         sym.$("toggleBtn").on('touchstart click', function(e){
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible")) {
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").css({"left":stageWidth + "px"});
         		sym.$("navBtns").fadeOut(0);
         	} else{
         		toggleIn();
         	}
         });
         function toggleIn(){
         	sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         	sym.$("panelMc").css({"left":"0px"});
         	sym.$("navBtns").fadeIn(0);
         }
         //********************************************************************************************************
         // NAV ARROW BUTTONS
         //********************************************************************************************************
         sym.getSymbol("navBtns").$("btnNavNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	changeStadia();
         });
         sym.getSymbol("navBtns").$("btnNavBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked--;
         	changeStadia();
         });
         //********************************************************************************************************
         // LIST BUTTONS
         //********************************************************************************************************
         
         var clickRect = 0;
         rectArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<10; a++){
         	rectArray.push(a);
         }
         
         function resetRect(){
         	for (var a=0; a<rectArray.length; a++){
         		venPath.getSymbol("venBtn"+a).$("txt").css({"color":"#46a0d2"});
         		venPath.getSymbol("miniMap").$("ball"+a).fadeOut(0);
         	}
         }
         resetRect();
         
         // RECT CLICK
         var rectBtnClick = function(rectNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = rectNo;
         		changeStadia();
         	};
         };
         for (var b=0;b<rectArray.length;b++){
         	venPath.$("venBtn"+b).on('touchstart click',rectBtnClick(b));
         	venPath.$("venBtn"+b).css({'cursor':'pointer'});
         }
         venPath.getSymbol("venBtn0").$("txt").css({"color":"#1e436b"});
         
         //********************************************************************************************************
         // RTL CHECK
         //********************************************************************************************************
         
         function checkRTL(){
         
         	if (RTL == true){
         		panelPath.$("capacityTxt").css({"text-align":"right", "left":(290 - panelPath.$("capacityTxt").width())+"px"});
         		panelPath.$("capMen").css({"left":90 - panelPath.$("capacityTxt").width()+90 + "px"});
         		panelPath.$("capMen").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right"});
         		sym.$("standTxt").css({"text-align":"right"});
         		$(".matchCl").css({'text-align':'right'});
         		$(".monthCl").css({'text-align':'right'});
         		panelPath.$("txt14").css({"text-align":"right"});
         		panelPath.$("openTxt").css({"text-align":"right"});
         		panelPath.$("homeTxt").css({"text-align":"right"});
         
         		panelPath.$("featuresTxt").css({"text-align":"right"});
         		sym.getSymbol("navBtns").$("btnNavNext").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)', "left":"0px"});
         		sym.getSymbol("navBtns").$("btnNavBack").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)', "left":"40px"});
         	}
         }
         checkRTL();
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("venList").stop(stageWidth*10);
         	sym.getSymbol("mapMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6100, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6100, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'placeHolder'
   (function(symbolName) {   
   
   })("placeHolder");
   //Edge symbol end:'placeHolder'

   //=========================================================
   
   //Edge symbol: 'ball'
   (function(symbolName) {   
   
   })("ball");
   //Edge symbol end:'ball'

   //=========================================================
   
   //Edge symbol: 'logo'
   (function(symbolName) {   
   
   })("logo");
   //Edge symbol end:'logo'

   //=========================================================
   
   //Edge symbol: 'capMen'
   (function(symbolName) {   
   
   })("capMen");
   //Edge symbol end:'capMen'

   //=========================================================
   
   //Edge symbol: 'panelContentMc'
   (function(symbolName) {   
   
   })("panelContentMc");
   //Edge symbol end:'panelContentMc'

   //=========================================================
   
   //Edge symbol: 'venList'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6100, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("venList");
   //Edge symbol end:'venList'

   //=========================================================
   
   //Edge symbol: 'mapMc_1'
   (function(symbolName) {   
   
      })("miniMap");
   //Edge symbol end:'miniMap'

   //=========================================================
   
   //Edge symbol: 'venBtn'
   (function(symbolName) {   
   
   })("venBtn");
   //Edge symbol end:'venBtn'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'btnNav'
   (function(symbolName) {   
   
   })("btnNav");
   //Edge symbol end:'btnNav'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'stadiaMc'
   (function(symbolName) {   
   
   })("stadiaMc");
   //Edge symbol end:'stadiaMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34265");