/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var scene = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"grey", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var standStyle = {"padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.getSymbol("scene1").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scene1").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("scene1").$("txt2").css(whiteTxtBox);
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("scene2").getSymbol("clockface").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("scene2").$("txt5").css(whiteTxtBox);
         	txt[6] = sym.getSymbol("scene2").$("txt6").css({"pointer-events":"none", "height":"auto"});
         	txt[7] = sym.getSymbol("scene2").$("txt7").css({"pointer-events":"none", "height":"auto"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("scene3").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("scene3").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("scene4").$("txt13").css(whiteTxtBox);
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css(whiteTxtBox);
         	txt[18] = sym.$("txt18").css(whiteTxtBox);
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34246.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<20; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         				if (RTL == true){
         					txt[i].css({'text-align':"right"});
         					txt[4].css({'text-align':"center"});
         					txt[9].css({'text-align':"center"});
         					txt[10].css({'text-align':"center"});
         					txt[17].css({'text-align':"center"});
         					txt[18].css({'text-align':"center"});
         					sym.$("standTxt").css({'text-align':"right"});
         				}
         			}
         
         			sym.getSymbol("scene1").$("txt2").css({"top":(490 - sym.getSymbol("scene1").$("txt2").height())+"px"})
         			sym.$("standTxt").append(txtArr[3]).css({"height":"auto"});
         			sym.getSymbol("scene2").$("txt5").css({"top":(490 - sym.getSymbol("scene2").$("txt5").height()-65)+"px", "padding-bottom":"75px"})
         			sym.getSymbol("scene2").$("txt6").css({"line-height":"16px", "top":(485 - sym.getSymbol("scene2").$("txt6").height()+10)+"px"})
         			sym.getSymbol("scene2").$("txt7").css({"line-height":"16px", "top":(485 - sym.getSymbol("scene2").$("txt7").height()+10)+"px"})
         			sym.getSymbol("scene4").$("txt13").css({"top":(490 - sym.getSymbol("scene4").$("txt13").height())+"px"})
         			sym.$("txt14").empty();
         		},
            complete:function(){
         		initSize();
            }
         }); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth = sym.$("Stage").width();
         	standHeight = sym.$("standTxt").height();
         	sym.$("navBtns").css({"left":(stageWidth-110) + "px"});
         
         
         	if(stageWidth<640){
         		sym.$("standTxt").css({"top":"-300px", "width":(stageWidth-10) + "px", "height":"auto"});
         		sym.$("standBgMc").css({"top":"-300px", "width":stageWidth + "px", "height":"10px"});
         		sym.$("standBtn").css({"top":"0px"});
         		sym.$("navBtns").css({"left":(stageWidth-150) + "px"});
         		if (RTL == true){
         			sym.$("navBtns").css({"left":"40px"});
         		}
         	}else{
         		sym.$("standBgMc").css({"top":"40px", "width":"200px", "height":"542px"});
         		sym.$("standTxt").css({"top":"40px", "width":"190px", "height":"542px"});
         		sym.$("standBtn").css({"top":"-40px"});
         		sym.$("navBtns").css({"left":(stageWidth-110) + "px"});
         		if (RTL == true){
         			sym.$("navBtns").css({"left":"0px"});
         		}
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("scene2").getSymbol("clockface").$("clockMeasure").fadeOut(0);
         		sym.getSymbol("scene2").getSymbol("clockface").$("txt4").fadeOut(0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("scene2").getSymbol("clockface").$("clockMeasure").fadeIn(0);
         		sym.getSymbol("scene2").getSymbol("clockface").$("txt4").fadeIn(0);
         	}
         	standVis = false;
         	standClose();
         	setStyle();
         	RTLcheck();
         }
         
         //********************************************************************************************************
         // NAV BUTTONS
         //********************************************************************************************************
         sym.getSymbol("navBtns").$("nextBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(scene<7){scene++;}else{scene=0;}
         	changeScene();
         });
         sym.getSymbol("navBtns").$("prevBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(scene>0){scene--;}else{scene=7;}
         	changeScene();
         });
         
         //********************************************************************************************************
         // CHANGE SCENE
         //********************************************************************************************************
         function changeScene() {
         	standVis = false;
         	standClose();
         	sym.$("standTxt").empty();
         	sym.$("standTxt").css({"height":"auto"});
         	sym.getSymbol("navBtns").$("no").html((scene+1) + "/8");
         	sym.getSymbol("navBtns").$("prevBtn").fadeIn(0);
         	sym.getSymbol("navBtns").$("nextBtn").fadeIn(0);
         	sym.$("scene1").stop().fadeOut(200);
         	sym.$("scene2").stop().fadeOut(200);
         	sym.$("scene3").stop().fadeOut(200);
         	sym.$("scene4").stop().fadeOut(200);
         	sym.$("scene5").stop().fadeOut(200);
         	sym.$("scene6").stop().fadeOut(200);
         	sym.getSymbol("scene6").stop();
         	sym.getSymbol("scene6").$("big_ben2")[0].pause();
         	sym.getSymbol("scene3").getSymbol("scene3Mini").stop(0);
         	sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismOver").stop(0);
         	sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismBack").stop(0);
         	sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("secondTimer").stop(0);
         	sym.getSymbol("scene4").$("txt13").stop().animate({opacity:0}, 0);
         	sym.getSymbol("scene4").$("txt9").stop().animate({opacity:0}, 0);
         	sym.getSymbol("scene4").$("txt10").stop().animate({opacity:0}, 0);
         	sym.$("txt14").empty();
         	sym.$("txt14").stop().animate({opacity:0}, 0);
         	sym.$("txt17").stop().animate({opacity:0}, 0);
         	sym.$("txt18").stop().animate({opacity:0}, 0);
         	if (scene == 0){
         		sym.$("scene1").stop().fadeIn(200);
         		sym.getSymbol("navBtns").$("prevBtn").fadeOut(0);
         		sym.$("standTxt").append(txtArr[3]).css(standStyle);
         		sym.getSymbol("standBtn").play(0);
         	}
         	if (scene == 1){
         		sym.$("scene2").stop().fadeIn(200);
         		sym.getSymbol("scene2").play(0);
         		sym.$("standTxt").append(txtArr[8]).css(standStyle);
         		sym.getSymbol("standBtn").play(0);
         	}
         	if (scene == 2){
         		sym.$("scene3").stop().fadeIn(200);
         		sym.getSymbol("scene3").play(0);
         		sym.getSymbol("scene3").getSymbol("scene3Mini").play(0);
         		sym.$("standTxt").append(txtArr[11]).css(standStyle);
         		sym.getSymbol("standBtn").play(0);
         	}
         	if (scene == 3){
         		sym.$("scene4").stop().fadeIn(200);
         		sym.getSymbol("scene4").play(0);
         		sym.$("standTxt").append(txtArr[11]).css(standStyle);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("escapeMechanismOver").stop().animate ({opacity:0}, 0);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("all").stop().animate ({opacity:1}, 0);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("secondTimer").stop().animate ({opacity:1}, 0);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("escapeMechanismBack").stop().animate ({opacity:1}, 0);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismBack").play(0);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismOver").play(0);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("secondTimer").play(0);
         	}
         	if (scene == 4){
         		sym.getSymbol("scene4").$("txt13").stop().animate({opacity:1}, 200);
         		sym.$("scene4").stop().fadeIn(200);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("escapeMechanismOver").stop().animate ({opacity:1}, 200);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("all").stop().animate ({opacity:0.1}, 200);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("secondTimer").stop().animate ({opacity:0.1}, 200);
         		sym.getSymbol("scene4").getSymbol("mainChains").$("escapeMechanismBack").stop().animate ({opacity:0}, 200);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismBack").play(0);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("escapeMechanismOver").play(0);
         		sym.getSymbol("scene4").getSymbol("mainChains").getSymbol("secondTimer").play(0);
         		sym.$("standTxt").append(txtArr[12]).css(standStyle);
         		sym.getSymbol("standBtn").play(0);
         	}
         	if (scene == 5){
         		sym.$("scene5").stop().fadeIn(200);
         		sym.getSymbol("scene5").play(0);
         		sym.getSymbol("scene5").getSymbol("mainChains").getSymbol("escapeMechanismBack").play(0);
         		sym.getSymbol("scene5").getSymbol("mainChains").getSymbol("secondTimer").play(0);
         		sym.$("standTxt").append(txtArr[11]).css(standStyle);
         		sym.$("txt14").stop().animate({opacity:1}, 0);
         		sym.$("txt14").append(txtArr[14]).css(whiteTxtBox);
         	}
         	if (scene == 6){
         		sym.$("scene5").stop().fadeIn(200);
         		sym.getSymbol("scene5").play(1001);
         		sym.getSymbol("scene5").getSymbol("mainChains").getSymbol("escapeMechanismBack").play(0);
         		sym.$("standTxt").append(txtArr[11]).css(standStyle);
         		sym.$("txt14").stop().animate({opacity:1}, 0);
         		sym.$("txt14").append(txtArr[15]).css(whiteTxtBox);
         	}
         	if (scene == 7){
         		sym.$("scene6").stop().fadeIn(200);
         		sym.getSymbol("scene6").play(0);
         		sym.getSymbol("scene6").$("big_ben2")[0].currentTime = 0;
         		sym.$("standTxt").append(txtArr[16]).css(standStyle);
         		sym.$("txt17").stop().animate({opacity:1}, 0);
         		sym.$("txt18").stop().animate({opacity:1}, 0);
         		sym.getSymbol("standBtn").play(0);
         		//scene = -1;
         	}
         	standHeight = sym.$("standTxt").height();
         
         }
         changeScene();
         
         //********************************************************************************************************
         // STAND BUTTONS
         //********************************************************************************************************
         var standVis = false;
         var standClicked = false;
         
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (standVis == false) {
         		standOpen();
         		standClicked = true;
         		standVis = true;
         	}else{
         		standClose();
         		standVis = false;
         	}
         });
         
         function standOpen(){
         	if(stageWidth<640){
         		sym.$("standTxt").stop().animate ({top:40}, 200, 'easeOutCubic');
         		sym.$("standBgMc").stop().animate ({top:40, height:standHeight+20}, 200, 'easeOutCubic');
         		sym.$("standBtn").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         		sym.getSymbol("standBtn").stop("open");
         		var standHt=sym.$("standTxt").height();
         		sym.$("txt14").stop().animate({top:standHt-110},200);
         	}
         }
         function standClose(){
         	stageWidth = sym.$("Stage").width();
         	if(stageWidth<640){
         		sym.$("standBgMc").stop().animate ({top:-300, height:20}, 200, 'easeOutCubic');
         		sym.$("standTxt").stop().animate ({top:-300}, 200, 'easeOutCubic');
         		sym.$("standBtn").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         		sym.getSymbol("standBtn").stop("closed");
         		sym.$("txt14").stop().animate({top:0},200);
         	}
         }
         sym.getSymbol("standBtn").play();
         
         //********************************************************************************************************
         // RIGHT TO LEFT
         //********************************************************************************************************
         function RTLcheck(){
         	if (RTL == false){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left"});
         		sym.$("standBtn").css({"left":(stageWidth-40) + "px"});
         	}else{ // RTL = TRUE
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right"});
         		sym.$("standBtn").css({"left":"0px"});
         	}
         }
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").html(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'scene1'
   (function(symbolName) {   
   
   })("scene1");
   //Edge symbol end:'scene1'

   //=========================================================
   
   //Edge symbol: 'scene2'
   (function(symbolName) {   
   
   })("clockface");
   //Edge symbol end:'clockface'

   //=========================================================
   
   //Edge symbol: 'scene1_1'
   (function(symbolName) {   
   
      })("scene2");
   //Edge symbol end:'scene2'

   //=========================================================
   
   //Edge symbol: 'scene2_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1300, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      })("scene3");
   //Edge symbol end:'scene3'

   //=========================================================
   
   //Edge symbol: 'pendulumMini'
   (function(symbolName) {   
   
   })("pendulumMini");
   //Edge symbol end:'pendulumMini'

   //=========================================================
   
   //Edge symbol: 'scene3Mini'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("scene3Mini");
   //Edge symbol end:'scene3Mini'

   //=========================================================
   
   //Edge symbol: 'scene3_1'
   (function(symbolName) {   
   
         })("scene4");
   //Edge symbol end:'scene4'

   //=========================================================
   
   //Edge symbol: 'mainChains'
   (function(symbolName) {   
   
   })("mainChains");
   //Edge symbol end:'mainChains'

   //=========================================================
   
   //Edge symbol: 'escapeArm'
   (function(symbolName) {   
   
   })("escapeArm");
   //Edge symbol end:'escapeArm'

   //=========================================================
   
   //Edge symbol: 'excapeWheel2'
   (function(symbolName) {   
   
   })("excapeWheel2");
   //Edge symbol end:'excapeWheel2'

   //=========================================================
   
   //Edge symbol: 'excapeWheel2_1'
   (function(symbolName) {   
   
   })("excapeWheel1");
   //Edge symbol end:'excapeWheel1'

   //=========================================================
   
   //Edge symbol: 'pendulumBig'
   (function(symbolName) {   
   
   })("pendulumBig");
   //Edge symbol end:'pendulumBig'

   //=========================================================
   
   //Edge symbol: 'escapeMechanism'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("escapeMechanism");
   //Edge symbol end:'escapeMechanism'

   //=========================================================
   
   //Edge symbol: 'secondTimer'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 85000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("secondTimer");
   //Edge symbol end:'secondTimer'

   //=========================================================
   
   //Edge symbol: 'secondHand'
   (function(symbolName) {   
   
   })("secondHand");
   //Edge symbol end:'secondHand'

   //=========================================================
   
   //Edge symbol: 'scene4_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

            })("scene5");
   //Edge symbol end:'scene5'

   //=========================================================
   
   //Edge symbol: 'scene6'
   (function(symbolName) {   
   
   })("scene6");
   //Edge symbol end:'scene6'

   //=========================================================
   
   //Edge symbol: 'miniRinger'
   (function(symbolName) {   
   
   })("miniRinger");
   //Edge symbol end:'miniRinger'

   //=========================================================
   
   //Edge symbol: 'bigRinger'
   (function(symbolName) {   
   
   })("bigRinger");
   //Edge symbol end:'bigRinger'

   //=========================================================
   
   //Edge symbol: 'miniRinger_1'
   (function(symbolName) {   
   
   })("miniRingerBack");
   //Edge symbol end:'miniRingerBack'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34246");