/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white","padding":"6px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"grey", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"5px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.$("txt0").css(whiteTxtBox);
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("plant2").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("globe").$("txt13").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34210.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<14; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			sym.$("txt9").css({'font-size':"11px", "line-height":"12px"});
         			sym.$("txt10").css({'font-size':"11px", "line-height":"12px"});
         			sym.$("txt11").css({'font-size':"11px", "line-height":"12px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         
         //********************************************************************************************************
         // ARABIC RTL
         //********************************************************************************************************
         if (RTL == true){
         	sym.$("txt0").css({"text-align":"right"});
         	//sym.$("txt1").css({"text-align":"right"});
         	sym.$("txt2").css({"text-align":"right"});
         	sym.$("txt3").css({"text-align":"right"});
         	sym.getSymbol("plant2").$("txt5").css({"text-align":"right"});
         	sym.$("txt7").css({"text-align":"right"});
         	//sym.$("txt8").css({"text-align":"right"});
         	//sym.$("txt9").css({"text-align":"right"});
         	sym.$("txt10").css({"text-align":"right"});
         	sym.$("txt11").css({"text-align":"right"});
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("navBtn").css({"left":(stageWidth/2)-30+"px"});
         
         	if(stageWidth<640){
         		sym.$("txt0").animate({width:stageWidth-50, left:20, top:523 - sym.$("txt0").height()-0}, 0);
         	}else{
         		sym.$("txt0").animate({width:stageWidth-200, left:100, top:523 - sym.$("txt0").height()-0}, 0);
         	}
         	if (stageWidth<480){
         		sym.$("standTxt").css({'font-size':"13px","line-height":"15px"});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.$("standTxt").css({'font-size':"15px","line-height":"16px"});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         }
         //********************************************************************************************************
         // CLICK ACTIONS
         //********************************************************************************************************
         var scene1Vis = 1;
         var scene2Vis = 0;
         var scene3Vis = 0;
         var scene4Vis = 0;
         
         function changeScene(){
         	scene1Vis = 0;
         	scene2Vis = 0;
         	scene3Vis = 0;
         	scene4Vis = 0;
         	sym.$("txt0").empty();
         	sym.$("txt9").hide();
         	sym.getSymbol("navBtn").$("replayMc").fadeOut(0);
         	sym.getSymbol("navBtn").$("arrowMc").fadeIn(0);
         
         	if (clicked == 0){
         		scene1Vis = 1;
         		sym.$("txt0").append(txtArr[0]);
         	} 
         	if (clicked == 1){
         		scene2Vis = 1;
         		sym.$("txt0").append(txtArr[4]);
         		sym.getSymbol("plant2").play(0);
         	}
         	if (clicked == 2){
         		scene3Vis = 1;
         		sym.$("txt0").append(txtArr[6]);
         	}
         	if (clicked == 3){
         		scene4Vis = 1;
         		sym.$("txt0").append(txtArr[12]);
         		sym.getSymbol("plant4").play(0);
         		clicked = -1;
         		sym.getSymbol("navBtn").$("replayMc").fadeIn(0);
         		sym.getSymbol("navBtn").$("arrowMc").fadeOut(0);
         	}
         	fadeScene1();
         	fadeScene2();
         	fadeScene3();
         	fadeScene4();
         	}
         changeScene();
         
         function fadeScene1(){
         	sym.$("plant1").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("txt1").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("txt2").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("txt3").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("scene1Point1").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("scene1Point2").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("scene1Point3").stop().animate ({opacity:scene1Vis}, 500);
         	sym.$("globe").stop().animate ({opacity:scene1Vis}, 500);
         }
         function fadeScene2(){
         	sym.$("plant2").stop().animate ({opacity:scene2Vis}, 500);
         }
         function fadeScene3(){
         	sym.$("plant3").stop().animate ({opacity:scene3Vis}, 500);
         	sym.$("txt7").stop().animate ({opacity:scene3Vis}, 500);
         }
         function fadeScene4(){
         	sym.$("plant4").stop().animate ({opacity:scene4Vis}, 500);
         	sym.$("txt8").stop().animate ({opacity:scene4Vis}, 500);
         	sym.$("txt9").stop().animate ({opacity:scene4Vis}, 500);
         	sym.$("txt10").stop().animate ({opacity:scene4Vis}, 500);
         	sym.$("txt11").stop().animate ({opacity:scene4Vis}, 500);
         }
         
         
         //********************************************************************************************************
         // NAV BUTTON
         //********************************************************************************************************
         sym.$("navBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	changeScene();
         	initSize();
         	});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         }
         setStyle();
         initSize();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'plant1'
   (function(symbolName) {   
   
   })("plant1");
   //Edge symbol end:'plant1'

   //=========================================================
   
   //Edge symbol: 'pointer1'
   (function(symbolName) {   
   
   })("pointer1");
   //Edge symbol end:'pointer1'

   //=========================================================
   
   //Edge symbol: 'globe'
   (function(symbolName) {   
   
   })("globe");
   //Edge symbol end:'globe'

   //=========================================================
   
   //Edge symbol: 'plant1_1'
   (function(symbolName) {   
   
   })("plant2");
   //Edge symbol end:'plant2'

   //=========================================================
   
   //Edge symbol: 'plant2_1'
   (function(symbolName) {   
   
   })("plant3");
   //Edge symbol end:'plant3'

   //=========================================================
   
   //Edge symbol: 'chopper'
   (function(symbolName) {   
   
   })("chopper");
   //Edge symbol end:'chopper'

   //=========================================================
   
   //Edge symbol: 'heliBlades'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 47, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("heliBlades");
   //Edge symbol end:'heliBlades'

   //=========================================================
   
   //Edge symbol: 'tombMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9502, function(sym, e) {
         sym.getComposition().getStage().$("txt9").show();
         

      });
      //Edge binding end

   })("tombMc");
   //Edge symbol end:'tombMc'

   //=========================================================
   
   //Edge symbol: 'archFrame'
   (function(symbolName) {   
   
   })("archFrame");
   //Edge symbol end:'archFrame'

   //=========================================================
   
   //Edge symbol: 'archFrame_1'
   (function(symbolName) {   
   
   })("archSkin");
   //Edge symbol end:'archSkin'

   //=========================================================
   
   //Edge symbol: 'wall'
   (function(symbolName) {   
   
   })("wall");
   //Edge symbol end:'wall'

   //=========================================================
   
   //Edge symbol: 'railOver'
   (function(symbolName) {   
   
   })("railOver");
   //Edge symbol end:'railOver'

   //=========================================================
   
   //Edge symbol: 'arrowMc_1'
   (function(symbolName) {   
   
      })("replayMc");
   //Edge symbol end:'replayMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34210");