/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "pointer-events":"none", "padding-left":"20px", "padding-top":"2px"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "border-radius":"5px", "background-color":"#0054a5", "width":"auto", "height":"auto",  "padding":"6px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	var profilePath = sym.getSymbol("profileMc");
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blueTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#0054a5", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<14; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	for (var i=16; i<24; i++){
         		txt[i] = sym.getSymbol("profileMc").getSymbol("profileTxt").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	for (var i=26; i<35; i++){
         		txt[i] = sym.getSymbol("tableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34155.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<35; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			//sym.getSymbol("carMc").$("text").css({'font-size':"14px"});
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         			mapPath.$("txt0").css(blueTxtBox);
         			mapPath.$("txt1").css(blueTxtBox);
         			mapPath.$("txt1").animate({left:530 - mapPath.$("txt1").width()}, 0);
         			mapPath.$("txt2").css({"line-height":"20px"});
         
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer,stageWidth;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	sym.$("mask").fadeIn(0);
          	sym.$("scrollMc").css({'overflow-x':'hidden'});
          	sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         	sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         	var pos = mapPath.getPosition();
         	sym.getSymbol("controlsMc").$("miles").html((pos / 229).toFixed(1) + " " + (txtArr[24]));
         	sym.getSymbol("controlsMc").$("km").html((pos / 142.18).toFixed(1) + " " + (txtArr[25]));
         	var x = mapPath.$("dotMc").position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500);
         	if (pos == 0 || pos == 6000) {
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.$("scrollMc").css({'overflow-x':'ew-resize'});
         		stopTimer();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
           sym.$("mask").fadeOut(0);
          sym.$("scrollMc").css({'overflow-x':'auto'});
         }
         startTimer();
         
         //********************************************************************************************************
         // PLAY / PAUSE BUTTON
         //********************************************************************************************************
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		mapPath.play();
         		sym.getSymbol("profileMc").play();
         		startTimer();
         	}else{
         		stopTimer();
         		mapPath.stop();
         		sym.getSymbol("profileMc").stop();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         	}
         });
         
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("controlsMc").stop().animate({left:stageWidth/2-140}, 0);
         
         	if(stageWidth<800){
         		sym.$("scrollMc").css({'left':stageWidth/2-320+'px', 'width':'640px'}, 0);
         		sym.$("controlsMc").stop().animate({left:stageWidth/2-140}, 0);
         		sym.$("tableMc").stop().animate ({left:stageWidth+10}, 0);
         		sym.$("standBtn").fadeIn(0);
         		standOpen = false;
         	}else{
         		sym.$("scrollMc").css({'left':'0px'});
         		sym.$("scrollMc").stop().animate({scrollLeft:0}, 0);
         		sym.$("controlsMc").stop().animate({left:stageWidth/2-220}, 0);
         		sym.$("tableMc").stop().animate ({left:stageWidth-160}, 0);
         		sym.$("standBtn").fadeOut(0);
         	}
         	if(stageWidth<640){
         		sym.$("scrollMc").css({'left':'0px', 'width':stageWidth});
         		sym.getSymbol("profileMc").$("profileTxt").stop().animate({opacity:0}, 0);
         		sym.getSymbol("profileMc").$("redLineMob").fadeOut(0);
         		sym.getSymbol("profileMc").getSymbol("dotMc").$("dot").stop().animate({width:(640/stageWidth)*11}, 0);
         	}else{
         		sym.getSymbol("profileMc").$("profileTxt").stop().animate({opacity:1}, 0);
         		sym.getSymbol("profileMc").$("redLineMob").fadeOut(0);
         		sym.getSymbol("profileMc").$("redLine").fadeIn(0);
         		sym.getSymbol("profileMc").$("dotMc").fadeIn(0);
         		sym.getSymbol("profileMc").getSymbol("dotMc").$("dot").stop().animate({width:10}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         }
         //********************************************************************************************************
         // ROTATE
         //********************************************************************************************************
         	$.fn.animateRotate = function(angle, duration, easing, complete) {
             return this.each(function() {
                 var $elem = $(this);
                 $({deg: 0}).animate({deg: angle}, {
                     duration: duration,
                     easing: easing,
                     step: function(now) {
                         $elem.css({
                           '-moz-transform':'rotate('+now+'deg)',
                           '-webkit-transform':'rotate('+now+'deg)',
                           '-o-transform':'rotate('+now+'deg)',
                           '-ms-transform':'rotate('+now+'deg)',
                           'transform':'rotate('+now+'deg)'
                         });
                     },
                     complete: complete || $.noop
                 });
             });
         };
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
             e.stopPropagation(); e.preventDefault();
             stopTimer();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	stopTimer();
             if(down){
                 var newX=e.pageX;
                 sym.$("scrollMc").scrollLeft(left-newX+x);    
             }
         });
         	sym.$("scrollMc").on('mouseup', function(e){
         		down=false;
         	});
         
         //********************************************************************************************************
         // STAND BUTTON
         //********************************************************************************************************
         var standOpen = false;
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (standOpen == false){
         		standOpen = true;
         		sym.$("tableMc").stop().animate ({left:stageWidth-160}, 200, 'easeOutCubic');
         		sym.$("standBtn").animateRotate(180, 0);
         	}else{
         		standOpen = false;
         		sym.$("tableMc").stop().animate ({left:stageWidth+10}, 200, 'easeInCubic');
         		sym.$("standBtn").animateRotate(0, 0);
         	}
         });
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3204, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'courseContMc'
   (function(symbolName) {   
   
   })("courseContMc");
   //Edge symbol end:'courseContMc'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'profileMc'
   (function(symbolName) {   
   
   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'profileTxt'
   (function(symbolName) {   
   
   })("profileTxt");
   //Edge symbol end:'profileTxt'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34155");