/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc");
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blueTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#184286", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	for (var i=0; i<3; i++){
         		txt[i] = sym.getSymbol("tableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=3; i<25; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=25; i<34; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[34] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.$("txt37").css({"pointer-events":"none"});
         	for (var i=38; i<42; i++){
         		txt[i] = mapPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34183.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<42; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			mapPath.$("txt12").css(blueTxtBox);
         			mapPath.$("txt22").css(blueTxtBox);
         			mapPath.$("txt21").css({'line-height':"20px"});
         			mapPath.$("txt39").css({'line-height':"19px"});
         			mapPath.$("txt40").css({'line-height':"19px"});
         			sym.getSymbol("tableMc").$("txt1").css({'line-height':"16px"});
         			sym.getSymbol("tableMc").$("txt2").css({'line-height':"16px"});
         			sym.getSymbol("tableMc").$("txt0").css({'line-height':"16px", "font-size":"15px"});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	var dotPath = sym.getSymbol("profileMc").getSymbol("dotMc").$("dot")
         	sym.$("standBtn").stop().animate({left:stageWidth-40}, 0);
         	sym.$("controlsMc").stop().animate({left:stageWidth/2-160}, 0);
         	sym.$("tableMc").stop().animate ({left:stageWidth+200}, 0);
         	sym.$("standBtn").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	standOpen = false;
         	if(stageWidth<800){
         		dotPath.stop().animate({width:(800/stageWidth)*11,left:-dotPath.width()/2}, 0);
         	}else{
         		sym.getSymbol("profileMc").getSymbol("dotMc").$("dot").stop().animate({width:11, left:0}, 0);
         	}
         	if(stageWidth<640){
         		for (var i=27; i<34; i++){
         			txt[i] = sym.$("txt"+i).css({"opacity":"0"});
         			sym.getSymbol("profileMc").$("pointers").css({"opacity":"0"});
         		}
         	}else{
         		for (var i=27; i<34; i++){
         			txt[i] = sym.$("txt"+i).css({"opacity":"1"});
         			sym.getSymbol("profileMc").$("pointers").css({"opacity":"1"});
         		}
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyle();
         }
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
         	sym.$("mask").fadeIn(0);
         	sym.$("line").fadeOut(0);
         	sym.$("txt25").fadeOut(0);
          	sym.$("scrollMc").css({'overflow-x':'hidden'});
          	sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         	sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         	timer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var pos = mapPath.getPosition();
         	sym.getSymbol("controlsMc").$("miles").html("<b>"+(pos / 381.6).toFixed(1)+"</b>" + " " + (txtArr[34]));
         	sym.getSymbol("controlsMc").$("km").html("<b>"+(pos / 236.9).toFixed(1)+"</b>" + " " + (txtArr[36]));
         	var x = mapPath.$("dot").position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500);
         	if (pos == 0 || pos == 10000) {
         		sym.$("line").fadeIn(0);
         		sym.$("txt25").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.$("scrollMc").css({'overflow-x':'ew-resize'});
         		stopTimer();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
           sym.$("mask").fadeOut(0);
           sym.$("scrollMc").css({'overflow-x':'auto'});
         }
         startTimer();
         
         //********************************************************************************************************
         // PLAY / PAUSE BUTTON
         //********************************************************************************************************
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		mapPath.play();
         		sym.getSymbol("profileMc").play();
         		startTimer();
         	}else{
         		stopTimer();
         		mapPath.stop();
         		sym.getSymbol("profileMc").stop();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         	}
         });
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //********************************************************************************************************
         // STAND BUTTON
         //********************************************************************************************************
         var standOpen = false;
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (standOpen == false){
         		standOpen = true;
         		sym.$("tableMc").stop().animate ({left:stageWidth-200}, 200, 'easeOutCubic');
         		sym.$("standBtn").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         	}else{
         		standOpen = false;
         		sym.$("tableMc").stop().animate ({left:stageWidth+10}, 200, 'easeOutCubic');
         		sym.$("standBtn").css({'transform':'scaleX(1)','-webkit-transform':'scaleX(1)','-ms-transform':'scaleX(1)'});
         	}
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0);
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'profileMc'
   (function(symbolName) {   
   
   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'profileTxt'
   (function(symbolName) {   
   
   })("profileTxt");
   //Edge symbol end:'profileTxt'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob_1'
   (function(symbolName) {   
   
   })("menuBtnMob_1");
   //Edge symbol end:'menuBtnMob_1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34183");