/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var btnNo = 0;
         	var navMove = 0;
         	var clicked = 0;
         	var clickedCard = 0;
         	var clickedAux = 0;
         	var clickedDot = 0;
         	var coursePath = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc");
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var winner;
         	var winnertxt = sym.getSymbol("winnersMc").$("winner").css("pointer-events","none");
         	var course;
         	var coursetxt = sym.getSymbol("winnersMc").$("course0").css("pointer-events","none");
         	
         	for (var a=0; a<18; a++){
         	coursePath.getSymbol("roundBtn"+a).$("txt").html(a+1);
         	coursePath.getSymbol("roundBtn"+a).$("txt").css({"pointer-events":"none"});
         }
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	//menuTxt[3] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // ADD HOLE IMAGES
         //********************************************************************************************************
         holesArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i < 18; i++){
          var holeObject = sym.getSymbol("holesMc").createChildSymbol("holeMc", "holesHolderMc");  // Create an instance element of a symbol as a child of the given parent element
          holeObject.setVariable("id", i);  //set the value of a Symbol variable
          holesArray.push(holeObject);  //push it into the array
         }
         
         for (var i=0; i<holesArray.length; i++){
         		holesArray[i].$("holesArt").animate ({left:-200*i}, 0);
         	}
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = coursePath.$("txt0").css({"pointer-events":"none"});
         	txt[1] = coursePath.$("txt1").css({"pointer-events":"none"});
         	txt[2] = coursePath.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	for (var i=6; i<15; i++){
         		txt[i] = sym.getSymbol("cardMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[15] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.$("txt37").css({"pointer-events":"none"});
         
         	var txtArr=[];
         	var datestring;
         	var parstring;
         	var yardsstring;
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34109.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<38; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			stringPar = $(xml).find('txt4').text(); // Stage date for stage btn info
                  parstring=stringPar.split("<br>");
                  stringYards = $(xml).find('txt5').text(); // Stage date for stage btn info
                  yardsstring=stringYards.split("<br>");
                  for (var h=0; h<18; h++){
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").html(h+1).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").append(parstring[h]).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").append(yardsstring[h]).css({"pointer-events":"none"});
         			}
         			sym.getSymbol("holesMc").$("txt19").css({"pointer-events":"none", "font-size":"16px"});
         			sym.getSymbol("holesMc").$("txt19").empty();
         			sym.getSymbol("holesMc").$("txt19").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         			coursePath.$("txt2").css({"font-size":"16px",'line-height':'20px'});
         			sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt15").css({"pointer-events":"none", "font-size":"16px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("scrollMc").stop().animate({width:stageWidth-200}, 0);
         
         	if(stageWidth<800){
         		sym.$("scrollMc").css({'cursor':'ew-resize'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		sym.$("scrollMc").css({'cursor':'default'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	};
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("winnersMc").$("winnerBtnsMc").stop().animate({left:0, width:stageWidth}, 0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("winnersMc").$("winnerBtnsMc").stop().animate({left:200, width:stageWidth-200}, 0);
         
         	};
         	if (stageWidth<480){
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"left":"49.3%"}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"opacity":"0"}, 0);
         		winBtnPath.$("table td:nth-child(3)").hide();
         		sym.$("holesMc").stop().animate({left:0, width:stageWidth}, 0);
         		if (clicked == 0){
         			resetCard();
         			sym.$("cardMc").stop().animate({left:0, width:stageWidth}, 0);
         		}else{
         			sym.$("cardMc").stop().animate({left:800, width:stageWidth}, 0);
         		};
         		mob = 1;
         	}else{
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt17").css({"left":"39.3%"}, 0);
         		sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc").$("txt18").css({"opacity":"1"}, 0);
         		winBtnPath.$("table td:nth-child(3)").show();
         		if (clicked == 0){
         			resetCard();
         			sym.$("cardMc").stop().animate({left:stageWidth-200, width:200}, 0);
         		}else{
         			sym.$("cardMc").stop().animate({left:800, width:200}, 0);
         		};
         		sym.$("holesMc").stop().animate({left:stageWidth-200, width:200}, 0);
         		mob = 0;
         		navClick();
         	};
         	for (var i=0; i<holesArray.length; i++){
         		holesArray[i].getSymbolElement().stop().animate({left:sym.$("holesMc").width()/2-100}, 0);
         	}
         	setStyle();
         	menuMob();
         };
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		sym.$("winnersMc").animate ({left:800}, 200, 'easeInCubic');
         		if (menuNo == 0){
         			if (stageWidth<480){
         				sym.$("cardMc").stop().animate ({left:0}, 200, 'easeOutCubic');
         				resetCard();
         			}else{
         				sym.$("cardMc").stop().animate ({left:stageWidth-200}, 200, 'easeOutCubic');
         			}
         		};
         		if (menuNo == 1){
         			sym.$("cardMc").stop().animate ({left:stageWidth}, 200, 'easeInCubic');
         		};
         		if (menuNo == 2){
         			sym.$("winnersMc").stop().animate ({left:0}, 200, 'easeOutCubic');
         		};
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:180+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:80-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		//sym.$("standTxt").css({"text-align":"right", "padding-top":"6px"});
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         	}
         }
         
         //********************************************************************************************************
         // DOT BUTTONS
         //********************************************************************************************************
         dotArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	dotArray.push(a);
         }
         
         function resetDot(){
         	for (var a=0; a<dotArray.length; a++){
         		coursePath.getSymbol("roundBtn" + a).$("btnBg").css({"background-color":"white"});
         		coursePath.getSymbol("roundBtn" + a).$("txt").css({"color":"black"});
         	}
         }
         resetDot();
         
         // DOT CLICK
         var dotBtnClick = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		clickedAux = dotNo;
         		clickedDot = clickedAux;
         		navClick();
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<dotArray.length;b++){
         	coursePath.$("roundBtn"+b).on('touchstart click',dotBtnClick(b));
         	coursePath.$("roundBtn"+b).css({'cursor':'pointer'});
         }
         coursePath.getSymbol("roundBtn0").$("btnBg").css({"background-color":"#da0000"});
         coursePath.getSymbol("roundBtn0").$("txt").css({"color":"white"});
         
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         // NAV CLICK FUNCTION
         //********************************************************************************************************
         function navClick(){
         	for (var i=0; i<holesArray.length; i++){
         		holesArray[i].getSymbolElement().animate ({opacity:0}, 0);
         	}
         	holesArray[clickedAux].getSymbolElement().stop().animate ({opacity:1}, 0);
         	sym.getSymbol("holesMc").$("holeNo").html(clickedAux + 1);
         	sym.getSymbol("holesMc").$("txt19").empty();
         	sym.getSymbol("holesMc").$("txt19").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         	sym.getSymbol("holesMc").$("txt20").empty();
         	sym.getSymbol("holesMc").$("txt20").append(txtArr[clickedAux+20]);
         
         	if (clickedAux <=0 ){
         		sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnBack").fadeIn(0);
         	}
         	if (clickedAux >= 17){
         		sym.getSymbol("holesMc").$("navBtnNext").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBtnNext").fadeIn(0);
         	}
         	resetCard();
         	resetDot();
         	sym.getSymbol("cardMc").getSymbol("btn" + clickedAux).$("btnBg").fadeIn(0);
         	coursePath.getSymbol("roundBtn" + clickedAux).$("btnBg").css({"background-color":"#da0000"});
         	coursePath.getSymbol("roundBtn" + clickedAux).$("txt").css({"color":"white"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt01").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt02").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt03").css({"color":"white", "font-weight":"bold"});
         
         	var x = coursePath.$("roundBtn" + clickedAux).position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500, 'easeOutCubic');
         }
         //********************************************************************************************************
         // NAVIGATION BUTTONS
         //********************************************************************************************************
         sym.getSymbol("holesMc").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux++;
         	navClick();
         	});
         sym.getSymbol("holesMc").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux--;
         	navClick();
         	});
         
         //********************************************************************************************************
         // CARD BUTTONS
         //********************************************************************************************************
         cardArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	cardArray.push(a);
         }
         
         function resetCard(){
         	for (var a=0; a<cardArray.length; a++){
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt03").css({"color":"black", "font-weight":"normal"});
         	}
         }
         resetCard();
         
         // CARD CLICK
         var cardBtnClick = function(cardNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		stageWidth=sym.$("Stage").width();
         		clickedAux = cardNo;
         		navClick();
         		if (stageWidth<480){
         			sym.$("cardMc").stop().animate ({left:stageWidth+10}, 200, 'easeInCubic');
         			resetmenu();
         			clicked=1;
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("bg").css(red);
         		}
         	};
         };
         
         for (var b=0;b<cardArray.length;b++){
         	sym.getSymbol("cardMc").$("btn"+b).on('touchstart click',cardBtnClick(b));
         	sym.getSymbol("cardMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("cardMc").getSymbol("btn0").$("btnBg").fadeIn(0);
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt01").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt02").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt03").css({"color":"white", "font-weight":"bold"});
         
         sym.getSymbol("holesMc").$("navBtnBack").fadeOut(0);
         sym.getSymbol("holesMc").getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         
         //********************************************************************************************************
         // WINNERS BUTTONS
         //********************************************************************************************************
         var winBtnPath = sym.getSymbol("winnersMc").getSymbol("winnerBtnsMc")
         
         winnersBtnArray = []; //the array that will hold references to the buttons.
         
         for (var w = 0; w < 10; w++){
         	var winnersBtnSymbols = winBtnPath.getSymbol("btn"+w); // Create an instance element of a symbol as a child of the given parent element
         	winnersBtnSymbols.setVariable("winnersBtnId", w); //set the value of a Symbol variable
         	winnersBtnArray.push(winnersBtnSymbols); //push it into the array
         	winBtnPath.getSymbol("btn"+w).$("no").html(2015-w)
         	winBtnPath.$("btn"+w).css({'cursor':'pointer'});
         	}
         
         	$.each(winnersBtnArray, function( count, winnersBtnInTheArray ){ //a 'for each' loop through the newly populated array
         		var winnersBtnItem = $(winnersBtnInTheArray); //create jQuery reference to the item
         		var winnersBtnElement = winnersBtnInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         		winnersBtnElement.bind ("click touchstart", {winnersBtnId:count}, winnersBtnClick);
         	})
         
         	function resetwinnersBtn(){
         		for (var k=0; k<winnersBtnArray.length; k++){
               	winnersBtnArray[k].$("bg").css({"background-color":"#fff"});
               	winnersBtnArray[k].$("no").css({"color":"#000"});
         		}
         	}
         	resetwinnersBtn();
         
         function winnersBtnClick (e){
         	winBtnPath.$("table").empty()
         	resetwinnersBtn(); //set them all back to normal state
         	var winnersBtn_id = (e.data.winnersBtnId); //get the id of the clicked item
         	winBtnPath.getSymbol("btn" + winnersBtn_id).$("bg").css({"background-color":"rgba(218,0,0,1)"});
         	winBtnPath.getSymbol("btn" + winnersBtn_id).$("no").css({"color":"#fff"});
         	sym.getSymbol("winnersMc").$("winPic").attr("src", "images/w" + (2015-winnersBtn_id) + ".jpg");
         	getYear(2015 - winnersBtn_id);
         }
         
         winBtnPath.getSymbol("btn0").$("bg").css({"background-color":"rgba(218,0,0,1)"});
         winBtnPath.getSymbol("btn0").$("no").css({"color":"#fff"});
         
         function getYear(year){
         		$.ajax({	
         		type: "GET",
         		url: year + "_results.xml",
         		dataType: "xml",
         		success: function(xml) {
         		winner = $(xml).find('winner').text();
         		winnertxt.html(winner);
         		course = $(xml).find('course').text();
         		coursetxt.html(course);
         
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="3" cellspacing="0">';
         		var playerName;
         		var playerScore;
         		var playerPrize;
         
         		$('Ranked',xml).each(function(i) {
         			playerName = $(this).find("person").text();
         			playerScore = $(this).find("score").text();
         			playerPrize = $(this).find("prize").text();
         			var playerdata = winnersTable(playerName,playerScore,playerPrize);
         			htmlOutput = htmlOutput + playerdata;
         		});
         
         		htmlOutput += '</table>';
         		winBtnPath.$("table").append(htmlOutput);
         		winBtnPath.$("table tr:odd").css({"text-align":"left", "background-color":"#fff","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		winBtnPath.$("table tr:even").css({"text-align":"left", "background-color":"#eeeee0","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		winBtnPath.$("table tr:first-child").css({"text-align":"left", "text-align":"left", "font-weight":"bold", "background-color":"#e60000","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         		stageWidth=sym.$("Stage").width();	
         		if(stageWidth<640){
         			winBtnPath.$("table td:nth-child(3)").hide();
         		}
         	}
         });
         
          function winnersTable(playerName,playerScore,playerPrize){
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:40%;font-weight: bold;">'+ playerName +'</td>';
         	output += '<td style="width:40%;">'+ playerScore +'</td>';
         	output += '<td style="width:20%;font-weight: bold;">'+ playerPrize +'</td>';
         	output += '</tr>';
         	return output;
         	}
         }
         getYear(2015);
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	winBtnPath.$("table").css({'overflow-x':'hidden'});
         }
         setStyle();
         sym.$("holesMc").css({'width':'auto'});
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'roundBtnsMc'
   (function(symbolName) {   
   
   })("roundBtnsMc");
   //Edge symbol end:'roundBtnsMc'

   //=========================================================
   
   //Edge symbol: 'roundBtn'
   (function(symbolName) {   
   
   })("roundBtn");
   //Edge symbol end:'roundBtn'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMc");
   //Edge symbol end:'holesMc'

   //=========================================================
   
   //Edge symbol: 'holeMc'
   (function(symbolName) {   
   
   })("holeMc");
   //Edge symbol end:'holeMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'holesHolderMc'
   (function(symbolName) {   
   
   })("holesHolderMc");
   //Edge symbol end:'holesHolderMc'

   //=========================================================
   
   //Edge symbol: 'cardBtn'
   (function(symbolName) {   
   
   })("cardBtn");
   //Edge symbol end:'cardBtn'

   //=========================================================
   
   //Edge symbol: 'cardMc'
   (function(symbolName) {   
   
   })("cardMc");
   //Edge symbol end:'cardMc'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'winnersBtn'
   (function(symbolName) {   
   
   })("winnersBtn");
   //Edge symbol end:'winnersBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34109");