/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var party="rep";//set a default party
         	var partyColour  = "#da0000";
         	
         	var d = new Date();
         	var n = d.getMonth();
         	var clickMonth = n-1;
         	if (clickMonth>4){clickMonth=4};
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"#999", "border-width":"1px","border-style":"solid", "border-radius":"20px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"8px", "padding-right":"40px", "padding-left":"12px", "padding-top":"10px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"20px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var greyTxt  = {"color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("txt").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("txt").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("resultsBtnMc").$("txt5").css(whiteTxtBox);
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("convMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("convMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("convMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("convMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("convMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         
         	var txtArr=[], month=[], monthEvents=[], result=[], resultEvent=[], repHead=[], repName=[], repTally=[], demHead=[], demName=[], demTally=[], repArray=[], demArray=[];//bunch of arrays
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN34096.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<16; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			sym.getSymbol("convMc").$("txt11").css({'line-height':"17px"});
         			sym.getSymbol("convMc").$("txt12").css({'line-height':"17px"});
         			sym.getSymbol("convMc").$("txt13").css({'line-height':"16px"});
         			sym.getSymbol("convMc").$("txt14").css({'line-height':"16px"});
         
         			sym.getSymbol("convMc").$("txt10").css({"font-size":"15px"});
         
         $(xml).find("month").each(function(){
         		var $month=$(this);
         		var monthname=$month.attr('name');
         		month.push(monthname);
         		monthEvents.push($month);
         });
         
         $(xml).find("repResult").each(function(){
         		var $event=$(this);
         		var repname=$event.find("RepublicanName").text();
         		repName.push(repname);
         		var reptally=$event.find("RepublicanTally").text();
         		repTally.push(reptally);
         		var rephead=$event.find("headShot").text();
         		repHead.push(rephead);
         });
         $(xml).find("demResult").each(function(){
         		var $event=$(this);
         		var demname=$event.find("DemocraticName").text();
         		demName.push(demname);
         		var demtally=$event.find("DemocraticTally").text();
         		demTally.push(demtally);
         		var demhead=$event.find("headShot").text();
         		demHead.push(demhead);
         });
         for (var i=0;i<repName.length;i++){
         	var mySymbolObject = sym.createChildSymbol("candidateMc", "repTallyMc");
         	mySymbolObject.setVariable("id", i);
         	repArray.push(mySymbolObject);
         	repArray[i].$("name").html(repName[i]);
         	repArray[i].getSymbol("graphMc").$("tally").html(repTally[i]);
         	repArray[i].getSymbol("graphMc").$("graph").css({"background-color":"#898989"});
         	repArray[i].getSymbolElement().css({"top":"20px"})
         	repArray[i].$("headShot").attr("src", "images/"+ repHead[i] + ".jpg");
         	repArray[i].getSymbol("graphMc").$("suspendedTxt").html(txtArr[15]);
         	repArray[0].getSymbol("graphMc").$("suspendedTxt").empty();
         	repArray[0].getSymbol("graphMc").$("graph").css({"background-color":"#da0000"});
         }
         
         for (var i=0;i<demName.length;i++){
         	var mySymbolObject = sym.createChildSymbol("candidateMc", "demTallyMc");
         	mySymbolObject.setVariable("id", i);
         	demArray.push(mySymbolObject);
         	demArray[i].$("name").html(demName[i]);
         	demArray[i].getSymbol("graphMc").$("tally").html(demTally[i]);
         	demArray[i].getSymbol("graphMc").$("graph").css({"background-color":"#345cc1"});
         	demArray[i].getSymbolElement().css({"top":"32px"})
         	demArray[i].$("headShot").attr("src", "images/"+ demHead[i] + ".jpg");
         }
         
         sym.$("repTallyMc").css({"height":"auto"});
         sym.$("demTallyMc").css({"height":"auto"});
         sym.$("tallyTxt").html(sym.$("repTallyMc").height());
         sym.$("demTallyMc").stop().animate({top:40+sym.$("repTallyMc").height()+77}, 0);
         
         sym.getSymbol("repTallyMc").$("header").html(txtArr[6]);
         sym.getSymbol("repTallyMc").$("total").html(txtArr[7]);
         sym.getSymbol("demTallyMc").$("header").html(txtArr[8]);
         sym.getSymbol("demTallyMc").$("total").html(txtArr[9]);
         sym.getSymbol("demTallyMc").$("total").css({"top":"10px"});
         sym.getSymbol("demTallyMc").$("endLine").css({"top":"10px"});
         
         for (var h=0; h<5; h++){
         	sym.getSymbol("rectBtns").getSymbol("btn"+h).$("txt").empty();
         	sym.getSymbol("rectBtns").getSymbol("btn"+h).$("txt").append(month[h]);
         }
         sym.$("resultsBtnMc").css({"width":sym.getSymbol("resultsBtnMc").$("txt5").width() + 88});
         sym.getSymbol("resultsBtnMc").$("txt5").css({"width":"auto","font-size":'18px'});
         sym.getSymbol("resultsBtnMc").$("resultsBtn").stop().animate({left:sym.getSymbol("resultsBtnMc").$("txt5").width()+18}, 0);
         sym.$("convMc").stop().animate({top:sym.$("repTallyMc").height() + sym.$("demTallyMc").height()+155}, 0);
         
         changeMonth(clickMonth,party);
         changeDay(0,clickMonth,party);
         },
            complete:function(){
         		initSize();
            }
         }); // END XML
         
         sym.$("menuBtnsMc").fadeOut(0);
         
         function changeMonth(num,party) {//arguments: month number and party
         		var dayName=[], stateName=[], delNumber=[], candCount=[];//put your other arrays for the table here. NB candCount new array for candidates
         		var $events=monthEvents[num].find(party+'Date');
         		var n=0;
         		$events.each(function(){
         			candCount[n]=[];//make candCount multidimensional array
         			var $event=$(this);
         			var daynam=$event.find("day").text();
         			dayName.push(daynam);
         			var statenam=$event.find("state").text();
         			stateName.push(statenam);
         			var delnumber=$event.find("delegates").text();
         			delNumber.push(delnumber);
         			var $candidates=$event.find('candidate');//get the candidates
         			$candidates.each(function(){
         			var $candidate=$(this);
         			candCount[n].push($candidate);//push candidates into array
         			});
         			n++;
         		});
         		var tableTxt="<table id='monthTable'>";
         		for (var i=0;i<dayName.length;i++){
         			tableTxt+="<tr id='date"+i+"' class='date'>";
         			tableTxt+="<td id='day"+i+"' class='dayName'>"+dayName[i]+"</td>";
         			tableTxt+="<td id='state"+i+"' class='stateName'>"+stateName[i]+"</td>";
         			tableTxt+="<td id='delegates"+i+"' class='delNumber'>"+(candCount[i].length>0?"<img src='images/openIcon.png'>":"")+"</td>";//test for number of candidates
         			tableTxt+="</tr>";
         		}
         		sym.getSymbol("tablesMc").$("monthTable").append(tableTxt); //Then attach the buttons:
         		for (var i=0;i<dayName.length;i++){
         			if(candCount[i].length>0){ //test for number of candidates
         			$("#date"+i).on('click',showDate(num,i,party));
         			}
         		}
         		$("#monthTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px",'border-collapse':'collapse', 'width':'100%'});
         		$("#monthTable tr:odd").css({"background-color":"#E9E9EA",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         		$("#monthTable tr:even").css({"background-color":"#f8f8f9",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         		$(".date").css({'height':'43px', 'cursor':'pointer'});
         		$(".dayName").css({'width':'100px','padding-left':'3px', 'padding-top':'11px',"vertical-align":"top", "font-weight":"bold"});
         		$(".stateName").css({'padding-left':'3px', 'padding-top':'11px',"vertical-align":"top"});
         		$(".delNumber").css({'width':'30px','padding-left':'3px', 'padding-top':'6px',"vertical-align":"top"});
         		sym.$("tablesMc").css({'overflow-y':'auto'});
         }
         
         function changeDay(num,day,party) {//args: month, day and party
         		var candidates=[], dayName=[], dateName=[], stateName=[];//put your other arrays for the table here
         		var $events=monthEvents[num].find(party+'Date');
         
         		var i=0;
         		var tableTxt="<table id='daytable'>";
         
         		$events.each(function(){
         			var $event=$(this);
         			var daynam=$event.find("reporting").text();
         			dayName.push(daynam);
         			var datenam=$event.find("dayName").text();
         			dateName.push(datenam);
         			var statenam=$event.find("state").text();
         			stateName.push(statenam);
         			if($event.attr('number')==day){//only get the event that matches 
         				var $candidates=$event.find("candidate"); //then get each candidate
         				sym.getSymbol("tablesMc").getSymbol("topOverMc").$("date").html(dateName[day]);
         				sym.getSymbol("tablesMc").getSymbol("topOverMc").$("state").html(stateName[day]);
         				tableTxt+="<th id='"+"header1"+i+"' class='"+"header1'>"+dayName[day]+ " " +txtArr[2]+"</th>";
         				tableTxt+="<th id='"+"header2"+i+"' class='"+"header2'>"+txtArr[1]+"</th>";
         				tableTxt+="<th id='"+"header3"+i+"' class='"+"header3'>"+txtArr[0]+"</th>";
         				$candidates.each(function(){
         					var $candidate=$(this);
         					var nam=$candidate.find("name").text();
         					var vot=$candidate.find("vote").text();
         					var per=$candidate.find("percent").text();
         					var del=$candidate.find("dels").text();
         
         					tableTxt+="<tr id='"+"Date"+i+"' class='"+"Date'>";
         					tableTxt+="<td id='"+"Nam"+i+"' class='"+"Nam1'>"+nam+"</td>";
         					tableTxt+="<td id='"+"Del"+i+"' class='"+"Del1'>"+del+"</td>";
         					tableTxt+="<td id='"+"Vot"+i+"' class='"+"Vot1'>"+vot+ "<br>" +  "<id='"+"Per"+i+"' class='"+"Per1'>"+per+"</td>";
         					//tableTxt+="<td id='"+party+"Per"+i+"' class='"+party+"Per1'>"+per+"</td>";
         
         					tableTxt+="</tr>";
         					i++;
         				});
         				tableTxt+="</table>";
         			}
         		});
         		sym.getSymbol("tablesMc").$("table").append(tableTxt); //Then attach the buttons:
         		$("#daytable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse', 'width':'100%'});
         		$("#daytable tr:odd").css({"background-color":"#E9E9EA",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$("#daytable tr:even").css({"background-color":"#f8f8f9",'border-color':"rgb(255,255,255)","border-width":"2px 0","border-style":"solid","opacity":"0.95"});
         		$(".Date").css({'height':'47px'});
         		$(".header1").css({"background-color":"#fff","font-weight":400,"color":"#666",'text-align':"left",'font-size':"12px", 'padding-left':'3px',  'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top", 'width':'30%'});
         		$(".header2").css({"background-color":"#fff","font-weight":400,"color":"#666",'text-align':"center", 'font-size':"12px", 'padding-left':'3px',  'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top", 'width':'35%'});
         		$(".header3").css({"background-color":"#fff","font-weight":400,"color":"#666",'text-align':"right",'font-size':"12px", 'padding-right':'12px',  'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top", 'width':'25%'});
         		$(".Nam1").css({'width':'30%','padding-left':'6px', 'padding-top':'6px',"vertical-align":"top"});
         		$(".Vot1").css({'width':'20%','padding-right':'12px', 'padding-top':'6px',"vertical-align":"top", 'text-align':'right'});
         		$(".Per1").css({"color":"#666"});
         		$(".Del1").css({'width':'10%',"color":partyColour, "background-color":"rgba(255,255,255,0.3)",'font-size':"26px", 'padding-left':'3px', 'padding-top':'6px', "vertical-align":"top",'text-align':'center'});
         		$("#Date"+0).css({"font-weight":"bold"});
         
         		$("#monthTable tr:odd").css({"font-weight":400,"color":"#000","background-color":"#E9E9EA"});
         		$("#monthTable tr:even").css({"font-weight":400,"color":"#000","background-color":"#f8f8f9"});
         		//$("#date"+day).css({"font-weight":"bold", "color":"#fff", "background-color":"#666", 'height':'30px'});
         		//sym.getSymbol("tablesMc").getSymbol("topOverMc").$("date").html(dayName);
         }
         
         //********************************************************************************************************
         // TABLE CLICKS
         //********************************************************************************************************
         var showDate = function(showDate,day,party){ //to handle lexical scope
         var move = 43;
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		dateNo = showDate;
         		sym.getSymbol("tablesMc").$("table").empty();
         		sym.getSymbol("tablesMc").$("table").css({'height':'auto'});
         		sym.getSymbol("tablesMc").$("topOverMc").fadeIn(0);
         		sym.getSymbol("tablesMc").getSymbol("topOverMc").$("bg").css({"background-color":partyColour});
         		changeDay(dateNo,day,party);//load the relevant month
         		tabHeight = sym.getSymbol("tablesMc").$("table").height()+45;
         		$(".date").css({'height':'30px'});
         		$("#date"+day).css({"font-weight":"bold", "color":"#fff", "background-color":partyColour, 'height':tabHeight});
         		sym.$("tablesMc").stop().animate({scrollTop:day*move}, 200);
         		sym.getSymbol("tablesMc").$("table").stop().animate ({top:(day*move)+move}, 0);
         		sym.getSymbol("tablesMc").$("topOverMc").stop().animate ({top:(day*move)+ 0}, 0);
         	};
         };
         
         //********************************************************************************************************
         // RECTANGLE BUTTONS
         //********************************************************************************************************
         monthArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<5; a++){
         	monthArray.push(a);
         	sym.getSymbol("rectBtns").getSymbol("btn"+a).$("no").html(a+1);
         }
         
         function resetMonth(){
         	for (var a=0; a<monthArray.length; a++){
         		sym.getSymbol("rectBtns").getSymbol("btn" + a).$("txt").css({"color":'#666', 'font-weight':'normal'});
         	}
         	sym.getSymbol("rectBtns").getSymbol("btn" + clickMonth).$("txt").css({"color":partyColour, 'font-weight':'bold'});
         }
         resetMonth();
         
         // RECT CLICK
         var monthBtnClick = function(monthNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("tablesMc").$("monthTable").empty();
         		sym.getSymbol("tablesMc").$("table").empty();
         		sym.$("tablesMc").scrollTop();
         		sym.getSymbol("tablesMc").$("topOverMc").fadeOut(0);
         		clickMonth = monthNo;
         		resetMonth();
         		changeMonth(clickMonth,party);//load the relevant month
         	};
         };
         for (var b=0;b<monthArray.length;b++){
         	sym.getSymbol("rectBtns").$("btn"+b).on('touchstart click',monthBtnClick(b,party));
         	sym.getSymbol("rectBtns").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("rectBtns").getSymbol("btn"+clickMonth).$("txt").css({"color":partyColour});
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("rectBtns").stop().animate({left:stageWidth/2-160}, 0);
         	sym.$("menuBtnsMc").stop().animate({left:stageWidth/2-156}, 0);
         	sym.$("resultsBtnMc").stop().animate({left:stageWidth/2 - (sym.$("resultsBtnMc").width()/2)}, 0);
         
         	for (var i=0; i<repArray.length; i++){
         		var maxRep=parseFloat((repTally[0].replace(',','')).replace('.',''))>1237?parseFloat((repTally[0].replace(',','')).replace('.','')):1237;//PB
         		repArray[i].getSymbol("graphMc").$("graph").css({"width":parseFloat((repTally[i].replace(',','')).replace('.',''))/maxRep*100 + "%"});//PB
         		//repArray[i].getSymbol("graphMc").$("graph").css({"width":parseFloat((repTally[i].replace(',','')).replace('.',''))/1237*100 + "%"});
         		repArray[i].$("graphMc").stop().animate({width:stageWidth-188}, 0);
         		//sym.getSymbol("repTallyMc").$("endLine").stop().animate({right:11, height:(repArray.length*50)+14}, 0);
         		sym.getSymbol("repTallyMc").$("endLine").stop().animate({right:((maxRep-1237)/maxRep)*(stageWidth-158), height:(repArray.length*50)+14}, 0);
         		sym.getSymbol("repTallyMc").$("total").stop().animate({right:((maxRep-1237)/maxRep)*(stageWidth-158)+5, height:(repArray.length*50)+14}, 0);
         		if ((repTally[i].replace(',','')).replace('.','')>999){
         			repArray[i].getSymbol("graphMc").$("tally").stop().animate({left:repArray[i].getSymbol("graphMc").$("graph").width()-55}, 0);
         			repArray[i].getSymbol("graphMc").$("tally").css({"text-align":"right", "color":"#fff"});
         		}else{
         			repArray[i].getSymbol("graphMc").$("tally").stop().animate({left:repArray[i].getSymbol("graphMc").$("graph").width()+5}, 0);
         			repArray[i].getSymbol("graphMc").$("tally").css({"text-align":"left", "color":"#000"});
         		}
         	}
         	for (var i=0; i<demArray.length; i++){
         		var maxDem=parseFloat((demTally[0].replace(',','')).replace('.',''))>2383?parseFloat((demTally[0].replace(',','')).replace('.','')):2383;//PB
         		demArray[i].getSymbol("graphMc").$("graph").css({"width":parseFloat((demTally[i].replace(',','')).replace('.',''))/maxDem*100 + "%"});//PB
         		//demArray[i].getSymbol("graphMc").$("graph").css({"width":parseFloat((demTally[i].replace(',','')).replace('.',''))/2383*100 + "%"});
         		demArray[i].$("graphMc").stop().animate({width:stageWidth-188}, 0);
         		//sym.getSymbol("demTallyMc").$("endLine").stop().animate({right:11, height:(demArray.length*50)+14}, 0);
         		sym.getSymbol("demTallyMc").$("endLine").stop().animate({right:((maxDem-2383)/maxDem)*(stageWidth-158), height:(demArray.length*50)+14}, 0);
         		sym.getSymbol("demTallyMc").$("total").stop().animate({right:((maxDem-2383)/maxDem)*(stageWidth-158)+5, height:(demArray.length*50)+14}, 0);
         		if ((demTally[i].replace(',','')).replace('.','')>1600){
         			demArray[i].getSymbol("graphMc").$("tally").stop().animate({left:demArray[i].getSymbol("graphMc").$("graph").width()-55}, 0);
         			demArray[i].getSymbol("graphMc").$("tally").css({"text-align":"right", "color":"#fff"});
         		}else{
         			demArray[i].getSymbol("graphMc").$("tally").stop().animate({left:demArray[i].getSymbol("graphMc").$("graph").width()+5}, 0);
         			demArray[i].getSymbol("graphMc").$("tally").css({"text-align":"left", "color":"#000"});
         		}
         	}
         
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("convMc").$("logoRep").css({"opacity":"0"});
         		sym.getSymbol("convMc").$("logoDem").css({"opacity":"0"});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("convMc").$("logoRep").css({"opacity":"1"});
         		sym.getSymbol("convMc").$("logoDem").css({"opacity":"1"});
         	}
         	if(stageWidth<400){
         	$(".susp").fadeOut(0);
         	}else{
         	$(".susp").fadeIn(0);
         	}
         	setStyle();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("tablesMc").$("monthTable").empty();
         		sym.getSymbol("tablesMc").$("table").empty();
         		sym.$("tablesMc").scrollTop();
         		sym.getSymbol("tablesMc").$("topOverMc").fadeOut(0);
         		if (menuNo == 0){
         			party="rep";
         			changeMonth(clickMonth,"rep");//load the relevant month
         			partyColour  = "#da0000";
         			resetMonth();
         		}
         		if (menuNo == 1){
         			party="dem";
         			partyColour  = "#345cc1";
         			resetMonth();
         			changeMonth(clickMonth,"dem");//load the relevant month
         		}
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css({'background-color':partyColour});
         		sym.getSymbol("tablesMc").getSymbol("topOverMc").$("bg").css({'background-color':partyColour});
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         
         //********************************************************************************************************
         // OPEN/CLOSE TABLE BUTTON
         //********************************************************************************************************
         sym.$("resultsBtnMc").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	closeTableData();
         		if(sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideUp").is(":visible")) {
         			sym.$("menuBtnsMc").fadeIn(200);
         			sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideUp").fadeOut(0);
         			sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideUp").fadeOut(0);
         			sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideDown").fadeIn(0);
         			sym.$("rectBtns").stop().animate ({top:176}, 200, 'easeOutCubic');
         			sym.$("tablesMc").stop().animate ({top:205}, 200, 'easeOutCubic');
         			sym.$("resultsBtnMc").stop().animate ({top:133}, 200, 'easeOutCubic');
         			sym.$("repTallyMc").stop().animate ({opacity:0}, 200);
         			sym.$("demTallyMc").stop().animate ({opacity:0}, 200);
         			sym.$("convMc").stop().animate({opacity:0},200);
         		} else{
         			sym.$("menuBtnsMc").fadeOut(0);
         			sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideUp").fadeIn(0);
         			sym.getSymbol("resultsBtnMc").getSymbol("resultsBtn").$("slideDown").fadeOut(0);
         			sym.$("rectBtns").stop().animate ({top:577}, 200, 'easeOutCubic');
         			sym.$("tablesMc").stop().animate ({top:606}, 200, 'easeOutCubic');
         			sym.$("resultsBtnMc").stop().animate ({top:540}, 200, 'easeOutCubic');
         			sym.$("repTallyMc").stop().animate ({opacity:1}, 200);
         			sym.$("demTallyMc").stop().animate ({opacity:1}, 200);
         			sym.$("convMc").stop().animate({opacity:1},200);
         		}
         	});
         
         //********************************************************************************************************
         // CLOSE TABLE DATA
         //********************************************************************************************************
         sym.getSymbol("tablesMc").$("topOverMc").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         		closeTableData();
         	});
         function closeTableData(){
         	sym.getSymbol("tablesMc").$("topOverMc").fadeOut(0);
         	sym.getSymbol("tablesMc").$("table").empty(0);
         	$(".date").css({'height':'30px'});
         	$("#monthTable tr:odd").css({"font-weight":400,"color":"#000","background-color":"#E9E9EA"});
         	$("#monthTable tr:even").css({"font-weight":400,"color":"#000","background-color":"#f8f8f9"});
         }
         closeTableData();
         
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tablesMc");
   //Edge symbol end:'tablesMc'

   //=========================================================
   
   //Edge symbol: 'TopOverMc'
   (function(symbolName) {   
   
   })("TopOverMc");
   //Edge symbol end:'TopOverMc'

   //=========================================================
   
   //Edge symbol: 'resultsBtn'
   (function(symbolName) {   
   
   })("resultsBtn");
   //Edge symbol end:'resultsBtn'

   //=========================================================
   
   //Edge symbol: 'graphMc'
   (function(symbolName) {   
   
   })("graphMc");
   //Edge symbol end:'graphMc'

   //=========================================================
   
   //Edge symbol: 'repTallyMc'
   (function(symbolName) {   
   
   })("repTallyMc");
   //Edge symbol end:'repTallyMc'

   //=========================================================
   
   //Edge symbol: 'candidateMc'
   (function(symbolName) {   
   
   })("candidateMc");
   //Edge symbol end:'candidateMc'

   //=========================================================
   
   //Edge symbol: 'graphMc_1'
   (function(symbolName) {   
   
   })("graphMc_1");
   //Edge symbol end:'graphMc_1'

   //=========================================================
   
   //Edge symbol: 'convMc'
   (function(symbolName) {   
   
   })("convMc");
   //Edge symbol end:'convMc'

   //=========================================================
   
   //Edge symbol: 'resultsBtnMc'
   (function(symbolName) {   
   
   })("resultsBtnMc");
   //Edge symbol end:'resultsBtnMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34096");