/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob=0, mobOpen=false, clicked=0, btnNo=0, raceNo=0;
         	var gn=34046, gnYear=2016;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var raceIDs=[1419727,1419841,1419866,1419891,1419916,1419941,1419966,1419991,1420017,1420042,1420068,1420093,1420118,1420143,1420168,1420193,1420218,1420243];
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // ADD TRACKS
         //********************************************************************************************************
         trackArray = []; //the array that will hold references to your new symbols.
         
         for (var i = 0; i <18; i++){
          var mySymbolObject = sym.createChildSymbol("trackMc"+i, "tracksMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          trackArray.push(mySymbolObject);  //push it into the array
         }
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<17; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[17] = sym.getSymbol("statsMc").$("txt17").css({"pointer-events":"none"});
         
         	var txtArr=[],headArr=[],leftArr=[],rightArr=[],lapsArr=[],lapArr=[],topArr=[],distArr=[], widthArr=[], aveArr=[], race=[], raceCountry=[], raceVenue=[], raceVenueShort=[], raceMonth=[], raceDate=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gn+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<18; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			for (var t=0;t<trackArray.length; t++){
         				$(xml).find("race"+t).each(function(){
         					var $races = $(this);
         					raceMonth[t]=$races.find('month').text();
         					raceDate[t]=$races.find('date').text();
         					raceCountry[t]=$races.find('country').text();
         					raceVenue[t]=$races.find('venue').text();
         					leftArr[t]=$races.find('left').text();
         					rightArr[t]=$races.find('right').text();
         					lapsArr[t]=$races.find('laps').text();
         					lapArr[t]=$races.find('lap').text();
         					topArr[t]=$races.find('top').text();
         					distArr[t]=$races.find('dist').text();
         					widthArr[t]=$races.find('width').text();
         					aveArr[t]=$races.find('ave').text();
         
         					var t14=(distArr[t]>0)?txtArr[14]:"";
         					var t15=(aveArr[t]>0)?txtArr[15]:"";
         
         					trackArray[t].$("month").html(raceMonth[t]);
         					trackArray[t].$("date").html(raceDate[t]);
         					trackArray[t].$("country").html(raceCountry[t]).css({"font-size":"20px"});
         					trackArray[t].$("venue").html(raceVenue[t]);
         					trackArray[t].$("left").html(txtArr[4] +" <b>"+ leftArr[t]+"</b>");
         					trackArray[t].$("right").html(txtArr[5] +" <b>"+ rightArr[t]+"</b>");
         					trackArray[t].$("laps").html(txtArr[8] +" <b>"+ lapsArr[t] + "</b><br>" + txtArr[9] +" <b>"+ lapArr[t] + txtArr[14] + "</b><br>" + txtArr[10] +" <b>"+ topArr[t] + t15+"</b>");
         					trackArray[t].$("dist").html(txtArr[11] +" <b>"+ distArr[t] + t14 + "</b><br>" + txtArr[12] +" <b>"+ widthArr[t] + txtArr[16] + "</b><br>" + txtArr[13] +" <b>"+ aveArr[t] + t15+"</b>");
         					trackArray[t].$("txt6").html(txtArr[6]);
         					trackArray[t].$("txt7").html(txtArr[7]);
         					sym.getSymbol("statsMc").$("country").html(raceCountry[raceNo]).css({"font-size":"20px"});;
         					sym.getSymbol("statsMc").$("venue").html(raceVenue[raceNo]);
         					});
         			}
         
         //NEW SPORT TABLE
         for (var t=0;t<trackArray.length; t++){	//get details for each team
         $(xml).find("race"+t).each(function(){
         	var $event=$(this);
         	var racecountry=$event.find("country").text();
         	raceCountry.push(racecountry);
         	var racevenue=$event.find("venue").text();
         	raceVenue.push(racevenue);
         	var racevenueshort=$event.find("venueShort").text();
         	raceVenueShort.push(racevenueshort);
         	var racemonth=$event.find("month").text();
         	raceMonth.push(racemonth);
         	var racedate=$event.find("date").text();
         	raceDate.push(racedate);
         });
         }
         var tableTxt="<table id='sportTable'>";
         for (var i=0;i<18;i++){ //create a row for each sport
         	tableTxt+="<tr id='race"+i+"' class='race'>";
         	tableTxt+="<td id='no"+i+"' class='raceNo'>"+(i+1)+"</td>";
         	tableTxt+="<td id='country"+i+"' class='countryName'>"+raceCountry[i]+"</td>";
         	tableTxt+="<td id='venueShort"+i+"' class='venueShortName'>"+raceVenueShort[i]+"</td>";
         	tableTxt+="<td id='month"+i+"' class='monthName'>"+raceMonth[i]+" "+raceDate[i]+"</td>";
         	tableTxt+="</tr>";
         }
         
         sym.$("table").append(tableTxt); //Then attach the buttons:
         for (var i=0;i<raceCountry.length;i++){
         	$("#race"+i).on('click',showSport(i));
         }
         
         $("#sportTable").css({"font-family":"pragmatica-web, arial sans-serif","font-size":"14px",'border-collapse':'collapse', 'width':'100%'});
         $("#sportTable tr:odd").css({"background-color":"#E9E9EA",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $("#sportTable tr:even").css({"background-color":"##f8f8f9",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         $(".race").css({'height':'30px', 'cursor':'pointer'});
         $(".raceNo").css({'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top"});
         $(".countryName").css({'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top"});
         $(".venueShortName").css({'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top"});
         $(".monthName").css({'padding-left':'3px', 'padding-top':'6px',"vertical-align":"top"});
         $("#race"+0).css({"font-weight":"bold", "color":"#fff", "background-color":"#f27024"});
         },
         
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         	//********************************************************************************************************
         // TABLE CLICKS
         //********************************************************************************************************
         var showSport = function(showSport){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		raceNo = showSport;
         		raceClicked();
         			getResults(raceIDs[raceNo]);
         	};
         };
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("navBtnsMc").fadeIn(0);
         	sym.$("checkPlateBg").fadeOut(0);
         	sym.$("navBtnsMc").stop().animate({left:0, width:320}, 0);
         
         	if(stageWidth<801){
         		if (clicked == 0){
         			sym.$("tracksMc").stop().animate({opacity:1, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:330, top:351, height:231, width:stageWidth-330}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:231, width:stageWidth}, 0);
         			sym.$("mapMc").fadeIn(0);
         		}
         		if (clicked == 1){
         			sym.$("tracksMc").stop().animate({opacity:1, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:325, top:40, height:542, width:470}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:542, width:320}, 0);
         			sym.$("mapMc").fadeIn(0);
         		}
         		if (clicked == 2){
         			sym.$("tracksMc").stop().animate({opacity:0, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:330, top:351, height:231, width:stageWidth-330}, 0);
         			sym.$("statsMc").stop().animate({opacity:1, left:0, top:40, height:231, width:320}, 0);
         			sym.$("mapMc").fadeIn(0);
         		}
         	}
         	if(stageWidth<640){
         		if (clicked == 0){
         			sym.$("tracksMc").stop().animate({opacity:0, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:(stageWidth-480)/2, top:351, height:231, width:480}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:231, width:320}, 0);
         			sym.$("mapMc").fadeIn(0);
         			sym.$("navBtnsMc").fadeOut(0);
         			sym.$("checkPlateBg").fadeIn(0);
         			$(".venueShortName").show();
         			$(".monthName").show();
         		}
         		if (clicked == 1){
         			sym.$("tracksMc").stop().animate({opacity:1, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:325, top:40, height:542, width:(stageWidth-325)}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:542, width:320}, 0);
         			sym.$("mapMc").fadeOut(0);
         			$(".venueShortName").css({"display":"none"});
         			$(".monthName").css({"display":"none"});
         		}
         		if (clicked == 2){
         			sym.$("tracksMc").stop().animate({opacity:0, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:325, top:40, height:542, width:(stageWidth-325)}, 0);
         			sym.$("statsMc").stop().animate({opacity:1, left:0, top:40, height:542, width:320}, 0);
         			sym.$("mapMc").fadeOut(0);
         			$(".venueShortName").css({"display":"none"});
         			$(".monthName").css({"display":"none"});
         		}
         		mob = 1;
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		$(".venueShortName").show();
         		$(".monthName").show();
         		mob = 0;
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").stop().animate({left:44}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         		sym.$("mapMc").stop().animate({opacity:1}, 200);
         		if (clicked == 1){
         			resetmenu();
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(black);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[0]);
         			clicked = 0;
         		}
         	}
         	if (stageWidth<480){
         		if (clicked == 0){
         			sym.$("tracksMc").stop().animate({opacity:0, left:0}, 0);
         			sym.$("table").stop().animate({opacity:1, left:0, top:351, height:231, width:stageWidth}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:231, width:stageWidth}, 0);
         			sym.$("mapMc").fadeIn(0);
         			sym.$("navBtnsMc").fadeOut(0);
         			sym.$("checkPlateBg").fadeIn(0);
         		}
         		if (clicked == 1){
         			sym.$("tracksMc").stop().animate({opacity:1, left:(stageWidth-320)/2}, 0);
         			sym.$("table").stop().animate({opacity:0, left:325, top:40, height:542, width:(stageWidth-325)}, 0);
         			sym.$("statsMc").stop().animate({opacity:0, left:0, top:40, height:542, width:320}, 0);
         			sym.$("mapMc").fadeOut(0);
         			sym.$("navBtnsMc").stop().animate({left:(stageWidth-320)/2}, 0);
         			sym.$("checkPlateBg").fadeIn(0);
         		}
         		if (clicked == 2){
         			sym.$("tracksMc").stop().animate({opacity:0, left:0}, 0);
         			sym.$("table").stop().animate({opacity:0, left:325, top:40, height:542, width:(stageWidth-325)}, 0);
         			sym.$("statsMc").stop().animate({opacity:1, left:0, top:40, height:542, width:stageWidth}, 0);
         			sym.$("mapMc").fadeOut(0);
         			sym.$("navBtnsMc").stop().animate({width:stageWidth}, 0);
         		}
         	}else{
         
         	}
         	setStyle();
         	menuMob();
         	//raceClicked();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(black);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (clicked==2){
         			getResults(raceIDs[raceNo]);
         		}
         		initSize();
         	};
         
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(black);
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:180+(s*40)}, 200, 'easeOutCubic');
         				sym.getSymbol("menuBtnsMc").$("menuBtn0").stop().animate({top:0, left:220}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:80-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         	}
         }
         
         //********************************************************************************************************
         // NAV BUTTONS
         //********************************************************************************************************
         sym.getSymbol("navBtnsMc").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	raceNo++;
         	raceClicked();
         	getResults(raceIDs[raceNo]);
         
         });
         sym.getSymbol("navBtnsMc").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	raceNo--;
         	raceClicked();
         	getResults(raceIDs[raceNo]);
         });
         
         //********************************************************************************************************
         // ROUND MAP BUTTONS
         //********************************************************************************************************
         var overMapBtn  = {"background-color":"#f27024"};
         var outMapBtn = {"background-color":"black"};
         mapBtnArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	mapBtnArray.push(a);
         	sym.getSymbol("mapMc").getSymbol("mapBtn" + a).$("txt").text(a+1);
         	sym.getSymbol("mapMc").getSymbol("mapBtn" + a).$("txt").css({"color":"white"});
         }
         
         function resetMapBtn(){
         	for (var a=0; a<mapBtnArray.length; a++){
         		sym.getSymbol("mapMc").getSymbol("mapBtn" + a).$("bg").css(outMapBtn);
         		sym.getSymbol("mapMc").getSymbol("mapBtn" + a).$("txt").css({"font-weight":"normal"});
         	}
         }
         resetMapBtn();
         
         // BTN CLICK
         var mapBtnClick = function(mapBtnNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		raceNo = mapBtnNo;
         		raceClicked();
         		getResults(raceIDs[raceNo]);
         	};
         };
         
         for (var b=0;b<mapBtnArray.length;b++){
         	sym.getSymbol("mapMc").$("mapBtn"+b).on('touchstart click',mapBtnClick(b));
         	sym.getSymbol("mapMc").$("mapBtn"+b).css({'cursor':'pointer'});
         }
         
         //********************************************************************************************************
         // ACTION BUTTONS - raceClicked
         //********************************************************************************************************
         function raceClicked(){
         	resetMapBtn();
         	$("#sportTable tr:even").css({"font-weight":"normal","color":"#000", "background-color":"#f8f8f9",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         	$("#sportTable tr:odd").css({"font-weight":"normal","color":"#000", "background-color":"#E9E9EA",'border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         	$("#race"+raceNo).css({"font-weight":"bold", "color":"#fff", "background-color":"#f27024"});
         
         	sym.getSymbol("statsMc").$("country").html(raceCountry[raceNo]);
         	sym.getSymbol("statsMc").$("venue").html(raceVenue[raceNo]);
         	sym.getSymbol("mapMc").getSymbol("mapBtn" + raceNo).$("bg").css(overMapBtn);
         	sym.getSymbol("mapMc").getSymbol("mapBtn" + raceNo).$("txt").css({"font-weight":"bold"});
         	sym.getSymbol("navBtnsMc").$("navBtnNext").fadeIn(0);
         	sym.getSymbol("navBtnsMc").$("navBtnBack").fadeIn(0);
         	if (raceNo <1){
         		sym.getSymbol("navBtnsMc").$("navBtnBack").fadeOut(0);
         	}
         	if (raceNo >16){
         		sym.getSymbol("navBtnsMc").$("navBtnNext").fadeOut(0);
         	} 
         	for (var t=0;t<trackArray.length; t++){
         		trackArray[t].stop(0);
         		trackArray[t].getSymbolElement().stop().fadeOut(200);
         	}
         	trackArray[raceNo].getSymbolElement().stop().fadeIn(0);
         	trackArray[raceNo].play(0);
         	sym.$("table").stop().animate({scrollTop:raceNo*30}, 200, 'easeOutCubic');
         }
         raceClicked();
         //********************************************************************************************************
         //LIVE RESULTS
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         
         function getResults(raceID) { //GET LIVE timing data and final result
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "sport=motogp&q=result&gn="+gn+"&yr="+gnYear+"&phase="+raceID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			raceData = data;
         			//Ensure all drivers will fit in graph
         			var nDrivers = raceData.length;
         			var barHeightr;
         			var minTime;
         			sym.getSymbol("statsMc").$("graph").empty();					
         			if (raceData.length>20){
         				barHeightr = Math.round(466/raceData.length)-3;
         			}else{
         				barHeightr = 18;
         			}
         
         			if (raceData.length>0){
         				//calculate relative length of each bar
         				minTime = raceData[0].n_TimeRel;
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 0;							
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeRel!=null && raceData[n].n_TimeRel>mxm) {
         						mxm = raceData[n].n_TimeRel;
         					}
         				}
         
         				for (var i = 0; i < raceData.length; i++) {
         					//if (raceData[i].n_TimeRel!=null && raceData[i].n_TimeRel>mxm) {
         					//	mxm = raceData[i].n_TimeRel;
         					//}
         
         					//create timing tables and final results table
         					var resultsText ="<div class='resultrace'>";
         					resultsText +="<div id='resultdata"+i+"'>";
         					resultsText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					resultsText +="<td class='rank' id='resultorder"+i+"' width='20px'></td>";
         					resultsText +="<td class='driver' id='resultdriver"+i+"' width='130px'></td>";
         					resultsText +="<td class='timing' id='time"+i+"'></td>";
         					resultsText +="</tr></table>";
         					resultsText +="</div>";
         					resultsText +="</div>";					
         					sym.getSymbol("statsMc").$("graph").append(resultsText);					
         
         						if(raceData[i].n_RankSort==1&&raceData[i].n_TimeRel==0){
         							scale=100;
         							$('#time' + i).html("<span style='color:rgb(0,0,0)'>"+raceData[i].c_Result+"</span>");
         						}else if(raceData[i].n_TimeRel==null){						
         							scale=70;
         							if (raceData[i].c_Result==null){
         								$('#time' + i).text('X');
         							}else{
         								$('#time' + i).text('X');
         							}
         						}else{
         							scale = 100-(raceData[i].n_TimeRel*30/mxm);
         							$('#time' + i).text(raceData[i].c_Result);
         						}
         					$("#time" + i).css({'font-size':'11px','text-align':'right', 'padding-right':'5px'});
         						order = (raceData[i].c_Rank!=null)?raceData[i].c_Rank:'';
         						$('#resultorder' + i).html("<b>"+order+"</b>");
         						$('#resultdriver' + i).text(raceData[i].c_Person);
         						$(".resultrace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'99%', 'margin-bottom':'3px', 'background-color':'rgba(255,255,255,0.7)'});
         						$("#resultdata"+i).css({'height':barHeightr+'px','width':scale+'%','padding-left':'3px','background-color':'rgb(255,255,255)', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});//230,225,215
         						$(".rank").css({'color':'rgb(242,111,33)'});
         						$(".timing").css({'color':'grey'});
         				}
         			}
         		},
         		error: function(){
         		}		
         	});
         }
         
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("mapMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("table").css({'overflow-x':'hidden', 'overflow-y':'auto'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         initSize();
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'mapBtn'
   (function(symbolName) {   
   
   })("mapBtn");
   //Edge symbol end:'mapBtn'

   //=========================================================
   
   //Edge symbol: 'euroMapMc'
   (function(symbolName) {   
   
   })("euroMapMc");
   //Edge symbol end:'euroMapMc'

   //=========================================================
   
   //Edge symbol: 'worldMapMc'
   (function(symbolName) {   
   
   })("worldMapMc");
   //Edge symbol end:'worldMapMc'

   //=========================================================
   
   //Edge symbol: 'trackMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("trackMc0");
   //Edge symbol end:'trackMc0'

   //=========================================================
   
   //Edge symbol: 'iconCorner'
   (function(symbolName) {   
   
   })("iconCorner");
   //Edge symbol end:'iconCorner'

   //=========================================================
   
   //Edge symbol: 'iconCorner_1'
   (function(symbolName) {   
   
   })("iconSpeed");
   //Edge symbol end:'iconSpeed'

   //=========================================================
   
   //Edge symbol: 'iconCorner_1'
   (function(symbolName) {   
   
   })("iconTiming");
   //Edge symbol end:'iconTiming'

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'tracksMc'
   (function(symbolName) {   
   
   })("tracksMc");
   //Edge symbol end:'tracksMc'

   //=========================================================
   
   //Edge symbol: 'trackMc0_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
         //Edge binding end

      })("trackMc1");
   //Edge symbol end:'trackMc1'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
         //Edge binding end

      })("trackMc2");
   //Edge symbol end:'trackMc2'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
         //Edge binding end

      })("trackMc8");
   //Edge symbol end:'trackMc8'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
         //Edge binding end

      })("trackMc3");
   //Edge symbol end:'trackMc3'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
         //Edge binding end

      })("trackMc4");
   //Edge symbol end:'trackMc4'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc5");
   //Edge symbol end:'trackMc5'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc6");
   //Edge symbol end:'trackMc6'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc7");
   //Edge symbol end:'trackMc7'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc9");
   //Edge symbol end:'trackMc9'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_4'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc10");
   //Edge symbol end:'trackMc10'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc11");
   //Edge symbol end:'trackMc11'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_6'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc17");
   //Edge symbol end:'trackMc17'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc12");
   //Edge symbol end:'trackMc12'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc13");
   //Edge symbol end:'trackMc13'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_3'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc14");
   //Edge symbol end:'trackMc14'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_4'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc15");
   //Edge symbol end:'trackMc15'

   //=========================================================
   
   //Edge symbol: 'trackMcTEMP_5'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.play(0);

      });
            //Edge binding end

         })("trackMc16");
   //Edge symbol end:'trackMc16'

   //=========================================================
   
   //Edge symbol: 'statsMc'
   (function(symbolName) {   
   
   })("statsMc");
   //Edge symbol end:'statsMc'

   //=========================================================
   
   //Edge symbol: 'calBtn'
   (function(symbolName) {   
   
   })("calBtn");
   //Edge symbol end:'calBtn'

   //=========================================================
   
   //Edge symbol: 'calMc'
   (function(symbolName) {   
   
   })("calMc");
   //Edge symbol end:'calMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtnsMc'
   (function(symbolName) {   
   
   })("navBtnsMc");
   //Edge symbol end:'navBtnsMc'

   //=========================================================
   
   //Edge symbol: 'checkPlateMc'
   (function(symbolName) {   
   
   })("checkPlateMc");
   //Edge symbol end:'checkPlateMc'

   //=========================================================
   
   //Edge symbol: 'checkPlateBg'
   (function(symbolName) {   
   
   })("checkPlateBg");
   //Edge symbol end:'checkPlateBg'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews34046");