/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none", "line-height":"16px"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px", "pointer-events":"none"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"white",
         	"background-color":"black", "height":"auto", "padding":"6px", "pointer-events":"none"};
         
         	var grey  = {"background-color":"#b3b3b3"};
         	var darkgrey  = {"background-color":"#999999"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var scrollPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc")
         	var scrollPath2 = sym.getSymbol("scrollMc2").getSymbol("scrollableMc2")
         
         	var txt=[];
         	for (var i=0; i<23; i++){
         		txt[i] = scrollPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=23; i<31; i++){
         		txt[i] = sym.getSymbol("sidePanelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=31; i<35; i++){
         		txt[i] = sym.getSymbol("mapKeyMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[35] = scrollPath2.getSymbol("graphP0").$("txt35").css(blackTxtBox);
         	txt[36] = scrollPath2.getSymbol("graphP0").$("txt36").css(blackTxtBox);
         	txt[37] = scrollPath2.getSymbol("graphP1").$("txt37").css(blackTxtBox);
         	txt[38] = scrollPath2.getSymbol("graphP1").$("txt38").css(blackTxtBox);
         	txt[39] = scrollPath2.getSymbol("graphP2").$("txt39").css(blackTxtBox);
         	txt[40] = scrollPath2.getSymbol("graphP3").$("txt40").css(blackTxtBox);
         	txt[41] = scrollPath2.getSymbol("graphP3").$("txt41").css(blackTxtBox);
         	txt[42] = scrollPath2.getSymbol("graphP4").$("txt42").css(blackTxtBox);
         	txt[43] = scrollPath2.getSymbol("graphP4").$("txt43").css(blackTxtBox);
         	txt[44] = scrollPath2.getSymbol("graphP4").$("txt44").css(blackTxtBox);
         	txt[45] = scrollPath2.$("txt45").css({"pointer-events":"none"});
         	txt[46] = scrollPath2.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.getSymbol("deadKeyMc").$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.getSymbol("deadKeyMc").$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.getSymbol("deadKeyMc").$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33983.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<2; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         			//create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         
         			sym.getSymbol("sidePanelMc").$("tableMc").append(newTable);
         			$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         			$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         			$("#newtab1 tr:odd").css({"background-color":"#fff"});
         			$("#newtab1 tr:even").css({"background-color":"#666", "color":"#fff", "font-weight":"bold"});
         			$(".events td").css({'padding':'5px 5px 5px 8px'});
         
         			if (RTL == true) {
         				$(".events").css({"text-align":"right","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         			}
         
         			for (var i=0; i<6; i++){
         				scrollPath.$("txt"+i).css({"font-size":"16px"});
         			}
         			scrollPath.$("txt3").css({"font-size":"17px"});
         			scrollPath.$("txt22").css({"line-height":"21px"});
         			sym.getSymbol("sidePanelMc").$("txt23").css({"font-size":"17px"});
         			scrollPath2.$("txt45").css({"font-size":"12px", "line-height":"44px"});
         			sym.$("txt50").css({"font-size":"16px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("rectBtns").stop().animate({left:stageWidth/2-160}, 0);
         	sym.$("scrollMc2").stop().animate ({width:stageWidth}, 0);
         
         	if(stageWidth<800){
         		closePanel();
         		sym.$("scrollMc2").css({'overflow-y':'hidden', 'overflow-x':'visible', 'cursor':'ew-resize'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").animate({opacity:0}, 0);
         		sym.$("sidePanelMc").animate({left:stageWidth+5}, 0);
         		sym.$("standBtn").animate({left:stageWidth-50}, 0);
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("scrollMc").stop().animate ({left:(stageWidth/2)-290}, 0);
         		sym.$("mapKeyMc").stop().animate ({left:(stageWidth/2)-160}, 0);
         		sym.$("deadKeyMc").animate({top:440}, 0);
         		sym.$("scrollMc2").animate({top:25}, 0);
         		sym.$("txt50").animate({top:47}, 0);
         	}else{
         		sym.$("scrollMc2").css({'overflow-y':'hidden', 'overflow-x':'hidden', 'cursor':'ew-resize'});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").animate({opacity:1}, 0);
         		sym.$("sidePanelMc").animate({left:580}, 0);
         		sym.$("standBtn").animate({left:stageWidth}, 0);
         		sym.$("scrollMc").stop().animate ({left:0, width:580}, 0);
         		sym.$("mapKeyMc").stop().animate ({left:140}, 0);
         		sym.$("deadKeyMc").animate({top:442}, 0);
         		sym.$("scrollMc2").animate({top:40}, 0);
         		sym.$("txt50").animate({top:53}, 0);
         	}
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if(stageWidth<580){
         		sym.$("scrollMc").css({'overflow-y':'hidden', 'overflow-x':'visible', 'cursor':'ew-resize'});
         		sym.$("scrollMc").stop().animate ({left:0, width:stageWidth}, 0);
         		sym.$("mapKeyMc").stop().animate ({top:495}, 0);
         	}else{
         		sym.$("scrollMc").css({'overflow-y':'hidden', 'overflow-x':'hidden', 'cursor':'ew-resize'});
         		sym.$("mapKeyMc").stop().animate ({top:507}, 0);
         	}
         	if (stageWidth<480){
         		mob = 1;
         	}else{
         		mob = 0;
         	}
         	setStyle();
         	menuMob();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(darkgrey);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0) {
         			sym.$("standBtn").stop().fadeIn(0);
         			sym.$("mapKeyMc").stop().fadeIn(500);
         			sym.$("scrollMc").stop().fadeIn(500);
         			sym.$("mapBg").stop().fadeIn(500);
         			sym.$("sidePanelMc").stop().fadeIn(500);
         		} else {
         			sym.$("standBtn").stop().fadeOut(0);
         			sym.$("mapKeyMc").stop().fadeOut(500);
         			sym.$("scrollMc").stop().fadeOut(500);
         			sym.$("mapBg").stop().fadeOut(500);
         			sym.$("sidePanelMc").stop().fadeOut(500);
         			scrollPath2.play(0);
         			closePanel();
         			resetRect();
         			scrollPath2.getSymbol("yearBtn0").$("bg").css(black);
         			scrollPath2.$("graphP0").stop().fadeIn(500);
         			sym.$("scrollMc2").stop().animate({scrollLeft:0}, 500, 'easeOutCubic');
         	}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<2; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:220+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<2; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<2; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<2; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:40-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<2; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<2; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"90px"});
         	}
         }
         
         //********************************************************************************************************
         // CHANGE YEAR
         //********************************************************************************************************
         var clickRect = 0;
         function yearClicked(){
         	scrollPath2.getSymbol("yearBtn" + clickRect).$("bg").css(black);
         	scrollPath2.$("graphP" + clickRect).stop().fadeIn(500);
         	if (clickRect == 0){
         		sym.$("scrollMc2").stop().animate({scrollLeft:0}, 500, 'easeOutCubic');
         	}
         	if (clickRect == 1){
         		sym.$("scrollMc2").stop().animate({scrollLeft:70}, 500, 'easeOutCubic');
         	}
         	if (clickRect == 2){
         		sym.$("scrollMc2").stop().animate({scrollLeft:250}, 500, 'easeOutCubic');
         	}
         	if (clickRect == 3){
         		sym.$("scrollMc2").stop().animate({scrollLeft:390}, 500, 'easeOutCubic');
         	}
         	if (clickRect == 4){
         		sym.$("scrollMc2").stop().animate({scrollLeft:480}, 500, 'easeOutCubic');
         	}
         }	
         
         //********************************************************************************************************
         // RECTANGLE BUTTONS
         //********************************************************************************************************
         var clickRect = 0;
         rectArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<5; a++){
         	rectArray.push(a);
         	scrollPath2.getSymbol("yearBtn"+a).$("no").html(a+2011);
         }
         
         function resetRect(){
         		scrollPath2.getSymbol("yearBtn0").$("bg").css(grey);
         		scrollPath2.getSymbol("yearBtn1").$("bg").css(darkgrey);
         		scrollPath2.getSymbol("yearBtn2").$("bg").css(grey);
         		scrollPath2.getSymbol("yearBtn3").$("bg").css(darkgrey);
         		scrollPath2.getSymbol("yearBtn4").$("bg").css(grey);
         		for (var a=0; a<5; a++){
         			scrollPath2.$("graphP"+a).stop().fadeOut(0);
         		}
         }
         resetRect();
         
         // RECT CLICK
         var rectBtnClick = function(rectNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickRect = rectNo;
         		resetRect();
         		yearClicked();
         	};
         };
         for (var b=0;b<rectArray.length;b++){
         	scrollPath2.$("yearBtn"+b).on('touchstart click',rectBtnClick(b));
         	scrollPath2.$("yearBtn"+b).css({'cursor':'pointer'});
         }
         
         scrollPath2.getSymbol("yearBtn0").$("bg").css(black);
         scrollPath2.$("graphP0").stop().fadeIn(500);
         
         //********************************************************************************************************
         // PANEL BUTTONS
         //********************************************************************************************************
         sym.$("standBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.$("sidePanelMc").stop().animate ({left:stageWidth-220}, 180);
         		sym.$("standBtn").stop().animate ({left:stageWidth-270}, 200);
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         	}else{
         		closePanel();
         	}
         });
         function closePanel(){
         	var stageWidth=sym.$("Stage").width();
         	if(stageWidth<800){
         		sym.$("sidePanelMc").stop().animate ({left:stageWidth+5}, 200);
         		sym.$("standBtn").stop().animate ({left:stageWidth-50}, 180);
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		}
         }
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc2").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc2").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc2").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc2").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.getSymbol("sidePanelMc").$("tableMc").css({'overflow-x':'hidden'});
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'sidePanelMc'
   (function(symbolName) {   
   
   })("sidePanelMc");
   //Edge symbol end:'sidePanelMc'

   //=========================================================
   
   //Edge symbol: 'mapKeyMc'
   (function(symbolName) {   
   
   })("mapKeyMc");
   //Edge symbol end:'mapKeyMc'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc_1'
   (function(symbolName) {   
   
      })("scrollableMc2");
   //Edge symbol end:'scrollableMc2'

   //=========================================================
   
   //Edge symbol: 'scrollMc_1'
   (function(symbolName) {   
   
      })("scrollMc2");
   //Edge symbol end:'scrollMc2'

   //=========================================================
   
   //Edge symbol: 'graphP0'
   (function(symbolName) {   
   
   })("graphP0");
   //Edge symbol end:'graphP0'

   //=========================================================
   
   //Edge symbol: 'graphP0_1'
   (function(symbolName) {   
   
   })("graphP1");
   //Edge symbol end:'graphP1'

   //=========================================================
   
   //Edge symbol: 'graphP1_1'
   (function(symbolName) {   
   
   })("graphP2");
   //Edge symbol end:'graphP2'

   //=========================================================
   
   //Edge symbol: 'graphP2_1'
   (function(symbolName) {   
   
   })("graphP3");
   //Edge symbol end:'graphP3'

   //=========================================================
   
   //Edge symbol: 'graphP3_1'
   (function(symbolName) {   
   
   })("graphP4");
   //Edge symbol end:'graphP4'

   //=========================================================
   
   //Edge symbol: 'graph2'
   (function(symbolName) {   
   
   })("graph2");
   //Edge symbol end:'graph2'

   //=========================================================
   
   //Edge symbol: 'graph2_1'
   (function(symbolName) {   
   
   })("graph1");
   //Edge symbol end:'graph1'

   //=========================================================
   
   //Edge symbol: 'graph1_1'
   (function(symbolName) {   
   
   })("graph0");
   //Edge symbol end:'graph0'

   //=========================================================
   
   //Edge symbol: 'deadKeyMc'
   (function(symbolName) {   
   
   })("deadKeyMc");
   //Edge symbol end:'deadKeyMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33983");