/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txtPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("textLayer");
         	var txt=[];
         
         	for (var i=0; i<8; i++){
         		txt[i] = txtPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	txt[8] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt8").css({"pointer-events":"none"});
         
         	for (var i=9; i<17; i++){
         		txt[i] = txtPath.$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	txt[17] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt17").css(blackTxtBox);
         	txt[18] = sym.getSymbol("sidePanelMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("sidePanelMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("sidePanelMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = txtPath.$("txt21").css({"pointer-events":"none"});
         	txt[22] = txtPath.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         
         	for (var i=26; i<38; i++){
         		txt[i] = sym.getSymbol("sidePanelMc").getSymbol("panelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33941.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<38; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         
         		txtPath.$("txt3").animate({left:380 - txtPath.$("txt3").width()+0}, 0);
         		txtPath.$("txt10").animate({left:174 - txtPath.$("txt10").width()+0}, 0);
         		txtPath.$("txt12").animate({left:174 - txtPath.$("txt12").width()+0}, 0);
         		txtPath.$("txt6").css(blackTxtBox);
         
         		sym.getSymbol("sidePanelMc").getSymbol("panelMc").$("txt36").css({"line-height":"21px"});
         		sym.getSymbol("sidePanelMc").getSymbol("panelMc").$("txt37").css({"line-height":"21px"});
         
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         
         	if(stageWidth<800){
         		sym.$("sidePanelMc").animate({left:800}, 0);
         		sym.$("winnersBtn").animate({left:stageWidth-50}, 0);
         		sym.getSymbol("winnersBtn").$("plus").fadeIn(0);
         		sym.$("scrollMc").stop().animate ({left:(stageWidth/2)-300}, 0);
         		sym.$("controlsMc").animate({top:404, left:(stageWidth/2)-300}, 0);
         	}else{
         		sym.$("sidePanelMc").animate({left:600}, 0);
         		sym.$("winnersBtn").animate({left:stageWidth}, 0);
         		sym.$("scrollMc").stop().animate ({left:0}, 0);
         		sym.$("controlsMc").animate({top:404, left:10}, 0);
         	}
         	if(stageWidth<600){
         		sym.$("scrollMc").css({'overflow-y':'hidden', 'overflow-x':'visible', 'cursor':'ew-resize'});
         		sym.$("scrollMc").stop().animate ({left:0, width:stageWidth}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("controlsMc").animate({top:514, left:10}, 0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotRedProf").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profile").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profileBg").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profBg").fadeOut(0);
         		txtPath.$("txt21").fadeOut(0);
         		txtPath.$("txt22").fadeOut(0);
         	}else{
         		sym.$("scrollMc").css({'overflow-y':'hidden', 'overflow-x':'hidden', 'cursor':'default'});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotRedProf").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profile").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profileBg").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("profBg").fadeIn(0);
         		txtPath.$("txt21").fadeIn(0);
         		txtPath.$("txt22").fadeIn(0);
         	}
         
         	setStyle();
         }
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);
         	}
         
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         
         //********************************************************************************************************
         // PANEL BUTTONS
         //********************************************************************************************************
         sym.$("winnersBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("winnersBtn").$("plus").is(":visible") ) { 
         		sym.$("sidePanelMc").stop().animate ({left:stageWidth-200}, 180);
         		sym.$("winnersBtn").stop().animate ({left:stageWidth-250}, 200);
         		sym.getSymbol("winnersBtn").$("plus").fadeOut(0);
         	}else{
         		sym.$("sidePanelMc").stop().animate ({left:stageWidth+50}, 200);
         		sym.$("winnersBtn").stop().animate ({left:stageWidth-50}, 180);
         		sym.getSymbol("winnersBtn").$("plus").fadeIn(0);
         	}
         }); 
         
         //********************************************************************************************************
         // PLAY BUTTONS
         //********************************************************************************************************
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		startTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		sym.getSymbol("profileMc").getSymbol("profile").play();
         	}else{
         		stopTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		sym.getSymbol("profileMc").getSymbol("profile").stop();
         	}
         }); 
         
         //********************************************************************************************************
         // TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
          	var stageWidth=sym.$("Stage").width();
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	sym.getSymbol("controlsMc").$("km").text((pos / 355.5).toFixed(1) + " " + (txtArr[25]));
         	var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotRed").position();
         	sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500);
         	if (pos == 0 || pos == 15000) {
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		stopTimer();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.getSymbol("sidePanelMc").$("panelMc").css({'overflow-x':'hidden'});
         	if (RTL == false){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"left", "padding":"6px"});
         	}else{ // RTL = TRUE
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right", "padding-top":"6px"});
         	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'scrollMc2'
   (function(symbolName) {   
   
   })("scrollMc2");
   //Edge symbol end:'scrollMc2'

   //=========================================================
   
   //Edge symbol: 'finishMc'
   (function(symbolName) {   
   
   })("finishMc");
   //Edge symbol end:'finishMc'

   //=========================================================
   
   //Edge symbol: 'textLayer'
   (function(symbolName) {   
   
   })("textLayer");
   //Edge symbol end:'textLayer'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'mapLoco'
   (function(symbolName) {   
   
   })("mapLoco");
   //Edge symbol end:'mapLoco'

   //=========================================================
   
   //Edge symbol: 'sidePanelMc'
   (function(symbolName) {   
   
   })("sidePanelMc");
   //Edge symbol end:'sidePanelMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33941");